// components/services/storage/public/mojom/service_worker_database.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_SERVICE_WORKER_DATABASE_MOJOM_DATA_VIEW_H_
#define COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_SERVICE_WORKER_DATABASE_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "components/services/storage/public/mojom/service_worker_database.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "services/network/public/mojom/cross_origin_embedder_policy.mojom-shared.h"
#include "third_party/blink/public/mojom/script/script_type.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/policy_container.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/navigation_preload_state.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_ancestor_frame_type.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_database.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_fetch_handler_type.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_registration_options.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_router_rule.mojom-shared.h"
#include "third_party/blink/public/mojom/storage_key/storage_key.mojom-shared.h"
#include "third_party/blink/public/mojom/use_counter/metrics/web_feature.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace storage::mojom {
class ServiceWorkerRegistrationDataDataView;

class ServiceWorkerResourceRecordDataView;



}  // storage::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::storage::mojom::ServiceWorkerRegistrationDataDataView> {
  using Data = ::storage::mojom::internal::ServiceWorkerRegistrationData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::storage::mojom::ServiceWorkerResourceRecordDataView> {
  using Data = ::storage::mojom::internal::ServiceWorkerResourceRecord_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace storage::mojom {


enum class ServiceWorkerDatabaseStatus : int32_t {
  
  kOk = 0,
  
  kErrorNotFound = 1,
  
  kErrorIOError = 2,
  
  kErrorCorrupted = 3,
  
  kErrorFailed = 4,
  
  kErrorNotSupported = 5,
  
  kErrorDisabled = 6,
  
  kErrorStorageDisconnected = 7,
  kMinValue = 0,
  kMaxValue = 7,
};

 std::ostream& operator<<(std::ostream& os, ServiceWorkerDatabaseStatus value);
inline bool IsKnownEnumValue(ServiceWorkerDatabaseStatus value) {
  return internal::ServiceWorkerDatabaseStatus_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class ServiceWorkerRegistrationDataDataView {
 public:
  ServiceWorkerRegistrationDataDataView() = default;

  ServiceWorkerRegistrationDataDataView(
      internal::ServiceWorkerRegistrationData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int64_t registration_id() const {
    return data_->registration_id;
  }
  inline void GetScopeDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScope(UserType* output) {
    
    auto* pointer = data_->scope.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetKeyDataView(
      ::blink::mojom::StorageKeyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadKey(UserType* output) {
    
    auto* pointer = data_->key.Get();
    return mojo::internal::Deserialize<::blink::mojom::StorageKeyDataView>(
        pointer, output, message_);
  }
  inline void GetScriptDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScript(UserType* output) {
    
    auto* pointer = data_->script.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadScriptType(UserType* output) const {
    auto data_value = data_->script_type;
    return mojo::internal::Deserialize<::blink::mojom::ScriptType>(
        data_value, output);
  }
  ::blink::mojom::ScriptType script_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::ScriptType>(data_->script_type));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadUpdateViaCache(UserType* output) const {
    auto data_value = data_->update_via_cache;
    return mojo::internal::Deserialize<::blink::mojom::ServiceWorkerUpdateViaCache>(
        data_value, output);
  }
  ::blink::mojom::ServiceWorkerUpdateViaCache update_via_cache() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::ServiceWorkerUpdateViaCache>(data_->update_via_cache));
  }
  int64_t version_id() const {
    return data_->version_id;
  }
  bool is_active() const {
    return data_->is_active;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadFetchHandlerType(UserType* output) const {
    auto data_value = data_->fetch_handler_type;
    return mojo::internal::Deserialize<::blink::mojom::ServiceWorkerFetchHandlerType>(
        data_value, output);
  }
  ::blink::mojom::ServiceWorkerFetchHandlerType fetch_handler_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::ServiceWorkerFetchHandlerType>(data_->fetch_handler_type));
  }
  inline void GetLastUpdateCheckDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLastUpdateCheck(UserType* output) {
    
    auto* pointer = data_->last_update_check.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
  inline void GetScriptResponseTimeDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScriptResponseTime(UserType* output) {
    
    auto* pointer = data_->script_response_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
  inline void GetOriginTrialTokensDataView(
      mojo::MapDataView<mojo::StringDataView, mojo::ArrayDataView<mojo::StringDataView>>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOriginTrialTokens(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::MapDataView<mojo::StringDataView, mojo::ArrayDataView<mojo::StringDataView>>, UserType>(),
    "Attempting to read the optional `origin_trial_tokens` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadOriginTrialTokens` instead "
    "of `ReadOriginTrialTokens if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->origin_trial_tokens.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, mojo::ArrayDataView<mojo::StringDataView>>>(
        pointer, output, message_);
  }
  inline void GetNavigationPreloadStateDataView(
      ::blink::mojom::NavigationPreloadStateDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNavigationPreloadState(UserType* output) {
    
    auto* pointer = data_->navigation_preload_state.Get();
    return mojo::internal::Deserialize<::blink::mojom::NavigationPreloadStateDataView>(
        pointer, output, message_);
  }
  inline void GetUsedFeaturesDataView(
      mojo::ArrayDataView<::blink::mojom::WebFeature>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUsedFeatures(UserType* output) {
    
    auto* pointer = data_->used_features.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::WebFeature>>(
        pointer, output, message_);
  }
  int64_t resources_total_size_bytes() const {
    return data_->resources_total_size_bytes;
  }
  inline void GetPolicyContainerPoliciesDataView(
      ::blink::mojom::PolicyContainerPoliciesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPolicyContainerPolicies(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::PolicyContainerPoliciesDataView, UserType>(),
    "Attempting to read the optional `policy_container_policies` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPolicyContainerPolicies` instead "
    "of `ReadPolicyContainerPolicies if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->policy_container_policies.Get();
    return mojo::internal::Deserialize<::blink::mojom::PolicyContainerPoliciesDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadAncestorFrameType(UserType* output) const {
    auto data_value = data_->ancestor_frame_type;
    return mojo::internal::Deserialize<::blink::mojom::AncestorFrameType>(
        data_value, output);
  }
  ::blink::mojom::AncestorFrameType ancestor_frame_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::AncestorFrameType>(data_->ancestor_frame_type));
  }
  inline void GetRouterRulesDataView(
      ::blink::mojom::ServiceWorkerRouterRulesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRouterRules(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::ServiceWorkerRouterRulesDataView, UserType>(),
    "Attempting to read the optional `router_rules` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadRouterRules` instead "
    "of `ReadRouterRules if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->router_rules.Get();
    return mojo::internal::Deserialize<::blink::mojom::ServiceWorkerRouterRulesDataView>(
        pointer, output, message_);
  }
  bool has_hid_event_handlers() const {
    return data_->has_hid_event_handlers;
  }
  bool has_usb_event_handlers() const {
    return data_->has_usb_event_handlers;
  }
 private:
  internal::ServiceWorkerRegistrationData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ServiceWorkerResourceRecordDataView {
 public:
  ServiceWorkerResourceRecordDataView() = default;

  ServiceWorkerResourceRecordDataView(
      internal::ServiceWorkerResourceRecord_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int64_t resource_id() const {
    return data_->resource_id;
  }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  int64_t size_bytes() const {
    return data_->size_bytes;
  }
  inline void GetSha256ChecksumDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSha256Checksum(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `sha256_checksum` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSha256Checksum` instead "
    "of `ReadSha256Checksum if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->sha256_checksum.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::ServiceWorkerResourceRecord_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // storage::mojom

#endif  // COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_SERVICE_WORKER_DATABASE_MOJOM_DATA_VIEW_H_