// content/browser/process_internals/process_internals.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "content/browser/process_internals/process_internals.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "content/browser/process_internals/process_internals.mojom-params-data.h"
#include "content/browser/process_internals/process_internals.mojom-shared-message-ids.h"

#include "content/browser/process_internals/process_internals.mojom-import-headers.h"
#include "content/browser/process_internals/process_internals.mojom-test-utils.h"


namespace mojom {
ProcessCountInfo::ProcessCountInfo()
    : renderer_process_limit(),
      renderer_process_count_total(),
      live_renderer_processes_count_total(),
      renderer_process_count_for_limit() {}

ProcessCountInfo::ProcessCountInfo(
    uint64_t renderer_process_limit_in,
    uint64_t renderer_process_count_total_in,
    uint64_t live_renderer_processes_count_total_in,
    uint64_t renderer_process_count_for_limit_in)
    : renderer_process_limit(std::move(renderer_process_limit_in)),
      renderer_process_count_total(std::move(renderer_process_count_total_in)),
      live_renderer_processes_count_total(std::move(live_renderer_processes_count_total_in)),
      renderer_process_count_for_limit(std::move(renderer_process_count_for_limit_in)) {}

ProcessCountInfo::~ProcessCountInfo() = default;
size_t ProcessCountInfo::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->renderer_process_limit);
  seed = mojo::internal::Hash(seed, this->renderer_process_count_total);
  seed = mojo::internal::Hash(seed, this->live_renderer_processes_count_total);
  seed = mojo::internal::Hash(seed, this->renderer_process_count_for_limit);
  return seed;
}

void ProcessCountInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "renderer_process_limit"), this->renderer_process_limit,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "renderer_process_count_total"), this->renderer_process_count_total,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "live_renderer_processes_count_total"), this->live_renderer_processes_count_total,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "renderer_process_count_for_limit"), this->renderer_process_count_for_limit,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ProcessCountInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SiteInstanceInfo::SiteInstanceInfo()
    : id(),
      site_instance_group_id(),
      browsing_instance_id(),
      locked(),
      site_url(),
      process_lock_url(),
      requires_origin_keyed_process(),
      is_sandbox_for_iframes(),
      is_guest(),
      is_pdf(),
      are_javascript_optimizers_enabled(),
      storage_partition() {}

SiteInstanceInfo::SiteInstanceInfo(
    int32_t id_in,
    int32_t site_instance_group_id_in,
    int32_t browsing_instance_id_in,
    bool locked_in,
    const std::optional<::GURL>& site_url_in,
    const std::optional<::GURL>& process_lock_url_in,
    bool requires_origin_keyed_process_in,
    bool is_sandbox_for_iframes_in,
    bool is_guest_in,
    bool is_pdf_in,
    bool are_javascript_optimizers_enabled_in,
    const std::optional<std::string>& storage_partition_in)
    : id(std::move(id_in)),
      site_instance_group_id(std::move(site_instance_group_id_in)),
      browsing_instance_id(std::move(browsing_instance_id_in)),
      locked(std::move(locked_in)),
      site_url(std::move(site_url_in)),
      process_lock_url(std::move(process_lock_url_in)),
      requires_origin_keyed_process(std::move(requires_origin_keyed_process_in)),
      is_sandbox_for_iframes(std::move(is_sandbox_for_iframes_in)),
      is_guest(std::move(is_guest_in)),
      is_pdf(std::move(is_pdf_in)),
      are_javascript_optimizers_enabled(std::move(are_javascript_optimizers_enabled_in)),
      storage_partition(std::move(storage_partition_in)) {}

SiteInstanceInfo::~SiteInstanceInfo() = default;

void SiteInstanceInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "site_instance_group_id"), this->site_instance_group_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "browsing_instance_id"), this->browsing_instance_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "locked"), this->locked,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "site_url"), this->site_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::GURL>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "process_lock_url"), this->process_lock_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::GURL>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "requires_origin_keyed_process"), this->requires_origin_keyed_process,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_sandbox_for_iframes"), this->is_sandbox_for_iframes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_guest"), this->is_guest,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_pdf"), this->is_pdf,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "are_javascript_optimizers_enabled"), this->are_javascript_optimizers_enabled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "storage_partition"), this->storage_partition,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SiteInstanceInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
FrameInfo::FrameInfo()
    : routing_id(),
      agent_scheduling_group_id(),
      process_id(),
      site_instance(),
      last_committed_url(),
      subframes(),
      type() {}

FrameInfo::FrameInfo(
    int32_t routing_id_in,
    int32_t agent_scheduling_group_id_in,
    int32_t process_id_in,
    SiteInstanceInfoPtr site_instance_in,
    const std::optional<::GURL>& last_committed_url_in,
    std::vector<FrameInfoPtr> subframes_in,
    FrameInfo::Type type_in)
    : routing_id(std::move(routing_id_in)),
      agent_scheduling_group_id(std::move(agent_scheduling_group_id_in)),
      process_id(std::move(process_id_in)),
      site_instance(std::move(site_instance_in)),
      last_committed_url(std::move(last_committed_url_in)),
      subframes(std::move(subframes_in)),
      type(std::move(type_in)) {}

FrameInfo::~FrameInfo() = default;

void FrameInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "routing_id"), this->routing_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "agent_scheduling_group_id"), this->agent_scheduling_group_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "process_id"), this->process_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "site_instance"), this->site_instance,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type SiteInstanceInfoPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "last_committed_url"), this->last_committed_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::GURL>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "subframes"), this->subframes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<FrameInfoPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type FrameInfo::Type>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FrameInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
WebContentsInfo::WebContentsInfo()
    : title(),
      root_frame(),
      bfcached_root_frames(),
      prerender_root_frames() {}

WebContentsInfo::WebContentsInfo(
    const std::string& title_in,
    FrameInfoPtr root_frame_in,
    std::vector<FrameInfoPtr> bfcached_root_frames_in,
    std::vector<FrameInfoPtr> prerender_root_frames_in)
    : title(std::move(title_in)),
      root_frame(std::move(root_frame_in)),
      bfcached_root_frames(std::move(bfcached_root_frames_in)),
      prerender_root_frames(std::move(prerender_root_frames_in)) {}

WebContentsInfo::~WebContentsInfo() = default;

void WebContentsInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "title"), this->title,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "root_frame"), this->root_frame,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type FrameInfoPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bfcached_root_frames"), this->bfcached_root_frames,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<FrameInfoPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "prerender_root_frames"), this->prerender_root_frames,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<FrameInfoPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool WebContentsInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
IsolatedOriginInfo::IsolatedOriginInfo()
    : origin(),
      source() {}

IsolatedOriginInfo::IsolatedOriginInfo(
    const std::string& origin_in,
    const std::string& source_in)
    : origin(std::move(origin_in)),
      source(std::move(source_in)) {}

IsolatedOriginInfo::~IsolatedOriginInfo() = default;
size_t IsolatedOriginInfo::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->origin);
  seed = mojo::internal::Hash(seed, this->source);
  return seed;
}

void IsolatedOriginInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "origin"), this->origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "source"), this->source,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool IsolatedOriginInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

ProcessInternalsHandler::IPCStableHashFunction ProcessInternalsHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ProcessInternalsHandler>(message.name())) {
    case messages::ProcessInternalsHandler::kGetProcessCountInfo: {
      return &ProcessInternalsHandler::GetProcessCountInfo_Sym::IPCStableHash;
    }
    case messages::ProcessInternalsHandler::kGetIsolationMode: {
      return &ProcessInternalsHandler::GetIsolationMode_Sym::IPCStableHash;
    }
    case messages::ProcessInternalsHandler::kGetProcessPerSiteMode: {
      return &ProcessInternalsHandler::GetProcessPerSiteMode_Sym::IPCStableHash;
    }
    case messages::ProcessInternalsHandler::kGetUserTriggeredIsolatedOrigins: {
      return &ProcessInternalsHandler::GetUserTriggeredIsolatedOrigins_Sym::IPCStableHash;
    }
    case messages::ProcessInternalsHandler::kGetWebTriggeredIsolatedOrigins: {
      return &ProcessInternalsHandler::GetWebTriggeredIsolatedOrigins_Sym::IPCStableHash;
    }
    case messages::ProcessInternalsHandler::kGetGloballyIsolatedOrigins: {
      return &ProcessInternalsHandler::GetGloballyIsolatedOrigins_Sym::IPCStableHash;
    }
    case messages::ProcessInternalsHandler::kGetAllWebContentsInfo: {
      return &ProcessInternalsHandler::GetAllWebContentsInfo_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ProcessInternalsHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ProcessInternalsHandler>(message.name())) {
      case messages::ProcessInternalsHandler::kGetProcessCountInfo:
            return "Receive mojom::ProcessInternalsHandler::GetProcessCountInfo";
      case messages::ProcessInternalsHandler::kGetIsolationMode:
            return "Receive mojom::ProcessInternalsHandler::GetIsolationMode";
      case messages::ProcessInternalsHandler::kGetProcessPerSiteMode:
            return "Receive mojom::ProcessInternalsHandler::GetProcessPerSiteMode";
      case messages::ProcessInternalsHandler::kGetUserTriggeredIsolatedOrigins:
            return "Receive mojom::ProcessInternalsHandler::GetUserTriggeredIsolatedOrigins";
      case messages::ProcessInternalsHandler::kGetWebTriggeredIsolatedOrigins:
            return "Receive mojom::ProcessInternalsHandler::GetWebTriggeredIsolatedOrigins";
      case messages::ProcessInternalsHandler::kGetGloballyIsolatedOrigins:
            return "Receive mojom::ProcessInternalsHandler::GetGloballyIsolatedOrigins";
      case messages::ProcessInternalsHandler::kGetAllWebContentsInfo:
            return "Receive mojom::ProcessInternalsHandler::GetAllWebContentsInfo";
    }
  } else {
    switch (static_cast<messages::ProcessInternalsHandler>(message.name())) {
      case messages::ProcessInternalsHandler::kGetProcessCountInfo:
            return "Receive reply mojom::ProcessInternalsHandler::GetProcessCountInfo";
      case messages::ProcessInternalsHandler::kGetIsolationMode:
            return "Receive reply mojom::ProcessInternalsHandler::GetIsolationMode";
      case messages::ProcessInternalsHandler::kGetProcessPerSiteMode:
            return "Receive reply mojom::ProcessInternalsHandler::GetProcessPerSiteMode";
      case messages::ProcessInternalsHandler::kGetUserTriggeredIsolatedOrigins:
            return "Receive reply mojom::ProcessInternalsHandler::GetUserTriggeredIsolatedOrigins";
      case messages::ProcessInternalsHandler::kGetWebTriggeredIsolatedOrigins:
            return "Receive reply mojom::ProcessInternalsHandler::GetWebTriggeredIsolatedOrigins";
      case messages::ProcessInternalsHandler::kGetGloballyIsolatedOrigins:
            return "Receive reply mojom::ProcessInternalsHandler::GetGloballyIsolatedOrigins";
      case messages::ProcessInternalsHandler::kGetAllWebContentsInfo:
            return "Receive reply mojom::ProcessInternalsHandler::GetAllWebContentsInfo";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ProcessInternalsHandler::GetProcessCountInfo_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xecbf1198;  // IPCStableHash for mojom::ProcessInternalsHandler::GetProcessCountInfo
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ProcessInternalsHandler::GetIsolationMode_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb3b3b6df;  // IPCStableHash for mojom::ProcessInternalsHandler::GetIsolationMode
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ProcessInternalsHandler::GetProcessPerSiteMode_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xec76eaac;  // IPCStableHash for mojom::ProcessInternalsHandler::GetProcessPerSiteMode
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ProcessInternalsHandler::GetUserTriggeredIsolatedOrigins_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x403aceff;  // IPCStableHash for mojom::ProcessInternalsHandler::GetUserTriggeredIsolatedOrigins
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ProcessInternalsHandler::GetWebTriggeredIsolatedOrigins_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x30a87d85;  // IPCStableHash for mojom::ProcessInternalsHandler::GetWebTriggeredIsolatedOrigins
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ProcessInternalsHandler::GetGloballyIsolatedOrigins_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb7c612a8;  // IPCStableHash for mojom::ProcessInternalsHandler::GetGloballyIsolatedOrigins
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ProcessInternalsHandler::GetAllWebContentsInfo_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x258571a3;  // IPCStableHash for mojom::ProcessInternalsHandler::GetAllWebContentsInfo
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class ProcessInternalsHandler_GetProcessCountInfo_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ProcessInternalsHandler_GetProcessCountInfo_ForwardToCallback(
      ProcessInternalsHandler::GetProcessCountInfoCallback callback
      ) : callback_(std::move(callback)) {
  }

  ProcessInternalsHandler_GetProcessCountInfo_ForwardToCallback(const ProcessInternalsHandler_GetProcessCountInfo_ForwardToCallback&) = delete;
  ProcessInternalsHandler_GetProcessCountInfo_ForwardToCallback& operator=(const ProcessInternalsHandler_GetProcessCountInfo_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ProcessInternalsHandler::GetProcessCountInfoCallback callback_;
};

class ProcessInternalsHandler_GetIsolationMode_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ProcessInternalsHandler_GetIsolationMode_ForwardToCallback(
      ProcessInternalsHandler::GetIsolationModeCallback callback
      ) : callback_(std::move(callback)) {
  }

  ProcessInternalsHandler_GetIsolationMode_ForwardToCallback(const ProcessInternalsHandler_GetIsolationMode_ForwardToCallback&) = delete;
  ProcessInternalsHandler_GetIsolationMode_ForwardToCallback& operator=(const ProcessInternalsHandler_GetIsolationMode_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ProcessInternalsHandler::GetIsolationModeCallback callback_;
};

class ProcessInternalsHandler_GetProcessPerSiteMode_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ProcessInternalsHandler_GetProcessPerSiteMode_ForwardToCallback(
      ProcessInternalsHandler::GetProcessPerSiteModeCallback callback
      ) : callback_(std::move(callback)) {
  }

  ProcessInternalsHandler_GetProcessPerSiteMode_ForwardToCallback(const ProcessInternalsHandler_GetProcessPerSiteMode_ForwardToCallback&) = delete;
  ProcessInternalsHandler_GetProcessPerSiteMode_ForwardToCallback& operator=(const ProcessInternalsHandler_GetProcessPerSiteMode_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ProcessInternalsHandler::GetProcessPerSiteModeCallback callback_;
};

class ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_ForwardToCallback(
      ProcessInternalsHandler::GetUserTriggeredIsolatedOriginsCallback callback
      ) : callback_(std::move(callback)) {
  }

  ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_ForwardToCallback(const ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_ForwardToCallback&) = delete;
  ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_ForwardToCallback& operator=(const ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ProcessInternalsHandler::GetUserTriggeredIsolatedOriginsCallback callback_;
};

class ProcessInternalsHandler_GetWebTriggeredIsolatedOrigins_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ProcessInternalsHandler_GetWebTriggeredIsolatedOrigins_ForwardToCallback(
      ProcessInternalsHandler::GetWebTriggeredIsolatedOriginsCallback callback
      ) : callback_(std::move(callback)) {
  }

  ProcessInternalsHandler_GetWebTriggeredIsolatedOrigins_ForwardToCallback(const ProcessInternalsHandler_GetWebTriggeredIsolatedOrigins_ForwardToCallback&) = delete;
  ProcessInternalsHandler_GetWebTriggeredIsolatedOrigins_ForwardToCallback& operator=(const ProcessInternalsHandler_GetWebTriggeredIsolatedOrigins_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ProcessInternalsHandler::GetWebTriggeredIsolatedOriginsCallback callback_;
};

class ProcessInternalsHandler_GetGloballyIsolatedOrigins_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ProcessInternalsHandler_GetGloballyIsolatedOrigins_ForwardToCallback(
      ProcessInternalsHandler::GetGloballyIsolatedOriginsCallback callback
      ) : callback_(std::move(callback)) {
  }

  ProcessInternalsHandler_GetGloballyIsolatedOrigins_ForwardToCallback(const ProcessInternalsHandler_GetGloballyIsolatedOrigins_ForwardToCallback&) = delete;
  ProcessInternalsHandler_GetGloballyIsolatedOrigins_ForwardToCallback& operator=(const ProcessInternalsHandler_GetGloballyIsolatedOrigins_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ProcessInternalsHandler::GetGloballyIsolatedOriginsCallback callback_;
};

class ProcessInternalsHandler_GetAllWebContentsInfo_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ProcessInternalsHandler_GetAllWebContentsInfo_ForwardToCallback(
      ProcessInternalsHandler::GetAllWebContentsInfoCallback callback
      ) : callback_(std::move(callback)) {
  }

  ProcessInternalsHandler_GetAllWebContentsInfo_ForwardToCallback(const ProcessInternalsHandler_GetAllWebContentsInfo_ForwardToCallback&) = delete;
  ProcessInternalsHandler_GetAllWebContentsInfo_ForwardToCallback& operator=(const ProcessInternalsHandler_GetAllWebContentsInfo_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ProcessInternalsHandler::GetAllWebContentsInfoCallback callback_;
};

ProcessInternalsHandlerProxy::ProcessInternalsHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ProcessInternalsHandlerProxy::GetProcessCountInfo(
    GetProcessCountInfoCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send mojom::ProcessInternalsHandler::GetProcessCountInfo");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProcessInternalsHandler::kGetProcessCountInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mojom::internal::ProcessInternalsHandler_GetProcessCountInfo_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProcessInternalsHandler::Name_);
  message.set_method_name("GetProcessCountInfo");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ProcessInternalsHandler_GetProcessCountInfo_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ProcessInternalsHandlerProxy::GetIsolationMode(
    GetIsolationModeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send mojom::ProcessInternalsHandler::GetIsolationMode");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProcessInternalsHandler::kGetIsolationMode), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mojom::internal::ProcessInternalsHandler_GetIsolationMode_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProcessInternalsHandler::Name_);
  message.set_method_name("GetIsolationMode");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ProcessInternalsHandler_GetIsolationMode_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ProcessInternalsHandlerProxy::GetProcessPerSiteMode(
    GetProcessPerSiteModeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send mojom::ProcessInternalsHandler::GetProcessPerSiteMode");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProcessInternalsHandler::kGetProcessPerSiteMode), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mojom::internal::ProcessInternalsHandler_GetProcessPerSiteMode_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProcessInternalsHandler::Name_);
  message.set_method_name("GetProcessPerSiteMode");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ProcessInternalsHandler_GetProcessPerSiteMode_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ProcessInternalsHandlerProxy::GetUserTriggeredIsolatedOrigins(
    GetUserTriggeredIsolatedOriginsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send mojom::ProcessInternalsHandler::GetUserTriggeredIsolatedOrigins");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProcessInternalsHandler::kGetUserTriggeredIsolatedOrigins), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mojom::internal::ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProcessInternalsHandler::Name_);
  message.set_method_name("GetUserTriggeredIsolatedOrigins");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ProcessInternalsHandlerProxy::GetWebTriggeredIsolatedOrigins(
    GetWebTriggeredIsolatedOriginsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send mojom::ProcessInternalsHandler::GetWebTriggeredIsolatedOrigins");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProcessInternalsHandler::kGetWebTriggeredIsolatedOrigins), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mojom::internal::ProcessInternalsHandler_GetWebTriggeredIsolatedOrigins_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProcessInternalsHandler::Name_);
  message.set_method_name("GetWebTriggeredIsolatedOrigins");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ProcessInternalsHandler_GetWebTriggeredIsolatedOrigins_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ProcessInternalsHandlerProxy::GetGloballyIsolatedOrigins(
    GetGloballyIsolatedOriginsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send mojom::ProcessInternalsHandler::GetGloballyIsolatedOrigins");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProcessInternalsHandler::kGetGloballyIsolatedOrigins), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mojom::internal::ProcessInternalsHandler_GetGloballyIsolatedOrigins_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProcessInternalsHandler::Name_);
  message.set_method_name("GetGloballyIsolatedOrigins");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ProcessInternalsHandler_GetGloballyIsolatedOrigins_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ProcessInternalsHandlerProxy::GetAllWebContentsInfo(
    GetAllWebContentsInfoCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send mojom::ProcessInternalsHandler::GetAllWebContentsInfo");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProcessInternalsHandler::kGetAllWebContentsInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mojom::internal::ProcessInternalsHandler_GetAllWebContentsInfo_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProcessInternalsHandler::Name_);
  message.set_method_name("GetAllWebContentsInfo");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ProcessInternalsHandler_GetAllWebContentsInfo_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class ProcessInternalsHandler_GetProcessCountInfo_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ProcessInternalsHandler::GetProcessCountInfoCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ProcessInternalsHandler_GetProcessCountInfo_ProxyToResponder> proxy(
        new ProcessInternalsHandler_GetProcessCountInfo_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ProcessInternalsHandler_GetProcessCountInfo_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ProcessInternalsHandler_GetProcessCountInfo_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ProcessInternalsHandler_GetProcessCountInfo_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ProcessInternalsHandler::GetProcessCountInfoCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ProcessCountInfoPtr in_info);
};

bool ProcessInternalsHandler_GetProcessCountInfo_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ProcessInternalsHandler_GetProcessCountInfo_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ProcessInternalsHandler_GetProcessCountInfo_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ProcessInternalsHandler.0
  bool success = true;
  ProcessCountInfoPtr p_info{};
  ProcessInternalsHandler_GetProcessCountInfo_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadInfo(&p_info))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ProcessInternalsHandler::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_info));
  }
  return true;
}

void ProcessInternalsHandler_GetProcessCountInfo_ProxyToResponder::Run(
    ProcessCountInfoPtr in_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply mojom::ProcessInternalsHandler::GetProcessCountInfo", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("info"), in_info,
                        "<value of type ProcessCountInfoPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProcessInternalsHandler::kGetProcessCountInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mojom::internal::ProcessInternalsHandler_GetProcessCountInfo_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->info)::BaseType> info_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojom::ProcessCountInfoDataView>(
    in_info,
    info_fragment);

  params->info.Set(
      info_fragment.is_null() ? nullptr : info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null info in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProcessInternalsHandler::Name_);
  message.set_method_name("GetProcessCountInfo");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ProcessInternalsHandler_GetIsolationMode_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ProcessInternalsHandler::GetIsolationModeCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ProcessInternalsHandler_GetIsolationMode_ProxyToResponder> proxy(
        new ProcessInternalsHandler_GetIsolationMode_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ProcessInternalsHandler_GetIsolationMode_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ProcessInternalsHandler_GetIsolationMode_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ProcessInternalsHandler_GetIsolationMode_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ProcessInternalsHandler::GetIsolationModeCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::string& in_mode);
};

bool ProcessInternalsHandler_GetIsolationMode_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ProcessInternalsHandler_GetIsolationMode_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ProcessInternalsHandler_GetIsolationMode_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ProcessInternalsHandler.1
  bool success = true;
  std::string p_mode{};
  ProcessInternalsHandler_GetIsolationMode_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadMode(&p_mode))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ProcessInternalsHandler::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_mode));
  }
  return true;
}

void ProcessInternalsHandler_GetIsolationMode_ProxyToResponder::Run(
    const std::string& in_mode) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply mojom::ProcessInternalsHandler::GetIsolationMode", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("mode"), in_mode,
                        "<value of type const std::string&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProcessInternalsHandler::kGetIsolationMode), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mojom::internal::ProcessInternalsHandler_GetIsolationMode_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->mode)::BaseType> mode_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_mode,
    mode_fragment);

  params->mode.Set(
      mode_fragment.is_null() ? nullptr : mode_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->mode.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null mode in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProcessInternalsHandler::Name_);
  message.set_method_name("GetIsolationMode");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ProcessInternalsHandler_GetProcessPerSiteMode_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ProcessInternalsHandler::GetProcessPerSiteModeCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ProcessInternalsHandler_GetProcessPerSiteMode_ProxyToResponder> proxy(
        new ProcessInternalsHandler_GetProcessPerSiteMode_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ProcessInternalsHandler_GetProcessPerSiteMode_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ProcessInternalsHandler_GetProcessPerSiteMode_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ProcessInternalsHandler_GetProcessPerSiteMode_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ProcessInternalsHandler::GetProcessPerSiteModeCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::string& in_mode);
};

bool ProcessInternalsHandler_GetProcessPerSiteMode_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ProcessInternalsHandler_GetProcessPerSiteMode_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ProcessInternalsHandler_GetProcessPerSiteMode_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ProcessInternalsHandler.2
  bool success = true;
  std::string p_mode{};
  ProcessInternalsHandler_GetProcessPerSiteMode_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadMode(&p_mode))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ProcessInternalsHandler::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_mode));
  }
  return true;
}

void ProcessInternalsHandler_GetProcessPerSiteMode_ProxyToResponder::Run(
    const std::string& in_mode) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply mojom::ProcessInternalsHandler::GetProcessPerSiteMode", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("mode"), in_mode,
                        "<value of type const std::string&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProcessInternalsHandler::kGetProcessPerSiteMode), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mojom::internal::ProcessInternalsHandler_GetProcessPerSiteMode_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->mode)::BaseType> mode_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_mode,
    mode_fragment);

  params->mode.Set(
      mode_fragment.is_null() ? nullptr : mode_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->mode.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null mode in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProcessInternalsHandler::Name_);
  message.set_method_name("GetProcessPerSiteMode");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ProcessInternalsHandler::GetUserTriggeredIsolatedOriginsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_ProxyToResponder> proxy(
        new ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ProcessInternalsHandler::GetUserTriggeredIsolatedOriginsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::vector<std::string>& in_isolated_origins);
};

bool ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ProcessInternalsHandler.3
  bool success = true;
  std::vector<std::string> p_isolated_origins{};
  ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadIsolatedOrigins(&p_isolated_origins))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ProcessInternalsHandler::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_isolated_origins));
  }
  return true;
}

void ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_ProxyToResponder::Run(
    const std::vector<std::string>& in_isolated_origins) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply mojom::ProcessInternalsHandler::GetUserTriggeredIsolatedOrigins", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("isolated_origins"), in_isolated_origins,
                        "<value of type const std::vector<std::string>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProcessInternalsHandler::kGetUserTriggeredIsolatedOrigins), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mojom::internal::ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->isolated_origins)::BaseType>
      isolated_origins_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& isolated_origins_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
    in_isolated_origins,
    isolated_origins_fragment,
    &isolated_origins_validate_params);

  params->isolated_origins.Set(
      isolated_origins_fragment.is_null() ? nullptr : isolated_origins_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->isolated_origins.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null isolated_origins in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProcessInternalsHandler::Name_);
  message.set_method_name("GetUserTriggeredIsolatedOrigins");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ProcessInternalsHandler_GetWebTriggeredIsolatedOrigins_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ProcessInternalsHandler::GetWebTriggeredIsolatedOriginsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ProcessInternalsHandler_GetWebTriggeredIsolatedOrigins_ProxyToResponder> proxy(
        new ProcessInternalsHandler_GetWebTriggeredIsolatedOrigins_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ProcessInternalsHandler_GetWebTriggeredIsolatedOrigins_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ProcessInternalsHandler_GetWebTriggeredIsolatedOrigins_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ProcessInternalsHandler_GetWebTriggeredIsolatedOrigins_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ProcessInternalsHandler::GetWebTriggeredIsolatedOriginsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::vector<std::string>& in_isolated_origins);
};

bool ProcessInternalsHandler_GetWebTriggeredIsolatedOrigins_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ProcessInternalsHandler_GetWebTriggeredIsolatedOrigins_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ProcessInternalsHandler_GetWebTriggeredIsolatedOrigins_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ProcessInternalsHandler.4
  bool success = true;
  std::vector<std::string> p_isolated_origins{};
  ProcessInternalsHandler_GetWebTriggeredIsolatedOrigins_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadIsolatedOrigins(&p_isolated_origins))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ProcessInternalsHandler::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_isolated_origins));
  }
  return true;
}

void ProcessInternalsHandler_GetWebTriggeredIsolatedOrigins_ProxyToResponder::Run(
    const std::vector<std::string>& in_isolated_origins) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply mojom::ProcessInternalsHandler::GetWebTriggeredIsolatedOrigins", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("isolated_origins"), in_isolated_origins,
                        "<value of type const std::vector<std::string>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProcessInternalsHandler::kGetWebTriggeredIsolatedOrigins), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mojom::internal::ProcessInternalsHandler_GetWebTriggeredIsolatedOrigins_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->isolated_origins)::BaseType>
      isolated_origins_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& isolated_origins_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
    in_isolated_origins,
    isolated_origins_fragment,
    &isolated_origins_validate_params);

  params->isolated_origins.Set(
      isolated_origins_fragment.is_null() ? nullptr : isolated_origins_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->isolated_origins.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null isolated_origins in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProcessInternalsHandler::Name_);
  message.set_method_name("GetWebTriggeredIsolatedOrigins");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ProcessInternalsHandler_GetGloballyIsolatedOrigins_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ProcessInternalsHandler::GetGloballyIsolatedOriginsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ProcessInternalsHandler_GetGloballyIsolatedOrigins_ProxyToResponder> proxy(
        new ProcessInternalsHandler_GetGloballyIsolatedOrigins_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ProcessInternalsHandler_GetGloballyIsolatedOrigins_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ProcessInternalsHandler_GetGloballyIsolatedOrigins_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ProcessInternalsHandler_GetGloballyIsolatedOrigins_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ProcessInternalsHandler::GetGloballyIsolatedOriginsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<IsolatedOriginInfoPtr> in_isolated_origins);
};

bool ProcessInternalsHandler_GetGloballyIsolatedOrigins_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ProcessInternalsHandler_GetGloballyIsolatedOrigins_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ProcessInternalsHandler_GetGloballyIsolatedOrigins_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ProcessInternalsHandler.5
  bool success = true;
  std::vector<IsolatedOriginInfoPtr> p_isolated_origins{};
  ProcessInternalsHandler_GetGloballyIsolatedOrigins_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadIsolatedOrigins(&p_isolated_origins))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ProcessInternalsHandler::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_isolated_origins));
  }
  return true;
}

void ProcessInternalsHandler_GetGloballyIsolatedOrigins_ProxyToResponder::Run(
    std::vector<IsolatedOriginInfoPtr> in_isolated_origins) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply mojom::ProcessInternalsHandler::GetGloballyIsolatedOrigins", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("isolated_origins"), in_isolated_origins,
                        "<value of type std::vector<IsolatedOriginInfoPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProcessInternalsHandler::kGetGloballyIsolatedOrigins), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mojom::internal::ProcessInternalsHandler_GetGloballyIsolatedOrigins_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->isolated_origins)::BaseType>
      isolated_origins_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& isolated_origins_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::mojom::IsolatedOriginInfoDataView>>(
    in_isolated_origins,
    isolated_origins_fragment,
    &isolated_origins_validate_params);

  params->isolated_origins.Set(
      isolated_origins_fragment.is_null() ? nullptr : isolated_origins_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->isolated_origins.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null isolated_origins in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProcessInternalsHandler::Name_);
  message.set_method_name("GetGloballyIsolatedOrigins");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ProcessInternalsHandler_GetAllWebContentsInfo_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ProcessInternalsHandler::GetAllWebContentsInfoCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ProcessInternalsHandler_GetAllWebContentsInfo_ProxyToResponder> proxy(
        new ProcessInternalsHandler_GetAllWebContentsInfo_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ProcessInternalsHandler_GetAllWebContentsInfo_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ProcessInternalsHandler_GetAllWebContentsInfo_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ProcessInternalsHandler_GetAllWebContentsInfo_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ProcessInternalsHandler::GetAllWebContentsInfoCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<WebContentsInfoPtr> in_infos);
};

bool ProcessInternalsHandler_GetAllWebContentsInfo_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ProcessInternalsHandler_GetAllWebContentsInfo_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ProcessInternalsHandler_GetAllWebContentsInfo_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ProcessInternalsHandler.6
  bool success = true;
  std::vector<WebContentsInfoPtr> p_infos{};
  ProcessInternalsHandler_GetAllWebContentsInfo_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadInfos(&p_infos))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ProcessInternalsHandler::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_infos));
  }
  return true;
}

void ProcessInternalsHandler_GetAllWebContentsInfo_ProxyToResponder::Run(
    std::vector<WebContentsInfoPtr> in_infos) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply mojom::ProcessInternalsHandler::GetAllWebContentsInfo", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("infos"), in_infos,
                        "<value of type std::vector<WebContentsInfoPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProcessInternalsHandler::kGetAllWebContentsInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mojom::internal::ProcessInternalsHandler_GetAllWebContentsInfo_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->infos)::BaseType>
      infos_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& infos_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::mojom::WebContentsInfoDataView>>(
    in_infos,
    infos_fragment,
    &infos_validate_params);

  params->infos.Set(
      infos_fragment.is_null() ? nullptr : infos_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->infos.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null infos in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProcessInternalsHandler::Name_);
  message.set_method_name("GetAllWebContentsInfo");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ProcessInternalsHandlerStubDispatch::Accept(
    ProcessInternalsHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ProcessInternalsHandler>(message->header()->name)) {
    case messages::ProcessInternalsHandler::kGetProcessCountInfo: {
      break;
    }
    case messages::ProcessInternalsHandler::kGetIsolationMode: {
      break;
    }
    case messages::ProcessInternalsHandler::kGetProcessPerSiteMode: {
      break;
    }
    case messages::ProcessInternalsHandler::kGetUserTriggeredIsolatedOrigins: {
      break;
    }
    case messages::ProcessInternalsHandler::kGetWebTriggeredIsolatedOrigins: {
      break;
    }
    case messages::ProcessInternalsHandler::kGetGloballyIsolatedOrigins: {
      break;
    }
    case messages::ProcessInternalsHandler::kGetAllWebContentsInfo: {
      break;
    }
  }
  return false;
}

// static
bool ProcessInternalsHandlerStubDispatch::AcceptWithResponder(
    ProcessInternalsHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ProcessInternalsHandler>(message->header()->name)) {
    case messages::ProcessInternalsHandler::kGetProcessCountInfo: {
      internal::ProcessInternalsHandler_GetProcessCountInfo_Params_Data* params =
          reinterpret_cast<
              internal::ProcessInternalsHandler_GetProcessCountInfo_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ProcessInternalsHandler.0
      bool success = true;
      ProcessInternalsHandler_GetProcessCountInfo_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProcessInternalsHandler::Name_, 0, false);
        return false;
      }
      auto callback =
          ProcessInternalsHandler_GetProcessCountInfo_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetProcessCountInfo(std::move(callback));
      return true;
    }
    case messages::ProcessInternalsHandler::kGetIsolationMode: {
      internal::ProcessInternalsHandler_GetIsolationMode_Params_Data* params =
          reinterpret_cast<
              internal::ProcessInternalsHandler_GetIsolationMode_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ProcessInternalsHandler.1
      bool success = true;
      ProcessInternalsHandler_GetIsolationMode_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProcessInternalsHandler::Name_, 1, false);
        return false;
      }
      auto callback =
          ProcessInternalsHandler_GetIsolationMode_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetIsolationMode(std::move(callback));
      return true;
    }
    case messages::ProcessInternalsHandler::kGetProcessPerSiteMode: {
      internal::ProcessInternalsHandler_GetProcessPerSiteMode_Params_Data* params =
          reinterpret_cast<
              internal::ProcessInternalsHandler_GetProcessPerSiteMode_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ProcessInternalsHandler.2
      bool success = true;
      ProcessInternalsHandler_GetProcessPerSiteMode_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProcessInternalsHandler::Name_, 2, false);
        return false;
      }
      auto callback =
          ProcessInternalsHandler_GetProcessPerSiteMode_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetProcessPerSiteMode(std::move(callback));
      return true;
    }
    case messages::ProcessInternalsHandler::kGetUserTriggeredIsolatedOrigins: {
      internal::ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_Params_Data* params =
          reinterpret_cast<
              internal::ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ProcessInternalsHandler.3
      bool success = true;
      ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProcessInternalsHandler::Name_, 3, false);
        return false;
      }
      auto callback =
          ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetUserTriggeredIsolatedOrigins(std::move(callback));
      return true;
    }
    case messages::ProcessInternalsHandler::kGetWebTriggeredIsolatedOrigins: {
      internal::ProcessInternalsHandler_GetWebTriggeredIsolatedOrigins_Params_Data* params =
          reinterpret_cast<
              internal::ProcessInternalsHandler_GetWebTriggeredIsolatedOrigins_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ProcessInternalsHandler.4
      bool success = true;
      ProcessInternalsHandler_GetWebTriggeredIsolatedOrigins_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProcessInternalsHandler::Name_, 4, false);
        return false;
      }
      auto callback =
          ProcessInternalsHandler_GetWebTriggeredIsolatedOrigins_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetWebTriggeredIsolatedOrigins(std::move(callback));
      return true;
    }
    case messages::ProcessInternalsHandler::kGetGloballyIsolatedOrigins: {
      internal::ProcessInternalsHandler_GetGloballyIsolatedOrigins_Params_Data* params =
          reinterpret_cast<
              internal::ProcessInternalsHandler_GetGloballyIsolatedOrigins_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ProcessInternalsHandler.5
      bool success = true;
      ProcessInternalsHandler_GetGloballyIsolatedOrigins_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProcessInternalsHandler::Name_, 5, false);
        return false;
      }
      auto callback =
          ProcessInternalsHandler_GetGloballyIsolatedOrigins_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetGloballyIsolatedOrigins(std::move(callback));
      return true;
    }
    case messages::ProcessInternalsHandler::kGetAllWebContentsInfo: {
      internal::ProcessInternalsHandler_GetAllWebContentsInfo_Params_Data* params =
          reinterpret_cast<
              internal::ProcessInternalsHandler_GetAllWebContentsInfo_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ProcessInternalsHandler.6
      bool success = true;
      ProcessInternalsHandler_GetAllWebContentsInfo_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProcessInternalsHandler::Name_, 6, false);
        return false;
      }
      auto callback =
          ProcessInternalsHandler_GetAllWebContentsInfo_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetAllWebContentsInfo(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kProcessInternalsHandlerValidationInfo[] = {
    {base::to_underlying(messages::ProcessInternalsHandler::kGetProcessCountInfo),
     { &internal::ProcessInternalsHandler_GetProcessCountInfo_Params_Data::Validate,
      &internal::ProcessInternalsHandler_GetProcessCountInfo_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::ProcessInternalsHandler::kGetIsolationMode),
     { &internal::ProcessInternalsHandler_GetIsolationMode_Params_Data::Validate,
      &internal::ProcessInternalsHandler_GetIsolationMode_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::ProcessInternalsHandler::kGetProcessPerSiteMode),
     { &internal::ProcessInternalsHandler_GetProcessPerSiteMode_Params_Data::Validate,
      &internal::ProcessInternalsHandler_GetProcessPerSiteMode_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::ProcessInternalsHandler::kGetUserTriggeredIsolatedOrigins),
     { &internal::ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_Params_Data::Validate,
      &internal::ProcessInternalsHandler_GetUserTriggeredIsolatedOrigins_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::ProcessInternalsHandler::kGetWebTriggeredIsolatedOrigins),
     { &internal::ProcessInternalsHandler_GetWebTriggeredIsolatedOrigins_Params_Data::Validate,
      &internal::ProcessInternalsHandler_GetWebTriggeredIsolatedOrigins_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::ProcessInternalsHandler::kGetGloballyIsolatedOrigins),
     { &internal::ProcessInternalsHandler_GetGloballyIsolatedOrigins_Params_Data::Validate,
      &internal::ProcessInternalsHandler_GetGloballyIsolatedOrigins_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::ProcessInternalsHandler::kGetAllWebContentsInfo),
     { &internal::ProcessInternalsHandler_GetAllWebContentsInfo_Params_Data::Validate,
      &internal::ProcessInternalsHandler_GetAllWebContentsInfo_ResponseParams_Data::Validate}},
};

bool ProcessInternalsHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::mojom::ProcessInternalsHandler::Name_,
    kProcessInternalsHandlerValidationInfo);
}

bool ProcessInternalsHandlerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGeneric(
    message,
    ::mojom::ProcessInternalsHandler::Name_,
    kProcessInternalsHandlerValidationInfo);

}


}  // mojom


namespace mojo {


// static
bool StructTraits<::mojom::ProcessCountInfo::DataView, ::mojom::ProcessCountInfoPtr>::Read(
    ::mojom::ProcessCountInfo::DataView input,
    ::mojom::ProcessCountInfoPtr* output) {
  bool success = true;
  ::mojom::ProcessCountInfoPtr result(::mojom::ProcessCountInfo::New());
  
      if (success)
        result->renderer_process_limit = input.renderer_process_limit();
      if (success)
        result->renderer_process_count_total = input.renderer_process_count_total();
      if (success)
        result->live_renderer_processes_count_total = input.live_renderer_processes_count_total();
      if (success)
        result->renderer_process_count_for_limit = input.renderer_process_count_for_limit();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::mojom::SiteInstanceInfo::DataView, ::mojom::SiteInstanceInfoPtr>::Read(
    ::mojom::SiteInstanceInfo::DataView input,
    ::mojom::SiteInstanceInfoPtr* output) {
  bool success = true;
  ::mojom::SiteInstanceInfoPtr result(::mojom::SiteInstanceInfo::New());
  
      if (success)
        result->id = input.id();
      if (success)
        result->site_instance_group_id = input.site_instance_group_id();
      if (success)
        result->browsing_instance_id = input.browsing_instance_id();
      if (success)
        result->locked = input.locked();
      if (success && !input.ReadSiteUrl(&result->site_url))
        success = false;
      if (success && !input.ReadProcessLockUrl(&result->process_lock_url))
        success = false;
      if (success)
        result->requires_origin_keyed_process = input.requires_origin_keyed_process();
      if (success)
        result->is_sandbox_for_iframes = input.is_sandbox_for_iframes();
      if (success)
        result->is_guest = input.is_guest();
      if (success)
        result->is_pdf = input.is_pdf();
      if (success)
        result->are_javascript_optimizers_enabled = input.are_javascript_optimizers_enabled();
      if (success && !input.ReadStoragePartition(&result->storage_partition))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::mojom::FrameInfo::DataView, ::mojom::FrameInfoPtr>::Read(
    ::mojom::FrameInfo::DataView input,
    ::mojom::FrameInfoPtr* output) {
  bool success = true;
  ::mojom::FrameInfoPtr result(::mojom::FrameInfo::New());
  
      if (success)
        result->routing_id = input.routing_id();
      if (success)
        result->agent_scheduling_group_id = input.agent_scheduling_group_id();
      if (success)
        result->process_id = input.process_id();
      if (success && !input.ReadSiteInstance(&result->site_instance))
        success = false;
      if (success && !input.ReadLastCommittedUrl(&result->last_committed_url))
        success = false;
      if (success && !input.ReadSubframes(&result->subframes))
        success = false;
      if (success && !input.ReadType(&result->type))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::mojom::WebContentsInfo::DataView, ::mojom::WebContentsInfoPtr>::Read(
    ::mojom::WebContentsInfo::DataView input,
    ::mojom::WebContentsInfoPtr* output) {
  bool success = true;
  ::mojom::WebContentsInfoPtr result(::mojom::WebContentsInfo::New());
  
      if (success && !input.ReadTitle(&result->title))
        success = false;
      if (success && !input.ReadRootFrame(&result->root_frame))
        success = false;
      if (success && !input.ReadBfcachedRootFrames(&result->bfcached_root_frames))
        success = false;
      if (success && !input.ReadPrerenderRootFrames(&result->prerender_root_frames))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::mojom::IsolatedOriginInfo::DataView, ::mojom::IsolatedOriginInfoPtr>::Read(
    ::mojom::IsolatedOriginInfo::DataView input,
    ::mojom::IsolatedOriginInfoPtr* output) {
  bool success = true;
  ::mojom::IsolatedOriginInfoPtr result(::mojom::IsolatedOriginInfo::New());
  
      if (success && !input.ReadOrigin(&result->origin))
        success = false;
      if (success && !input.ReadSource(&result->source))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace mojom {


void ProcessInternalsHandlerInterceptorForTesting::GetProcessCountInfo(GetProcessCountInfoCallback callback) {
  GetForwardingInterface()->GetProcessCountInfo(std::move(callback));
}
void ProcessInternalsHandlerInterceptorForTesting::GetIsolationMode(GetIsolationModeCallback callback) {
  GetForwardingInterface()->GetIsolationMode(std::move(callback));
}
void ProcessInternalsHandlerInterceptorForTesting::GetProcessPerSiteMode(GetProcessPerSiteModeCallback callback) {
  GetForwardingInterface()->GetProcessPerSiteMode(std::move(callback));
}
void ProcessInternalsHandlerInterceptorForTesting::GetUserTriggeredIsolatedOrigins(GetUserTriggeredIsolatedOriginsCallback callback) {
  GetForwardingInterface()->GetUserTriggeredIsolatedOrigins(std::move(callback));
}
void ProcessInternalsHandlerInterceptorForTesting::GetWebTriggeredIsolatedOrigins(GetWebTriggeredIsolatedOriginsCallback callback) {
  GetForwardingInterface()->GetWebTriggeredIsolatedOrigins(std::move(callback));
}
void ProcessInternalsHandlerInterceptorForTesting::GetGloballyIsolatedOrigins(GetGloballyIsolatedOriginsCallback callback) {
  GetForwardingInterface()->GetGloballyIsolatedOrigins(std::move(callback));
}
void ProcessInternalsHandlerInterceptorForTesting::GetAllWebContentsInfo(GetAllWebContentsInfoCallback callback) {
  GetForwardingInterface()->GetAllWebContentsInfo(std::move(callback));
}
ProcessInternalsHandlerAsyncWaiter::ProcessInternalsHandlerAsyncWaiter(
    ProcessInternalsHandler* proxy) : proxy_(proxy) {}

ProcessInternalsHandlerAsyncWaiter::~ProcessInternalsHandlerAsyncWaiter() = default;


void ProcessInternalsHandlerAsyncWaiter::GetProcessCountInfo(
    ProcessCountInfoPtr* out_info) {
  base::RunLoop loop;
  proxy_->GetProcessCountInfo(
      base::BindOnce(
          [](base::RunLoop* loop,
             ProcessCountInfoPtr* out_info
,
             ProcessCountInfoPtr info) {*out_info = std::move(info);
            loop->Quit();
          },
          &loop,
          out_info));
  loop.Run();
}

ProcessCountInfoPtr ProcessInternalsHandlerAsyncWaiter::GetProcessCountInfo(
    ) {
  ProcessCountInfoPtr async_wait_result;
  GetProcessCountInfo(&async_wait_result);
  return async_wait_result;
}

void ProcessInternalsHandlerAsyncWaiter::GetIsolationMode(
    std::string* out_mode) {
  base::RunLoop loop;
  proxy_->GetIsolationMode(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::string* out_mode
,
             const std::string& mode) {*out_mode = std::move(mode);
            loop->Quit();
          },
          &loop,
          out_mode));
  loop.Run();
}

std::string ProcessInternalsHandlerAsyncWaiter::GetIsolationMode(
    ) {
  std::string async_wait_result;
  GetIsolationMode(&async_wait_result);
  return async_wait_result;
}

void ProcessInternalsHandlerAsyncWaiter::GetProcessPerSiteMode(
    std::string* out_mode) {
  base::RunLoop loop;
  proxy_->GetProcessPerSiteMode(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::string* out_mode
,
             const std::string& mode) {*out_mode = std::move(mode);
            loop->Quit();
          },
          &loop,
          out_mode));
  loop.Run();
}

std::string ProcessInternalsHandlerAsyncWaiter::GetProcessPerSiteMode(
    ) {
  std::string async_wait_result;
  GetProcessPerSiteMode(&async_wait_result);
  return async_wait_result;
}

void ProcessInternalsHandlerAsyncWaiter::GetUserTriggeredIsolatedOrigins(
    std::vector<std::string>* out_isolated_origins) {
  base::RunLoop loop;
  proxy_->GetUserTriggeredIsolatedOrigins(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<std::string>* out_isolated_origins
,
             const std::vector<std::string>& isolated_origins) {*out_isolated_origins = std::move(isolated_origins);
            loop->Quit();
          },
          &loop,
          out_isolated_origins));
  loop.Run();
}

std::vector<std::string> ProcessInternalsHandlerAsyncWaiter::GetUserTriggeredIsolatedOrigins(
    ) {
  std::vector<std::string> async_wait_result;
  GetUserTriggeredIsolatedOrigins(&async_wait_result);
  return async_wait_result;
}

void ProcessInternalsHandlerAsyncWaiter::GetWebTriggeredIsolatedOrigins(
    std::vector<std::string>* out_isolated_origins) {
  base::RunLoop loop;
  proxy_->GetWebTriggeredIsolatedOrigins(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<std::string>* out_isolated_origins
,
             const std::vector<std::string>& isolated_origins) {*out_isolated_origins = std::move(isolated_origins);
            loop->Quit();
          },
          &loop,
          out_isolated_origins));
  loop.Run();
}

std::vector<std::string> ProcessInternalsHandlerAsyncWaiter::GetWebTriggeredIsolatedOrigins(
    ) {
  std::vector<std::string> async_wait_result;
  GetWebTriggeredIsolatedOrigins(&async_wait_result);
  return async_wait_result;
}

void ProcessInternalsHandlerAsyncWaiter::GetGloballyIsolatedOrigins(
    std::vector<IsolatedOriginInfoPtr>* out_isolated_origins) {
  base::RunLoop loop;
  proxy_->GetGloballyIsolatedOrigins(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<IsolatedOriginInfoPtr>* out_isolated_origins
,
             std::vector<IsolatedOriginInfoPtr> isolated_origins) {*out_isolated_origins = std::move(isolated_origins);
            loop->Quit();
          },
          &loop,
          out_isolated_origins));
  loop.Run();
}

std::vector<IsolatedOriginInfoPtr> ProcessInternalsHandlerAsyncWaiter::GetGloballyIsolatedOrigins(
    ) {
  std::vector<IsolatedOriginInfoPtr> async_wait_result;
  GetGloballyIsolatedOrigins(&async_wait_result);
  return async_wait_result;
}

void ProcessInternalsHandlerAsyncWaiter::GetAllWebContentsInfo(
    std::vector<WebContentsInfoPtr>* out_infos) {
  base::RunLoop loop;
  proxy_->GetAllWebContentsInfo(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<WebContentsInfoPtr>* out_infos
,
             std::vector<WebContentsInfoPtr> infos) {*out_infos = std::move(infos);
            loop->Quit();
          },
          &loop,
          out_infos));
  loop.Run();
}

std::vector<WebContentsInfoPtr> ProcessInternalsHandlerAsyncWaiter::GetAllWebContentsInfo(
    ) {
  std::vector<WebContentsInfoPtr> async_wait_result;
  GetAllWebContentsInfo(&async_wait_result);
  return async_wait_result;
}






}  // mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif