// content/common/memory_coordinator/mojom/memory_coordinator.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_COMMON_MEMORY_COORDINATOR_MOJOM_MEMORY_COORDINATOR_MOJOM_H_
#define CONTENT_COMMON_MEMORY_COORDINATOR_MOJOM_MEMORY_COORDINATOR_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "content/common/memory_coordinator/mojom/memory_coordinator.mojom-features.h"  // IWYU pragma: export
#include "content/common/memory_coordinator/mojom/memory_coordinator.mojom-shared.h"  // IWYU pragma: export
#include "content/common/memory_coordinator/mojom/memory_coordinator.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "content/common/memory_coordinator/mojom/memory_consumer_traits_mojom_traits.h"
#include "base/component_export.h"




namespace content::mojom {

class ChildMemoryConsumerProxy;

template <typename ImplRefTraits>
class ChildMemoryConsumerStub;

class ChildMemoryConsumerRequestValidator;


class COMPONENT_EXPORT(CONTENT_BROWSER_MEMORY_COORDINATOR_MOJOM) ChildMemoryConsumer
    : public ChildMemoryConsumerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "content.mojom.ChildMemoryConsumer";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ChildMemoryConsumerInterfaceBase;
  using Proxy_ = ChildMemoryConsumerProxy;

  template <typename ImplRefTraits>
  using Stub_ = ChildMemoryConsumerStub<ImplRefTraits>;

  using RequestValidator_ = ChildMemoryConsumerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kNotifyReleaseMemoryMinVersion = 0,
    kNotifyUpdateMemoryLimitMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct NotifyReleaseMemory_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NotifyUpdateMemoryLimit_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ChildMemoryConsumer() = default;

  virtual void NotifyReleaseMemory() = 0;

  virtual void NotifyUpdateMemoryLimit(int32_t percentage) = 0;
};

class BrowserMemoryConsumerRegistryProxy;

template <typename ImplRefTraits>
class BrowserMemoryConsumerRegistryStub;

class BrowserMemoryConsumerRegistryRequestValidator;


class COMPONENT_EXPORT(CONTENT_BROWSER_MEMORY_COORDINATOR_MOJOM) BrowserMemoryConsumerRegistry
    : public BrowserMemoryConsumerRegistryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "content.mojom.BrowserMemoryConsumerRegistry";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = BrowserMemoryConsumerRegistryInterfaceBase;
  using Proxy_ = BrowserMemoryConsumerRegistryProxy;

  template <typename ImplRefTraits>
  using Stub_ = BrowserMemoryConsumerRegistryStub<ImplRefTraits>;

  using RequestValidator_ = BrowserMemoryConsumerRegistryRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kRegisterChildMemoryConsumerMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct RegisterChildMemoryConsumer_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~BrowserMemoryConsumerRegistry() = default;

  virtual void RegisterChildMemoryConsumer(const std::string& consumer_id, ::base::MemoryConsumerTraits traits, ::mojo::PendingRemote<ChildMemoryConsumer> child_consumer) = 0;
};



class COMPONENT_EXPORT(CONTENT_BROWSER_MEMORY_COORDINATOR_MOJOM) ChildMemoryConsumerProxy
    : public ChildMemoryConsumer {
 public:
  using InterfaceType = ChildMemoryConsumer;

  explicit ChildMemoryConsumerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void NotifyReleaseMemory() final;
  
  void NotifyUpdateMemoryLimit(int32_t percentage) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class COMPONENT_EXPORT(CONTENT_BROWSER_MEMORY_COORDINATOR_MOJOM) BrowserMemoryConsumerRegistryProxy
    : public BrowserMemoryConsumerRegistry {
 public:
  using InterfaceType = BrowserMemoryConsumerRegistry;

  explicit BrowserMemoryConsumerRegistryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void RegisterChildMemoryConsumer(const std::string& consumer_id, ::base::MemoryConsumerTraits traits, ::mojo::PendingRemote<ChildMemoryConsumer> child_consumer) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class COMPONENT_EXPORT(CONTENT_BROWSER_MEMORY_COORDINATOR_MOJOM) ChildMemoryConsumerStubDispatch {
 public:
  static bool Accept(ChildMemoryConsumer* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ChildMemoryConsumer* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ChildMemoryConsumer>>
class ChildMemoryConsumerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ChildMemoryConsumerStub() = default;
  ~ChildMemoryConsumerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ChildMemoryConsumerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ChildMemoryConsumerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(CONTENT_BROWSER_MEMORY_COORDINATOR_MOJOM) BrowserMemoryConsumerRegistryStubDispatch {
 public:
  static bool Accept(BrowserMemoryConsumerRegistry* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      BrowserMemoryConsumerRegistry* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<BrowserMemoryConsumerRegistry>>
class BrowserMemoryConsumerRegistryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  BrowserMemoryConsumerRegistryStub() = default;
  ~BrowserMemoryConsumerRegistryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return BrowserMemoryConsumerRegistryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return BrowserMemoryConsumerRegistryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(CONTENT_BROWSER_MEMORY_COORDINATOR_MOJOM) ChildMemoryConsumerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(CONTENT_BROWSER_MEMORY_COORDINATOR_MOJOM) BrowserMemoryConsumerRegistryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class COMPONENT_EXPORT(CONTENT_BROWSER_MEMORY_COORDINATOR_MOJOM) MemoryConsumerTraits {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<MemoryConsumerTraits, T>::value>;
  using DataView = MemoryConsumerTraitsDataView;
  using Data_ = internal::MemoryConsumerTraits_Data;

  template <typename... Args>
  static MemoryConsumerTraitsPtr New(Args&&... args) {
    return MemoryConsumerTraitsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static MemoryConsumerTraitsPtr From(const U& u) {
    return mojo::TypeConverter<MemoryConsumerTraitsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, MemoryConsumerTraits>::Convert(*this);
  }


  MemoryConsumerTraits();

  MemoryConsumerTraits(
      uint8_t supports_memory_limit,
      uint8_t in_process,
      uint8_t estimated_memory_usage,
      uint8_t release_memory_cost,
      uint8_t recreate_memory_cost,
      uint8_t information_retention,
      uint8_t memory_release_behavior,
      uint8_t execution_type,
      uint8_t release_gc_references,
      uint8_t garbage_collects_v8_heap);


  ~MemoryConsumerTraits();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = MemoryConsumerTraitsPtr>
  MemoryConsumerTraitsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, MemoryConsumerTraits::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, MemoryConsumerTraits::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, MemoryConsumerTraits::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MemoryConsumerTraits::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MemoryConsumerTraits::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        MemoryConsumerTraits::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::MemoryConsumerTraits_UnserializedMessageContext<
            UserType, MemoryConsumerTraits::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<MemoryConsumerTraits::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return MemoryConsumerTraits::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::MemoryConsumerTraits_UnserializedMessageContext<
            UserType, MemoryConsumerTraits::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<MemoryConsumerTraits::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint8_t supports_memory_limit;
  
  uint8_t in_process;
  
  uint8_t estimated_memory_usage;
  
  uint8_t release_memory_cost;
  
  uint8_t recreate_memory_cost;
  
  uint8_t information_retention;
  
  uint8_t memory_release_behavior;
  
  uint8_t execution_type;
  
  uint8_t release_gc_references;
  
  uint8_t garbage_collects_v8_heap;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, MemoryConsumerTraits::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, MemoryConsumerTraits::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, MemoryConsumerTraits::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, MemoryConsumerTraits::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
MemoryConsumerTraitsPtr MemoryConsumerTraits::Clone() const {
  return New(
      mojo::Clone(supports_memory_limit),
      mojo::Clone(in_process),
      mojo::Clone(estimated_memory_usage),
      mojo::Clone(release_memory_cost),
      mojo::Clone(recreate_memory_cost),
      mojo::Clone(information_retention),
      mojo::Clone(memory_release_behavior),
      mojo::Clone(execution_type),
      mojo::Clone(release_gc_references),
      mojo::Clone(garbage_collects_v8_heap)
  );
}

template <typename T, MemoryConsumerTraits::EnableIfSame<T>*>
bool MemoryConsumerTraits::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->supports_memory_limit, other_struct.supports_memory_limit))
    return false;
  if (!mojo::Equals(this->in_process, other_struct.in_process))
    return false;
  if (!mojo::Equals(this->estimated_memory_usage, other_struct.estimated_memory_usage))
    return false;
  if (!mojo::Equals(this->release_memory_cost, other_struct.release_memory_cost))
    return false;
  if (!mojo::Equals(this->recreate_memory_cost, other_struct.recreate_memory_cost))
    return false;
  if (!mojo::Equals(this->information_retention, other_struct.information_retention))
    return false;
  if (!mojo::Equals(this->memory_release_behavior, other_struct.memory_release_behavior))
    return false;
  if (!mojo::Equals(this->execution_type, other_struct.execution_type))
    return false;
  if (!mojo::Equals(this->release_gc_references, other_struct.release_gc_references))
    return false;
  if (!mojo::Equals(this->garbage_collects_v8_heap, other_struct.garbage_collects_v8_heap))
    return false;
  return true;
}

template <typename T, MemoryConsumerTraits::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.supports_memory_limit < rhs.supports_memory_limit)
    return true;
  if (rhs.supports_memory_limit < lhs.supports_memory_limit)
    return false;
  if (lhs.in_process < rhs.in_process)
    return true;
  if (rhs.in_process < lhs.in_process)
    return false;
  if (lhs.estimated_memory_usage < rhs.estimated_memory_usage)
    return true;
  if (rhs.estimated_memory_usage < lhs.estimated_memory_usage)
    return false;
  if (lhs.release_memory_cost < rhs.release_memory_cost)
    return true;
  if (rhs.release_memory_cost < lhs.release_memory_cost)
    return false;
  if (lhs.recreate_memory_cost < rhs.recreate_memory_cost)
    return true;
  if (rhs.recreate_memory_cost < lhs.recreate_memory_cost)
    return false;
  if (lhs.information_retention < rhs.information_retention)
    return true;
  if (rhs.information_retention < lhs.information_retention)
    return false;
  if (lhs.memory_release_behavior < rhs.memory_release_behavior)
    return true;
  if (rhs.memory_release_behavior < lhs.memory_release_behavior)
    return false;
  if (lhs.execution_type < rhs.execution_type)
    return true;
  if (rhs.execution_type < lhs.execution_type)
    return false;
  if (lhs.release_gc_references < rhs.release_gc_references)
    return true;
  if (rhs.release_gc_references < lhs.release_gc_references)
    return false;
  if (lhs.garbage_collects_v8_heap < rhs.garbage_collects_v8_heap)
    return true;
  if (rhs.garbage_collects_v8_heap < lhs.garbage_collects_v8_heap)
    return false;
  return false;
}


}  // content::mojom

namespace mojo {


template <>
struct COMPONENT_EXPORT(CONTENT_BROWSER_MEMORY_COORDINATOR_MOJOM) StructTraits<::content::mojom::MemoryConsumerTraits::DataView,
                                         ::content::mojom::MemoryConsumerTraitsPtr> {
  static bool IsNull(const ::content::mojom::MemoryConsumerTraitsPtr& input) { return !input; }
  static void SetToNull(::content::mojom::MemoryConsumerTraitsPtr* output) { output->reset(); }

  static decltype(::content::mojom::MemoryConsumerTraits::supports_memory_limit) supports_memory_limit(
      const ::content::mojom::MemoryConsumerTraitsPtr& input) {
    return input->supports_memory_limit;
  }

  static decltype(::content::mojom::MemoryConsumerTraits::in_process) in_process(
      const ::content::mojom::MemoryConsumerTraitsPtr& input) {
    return input->in_process;
  }

  static decltype(::content::mojom::MemoryConsumerTraits::estimated_memory_usage) estimated_memory_usage(
      const ::content::mojom::MemoryConsumerTraitsPtr& input) {
    return input->estimated_memory_usage;
  }

  static decltype(::content::mojom::MemoryConsumerTraits::release_memory_cost) release_memory_cost(
      const ::content::mojom::MemoryConsumerTraitsPtr& input) {
    return input->release_memory_cost;
  }

  static decltype(::content::mojom::MemoryConsumerTraits::recreate_memory_cost) recreate_memory_cost(
      const ::content::mojom::MemoryConsumerTraitsPtr& input) {
    return input->recreate_memory_cost;
  }

  static decltype(::content::mojom::MemoryConsumerTraits::information_retention) information_retention(
      const ::content::mojom::MemoryConsumerTraitsPtr& input) {
    return input->information_retention;
  }

  static decltype(::content::mojom::MemoryConsumerTraits::memory_release_behavior) memory_release_behavior(
      const ::content::mojom::MemoryConsumerTraitsPtr& input) {
    return input->memory_release_behavior;
  }

  static decltype(::content::mojom::MemoryConsumerTraits::execution_type) execution_type(
      const ::content::mojom::MemoryConsumerTraitsPtr& input) {
    return input->execution_type;
  }

  static decltype(::content::mojom::MemoryConsumerTraits::release_gc_references) release_gc_references(
      const ::content::mojom::MemoryConsumerTraitsPtr& input) {
    return input->release_gc_references;
  }

  static decltype(::content::mojom::MemoryConsumerTraits::garbage_collects_v8_heap) garbage_collects_v8_heap(
      const ::content::mojom::MemoryConsumerTraitsPtr& input) {
    return input->garbage_collects_v8_heap;
  }

  static bool Read(::content::mojom::MemoryConsumerTraits::DataView input, ::content::mojom::MemoryConsumerTraitsPtr* output);
};

}  // namespace mojo

#endif  // CONTENT_COMMON_MEMORY_COORDINATOR_MOJOM_MEMORY_COORDINATOR_MOJOM_H_