// content/services/auction_worklet/public/mojom/seller_worklet.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "content/services/auction_worklet/public/mojom/seller_worklet.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "content/services/auction_worklet/public/mojom/seller_worklet.mojom-params-data.h"
namespace auction_worklet {
namespace mojom {

namespace internal {
// static
bool ComponentAuctionOtherSeller_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const ComponentAuctionOtherSeller_Data* object = static_cast<const ComponentAuctionOtherSeller_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case ComponentAuctionOtherSeller_Tag::kTopLevelSeller: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_top_level_seller, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_top_level_seller, validation_context))
        return false;
      return true;
    }
    case ComponentAuctionOtherSeller_Tag::kComponentSeller: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_component_seller, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_component_seller, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in ComponentAuctionOtherSeller");
      return false;
    }
  }
}


// static
bool ComponentAuctionModifiedBidParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ComponentAuctionModifiedBidParams_Data* object =
      static_cast<const ComponentAuctionModifiedBidParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->ad, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& ad_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->ad, validation_context,
                                         &ad_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->bid_currency, validation_context))
    return false;

  return true;
}

ComponentAuctionModifiedBidParams_Data::ComponentAuctionModifiedBidParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ComponentAuctionReportResultParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ComponentAuctionReportResultParams_Data* object =
      static_cast<const ComponentAuctionReportResultParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->top_level_seller_signals, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& top_level_seller_signals_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->top_level_seller_signals, validation_context,
                                         &top_level_seller_signals_validate_params)) {
    return false;
  }

  return true;
}

ComponentAuctionReportResultParams_Data::ComponentAuctionReportResultParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ScoreAdDependencyLatencies_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ScoreAdDependencyLatencies_Data* object =
      static_cast<const ScoreAdDependencyLatencies_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->code_ready_latency, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->direct_from_seller_signals_latency, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->trusted_scoring_signals_latency, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->deps_wait_start_time, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->deps_wait_start_time, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->score_ad_start_time, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->score_ad_start_time, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->score_ad_finish_time, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->score_ad_finish_time, validation_context))
    return false;

  return true;
}

ScoreAdDependencyLatencies_Data::ScoreAdDependencyLatencies_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SellerTimingMetrics_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SellerTimingMetrics_Data* object =
      static_cast<const SellerTimingMetrics_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->js_fetch_latency, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->script_latency, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->script_latency, validation_context))
    return false;

  return true;
}

SellerTimingMetrics_Data::SellerTimingMetrics_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CreativeInfoWithoutOwner_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CreativeInfoWithoutOwner_Data* object =
      static_cast<const CreativeInfoWithoutOwner_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->ad_descriptor, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->ad_descriptor, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& creative_scanning_metadata_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->creative_scanning_metadata, validation_context,
                                         &creative_scanning_metadata_validate_params)) {
    return false;
  }

  return true;
}

CreativeInfoWithoutOwner_Data::CreativeInfoWithoutOwner_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ScoreAdClient_OnScoreAdComplete_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 104, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ScoreAdClient_OnScoreAdComplete_Params_Data* object =
      static_cast<const ScoreAdClient_OnScoreAdComplete_Params_Data*>(data);


  if (!::auction_worklet::mojom::internal::RejectReason_Data
        ::Validate(object->reject_reason, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->component_auction_modified_bid_params, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->debug_loss_report_url, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->debug_win_report_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->pa_requests, 10, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& pa_requests_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->pa_requests, validation_context,
                                         &pa_requests_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->real_time_contributions, 11, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& real_time_contributions_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->real_time_contributions, validation_context,
                                         &real_time_contributions_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->score_ad_timing_metrics, 12, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->score_ad_timing_metrics, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->score_ad_dependency_latencies, 13, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->score_ad_dependency_latencies, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->errors, 14, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& errors_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->errors, validation_context,
                                         &errors_validate_params)) {
    return false;
  }

  return true;
}

ScoreAdClient_OnScoreAdComplete_Params_Data::ScoreAdClient_OnScoreAdComplete_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SellerWorklet_ScoreAd_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 192, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SellerWorklet_ScoreAd_Params_Data* object =
      static_cast<const SellerWorklet_ScoreAd_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->ad_metadata_json, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& ad_metadata_json_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->ad_metadata_json, validation_context,
                                         &ad_metadata_json_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->bid_currency, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->auction_ad_config_non_shared_params, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->auction_ad_config_non_shared_params, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->key_value_signals_cache_key, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->ad, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->ad, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->ad_components, 7, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& ad_components_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->ad_components, validation_context,
                                         &ad_components_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->direct_from_seller_seller_signals, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& direct_from_seller_seller_signals_header_ad_slot_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->direct_from_seller_seller_signals_header_ad_slot, validation_context,
                                         &direct_from_seller_seller_signals_header_ad_slot_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->direct_from_seller_auction_signals, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& direct_from_seller_auction_signals_header_ad_slot_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->direct_from_seller_auction_signals_header_ad_slot, validation_context,
                                         &direct_from_seller_auction_signals_header_ad_slot_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateInlinedUnion(object->browser_signals_other_seller, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->component_expect_bid_currency, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->browser_signal_interest_group_owner, 14, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->browser_signal_interest_group_owner, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& browser_signal_selected_buyer_and_seller_reporting_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->browser_signal_selected_buyer_and_seller_reporting_id, validation_context,
                                         &browser_signal_selected_buyer_and_seller_reporting_id_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& browser_signal_buyer_and_seller_reporting_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->browser_signal_buyer_and_seller_reporting_id, validation_context,
                                         &browser_signal_buyer_and_seller_reporting_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->seller_timeout, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bidder_joining_origin, 24, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->bidder_joining_origin, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->score_ad_client, 25, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->score_ad_client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

SellerWorklet_ScoreAd_Params_Data::SellerWorklet_ScoreAd_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SellerWorklet_SendPendingSignalsRequests_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SellerWorklet_SendPendingSignalsRequests_Params_Data* object =
      static_cast<const SellerWorklet_SendPendingSignalsRequests_Params_Data*>(data);

  return true;
}

SellerWorklet_SendPendingSignalsRequests_Params_Data::SellerWorklet_SendPendingSignalsRequests_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SellerWorklet_ReportResult_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 160, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SellerWorklet_ReportResult_Params_Data* object =
      static_cast<const SellerWorklet_ReportResult_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->auction_ad_config_non_shared_params, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->auction_ad_config_non_shared_params, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->direct_from_seller_seller_signals, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& direct_from_seller_seller_signals_header_ad_slot_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->direct_from_seller_seller_signals_header_ad_slot, validation_context,
                                         &direct_from_seller_seller_signals_header_ad_slot_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->direct_from_seller_auction_signals, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& direct_from_seller_auction_signals_header_ad_slot_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->direct_from_seller_auction_signals_header_ad_slot, validation_context,
                                         &direct_from_seller_auction_signals_header_ad_slot_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateInlinedUnion(object->browser_signals_other_seller, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->browser_signal_interest_group_owner, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->browser_signal_interest_group_owner, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& browser_signal_buyer_and_seller_reporting_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->browser_signal_buyer_and_seller_reporting_id, validation_context,
                                         &browser_signal_buyer_and_seller_reporting_id_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& browser_signal_selected_buyer_and_seller_reporting_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->browser_signal_selected_buyer_and_seller_reporting_id, validation_context,
                                         &browser_signal_selected_buyer_and_seller_reporting_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->browser_signal_render_url, 10, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->browser_signal_render_url, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->browser_signal_bid_currency, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->browser_signal_highest_scoring_other_bid_currency, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->browser_signals_component_auction_report_result_params, validation_context))
    return false;

  return true;
}

SellerWorklet_ReportResult_Params_Data::SellerWorklet_ReportResult_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SellerWorklet_ReportResult_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SellerWorklet_ReportResult_ResponseParams_Data* object =
      static_cast<const SellerWorklet_ReportResult_ResponseParams_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& signals_for_winner_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->signals_for_winner, validation_context,
                                         &signals_for_winner_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->report_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->ad_beacon_map, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& ad_beacon_map_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->ad_beacon_map, validation_context,
                                         &ad_beacon_map_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->pa_requests, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& pa_requests_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->pa_requests, validation_context,
                                         &pa_requests_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->time_metrics, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->time_metrics, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->error_msgs, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& error_msgs_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->error_msgs, validation_context,
                                         &error_msgs_validate_params)) {
    return false;
  }

  return true;
}

SellerWorklet_ReportResult_ResponseParams_Data::SellerWorklet_ReportResult_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SellerWorklet_ConnectDevToolsAgent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SellerWorklet_ConnectDevToolsAgent_Params_Data* object =
      static_cast<const SellerWorklet_ConnectDevToolsAgent_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->agent, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->agent,
                                                 validation_context)) {
    return false;
  }

  return true;
}

SellerWorklet_ConnectDevToolsAgent_Params_Data::SellerWorklet_ConnectDevToolsAgent_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace auction_worklet