// Copyright 2026 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "extensions/browser/api/generated_api_registration.h"

#include "build/android_buildflags.h"
#include "build/build_config.h"

#include "extensions/browser/api/alarms/alarms_api.h"
#include "extensions/browser/api/declarative_net_request/declarative_net_request_api.h"
#include "extensions/browser/api/dns/dns_api.h"
#include "extensions/browser/api/declarative/declarative_api.h"
#include "extensions/browser/api/i18n/i18n_api.h"
#include "extensions/browser/api/idle/idle_api.h"
#include "extensions/browser/api/management/management_api.h"
#include "extensions/browser/api/metrics_private/metrics_private_api.h"
#include "extensions/browser/api/offscreen/offscreen_api.h"
#include "extensions/browser/api/power/power_api.h"
#include "extensions/browser/api/runtime/runtime_api.h"
#include "extensions/browser/api/storage/storage_api.h"
#include "extensions/browser/api/system_cpu/system_cpu_api.h"
#include "extensions/browser/api/system_memory/system_memory_api.h"
#include "extensions/browser/api/system_network/system_network_api.h"
#include "extensions/browser/api/test/test_api.h"
#include "extensions/browser/api/user_scripts/user_scripts_api.h"
#include "extensions/browser/api/web_request/web_request_api.h"
#include "extensions/browser/api/app_current_window_internal/app_current_window_internal_api.h"
#include "extensions/browser/api/app_runtime/app_runtime_api.h"
#include "extensions/browser/api/guest_view/app_view/app_view_guest_internal_api.h"
#include "extensions/browser/api/app_window/app_window_api.h"
#include "extensions/browser/api/audio/audio_api.h"
#include "extensions/browser/api/automation_internal/automation_internal_api.h"
#if BUILDFLAG(IS_CHROMEOS)
#include "extensions/browser/api/cec_private/cec_private_api.h"
#endif  // BUILDFLAG(IS_CHROMEOS)
#if BUILDFLAG(IS_CHROMEOS)
#include "extensions/browser/api/clipboard/clipboard_api.h"
#endif  // BUILDFLAG(IS_CHROMEOS)
#include "extensions/browser/api/file_system/file_system_api.h"
#include "extensions/browser/api/guest_view/guest_view_internal_api.h"
#include "extensions/browser/api/hid/hid_api.h"
#include "extensions/browser/api/networking_private/networking_private_api.h"
#include "extensions/browser/api/printer_provider/printer_provider_internal_api.h"
#include "extensions/browser/api/printer_provider/printer_provider_api.h"
#include "extensions/browser/api/serial/serial_api.h"
#include "extensions/browser/api/socket/socket_api.h"
#include "extensions/browser/api/sockets_tcp_server/sockets_tcp_server_api.h"
#include "extensions/browser/api/sockets_tcp/sockets_tcp_api.h"
#include "extensions/browser/api/sockets_udp/sockets_udp_api.h"
#include "extensions/browser/api/system_display/system_display_api.h"
#include "extensions/browser/api/system_storage/system_storage_api.h"
#include "extensions/browser/api/usb/usb_api.h"
#if BUILDFLAG(IS_CHROMEOS)
#include "extensions/browser/api/virtual_keyboard_private/virtual_keyboard_private_api.h"
#endif  // BUILDFLAG(IS_CHROMEOS)
#if BUILDFLAG(IS_CHROMEOS)
#include "extensions/browser/api/virtual_keyboard/virtual_keyboard_api.h"
#endif  // BUILDFLAG(IS_CHROMEOS)
#include "extensions/browser/api/guest_view/web_view/web_view_internal_api.h"
#include "extensions/browser/api/web_request/web_request_api.h"

#include "extensions/browser/extension_function_registry.h"

namespace extensions {
namespace api {

// static
void GeneratedFunctionRegistry::RegisterAll(ExtensionFunctionRegistry* registry) {
  constexpr ExtensionFunctionRegistry::FactoryEntry kEntries[] = {
    {
      &NewExtensionFunction<AlarmsCreateFunction>,
      AlarmsCreateFunction::static_function_name(),
      AlarmsCreateFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AlarmsGetFunction>,
      AlarmsGetFunction::static_function_name(),
      AlarmsGetFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AlarmsGetAllFunction>,
      AlarmsGetAllFunction::static_function_name(),
      AlarmsGetAllFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AlarmsClearFunction>,
      AlarmsClearFunction::static_function_name(),
      AlarmsClearFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AlarmsClearAllFunction>,
      AlarmsClearAllFunction::static_function_name(),
      AlarmsClearAllFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<DeclarativeNetRequestUpdateDynamicRulesFunction>,
      DeclarativeNetRequestUpdateDynamicRulesFunction::static_function_name(),
      DeclarativeNetRequestUpdateDynamicRulesFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<DeclarativeNetRequestGetDynamicRulesFunction>,
      DeclarativeNetRequestGetDynamicRulesFunction::static_function_name(),
      DeclarativeNetRequestGetDynamicRulesFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<DeclarativeNetRequestUpdateSessionRulesFunction>,
      DeclarativeNetRequestUpdateSessionRulesFunction::static_function_name(),
      DeclarativeNetRequestUpdateSessionRulesFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<DeclarativeNetRequestGetSessionRulesFunction>,
      DeclarativeNetRequestGetSessionRulesFunction::static_function_name(),
      DeclarativeNetRequestGetSessionRulesFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<DeclarativeNetRequestUpdateEnabledRulesetsFunction>,
      DeclarativeNetRequestUpdateEnabledRulesetsFunction::static_function_name(),
      DeclarativeNetRequestUpdateEnabledRulesetsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<DeclarativeNetRequestGetEnabledRulesetsFunction>,
      DeclarativeNetRequestGetEnabledRulesetsFunction::static_function_name(),
      DeclarativeNetRequestGetEnabledRulesetsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<DeclarativeNetRequestUpdateStaticRulesFunction>,
      DeclarativeNetRequestUpdateStaticRulesFunction::static_function_name(),
      DeclarativeNetRequestUpdateStaticRulesFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<DeclarativeNetRequestGetDisabledRuleIdsFunction>,
      DeclarativeNetRequestGetDisabledRuleIdsFunction::static_function_name(),
      DeclarativeNetRequestGetDisabledRuleIdsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<DeclarativeNetRequestGetMatchedRulesFunction>,
      DeclarativeNetRequestGetMatchedRulesFunction::static_function_name(),
      DeclarativeNetRequestGetMatchedRulesFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<DeclarativeNetRequestSetExtensionActionOptionsFunction>,
      DeclarativeNetRequestSetExtensionActionOptionsFunction::static_function_name(),
      DeclarativeNetRequestSetExtensionActionOptionsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<DeclarativeNetRequestIsRegexSupportedFunction>,
      DeclarativeNetRequestIsRegexSupportedFunction::static_function_name(),
      DeclarativeNetRequestIsRegexSupportedFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<DeclarativeNetRequestGetAvailableStaticRuleCountFunction>,
      DeclarativeNetRequestGetAvailableStaticRuleCountFunction::static_function_name(),
      DeclarativeNetRequestGetAvailableStaticRuleCountFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<DeclarativeNetRequestTestMatchOutcomeFunction>,
      DeclarativeNetRequestTestMatchOutcomeFunction::static_function_name(),
      DeclarativeNetRequestTestMatchOutcomeFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<DnsResolveFunction>,
      DnsResolveFunction::static_function_name(),
      DnsResolveFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<EventsEventAddRulesFunction>,
      EventsEventAddRulesFunction::static_function_name(),
      EventsEventAddRulesFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<EventsEventGetRulesFunction>,
      EventsEventGetRulesFunction::static_function_name(),
      EventsEventGetRulesFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<EventsEventRemoveRulesFunction>,
      EventsEventRemoveRulesFunction::static_function_name(),
      EventsEventRemoveRulesFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<I18nGetAcceptLanguagesFunction>,
      I18nGetAcceptLanguagesFunction::static_function_name(),
      I18nGetAcceptLanguagesFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<IdleQueryStateFunction>,
      IdleQueryStateFunction::static_function_name(),
      IdleQueryStateFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<IdleSetDetectionIntervalFunction>,
      IdleSetDetectionIntervalFunction::static_function_name(),
      IdleSetDetectionIntervalFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<IdleGetAutoLockDelayFunction>,
      IdleGetAutoLockDelayFunction::static_function_name(),
      IdleGetAutoLockDelayFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<ManagementGetAllFunction>,
      ManagementGetAllFunction::static_function_name(),
      ManagementGetAllFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<ManagementGetFunction>,
      ManagementGetFunction::static_function_name(),
      ManagementGetFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<ManagementGetSelfFunction>,
      ManagementGetSelfFunction::static_function_name(),
      ManagementGetSelfFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<ManagementGetPermissionWarningsByIdFunction>,
      ManagementGetPermissionWarningsByIdFunction::static_function_name(),
      ManagementGetPermissionWarningsByIdFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<ManagementGetPermissionWarningsByManifestFunction>,
      ManagementGetPermissionWarningsByManifestFunction::static_function_name(),
      ManagementGetPermissionWarningsByManifestFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<ManagementSetEnabledFunction>,
      ManagementSetEnabledFunction::static_function_name(),
      ManagementSetEnabledFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<ManagementUninstallFunction>,
      ManagementUninstallFunction::static_function_name(),
      ManagementUninstallFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<ManagementUninstallSelfFunction>,
      ManagementUninstallSelfFunction::static_function_name(),
      ManagementUninstallSelfFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<ManagementLaunchAppFunction>,
      ManagementLaunchAppFunction::static_function_name(),
      ManagementLaunchAppFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<ManagementCreateAppShortcutFunction>,
      ManagementCreateAppShortcutFunction::static_function_name(),
      ManagementCreateAppShortcutFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<ManagementSetLaunchTypeFunction>,
      ManagementSetLaunchTypeFunction::static_function_name(),
      ManagementSetLaunchTypeFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<ManagementGenerateAppForLinkFunction>,
      ManagementGenerateAppForLinkFunction::static_function_name(),
      ManagementGenerateAppForLinkFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<ManagementInstallReplacementWebAppFunction>,
      ManagementInstallReplacementWebAppFunction::static_function_name(),
      ManagementInstallReplacementWebAppFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<MetricsPrivateGetHistogramFunction>,
      MetricsPrivateGetHistogramFunction::static_function_name(),
      MetricsPrivateGetHistogramFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<MetricsPrivateGetIsCrashReportingEnabledFunction>,
      MetricsPrivateGetIsCrashReportingEnabledFunction::static_function_name(),
      MetricsPrivateGetIsCrashReportingEnabledFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<MetricsPrivateGetFieldTrialFunction>,
      MetricsPrivateGetFieldTrialFunction::static_function_name(),
      MetricsPrivateGetFieldTrialFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<MetricsPrivateGetVariationParamsFunction>,
      MetricsPrivateGetVariationParamsFunction::static_function_name(),
      MetricsPrivateGetVariationParamsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<MetricsPrivateRecordUserActionFunction>,
      MetricsPrivateRecordUserActionFunction::static_function_name(),
      MetricsPrivateRecordUserActionFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<MetricsPrivateRecordPercentageFunction>,
      MetricsPrivateRecordPercentageFunction::static_function_name(),
      MetricsPrivateRecordPercentageFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<MetricsPrivateRecordCountFunction>,
      MetricsPrivateRecordCountFunction::static_function_name(),
      MetricsPrivateRecordCountFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<MetricsPrivateRecordSmallCountFunction>,
      MetricsPrivateRecordSmallCountFunction::static_function_name(),
      MetricsPrivateRecordSmallCountFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<MetricsPrivateRecordMediumCountFunction>,
      MetricsPrivateRecordMediumCountFunction::static_function_name(),
      MetricsPrivateRecordMediumCountFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<MetricsPrivateRecordTimeFunction>,
      MetricsPrivateRecordTimeFunction::static_function_name(),
      MetricsPrivateRecordTimeFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<MetricsPrivateRecordMediumTimeFunction>,
      MetricsPrivateRecordMediumTimeFunction::static_function_name(),
      MetricsPrivateRecordMediumTimeFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<MetricsPrivateRecordLongTimeFunction>,
      MetricsPrivateRecordLongTimeFunction::static_function_name(),
      MetricsPrivateRecordLongTimeFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<MetricsPrivateRecordSparseValueWithHashMetricNameFunction>,
      MetricsPrivateRecordSparseValueWithHashMetricNameFunction::static_function_name(),
      MetricsPrivateRecordSparseValueWithHashMetricNameFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<MetricsPrivateRecordSparseValueWithPersistentHashFunction>,
      MetricsPrivateRecordSparseValueWithPersistentHashFunction::static_function_name(),
      MetricsPrivateRecordSparseValueWithPersistentHashFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<MetricsPrivateRecordSparseValueFunction>,
      MetricsPrivateRecordSparseValueFunction::static_function_name(),
      MetricsPrivateRecordSparseValueFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<MetricsPrivateRecordValueFunction>,
      MetricsPrivateRecordValueFunction::static_function_name(),
      MetricsPrivateRecordValueFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<MetricsPrivateRecordBooleanFunction>,
      MetricsPrivateRecordBooleanFunction::static_function_name(),
      MetricsPrivateRecordBooleanFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<MetricsPrivateRecordEnumerationValueFunction>,
      MetricsPrivateRecordEnumerationValueFunction::static_function_name(),
      MetricsPrivateRecordEnumerationValueFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<OffscreenCreateDocumentFunction>,
      OffscreenCreateDocumentFunction::static_function_name(),
      OffscreenCreateDocumentFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<OffscreenCloseDocumentFunction>,
      OffscreenCloseDocumentFunction::static_function_name(),
      OffscreenCloseDocumentFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<OffscreenHasDocumentFunction>,
      OffscreenHasDocumentFunction::static_function_name(),
      OffscreenHasDocumentFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<PowerRequestKeepAwakeFunction>,
      PowerRequestKeepAwakeFunction::static_function_name(),
      PowerRequestKeepAwakeFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<PowerReleaseKeepAwakeFunction>,
      PowerReleaseKeepAwakeFunction::static_function_name(),
      PowerReleaseKeepAwakeFunction::static_histogram_value(),
    },
    #if BUILDFLAG(IS_CHROMEOS)
    {
      &NewExtensionFunction<PowerReportActivityFunction>,
      PowerReportActivityFunction::static_function_name(),
      PowerReportActivityFunction::static_histogram_value(),
    },
    #endif  // BUILDFLAG(IS_CHROMEOS)
    {
      &NewExtensionFunction<RuntimeGetBackgroundPageFunction>,
      RuntimeGetBackgroundPageFunction::static_function_name(),
      RuntimeGetBackgroundPageFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<RuntimeOpenOptionsPageFunction>,
      RuntimeOpenOptionsPageFunction::static_function_name(),
      RuntimeOpenOptionsPageFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<RuntimeSetUninstallURLFunction>,
      RuntimeSetUninstallURLFunction::static_function_name(),
      RuntimeSetUninstallURLFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<RuntimeReloadFunction>,
      RuntimeReloadFunction::static_function_name(),
      RuntimeReloadFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<RuntimeRequestUpdateCheckFunction>,
      RuntimeRequestUpdateCheckFunction::static_function_name(),
      RuntimeRequestUpdateCheckFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<RuntimeRestartFunction>,
      RuntimeRestartFunction::static_function_name(),
      RuntimeRestartFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<RuntimeRestartAfterDelayFunction>,
      RuntimeRestartAfterDelayFunction::static_function_name(),
      RuntimeRestartAfterDelayFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<RuntimeGetPlatformInfoFunction>,
      RuntimeGetPlatformInfoFunction::static_function_name(),
      RuntimeGetPlatformInfoFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<RuntimeGetPackageDirectoryEntryFunction>,
      RuntimeGetPackageDirectoryEntryFunction::static_function_name(),
      RuntimeGetPackageDirectoryEntryFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<RuntimeGetContextsFunction>,
      RuntimeGetContextsFunction::static_function_name(),
      RuntimeGetContextsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<StorageStorageAreaGetFunction>,
      StorageStorageAreaGetFunction::static_function_name(),
      StorageStorageAreaGetFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<StorageStorageAreaGetKeysFunction>,
      StorageStorageAreaGetKeysFunction::static_function_name(),
      StorageStorageAreaGetKeysFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<StorageStorageAreaGetBytesInUseFunction>,
      StorageStorageAreaGetBytesInUseFunction::static_function_name(),
      StorageStorageAreaGetBytesInUseFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<StorageStorageAreaSetFunction>,
      StorageStorageAreaSetFunction::static_function_name(),
      StorageStorageAreaSetFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<StorageStorageAreaRemoveFunction>,
      StorageStorageAreaRemoveFunction::static_function_name(),
      StorageStorageAreaRemoveFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<StorageStorageAreaClearFunction>,
      StorageStorageAreaClearFunction::static_function_name(),
      StorageStorageAreaClearFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<StorageStorageAreaSetAccessLevelFunction>,
      StorageStorageAreaSetAccessLevelFunction::static_function_name(),
      StorageStorageAreaSetAccessLevelFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SystemCpuGetInfoFunction>,
      SystemCpuGetInfoFunction::static_function_name(),
      SystemCpuGetInfoFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SystemMemoryGetInfoFunction>,
      SystemMemoryGetInfoFunction::static_function_name(),
      SystemMemoryGetInfoFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SystemNetworkGetNetworkInterfacesFunction>,
      SystemNetworkGetNetworkInterfacesFunction::static_function_name(),
      SystemNetworkGetNetworkInterfacesFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<TestGetConfigFunction>,
      TestGetConfigFunction::static_function_name(),
      TestGetConfigFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<TestNotifyFailFunction>,
      TestNotifyFailFunction::static_function_name(),
      TestNotifyFailFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<TestNotifyPassFunction>,
      TestNotifyPassFunction::static_function_name(),
      TestNotifyPassFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<TestLogFunction>,
      TestLogFunction::static_function_name(),
      TestLogFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<TestOpenFileUrlFunction>,
      TestOpenFileUrlFunction::static_function_name(),
      TestOpenFileUrlFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<TestSendMessageFunction>,
      TestSendMessageFunction::static_function_name(),
      TestSendMessageFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<TestSendScriptResultFunction>,
      TestSendScriptResultFunction::static_function_name(),
      TestSendScriptResultFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<TestWaitForRoundTripFunction>,
      TestWaitForRoundTripFunction::static_function_name(),
      TestWaitForRoundTripFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<UserScriptsRegisterFunction>,
      UserScriptsRegisterFunction::static_function_name(),
      UserScriptsRegisterFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<UserScriptsGetScriptsFunction>,
      UserScriptsGetScriptsFunction::static_function_name(),
      UserScriptsGetScriptsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<UserScriptsUnregisterFunction>,
      UserScriptsUnregisterFunction::static_function_name(),
      UserScriptsUnregisterFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<UserScriptsUpdateFunction>,
      UserScriptsUpdateFunction::static_function_name(),
      UserScriptsUpdateFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<UserScriptsExecuteFunction>,
      UserScriptsExecuteFunction::static_function_name(),
      UserScriptsExecuteFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<UserScriptsConfigureWorldFunction>,
      UserScriptsConfigureWorldFunction::static_function_name(),
      UserScriptsConfigureWorldFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<UserScriptsGetWorldConfigurationsFunction>,
      UserScriptsGetWorldConfigurationsFunction::static_function_name(),
      UserScriptsGetWorldConfigurationsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<UserScriptsResetWorldConfigurationFunction>,
      UserScriptsResetWorldConfigurationFunction::static_function_name(),
      UserScriptsResetWorldConfigurationFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebRequestHandlerBehaviorChangedFunction>,
      WebRequestHandlerBehaviorChangedFunction::static_function_name(),
      WebRequestHandlerBehaviorChangedFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AppCurrentWindowInternalFocusFunction>,
      AppCurrentWindowInternalFocusFunction::static_function_name(),
      AppCurrentWindowInternalFocusFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AppCurrentWindowInternalFullscreenFunction>,
      AppCurrentWindowInternalFullscreenFunction::static_function_name(),
      AppCurrentWindowInternalFullscreenFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AppCurrentWindowInternalMinimizeFunction>,
      AppCurrentWindowInternalMinimizeFunction::static_function_name(),
      AppCurrentWindowInternalMinimizeFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AppCurrentWindowInternalMaximizeFunction>,
      AppCurrentWindowInternalMaximizeFunction::static_function_name(),
      AppCurrentWindowInternalMaximizeFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AppCurrentWindowInternalRestoreFunction>,
      AppCurrentWindowInternalRestoreFunction::static_function_name(),
      AppCurrentWindowInternalRestoreFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AppCurrentWindowInternalDrawAttentionFunction>,
      AppCurrentWindowInternalDrawAttentionFunction::static_function_name(),
      AppCurrentWindowInternalDrawAttentionFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AppCurrentWindowInternalClearAttentionFunction>,
      AppCurrentWindowInternalClearAttentionFunction::static_function_name(),
      AppCurrentWindowInternalClearAttentionFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AppCurrentWindowInternalShowFunction>,
      AppCurrentWindowInternalShowFunction::static_function_name(),
      AppCurrentWindowInternalShowFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AppCurrentWindowInternalHideFunction>,
      AppCurrentWindowInternalHideFunction::static_function_name(),
      AppCurrentWindowInternalHideFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AppCurrentWindowInternalSetBoundsFunction>,
      AppCurrentWindowInternalSetBoundsFunction::static_function_name(),
      AppCurrentWindowInternalSetBoundsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AppCurrentWindowInternalSetSizeConstraintsFunction>,
      AppCurrentWindowInternalSetSizeConstraintsFunction::static_function_name(),
      AppCurrentWindowInternalSetSizeConstraintsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AppCurrentWindowInternalSetIconFunction>,
      AppCurrentWindowInternalSetIconFunction::static_function_name(),
      AppCurrentWindowInternalSetIconFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AppCurrentWindowInternalSetShapeFunction>,
      AppCurrentWindowInternalSetShapeFunction::static_function_name(),
      AppCurrentWindowInternalSetShapeFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AppCurrentWindowInternalSetAlwaysOnTopFunction>,
      AppCurrentWindowInternalSetAlwaysOnTopFunction::static_function_name(),
      AppCurrentWindowInternalSetAlwaysOnTopFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AppCurrentWindowInternalSetVisibleOnAllWorkspacesFunction>,
      AppCurrentWindowInternalSetVisibleOnAllWorkspacesFunction::static_function_name(),
      AppCurrentWindowInternalSetVisibleOnAllWorkspacesFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AppCurrentWindowInternalSetActivateOnPointerFunction>,
      AppCurrentWindowInternalSetActivateOnPointerFunction::static_function_name(),
      AppCurrentWindowInternalSetActivateOnPointerFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AppViewGuestInternalAttachFrameFunction>,
      AppViewGuestInternalAttachFrameFunction::static_function_name(),
      AppViewGuestInternalAttachFrameFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AppViewGuestInternalDenyRequestFunction>,
      AppViewGuestInternalDenyRequestFunction::static_function_name(),
      AppViewGuestInternalDenyRequestFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AppWindowCreateFunction>,
      AppWindowCreateFunction::static_function_name(),
      AppWindowCreateFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AudioGetDevicesFunction>,
      AudioGetDevicesFunction::static_function_name(),
      AudioGetDevicesFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AudioSetActiveDevicesFunction>,
      AudioSetActiveDevicesFunction::static_function_name(),
      AudioSetActiveDevicesFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AudioSetPropertiesFunction>,
      AudioSetPropertiesFunction::static_function_name(),
      AudioSetPropertiesFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AudioGetMuteFunction>,
      AudioGetMuteFunction::static_function_name(),
      AudioGetMuteFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AudioSetMuteFunction>,
      AudioSetMuteFunction::static_function_name(),
      AudioSetMuteFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutomationInternalEnableTreeFunction>,
      AutomationInternalEnableTreeFunction::static_function_name(),
      AutomationInternalEnableTreeFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutomationInternalEnableDesktopFunction>,
      AutomationInternalEnableDesktopFunction::static_function_name(),
      AutomationInternalEnableDesktopFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutomationInternalDisableDesktopFunction>,
      AutomationInternalDisableDesktopFunction::static_function_name(),
      AutomationInternalDisableDesktopFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<AutomationInternalPerformActionFunction>,
      AutomationInternalPerformActionFunction::static_function_name(),
      AutomationInternalPerformActionFunction::static_histogram_value(),
    },
    #if BUILDFLAG(IS_CHROMEOS)
    {
      &NewExtensionFunction<CecPrivateSendStandByFunction>,
      CecPrivateSendStandByFunction::static_function_name(),
      CecPrivateSendStandByFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<CecPrivateSendWakeUpFunction>,
      CecPrivateSendWakeUpFunction::static_function_name(),
      CecPrivateSendWakeUpFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<CecPrivateQueryDisplayCecPowerStateFunction>,
      CecPrivateQueryDisplayCecPowerStateFunction::static_function_name(),
      CecPrivateQueryDisplayCecPowerStateFunction::static_histogram_value(),
    },
    #endif  // BUILDFLAG(IS_CHROMEOS)
    #if BUILDFLAG(IS_CHROMEOS)
    {
      &NewExtensionFunction<ClipboardSetImageDataFunction>,
      ClipboardSetImageDataFunction::static_function_name(),
      ClipboardSetImageDataFunction::static_histogram_value(),
    },
    #endif  // BUILDFLAG(IS_CHROMEOS)
    {
      &NewExtensionFunction<FileSystemGetDisplayPathFunction>,
      FileSystemGetDisplayPathFunction::static_function_name(),
      FileSystemGetDisplayPathFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<FileSystemGetWritableEntryFunction>,
      FileSystemGetWritableEntryFunction::static_function_name(),
      FileSystemGetWritableEntryFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<FileSystemIsWritableEntryFunction>,
      FileSystemIsWritableEntryFunction::static_function_name(),
      FileSystemIsWritableEntryFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<FileSystemChooseEntryFunction>,
      FileSystemChooseEntryFunction::static_function_name(),
      FileSystemChooseEntryFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<FileSystemRestoreEntryFunction>,
      FileSystemRestoreEntryFunction::static_function_name(),
      FileSystemRestoreEntryFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<FileSystemIsRestorableFunction>,
      FileSystemIsRestorableFunction::static_function_name(),
      FileSystemIsRestorableFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<FileSystemRetainEntryFunction>,
      FileSystemRetainEntryFunction::static_function_name(),
      FileSystemRetainEntryFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<FileSystemRequestFileSystemFunction>,
      FileSystemRequestFileSystemFunction::static_function_name(),
      FileSystemRequestFileSystemFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<FileSystemGetVolumeListFunction>,
      FileSystemGetVolumeListFunction::static_function_name(),
      FileSystemGetVolumeListFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<GuestViewInternalCreateGuestFunction>,
      GuestViewInternalCreateGuestFunction::static_function_name(),
      GuestViewInternalCreateGuestFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<GuestViewInternalDestroyUnattachedGuestFunction>,
      GuestViewInternalDestroyUnattachedGuestFunction::static_function_name(),
      GuestViewInternalDestroyUnattachedGuestFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<GuestViewInternalSetSizeFunction>,
      GuestViewInternalSetSizeFunction::static_function_name(),
      GuestViewInternalSetSizeFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<HidGetDevicesFunction>,
      HidGetDevicesFunction::static_function_name(),
      HidGetDevicesFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<HidConnectFunction>,
      HidConnectFunction::static_function_name(),
      HidConnectFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<HidDisconnectFunction>,
      HidDisconnectFunction::static_function_name(),
      HidDisconnectFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<HidReceiveFunction>,
      HidReceiveFunction::static_function_name(),
      HidReceiveFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<HidSendFunction>,
      HidSendFunction::static_function_name(),
      HidSendFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<HidReceiveFeatureReportFunction>,
      HidReceiveFeatureReportFunction::static_function_name(),
      HidReceiveFeatureReportFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<HidSendFeatureReportFunction>,
      HidSendFeatureReportFunction::static_function_name(),
      HidSendFeatureReportFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<NetworkingPrivateGetPropertiesFunction>,
      NetworkingPrivateGetPropertiesFunction::static_function_name(),
      NetworkingPrivateGetPropertiesFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<NetworkingPrivateGetManagedPropertiesFunction>,
      NetworkingPrivateGetManagedPropertiesFunction::static_function_name(),
      NetworkingPrivateGetManagedPropertiesFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<NetworkingPrivateGetStateFunction>,
      NetworkingPrivateGetStateFunction::static_function_name(),
      NetworkingPrivateGetStateFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<NetworkingPrivateSetPropertiesFunction>,
      NetworkingPrivateSetPropertiesFunction::static_function_name(),
      NetworkingPrivateSetPropertiesFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<NetworkingPrivateCreateNetworkFunction>,
      NetworkingPrivateCreateNetworkFunction::static_function_name(),
      NetworkingPrivateCreateNetworkFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<NetworkingPrivateForgetNetworkFunction>,
      NetworkingPrivateForgetNetworkFunction::static_function_name(),
      NetworkingPrivateForgetNetworkFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<NetworkingPrivateGetNetworksFunction>,
      NetworkingPrivateGetNetworksFunction::static_function_name(),
      NetworkingPrivateGetNetworksFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<NetworkingPrivateGetVisibleNetworksFunction>,
      NetworkingPrivateGetVisibleNetworksFunction::static_function_name(),
      NetworkingPrivateGetVisibleNetworksFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<NetworkingPrivateGetEnabledNetworkTypesFunction>,
      NetworkingPrivateGetEnabledNetworkTypesFunction::static_function_name(),
      NetworkingPrivateGetEnabledNetworkTypesFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<NetworkingPrivateGetDeviceStatesFunction>,
      NetworkingPrivateGetDeviceStatesFunction::static_function_name(),
      NetworkingPrivateGetDeviceStatesFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<NetworkingPrivateEnableNetworkTypeFunction>,
      NetworkingPrivateEnableNetworkTypeFunction::static_function_name(),
      NetworkingPrivateEnableNetworkTypeFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<NetworkingPrivateDisableNetworkTypeFunction>,
      NetworkingPrivateDisableNetworkTypeFunction::static_function_name(),
      NetworkingPrivateDisableNetworkTypeFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<NetworkingPrivateRequestNetworkScanFunction>,
      NetworkingPrivateRequestNetworkScanFunction::static_function_name(),
      NetworkingPrivateRequestNetworkScanFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<NetworkingPrivateStartConnectFunction>,
      NetworkingPrivateStartConnectFunction::static_function_name(),
      NetworkingPrivateStartConnectFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<NetworkingPrivateStartDisconnectFunction>,
      NetworkingPrivateStartDisconnectFunction::static_function_name(),
      NetworkingPrivateStartDisconnectFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<NetworkingPrivateStartActivateFunction>,
      NetworkingPrivateStartActivateFunction::static_function_name(),
      NetworkingPrivateStartActivateFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<NetworkingPrivateGetCaptivePortalStatusFunction>,
      NetworkingPrivateGetCaptivePortalStatusFunction::static_function_name(),
      NetworkingPrivateGetCaptivePortalStatusFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<NetworkingPrivateUnlockCellularSimFunction>,
      NetworkingPrivateUnlockCellularSimFunction::static_function_name(),
      NetworkingPrivateUnlockCellularSimFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<NetworkingPrivateSetCellularSimStateFunction>,
      NetworkingPrivateSetCellularSimStateFunction::static_function_name(),
      NetworkingPrivateSetCellularSimStateFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<NetworkingPrivateSelectCellularMobileNetworkFunction>,
      NetworkingPrivateSelectCellularMobileNetworkFunction::static_function_name(),
      NetworkingPrivateSelectCellularMobileNetworkFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<NetworkingPrivateGetGlobalPolicyFunction>,
      NetworkingPrivateGetGlobalPolicyFunction::static_function_name(),
      NetworkingPrivateGetGlobalPolicyFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<NetworkingPrivateGetCertificateListsFunction>,
      NetworkingPrivateGetCertificateListsFunction::static_function_name(),
      NetworkingPrivateGetCertificateListsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<PrinterProviderInternalReportPrintersFunction>,
      PrinterProviderInternalReportPrintersFunction::static_function_name(),
      PrinterProviderInternalReportPrintersFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<PrinterProviderInternalReportUsbPrinterInfoFunction>,
      PrinterProviderInternalReportUsbPrinterInfoFunction::static_function_name(),
      PrinterProviderInternalReportUsbPrinterInfoFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<PrinterProviderInternalReportPrinterCapabilityFunction>,
      PrinterProviderInternalReportPrinterCapabilityFunction::static_function_name(),
      PrinterProviderInternalReportPrinterCapabilityFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<PrinterProviderInternalReportPrintResultFunction>,
      PrinterProviderInternalReportPrintResultFunction::static_function_name(),
      PrinterProviderInternalReportPrintResultFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<PrinterProviderInternalGetPrintDataFunction>,
      PrinterProviderInternalGetPrintDataFunction::static_function_name(),
      PrinterProviderInternalGetPrintDataFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SerialGetDevicesFunction>,
      SerialGetDevicesFunction::static_function_name(),
      SerialGetDevicesFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SerialConnectFunction>,
      SerialConnectFunction::static_function_name(),
      SerialConnectFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SerialUpdateFunction>,
      SerialUpdateFunction::static_function_name(),
      SerialUpdateFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SerialDisconnectFunction>,
      SerialDisconnectFunction::static_function_name(),
      SerialDisconnectFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SerialSetPausedFunction>,
      SerialSetPausedFunction::static_function_name(),
      SerialSetPausedFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SerialGetInfoFunction>,
      SerialGetInfoFunction::static_function_name(),
      SerialGetInfoFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SerialGetConnectionsFunction>,
      SerialGetConnectionsFunction::static_function_name(),
      SerialGetConnectionsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SerialSendFunction>,
      SerialSendFunction::static_function_name(),
      SerialSendFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SerialFlushFunction>,
      SerialFlushFunction::static_function_name(),
      SerialFlushFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SerialGetControlSignalsFunction>,
      SerialGetControlSignalsFunction::static_function_name(),
      SerialGetControlSignalsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SerialSetControlSignalsFunction>,
      SerialSetControlSignalsFunction::static_function_name(),
      SerialSetControlSignalsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SerialSetBreakFunction>,
      SerialSetBreakFunction::static_function_name(),
      SerialSetBreakFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SerialClearBreakFunction>,
      SerialClearBreakFunction::static_function_name(),
      SerialClearBreakFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SocketCreateFunction>,
      SocketCreateFunction::static_function_name(),
      SocketCreateFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SocketDestroyFunction>,
      SocketDestroyFunction::static_function_name(),
      SocketDestroyFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SocketConnectFunction>,
      SocketConnectFunction::static_function_name(),
      SocketConnectFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SocketBindFunction>,
      SocketBindFunction::static_function_name(),
      SocketBindFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SocketDisconnectFunction>,
      SocketDisconnectFunction::static_function_name(),
      SocketDisconnectFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SocketReadFunction>,
      SocketReadFunction::static_function_name(),
      SocketReadFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SocketWriteFunction>,
      SocketWriteFunction::static_function_name(),
      SocketWriteFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SocketRecvFromFunction>,
      SocketRecvFromFunction::static_function_name(),
      SocketRecvFromFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SocketSendToFunction>,
      SocketSendToFunction::static_function_name(),
      SocketSendToFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SocketListenFunction>,
      SocketListenFunction::static_function_name(),
      SocketListenFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SocketAcceptFunction>,
      SocketAcceptFunction::static_function_name(),
      SocketAcceptFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SocketSetKeepAliveFunction>,
      SocketSetKeepAliveFunction::static_function_name(),
      SocketSetKeepAliveFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SocketSetNoDelayFunction>,
      SocketSetNoDelayFunction::static_function_name(),
      SocketSetNoDelayFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SocketGetInfoFunction>,
      SocketGetInfoFunction::static_function_name(),
      SocketGetInfoFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SocketGetNetworkListFunction>,
      SocketGetNetworkListFunction::static_function_name(),
      SocketGetNetworkListFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SocketJoinGroupFunction>,
      SocketJoinGroupFunction::static_function_name(),
      SocketJoinGroupFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SocketLeaveGroupFunction>,
      SocketLeaveGroupFunction::static_function_name(),
      SocketLeaveGroupFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SocketSetMulticastTimeToLiveFunction>,
      SocketSetMulticastTimeToLiveFunction::static_function_name(),
      SocketSetMulticastTimeToLiveFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SocketSetMulticastLoopbackModeFunction>,
      SocketSetMulticastLoopbackModeFunction::static_function_name(),
      SocketSetMulticastLoopbackModeFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SocketGetJoinedGroupsFunction>,
      SocketGetJoinedGroupsFunction::static_function_name(),
      SocketGetJoinedGroupsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SocketSecureFunction>,
      SocketSecureFunction::static_function_name(),
      SocketSecureFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SocketsTcpServerCreateFunction>,
      SocketsTcpServerCreateFunction::static_function_name(),
      SocketsTcpServerCreateFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SocketsTcpServerUpdateFunction>,
      SocketsTcpServerUpdateFunction::static_function_name(),
      SocketsTcpServerUpdateFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SocketsTcpServerSetPausedFunction>,
      SocketsTcpServerSetPausedFunction::static_function_name(),
      SocketsTcpServerSetPausedFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SocketsTcpServerListenFunction>,
      SocketsTcpServerListenFunction::static_function_name(),
      SocketsTcpServerListenFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SocketsTcpServerDisconnectFunction>,
      SocketsTcpServerDisconnectFunction::static_function_name(),
      SocketsTcpServerDisconnectFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SocketsTcpServerCloseFunction>,
      SocketsTcpServerCloseFunction::static_function_name(),
      SocketsTcpServerCloseFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SocketsTcpServerGetInfoFunction>,
      SocketsTcpServerGetInfoFunction::static_function_name(),
      SocketsTcpServerGetInfoFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SocketsTcpServerGetSocketsFunction>,
      SocketsTcpServerGetSocketsFunction::static_function_name(),
      SocketsTcpServerGetSocketsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SocketsTcpCreateFunction>,
      SocketsTcpCreateFunction::static_function_name(),
      SocketsTcpCreateFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SocketsTcpUpdateFunction>,
      SocketsTcpUpdateFunction::static_function_name(),
      SocketsTcpUpdateFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SocketsTcpSetPausedFunction>,
      SocketsTcpSetPausedFunction::static_function_name(),
      SocketsTcpSetPausedFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SocketsTcpSetKeepAliveFunction>,
      SocketsTcpSetKeepAliveFunction::static_function_name(),
      SocketsTcpSetKeepAliveFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SocketsTcpSetNoDelayFunction>,
      SocketsTcpSetNoDelayFunction::static_function_name(),
      SocketsTcpSetNoDelayFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SocketsTcpConnectFunction>,
      SocketsTcpConnectFunction::static_function_name(),
      SocketsTcpConnectFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SocketsTcpDisconnectFunction>,
      SocketsTcpDisconnectFunction::static_function_name(),
      SocketsTcpDisconnectFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SocketsTcpSecureFunction>,
      SocketsTcpSecureFunction::static_function_name(),
      SocketsTcpSecureFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SocketsTcpSendFunction>,
      SocketsTcpSendFunction::static_function_name(),
      SocketsTcpSendFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SocketsTcpCloseFunction>,
      SocketsTcpCloseFunction::static_function_name(),
      SocketsTcpCloseFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SocketsTcpGetInfoFunction>,
      SocketsTcpGetInfoFunction::static_function_name(),
      SocketsTcpGetInfoFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SocketsTcpGetSocketsFunction>,
      SocketsTcpGetSocketsFunction::static_function_name(),
      SocketsTcpGetSocketsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SocketsUdpCreateFunction>,
      SocketsUdpCreateFunction::static_function_name(),
      SocketsUdpCreateFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SocketsUdpUpdateFunction>,
      SocketsUdpUpdateFunction::static_function_name(),
      SocketsUdpUpdateFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SocketsUdpSetPausedFunction>,
      SocketsUdpSetPausedFunction::static_function_name(),
      SocketsUdpSetPausedFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SocketsUdpBindFunction>,
      SocketsUdpBindFunction::static_function_name(),
      SocketsUdpBindFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SocketsUdpSendFunction>,
      SocketsUdpSendFunction::static_function_name(),
      SocketsUdpSendFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SocketsUdpCloseFunction>,
      SocketsUdpCloseFunction::static_function_name(),
      SocketsUdpCloseFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SocketsUdpGetInfoFunction>,
      SocketsUdpGetInfoFunction::static_function_name(),
      SocketsUdpGetInfoFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SocketsUdpGetSocketsFunction>,
      SocketsUdpGetSocketsFunction::static_function_name(),
      SocketsUdpGetSocketsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SocketsUdpJoinGroupFunction>,
      SocketsUdpJoinGroupFunction::static_function_name(),
      SocketsUdpJoinGroupFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SocketsUdpLeaveGroupFunction>,
      SocketsUdpLeaveGroupFunction::static_function_name(),
      SocketsUdpLeaveGroupFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SocketsUdpSetMulticastTimeToLiveFunction>,
      SocketsUdpSetMulticastTimeToLiveFunction::static_function_name(),
      SocketsUdpSetMulticastTimeToLiveFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SocketsUdpSetMulticastLoopbackModeFunction>,
      SocketsUdpSetMulticastLoopbackModeFunction::static_function_name(),
      SocketsUdpSetMulticastLoopbackModeFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SocketsUdpGetJoinedGroupsFunction>,
      SocketsUdpGetJoinedGroupsFunction::static_function_name(),
      SocketsUdpGetJoinedGroupsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SocketsUdpSetBroadcastFunction>,
      SocketsUdpSetBroadcastFunction::static_function_name(),
      SocketsUdpSetBroadcastFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SystemDisplayGetInfoFunction>,
      SystemDisplayGetInfoFunction::static_function_name(),
      SystemDisplayGetInfoFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SystemDisplayGetDisplayLayoutFunction>,
      SystemDisplayGetDisplayLayoutFunction::static_function_name(),
      SystemDisplayGetDisplayLayoutFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SystemDisplaySetDisplayPropertiesFunction>,
      SystemDisplaySetDisplayPropertiesFunction::static_function_name(),
      SystemDisplaySetDisplayPropertiesFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SystemDisplaySetDisplayLayoutFunction>,
      SystemDisplaySetDisplayLayoutFunction::static_function_name(),
      SystemDisplaySetDisplayLayoutFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SystemDisplayEnableUnifiedDesktopFunction>,
      SystemDisplayEnableUnifiedDesktopFunction::static_function_name(),
      SystemDisplayEnableUnifiedDesktopFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SystemDisplayOverscanCalibrationStartFunction>,
      SystemDisplayOverscanCalibrationStartFunction::static_function_name(),
      SystemDisplayOverscanCalibrationStartFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SystemDisplayOverscanCalibrationAdjustFunction>,
      SystemDisplayOverscanCalibrationAdjustFunction::static_function_name(),
      SystemDisplayOverscanCalibrationAdjustFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SystemDisplayOverscanCalibrationResetFunction>,
      SystemDisplayOverscanCalibrationResetFunction::static_function_name(),
      SystemDisplayOverscanCalibrationResetFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SystemDisplayOverscanCalibrationCompleteFunction>,
      SystemDisplayOverscanCalibrationCompleteFunction::static_function_name(),
      SystemDisplayOverscanCalibrationCompleteFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SystemDisplayShowNativeTouchCalibrationFunction>,
      SystemDisplayShowNativeTouchCalibrationFunction::static_function_name(),
      SystemDisplayShowNativeTouchCalibrationFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SystemDisplayStartCustomTouchCalibrationFunction>,
      SystemDisplayStartCustomTouchCalibrationFunction::static_function_name(),
      SystemDisplayStartCustomTouchCalibrationFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SystemDisplayCompleteCustomTouchCalibrationFunction>,
      SystemDisplayCompleteCustomTouchCalibrationFunction::static_function_name(),
      SystemDisplayCompleteCustomTouchCalibrationFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SystemDisplayClearTouchCalibrationFunction>,
      SystemDisplayClearTouchCalibrationFunction::static_function_name(),
      SystemDisplayClearTouchCalibrationFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SystemDisplaySetMirrorModeFunction>,
      SystemDisplaySetMirrorModeFunction::static_function_name(),
      SystemDisplaySetMirrorModeFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SystemStorageGetInfoFunction>,
      SystemStorageGetInfoFunction::static_function_name(),
      SystemStorageGetInfoFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SystemStorageEjectDeviceFunction>,
      SystemStorageEjectDeviceFunction::static_function_name(),
      SystemStorageEjectDeviceFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<SystemStorageGetAvailableCapacityFunction>,
      SystemStorageGetAvailableCapacityFunction::static_function_name(),
      SystemStorageGetAvailableCapacityFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<UsbGetDevicesFunction>,
      UsbGetDevicesFunction::static_function_name(),
      UsbGetDevicesFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<UsbGetUserSelectedDevicesFunction>,
      UsbGetUserSelectedDevicesFunction::static_function_name(),
      UsbGetUserSelectedDevicesFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<UsbGetConfigurationsFunction>,
      UsbGetConfigurationsFunction::static_function_name(),
      UsbGetConfigurationsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<UsbRequestAccessFunction>,
      UsbRequestAccessFunction::static_function_name(),
      UsbRequestAccessFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<UsbOpenDeviceFunction>,
      UsbOpenDeviceFunction::static_function_name(),
      UsbOpenDeviceFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<UsbFindDevicesFunction>,
      UsbFindDevicesFunction::static_function_name(),
      UsbFindDevicesFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<UsbCloseDeviceFunction>,
      UsbCloseDeviceFunction::static_function_name(),
      UsbCloseDeviceFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<UsbSetConfigurationFunction>,
      UsbSetConfigurationFunction::static_function_name(),
      UsbSetConfigurationFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<UsbGetConfigurationFunction>,
      UsbGetConfigurationFunction::static_function_name(),
      UsbGetConfigurationFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<UsbListInterfacesFunction>,
      UsbListInterfacesFunction::static_function_name(),
      UsbListInterfacesFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<UsbClaimInterfaceFunction>,
      UsbClaimInterfaceFunction::static_function_name(),
      UsbClaimInterfaceFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<UsbReleaseInterfaceFunction>,
      UsbReleaseInterfaceFunction::static_function_name(),
      UsbReleaseInterfaceFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<UsbSetInterfaceAlternateSettingFunction>,
      UsbSetInterfaceAlternateSettingFunction::static_function_name(),
      UsbSetInterfaceAlternateSettingFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<UsbControlTransferFunction>,
      UsbControlTransferFunction::static_function_name(),
      UsbControlTransferFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<UsbBulkTransferFunction>,
      UsbBulkTransferFunction::static_function_name(),
      UsbBulkTransferFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<UsbInterruptTransferFunction>,
      UsbInterruptTransferFunction::static_function_name(),
      UsbInterruptTransferFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<UsbIsochronousTransferFunction>,
      UsbIsochronousTransferFunction::static_function_name(),
      UsbIsochronousTransferFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<UsbResetDeviceFunction>,
      UsbResetDeviceFunction::static_function_name(),
      UsbResetDeviceFunction::static_histogram_value(),
    },
    #if BUILDFLAG(IS_CHROMEOS)
    {
      &NewExtensionFunction<VirtualKeyboardPrivateInsertTextFunction>,
      VirtualKeyboardPrivateInsertTextFunction::static_function_name(),
      VirtualKeyboardPrivateInsertTextFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<VirtualKeyboardPrivateSendKeyEventFunction>,
      VirtualKeyboardPrivateSendKeyEventFunction::static_function_name(),
      VirtualKeyboardPrivateSendKeyEventFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<VirtualKeyboardPrivateHideKeyboardFunction>,
      VirtualKeyboardPrivateHideKeyboardFunction::static_function_name(),
      VirtualKeyboardPrivateHideKeyboardFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<VirtualKeyboardPrivateSetHotrodKeyboardFunction>,
      VirtualKeyboardPrivateSetHotrodKeyboardFunction::static_function_name(),
      VirtualKeyboardPrivateSetHotrodKeyboardFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<VirtualKeyboardPrivateLockKeyboardFunction>,
      VirtualKeyboardPrivateLockKeyboardFunction::static_function_name(),
      VirtualKeyboardPrivateLockKeyboardFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<VirtualKeyboardPrivateKeyboardLoadedFunction>,
      VirtualKeyboardPrivateKeyboardLoadedFunction::static_function_name(),
      VirtualKeyboardPrivateKeyboardLoadedFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<VirtualKeyboardPrivateGetKeyboardConfigFunction>,
      VirtualKeyboardPrivateGetKeyboardConfigFunction::static_function_name(),
      VirtualKeyboardPrivateGetKeyboardConfigFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<VirtualKeyboardPrivateOpenSettingsFunction>,
      VirtualKeyboardPrivateOpenSettingsFunction::static_function_name(),
      VirtualKeyboardPrivateOpenSettingsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<VirtualKeyboardPrivateOpenSuggestionSettingsFunction>,
      VirtualKeyboardPrivateOpenSuggestionSettingsFunction::static_function_name(),
      VirtualKeyboardPrivateOpenSuggestionSettingsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<VirtualKeyboardPrivateSetContainerBehaviorFunction>,
      VirtualKeyboardPrivateSetContainerBehaviorFunction::static_function_name(),
      VirtualKeyboardPrivateSetContainerBehaviorFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<VirtualKeyboardPrivateSetDraggableAreaFunction>,
      VirtualKeyboardPrivateSetDraggableAreaFunction::static_function_name(),
      VirtualKeyboardPrivateSetDraggableAreaFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<VirtualKeyboardPrivateSetKeyboardStateFunction>,
      VirtualKeyboardPrivateSetKeyboardStateFunction::static_function_name(),
      VirtualKeyboardPrivateSetKeyboardStateFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<VirtualKeyboardPrivateSetOccludedBoundsFunction>,
      VirtualKeyboardPrivateSetOccludedBoundsFunction::static_function_name(),
      VirtualKeyboardPrivateSetOccludedBoundsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<VirtualKeyboardPrivateSetHitTestBoundsFunction>,
      VirtualKeyboardPrivateSetHitTestBoundsFunction::static_function_name(),
      VirtualKeyboardPrivateSetHitTestBoundsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<VirtualKeyboardPrivateSetAreaToRemainOnScreenFunction>,
      VirtualKeyboardPrivateSetAreaToRemainOnScreenFunction::static_function_name(),
      VirtualKeyboardPrivateSetAreaToRemainOnScreenFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<VirtualKeyboardPrivateSetWindowBoundsInScreenFunction>,
      VirtualKeyboardPrivateSetWindowBoundsInScreenFunction::static_function_name(),
      VirtualKeyboardPrivateSetWindowBoundsInScreenFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<VirtualKeyboardPrivateGetClipboardHistoryFunction>,
      VirtualKeyboardPrivateGetClipboardHistoryFunction::static_function_name(),
      VirtualKeyboardPrivateGetClipboardHistoryFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<VirtualKeyboardPrivatePasteClipboardItemFunction>,
      VirtualKeyboardPrivatePasteClipboardItemFunction::static_function_name(),
      VirtualKeyboardPrivatePasteClipboardItemFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<VirtualKeyboardPrivateDeleteClipboardItemFunction>,
      VirtualKeyboardPrivateDeleteClipboardItemFunction::static_function_name(),
      VirtualKeyboardPrivateDeleteClipboardItemFunction::static_histogram_value(),
    },
    #endif  // BUILDFLAG(IS_CHROMEOS)
    #if BUILDFLAG(IS_CHROMEOS)
    {
      &NewExtensionFunction<VirtualKeyboardRestrictFeaturesFunction>,
      VirtualKeyboardRestrictFeaturesFunction::static_function_name(),
      VirtualKeyboardRestrictFeaturesFunction::static_histogram_value(),
    },
    #endif  // BUILDFLAG(IS_CHROMEOS)
    {
      &NewExtensionFunction<WebViewInternalGetAudioStateFunction>,
      WebViewInternalGetAudioStateFunction::static_function_name(),
      WebViewInternalGetAudioStateFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebViewInternalSetAudioMutedFunction>,
      WebViewInternalSetAudioMutedFunction::static_function_name(),
      WebViewInternalSetAudioMutedFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebViewInternalIsAudioMutedFunction>,
      WebViewInternalIsAudioMutedFunction::static_function_name(),
      WebViewInternalIsAudioMutedFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebViewInternalExecuteScriptFunction>,
      WebViewInternalExecuteScriptFunction::static_function_name(),
      WebViewInternalExecuteScriptFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebViewInternalInsertCSSFunction>,
      WebViewInternalInsertCSSFunction::static_function_name(),
      WebViewInternalInsertCSSFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebViewInternalAddContentScriptsFunction>,
      WebViewInternalAddContentScriptsFunction::static_function_name(),
      WebViewInternalAddContentScriptsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebViewInternalRemoveContentScriptsFunction>,
      WebViewInternalRemoveContentScriptsFunction::static_function_name(),
      WebViewInternalRemoveContentScriptsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebViewInternalSetZoomFunction>,
      WebViewInternalSetZoomFunction::static_function_name(),
      WebViewInternalSetZoomFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebViewInternalGetZoomFunction>,
      WebViewInternalGetZoomFunction::static_function_name(),
      WebViewInternalGetZoomFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebViewInternalSetZoomModeFunction>,
      WebViewInternalSetZoomModeFunction::static_function_name(),
      WebViewInternalSetZoomModeFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebViewInternalGetZoomModeFunction>,
      WebViewInternalGetZoomModeFunction::static_function_name(),
      WebViewInternalGetZoomModeFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebViewInternalFindFunction>,
      WebViewInternalFindFunction::static_function_name(),
      WebViewInternalFindFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebViewInternalStopFindingFunction>,
      WebViewInternalStopFindingFunction::static_function_name(),
      WebViewInternalStopFindingFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebViewInternalLoadDataWithBaseUrlFunction>,
      WebViewInternalLoadDataWithBaseUrlFunction::static_function_name(),
      WebViewInternalLoadDataWithBaseUrlFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebViewInternalGoFunction>,
      WebViewInternalGoFunction::static_function_name(),
      WebViewInternalGoFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebViewInternalOverrideUserAgentFunction>,
      WebViewInternalOverrideUserAgentFunction::static_function_name(),
      WebViewInternalOverrideUserAgentFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebViewInternalReloadFunction>,
      WebViewInternalReloadFunction::static_function_name(),
      WebViewInternalReloadFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebViewInternalSetAllowTransparencyFunction>,
      WebViewInternalSetAllowTransparencyFunction::static_function_name(),
      WebViewInternalSetAllowTransparencyFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebViewInternalSetAllowScalingFunction>,
      WebViewInternalSetAllowScalingFunction::static_function_name(),
      WebViewInternalSetAllowScalingFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebViewInternalSetNameFunction>,
      WebViewInternalSetNameFunction::static_function_name(),
      WebViewInternalSetNameFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebViewInternalSetPermissionFunction>,
      WebViewInternalSetPermissionFunction::static_function_name(),
      WebViewInternalSetPermissionFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebViewInternalNavigateFunction>,
      WebViewInternalNavigateFunction::static_function_name(),
      WebViewInternalNavigateFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebViewInternalStopFunction>,
      WebViewInternalStopFunction::static_function_name(),
      WebViewInternalStopFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebViewInternalTerminateFunction>,
      WebViewInternalTerminateFunction::static_function_name(),
      WebViewInternalTerminateFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebViewInternalCaptureVisibleRegionFunction>,
      WebViewInternalCaptureVisibleRegionFunction::static_function_name(),
      WebViewInternalCaptureVisibleRegionFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebViewInternalSetSpatialNavigationEnabledFunction>,
      WebViewInternalSetSpatialNavigationEnabledFunction::static_function_name(),
      WebViewInternalSetSpatialNavigationEnabledFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebViewInternalIsSpatialNavigationEnabledFunction>,
      WebViewInternalIsSpatialNavigationEnabledFunction::static_function_name(),
      WebViewInternalIsSpatialNavigationEnabledFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebViewInternalClearDataFunction>,
      WebViewInternalClearDataFunction::static_function_name(),
      WebViewInternalClearDataFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebRequestInternalAddEventListenerFunction>,
      WebRequestInternalAddEventListenerFunction::static_function_name(),
      WebRequestInternalAddEventListenerFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebRequestInternalEventHandledFunction>,
      WebRequestInternalEventHandledFunction::static_function_name(),
      WebRequestInternalEventHandledFunction::static_histogram_value(),
    },
  };
  for (const auto& entry : kEntries) {
      registry->Register(entry);
  }
}

}  // namespace api
}  // namespace extensions
