// extensions/common/mojom/permission_set.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "extensions/common/mojom/permission_set.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "extensions/common/mojom/permission_set.mojom-params-data.h"
#include "extensions/common/mojom/permission_set.mojom-shared-message-ids.h"

#include "extensions/common/mojom/permission_set.mojom-import-headers.h"
#include "extensions/common/mojom/permission_set.mojom-test-utils.h"


namespace extensions::mojom {
APIPermission::APIPermission()
    : id(),
      value() {}

APIPermission::APIPermission(
    ::extensions::mojom::APIPermissionID id_in,
    std::optional<::base::Value> value_in)
    : id(std::move(id_in)),
      value(std::move(value_in)) {}

APIPermission::~APIPermission() = default;

void APIPermission::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::extensions::mojom::APIPermissionID>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::Value>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool APIPermission::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
APIPermissionSet::APIPermissionSet()
    : permission_map() {}

APIPermissionSet::APIPermissionSet(
    base::flat_map<::extensions::mojom::APIPermissionID, ::std::unique_ptr<::extensions::APIPermission>> permission_map_in)
    : permission_map(std::move(permission_map_in)) {}

APIPermissionSet::~APIPermissionSet() = default;

void APIPermissionSet::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "permission_map"), this->permission_map,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type base::flat_map<::extensions::mojom::APIPermissionID, ::std::unique_ptr<::extensions::APIPermission>>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool APIPermissionSet::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ManifestPermission::ManifestPermission()
    : id(),
      value() {}

ManifestPermission::ManifestPermission(
    const std::string& id_in,
    std::optional<::base::Value> value_in)
    : id(std::move(id_in)),
      value(std::move(value_in)) {}

ManifestPermission::~ManifestPermission() = default;

void ManifestPermission::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::Value>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ManifestPermission::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ManifestPermissionSet::ManifestPermissionSet()
    : permission_map() {}

ManifestPermissionSet::ManifestPermissionSet(
    base::flat_map<std::string, ::std::unique_ptr<::extensions::ManifestPermission>> permission_map_in)
    : permission_map(std::move(permission_map_in)) {}

ManifestPermissionSet::~ManifestPermissionSet() = default;

void ManifestPermissionSet::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "permission_map"), this->permission_map,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type base::flat_map<std::string, ::std::unique_ptr<::extensions::ManifestPermission>>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ManifestPermissionSet::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PermissionSet::PermissionSet()
    : apis(),
      manifest_permissions(),
      hosts(),
      user_script_hosts() {}

PermissionSet::PermissionSet(
    ::extensions::APIPermissionSet apis_in,
    ::extensions::ManifestPermissionSet manifest_permissions_in,
    ::extensions::URLPatternSet hosts_in,
    ::extensions::URLPatternSet user_script_hosts_in)
    : apis(std::move(apis_in)),
      manifest_permissions(std::move(manifest_permissions_in)),
      hosts(std::move(hosts_in)),
      user_script_hosts(std::move(user_script_hosts_in)) {}

PermissionSet::~PermissionSet() = default;

void PermissionSet::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "apis"), this->apis,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::extensions::APIPermissionSet>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "manifest_permissions"), this->manifest_permissions,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::extensions::ManifestPermissionSet>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hosts"), this->hosts,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::extensions::URLPatternSet>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "user_script_hosts"), this->user_script_hosts,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::extensions::URLPatternSet>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PermissionSet::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // extensions::mojom


namespace mojo {


// static
bool StructTraits<::extensions::mojom::APIPermission::DataView, ::extensions::mojom::APIPermissionPtr>::Read(
    ::extensions::mojom::APIPermission::DataView input,
    ::extensions::mojom::APIPermissionPtr* output) {
  bool success = true;
  ::extensions::mojom::APIPermissionPtr result(::extensions::mojom::APIPermission::New());
  
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadValue(&result->value))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::extensions::mojom::APIPermissionSet::DataView, ::extensions::mojom::APIPermissionSetPtr>::Read(
    ::extensions::mojom::APIPermissionSet::DataView input,
    ::extensions::mojom::APIPermissionSetPtr* output) {
  bool success = true;
  ::extensions::mojom::APIPermissionSetPtr result(::extensions::mojom::APIPermissionSet::New());
  
      if (success && !input.ReadPermissionMap(&result->permission_map))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::extensions::mojom::ManifestPermission::DataView, ::extensions::mojom::ManifestPermissionPtr>::Read(
    ::extensions::mojom::ManifestPermission::DataView input,
    ::extensions::mojom::ManifestPermissionPtr* output) {
  bool success = true;
  ::extensions::mojom::ManifestPermissionPtr result(::extensions::mojom::ManifestPermission::New());
  
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadValue(&result->value))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::extensions::mojom::ManifestPermissionSet::DataView, ::extensions::mojom::ManifestPermissionSetPtr>::Read(
    ::extensions::mojom::ManifestPermissionSet::DataView input,
    ::extensions::mojom::ManifestPermissionSetPtr* output) {
  bool success = true;
  ::extensions::mojom::ManifestPermissionSetPtr result(::extensions::mojom::ManifestPermissionSet::New());
  
      if (success && !input.ReadPermissionMap(&result->permission_map))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::extensions::mojom::PermissionSet::DataView, ::extensions::mojom::PermissionSetPtr>::Read(
    ::extensions::mojom::PermissionSet::DataView input,
    ::extensions::mojom::PermissionSetPtr* output) {
  bool success = true;
  ::extensions::mojom::PermissionSetPtr result(::extensions::mojom::PermissionSet::New());
  
      if (success && !input.ReadApis(&result->apis))
        success = false;
      if (success && !input.ReadManifestPermissions(&result->manifest_permissions))
        success = false;
      if (success && !input.ReadHosts(&result->hosts))
        success = false;
      if (success && !input.ReadUserScriptHosts(&result->user_script_hosts))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace extensions::mojom {




}  // extensions::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif