// extensions/common/mojom/service_worker_host.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "extensions/common/mojom/service_worker_host.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "extensions/common/mojom/service_worker_host.mojom-params-data.h"
namespace extensions {
namespace mojom {

namespace internal {


// static
bool ServiceWorkerHost_DidInitializeServiceWorkerContext_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ServiceWorkerHost_DidInitializeServiceWorkerContext_Params_Data* object =
      static_cast<const ServiceWorkerHost_DidInitializeServiceWorkerContext_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->extension_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->extension_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->service_worker_token, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->service_worker_token, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->event_dispatcher, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->event_dispatcher,
                                                 validation_context)) {
    return false;
  }

  return true;
}

ServiceWorkerHost_DidInitializeServiceWorkerContext_Params_Data::ServiceWorkerHost_DidInitializeServiceWorkerContext_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerHost_DidStartServiceWorkerContext_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ServiceWorkerHost_DidStartServiceWorkerContext_Params_Data* object =
      static_cast<const ServiceWorkerHost_DidStartServiceWorkerContext_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->extension_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->extension_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->activation_token, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->activation_token, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->service_worker_scope, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->service_worker_scope, validation_context))
    return false;

  return true;
}

ServiceWorkerHost_DidStartServiceWorkerContext_Params_Data::ServiceWorkerHost_DidStartServiceWorkerContext_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerHost_DidStopServiceWorkerContext_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ServiceWorkerHost_DidStopServiceWorkerContext_Params_Data* object =
      static_cast<const ServiceWorkerHost_DidStopServiceWorkerContext_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->extension_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->extension_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->activation_token, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->activation_token, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->service_worker_scope, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->service_worker_scope, validation_context))
    return false;

  return true;
}

ServiceWorkerHost_DidStopServiceWorkerContext_Params_Data::ServiceWorkerHost_DidStopServiceWorkerContext_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerHost_RequestWorker_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ServiceWorkerHost_RequestWorker_Params_Data* object =
      static_cast<const ServiceWorkerHost_RequestWorker_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  return true;
}

ServiceWorkerHost_RequestWorker_Params_Data::ServiceWorkerHost_RequestWorker_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerHost_RequestWorker_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ServiceWorkerHost_RequestWorker_ResponseParams_Data* object =
      static_cast<const ServiceWorkerHost_RequestWorker_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->response_wrapper, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->response_wrapper, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->error, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& error_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->error, validation_context,
                                         &error_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->extra_data, validation_context))
    return false;

  return true;
}

ServiceWorkerHost_RequestWorker_ResponseParams_Data::ServiceWorkerHost_RequestWorker_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerHost_WorkerResponseAck_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ServiceWorkerHost_WorkerResponseAck_Params_Data* object =
      static_cast<const ServiceWorkerHost_WorkerResponseAck_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->request_uuid, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->request_uuid, validation_context))
    return false;

  return true;
}

ServiceWorkerHost_WorkerResponseAck_Params_Data::ServiceWorkerHost_WorkerResponseAck_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerHost_OpenChannelToExtension_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ServiceWorkerHost_OpenChannelToExtension_Params_Data* object =
      static_cast<const ServiceWorkerHost_OpenChannelToExtension_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->info, validation_context))
    return false;


  if (!::extensions::mojom::internal::ChannelType_Data
        ::Validate(object->channel_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->channel_name, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& channel_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->channel_name, validation_context,
                                         &channel_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->port_id, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->port_id, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->port, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->port,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->port_host, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->port_host,
                                                 validation_context)) {
    return false;
  }

  return true;
}

ServiceWorkerHost_OpenChannelToExtension_Params_Data::ServiceWorkerHost_OpenChannelToExtension_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerHost_OpenChannelToNativeApp_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ServiceWorkerHost_OpenChannelToNativeApp_Params_Data* object =
      static_cast<const ServiceWorkerHost_OpenChannelToNativeApp_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->native_app_name, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& native_app_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->native_app_name, validation_context,
                                         &native_app_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->port_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->port_id, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->port, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->port,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->port_host, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->port_host,
                                                 validation_context)) {
    return false;
  }

  return true;
}

ServiceWorkerHost_OpenChannelToNativeApp_Params_Data::ServiceWorkerHost_OpenChannelToNativeApp_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerHost_OpenChannelToTab_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ServiceWorkerHost_OpenChannelToTab_Params_Data* object =
      static_cast<const ServiceWorkerHost_OpenChannelToTab_Params_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& document_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->document_id, validation_context,
                                         &document_id_validate_params)) {
    return false;
  }


  if (!::extensions::mojom::internal::ChannelType_Data
        ::Validate(object->channel_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->channel_name, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& channel_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->channel_name, validation_context,
                                         &channel_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->port_id, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->port_id, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->port, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->port,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->port_host, 8, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->port_host,
                                                 validation_context)) {
    return false;
  }

  return true;
}

ServiceWorkerHost_OpenChannelToTab_Params_Data::ServiceWorkerHost_OpenChannelToTab_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace extensions