// extensions/common/mojom/stack_frame.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef EXTENSIONS_COMMON_MOJOM_STACK_FRAME_MOJOM_SHARED_H_
#define EXTENSIONS_COMMON_MOJOM_STACK_FRAME_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "extensions/common/mojom/stack_frame.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"




#include "extensions/common/mojom/stack_frame.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::extensions::mojom::StackFrameDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::extensions::mojom::StackFrameDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::extensions::mojom::internal::StackFrame_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->line_number = Traits::line_number(input);

    fragment->column_number = Traits::column_number(input);

    decltype(Traits::source(input)) in_source = Traits::source(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->source)::BaseType> source_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_source,
      source_fragment);

    fragment->source.Set(
        source_fragment.is_null() ? nullptr : source_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->source.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null source in StackFrame struct");

    decltype(Traits::function(input)) in_function = Traits::function(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->function)::BaseType> function_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_function,
      function_fragment);

    fragment->function.Set(
        function_fragment.is_null() ? nullptr : function_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->function.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null function in StackFrame struct");
  }

  static bool Deserialize(::extensions::mojom::internal::StackFrame_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::extensions::mojom::StackFrameDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace extensions::mojom {

inline void StackFrameDataView::GetSourceDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->source.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void StackFrameDataView::GetFunctionDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->function.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}



}  // extensions::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // EXTENSIONS_COMMON_MOJOM_STACK_FRAME_MOJOM_SHARED_H_