// gpu/ipc/common/exported_shared_image.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef GPU_IPC_COMMON_EXPORTED_SHARED_IMAGE_MOJOM_SHARED_H_
#define GPU_IPC_COMMON_EXPORTED_SHARED_IMAGE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "gpu/ipc/common/exported_shared_image.mojom-shared-internal.h"
#include "gpu/ipc/common/mailbox.mojom-shared.h"
#include "gpu/ipc/common/shared_image_metadata.mojom-shared.h"
#include "gpu/ipc/common/sync_token.mojom-shared.h"
#include "ui/gfx/mojom/buffer_types.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "gpu/ipc/common/exported_shared_image.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::ExportedSharedImageDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::ExportedSharedImageDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gpu::mojom::internal::ExportedSharedImage_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::mailbox(input)) in_mailbox = Traits::mailbox(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->mailbox)::BaseType> mailbox_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gpu::mojom::MailboxDataView>(
      in_mailbox,
      mailbox_fragment);

    fragment->mailbox.Set(
        mailbox_fragment.is_null() ? nullptr : mailbox_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->mailbox.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null mailbox in ExportedSharedImage struct");

    decltype(Traits::metadata(input)) in_metadata = Traits::metadata(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->metadata)::BaseType> metadata_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gpu::mojom::SharedImageMetadataDataView>(
      in_metadata,
      metadata_fragment);

    fragment->metadata.Set(
        metadata_fragment.is_null() ? nullptr : metadata_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->metadata.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null metadata in ExportedSharedImage struct");

    decltype(Traits::creation_sync_token(input)) in_creation_sync_token = Traits::creation_sync_token(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->creation_sync_token)::BaseType> creation_sync_token_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gpu::mojom::SyncTokenDataView>(
      in_creation_sync_token,
      creation_sync_token_fragment);

    fragment->creation_sync_token.Set(
        creation_sync_token_fragment.is_null() ? nullptr : creation_sync_token_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->creation_sync_token.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null creation_sync_token in ExportedSharedImage struct");

    decltype(Traits::debug_label(input)) in_debug_label = Traits::debug_label(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->debug_label)::BaseType> debug_label_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_debug_label,
      debug_label_fragment);

    fragment->debug_label.Set(
        debug_label_fragment.is_null() ? nullptr : debug_label_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->debug_label.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null debug_label in ExportedSharedImage struct");

    decltype(Traits::buffer_handle(input)) in_buffer_handle = Traits::buffer_handle(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->buffer_handle)::BaseType> buffer_handle_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::GpuMemoryBufferHandleDataView>(
      in_buffer_handle,
      buffer_handle_fragment);

    fragment->buffer_handle.Set(
        buffer_handle_fragment.is_null() ? nullptr : buffer_handle_fragment.data());
    fragment->buffer_usage_$flag = Traits::buffer_usage(input).has_value();
    if (Traits::buffer_usage(input).has_value()) {
      
      mojo::internal::Serialize<::gfx::mojom::BufferUsage>(
        Traits::buffer_usage(input).value(),
        &fragment->buffer_usage_$value);
    } else {
      fragment->buffer_usage_$value =
          static_cast<int32_t>(::gfx::mojom::BufferUsage::kMinValue);
    }

    fragment->texture_target = Traits::texture_target(input);
  }

  static bool Deserialize(::gpu::mojom::internal::ExportedSharedImage_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gpu::mojom::ExportedSharedImageDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace gpu::mojom {

inline void ExportedSharedImageDataView::GetMailboxDataView(
    ::gpu::mojom::MailboxDataView* output) {
  auto pointer = data_->mailbox.Get();
  *output = ::gpu::mojom::MailboxDataView(pointer, message_);
}
inline void ExportedSharedImageDataView::GetMetadataDataView(
    ::gpu::mojom::SharedImageMetadataDataView* output) {
  auto pointer = data_->metadata.Get();
  *output = ::gpu::mojom::SharedImageMetadataDataView(pointer, message_);
}
inline void ExportedSharedImageDataView::GetCreationSyncTokenDataView(
    ::gpu::mojom::SyncTokenDataView* output) {
  auto pointer = data_->creation_sync_token.Get();
  *output = ::gpu::mojom::SyncTokenDataView(pointer, message_);
}
inline void ExportedSharedImageDataView::GetDebugLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->debug_label.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ExportedSharedImageDataView::GetBufferHandleDataView(
    ::gfx::mojom::GpuMemoryBufferHandleDataView* output) {
  auto pointer = data_->buffer_handle.Get();
  *output = ::gfx::mojom::GpuMemoryBufferHandleDataView(pointer, message_);
}



}  // gpu::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // GPU_IPC_COMMON_EXPORTED_SHARED_IMAGE_MOJOM_SHARED_H_