// gpu/ipc/common/shared_image_capabilities.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "gpu/ipc/common/shared_image_capabilities.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "gpu/ipc/common/shared_image_capabilities.mojom-params-data.h"
#include "gpu/ipc/common/shared_image_capabilities.mojom-shared-message-ids.h"

#include "gpu/ipc/common/shared_image_capabilities.mojom-import-headers.h"
#include "gpu/ipc/common/shared_image_capabilities.mojom-test-utils.h"


namespace gpu::mojom {
SharedImageCapabilities::SharedImageCapabilities()
    : supports_scanout_shared_images(),
      supports_luminance_shared_images(),
      supports_r16_shared_images(),
      supports_native_nv12_mappable_shared_images(),
      is_r16f_supported(),
      disable_r8_shared_images(),
      disable_webgpu_shared_images(),
      disable_one_component_textures(),
      shared_image_d3d(),
      shared_image_swap_chain() {}

SharedImageCapabilities::SharedImageCapabilities(
    bool supports_scanout_shared_images_in,
    bool supports_luminance_shared_images_in,
    bool supports_r16_shared_images_in,
    bool supports_native_nv12_mappable_shared_images_in,
    bool is_r16f_supported_in,
    bool disable_r8_shared_images_in,
    bool disable_webgpu_shared_images_in,
    bool disable_one_component_textures_in,
    bool shared_image_d3d_in,
    bool shared_image_swap_chain_in)
    : supports_scanout_shared_images(std::move(supports_scanout_shared_images_in)),
      supports_luminance_shared_images(std::move(supports_luminance_shared_images_in)),
      supports_r16_shared_images(std::move(supports_r16_shared_images_in)),
      supports_native_nv12_mappable_shared_images(std::move(supports_native_nv12_mappable_shared_images_in)),
      is_r16f_supported(std::move(is_r16f_supported_in)),
      disable_r8_shared_images(std::move(disable_r8_shared_images_in)),
      disable_webgpu_shared_images(std::move(disable_webgpu_shared_images_in)),
      disable_one_component_textures(std::move(disable_one_component_textures_in)),
      shared_image_d3d(std::move(shared_image_d3d_in)),
      shared_image_swap_chain(std::move(shared_image_swap_chain_in)) {}

SharedImageCapabilities::~SharedImageCapabilities() = default;

void SharedImageCapabilities::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "supports_scanout_shared_images"), this->supports_scanout_shared_images,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "supports_luminance_shared_images"), this->supports_luminance_shared_images,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "supports_r16_shared_images"), this->supports_r16_shared_images,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "supports_native_nv12_mappable_shared_images"), this->supports_native_nv12_mappable_shared_images,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_r16f_supported"), this->is_r16f_supported,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "disable_r8_shared_images"), this->disable_r8_shared_images,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "disable_webgpu_shared_images"), this->disable_webgpu_shared_images,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "disable_one_component_textures"), this->disable_one_component_textures,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "shared_image_d3d"), this->shared_image_d3d,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "shared_image_swap_chain"), this->shared_image_swap_chain,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SharedImageCapabilities::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // gpu::mojom


namespace mojo {


// static
bool StructTraits<::gpu::mojom::SharedImageCapabilities::DataView, ::gpu::mojom::SharedImageCapabilitiesPtr>::Read(
    ::gpu::mojom::SharedImageCapabilities::DataView input,
    ::gpu::mojom::SharedImageCapabilitiesPtr* output) {
  bool success = true;
  ::gpu::mojom::SharedImageCapabilitiesPtr result(::gpu::mojom::SharedImageCapabilities::New());
  
      if (success)
        result->supports_scanout_shared_images = input.supports_scanout_shared_images();
      if (success)
        result->supports_luminance_shared_images = input.supports_luminance_shared_images();
      if (success)
        result->supports_r16_shared_images = input.supports_r16_shared_images();
      if (success)
        result->supports_native_nv12_mappable_shared_images = input.supports_native_nv12_mappable_shared_images();
      if (success)
        result->is_r16f_supported = input.is_r16f_supported();
      if (success)
        result->disable_r8_shared_images = input.disable_r8_shared_images();
      if (success)
        result->disable_webgpu_shared_images = input.disable_webgpu_shared_images();
      if (success)
        result->disable_one_component_textures = input.disable_one_component_textures();
      if (success)
        result->shared_image_d3d = input.shared_image_d3d();
      if (success)
        result->shared_image_swap_chain = input.shared_image_swap_chain();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace gpu::mojom {




}  // gpu::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif