// media/mojo/mojom/audio_input_stream.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/mojo/mojom/audio_input_stream.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/audio_input_stream.mojom-params-data.h"
#include "media/mojo/mojom/audio_input_stream.mojom-shared-message-ids.h"

#include "media/mojo/mojom/audio_input_stream.mojom-import-headers.h"
#include "media/mojo/mojom/audio_input_stream.mojom-test-utils.h"


namespace media::mojom {
// The declaration includes the definition on other builds.

AudioInputStream::IPCStableHashFunction AudioInputStream::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::AudioInputStream>(message.name())) {
    case messages::AudioInputStream::kRecord: {
      return &AudioInputStream::Record_Sym::IPCStableHash;
    }
    case messages::AudioInputStream::kSetVolume: {
      return &AudioInputStream::SetVolume_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* AudioInputStream::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::AudioInputStream>(message.name())) {
      case messages::AudioInputStream::kRecord:
            return "Receive media::mojom::AudioInputStream::Record";
      case messages::AudioInputStream::kSetVolume:
            return "Receive media::mojom::AudioInputStream::SetVolume";
    }
  } else {
    switch (static_cast<messages::AudioInputStream>(message.name())) {
      case messages::AudioInputStream::kRecord:
            return "Receive reply media::mojom::AudioInputStream::Record";
      case messages::AudioInputStream::kSetVolume:
            return "Receive reply media::mojom::AudioInputStream::SetVolume";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t AudioInputStream::Record_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5d2662b3;  // IPCStableHash for media::mojom::AudioInputStream::Record
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AudioInputStream::SetVolume_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xdfb81eab;  // IPCStableHash for media::mojom::AudioInputStream::SetVolume
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

AudioInputStreamProxy::AudioInputStreamProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AudioInputStreamProxy::Record(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media::mojom::AudioInputStream::Record");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioInputStream::kRecord), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::AudioInputStream_Record_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioInputStream::Name_);
  message.set_method_name("Record");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AudioInputStreamProxy::SetVolume(
    double in_volume) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::AudioInputStream::SetVolume", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("volume"), in_volume,
                        "<value of type double>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioInputStream::kSetVolume), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::AudioInputStream_SetVolume_Params_Data> params(
          message);
  params.Allocate();

  params->volume = in_volume;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioInputStream::Name_);
  message.set_method_name("SetVolume");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool AudioInputStreamStubDispatch::Accept(
    AudioInputStream* impl,
    mojo::Message* message) {
  switch (static_cast<messages::AudioInputStream>(message->header()->name)) {
    case messages::AudioInputStream::kRecord: {
      DCHECK(message->is_serialized());
      internal::AudioInputStream_Record_Params_Data* params =
          reinterpret_cast<internal::AudioInputStream_Record_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AudioInputStream.0
      bool success = true;
      AudioInputStream_Record_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioInputStream::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Record(        );
      return true;
    }
    case messages::AudioInputStream::kSetVolume: {
      DCHECK(message->is_serialized());
      internal::AudioInputStream_SetVolume_Params_Data* params =
          reinterpret_cast<internal::AudioInputStream_SetVolume_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AudioInputStream.1
      bool success = true;
      double p_volume{};
      AudioInputStream_SetVolume_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_volume = input_data_view.volume();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioInputStream::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetVolume(        
        std::move(p_volume));
      return true;
    }
  }
  return false;
}

// static
bool AudioInputStreamStubDispatch::AcceptWithResponder(
    AudioInputStream* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::AudioInputStream>(message->header()->name)) {
    case messages::AudioInputStream::kRecord: {
      break;
    }
    case messages::AudioInputStream::kSetVolume: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kAudioInputStreamValidationInfo[] = {
    {base::to_underlying(messages::AudioInputStream::kRecord),
     { &internal::AudioInputStream_Record_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::AudioInputStream::kSetVolume),
     { &internal::AudioInputStream_SetVolume_Params_Data::Validate,
      nullptr /* no response */}},
};

bool AudioInputStreamRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::media::mojom::AudioInputStream::Name_,
    kAudioInputStreamValidationInfo);
}

// The declaration includes the definition on other builds.

AudioInputStreamClient::IPCStableHashFunction AudioInputStreamClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::AudioInputStreamClient>(message.name())) {
    case messages::AudioInputStreamClient::kOnError: {
      return &AudioInputStreamClient::OnError_Sym::IPCStableHash;
    }
    case messages::AudioInputStreamClient::kOnMutedStateChanged: {
      return &AudioInputStreamClient::OnMutedStateChanged_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* AudioInputStreamClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::AudioInputStreamClient>(message.name())) {
      case messages::AudioInputStreamClient::kOnError:
            return "Receive media::mojom::AudioInputStreamClient::OnError";
      case messages::AudioInputStreamClient::kOnMutedStateChanged:
            return "Receive media::mojom::AudioInputStreamClient::OnMutedStateChanged";
    }
  } else {
    switch (static_cast<messages::AudioInputStreamClient>(message.name())) {
      case messages::AudioInputStreamClient::kOnError:
            return "Receive reply media::mojom::AudioInputStreamClient::OnError";
      case messages::AudioInputStreamClient::kOnMutedStateChanged:
            return "Receive reply media::mojom::AudioInputStreamClient::OnMutedStateChanged";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t AudioInputStreamClient::OnError_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1886f46f;  // IPCStableHash for media::mojom::AudioInputStreamClient::OnError
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AudioInputStreamClient::OnMutedStateChanged_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x52a0d5c1;  // IPCStableHash for media::mojom::AudioInputStreamClient::OnMutedStateChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

AudioInputStreamClientProxy::AudioInputStreamClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AudioInputStreamClientProxy::OnError(
    ::media::mojom::InputStreamErrorCode in_code) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::AudioInputStreamClient::OnError", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("code"), in_code,
                        "<value of type ::media::mojom::InputStreamErrorCode>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioInputStreamClient::kOnError), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::AudioInputStreamClient_OnError_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::media::mojom::InputStreamErrorCode>(
    in_code,
    &params->code);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioInputStreamClient::Name_);
  message.set_method_name("OnError");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AudioInputStreamClientProxy::OnMutedStateChanged(
    bool in_is_muted) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::AudioInputStreamClient::OnMutedStateChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_muted"), in_is_muted,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioInputStreamClient::kOnMutedStateChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::AudioInputStreamClient_OnMutedStateChanged_Params_Data> params(
          message);
  params.Allocate();

  params->is_muted = in_is_muted;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioInputStreamClient::Name_);
  message.set_method_name("OnMutedStateChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool AudioInputStreamClientStubDispatch::Accept(
    AudioInputStreamClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::AudioInputStreamClient>(message->header()->name)) {
    case messages::AudioInputStreamClient::kOnError: {
      DCHECK(message->is_serialized());
      internal::AudioInputStreamClient_OnError_Params_Data* params =
          reinterpret_cast<internal::AudioInputStreamClient_OnError_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AudioInputStreamClient.0
      bool success = true;
      ::media::mojom::InputStreamErrorCode p_code{};
      AudioInputStreamClient_OnError_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCode(&p_code))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioInputStreamClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnError(        
        std::move(p_code));
      return true;
    }
    case messages::AudioInputStreamClient::kOnMutedStateChanged: {
      DCHECK(message->is_serialized());
      internal::AudioInputStreamClient_OnMutedStateChanged_Params_Data* params =
          reinterpret_cast<internal::AudioInputStreamClient_OnMutedStateChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AudioInputStreamClient.1
      bool success = true;
      bool p_is_muted{};
      AudioInputStreamClient_OnMutedStateChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_is_muted = input_data_view.is_muted();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioInputStreamClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnMutedStateChanged(        
        std::move(p_is_muted));
      return true;
    }
  }
  return false;
}

// static
bool AudioInputStreamClientStubDispatch::AcceptWithResponder(
    AudioInputStreamClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::AudioInputStreamClient>(message->header()->name)) {
    case messages::AudioInputStreamClient::kOnError: {
      break;
    }
    case messages::AudioInputStreamClient::kOnMutedStateChanged: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kAudioInputStreamClientValidationInfo[] = {
    {base::to_underlying(messages::AudioInputStreamClient::kOnError),
     { &internal::AudioInputStreamClient_OnError_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::AudioInputStreamClient::kOnMutedStateChanged),
     { &internal::AudioInputStreamClient_OnMutedStateChanged_Params_Data::Validate,
      nullptr /* no response */}},
};

bool AudioInputStreamClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::media::mojom::AudioInputStreamClient::Name_,
    kAudioInputStreamClientValidationInfo);
}

// The declaration includes the definition on other builds.

AudioInputStreamObserver::IPCStableHashFunction AudioInputStreamObserver::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::AudioInputStreamObserver>(message.name())) {
    case messages::AudioInputStreamObserver::kDidStartRecording: {
      return &AudioInputStreamObserver::DidStartRecording_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* AudioInputStreamObserver::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::AudioInputStreamObserver>(message.name())) {
      case messages::AudioInputStreamObserver::kDidStartRecording:
            return "Receive media::mojom::AudioInputStreamObserver::DidStartRecording";
    }
  } else {
    switch (static_cast<messages::AudioInputStreamObserver>(message.name())) {
      case messages::AudioInputStreamObserver::kDidStartRecording:
            return "Receive reply media::mojom::AudioInputStreamObserver::DidStartRecording";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t AudioInputStreamObserver::DidStartRecording_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xdccfb87a;  // IPCStableHash for media::mojom::AudioInputStreamObserver::DidStartRecording
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

AudioInputStreamObserverProxy::AudioInputStreamObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AudioInputStreamObserverProxy::DidStartRecording(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media::mojom::AudioInputStreamObserver::DidStartRecording");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioInputStreamObserver::kDidStartRecording), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::AudioInputStreamObserver_DidStartRecording_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioInputStreamObserver::Name_);
  message.set_method_name("DidStartRecording");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool AudioInputStreamObserverStubDispatch::Accept(
    AudioInputStreamObserver* impl,
    mojo::Message* message) {
  switch (static_cast<messages::AudioInputStreamObserver>(message->header()->name)) {
    case messages::AudioInputStreamObserver::kDidStartRecording: {
      DCHECK(message->is_serialized());
      internal::AudioInputStreamObserver_DidStartRecording_Params_Data* params =
          reinterpret_cast<internal::AudioInputStreamObserver_DidStartRecording_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AudioInputStreamObserver.0
      bool success = true;
      AudioInputStreamObserver_DidStartRecording_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioInputStreamObserver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidStartRecording(        );
      return true;
    }
  }
  return false;
}

// static
bool AudioInputStreamObserverStubDispatch::AcceptWithResponder(
    AudioInputStreamObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::AudioInputStreamObserver>(message->header()->name)) {
    case messages::AudioInputStreamObserver::kDidStartRecording: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kAudioInputStreamObserverValidationInfo[] = {
    {base::to_underlying(messages::AudioInputStreamObserver::kDidStartRecording),
     { &internal::AudioInputStreamObserver_DidStartRecording_Params_Data::Validate,
      nullptr /* no response */}},
};

bool AudioInputStreamObserverRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::media::mojom::AudioInputStreamObserver::Name_,
    kAudioInputStreamObserverValidationInfo);
}



}  // media::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace media::mojom {


void AudioInputStreamInterceptorForTesting::Record() {
  GetForwardingInterface()->Record();
}
void AudioInputStreamInterceptorForTesting::SetVolume(double volume) {
  GetForwardingInterface()->SetVolume(
    std::move(volume)
    );
}
AudioInputStreamAsyncWaiter::AudioInputStreamAsyncWaiter(
    AudioInputStream* proxy) : proxy_(proxy) {}

AudioInputStreamAsyncWaiter::~AudioInputStreamAsyncWaiter() = default;





void AudioInputStreamClientInterceptorForTesting::OnError(::media::mojom::InputStreamErrorCode code) {
  GetForwardingInterface()->OnError(
    std::move(code)
    );
}
void AudioInputStreamClientInterceptorForTesting::OnMutedStateChanged(bool is_muted) {
  GetForwardingInterface()->OnMutedStateChanged(
    std::move(is_muted)
    );
}
AudioInputStreamClientAsyncWaiter::AudioInputStreamClientAsyncWaiter(
    AudioInputStreamClient* proxy) : proxy_(proxy) {}

AudioInputStreamClientAsyncWaiter::~AudioInputStreamClientAsyncWaiter() = default;





void AudioInputStreamObserverInterceptorForTesting::DidStartRecording() {
  GetForwardingInterface()->DidStartRecording();
}
AudioInputStreamObserverAsyncWaiter::AudioInputStreamObserverAsyncWaiter(
    AudioInputStreamObserver* proxy) : proxy_(proxy) {}

AudioInputStreamObserverAsyncWaiter::~AudioInputStreamObserverAsyncWaiter() = default;







}  // media::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif