// media/mojo/mojom/video_decoder.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_VIDEO_DECODER_MOJOM_DATA_VIEW_H_
#define MEDIA_MOJO_MOJOM_VIDEO_DECODER_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "media/mojo/mojom/video_decoder.mojom-shared-internal.h"
#include "gpu/ipc/common/sync_token.mojom-shared.h"
#include "media/mojo/mojom/media_log.mojom-shared.h"
#include "media/mojo/mojom/media_types.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/color_space.mojom-shared.h"
#include "media/mojo/mojom/cdm_context_for_oopvd.mojom-shared.h"


namespace media::mojom {
class SupportedVideoDecoderConfigDataView;

class CommandBufferIdDataView;

using OverlayInfoDataView = mojo::native::NativeStructDataView;

class CdmDataView;


}  // media::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::media::mojom::SupportedVideoDecoderConfigDataView> {
  using Data = ::media::mojom::internal::SupportedVideoDecoderConfig_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::CommandBufferIdDataView> {
  using Data = ::media::mojom::internal::CommandBufferId_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::CdmDataView> {
  using Data = ::media::mojom::internal::Cdm_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace media::mojom {
// Interface base classes. They are used for type safety check.
class VideoFrameHandleReleaserInterfaceBase {};

using VideoFrameHandleReleaserPtrDataView =
    mojo::InterfacePtrDataView<VideoFrameHandleReleaserInterfaceBase>;
using VideoFrameHandleReleaserRequestDataView =
    mojo::InterfaceRequestDataView<VideoFrameHandleReleaserInterfaceBase>;
using VideoFrameHandleReleaserAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<VideoFrameHandleReleaserInterfaceBase>;
using VideoFrameHandleReleaserAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<VideoFrameHandleReleaserInterfaceBase>;
class VideoDecoderInterfaceBase {};

using VideoDecoderPtrDataView =
    mojo::InterfacePtrDataView<VideoDecoderInterfaceBase>;
using VideoDecoderRequestDataView =
    mojo::InterfaceRequestDataView<VideoDecoderInterfaceBase>;
using VideoDecoderAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<VideoDecoderInterfaceBase>;
using VideoDecoderAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<VideoDecoderInterfaceBase>;
class VideoDecoderClientInterfaceBase {};

using VideoDecoderClientPtrDataView =
    mojo::InterfacePtrDataView<VideoDecoderClientInterfaceBase>;
using VideoDecoderClientRequestDataView =
    mojo::InterfaceRequestDataView<VideoDecoderClientInterfaceBase>;
using VideoDecoderClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<VideoDecoderClientInterfaceBase>;
using VideoDecoderClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<VideoDecoderClientInterfaceBase>;


class SupportedVideoDecoderConfigDataView {
 public:
  SupportedVideoDecoderConfigDataView() = default;

  SupportedVideoDecoderConfigDataView(
      internal::SupportedVideoDecoderConfig_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadProfileMin(UserType* output) const {
    auto data_value = data_->profile_min;
    return mojo::internal::Deserialize<::media::mojom::VideoCodecProfile>(
        data_value, output);
  }
  ::media::mojom::VideoCodecProfile profile_min() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::VideoCodecProfile>(data_->profile_min));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadProfileMax(UserType* output) const {
    auto data_value = data_->profile_max;
    return mojo::internal::Deserialize<::media::mojom::VideoCodecProfile>(
        data_value, output);
  }
  ::media::mojom::VideoCodecProfile profile_max() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::VideoCodecProfile>(data_->profile_max));
  }
  inline void GetCodedSizeMinDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCodedSizeMin(UserType* output) {
    
    auto* pointer = data_->coded_size_min.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  inline void GetCodedSizeMaxDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCodedSizeMax(UserType* output) {
    
    auto* pointer = data_->coded_size_max.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  bool allow_encrypted() const {
    return data_->allow_encrypted;
  }
  bool require_encrypted() const {
    return data_->require_encrypted;
  }
 private:
  internal::SupportedVideoDecoderConfig_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CommandBufferIdDataView {
 public:
  CommandBufferIdDataView() = default;

  CommandBufferIdDataView(
      internal::CommandBufferId_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetChannelTokenDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadChannelToken(UserType* output) {
    
    auto* pointer = data_->channel_token.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  int32_t route_id() const {
    return data_->route_id;
  }
 private:
  internal::CommandBufferId_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CdmDataView {
 public:
  using Tag = internal::Cdm_Data::Cdm_Tag;

  CdmDataView() = default;

  CdmDataView(
      internal::Cdm_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_cdm_id() const { return data_->tag == Tag::kCdmId; }
  inline void GetCdmIdDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadCdmId(UserType* output) const {
    
    CHECK(is_cdm_id());
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        data_->data.f_cdm_id.Get(), output, message_);
  }
  bool is_cdm_context() const { return data_->tag == Tag::kCdmContext; }
  template <typename UserType>
  UserType TakeCdmContext() {
    CHECK(is_cdm_context());
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::media::mojom::CdmContextForOOPVDInterfaceBase>>(
            &data_->data.f_cdm_context, &result, message_);
    CHECK(ret);
    return result;
  }

 private:
  internal::Cdm_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // media::mojom

#endif  // MEDIA_MOJO_MOJOM_VIDEO_DECODER_MOJOM_DATA_VIEW_H_