// media/mojo/mojom/webrtc_video_perf.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/mojo/mojom/webrtc_video_perf.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/webrtc_video_perf.mojom-params-data.h"
#include "media/mojo/mojom/webrtc_video_perf.mojom-shared-message-ids.h"

#include "media/mojo/mojom/webrtc_video_perf.mojom-import-headers.h"
#include "media/mojo/mojom/webrtc_video_perf.mojom-test-utils.h"


namespace media::mojom {
WebrtcPredictionFeatures::WebrtcPredictionFeatures()
    : is_decode_stats(true),
      profile(),
      video_pixels(0),
      hardware_accelerated(false) {}

WebrtcPredictionFeatures::WebrtcPredictionFeatures(
    bool is_decode_stats_in,
    ::media::VideoCodecProfile profile_in,
    int32_t video_pixels_in,
    bool hardware_accelerated_in)
    : is_decode_stats(std::move(is_decode_stats_in)),
      profile(std::move(profile_in)),
      video_pixels(std::move(video_pixels_in)),
      hardware_accelerated(std::move(hardware_accelerated_in)) {}

WebrtcPredictionFeatures::~WebrtcPredictionFeatures() = default;

void WebrtcPredictionFeatures::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_decode_stats"), this->is_decode_stats,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "profile"), this->profile,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::VideoCodecProfile>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "video_pixels"), this->video_pixels,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hardware_accelerated"), this->hardware_accelerated,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool WebrtcPredictionFeatures::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
WebrtcVideoStats::WebrtcVideoStats()
    : frames_processed(0U),
      key_frames_processed(0U),
      p99_processing_time_ms(0) {}

WebrtcVideoStats::WebrtcVideoStats(
    uint32_t frames_processed_in,
    uint32_t key_frames_processed_in,
    float p99_processing_time_ms_in)
    : frames_processed(std::move(frames_processed_in)),
      key_frames_processed(std::move(key_frames_processed_in)),
      p99_processing_time_ms(std::move(p99_processing_time_ms_in)) {}

WebrtcVideoStats::~WebrtcVideoStats() = default;
size_t WebrtcVideoStats::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->frames_processed);
  seed = mojo::internal::Hash(seed, this->key_frames_processed);
  seed = mojo::internal::Hash(seed, this->p99_processing_time_ms);
  return seed;
}

void WebrtcVideoStats::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frames_processed"), this->frames_processed,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "key_frames_processed"), this->key_frames_processed,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "p99_processing_time_ms"), this->p99_processing_time_ms,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool WebrtcVideoStats::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

WebrtcVideoPerfRecorder::IPCStableHashFunction WebrtcVideoPerfRecorder::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::WebrtcVideoPerfRecorder>(message.name())) {
    case messages::WebrtcVideoPerfRecorder::kUpdateRecord: {
      return &WebrtcVideoPerfRecorder::UpdateRecord_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* WebrtcVideoPerfRecorder::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::WebrtcVideoPerfRecorder>(message.name())) {
      case messages::WebrtcVideoPerfRecorder::kUpdateRecord:
            return "Receive media::mojom::WebrtcVideoPerfRecorder::UpdateRecord";
    }
  } else {
    switch (static_cast<messages::WebrtcVideoPerfRecorder>(message.name())) {
      case messages::WebrtcVideoPerfRecorder::kUpdateRecord:
            return "Receive reply media::mojom::WebrtcVideoPerfRecorder::UpdateRecord";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t WebrtcVideoPerfRecorder::UpdateRecord_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x79d45b96;  // IPCStableHash for media::mojom::WebrtcVideoPerfRecorder::UpdateRecord
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

WebrtcVideoPerfRecorderProxy::WebrtcVideoPerfRecorderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WebrtcVideoPerfRecorderProxy::UpdateRecord(
    WebrtcPredictionFeaturesPtr in_features, WebrtcVideoStatsPtr in_video_stats) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::WebrtcVideoPerfRecorder::UpdateRecord", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("features"), in_features,
                        "<value of type WebrtcPredictionFeaturesPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("video_stats"), in_video_stats,
                        "<value of type WebrtcVideoStatsPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebrtcVideoPerfRecorder::kUpdateRecord), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::WebrtcVideoPerfRecorder_UpdateRecord_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->features)::BaseType> features_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::WebrtcPredictionFeaturesDataView>(
    in_features,
    features_fragment);

  params->features.Set(
      features_fragment.is_null() ? nullptr : features_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->features.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null features in WebrtcVideoPerfRecorder.UpdateRecord request");
  mojo::internal::MessageFragment<
      typename decltype(params->video_stats)::BaseType> video_stats_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::WebrtcVideoStatsDataView>(
    in_video_stats,
    video_stats_fragment);

  params->video_stats.Set(
      video_stats_fragment.is_null() ? nullptr : video_stats_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->video_stats.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null video_stats in WebrtcVideoPerfRecorder.UpdateRecord request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebrtcVideoPerfRecorder::Name_);
  message.set_method_name("UpdateRecord");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool WebrtcVideoPerfRecorderStubDispatch::Accept(
    WebrtcVideoPerfRecorder* impl,
    mojo::Message* message) {
  switch (static_cast<messages::WebrtcVideoPerfRecorder>(message->header()->name)) {
    case messages::WebrtcVideoPerfRecorder::kUpdateRecord: {
      DCHECK(message->is_serialized());
      internal::WebrtcVideoPerfRecorder_UpdateRecord_Params_Data* params =
          reinterpret_cast<internal::WebrtcVideoPerfRecorder_UpdateRecord_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebrtcVideoPerfRecorder.0
      bool success = true;
      WebrtcPredictionFeaturesPtr p_features{};
      WebrtcVideoStatsPtr p_video_stats{};
      WebrtcVideoPerfRecorder_UpdateRecord_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFeatures(&p_features))
        success = false;
      if (success && !input_data_view.ReadVideoStats(&p_video_stats))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebrtcVideoPerfRecorder::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateRecord(        
        std::move(p_features), 
        std::move(p_video_stats));
      return true;
    }
  }
  return false;
}

// static
bool WebrtcVideoPerfRecorderStubDispatch::AcceptWithResponder(
    WebrtcVideoPerfRecorder* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::WebrtcVideoPerfRecorder>(message->header()->name)) {
    case messages::WebrtcVideoPerfRecorder::kUpdateRecord: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kWebrtcVideoPerfRecorderValidationInfo[] = {
    {base::to_underlying(messages::WebrtcVideoPerfRecorder::kUpdateRecord),
     { &internal::WebrtcVideoPerfRecorder_UpdateRecord_Params_Data::Validate,
      nullptr /* no response */}},
};

bool WebrtcVideoPerfRecorderRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::media::mojom::WebrtcVideoPerfRecorder::Name_,
    kWebrtcVideoPerfRecorderValidationInfo);
}

// The declaration includes the definition on other builds.

WebrtcVideoPerfHistory::IPCStableHashFunction WebrtcVideoPerfHistory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::WebrtcVideoPerfHistory>(message.name())) {
    case messages::WebrtcVideoPerfHistory::kGetPerfInfo: {
      return &WebrtcVideoPerfHistory::GetPerfInfo_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* WebrtcVideoPerfHistory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::WebrtcVideoPerfHistory>(message.name())) {
      case messages::WebrtcVideoPerfHistory::kGetPerfInfo:
            return "Receive media::mojom::WebrtcVideoPerfHistory::GetPerfInfo";
    }
  } else {
    switch (static_cast<messages::WebrtcVideoPerfHistory>(message.name())) {
      case messages::WebrtcVideoPerfHistory::kGetPerfInfo:
            return "Receive reply media::mojom::WebrtcVideoPerfHistory::GetPerfInfo";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t WebrtcVideoPerfHistory::GetPerfInfo_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8731854c;  // IPCStableHash for media::mojom::WebrtcVideoPerfHistory::GetPerfInfo
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class WebrtcVideoPerfHistory_GetPerfInfo_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebrtcVideoPerfHistory_GetPerfInfo_ForwardToCallback(
      WebrtcVideoPerfHistory::GetPerfInfoCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebrtcVideoPerfHistory_GetPerfInfo_ForwardToCallback(const WebrtcVideoPerfHistory_GetPerfInfo_ForwardToCallback&) = delete;
  WebrtcVideoPerfHistory_GetPerfInfo_ForwardToCallback& operator=(const WebrtcVideoPerfHistory_GetPerfInfo_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebrtcVideoPerfHistory::GetPerfInfoCallback callback_;
};

WebrtcVideoPerfHistoryProxy::WebrtcVideoPerfHistoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WebrtcVideoPerfHistoryProxy::GetPerfInfo(
    WebrtcPredictionFeaturesPtr in_features, int32_t in_frames_per_second, GetPerfInfoCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::WebrtcVideoPerfHistory::GetPerfInfo", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("features"), in_features,
                        "<value of type WebrtcPredictionFeaturesPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frames_per_second"), in_frames_per_second,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebrtcVideoPerfHistory::kGetPerfInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::WebrtcVideoPerfHistory_GetPerfInfo_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->features)::BaseType> features_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::WebrtcPredictionFeaturesDataView>(
    in_features,
    features_fragment);

  params->features.Set(
      features_fragment.is_null() ? nullptr : features_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->features.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null features in WebrtcVideoPerfHistory.GetPerfInfo request");

  params->frames_per_second = in_frames_per_second;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebrtcVideoPerfHistory::Name_);
  message.set_method_name("GetPerfInfo");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebrtcVideoPerfHistory_GetPerfInfo_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class WebrtcVideoPerfHistory_GetPerfInfo_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebrtcVideoPerfHistory::GetPerfInfoCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebrtcVideoPerfHistory_GetPerfInfo_ProxyToResponder> proxy(
        new WebrtcVideoPerfHistory_GetPerfInfo_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebrtcVideoPerfHistory_GetPerfInfo_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebrtcVideoPerfHistory_GetPerfInfo_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebrtcVideoPerfHistory_GetPerfInfo_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "WebrtcVideoPerfHistory::GetPerfInfoCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_is_smooth);
};

bool WebrtcVideoPerfHistory_GetPerfInfo_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebrtcVideoPerfHistory_GetPerfInfo_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebrtcVideoPerfHistory_GetPerfInfo_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebrtcVideoPerfHistory.0
  bool success = true;
  bool p_is_smooth{};
  WebrtcVideoPerfHistory_GetPerfInfo_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_is_smooth = input_data_view.is_smooth();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebrtcVideoPerfHistory::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_is_smooth));
  }
  return true;
}

void WebrtcVideoPerfHistory_GetPerfInfo_ProxyToResponder::Run(
    bool in_is_smooth) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media::mojom::WebrtcVideoPerfHistory::GetPerfInfo", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_smooth"), in_is_smooth,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebrtcVideoPerfHistory::kGetPerfInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::WebrtcVideoPerfHistory_GetPerfInfo_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->is_smooth = in_is_smooth;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebrtcVideoPerfHistory::Name_);
  message.set_method_name("GetPerfInfo");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool WebrtcVideoPerfHistoryStubDispatch::Accept(
    WebrtcVideoPerfHistory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::WebrtcVideoPerfHistory>(message->header()->name)) {
    case messages::WebrtcVideoPerfHistory::kGetPerfInfo: {
      break;
    }
  }
  return false;
}

// static
bool WebrtcVideoPerfHistoryStubDispatch::AcceptWithResponder(
    WebrtcVideoPerfHistory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::WebrtcVideoPerfHistory>(message->header()->name)) {
    case messages::WebrtcVideoPerfHistory::kGetPerfInfo: {
      internal::WebrtcVideoPerfHistory_GetPerfInfo_Params_Data* params =
          reinterpret_cast<
              internal::WebrtcVideoPerfHistory_GetPerfInfo_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebrtcVideoPerfHistory.0
      bool success = true;
      WebrtcPredictionFeaturesPtr p_features{};
      int32_t p_frames_per_second{};
      WebrtcVideoPerfHistory_GetPerfInfo_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFeatures(&p_features))
        success = false;
      if (success)
        p_frames_per_second = input_data_view.frames_per_second();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebrtcVideoPerfHistory::Name_, 0, false);
        return false;
      }
      auto callback =
          WebrtcVideoPerfHistory_GetPerfInfo_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetPerfInfo(        
        std::move(p_features), 
        std::move(p_frames_per_second), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kWebrtcVideoPerfHistoryValidationInfo[] = {
    {base::to_underlying(messages::WebrtcVideoPerfHistory::kGetPerfInfo),
     { &internal::WebrtcVideoPerfHistory_GetPerfInfo_Params_Data::Validate,
      &internal::WebrtcVideoPerfHistory_GetPerfInfo_ResponseParams_Data::Validate}},
};

bool WebrtcVideoPerfHistoryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::media::mojom::WebrtcVideoPerfHistory::Name_,
    kWebrtcVideoPerfHistoryValidationInfo);
}

bool WebrtcVideoPerfHistoryResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGeneric(
    message,
    ::media::mojom::WebrtcVideoPerfHistory::Name_,
    kWebrtcVideoPerfHistoryValidationInfo);

}


}  // media::mojom


namespace mojo {


// static
bool StructTraits<::media::mojom::WebrtcPredictionFeatures::DataView, ::media::mojom::WebrtcPredictionFeaturesPtr>::Read(
    ::media::mojom::WebrtcPredictionFeatures::DataView input,
    ::media::mojom::WebrtcPredictionFeaturesPtr* output) {
  bool success = true;
  ::media::mojom::WebrtcPredictionFeaturesPtr result(::media::mojom::WebrtcPredictionFeatures::New());
  
      if (success)
        result->is_decode_stats = input.is_decode_stats();
      if (success && !input.ReadProfile(&result->profile))
        success = false;
      if (success)
        result->video_pixels = input.video_pixels();
      if (success)
        result->hardware_accelerated = input.hardware_accelerated();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::WebrtcVideoStats::DataView, ::media::mojom::WebrtcVideoStatsPtr>::Read(
    ::media::mojom::WebrtcVideoStats::DataView input,
    ::media::mojom::WebrtcVideoStatsPtr* output) {
  bool success = true;
  ::media::mojom::WebrtcVideoStatsPtr result(::media::mojom::WebrtcVideoStats::New());
  
      if (success)
        result->frames_processed = input.frames_processed();
      if (success)
        result->key_frames_processed = input.key_frames_processed();
      if (success)
        result->p99_processing_time_ms = input.p99_processing_time_ms();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace media::mojom {


void WebrtcVideoPerfRecorderInterceptorForTesting::UpdateRecord(WebrtcPredictionFeaturesPtr features, WebrtcVideoStatsPtr video_stats) {
  GetForwardingInterface()->UpdateRecord(
    std::move(features)
    , 
    std::move(video_stats)
    );
}
WebrtcVideoPerfRecorderAsyncWaiter::WebrtcVideoPerfRecorderAsyncWaiter(
    WebrtcVideoPerfRecorder* proxy) : proxy_(proxy) {}

WebrtcVideoPerfRecorderAsyncWaiter::~WebrtcVideoPerfRecorderAsyncWaiter() = default;





void WebrtcVideoPerfHistoryInterceptorForTesting::GetPerfInfo(WebrtcPredictionFeaturesPtr features, int32_t frames_per_second, GetPerfInfoCallback callback) {
  GetForwardingInterface()->GetPerfInfo(
    std::move(features)
    , 
    std::move(frames_per_second)
    , std::move(callback));
}
WebrtcVideoPerfHistoryAsyncWaiter::WebrtcVideoPerfHistoryAsyncWaiter(
    WebrtcVideoPerfHistory* proxy) : proxy_(proxy) {}

WebrtcVideoPerfHistoryAsyncWaiter::~WebrtcVideoPerfHistoryAsyncWaiter() = default;


void WebrtcVideoPerfHistoryAsyncWaiter::GetPerfInfo(
    WebrtcPredictionFeaturesPtr features, int32_t frames_per_second, bool* out_is_smooth) {
  base::RunLoop loop;
  proxy_->GetPerfInfo(
      std::move(features),
      std::move(frames_per_second),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_is_smooth
,
             bool is_smooth) {*out_is_smooth = std::move(is_smooth);
            loop->Quit();
          },
          &loop,
          out_is_smooth));
  loop.Run();
}

bool WebrtcVideoPerfHistoryAsyncWaiter::GetPerfInfo(
    WebrtcPredictionFeaturesPtr features, int32_t frames_per_second) {
  bool async_wait_result;
  GetPerfInfo(std::move(features),std::move(frames_per_second),&async_wait_result);
  return async_wait_result;
}






}  // media::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif