// mojo/public/interfaces/bindings/pipe_control_messages.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MOJO_PUBLIC_INTERFACES_BINDINGS_PIPE_CONTROL_MESSAGES_MOJOM_DATA_VIEW_H_
#define MOJO_PUBLIC_INTERFACES_BINDINGS_PIPE_CONTROL_MESSAGES_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "mojo/public/interfaces/bindings/pipe_control_messages.mojom-shared-internal.h"


namespace mojo::pipe_control {
class RunOrClosePipeMessageParamsDataView;

class DisconnectReasonDataView;

class PeerAssociatedEndpointClosedEventDataView;

class PauseUntilFlushCompletesDataView;

class FlushAsyncDataView;

class RunOrClosePipeInputDataView;


}  // mojo::pipe_control


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::mojo::pipe_control::RunOrClosePipeMessageParamsDataView> {
  using Data = ::mojo::pipe_control::internal::RunOrClosePipeMessageParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::mojo::pipe_control::DisconnectReasonDataView> {
  using Data = ::mojo::pipe_control::internal::DisconnectReason_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::mojo::pipe_control::PeerAssociatedEndpointClosedEventDataView> {
  using Data = ::mojo::pipe_control::internal::PeerAssociatedEndpointClosedEvent_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::mojo::pipe_control::PauseUntilFlushCompletesDataView> {
  using Data = ::mojo::pipe_control::internal::PauseUntilFlushCompletes_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::mojo::pipe_control::FlushAsyncDataView> {
  using Data = ::mojo::pipe_control::internal::FlushAsync_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::mojo::pipe_control::RunOrClosePipeInputDataView> {
  using Data = ::mojo::pipe_control::internal::RunOrClosePipeInput_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace mojo::pipe_control {


class RunOrClosePipeMessageParamsDataView {
 public:
  RunOrClosePipeMessageParamsDataView() = default;

  RunOrClosePipeMessageParamsDataView(
      internal::RunOrClosePipeMessageParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInputDataView(
      RunOrClosePipeInputDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInput(UserType* output) {
    
    auto* pointer = !data_->input.is_null() ? &data_->input : nullptr;
    return mojo::internal::Deserialize<::mojo::pipe_control::RunOrClosePipeInputDataView>(
        pointer, output, message_);
  }
 private:
  internal::RunOrClosePipeMessageParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DisconnectReasonDataView {
 public:
  DisconnectReasonDataView() = default;

  DisconnectReasonDataView(
      internal::DisconnectReason_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint32_t custom_reason() const {
    return data_->custom_reason;
  }
  inline void GetDescriptionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDescription(UserType* output) {
    
    auto* pointer = data_->description.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::DisconnectReason_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PeerAssociatedEndpointClosedEventDataView {
 public:
  PeerAssociatedEndpointClosedEventDataView() = default;

  PeerAssociatedEndpointClosedEventDataView(
      internal::PeerAssociatedEndpointClosedEvent_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint32_t id() const {
    return data_->id;
  }
  inline void GetDisconnectReasonDataView(
      DisconnectReasonDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDisconnectReason(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo::pipe_control::DisconnectReasonDataView, UserType>(),
    "Attempting to read the optional `disconnect_reason` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDisconnectReason` instead "
    "of `ReadDisconnectReason if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->disconnect_reason.Get();
    return mojo::internal::Deserialize<::mojo::pipe_control::DisconnectReasonDataView>(
        pointer, output, message_);
  }
 private:
  internal::PeerAssociatedEndpointClosedEvent_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PauseUntilFlushCompletesDataView {
 public:
  PauseUntilFlushCompletesDataView() = default;

  PauseUntilFlushCompletesDataView(
      internal::PauseUntilFlushCompletes_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  mojo::ScopedMessagePipeHandle TakeFlushPipe() {
    mojo::ScopedMessagePipeHandle result;
    bool ret =
        mojo::internal::Deserialize<mojo::ScopedMessagePipeHandle>(
            &data_->flush_pipe, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::PauseUntilFlushCompletes_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FlushAsyncDataView {
 public:
  FlushAsyncDataView() = default;

  FlushAsyncDataView(
      internal::FlushAsync_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  mojo::ScopedMessagePipeHandle TakeFlusherPipe() {
    mojo::ScopedMessagePipeHandle result;
    bool ret =
        mojo::internal::Deserialize<mojo::ScopedMessagePipeHandle>(
            &data_->flusher_pipe, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::FlushAsync_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class RunOrClosePipeInputDataView {
 public:
  using Tag = internal::RunOrClosePipeInput_Data::RunOrClosePipeInput_Tag;

  RunOrClosePipeInputDataView() = default;

  RunOrClosePipeInputDataView(
      internal::RunOrClosePipeInput_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_peer_associated_endpoint_closed_event() const { return data_->tag == Tag::kPeerAssociatedEndpointClosedEvent; }
  inline void GetPeerAssociatedEndpointClosedEventDataView(
      PeerAssociatedEndpointClosedEventDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadPeerAssociatedEndpointClosedEvent(UserType* output) const {
    
    CHECK(is_peer_associated_endpoint_closed_event());
    return mojo::internal::Deserialize<::mojo::pipe_control::PeerAssociatedEndpointClosedEventDataView>(
        data_->data.f_peer_associated_endpoint_closed_event.Get(), output, message_);
  }
  bool is_pause_until_flush_completes() const { return data_->tag == Tag::kPauseUntilFlushCompletes; }
  inline void GetPauseUntilFlushCompletesDataView(
      PauseUntilFlushCompletesDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadPauseUntilFlushCompletes(UserType* output) const {
    
    CHECK(is_pause_until_flush_completes());
    return mojo::internal::Deserialize<::mojo::pipe_control::PauseUntilFlushCompletesDataView>(
        data_->data.f_pause_until_flush_completes.Get(), output, message_);
  }
  bool is_flush_async() const { return data_->tag == Tag::kFlushAsync; }
  inline void GetFlushAsyncDataView(
      FlushAsyncDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadFlushAsync(UserType* output) const {
    
    CHECK(is_flush_async());
    return mojo::internal::Deserialize<::mojo::pipe_control::FlushAsyncDataView>(
        data_->data.f_flush_async.Get(), output, message_);
  }

 private:
  internal::RunOrClosePipeInput_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // mojo::pipe_control

#endif  // MOJO_PUBLIC_INTERFACES_BINDINGS_PIPE_CONTROL_MESSAGES_MOJOM_DATA_VIEW_H_