// qtwebengine/browser/qtwebchannel.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef QTWEBENGINE_BROWSER_QTWEBCHANNEL_MOJOM_H_
#define QTWEBENGINE_BROWSER_QTWEBCHANNEL_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "qtwebengine/browser/qtwebchannel.mojom-features.h"  // IWYU pragma: export
#include "qtwebengine/browser/qtwebchannel.mojom-shared.h"  // IWYU pragma: export
#include "qtwebengine/browser/qtwebchannel.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace qtwebchannel::mojom {

class WebChannelTransportRenderProxy;

template <typename ImplRefTraits>
class WebChannelTransportRenderStub;

class WebChannelTransportRenderRequestValidator;


class WebChannelTransportRender
    : public WebChannelTransportRenderInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "qtwebchannel.mojom.WebChannelTransportRender";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = WebChannelTransportRenderInterfaceBase;
  using Proxy_ = WebChannelTransportRenderProxy;

  template <typename ImplRefTraits>
  using Stub_ = WebChannelTransportRenderStub<ImplRefTraits>;

  using RequestValidator_ = WebChannelTransportRenderRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSetWorldIdMinVersion = 0,
    kResetWorldIdMinVersion = 0,
    kDispatchWebChannelMessageMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetWorldId_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ResetWorldId_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DispatchWebChannelMessage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~WebChannelTransportRender() = default;

  virtual void SetWorldId(uint32_t worldId) = 0;

  virtual void ResetWorldId() = 0;

  virtual void DispatchWebChannelMessage(const std::vector<uint8_t>& binaryJson, uint32_t worldId) = 0;
};

class WebChannelTransportHostProxy;

template <typename ImplRefTraits>
class WebChannelTransportHostStub;

class WebChannelTransportHostRequestValidator;


class WebChannelTransportHost
    : public WebChannelTransportHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "qtwebchannel.mojom.WebChannelTransportHost";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = WebChannelTransportHostInterfaceBase;
  using Proxy_ = WebChannelTransportHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = WebChannelTransportHostStub<ImplRefTraits>;

  using RequestValidator_ = WebChannelTransportHostRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kDispatchWebChannelMessageMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct DispatchWebChannelMessage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~WebChannelTransportHost() = default;

  virtual void DispatchWebChannelMessage(const std::vector<uint8_t>& binaryJson) = 0;
};



class  WebChannelTransportRenderProxy
    : public WebChannelTransportRender {
 public:
  using InterfaceType = WebChannelTransportRender;

  explicit WebChannelTransportRenderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetWorldId(uint32_t worldId) final;
  
  void ResetWorldId() final;
  
  void DispatchWebChannelMessage(const std::vector<uint8_t>& binaryJson, uint32_t worldId) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  WebChannelTransportHostProxy
    : public WebChannelTransportHost {
 public:
  using InterfaceType = WebChannelTransportHost;

  explicit WebChannelTransportHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void DispatchWebChannelMessage(const std::vector<uint8_t>& binaryJson) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  WebChannelTransportRenderStubDispatch {
 public:
  static bool Accept(WebChannelTransportRender* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      WebChannelTransportRender* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<WebChannelTransportRender>>
class WebChannelTransportRenderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WebChannelTransportRenderStub() = default;
  ~WebChannelTransportRenderStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebChannelTransportRenderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebChannelTransportRenderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  WebChannelTransportHostStubDispatch {
 public:
  static bool Accept(WebChannelTransportHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      WebChannelTransportHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<WebChannelTransportHost>>
class WebChannelTransportHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WebChannelTransportHostStub() = default;
  ~WebChannelTransportHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebChannelTransportHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebChannelTransportHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  WebChannelTransportRenderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  WebChannelTransportHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // qtwebchannel::mojom

namespace mojo {

}  // namespace mojo

#endif  // QTWEBENGINE_BROWSER_QTWEBCHANNEL_MOJOM_H_