// qtwebengine/userscript/userscript.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef QTWEBENGINE_USERSCRIPT_USERSCRIPT_MOJOM_H_
#define QTWEBENGINE_USERSCRIPT_USERSCRIPT_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "qtwebengine/userscript/userscript.mojom-features.h"  // IWYU pragma: export
#include "qtwebengine/userscript/userscript.mojom-shared.h"  // IWYU pragma: export
#include "qtwebengine/userscript/userscript.mojom-forward.h"  // IWYU pragma: export
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "qtwebengine/userscript/user_script_data_mojom_traits.h"




namespace qtwebengine::mojom {

class UserResourceControllerRenderFrameProxy;

template <typename ImplRefTraits>
class UserResourceControllerRenderFrameStub;

class UserResourceControllerRenderFrameRequestValidator;


class UserResourceControllerRenderFrame
    : public UserResourceControllerRenderFrameInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "qtwebengine.mojom.UserResourceControllerRenderFrame";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = UserResourceControllerRenderFrameInterfaceBase;
  using Proxy_ = UserResourceControllerRenderFrameProxy;

  template <typename ImplRefTraits>
  using Stub_ = UserResourceControllerRenderFrameStub<ImplRefTraits>;

  using RequestValidator_ = UserResourceControllerRenderFrameRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kAddScriptMinVersion = 0,
    kRemoveScriptMinVersion = 0,
    kClearScriptsMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct AddScript_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RemoveScript_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ClearScripts_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~UserResourceControllerRenderFrame() = default;

  virtual void AddScript(const QtWebEngineCore::UserScriptData& data) = 0;

  virtual void RemoveScript(const QtWebEngineCore::UserScriptData& data) = 0;

  virtual void ClearScripts() = 0;
};

class UserResourceControllerProxy;

template <typename ImplRefTraits>
class UserResourceControllerStub;

class UserResourceControllerRequestValidator;


class UserResourceController
    : public UserResourceControllerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "qtwebengine.mojom.UserResourceController";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = UserResourceControllerInterfaceBase;
  using Proxy_ = UserResourceControllerProxy;

  template <typename ImplRefTraits>
  using Stub_ = UserResourceControllerStub<ImplRefTraits>;

  using RequestValidator_ = UserResourceControllerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kAddScriptMinVersion = 0,
    kRemoveScriptMinVersion = 0,
    kClearScriptsMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct AddScript_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RemoveScript_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ClearScripts_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~UserResourceController() = default;

  virtual void AddScript(const QtWebEngineCore::UserScriptData& data) = 0;

  virtual void RemoveScript(const QtWebEngineCore::UserScriptData& data) = 0;

  virtual void ClearScripts() = 0;
};



class  UserResourceControllerRenderFrameProxy
    : public UserResourceControllerRenderFrame {
 public:
  using InterfaceType = UserResourceControllerRenderFrame;

  explicit UserResourceControllerRenderFrameProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void AddScript(const QtWebEngineCore::UserScriptData& data) final;
  
  void RemoveScript(const QtWebEngineCore::UserScriptData& data) final;
  
  void ClearScripts() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  UserResourceControllerProxy
    : public UserResourceController {
 public:
  using InterfaceType = UserResourceController;

  explicit UserResourceControllerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void AddScript(const QtWebEngineCore::UserScriptData& data) final;
  
  void RemoveScript(const QtWebEngineCore::UserScriptData& data) final;
  
  void ClearScripts() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  UserResourceControllerRenderFrameStubDispatch {
 public:
  static bool Accept(UserResourceControllerRenderFrame* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      UserResourceControllerRenderFrame* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<UserResourceControllerRenderFrame>>
class UserResourceControllerRenderFrameStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  UserResourceControllerRenderFrameStub() = default;
  ~UserResourceControllerRenderFrameStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return UserResourceControllerRenderFrameStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return UserResourceControllerRenderFrameStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  UserResourceControllerStubDispatch {
 public:
  static bool Accept(UserResourceController* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      UserResourceController* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<UserResourceController>>
class UserResourceControllerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  UserResourceControllerStub() = default;
  ~UserResourceControllerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return UserResourceControllerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return UserResourceControllerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  UserResourceControllerRenderFrameRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  UserResourceControllerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class  UserScriptData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<UserScriptData, T>::value>;
  using DataView = UserScriptDataDataView;
  using Data_ = internal::UserScriptData_Data;

  template <typename... Args>
  static UserScriptDataPtr New(Args&&... args) {
    return UserScriptDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static UserScriptDataPtr From(const U& u) {
    return mojo::TypeConverter<UserScriptDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, UserScriptData>::Convert(*this);
  }


  UserScriptData();

  UserScriptData(
      const std::string& source,
      const ::GURL& url,
      uint8_t injectionPoint,
      bool injectForSubframes,
      uint8_t worldId,
      uint64_t scriptId,
      std::vector<std::string> globs,
      std::vector<std::string> excludeGlobs,
      std::vector<std::string> urlPatterns);


  ~UserScriptData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = UserScriptDataPtr>
  UserScriptDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, UserScriptData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, UserScriptData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, UserScriptData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UserScriptData::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UserScriptData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        UserScriptData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::UserScriptData_UnserializedMessageContext<
            UserType, UserScriptData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<UserScriptData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return UserScriptData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::UserScriptData_UnserializedMessageContext<
            UserType, UserScriptData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<UserScriptData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string source;
  
  ::GURL url;
  
  uint8_t injectionPoint;
  
  bool injectForSubframes;
  
  uint8_t worldId;
  
  uint64_t scriptId;
  
  std::vector<std::string> globs;
  
  std::vector<std::string> excludeGlobs;
  
  std::vector<std::string> urlPatterns;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, UserScriptData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, UserScriptData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, UserScriptData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, UserScriptData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
UserScriptDataPtr UserScriptData::Clone() const {
  return New(
      mojo::Clone(source),
      mojo::Clone(url),
      mojo::Clone(injectionPoint),
      mojo::Clone(injectForSubframes),
      mojo::Clone(worldId),
      mojo::Clone(scriptId),
      mojo::Clone(globs),
      mojo::Clone(excludeGlobs),
      mojo::Clone(urlPatterns)
  );
}

template <typename T, UserScriptData::EnableIfSame<T>*>
bool UserScriptData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->source, other_struct.source))
    return false;
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->injectionPoint, other_struct.injectionPoint))
    return false;
  if (!mojo::Equals(this->injectForSubframes, other_struct.injectForSubframes))
    return false;
  if (!mojo::Equals(this->worldId, other_struct.worldId))
    return false;
  if (!mojo::Equals(this->scriptId, other_struct.scriptId))
    return false;
  if (!mojo::Equals(this->globs, other_struct.globs))
    return false;
  if (!mojo::Equals(this->excludeGlobs, other_struct.excludeGlobs))
    return false;
  if (!mojo::Equals(this->urlPatterns, other_struct.urlPatterns))
    return false;
  return true;
}

template <typename T, UserScriptData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.source < rhs.source)
    return true;
  if (rhs.source < lhs.source)
    return false;
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.injectionPoint < rhs.injectionPoint)
    return true;
  if (rhs.injectionPoint < lhs.injectionPoint)
    return false;
  if (lhs.injectForSubframes < rhs.injectForSubframes)
    return true;
  if (rhs.injectForSubframes < lhs.injectForSubframes)
    return false;
  if (lhs.worldId < rhs.worldId)
    return true;
  if (rhs.worldId < lhs.worldId)
    return false;
  if (lhs.scriptId < rhs.scriptId)
    return true;
  if (rhs.scriptId < lhs.scriptId)
    return false;
  if (lhs.globs < rhs.globs)
    return true;
  if (rhs.globs < lhs.globs)
    return false;
  if (lhs.excludeGlobs < rhs.excludeGlobs)
    return true;
  if (rhs.excludeGlobs < lhs.excludeGlobs)
    return false;
  if (lhs.urlPatterns < rhs.urlPatterns)
    return true;
  if (rhs.urlPatterns < lhs.urlPatterns)
    return false;
  return false;
}


}  // qtwebengine::mojom

namespace mojo {


template <>
struct  StructTraits<::qtwebengine::mojom::UserScriptData::DataView,
                                         ::qtwebengine::mojom::UserScriptDataPtr> {
  static bool IsNull(const ::qtwebengine::mojom::UserScriptDataPtr& input) { return !input; }
  static void SetToNull(::qtwebengine::mojom::UserScriptDataPtr* output) { output->reset(); }

  static const decltype(::qtwebengine::mojom::UserScriptData::source)& source(
      const ::qtwebengine::mojom::UserScriptDataPtr& input) {
    return input->source;
  }

  static const decltype(::qtwebengine::mojom::UserScriptData::url)& url(
      const ::qtwebengine::mojom::UserScriptDataPtr& input) {
    return input->url;
  }

  static decltype(::qtwebengine::mojom::UserScriptData::injectionPoint) injectionPoint(
      const ::qtwebengine::mojom::UserScriptDataPtr& input) {
    return input->injectionPoint;
  }

  static decltype(::qtwebengine::mojom::UserScriptData::injectForSubframes) injectForSubframes(
      const ::qtwebengine::mojom::UserScriptDataPtr& input) {
    return input->injectForSubframes;
  }

  static decltype(::qtwebengine::mojom::UserScriptData::worldId) worldId(
      const ::qtwebengine::mojom::UserScriptDataPtr& input) {
    return input->worldId;
  }

  static decltype(::qtwebengine::mojom::UserScriptData::scriptId) scriptId(
      const ::qtwebengine::mojom::UserScriptDataPtr& input) {
    return input->scriptId;
  }

  static const decltype(::qtwebengine::mojom::UserScriptData::globs)& globs(
      const ::qtwebengine::mojom::UserScriptDataPtr& input) {
    return input->globs;
  }

  static const decltype(::qtwebengine::mojom::UserScriptData::excludeGlobs)& excludeGlobs(
      const ::qtwebengine::mojom::UserScriptDataPtr& input) {
    return input->excludeGlobs;
  }

  static const decltype(::qtwebengine::mojom::UserScriptData::urlPatterns)& urlPatterns(
      const ::qtwebengine::mojom::UserScriptDataPtr& input) {
    return input->urlPatterns;
  }

  static bool Read(::qtwebengine::mojom::UserScriptData::DataView input, ::qtwebengine::mojom::UserScriptDataPtr* output);
};

}  // namespace mojo

#endif  // QTWEBENGINE_USERSCRIPT_USERSCRIPT_MOJOM_H_