// services/data_decoder/public/mojom/image_decoder.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DATA_DECODER_PUBLIC_MOJOM_IMAGE_DECODER_MOJOM_DATA_VIEW_H_
#define SERVICES_DATA_DECODER_PUBLIC_MOJOM_IMAGE_DECODER_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "services/data_decoder/public/mojom/image_decoder.mojom-shared-internal.h"
#include "mojo/public/mojom/base/big_buffer.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "skia/public/mojom/bitmap.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"


namespace data_decoder::mojom {
class AnimationFrameDataView;



}  // data_decoder::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::data_decoder::mojom::AnimationFrameDataView> {
  using Data = ::data_decoder::mojom::internal::AnimationFrame_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace data_decoder::mojom {


enum class ImageCodec : int32_t {
  
  kDefault = 0,
  
  kPng = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, ImageCodec value);
inline bool IsKnownEnumValue(ImageCodec value) {
  return internal::ImageCodec_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class ImageDecoderInterfaceBase {};

using ImageDecoderPtrDataView =
    mojo::InterfacePtrDataView<ImageDecoderInterfaceBase>;
using ImageDecoderRequestDataView =
    mojo::InterfaceRequestDataView<ImageDecoderInterfaceBase>;
using ImageDecoderAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ImageDecoderInterfaceBase>;
using ImageDecoderAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ImageDecoderInterfaceBase>;


class AnimationFrameDataView {
 public:
  AnimationFrameDataView() = default;

  AnimationFrameDataView(
      internal::AnimationFrame_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetBitmapDataView(
      ::skia::mojom::InlineBitmapDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBitmap(UserType* output) {
    
    auto* pointer = data_->bitmap.Get();
    return mojo::internal::Deserialize<::skia::mojom::InlineBitmapDataView>(
        pointer, output, message_);
  }
  inline void GetDurationDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDuration(UserType* output) {
    
    auto* pointer = data_->duration.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
 private:
  internal::AnimationFrame_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // data_decoder::mojom

#endif  // SERVICES_DATA_DECODER_PUBLIC_MOJOM_IMAGE_DECODER_MOJOM_DATA_VIEW_H_