// services/device/public/mojom/hid.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_HID_MOJOM_DATA_VIEW_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_HID_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "services/device/public/mojom/hid.mojom-shared-internal.h"


namespace device::mojom {
class HidUsageAndPageDataView;

class HidReportItemDataView;

class HidReportDescriptionDataView;

class HidCollectionInfoDataView;

class HidDeviceInfoDataView;



}  // device::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::device::mojom::HidUsageAndPageDataView> {
  using Data = ::device::mojom::internal::HidUsageAndPage_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::HidReportItemDataView> {
  using Data = ::device::mojom::internal::HidReportItem_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::HidReportDescriptionDataView> {
  using Data = ::device::mojom::internal::HidReportDescription_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::HidCollectionInfoDataView> {
  using Data = ::device::mojom::internal::HidCollectionInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::HidDeviceInfoDataView> {
  using Data = ::device::mojom::internal::HidDeviceInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace device::mojom {


enum class HidBusType : int32_t {
  
  kHIDBusTypeUSB = 0,
  
  kHIDBusTypeBluetooth = 1,
  
  kHIDBusTypeUnknown = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, HidBusType value);
inline bool IsKnownEnumValue(HidBusType value) {
  return internal::HidBusType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class HidManagerClientInterfaceBase {};

using HidManagerClientPtrDataView =
    mojo::InterfacePtrDataView<HidManagerClientInterfaceBase>;
using HidManagerClientRequestDataView =
    mojo::InterfaceRequestDataView<HidManagerClientInterfaceBase>;
using HidManagerClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<HidManagerClientInterfaceBase>;
using HidManagerClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<HidManagerClientInterfaceBase>;
class HidManagerInterfaceBase {};

using HidManagerPtrDataView =
    mojo::InterfacePtrDataView<HidManagerInterfaceBase>;
using HidManagerRequestDataView =
    mojo::InterfaceRequestDataView<HidManagerInterfaceBase>;
using HidManagerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<HidManagerInterfaceBase>;
using HidManagerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<HidManagerInterfaceBase>;
class HidConnectionInterfaceBase {};

using HidConnectionPtrDataView =
    mojo::InterfacePtrDataView<HidConnectionInterfaceBase>;
using HidConnectionRequestDataView =
    mojo::InterfaceRequestDataView<HidConnectionInterfaceBase>;
using HidConnectionAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<HidConnectionInterfaceBase>;
using HidConnectionAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<HidConnectionInterfaceBase>;
class HidConnectionClientInterfaceBase {};

using HidConnectionClientPtrDataView =
    mojo::InterfacePtrDataView<HidConnectionClientInterfaceBase>;
using HidConnectionClientRequestDataView =
    mojo::InterfaceRequestDataView<HidConnectionClientInterfaceBase>;
using HidConnectionClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<HidConnectionClientInterfaceBase>;
using HidConnectionClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<HidConnectionClientInterfaceBase>;
class HidConnectionWatcherInterfaceBase {};

using HidConnectionWatcherPtrDataView =
    mojo::InterfacePtrDataView<HidConnectionWatcherInterfaceBase>;
using HidConnectionWatcherRequestDataView =
    mojo::InterfaceRequestDataView<HidConnectionWatcherInterfaceBase>;
using HidConnectionWatcherAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<HidConnectionWatcherInterfaceBase>;
using HidConnectionWatcherAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<HidConnectionWatcherInterfaceBase>;


class HidUsageAndPageDataView {
 public:
  HidUsageAndPageDataView() = default;

  HidUsageAndPageDataView(
      internal::HidUsageAndPage_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint16_t usage() const {
    return data_->usage;
  }
  uint16_t usage_page() const {
    return data_->usage_page;
  }
 private:
  internal::HidUsageAndPage_Data* data_ = nullptr;
};


class HidReportItemDataView {
 public:
  HidReportItemDataView() = default;

  HidReportItemDataView(
      internal::HidReportItem_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool is_range() const {
    return data_->is_range;
  }
  bool is_constant() const {
    return data_->is_constant;
  }
  bool is_variable() const {
    return data_->is_variable;
  }
  bool is_relative() const {
    return data_->is_relative;
  }
  bool wrap() const {
    return data_->wrap;
  }
  bool is_non_linear() const {
    return data_->is_non_linear;
  }
  bool no_preferred_state() const {
    return data_->no_preferred_state;
  }
  bool has_null_position() const {
    return data_->has_null_position;
  }
  bool is_volatile() const {
    return data_->is_volatile;
  }
  bool is_buffered_bytes() const {
    return data_->is_buffered_bytes;
  }
  inline void GetUsagesDataView(
      mojo::ArrayDataView<HidUsageAndPageDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUsages(UserType* output) {
    
    auto* pointer = data_->usages.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::HidUsageAndPageDataView>>(
        pointer, output, message_);
  }
  inline void GetUsageMinimumDataView(
      HidUsageAndPageDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUsageMinimum(UserType* output) {
    
    auto* pointer = data_->usage_minimum.Get();
    return mojo::internal::Deserialize<::device::mojom::HidUsageAndPageDataView>(
        pointer, output, message_);
  }
  inline void GetUsageMaximumDataView(
      HidUsageAndPageDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUsageMaximum(UserType* output) {
    
    auto* pointer = data_->usage_maximum.Get();
    return mojo::internal::Deserialize<::device::mojom::HidUsageAndPageDataView>(
        pointer, output, message_);
  }
  uint32_t designator_minimum() const {
    return data_->designator_minimum;
  }
  uint32_t designator_maximum() const {
    return data_->designator_maximum;
  }
  uint32_t string_minimum() const {
    return data_->string_minimum;
  }
  uint32_t string_maximum() const {
    return data_->string_maximum;
  }
  int32_t logical_minimum() const {
    return data_->logical_minimum;
  }
  int32_t logical_maximum() const {
    return data_->logical_maximum;
  }
  int32_t physical_minimum() const {
    return data_->physical_minimum;
  }
  int32_t physical_maximum() const {
    return data_->physical_maximum;
  }
  uint32_t unit_exponent() const {
    return data_->unit_exponent;
  }
  uint32_t unit() const {
    return data_->unit;
  }
  uint32_t report_size() const {
    return data_->report_size;
  }
  uint32_t report_count() const {
    return data_->report_count;
  }
 private:
  internal::HidReportItem_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class HidReportDescriptionDataView {
 public:
  HidReportDescriptionDataView() = default;

  HidReportDescriptionDataView(
      internal::HidReportDescription_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint8_t report_id() const {
    return data_->report_id;
  }
  inline void GetItemsDataView(
      mojo::ArrayDataView<HidReportItemDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadItems(UserType* output) {
    
    auto* pointer = data_->items.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::HidReportItemDataView>>(
        pointer, output, message_);
  }
 private:
  internal::HidReportDescription_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class HidCollectionInfoDataView {
 public:
  HidCollectionInfoDataView() = default;

  HidCollectionInfoDataView(
      internal::HidCollectionInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUsageDataView(
      HidUsageAndPageDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUsage(UserType* output) {
    
    auto* pointer = data_->usage.Get();
    return mojo::internal::Deserialize<::device::mojom::HidUsageAndPageDataView>(
        pointer, output, message_);
  }
  inline void GetReportIdsDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReportIds(UserType* output) {
    
    auto* pointer = data_->report_ids.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  uint32_t collection_type() const {
    return data_->collection_type;
  }
  inline void GetInputReportsDataView(
      mojo::ArrayDataView<HidReportDescriptionDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInputReports(UserType* output) {
    
    auto* pointer = data_->input_reports.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::HidReportDescriptionDataView>>(
        pointer, output, message_);
  }
  inline void GetOutputReportsDataView(
      mojo::ArrayDataView<HidReportDescriptionDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOutputReports(UserType* output) {
    
    auto* pointer = data_->output_reports.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::HidReportDescriptionDataView>>(
        pointer, output, message_);
  }
  inline void GetFeatureReportsDataView(
      mojo::ArrayDataView<HidReportDescriptionDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFeatureReports(UserType* output) {
    
    auto* pointer = data_->feature_reports.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::HidReportDescriptionDataView>>(
        pointer, output, message_);
  }
  inline void GetChildrenDataView(
      mojo::ArrayDataView<HidCollectionInfoDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadChildren(UserType* output) {
    
    auto* pointer = data_->children.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::HidCollectionInfoDataView>>(
        pointer, output, message_);
  }
 private:
  internal::HidCollectionInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class HidDeviceInfoDataView {
 public:
  HidDeviceInfoDataView() = default;

  HidDeviceInfoDataView(
      internal::HidDeviceInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetGuidDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGuid(UserType* output) {
    
    auto* pointer = data_->guid.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetPhysicalDeviceIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPhysicalDeviceId(UserType* output) {
    
    auto* pointer = data_->physical_device_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  uint16_t vendor_id() const {
    return data_->vendor_id;
  }
  uint16_t product_id() const {
    return data_->product_id;
  }
  inline void GetProductNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadProductName(UserType* output) {
    
    auto* pointer = data_->product_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetSerialNumberDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSerialNumber(UserType* output) {
    
    auto* pointer = data_->serial_number.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadBusType(UserType* output) const {
    auto data_value = data_->bus_type;
    return mojo::internal::Deserialize<::device::mojom::HidBusType>(
        data_value, output);
  }
  HidBusType bus_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device::mojom::HidBusType>(data_->bus_type));
  }
  inline void GetReportDescriptorDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReportDescriptor(UserType* output) {
    
    auto* pointer = data_->report_descriptor.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  inline void GetCollectionsDataView(
      mojo::ArrayDataView<HidCollectionInfoDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCollections(UserType* output) {
    
    auto* pointer = data_->collections.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::HidCollectionInfoDataView>>(
        pointer, output, message_);
  }
  bool has_report_id() const {
    return data_->has_report_id;
  }
  uint64_t max_input_report_size() const {
    return data_->max_input_report_size;
  }
  uint64_t max_output_report_size() const {
    return data_->max_output_report_size;
  }
  uint64_t max_feature_report_size() const {
    return data_->max_feature_report_size;
  }
  inline void GetDeviceNodeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDeviceNode(UserType* output) {
    
    auto* pointer = data_->device_node.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetProtectedInputReportIdsDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadProtectedInputReportIds(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<uint8_t>, UserType>(),
    "Attempting to read the optional `protected_input_report_ids` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadProtectedInputReportIds` instead "
    "of `ReadProtectedInputReportIds if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->header_.version >= 1
                    ? data_->protected_input_report_ids.Get() : nullptr;
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  inline void GetProtectedOutputReportIdsDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadProtectedOutputReportIds(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<uint8_t>, UserType>(),
    "Attempting to read the optional `protected_output_report_ids` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadProtectedOutputReportIds` instead "
    "of `ReadProtectedOutputReportIds if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->header_.version >= 1
                    ? data_->protected_output_report_ids.Get() : nullptr;
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  inline void GetProtectedFeatureReportIdsDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadProtectedFeatureReportIds(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<uint8_t>, UserType>(),
    "Attempting to read the optional `protected_feature_report_ids` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadProtectedFeatureReportIds` instead "
    "of `ReadProtectedFeatureReportIds if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->header_.version >= 1
                    ? data_->protected_feature_report_ids.Get() : nullptr;
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  bool is_excluded_by_blocklist() const {
    if (data_->header_.version < 3)
      return bool{};
    return data_->is_excluded_by_blocklist;
  }
 private:
  internal::HidDeviceInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // device::mojom

#endif  // SERVICES_DEVICE_PUBLIC_MOJOM_HID_MOJOM_DATA_VIEW_H_