// services/device/public/mojom/nfc.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_NFC_MOJOM_BLINK_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_NFC_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/device/public/mojom/nfc.mojom-features.h"  // IWYU pragma: export
#include "services/device/public/mojom/nfc.mojom-shared.h"  // IWYU pragma: export
#include "services/device/public/mojom/nfc.mojom-blink-forward.h"  // IWYU pragma: export

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace device::mojom::blink {

class NFCProxy;

template <typename ImplRefTraits>
class NFCStub;

class NFCRequestValidator;
class NFCResponseValidator;


class BLINK_PLATFORM_EXPORT NFC
    : public NFCInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "device.mojom.NFC";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = NFCInterfaceBase;
  using Proxy_ = NFCProxy;

  template <typename ImplRefTraits>
  using Stub_ = NFCStub<ImplRefTraits>;

  using RequestValidator_ = NFCRequestValidator;
  using ResponseValidator_ = NFCResponseValidator;
  enum MethodMinVersions : uint32_t {
    kSetClientMinVersion = 0,
    kPushMinVersion = 0,
    kCancelPushMinVersion = 0,
    kMakeReadOnlyMinVersion = 0,
    kCancelMakeReadOnlyMinVersion = 0,
    kWatchMinVersion = 0,
    kCancelWatchMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetClient_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Push_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CancelPush_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct MakeReadOnly_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CancelMakeReadOnly_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Watch_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CancelWatch_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~NFC() = default;

  virtual void SetClient(::mojo::PendingRemote<NFCClient> client) = 0;

  using PushCallback = base::OnceCallback<void(NDEFErrorPtr)>;
  using PushMojoCallback = base::OnceCallback<void(NDEFErrorPtr)>;

  virtual void Push(NDEFMessagePtr message, NDEFWriteOptionsPtr options, PushCallback callback) = 0;

  virtual void CancelPush() = 0;

  using MakeReadOnlyCallback = base::OnceCallback<void(NDEFErrorPtr)>;
  using MakeReadOnlyMojoCallback = base::OnceCallback<void(NDEFErrorPtr)>;

  virtual void MakeReadOnly(MakeReadOnlyCallback callback) = 0;

  virtual void CancelMakeReadOnly() = 0;

  using WatchCallback = base::OnceCallback<void(NDEFErrorPtr)>;
  using WatchMojoCallback = base::OnceCallback<void(NDEFErrorPtr)>;

  virtual void Watch(uint32_t id, WatchCallback callback) = 0;

  virtual void CancelWatch(uint32_t id) = 0;
};

class NFCClientProxy;

template <typename ImplRefTraits>
class NFCClientStub;

class NFCClientRequestValidator;


class BLINK_PLATFORM_EXPORT NFCClient
    : public NFCClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "device.mojom.NFCClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = NFCClientInterfaceBase;
  using Proxy_ = NFCClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = NFCClientStub<ImplRefTraits>;

  using RequestValidator_ = NFCClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnWatchMinVersion = 0,
    kOnErrorMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnWatch_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnError_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~NFCClient() = default;

  virtual void OnWatch(const ::blink::Vector<uint32_t>& watch_ids, const ::blink::String& serial_number, NDEFMessagePtr message) = 0;

  virtual void OnError(NDEFErrorPtr error) = 0;
};



class BLINK_PLATFORM_EXPORT NFCProxy
    : public NFC {
 public:
  using InterfaceType = NFC;

  explicit NFCProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetClient(::mojo::PendingRemote<NFCClient> client) final;
  
  void Push(NDEFMessagePtr message, NDEFWriteOptionsPtr options, PushCallback callback) final;
  
  void CancelPush() final;
  
  void MakeReadOnly(MakeReadOnlyCallback callback) final;
  
  void CancelMakeReadOnly() final;
  
  void Watch(uint32_t id, WatchCallback callback) final;
  
  void CancelWatch(uint32_t id) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_PLATFORM_EXPORT NFCClientProxy
    : public NFCClient {
 public:
  using InterfaceType = NFCClient;

  explicit NFCClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnWatch(const ::blink::Vector<uint32_t>& watch_ids, const ::blink::String& serial_number, NDEFMessagePtr message) final;
  
  void OnError(NDEFErrorPtr error) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_PLATFORM_EXPORT NFCStubDispatch {
 public:
  static bool Accept(NFC* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      NFC* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<NFC>>
class NFCStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  NFCStub() = default;
  ~NFCStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NFCStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NFCStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT NFCClientStubDispatch {
 public:
  static bool Accept(NFCClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      NFCClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<NFCClient>>
class NFCClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  NFCClientStub() = default;
  ~NFCClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NFCClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NFCClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT NFCRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT NFCClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT NFCResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class BLINK_PLATFORM_EXPORT NDEFError {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<NDEFError, T>::value>;
  using DataView = NDEFErrorDataView;
  using Data_ = internal::NDEFError_Data;

  template <typename... Args>
  static NDEFErrorPtr New(Args&&... args) {
    return NDEFErrorPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static NDEFErrorPtr From(const U& u) {
    return mojo::TypeConverter<NDEFErrorPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, NDEFError>::Convert(*this);
  }


  NDEFError();

  NDEFError(
      NDEFErrorType error_type,
      const ::blink::String& error_message);


  ~NDEFError();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = NDEFErrorPtr>
  NDEFErrorPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, NDEFError::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, NDEFError::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, NDEFError::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NDEFError::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NDEFError::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        NDEFError::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::NDEFError_UnserializedMessageContext<
            UserType, NDEFError::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<NDEFError::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return NDEFError::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::NDEFError_UnserializedMessageContext<
            UserType, NDEFError::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<NDEFError::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  NDEFErrorType error_type;
  
  ::blink::String error_message;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, NDEFError::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, NDEFError::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, NDEFError::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, NDEFError::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class BLINK_PLATFORM_EXPORT NDEFWriteOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<NDEFWriteOptions, T>::value>;
  using DataView = NDEFWriteOptionsDataView;
  using Data_ = internal::NDEFWriteOptions_Data;

  template <typename... Args>
  static NDEFWriteOptionsPtr New(Args&&... args) {
    return NDEFWriteOptionsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static NDEFWriteOptionsPtr From(const U& u) {
    return mojo::TypeConverter<NDEFWriteOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, NDEFWriteOptions>::Convert(*this);
  }


  NDEFWriteOptions();

  explicit NDEFWriteOptions(
      bool overwrite);


  ~NDEFWriteOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = NDEFWriteOptionsPtr>
  NDEFWriteOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, NDEFWriteOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, NDEFWriteOptions::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, NDEFWriteOptions::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NDEFWriteOptions::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NDEFWriteOptions::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        NDEFWriteOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::NDEFWriteOptions_UnserializedMessageContext<
            UserType, NDEFWriteOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<NDEFWriteOptions::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return NDEFWriteOptions::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::NDEFWriteOptions_UnserializedMessageContext<
            UserType, NDEFWriteOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<NDEFWriteOptions::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool overwrite;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, NDEFWriteOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, NDEFWriteOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, NDEFWriteOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, NDEFWriteOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}








class BLINK_PLATFORM_EXPORT NDEFRecord {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<NDEFRecord, T>::value>;
  using DataView = NDEFRecordDataView;
  using Data_ = internal::NDEFRecord_Data;

  template <typename... Args>
  static NDEFRecordPtr New(Args&&... args) {
    return NDEFRecordPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static NDEFRecordPtr From(const U& u) {
    return mojo::TypeConverter<NDEFRecordPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, NDEFRecord>::Convert(*this);
  }


  NDEFRecord();

  NDEFRecord(
      NDEFRecordTypeCategory category,
      const ::blink::String& record_type,
      const ::blink::String& media_type,
      const ::blink::String& id,
      const ::blink::String& encoding,
      const ::blink::String& lang,
      ::blink::Vector<uint8_t> data,
      NDEFMessagePtr payload_message);

NDEFRecord(const NDEFRecord&) = delete;
NDEFRecord& operator=(const NDEFRecord&) = delete;

  ~NDEFRecord();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = NDEFRecordPtr>
  NDEFRecordPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, NDEFRecord::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, NDEFRecord::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, NDEFRecord::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NDEFRecord::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NDEFRecord::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        NDEFRecord::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::NDEFRecord_UnserializedMessageContext<
            UserType, NDEFRecord::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<NDEFRecord::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return NDEFRecord::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::NDEFRecord_UnserializedMessageContext<
            UserType, NDEFRecord::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<NDEFRecord::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  NDEFRecordTypeCategory category;
  
  ::blink::String record_type;
  
  ::blink::String media_type;
  
  ::blink::String id;
  
  ::blink::String encoding;
  
  ::blink::String lang;
  
  ::blink::Vector<uint8_t> data;
  
  NDEFMessagePtr payload_message;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, NDEFRecord::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, NDEFRecord::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, NDEFRecord::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, NDEFRecord::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT NDEFMessage {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<NDEFMessage, T>::value>;
  using DataView = NDEFMessageDataView;
  using Data_ = internal::NDEFMessage_Data;

  template <typename... Args>
  static NDEFMessagePtr New(Args&&... args) {
    return NDEFMessagePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static NDEFMessagePtr From(const U& u) {
    return mojo::TypeConverter<NDEFMessagePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, NDEFMessage>::Convert(*this);
  }


  NDEFMessage();

  explicit NDEFMessage(
      ::blink::Vector<NDEFRecordPtr> data);

NDEFMessage(const NDEFMessage&) = delete;
NDEFMessage& operator=(const NDEFMessage&) = delete;

  ~NDEFMessage();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = NDEFMessagePtr>
  NDEFMessagePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, NDEFMessage::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, NDEFMessage::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, NDEFMessage::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NDEFMessage::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NDEFMessage::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        NDEFMessage::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::NDEFMessage_UnserializedMessageContext<
            UserType, NDEFMessage::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<NDEFMessage::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return NDEFMessage::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::NDEFMessage_UnserializedMessageContext<
            UserType, NDEFMessage::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<NDEFMessage::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::Vector<NDEFRecordPtr> data;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, NDEFMessage::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, NDEFMessage::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, NDEFMessage::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, NDEFMessage::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}


template <typename StructPtrType>
NDEFErrorPtr NDEFError::Clone() const {
  return New(
      mojo::Clone(error_type),
      mojo::Clone(error_message)
  );
}

template <typename T, NDEFError::EnableIfSame<T>*>
bool NDEFError::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->error_type, other_struct.error_type))
    return false;
  if (!mojo::Equals(this->error_message, other_struct.error_message))
    return false;
  return true;
}

template <typename T, NDEFError::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.error_type < rhs.error_type)
    return true;
  if (rhs.error_type < lhs.error_type)
    return false;
  if (lhs.error_message < rhs.error_message)
    return true;
  if (rhs.error_message < lhs.error_message)
    return false;
  return false;
}
template <typename StructPtrType>
NDEFRecordPtr NDEFRecord::Clone() const {
  return New(
      mojo::Clone(category),
      mojo::Clone(record_type),
      mojo::Clone(media_type),
      mojo::Clone(id),
      mojo::Clone(encoding),
      mojo::Clone(lang),
      mojo::Clone(data),
      mojo::Clone(payload_message)
  );
}

template <typename T, NDEFRecord::EnableIfSame<T>*>
bool NDEFRecord::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->category, other_struct.category))
    return false;
  if (!mojo::Equals(this->record_type, other_struct.record_type))
    return false;
  if (!mojo::Equals(this->media_type, other_struct.media_type))
    return false;
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->encoding, other_struct.encoding))
    return false;
  if (!mojo::Equals(this->lang, other_struct.lang))
    return false;
  if (!mojo::Equals(this->data, other_struct.data))
    return false;
  if (!mojo::Equals(this->payload_message, other_struct.payload_message))
    return false;
  return true;
}

template <typename T, NDEFRecord::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.category < rhs.category)
    return true;
  if (rhs.category < lhs.category)
    return false;
  if (lhs.record_type < rhs.record_type)
    return true;
  if (rhs.record_type < lhs.record_type)
    return false;
  if (lhs.media_type < rhs.media_type)
    return true;
  if (rhs.media_type < lhs.media_type)
    return false;
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.encoding < rhs.encoding)
    return true;
  if (rhs.encoding < lhs.encoding)
    return false;
  if (lhs.lang < rhs.lang)
    return true;
  if (rhs.lang < lhs.lang)
    return false;
  if (lhs.data < rhs.data)
    return true;
  if (rhs.data < lhs.data)
    return false;
  if (lhs.payload_message < rhs.payload_message)
    return true;
  if (rhs.payload_message < lhs.payload_message)
    return false;
  return false;
}
template <typename StructPtrType>
NDEFMessagePtr NDEFMessage::Clone() const {
  return New(
      mojo::Clone(data)
  );
}

template <typename T, NDEFMessage::EnableIfSame<T>*>
bool NDEFMessage::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->data, other_struct.data))
    return false;
  return true;
}

template <typename T, NDEFMessage::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.data < rhs.data)
    return true;
  if (rhs.data < lhs.data)
    return false;
  return false;
}
template <typename StructPtrType>
NDEFWriteOptionsPtr NDEFWriteOptions::Clone() const {
  return New(
      mojo::Clone(overwrite)
  );
}

template <typename T, NDEFWriteOptions::EnableIfSame<T>*>
bool NDEFWriteOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->overwrite, other_struct.overwrite))
    return false;
  return true;
}

template <typename T, NDEFWriteOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.overwrite < rhs.overwrite)
    return true;
  if (rhs.overwrite < lhs.overwrite)
    return false;
  return false;
}


}  // device::mojom::blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::device::mojom::blink::NDEFError::DataView,
                                         ::device::mojom::blink::NDEFErrorPtr> {
  static bool IsNull(const ::device::mojom::blink::NDEFErrorPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::NDEFErrorPtr* output) { output->reset(); }

  static decltype(::device::mojom::blink::NDEFError::error_type) error_type(
      const ::device::mojom::blink::NDEFErrorPtr& input) {
    return input->error_type;
  }

  static const decltype(::device::mojom::blink::NDEFError::error_message)& error_message(
      const ::device::mojom::blink::NDEFErrorPtr& input) {
    return input->error_message;
  }

  static bool Read(::device::mojom::blink::NDEFError::DataView input, ::device::mojom::blink::NDEFErrorPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::device::mojom::blink::NDEFRecord::DataView,
                                         ::device::mojom::blink::NDEFRecordPtr> {
  static bool IsNull(const ::device::mojom::blink::NDEFRecordPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::NDEFRecordPtr* output) { output->reset(); }

  static decltype(::device::mojom::blink::NDEFRecord::category) category(
      const ::device::mojom::blink::NDEFRecordPtr& input) {
    return input->category;
  }

  static const decltype(::device::mojom::blink::NDEFRecord::record_type)& record_type(
      const ::device::mojom::blink::NDEFRecordPtr& input) {
    return input->record_type;
  }

  static const decltype(::device::mojom::blink::NDEFRecord::media_type)& media_type(
      const ::device::mojom::blink::NDEFRecordPtr& input) {
    return input->media_type;
  }

  static const decltype(::device::mojom::blink::NDEFRecord::id)& id(
      const ::device::mojom::blink::NDEFRecordPtr& input) {
    return input->id;
  }

  static const decltype(::device::mojom::blink::NDEFRecord::encoding)& encoding(
      const ::device::mojom::blink::NDEFRecordPtr& input) {
    return input->encoding;
  }

  static const decltype(::device::mojom::blink::NDEFRecord::lang)& lang(
      const ::device::mojom::blink::NDEFRecordPtr& input) {
    return input->lang;
  }

  static const decltype(::device::mojom::blink::NDEFRecord::data)& data(
      const ::device::mojom::blink::NDEFRecordPtr& input) {
    return input->data;
  }

  static const decltype(::device::mojom::blink::NDEFRecord::payload_message)& payload_message(
      const ::device::mojom::blink::NDEFRecordPtr& input) {
    return input->payload_message;
  }

  static bool Read(::device::mojom::blink::NDEFRecord::DataView input, ::device::mojom::blink::NDEFRecordPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::device::mojom::blink::NDEFMessage::DataView,
                                         ::device::mojom::blink::NDEFMessagePtr> {
  static bool IsNull(const ::device::mojom::blink::NDEFMessagePtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::NDEFMessagePtr* output) { output->reset(); }

  static const decltype(::device::mojom::blink::NDEFMessage::data)& data(
      const ::device::mojom::blink::NDEFMessagePtr& input) {
    return input->data;
  }

  static bool Read(::device::mojom::blink::NDEFMessage::DataView input, ::device::mojom::blink::NDEFMessagePtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::device::mojom::blink::NDEFWriteOptions::DataView,
                                         ::device::mojom::blink::NDEFWriteOptionsPtr> {
  static bool IsNull(const ::device::mojom::blink::NDEFWriteOptionsPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::NDEFWriteOptionsPtr* output) { output->reset(); }

  static decltype(::device::mojom::blink::NDEFWriteOptions::overwrite) overwrite(
      const ::device::mojom::blink::NDEFWriteOptionsPtr& input) {
    return input->overwrite;
  }

  static bool Read(::device::mojom::blink::NDEFWriteOptions::DataView input, ::device::mojom::blink::NDEFWriteOptionsPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_DEVICE_PUBLIC_MOJOM_NFC_MOJOM_BLINK_H_