// services/device/public/mojom/smart_card.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_SMART_CARD_MOJOM_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_SMART_CARD_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/device/public/mojom/smart_card.mojom-features.h"  // IWYU pragma: export
#include "services/device/public/mojom/smart_card.mojom-shared.h"  // IWYU pragma: export
#include "services/device/public/mojom/smart_card.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/time.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace device::mojom {

class SmartCardTransactionProxy;

template <typename ImplRefTraits>
class SmartCardTransactionStub;

class SmartCardTransactionRequestValidator;
class SmartCardTransactionResponseValidator;


class SmartCardTransaction
    : public SmartCardTransactionInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "device.mojom.SmartCardTransaction";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SmartCardTransactionInterfaceBase;
  using Proxy_ = SmartCardTransactionProxy;

  template <typename ImplRefTraits>
  using Stub_ = SmartCardTransactionStub<ImplRefTraits>;

  using RequestValidator_ = SmartCardTransactionRequestValidator;
  using ResponseValidator_ = SmartCardTransactionResponseValidator;
  enum MethodMinVersions : uint32_t {
    kEndTransactionMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct EndTransaction_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SmartCardTransaction() = default;

  using EndTransactionCallback = base::OnceCallback<void(SmartCardResultPtr)>;
  using EndTransactionMojoCallback = base::OnceCallback<void(SmartCardResultPtr)>;

  virtual void EndTransaction(SmartCardDisposition disposition, EndTransactionCallback callback) = 0;
};

class SmartCardConnectionProxy;

template <typename ImplRefTraits>
class SmartCardConnectionStub;

class SmartCardConnectionRequestValidator;
class SmartCardConnectionResponseValidator;


class SmartCardConnection
    : public SmartCardConnectionInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "device.mojom.SmartCardConnection";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SmartCardConnectionInterfaceBase;
  using Proxy_ = SmartCardConnectionProxy;

  template <typename ImplRefTraits>
  using Stub_ = SmartCardConnectionStub<ImplRefTraits>;

  using RequestValidator_ = SmartCardConnectionRequestValidator;
  using ResponseValidator_ = SmartCardConnectionResponseValidator;
  enum MethodMinVersions : uint32_t {
    kDisconnectMinVersion = 0,
    kTransmitMinVersion = 0,
    kControlMinVersion = 0,
    kGetAttribMinVersion = 0,
    kSetAttribMinVersion = 0,
    kStatusMinVersion = 0,
    kBeginTransactionMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Disconnect_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Transmit_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Control_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetAttrib_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetAttrib_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Status_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct BeginTransaction_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SmartCardConnection() = default;

  using DisconnectCallback = base::OnceCallback<void(SmartCardResultPtr)>;
  using DisconnectMojoCallback = base::OnceCallback<void(SmartCardResultPtr)>;

  virtual void Disconnect(SmartCardDisposition disposition, DisconnectCallback callback) = 0;

  using TransmitCallback = base::OnceCallback<void(SmartCardDataResultPtr)>;
  using TransmitMojoCallback = base::OnceCallback<void(SmartCardDataResultPtr)>;

  virtual void Transmit(SmartCardProtocol protocol, const std::vector<uint8_t>& data, TransmitCallback callback) = 0;

  using ControlCallback = base::OnceCallback<void(SmartCardDataResultPtr)>;
  using ControlMojoCallback = base::OnceCallback<void(SmartCardDataResultPtr)>;

  virtual void Control(uint32_t control_code, const std::vector<uint8_t>& data, ControlCallback callback) = 0;

  using GetAttribCallback = base::OnceCallback<void(SmartCardDataResultPtr)>;
  using GetAttribMojoCallback = base::OnceCallback<void(SmartCardDataResultPtr)>;

  virtual void GetAttrib(uint32_t id, GetAttribCallback callback) = 0;

  using SetAttribCallback = base::OnceCallback<void(SmartCardResultPtr)>;
  using SetAttribMojoCallback = base::OnceCallback<void(SmartCardResultPtr)>;

  virtual void SetAttrib(uint32_t id, const std::vector<uint8_t>& data, SetAttribCallback callback) = 0;

  using StatusCallback = base::OnceCallback<void(SmartCardStatusResultPtr)>;
  using StatusMojoCallback = base::OnceCallback<void(SmartCardStatusResultPtr)>;

  virtual void Status(StatusCallback callback) = 0;

  using BeginTransactionCallback = base::OnceCallback<void(SmartCardTransactionResultPtr)>;
  using BeginTransactionMojoCallback = base::OnceCallback<void(SmartCardTransactionResultPtr)>;

  virtual void BeginTransaction(BeginTransactionCallback callback) = 0;
};

class SmartCardConnectionWatcherProxy;

template <typename ImplRefTraits>
class SmartCardConnectionWatcherStub;

class SmartCardConnectionWatcherRequestValidator;


class SmartCardConnectionWatcher
    : public SmartCardConnectionWatcherInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "device.mojom.SmartCardConnectionWatcher";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SmartCardConnectionWatcherInterfaceBase;
  using Proxy_ = SmartCardConnectionWatcherProxy;

  template <typename ImplRefTraits>
  using Stub_ = SmartCardConnectionWatcherStub<ImplRefTraits>;

  using RequestValidator_ = SmartCardConnectionWatcherRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kNotifyConnectionUsedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct NotifyConnectionUsed_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SmartCardConnectionWatcher() = default;

  virtual void NotifyConnectionUsed() = 0;
};

class SmartCardContextProxy;

template <typename ImplRefTraits>
class SmartCardContextStub;

class SmartCardContextRequestValidator;
class SmartCardContextResponseValidator;


class SmartCardContext
    : public SmartCardContextInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "device.mojom.SmartCardContext";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SmartCardContextInterfaceBase;
  using Proxy_ = SmartCardContextProxy;

  template <typename ImplRefTraits>
  using Stub_ = SmartCardContextStub<ImplRefTraits>;

  using RequestValidator_ = SmartCardContextRequestValidator;
  using ResponseValidator_ = SmartCardContextResponseValidator;
  enum MethodMinVersions : uint32_t {
    kListReadersMinVersion = 0,
    kGetStatusChangeMinVersion = 0,
    kCancelMinVersion = 0,
    kConnectMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct ListReaders_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetStatusChange_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Cancel_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Connect_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SmartCardContext() = default;

  using ListReadersCallback = base::OnceCallback<void(SmartCardListReadersResultPtr)>;
  using ListReadersMojoCallback = base::OnceCallback<void(SmartCardListReadersResultPtr)>;

  virtual void ListReaders(ListReadersCallback callback) = 0;

  using GetStatusChangeCallback = base::OnceCallback<void(SmartCardStatusChangeResultPtr)>;
  using GetStatusChangeMojoCallback = base::OnceCallback<void(SmartCardStatusChangeResultPtr)>;

  virtual void GetStatusChange(::base::TimeDelta timeout, std::vector<SmartCardReaderStateInPtr> reader_states, GetStatusChangeCallback callback) = 0;

  using CancelCallback = base::OnceCallback<void(SmartCardResultPtr)>;
  using CancelMojoCallback = base::OnceCallback<void(SmartCardResultPtr)>;

  virtual void Cancel(CancelCallback callback) = 0;

  using ConnectCallback = base::OnceCallback<void(SmartCardConnectResultPtr)>;
  using ConnectMojoCallback = base::OnceCallback<void(SmartCardConnectResultPtr)>;

  virtual void Connect(const std::string& reader, SmartCardShareMode share_mode, SmartCardProtocolsPtr preferred_protocols, ::mojo::PendingRemote<SmartCardConnectionWatcher> connection_watcher, ConnectCallback callback) = 0;
};

class SmartCardContextFactoryProxy;

template <typename ImplRefTraits>
class SmartCardContextFactoryStub;

class SmartCardContextFactoryRequestValidator;
class SmartCardContextFactoryResponseValidator;


class SmartCardContextFactory
    : public SmartCardContextFactoryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "device.mojom.SmartCardContextFactory";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SmartCardContextFactoryInterfaceBase;
  using Proxy_ = SmartCardContextFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = SmartCardContextFactoryStub<ImplRefTraits>;

  using RequestValidator_ = SmartCardContextFactoryRequestValidator;
  using ResponseValidator_ = SmartCardContextFactoryResponseValidator;
  enum MethodMinVersions : uint32_t {
    kCreateContextMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreateContext_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SmartCardContextFactory() = default;

  using CreateContextCallback = base::OnceCallback<void(SmartCardCreateContextResultPtr)>;
  using CreateContextMojoCallback = base::OnceCallback<void(SmartCardCreateContextResultPtr)>;

  virtual void CreateContext(CreateContextCallback callback) = 0;
};



class  SmartCardTransactionProxy
    : public SmartCardTransaction {
 public:
  using InterfaceType = SmartCardTransaction;

  explicit SmartCardTransactionProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void EndTransaction(SmartCardDisposition disposition, EndTransactionCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  SmartCardConnectionProxy
    : public SmartCardConnection {
 public:
  using InterfaceType = SmartCardConnection;

  explicit SmartCardConnectionProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Disconnect(SmartCardDisposition disposition, DisconnectCallback callback) final;
  
  void Transmit(SmartCardProtocol protocol, const std::vector<uint8_t>& data, TransmitCallback callback) final;
  
  void Control(uint32_t control_code, const std::vector<uint8_t>& data, ControlCallback callback) final;
  
  void GetAttrib(uint32_t id, GetAttribCallback callback) final;
  
  void SetAttrib(uint32_t id, const std::vector<uint8_t>& data, SetAttribCallback callback) final;
  
  void Status(StatusCallback callback) final;
  
  void BeginTransaction(BeginTransactionCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  SmartCardConnectionWatcherProxy
    : public SmartCardConnectionWatcher {
 public:
  using InterfaceType = SmartCardConnectionWatcher;

  explicit SmartCardConnectionWatcherProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void NotifyConnectionUsed() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  SmartCardContextProxy
    : public SmartCardContext {
 public:
  using InterfaceType = SmartCardContext;

  explicit SmartCardContextProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ListReaders(ListReadersCallback callback) final;
  
  void GetStatusChange(::base::TimeDelta timeout, std::vector<SmartCardReaderStateInPtr> reader_states, GetStatusChangeCallback callback) final;
  
  void Cancel(CancelCallback callback) final;
  
  void Connect(const std::string& reader, SmartCardShareMode share_mode, SmartCardProtocolsPtr preferred_protocols, ::mojo::PendingRemote<SmartCardConnectionWatcher> connection_watcher, ConnectCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  SmartCardContextFactoryProxy
    : public SmartCardContextFactory {
 public:
  using InterfaceType = SmartCardContextFactory;

  explicit SmartCardContextFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateContext(CreateContextCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  SmartCardTransactionStubDispatch {
 public:
  static bool Accept(SmartCardTransaction* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SmartCardTransaction* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SmartCardTransaction>>
class SmartCardTransactionStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SmartCardTransactionStub() = default;
  ~SmartCardTransactionStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SmartCardTransactionStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SmartCardTransactionStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  SmartCardConnectionStubDispatch {
 public:
  static bool Accept(SmartCardConnection* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SmartCardConnection* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SmartCardConnection>>
class SmartCardConnectionStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SmartCardConnectionStub() = default;
  ~SmartCardConnectionStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SmartCardConnectionStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SmartCardConnectionStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  SmartCardConnectionWatcherStubDispatch {
 public:
  static bool Accept(SmartCardConnectionWatcher* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SmartCardConnectionWatcher* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SmartCardConnectionWatcher>>
class SmartCardConnectionWatcherStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SmartCardConnectionWatcherStub() = default;
  ~SmartCardConnectionWatcherStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SmartCardConnectionWatcherStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SmartCardConnectionWatcherStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  SmartCardContextStubDispatch {
 public:
  static bool Accept(SmartCardContext* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SmartCardContext* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SmartCardContext>>
class SmartCardContextStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SmartCardContextStub() = default;
  ~SmartCardContextStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SmartCardContextStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SmartCardContextStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  SmartCardContextFactoryStubDispatch {
 public:
  static bool Accept(SmartCardContextFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SmartCardContextFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SmartCardContextFactory>>
class SmartCardContextFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SmartCardContextFactoryStub() = default;
  ~SmartCardContextFactoryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SmartCardContextFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SmartCardContextFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  SmartCardTransactionRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  SmartCardConnectionRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  SmartCardConnectionWatcherRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  SmartCardContextRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  SmartCardContextFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  SmartCardTransactionResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  SmartCardConnectionResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  SmartCardContextResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  SmartCardContextFactoryResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class  SmartCardProtocols {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SmartCardProtocols, T>::value>;
  using DataView = SmartCardProtocolsDataView;
  using Data_ = internal::SmartCardProtocols_Data;

  template <typename... Args>
  static SmartCardProtocolsPtr New(Args&&... args) {
    return SmartCardProtocolsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SmartCardProtocolsPtr From(const U& u) {
    return mojo::TypeConverter<SmartCardProtocolsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SmartCardProtocols>::Convert(*this);
  }


  SmartCardProtocols();

  SmartCardProtocols(
      bool t0,
      bool t1,
      bool raw);


  ~SmartCardProtocols();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SmartCardProtocolsPtr>
  SmartCardProtocolsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SmartCardProtocols::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SmartCardProtocols::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SmartCardProtocols::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SmartCardProtocols::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SmartCardProtocols::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SmartCardProtocols::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SmartCardProtocols_UnserializedMessageContext<
            UserType, SmartCardProtocols::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SmartCardProtocols::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SmartCardProtocols::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SmartCardProtocols_UnserializedMessageContext<
            UserType, SmartCardProtocols::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SmartCardProtocols::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool t0;
  
  bool t1;
  
  bool raw;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SmartCardProtocols::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SmartCardProtocols::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SmartCardProtocols::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SmartCardProtocols::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class  SmartCardResult {
 public:
  using DataView = SmartCardResultDataView;
  using Data_ = internal::SmartCardResult_Data;
  using Tag = Data_::SmartCardResult_Tag;

  template <typename... Args>
  static SmartCardResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |success|.
  static SmartCardResultPtr NewSuccess(
      SmartCardSuccess value);
  // Construct an instance holding |error|.
  static SmartCardResultPtr NewError(
      SmartCardError value);

  template <typename U>
  static SmartCardResultPtr From(const U& u) {
    return mojo::TypeConverter<SmartCardResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SmartCardResult>::Convert(*this);
  }
  ~SmartCardResult();


  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = SmartCardResultPtr>
  SmartCardResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, SmartCardResult>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, SmartCardResult>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }
  size_t Hash(size_t seed) const;

  Tag which() const {
    return tag_;
  }

  bool is_success() const { return tag_ == Tag::kSuccess; }
  SmartCardSuccess get_success() const {
    CHECK(tag_ == Tag::kSuccess);
    return data_.success;
  }
  void set_success(SmartCardSuccess success);

  bool is_error() const { return tag_ == Tag::kError; }
  SmartCardError get_error() const {
    CHECK(tag_ == Tag::kError);
    return data_.error;
  }
  void set_error(SmartCardError error);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SmartCardResult::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<SmartCardResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
        SmartCardSuccess value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kError)>,
        SmartCardError value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    SmartCardSuccess success;
    SmartCardError error;
  };

  SmartCardResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
      SmartCardSuccess value);
  SmartCardResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kError)>,
      SmartCardError value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class  SmartCardStatusChangeResult {
 public:
  using DataView = SmartCardStatusChangeResultDataView;
  using Data_ = internal::SmartCardStatusChangeResult_Data;
  using Tag = Data_::SmartCardStatusChangeResult_Tag;

  template <typename... Args>
  static SmartCardStatusChangeResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |reader_states|.
  static SmartCardStatusChangeResultPtr NewReaderStates(
      std::vector<SmartCardReaderStateOutPtr> value);
  // Construct an instance holding |error|.
  static SmartCardStatusChangeResultPtr NewError(
      SmartCardError value);

  template <typename U>
  static SmartCardStatusChangeResultPtr From(const U& u) {
    return mojo::TypeConverter<SmartCardStatusChangeResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SmartCardStatusChangeResult>::Convert(*this);
  }
  ~SmartCardStatusChangeResult();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  SmartCardStatusChangeResult(const SmartCardStatusChangeResult& other) = delete;
  SmartCardStatusChangeResult& operator=(const SmartCardStatusChangeResult& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = SmartCardStatusChangeResultPtr>
  SmartCardStatusChangeResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, SmartCardStatusChangeResult>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, SmartCardStatusChangeResult>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_reader_states() const { return tag_ == Tag::kReaderStates; }
  const std::vector<SmartCardReaderStateOutPtr>& get_reader_states() const {
    CHECK(tag_ == Tag::kReaderStates);
    return data_.reader_states;
  }
  std::vector<SmartCardReaderStateOutPtr>& get_reader_states() {
    CHECK(tag_ == Tag::kReaderStates);
    return data_.reader_states;
  }
  void set_reader_states(std::vector<SmartCardReaderStateOutPtr> reader_states);

  bool is_error() const { return tag_ == Tag::kError; }
  SmartCardError get_error() const {
    CHECK(tag_ == Tag::kError);
    return data_.error;
  }
  void set_error(SmartCardError error);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SmartCardStatusChangeResult::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<SmartCardStatusChangeResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kReaderStates)>,
        std::vector<SmartCardReaderStateOutPtr> value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kError)>,
        SmartCardError value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    std::vector<SmartCardReaderStateOutPtr> reader_states;
    SmartCardError error;
  };

  SmartCardStatusChangeResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kReaderStates)>,
      std::vector<SmartCardReaderStateOutPtr> value);
  SmartCardStatusChangeResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kError)>,
      SmartCardError value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class  SmartCardListReadersResult {
 public:
  using DataView = SmartCardListReadersResultDataView;
  using Data_ = internal::SmartCardListReadersResult_Data;
  using Tag = Data_::SmartCardListReadersResult_Tag;

  template <typename... Args>
  static SmartCardListReadersResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |readers|.
  static SmartCardListReadersResultPtr NewReaders(
      std::vector<std::string> value);
  // Construct an instance holding |error|.
  static SmartCardListReadersResultPtr NewError(
      SmartCardError value);

  template <typename U>
  static SmartCardListReadersResultPtr From(const U& u) {
    return mojo::TypeConverter<SmartCardListReadersResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SmartCardListReadersResult>::Convert(*this);
  }
  ~SmartCardListReadersResult();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  SmartCardListReadersResult(const SmartCardListReadersResult& other) = delete;
  SmartCardListReadersResult& operator=(const SmartCardListReadersResult& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = SmartCardListReadersResultPtr>
  SmartCardListReadersResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, SmartCardListReadersResult>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, SmartCardListReadersResult>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_readers() const { return tag_ == Tag::kReaders; }
  const std::vector<std::string>& get_readers() const {
    CHECK(tag_ == Tag::kReaders);
    return data_.readers;
  }
  std::vector<std::string>& get_readers() {
    CHECK(tag_ == Tag::kReaders);
    return data_.readers;
  }
  void set_readers(std::vector<std::string> readers);

  bool is_error() const { return tag_ == Tag::kError; }
  SmartCardError get_error() const {
    CHECK(tag_ == Tag::kError);
    return data_.error;
  }
  void set_error(SmartCardError error);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SmartCardListReadersResult::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<SmartCardListReadersResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kReaders)>,
        std::vector<std::string> value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kError)>,
        SmartCardError value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    std::vector<std::string> readers;
    SmartCardError error;
  };

  SmartCardListReadersResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kReaders)>,
      std::vector<std::string> value);
  SmartCardListReadersResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kError)>,
      SmartCardError value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class  SmartCardCreateContextResult {
 public:
  using DataView = SmartCardCreateContextResultDataView;
  using Data_ = internal::SmartCardCreateContextResult_Data;
  using Tag = Data_::SmartCardCreateContextResult_Tag;

  template <typename... Args>
  static SmartCardCreateContextResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |context|.
  static SmartCardCreateContextResultPtr NewContext(
      ::mojo::PendingRemote<SmartCardContext> value);
  // Construct an instance holding |error|.
  static SmartCardCreateContextResultPtr NewError(
      SmartCardError value);

  template <typename U>
  static SmartCardCreateContextResultPtr From(const U& u) {
    return mojo::TypeConverter<SmartCardCreateContextResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SmartCardCreateContextResult>::Convert(*this);
  }
  ~SmartCardCreateContextResult();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  SmartCardCreateContextResult(const SmartCardCreateContextResult& other) = delete;
  SmartCardCreateContextResult& operator=(const SmartCardCreateContextResult& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = SmartCardCreateContextResultPtr>
  SmartCardCreateContextResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, SmartCardCreateContextResult>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, SmartCardCreateContextResult>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_context() const { return tag_ == Tag::kContext; }
  const ::mojo::PendingRemote<SmartCardContext>& get_context() const {
    CHECK(tag_ == Tag::kContext);
    return data_.context;
  }
  ::mojo::PendingRemote<SmartCardContext>& get_context() {
    CHECK(tag_ == Tag::kContext);
    return data_.context;
  }
  void set_context(::mojo::PendingRemote<SmartCardContext> context);

  bool is_error() const { return tag_ == Tag::kError; }
  SmartCardError get_error() const {
    CHECK(tag_ == Tag::kError);
    return data_.error;
  }
  void set_error(SmartCardError error);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SmartCardCreateContextResult::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<SmartCardCreateContextResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kContext)>,
        ::mojo::PendingRemote<SmartCardContext> value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kError)>,
        SmartCardError value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    ::mojo::PendingRemote<SmartCardContext> context;
    SmartCardError error;
  };

  SmartCardCreateContextResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kContext)>,
      ::mojo::PendingRemote<SmartCardContext> value);
  SmartCardCreateContextResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kError)>,
      SmartCardError value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class  SmartCardConnectResult {
 public:
  using DataView = SmartCardConnectResultDataView;
  using Data_ = internal::SmartCardConnectResult_Data;
  using Tag = Data_::SmartCardConnectResult_Tag;

  template <typename... Args>
  static SmartCardConnectResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |success|.
  static SmartCardConnectResultPtr NewSuccess(
      SmartCardConnectSuccessPtr value);
  // Construct an instance holding |error|.
  static SmartCardConnectResultPtr NewError(
      SmartCardError value);

  template <typename U>
  static SmartCardConnectResultPtr From(const U& u) {
    return mojo::TypeConverter<SmartCardConnectResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SmartCardConnectResult>::Convert(*this);
  }
  ~SmartCardConnectResult();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  SmartCardConnectResult(const SmartCardConnectResult& other) = delete;
  SmartCardConnectResult& operator=(const SmartCardConnectResult& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = SmartCardConnectResultPtr>
  SmartCardConnectResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, SmartCardConnectResult>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, SmartCardConnectResult>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_success() const { return tag_ == Tag::kSuccess; }
  const SmartCardConnectSuccessPtr& get_success() const {
    CHECK(tag_ == Tag::kSuccess);
    return data_.success;
  }
  SmartCardConnectSuccessPtr& get_success() {
    CHECK(tag_ == Tag::kSuccess);
    return data_.success;
  }
  void set_success(SmartCardConnectSuccessPtr success);

  bool is_error() const { return tag_ == Tag::kError; }
  SmartCardError get_error() const {
    CHECK(tag_ == Tag::kError);
    return data_.error;
  }
  void set_error(SmartCardError error);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SmartCardConnectResult::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<SmartCardConnectResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
        SmartCardConnectSuccessPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kError)>,
        SmartCardError value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    SmartCardConnectSuccessPtr success;
    SmartCardError error;
  };

  SmartCardConnectResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
      SmartCardConnectSuccessPtr value);
  SmartCardConnectResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kError)>,
      SmartCardError value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class  SmartCardDataResult {
 public:
  using DataView = SmartCardDataResultDataView;
  using Data_ = internal::SmartCardDataResult_Data;
  using Tag = Data_::SmartCardDataResult_Tag;

  template <typename... Args>
  static SmartCardDataResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |data|.
  static SmartCardDataResultPtr NewData(
      std::vector<uint8_t> value);
  // Construct an instance holding |error|.
  static SmartCardDataResultPtr NewError(
      SmartCardError value);

  template <typename U>
  static SmartCardDataResultPtr From(const U& u) {
    return mojo::TypeConverter<SmartCardDataResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SmartCardDataResult>::Convert(*this);
  }
  ~SmartCardDataResult();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  SmartCardDataResult(const SmartCardDataResult& other) = delete;
  SmartCardDataResult& operator=(const SmartCardDataResult& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = SmartCardDataResultPtr>
  SmartCardDataResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, SmartCardDataResult>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, SmartCardDataResult>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_data() const { return tag_ == Tag::kData; }
  const std::vector<uint8_t>& get_data() const {
    CHECK(tag_ == Tag::kData);
    return data_.data;
  }
  std::vector<uint8_t>& get_data() {
    CHECK(tag_ == Tag::kData);
    return data_.data;
  }
  void set_data(std::vector<uint8_t> data);

  bool is_error() const { return tag_ == Tag::kError; }
  SmartCardError get_error() const {
    CHECK(tag_ == Tag::kError);
    return data_.error;
  }
  void set_error(SmartCardError error);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SmartCardDataResult::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<SmartCardDataResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kData)>,
        std::vector<uint8_t> value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kError)>,
        SmartCardError value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    std::vector<uint8_t> data;
    SmartCardError error;
  };

  SmartCardDataResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kData)>,
      std::vector<uint8_t> value);
  SmartCardDataResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kError)>,
      SmartCardError value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class  SmartCardStatusResult {
 public:
  using DataView = SmartCardStatusResultDataView;
  using Data_ = internal::SmartCardStatusResult_Data;
  using Tag = Data_::SmartCardStatusResult_Tag;

  template <typename... Args>
  static SmartCardStatusResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |status|.
  static SmartCardStatusResultPtr NewStatus(
      SmartCardStatusPtr value);
  // Construct an instance holding |error|.
  static SmartCardStatusResultPtr NewError(
      SmartCardError value);

  template <typename U>
  static SmartCardStatusResultPtr From(const U& u) {
    return mojo::TypeConverter<SmartCardStatusResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SmartCardStatusResult>::Convert(*this);
  }
  ~SmartCardStatusResult();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  SmartCardStatusResult(const SmartCardStatusResult& other) = delete;
  SmartCardStatusResult& operator=(const SmartCardStatusResult& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = SmartCardStatusResultPtr>
  SmartCardStatusResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, SmartCardStatusResult>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, SmartCardStatusResult>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_status() const { return tag_ == Tag::kStatus; }
  const SmartCardStatusPtr& get_status() const {
    CHECK(tag_ == Tag::kStatus);
    return data_.status;
  }
  SmartCardStatusPtr& get_status() {
    CHECK(tag_ == Tag::kStatus);
    return data_.status;
  }
  void set_status(SmartCardStatusPtr status);

  bool is_error() const { return tag_ == Tag::kError; }
  SmartCardError get_error() const {
    CHECK(tag_ == Tag::kError);
    return data_.error;
  }
  void set_error(SmartCardError error);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SmartCardStatusResult::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<SmartCardStatusResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kStatus)>,
        SmartCardStatusPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kError)>,
        SmartCardError value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    SmartCardStatusPtr status;
    SmartCardError error;
  };

  SmartCardStatusResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kStatus)>,
      SmartCardStatusPtr value);
  SmartCardStatusResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kError)>,
      SmartCardError value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class  SmartCardTransactionResult {
 public:
  using DataView = SmartCardTransactionResultDataView;
  using Data_ = internal::SmartCardTransactionResult_Data;
  using Tag = Data_::SmartCardTransactionResult_Tag;

  template <typename... Args>
  static SmartCardTransactionResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |transaction|.
  static SmartCardTransactionResultPtr NewTransaction(
      ::mojo::PendingAssociatedRemote<SmartCardTransaction> value);
  // Construct an instance holding |error|.
  static SmartCardTransactionResultPtr NewError(
      SmartCardError value);

  template <typename U>
  static SmartCardTransactionResultPtr From(const U& u) {
    return mojo::TypeConverter<SmartCardTransactionResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SmartCardTransactionResult>::Convert(*this);
  }
  ~SmartCardTransactionResult();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  SmartCardTransactionResult(const SmartCardTransactionResult& other) = delete;
  SmartCardTransactionResult& operator=(const SmartCardTransactionResult& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = SmartCardTransactionResultPtr>
  SmartCardTransactionResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, SmartCardTransactionResult>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, SmartCardTransactionResult>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_transaction() const { return tag_ == Tag::kTransaction; }
  const ::mojo::PendingAssociatedRemote<SmartCardTransaction>& get_transaction() const {
    CHECK(tag_ == Tag::kTransaction);
    return data_.transaction;
  }
  ::mojo::PendingAssociatedRemote<SmartCardTransaction>& get_transaction() {
    CHECK(tag_ == Tag::kTransaction);
    return data_.transaction;
  }
  void set_transaction(::mojo::PendingAssociatedRemote<SmartCardTransaction> transaction);

  bool is_error() const { return tag_ == Tag::kError; }
  SmartCardError get_error() const {
    CHECK(tag_ == Tag::kError);
    return data_.error;
  }
  void set_error(SmartCardError error);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SmartCardTransactionResult::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<SmartCardTransactionResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kTransaction)>,
        ::mojo::PendingAssociatedRemote<SmartCardTransaction> value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kError)>,
        SmartCardError value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    ::mojo::PendingAssociatedRemote<SmartCardTransaction> transaction;
    SmartCardError error;
  };

  SmartCardTransactionResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kTransaction)>,
      ::mojo::PendingAssociatedRemote<SmartCardTransaction> value);
  SmartCardTransactionResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kError)>,
      SmartCardError value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class  SmartCardReaderStateFlags {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SmartCardReaderStateFlags, T>::value>;
  using DataView = SmartCardReaderStateFlagsDataView;
  using Data_ = internal::SmartCardReaderStateFlags_Data;

  template <typename... Args>
  static SmartCardReaderStateFlagsPtr New(Args&&... args) {
    return SmartCardReaderStateFlagsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SmartCardReaderStateFlagsPtr From(const U& u) {
    return mojo::TypeConverter<SmartCardReaderStateFlagsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SmartCardReaderStateFlags>::Convert(*this);
  }


  SmartCardReaderStateFlags();

  SmartCardReaderStateFlags(
      bool unaware,
      bool ignore,
      bool changed,
      bool unknown,
      bool unavailable,
      bool empty,
      bool present,
      bool exclusive,
      bool inuse,
      bool mute,
      bool unpowered);


  ~SmartCardReaderStateFlags();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SmartCardReaderStateFlagsPtr>
  SmartCardReaderStateFlagsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SmartCardReaderStateFlags::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SmartCardReaderStateFlags::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SmartCardReaderStateFlags::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SmartCardReaderStateFlags::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SmartCardReaderStateFlags::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SmartCardReaderStateFlags::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SmartCardReaderStateFlags_UnserializedMessageContext<
            UserType, SmartCardReaderStateFlags::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SmartCardReaderStateFlags::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SmartCardReaderStateFlags::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SmartCardReaderStateFlags_UnserializedMessageContext<
            UserType, SmartCardReaderStateFlags::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SmartCardReaderStateFlags::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool unaware;
  
  bool ignore;
  
  bool changed;
  
  bool unknown;
  
  bool unavailable;
  
  bool empty;
  
  bool present;
  
  bool exclusive;
  
  bool inuse;
  
  bool mute;
  
  bool unpowered;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SmartCardReaderStateFlags::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SmartCardReaderStateFlags::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SmartCardReaderStateFlags::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SmartCardReaderStateFlags::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  SmartCardReaderStateIn {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SmartCardReaderStateIn, T>::value>;
  using DataView = SmartCardReaderStateInDataView;
  using Data_ = internal::SmartCardReaderStateIn_Data;

  template <typename... Args>
  static SmartCardReaderStateInPtr New(Args&&... args) {
    return SmartCardReaderStateInPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SmartCardReaderStateInPtr From(const U& u) {
    return mojo::TypeConverter<SmartCardReaderStateInPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SmartCardReaderStateIn>::Convert(*this);
  }


  SmartCardReaderStateIn();

  SmartCardReaderStateIn(
      const std::string& reader,
      SmartCardReaderStateFlagsPtr current_state,
      uint16_t current_count);

SmartCardReaderStateIn(const SmartCardReaderStateIn&) = delete;
SmartCardReaderStateIn& operator=(const SmartCardReaderStateIn&) = delete;

  ~SmartCardReaderStateIn();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SmartCardReaderStateInPtr>
  SmartCardReaderStateInPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SmartCardReaderStateIn::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SmartCardReaderStateIn::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SmartCardReaderStateIn::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SmartCardReaderStateIn::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SmartCardReaderStateIn::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SmartCardReaderStateIn::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SmartCardReaderStateIn_UnserializedMessageContext<
            UserType, SmartCardReaderStateIn::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SmartCardReaderStateIn::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SmartCardReaderStateIn::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SmartCardReaderStateIn_UnserializedMessageContext<
            UserType, SmartCardReaderStateIn::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SmartCardReaderStateIn::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string reader;
  
  SmartCardReaderStateFlagsPtr current_state;
  
  uint16_t current_count;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SmartCardReaderStateIn::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SmartCardReaderStateIn::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SmartCardReaderStateIn::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SmartCardReaderStateIn::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  SmartCardReaderStateOut {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SmartCardReaderStateOut, T>::value>;
  using DataView = SmartCardReaderStateOutDataView;
  using Data_ = internal::SmartCardReaderStateOut_Data;

  template <typename... Args>
  static SmartCardReaderStateOutPtr New(Args&&... args) {
    return SmartCardReaderStateOutPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SmartCardReaderStateOutPtr From(const U& u) {
    return mojo::TypeConverter<SmartCardReaderStateOutPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SmartCardReaderStateOut>::Convert(*this);
  }


  SmartCardReaderStateOut();

  SmartCardReaderStateOut(
      const std::string& reader,
      SmartCardReaderStateFlagsPtr event_state,
      uint16_t event_count,
      std::vector<uint8_t> answer_to_reset);

SmartCardReaderStateOut(const SmartCardReaderStateOut&) = delete;
SmartCardReaderStateOut& operator=(const SmartCardReaderStateOut&) = delete;

  ~SmartCardReaderStateOut();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SmartCardReaderStateOutPtr>
  SmartCardReaderStateOutPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SmartCardReaderStateOut::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SmartCardReaderStateOut::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SmartCardReaderStateOut::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SmartCardReaderStateOut::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SmartCardReaderStateOut::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SmartCardReaderStateOut::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SmartCardReaderStateOut_UnserializedMessageContext<
            UserType, SmartCardReaderStateOut::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SmartCardReaderStateOut::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SmartCardReaderStateOut::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SmartCardReaderStateOut_UnserializedMessageContext<
            UserType, SmartCardReaderStateOut::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SmartCardReaderStateOut::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string reader;
  
  SmartCardReaderStateFlagsPtr event_state;
  
  uint16_t event_count;
  
  std::vector<uint8_t> answer_to_reset;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SmartCardReaderStateOut::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SmartCardReaderStateOut::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SmartCardReaderStateOut::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SmartCardReaderStateOut::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  SmartCardStatus {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SmartCardStatus, T>::value>;
  using DataView = SmartCardStatusDataView;
  using Data_ = internal::SmartCardStatus_Data;

  template <typename... Args>
  static SmartCardStatusPtr New(Args&&... args) {
    return SmartCardStatusPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SmartCardStatusPtr From(const U& u) {
    return mojo::TypeConverter<SmartCardStatusPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SmartCardStatus>::Convert(*this);
  }


  SmartCardStatus();

  SmartCardStatus(
      const std::string& reader_name,
      SmartCardConnectionState state,
      SmartCardProtocol protocol,
      std::vector<uint8_t> answer_to_reset);


  ~SmartCardStatus();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SmartCardStatusPtr>
  SmartCardStatusPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SmartCardStatus::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SmartCardStatus::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SmartCardStatus::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SmartCardStatus::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SmartCardStatus::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SmartCardStatus::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SmartCardStatus_UnserializedMessageContext<
            UserType, SmartCardStatus::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SmartCardStatus::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SmartCardStatus::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SmartCardStatus_UnserializedMessageContext<
            UserType, SmartCardStatus::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SmartCardStatus::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string reader_name;
  
  SmartCardConnectionState state;
  
  SmartCardProtocol protocol;
  
  std::vector<uint8_t> answer_to_reset;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SmartCardStatus::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SmartCardStatus::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SmartCardStatus::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SmartCardStatus::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  SmartCardConnectSuccess {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SmartCardConnectSuccess, T>::value>;
  using DataView = SmartCardConnectSuccessDataView;
  using Data_ = internal::SmartCardConnectSuccess_Data;

  template <typename... Args>
  static SmartCardConnectSuccessPtr New(Args&&... args) {
    return SmartCardConnectSuccessPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SmartCardConnectSuccessPtr From(const U& u) {
    return mojo::TypeConverter<SmartCardConnectSuccessPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SmartCardConnectSuccess>::Convert(*this);
  }


  SmartCardConnectSuccess();

  SmartCardConnectSuccess(
      ::mojo::PendingRemote<SmartCardConnection> connection,
      SmartCardProtocol active_protocol);

SmartCardConnectSuccess(const SmartCardConnectSuccess&) = delete;
SmartCardConnectSuccess& operator=(const SmartCardConnectSuccess&) = delete;

  ~SmartCardConnectSuccess();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SmartCardConnectSuccessPtr>
  SmartCardConnectSuccessPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SmartCardConnectSuccess::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SmartCardConnectSuccess::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SmartCardConnectSuccess::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SmartCardConnectSuccess::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SmartCardConnectSuccess_UnserializedMessageContext<
            UserType, SmartCardConnectSuccess::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SmartCardConnectSuccess::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SmartCardConnectSuccess::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SmartCardConnectSuccess_UnserializedMessageContext<
            UserType, SmartCardConnectSuccess::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SmartCardConnectSuccess::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::mojo::PendingRemote<SmartCardConnection> connection;
  
  SmartCardProtocol active_protocol;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SmartCardConnectSuccess::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SmartCardConnectSuccess::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SmartCardConnectSuccess::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SmartCardConnectSuccess::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
SmartCardResultPtr SmartCardResult::Clone() const {
  switch (tag_) {
    case Tag::kSuccess:
      return NewSuccess(
          mojo::Clone(data_.success));
    case Tag::kError:
      return NewError(
          mojo::Clone(data_.error));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, SmartCardResult>::value>::type*>
bool SmartCardResult::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kSuccess:
      return mojo::Equals(data_.success, other.data_.success);
    case Tag::kError:
      return mojo::Equals(data_.error, other.data_.error);
  }

  return false;
}
template <typename UnionPtrType>
SmartCardStatusChangeResultPtr SmartCardStatusChangeResult::Clone() const {
  switch (tag_) {
    case Tag::kReaderStates:
      return NewReaderStates(
          mojo::Clone(data_.reader_states));
    case Tag::kError:
      return NewError(
          mojo::Clone(data_.error));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, SmartCardStatusChangeResult>::value>::type*>
bool SmartCardStatusChangeResult::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kReaderStates:
      return mojo::Equals(data_.reader_states, other.data_.reader_states);
    case Tag::kError:
      return mojo::Equals(data_.error, other.data_.error);
  }

  return false;
}
template <typename UnionPtrType>
SmartCardListReadersResultPtr SmartCardListReadersResult::Clone() const {
  switch (tag_) {
    case Tag::kReaders:
      return NewReaders(
          mojo::Clone(data_.readers));
    case Tag::kError:
      return NewError(
          mojo::Clone(data_.error));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, SmartCardListReadersResult>::value>::type*>
bool SmartCardListReadersResult::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kReaders:
      return mojo::Equals(data_.readers, other.data_.readers);
    case Tag::kError:
      return mojo::Equals(data_.error, other.data_.error);
  }

  return false;
}
template <typename UnionPtrType>
SmartCardCreateContextResultPtr SmartCardCreateContextResult::Clone() const {
  switch (tag_) {
    case Tag::kContext:
      return NewContext(
          mojo::Clone(data_.context));
    case Tag::kError:
      return NewError(
          mojo::Clone(data_.error));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, SmartCardCreateContextResult>::value>::type*>
bool SmartCardCreateContextResult::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kContext:
      return mojo::Equals(data_.context, other.data_.context);
    case Tag::kError:
      return mojo::Equals(data_.error, other.data_.error);
  }

  return false;
}
template <typename UnionPtrType>
SmartCardConnectResultPtr SmartCardConnectResult::Clone() const {
  switch (tag_) {
    case Tag::kSuccess:
      return NewSuccess(
          mojo::Clone(data_.success));
    case Tag::kError:
      return NewError(
          mojo::Clone(data_.error));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, SmartCardConnectResult>::value>::type*>
bool SmartCardConnectResult::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kSuccess:
      return mojo::Equals(data_.success, other.data_.success);
    case Tag::kError:
      return mojo::Equals(data_.error, other.data_.error);
  }

  return false;
}
template <typename UnionPtrType>
SmartCardDataResultPtr SmartCardDataResult::Clone() const {
  switch (tag_) {
    case Tag::kData:
      return NewData(
          mojo::Clone(data_.data));
    case Tag::kError:
      return NewError(
          mojo::Clone(data_.error));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, SmartCardDataResult>::value>::type*>
bool SmartCardDataResult::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kData:
      return mojo::Equals(data_.data, other.data_.data);
    case Tag::kError:
      return mojo::Equals(data_.error, other.data_.error);
  }

  return false;
}
template <typename UnionPtrType>
SmartCardStatusResultPtr SmartCardStatusResult::Clone() const {
  switch (tag_) {
    case Tag::kStatus:
      return NewStatus(
          mojo::Clone(data_.status));
    case Tag::kError:
      return NewError(
          mojo::Clone(data_.error));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, SmartCardStatusResult>::value>::type*>
bool SmartCardStatusResult::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kStatus:
      return mojo::Equals(data_.status, other.data_.status);
    case Tag::kError:
      return mojo::Equals(data_.error, other.data_.error);
  }

  return false;
}
template <typename UnionPtrType>
SmartCardTransactionResultPtr SmartCardTransactionResult::Clone() const {
  switch (tag_) {
    case Tag::kTransaction:
      return NewTransaction(
          mojo::Clone(data_.transaction));
    case Tag::kError:
      return NewError(
          mojo::Clone(data_.error));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, SmartCardTransactionResult>::value>::type*>
bool SmartCardTransactionResult::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kTransaction:
      return mojo::Equals(data_.transaction, other.data_.transaction);
    case Tag::kError:
      return mojo::Equals(data_.error, other.data_.error);
  }

  return false;
}
template <typename StructPtrType>
SmartCardReaderStateFlagsPtr SmartCardReaderStateFlags::Clone() const {
  return New(
      mojo::Clone(unaware),
      mojo::Clone(ignore),
      mojo::Clone(changed),
      mojo::Clone(unknown),
      mojo::Clone(unavailable),
      mojo::Clone(empty),
      mojo::Clone(present),
      mojo::Clone(exclusive),
      mojo::Clone(inuse),
      mojo::Clone(mute),
      mojo::Clone(unpowered)
  );
}

template <typename T, SmartCardReaderStateFlags::EnableIfSame<T>*>
bool SmartCardReaderStateFlags::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->unaware, other_struct.unaware))
    return false;
  if (!mojo::Equals(this->ignore, other_struct.ignore))
    return false;
  if (!mojo::Equals(this->changed, other_struct.changed))
    return false;
  if (!mojo::Equals(this->unknown, other_struct.unknown))
    return false;
  if (!mojo::Equals(this->unavailable, other_struct.unavailable))
    return false;
  if (!mojo::Equals(this->empty, other_struct.empty))
    return false;
  if (!mojo::Equals(this->present, other_struct.present))
    return false;
  if (!mojo::Equals(this->exclusive, other_struct.exclusive))
    return false;
  if (!mojo::Equals(this->inuse, other_struct.inuse))
    return false;
  if (!mojo::Equals(this->mute, other_struct.mute))
    return false;
  if (!mojo::Equals(this->unpowered, other_struct.unpowered))
    return false;
  return true;
}

template <typename T, SmartCardReaderStateFlags::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.unaware < rhs.unaware)
    return true;
  if (rhs.unaware < lhs.unaware)
    return false;
  if (lhs.ignore < rhs.ignore)
    return true;
  if (rhs.ignore < lhs.ignore)
    return false;
  if (lhs.changed < rhs.changed)
    return true;
  if (rhs.changed < lhs.changed)
    return false;
  if (lhs.unknown < rhs.unknown)
    return true;
  if (rhs.unknown < lhs.unknown)
    return false;
  if (lhs.unavailable < rhs.unavailable)
    return true;
  if (rhs.unavailable < lhs.unavailable)
    return false;
  if (lhs.empty < rhs.empty)
    return true;
  if (rhs.empty < lhs.empty)
    return false;
  if (lhs.present < rhs.present)
    return true;
  if (rhs.present < lhs.present)
    return false;
  if (lhs.exclusive < rhs.exclusive)
    return true;
  if (rhs.exclusive < lhs.exclusive)
    return false;
  if (lhs.inuse < rhs.inuse)
    return true;
  if (rhs.inuse < lhs.inuse)
    return false;
  if (lhs.mute < rhs.mute)
    return true;
  if (rhs.mute < lhs.mute)
    return false;
  if (lhs.unpowered < rhs.unpowered)
    return true;
  if (rhs.unpowered < lhs.unpowered)
    return false;
  return false;
}
template <typename StructPtrType>
SmartCardReaderStateInPtr SmartCardReaderStateIn::Clone() const {
  return New(
      mojo::Clone(reader),
      mojo::Clone(current_state),
      mojo::Clone(current_count)
  );
}

template <typename T, SmartCardReaderStateIn::EnableIfSame<T>*>
bool SmartCardReaderStateIn::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->reader, other_struct.reader))
    return false;
  if (!mojo::Equals(this->current_state, other_struct.current_state))
    return false;
  if (!mojo::Equals(this->current_count, other_struct.current_count))
    return false;
  return true;
}

template <typename T, SmartCardReaderStateIn::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.reader < rhs.reader)
    return true;
  if (rhs.reader < lhs.reader)
    return false;
  if (lhs.current_state < rhs.current_state)
    return true;
  if (rhs.current_state < lhs.current_state)
    return false;
  if (lhs.current_count < rhs.current_count)
    return true;
  if (rhs.current_count < lhs.current_count)
    return false;
  return false;
}
template <typename StructPtrType>
SmartCardReaderStateOutPtr SmartCardReaderStateOut::Clone() const {
  return New(
      mojo::Clone(reader),
      mojo::Clone(event_state),
      mojo::Clone(event_count),
      mojo::Clone(answer_to_reset)
  );
}

template <typename T, SmartCardReaderStateOut::EnableIfSame<T>*>
bool SmartCardReaderStateOut::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->reader, other_struct.reader))
    return false;
  if (!mojo::Equals(this->event_state, other_struct.event_state))
    return false;
  if (!mojo::Equals(this->event_count, other_struct.event_count))
    return false;
  if (!mojo::Equals(this->answer_to_reset, other_struct.answer_to_reset))
    return false;
  return true;
}

template <typename T, SmartCardReaderStateOut::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.reader < rhs.reader)
    return true;
  if (rhs.reader < lhs.reader)
    return false;
  if (lhs.event_state < rhs.event_state)
    return true;
  if (rhs.event_state < lhs.event_state)
    return false;
  if (lhs.event_count < rhs.event_count)
    return true;
  if (rhs.event_count < lhs.event_count)
    return false;
  if (lhs.answer_to_reset < rhs.answer_to_reset)
    return true;
  if (rhs.answer_to_reset < lhs.answer_to_reset)
    return false;
  return false;
}
template <typename StructPtrType>
SmartCardProtocolsPtr SmartCardProtocols::Clone() const {
  return New(
      mojo::Clone(t0),
      mojo::Clone(t1),
      mojo::Clone(raw)
  );
}

template <typename T, SmartCardProtocols::EnableIfSame<T>*>
bool SmartCardProtocols::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->t0, other_struct.t0))
    return false;
  if (!mojo::Equals(this->t1, other_struct.t1))
    return false;
  if (!mojo::Equals(this->raw, other_struct.raw))
    return false;
  return true;
}

template <typename T, SmartCardProtocols::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.t0 < rhs.t0)
    return true;
  if (rhs.t0 < lhs.t0)
    return false;
  if (lhs.t1 < rhs.t1)
    return true;
  if (rhs.t1 < lhs.t1)
    return false;
  if (lhs.raw < rhs.raw)
    return true;
  if (rhs.raw < lhs.raw)
    return false;
  return false;
}
template <typename StructPtrType>
SmartCardStatusPtr SmartCardStatus::Clone() const {
  return New(
      mojo::Clone(reader_name),
      mojo::Clone(state),
      mojo::Clone(protocol),
      mojo::Clone(answer_to_reset)
  );
}

template <typename T, SmartCardStatus::EnableIfSame<T>*>
bool SmartCardStatus::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->reader_name, other_struct.reader_name))
    return false;
  if (!mojo::Equals(this->state, other_struct.state))
    return false;
  if (!mojo::Equals(this->protocol, other_struct.protocol))
    return false;
  if (!mojo::Equals(this->answer_to_reset, other_struct.answer_to_reset))
    return false;
  return true;
}

template <typename T, SmartCardStatus::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.reader_name < rhs.reader_name)
    return true;
  if (rhs.reader_name < lhs.reader_name)
    return false;
  if (lhs.state < rhs.state)
    return true;
  if (rhs.state < lhs.state)
    return false;
  if (lhs.protocol < rhs.protocol)
    return true;
  if (rhs.protocol < lhs.protocol)
    return false;
  if (lhs.answer_to_reset < rhs.answer_to_reset)
    return true;
  if (rhs.answer_to_reset < lhs.answer_to_reset)
    return false;
  return false;
}
template <typename StructPtrType>
SmartCardConnectSuccessPtr SmartCardConnectSuccess::Clone() const {
  return New(
      mojo::Clone(connection),
      mojo::Clone(active_protocol)
  );
}

template <typename T, SmartCardConnectSuccess::EnableIfSame<T>*>
bool SmartCardConnectSuccess::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->connection, other_struct.connection))
    return false;
  if (!mojo::Equals(this->active_protocol, other_struct.active_protocol))
    return false;
  return true;
}

template <typename T, SmartCardConnectSuccess::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.connection < rhs.connection)
    return true;
  if (rhs.connection < lhs.connection)
    return false;
  if (lhs.active_protocol < rhs.active_protocol)
    return true;
  if (rhs.active_protocol < lhs.active_protocol)
    return false;
  return false;
}


}  // device::mojom

namespace mojo {


template <>
struct  StructTraits<::device::mojom::SmartCardReaderStateFlags::DataView,
                                         ::device::mojom::SmartCardReaderStateFlagsPtr> {
  static bool IsNull(const ::device::mojom::SmartCardReaderStateFlagsPtr& input) { return !input; }
  static void SetToNull(::device::mojom::SmartCardReaderStateFlagsPtr* output) { output->reset(); }

  static decltype(::device::mojom::SmartCardReaderStateFlags::unaware) unaware(
      const ::device::mojom::SmartCardReaderStateFlagsPtr& input) {
    return input->unaware;
  }

  static decltype(::device::mojom::SmartCardReaderStateFlags::ignore) ignore(
      const ::device::mojom::SmartCardReaderStateFlagsPtr& input) {
    return input->ignore;
  }

  static decltype(::device::mojom::SmartCardReaderStateFlags::changed) changed(
      const ::device::mojom::SmartCardReaderStateFlagsPtr& input) {
    return input->changed;
  }

  static decltype(::device::mojom::SmartCardReaderStateFlags::unknown) unknown(
      const ::device::mojom::SmartCardReaderStateFlagsPtr& input) {
    return input->unknown;
  }

  static decltype(::device::mojom::SmartCardReaderStateFlags::unavailable) unavailable(
      const ::device::mojom::SmartCardReaderStateFlagsPtr& input) {
    return input->unavailable;
  }

  static decltype(::device::mojom::SmartCardReaderStateFlags::empty) empty(
      const ::device::mojom::SmartCardReaderStateFlagsPtr& input) {
    return input->empty;
  }

  static decltype(::device::mojom::SmartCardReaderStateFlags::present) present(
      const ::device::mojom::SmartCardReaderStateFlagsPtr& input) {
    return input->present;
  }

  static decltype(::device::mojom::SmartCardReaderStateFlags::exclusive) exclusive(
      const ::device::mojom::SmartCardReaderStateFlagsPtr& input) {
    return input->exclusive;
  }

  static decltype(::device::mojom::SmartCardReaderStateFlags::inuse) inuse(
      const ::device::mojom::SmartCardReaderStateFlagsPtr& input) {
    return input->inuse;
  }

  static decltype(::device::mojom::SmartCardReaderStateFlags::mute) mute(
      const ::device::mojom::SmartCardReaderStateFlagsPtr& input) {
    return input->mute;
  }

  static decltype(::device::mojom::SmartCardReaderStateFlags::unpowered) unpowered(
      const ::device::mojom::SmartCardReaderStateFlagsPtr& input) {
    return input->unpowered;
  }

  static bool Read(::device::mojom::SmartCardReaderStateFlags::DataView input, ::device::mojom::SmartCardReaderStateFlagsPtr* output);
};


template <>
struct  StructTraits<::device::mojom::SmartCardReaderStateIn::DataView,
                                         ::device::mojom::SmartCardReaderStateInPtr> {
  static bool IsNull(const ::device::mojom::SmartCardReaderStateInPtr& input) { return !input; }
  static void SetToNull(::device::mojom::SmartCardReaderStateInPtr* output) { output->reset(); }

  static const decltype(::device::mojom::SmartCardReaderStateIn::reader)& reader(
      const ::device::mojom::SmartCardReaderStateInPtr& input) {
    return input->reader;
  }

  static const decltype(::device::mojom::SmartCardReaderStateIn::current_state)& current_state(
      const ::device::mojom::SmartCardReaderStateInPtr& input) {
    return input->current_state;
  }

  static decltype(::device::mojom::SmartCardReaderStateIn::current_count) current_count(
      const ::device::mojom::SmartCardReaderStateInPtr& input) {
    return input->current_count;
  }

  static bool Read(::device::mojom::SmartCardReaderStateIn::DataView input, ::device::mojom::SmartCardReaderStateInPtr* output);
};


template <>
struct  StructTraits<::device::mojom::SmartCardReaderStateOut::DataView,
                                         ::device::mojom::SmartCardReaderStateOutPtr> {
  static bool IsNull(const ::device::mojom::SmartCardReaderStateOutPtr& input) { return !input; }
  static void SetToNull(::device::mojom::SmartCardReaderStateOutPtr* output) { output->reset(); }

  static const decltype(::device::mojom::SmartCardReaderStateOut::reader)& reader(
      const ::device::mojom::SmartCardReaderStateOutPtr& input) {
    return input->reader;
  }

  static const decltype(::device::mojom::SmartCardReaderStateOut::event_state)& event_state(
      const ::device::mojom::SmartCardReaderStateOutPtr& input) {
    return input->event_state;
  }

  static decltype(::device::mojom::SmartCardReaderStateOut::event_count) event_count(
      const ::device::mojom::SmartCardReaderStateOutPtr& input) {
    return input->event_count;
  }

  static const decltype(::device::mojom::SmartCardReaderStateOut::answer_to_reset)& answer_to_reset(
      const ::device::mojom::SmartCardReaderStateOutPtr& input) {
    return input->answer_to_reset;
  }

  static bool Read(::device::mojom::SmartCardReaderStateOut::DataView input, ::device::mojom::SmartCardReaderStateOutPtr* output);
};


template <>
struct  StructTraits<::device::mojom::SmartCardProtocols::DataView,
                                         ::device::mojom::SmartCardProtocolsPtr> {
  static bool IsNull(const ::device::mojom::SmartCardProtocolsPtr& input) { return !input; }
  static void SetToNull(::device::mojom::SmartCardProtocolsPtr* output) { output->reset(); }

  static decltype(::device::mojom::SmartCardProtocols::t0) t0(
      const ::device::mojom::SmartCardProtocolsPtr& input) {
    return input->t0;
  }

  static decltype(::device::mojom::SmartCardProtocols::t1) t1(
      const ::device::mojom::SmartCardProtocolsPtr& input) {
    return input->t1;
  }

  static decltype(::device::mojom::SmartCardProtocols::raw) raw(
      const ::device::mojom::SmartCardProtocolsPtr& input) {
    return input->raw;
  }

  static bool Read(::device::mojom::SmartCardProtocols::DataView input, ::device::mojom::SmartCardProtocolsPtr* output);
};


template <>
struct  StructTraits<::device::mojom::SmartCardStatus::DataView,
                                         ::device::mojom::SmartCardStatusPtr> {
  static bool IsNull(const ::device::mojom::SmartCardStatusPtr& input) { return !input; }
  static void SetToNull(::device::mojom::SmartCardStatusPtr* output) { output->reset(); }

  static const decltype(::device::mojom::SmartCardStatus::reader_name)& reader_name(
      const ::device::mojom::SmartCardStatusPtr& input) {
    return input->reader_name;
  }

  static decltype(::device::mojom::SmartCardStatus::state) state(
      const ::device::mojom::SmartCardStatusPtr& input) {
    return input->state;
  }

  static decltype(::device::mojom::SmartCardStatus::protocol) protocol(
      const ::device::mojom::SmartCardStatusPtr& input) {
    return input->protocol;
  }

  static const decltype(::device::mojom::SmartCardStatus::answer_to_reset)& answer_to_reset(
      const ::device::mojom::SmartCardStatusPtr& input) {
    return input->answer_to_reset;
  }

  static bool Read(::device::mojom::SmartCardStatus::DataView input, ::device::mojom::SmartCardStatusPtr* output);
};


template <>
struct  StructTraits<::device::mojom::SmartCardConnectSuccess::DataView,
                                         ::device::mojom::SmartCardConnectSuccessPtr> {
  static bool IsNull(const ::device::mojom::SmartCardConnectSuccessPtr& input) { return !input; }
  static void SetToNull(::device::mojom::SmartCardConnectSuccessPtr* output) { output->reset(); }

  static  decltype(::device::mojom::SmartCardConnectSuccess::connection)& connection(
       ::device::mojom::SmartCardConnectSuccessPtr& input) {
    return input->connection;
  }

  static decltype(::device::mojom::SmartCardConnectSuccess::active_protocol) active_protocol(
      const ::device::mojom::SmartCardConnectSuccessPtr& input) {
    return input->active_protocol;
  }

  static bool Read(::device::mojom::SmartCardConnectSuccess::DataView input, ::device::mojom::SmartCardConnectSuccessPtr* output);
};


template <>
struct  UnionTraits<::device::mojom::SmartCardResult::DataView,
                                        ::device::mojom::SmartCardResultPtr> {
  static bool IsNull(const ::device::mojom::SmartCardResultPtr& input) { return !input; }
  static void SetToNull(::device::mojom::SmartCardResultPtr* output) { output->reset(); }

  static ::device::mojom::SmartCardResult::Tag GetTag(const ::device::mojom::SmartCardResultPtr& input) {
    return input->which();
  }

  static  ::device::mojom::SmartCardSuccess success(const ::device::mojom::SmartCardResultPtr& input) {
    return input->get_success();
  }

  static  ::device::mojom::SmartCardError error(const ::device::mojom::SmartCardResultPtr& input) {
    return input->get_error();
  }

  static bool Read(::device::mojom::SmartCardResult::DataView input, ::device::mojom::SmartCardResultPtr* output);
};


template <>
struct  UnionTraits<::device::mojom::SmartCardStatusChangeResult::DataView,
                                        ::device::mojom::SmartCardStatusChangeResultPtr> {
  static bool IsNull(const ::device::mojom::SmartCardStatusChangeResultPtr& input) { return !input; }
  static void SetToNull(::device::mojom::SmartCardStatusChangeResultPtr* output) { output->reset(); }

  static ::device::mojom::SmartCardStatusChangeResult::Tag GetTag(const ::device::mojom::SmartCardStatusChangeResultPtr& input) {
    return input->which();
  }

  static const std::vector<::device::mojom::SmartCardReaderStateOutPtr>& reader_states(const ::device::mojom::SmartCardStatusChangeResultPtr& input) {
    return input->get_reader_states();
  }

  static  ::device::mojom::SmartCardError error(const ::device::mojom::SmartCardStatusChangeResultPtr& input) {
    return input->get_error();
  }

  static bool Read(::device::mojom::SmartCardStatusChangeResult::DataView input, ::device::mojom::SmartCardStatusChangeResultPtr* output);
};


template <>
struct  UnionTraits<::device::mojom::SmartCardListReadersResult::DataView,
                                        ::device::mojom::SmartCardListReadersResultPtr> {
  static bool IsNull(const ::device::mojom::SmartCardListReadersResultPtr& input) { return !input; }
  static void SetToNull(::device::mojom::SmartCardListReadersResultPtr* output) { output->reset(); }

  static ::device::mojom::SmartCardListReadersResult::Tag GetTag(const ::device::mojom::SmartCardListReadersResultPtr& input) {
    return input->which();
  }

  static const std::vector<std::string>& readers(const ::device::mojom::SmartCardListReadersResultPtr& input) {
    return input->get_readers();
  }

  static  ::device::mojom::SmartCardError error(const ::device::mojom::SmartCardListReadersResultPtr& input) {
    return input->get_error();
  }

  static bool Read(::device::mojom::SmartCardListReadersResult::DataView input, ::device::mojom::SmartCardListReadersResultPtr* output);
};


template <>
struct  UnionTraits<::device::mojom::SmartCardCreateContextResult::DataView,
                                        ::device::mojom::SmartCardCreateContextResultPtr> {
  static bool IsNull(const ::device::mojom::SmartCardCreateContextResultPtr& input) { return !input; }
  static void SetToNull(::device::mojom::SmartCardCreateContextResultPtr* output) { output->reset(); }

  static ::device::mojom::SmartCardCreateContextResult::Tag GetTag(const ::device::mojom::SmartCardCreateContextResultPtr& input) {
    return input->which();
  }

  static  ::mojo::PendingRemote<::device::mojom::SmartCardContext>& context( ::device::mojom::SmartCardCreateContextResultPtr& input) {
    return input->get_context();
  }

  static  ::device::mojom::SmartCardError error(const ::device::mojom::SmartCardCreateContextResultPtr& input) {
    return input->get_error();
  }

  static bool Read(::device::mojom::SmartCardCreateContextResult::DataView input, ::device::mojom::SmartCardCreateContextResultPtr* output);
};


template <>
struct  UnionTraits<::device::mojom::SmartCardConnectResult::DataView,
                                        ::device::mojom::SmartCardConnectResultPtr> {
  static bool IsNull(const ::device::mojom::SmartCardConnectResultPtr& input) { return !input; }
  static void SetToNull(::device::mojom::SmartCardConnectResultPtr* output) { output->reset(); }

  static ::device::mojom::SmartCardConnectResult::Tag GetTag(const ::device::mojom::SmartCardConnectResultPtr& input) {
    return input->which();
  }

  static  ::device::mojom::SmartCardConnectSuccessPtr& success( ::device::mojom::SmartCardConnectResultPtr& input) {
    return input->get_success();
  }

  static  ::device::mojom::SmartCardError error(const ::device::mojom::SmartCardConnectResultPtr& input) {
    return input->get_error();
  }

  static bool Read(::device::mojom::SmartCardConnectResult::DataView input, ::device::mojom::SmartCardConnectResultPtr* output);
};


template <>
struct  UnionTraits<::device::mojom::SmartCardDataResult::DataView,
                                        ::device::mojom::SmartCardDataResultPtr> {
  static bool IsNull(const ::device::mojom::SmartCardDataResultPtr& input) { return !input; }
  static void SetToNull(::device::mojom::SmartCardDataResultPtr* output) { output->reset(); }

  static ::device::mojom::SmartCardDataResult::Tag GetTag(const ::device::mojom::SmartCardDataResultPtr& input) {
    return input->which();
  }

  static const std::vector<uint8_t>& data(const ::device::mojom::SmartCardDataResultPtr& input) {
    return input->get_data();
  }

  static  ::device::mojom::SmartCardError error(const ::device::mojom::SmartCardDataResultPtr& input) {
    return input->get_error();
  }

  static bool Read(::device::mojom::SmartCardDataResult::DataView input, ::device::mojom::SmartCardDataResultPtr* output);
};


template <>
struct  UnionTraits<::device::mojom::SmartCardStatusResult::DataView,
                                        ::device::mojom::SmartCardStatusResultPtr> {
  static bool IsNull(const ::device::mojom::SmartCardStatusResultPtr& input) { return !input; }
  static void SetToNull(::device::mojom::SmartCardStatusResultPtr* output) { output->reset(); }

  static ::device::mojom::SmartCardStatusResult::Tag GetTag(const ::device::mojom::SmartCardStatusResultPtr& input) {
    return input->which();
  }

  static const ::device::mojom::SmartCardStatusPtr& status(const ::device::mojom::SmartCardStatusResultPtr& input) {
    return input->get_status();
  }

  static  ::device::mojom::SmartCardError error(const ::device::mojom::SmartCardStatusResultPtr& input) {
    return input->get_error();
  }

  static bool Read(::device::mojom::SmartCardStatusResult::DataView input, ::device::mojom::SmartCardStatusResultPtr* output);
};


template <>
struct  UnionTraits<::device::mojom::SmartCardTransactionResult::DataView,
                                        ::device::mojom::SmartCardTransactionResultPtr> {
  static bool IsNull(const ::device::mojom::SmartCardTransactionResultPtr& input) { return !input; }
  static void SetToNull(::device::mojom::SmartCardTransactionResultPtr* output) { output->reset(); }

  static ::device::mojom::SmartCardTransactionResult::Tag GetTag(const ::device::mojom::SmartCardTransactionResultPtr& input) {
    return input->which();
  }

  static  ::mojo::PendingAssociatedRemote<::device::mojom::SmartCardTransaction>& transaction( ::device::mojom::SmartCardTransactionResultPtr& input) {
    return input->get_transaction();
  }

  static  ::device::mojom::SmartCardError error(const ::device::mojom::SmartCardTransactionResultPtr& input) {
    return input->get_error();
  }

  static bool Read(::device::mojom::SmartCardTransactionResult::DataView input, ::device::mojom::SmartCardTransactionResultPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_DEVICE_PUBLIC_MOJOM_SMART_CARD_MOJOM_H_