// services/metrics/public/mojom/ukm_interface.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_METRICS_PUBLIC_MOJOM_UKM_INTERFACE_MOJOM_DATA_VIEW_H_
#define SERVICES_METRICS_PUBLIC_MOJOM_UKM_INTERFACE_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "services/metrics/public/mojom/ukm_interface.mojom-shared-internal.h"


namespace ukm::mojom {
class UkmEntryDataView;

class UkmRecorderParametersDataView;



}  // ukm::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::ukm::mojom::UkmEntryDataView> {
  using Data = ::ukm::mojom::internal::UkmEntry_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::ukm::mojom::UkmRecorderParametersDataView> {
  using Data = ::ukm::mojom::internal::UkmRecorderParameters_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace ukm::mojom {
// Interface base classes. They are used for type safety check.
class SingularUkmInterfaceInterfaceBase {};

using SingularUkmInterfacePtrDataView =
    mojo::InterfacePtrDataView<SingularUkmInterfaceInterfaceBase>;
using SingularUkmInterfaceRequestDataView =
    mojo::InterfaceRequestDataView<SingularUkmInterfaceInterfaceBase>;
using SingularUkmInterfaceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SingularUkmInterfaceInterfaceBase>;
using SingularUkmInterfaceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SingularUkmInterfaceInterfaceBase>;
class UkmRecorderClientInterfaceInterfaceBase {};

using UkmRecorderClientInterfacePtrDataView =
    mojo::InterfacePtrDataView<UkmRecorderClientInterfaceInterfaceBase>;
using UkmRecorderClientInterfaceRequestDataView =
    mojo::InterfaceRequestDataView<UkmRecorderClientInterfaceInterfaceBase>;
using UkmRecorderClientInterfaceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<UkmRecorderClientInterfaceInterfaceBase>;
using UkmRecorderClientInterfaceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<UkmRecorderClientInterfaceInterfaceBase>;
class UkmRecorderInterfaceInterfaceBase {};

using UkmRecorderInterfacePtrDataView =
    mojo::InterfacePtrDataView<UkmRecorderInterfaceInterfaceBase>;
using UkmRecorderInterfaceRequestDataView =
    mojo::InterfaceRequestDataView<UkmRecorderInterfaceInterfaceBase>;
using UkmRecorderInterfaceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<UkmRecorderInterfaceInterfaceBase>;
using UkmRecorderInterfaceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<UkmRecorderInterfaceInterfaceBase>;
class UkmRecorderFactoryInterfaceBase {};

using UkmRecorderFactoryPtrDataView =
    mojo::InterfacePtrDataView<UkmRecorderFactoryInterfaceBase>;
using UkmRecorderFactoryRequestDataView =
    mojo::InterfaceRequestDataView<UkmRecorderFactoryInterfaceBase>;
using UkmRecorderFactoryAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<UkmRecorderFactoryInterfaceBase>;
using UkmRecorderFactoryAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<UkmRecorderFactoryInterfaceBase>;


class UkmEntryDataView {
 public:
  UkmEntryDataView() = default;

  UkmEntryDataView(
      internal::UkmEntry_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int64_t source_id() const {
    return data_->source_id;
  }
  uint64_t event_hash() const {
    return data_->event_hash;
  }
  inline void GetMetricsDataView(
      mojo::MapDataView<uint64_t, int64_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMetrics(UserType* output) {
    
    auto* pointer = data_->metrics.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<uint64_t, int64_t>>(
        pointer, output, message_);
  }
 private:
  internal::UkmEntry_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class UkmRecorderParametersDataView {
 public:
  UkmRecorderParametersDataView() = default;

  UkmRecorderParametersDataView(
      internal::UkmRecorderParameters_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool is_enabled() const {
    return data_->is_enabled;
  }
  inline void GetEventHashBypassListDataView(
      mojo::ArrayDataView<uint64_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEventHashBypassList(UserType* output) {
    
    auto* pointer = data_->event_hash_bypass_list.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint64_t>>(
        pointer, output, message_);
  }
 private:
  internal::UkmRecorderParameters_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // ukm::mojom

#endif  // SERVICES_METRICS_PUBLIC_MOJOM_UKM_INTERFACE_MOJOM_DATA_VIEW_H_