// services/network/public/mojom/connection_change_observer_client.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/connection_change_observer_client.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/connection_change_observer_client.mojom-params-data.h"
namespace network {
namespace mojom {

NOINLINE static const char* NetworkChangeEventToStringHelper(NetworkChangeEvent value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case NetworkChangeEvent::kSoonToDisconnect:
      return "kSoonToDisconnect";
    case NetworkChangeEvent::kDisconnected:
      return "kDisconnected";
    case NetworkChangeEvent::kConnected:
      return "kConnected";
    case NetworkChangeEvent::kDefaultNetworkChanged:
      return "kDefaultNetworkChanged";
    default:
      return nullptr;
  }
}

std::string NetworkChangeEventToString(NetworkChangeEvent value) {
  const char *str = NetworkChangeEventToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown NetworkChangeEvent value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, NetworkChangeEvent value) {
  return os << NetworkChangeEventToString(value);
}

namespace internal {


// static
bool ConnectionKeepAliveConfig_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ConnectionKeepAliveConfig_Data* object =
      static_cast<const ConnectionKeepAliveConfig_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->quic_connection_options, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& quic_connection_options_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->quic_connection_options, validation_context,
                                         &quic_connection_options_validate_params)) {
    return false;
  }

  return true;
}

ConnectionKeepAliveConfig_Data::ConnectionKeepAliveConfig_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ConnectionChangeObserverClient_OnSessionClosed_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ConnectionChangeObserverClient_OnSessionClosed_Params_Data* object =
      static_cast<const ConnectionChangeObserverClient_OnSessionClosed_Params_Data*>(data);

  return true;
}

ConnectionChangeObserverClient_OnSessionClosed_Params_Data::ConnectionChangeObserverClient_OnSessionClosed_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ConnectionChangeObserverClient_OnNetworkEvent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ConnectionChangeObserverClient_OnNetworkEvent_Params_Data* object =
      static_cast<const ConnectionChangeObserverClient_OnNetworkEvent_Params_Data*>(data);


  if (!::network::mojom::internal::NetworkChangeEvent_Data
        ::Validate(object->event, validation_context))
    return false;

  return true;
}

ConnectionChangeObserverClient_OnNetworkEvent_Params_Data::ConnectionChangeObserverClient_OnNetworkEvent_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ConnectionChangeObserverClient_OnConnectionFailed_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ConnectionChangeObserverClient_OnConnectionFailed_Params_Data* object =
      static_cast<const ConnectionChangeObserverClient_OnConnectionFailed_Params_Data*>(data);

  return true;
}

ConnectionChangeObserverClient_OnConnectionFailed_Params_Data::ConnectionChangeObserverClient_OnConnectionFailed_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace network

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::NetworkChangeEvent>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::NetworkChangeEvent value) {
  return std::move(context).WriteString(::network::mojom::NetworkChangeEventToString(value));
}

} // namespace perfetto