// services/network/public/mojom/cookie_access_observer.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_COOKIE_ACCESS_OBSERVER_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_COOKIE_ACCESS_OBSERVER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/cookie_access_observer.mojom-shared-internal.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "services/network/public/mojom/site_for_cookies.mojom-shared.h"
#include "services/network/public/mojom/cookie_manager.mojom-shared.h"
#include "services/network/public/mojom/cookie_setting_overrides.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "services/network/public/mojom/cookie_access_observer.mojom-data-view.h"




namespace std {

template <>
struct hash<::network::mojom::CookieAccessDetails_Type>
    : public mojo::internal::EnumHashImpl<::network::mojom::CookieAccessDetails_Type> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CookieAccessDetails_Type, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::CookieAccessDetails_Type, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::CookieAccessDetails_Type>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CookieAccessDetailsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::CookieAccessDetailsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::CookieAccessDetails_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::network::mojom::CookieAccessDetails_Type>(
      Traits::type(input),
      &fragment->type);

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in CookieAccessDetails struct");

    decltype(Traits::frame_origin(input)) in_frame_origin = Traits::frame_origin(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->frame_origin)::BaseType> frame_origin_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_frame_origin,
      frame_origin_fragment);

    fragment->frame_origin.Set(
        frame_origin_fragment.is_null() ? nullptr : frame_origin_fragment.data());

    decltype(Traits::top_frame_origin(input)) in_top_frame_origin = Traits::top_frame_origin(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->top_frame_origin)::BaseType> top_frame_origin_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_top_frame_origin,
      top_frame_origin_fragment);

    fragment->top_frame_origin.Set(
        top_frame_origin_fragment.is_null() ? nullptr : top_frame_origin_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->top_frame_origin.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null top_frame_origin in CookieAccessDetails struct");

    decltype(Traits::site_for_cookies(input)) in_site_for_cookies = Traits::site_for_cookies(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->site_for_cookies)::BaseType> site_for_cookies_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::SiteForCookiesDataView>(
      in_site_for_cookies,
      site_for_cookies_fragment);

    fragment->site_for_cookies.Set(
        site_for_cookies_fragment.is_null() ? nullptr : site_for_cookies_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->site_for_cookies.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null site_for_cookies in CookieAccessDetails struct");

    decltype(Traits::cookie_list(input)) in_cookie_list = Traits::cookie_list(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->cookie_list)::BaseType>
        cookie_list_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& cookie_list_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::CookieOrLineWithAccessResultDataView>>(
      in_cookie_list,
      cookie_list_fragment,
      &cookie_list_validate_params);

    fragment->cookie_list.Set(
        cookie_list_fragment.is_null() ? nullptr : cookie_list_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->cookie_list.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null cookie_list in CookieAccessDetails struct");

    decltype(Traits::devtools_request_id(input)) in_devtools_request_id = Traits::devtools_request_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->devtools_request_id)::BaseType> devtools_request_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_devtools_request_id,
      devtools_request_id_fragment);

    fragment->devtools_request_id.Set(
        devtools_request_id_fragment.is_null() ? nullptr : devtools_request_id_fragment.data());

    fragment->is_ad_tagged = Traits::is_ad_tagged(input);

    decltype(Traits::cookie_setting_overrides(input)) in_cookie_setting_overrides = Traits::cookie_setting_overrides(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->cookie_setting_overrides)::BaseType> cookie_setting_overrides_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::CookieSettingOverridesDataView>(
      in_cookie_setting_overrides,
      cookie_setting_overrides_fragment);

    fragment->cookie_setting_overrides.Set(
        cookie_setting_overrides_fragment.is_null() ? nullptr : cookie_setting_overrides_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->cookie_setting_overrides.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null cookie_setting_overrides in CookieAccessDetails struct");
  }

  static bool Deserialize(::network::mojom::internal::CookieAccessDetails_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::CookieAccessDetailsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network::mojom {

inline void CookieAccessDetailsDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void CookieAccessDetailsDataView::GetFrameOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->frame_origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}
inline void CookieAccessDetailsDataView::GetTopFrameOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->top_frame_origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}
inline void CookieAccessDetailsDataView::GetSiteForCookiesDataView(
    ::network::mojom::SiteForCookiesDataView* output) {
  auto pointer = data_->site_for_cookies.Get();
  *output = ::network::mojom::SiteForCookiesDataView(pointer, message_);
}
inline void CookieAccessDetailsDataView::GetCookieListDataView(
    mojo::ArrayDataView<::network::mojom::CookieOrLineWithAccessResultDataView>* output) {
  auto pointer = data_->cookie_list.Get();
  *output = mojo::ArrayDataView<::network::mojom::CookieOrLineWithAccessResultDataView>(pointer, message_);
}
inline void CookieAccessDetailsDataView::GetDevtoolsRequestIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->devtools_request_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void CookieAccessDetailsDataView::GetCookieSettingOverridesDataView(
    ::network::mojom::CookieSettingOverridesDataView* output) {
  auto pointer = data_->cookie_setting_overrides.Get();
  *output = ::network::mojom::CookieSettingOverridesDataView(pointer, message_);
}



}  // network::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::CookieAccessDetails_Type> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::CookieAccessDetails_Type value);
};

} // namespace perfetto

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_COOKIE_ACCESS_OBSERVER_MOJOM_SHARED_H_