// services/network/public/mojom/fetch_retry_options.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_FETCH_RETRY_OPTIONS_MOJOM_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_FETCH_RETRY_OPTIONS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/fetch_retry_options.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/fetch_retry_options.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/fetch_retry_options.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/time.mojom.h"
#include <string>
#include <vector>








namespace network::mojom {








class  FetchRetryOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FetchRetryOptions, T>::value>;
  using DataView = FetchRetryOptionsDataView;
  using Data_ = internal::FetchRetryOptions_Data;

  template <typename... Args>
  static FetchRetryOptionsPtr New(Args&&... args) {
    return FetchRetryOptionsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FetchRetryOptionsPtr From(const U& u) {
    return mojo::TypeConverter<FetchRetryOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FetchRetryOptions>::Convert(*this);
  }


  FetchRetryOptions();

  FetchRetryOptions(
      uint32_t max_attempts,
      std::optional<::base::TimeDelta> initial_delay,
      std::optional<double> backoff_factor,
      std::optional<::base::TimeDelta> max_age,
      bool retry_after_unload,
      bool retry_non_idempotent,
      bool retry_only_if_server_unreached);


  ~FetchRetryOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FetchRetryOptionsPtr>
  FetchRetryOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FetchRetryOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FetchRetryOptions::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FetchRetryOptions::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FetchRetryOptions::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FetchRetryOptions::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FetchRetryOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FetchRetryOptions_UnserializedMessageContext<
            UserType, FetchRetryOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FetchRetryOptions::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FetchRetryOptions::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FetchRetryOptions_UnserializedMessageContext<
            UserType, FetchRetryOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FetchRetryOptions::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t max_attempts;
  
  std::optional<::base::TimeDelta> initial_delay;
  
  std::optional<double> backoff_factor;
  
  std::optional<::base::TimeDelta> max_age;
  
  bool retry_after_unload;
  
  bool retry_non_idempotent;
  
  bool retry_only_if_server_unreached;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FetchRetryOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FetchRetryOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FetchRetryOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FetchRetryOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
FetchRetryOptionsPtr FetchRetryOptions::Clone() const {
  return New(
      mojo::Clone(max_attempts),
      mojo::Clone(initial_delay),
      mojo::Clone(backoff_factor),
      mojo::Clone(max_age),
      mojo::Clone(retry_after_unload),
      mojo::Clone(retry_non_idempotent),
      mojo::Clone(retry_only_if_server_unreached)
  );
}

template <typename T, FetchRetryOptions::EnableIfSame<T>*>
bool FetchRetryOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->max_attempts, other_struct.max_attempts))
    return false;
  if (!mojo::Equals(this->initial_delay, other_struct.initial_delay))
    return false;
  if (!mojo::Equals(this->backoff_factor, other_struct.backoff_factor))
    return false;
  if (!mojo::Equals(this->max_age, other_struct.max_age))
    return false;
  if (!mojo::Equals(this->retry_after_unload, other_struct.retry_after_unload))
    return false;
  if (!mojo::Equals(this->retry_non_idempotent, other_struct.retry_non_idempotent))
    return false;
  if (!mojo::Equals(this->retry_only_if_server_unreached, other_struct.retry_only_if_server_unreached))
    return false;
  return true;
}

template <typename T, FetchRetryOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.max_attempts < rhs.max_attempts)
    return true;
  if (rhs.max_attempts < lhs.max_attempts)
    return false;
  if (lhs.initial_delay < rhs.initial_delay)
    return true;
  if (rhs.initial_delay < lhs.initial_delay)
    return false;
  if (lhs.backoff_factor < rhs.backoff_factor)
    return true;
  if (rhs.backoff_factor < lhs.backoff_factor)
    return false;
  if (lhs.max_age < rhs.max_age)
    return true;
  if (rhs.max_age < lhs.max_age)
    return false;
  if (lhs.retry_after_unload < rhs.retry_after_unload)
    return true;
  if (rhs.retry_after_unload < lhs.retry_after_unload)
    return false;
  if (lhs.retry_non_idempotent < rhs.retry_non_idempotent)
    return true;
  if (rhs.retry_non_idempotent < lhs.retry_non_idempotent)
    return false;
  if (lhs.retry_only_if_server_unreached < rhs.retry_only_if_server_unreached)
    return true;
  if (rhs.retry_only_if_server_unreached < lhs.retry_only_if_server_unreached)
    return false;
  return false;
}


}  // network::mojom

namespace mojo {


template <>
struct  StructTraits<::network::mojom::FetchRetryOptions::DataView,
                                         ::network::mojom::FetchRetryOptionsPtr> {
  static bool IsNull(const ::network::mojom::FetchRetryOptionsPtr& input) { return !input; }
  static void SetToNull(::network::mojom::FetchRetryOptionsPtr* output) { output->reset(); }

  static decltype(::network::mojom::FetchRetryOptions::max_attempts) max_attempts(
      const ::network::mojom::FetchRetryOptionsPtr& input) {
    return input->max_attempts;
  }

  static const decltype(::network::mojom::FetchRetryOptions::initial_delay)& initial_delay(
      const ::network::mojom::FetchRetryOptionsPtr& input) {
    return input->initial_delay;
  }

  static decltype(::network::mojom::FetchRetryOptions::backoff_factor) backoff_factor(
      const ::network::mojom::FetchRetryOptionsPtr& input) {
    return input->backoff_factor;
  }

  static const decltype(::network::mojom::FetchRetryOptions::max_age)& max_age(
      const ::network::mojom::FetchRetryOptionsPtr& input) {
    return input->max_age;
  }

  static decltype(::network::mojom::FetchRetryOptions::retry_after_unload) retry_after_unload(
      const ::network::mojom::FetchRetryOptionsPtr& input) {
    return input->retry_after_unload;
  }

  static decltype(::network::mojom::FetchRetryOptions::retry_non_idempotent) retry_non_idempotent(
      const ::network::mojom::FetchRetryOptionsPtr& input) {
    return input->retry_non_idempotent;
  }

  static decltype(::network::mojom::FetchRetryOptions::retry_only_if_server_unreached) retry_only_if_server_unreached(
      const ::network::mojom::FetchRetryOptionsPtr& input) {
    return input->retry_only_if_server_unreached;
  }

  static bool Read(::network::mojom::FetchRetryOptions::DataView input, ::network::mojom::FetchRetryOptionsPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_FETCH_RETRY_OPTIONS_MOJOM_H_