// services/network/public/mojom/first_party_sets.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/first_party_sets.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/first_party_sets.mojom-params-data.h"
namespace network {
namespace mojom {

NOINLINE static const char* SiteTypeToStringHelper(SiteType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SiteType::kPrimary:
      return "kPrimary";
    case SiteType::kAssociated:
      return "kAssociated";
    case SiteType::kService:
      return "kService";
    default:
      return nullptr;
  }
}

std::string SiteTypeToString(SiteType value) {
  const char *str = SiteTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SiteType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SiteType value) {
  return os << SiteTypeToString(value);
}

namespace internal {


// static
bool FirstPartySetEntry_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FirstPartySetEntry_Data* object =
      static_cast<const FirstPartySetEntry_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->primary, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->primary, validation_context))
    return false;


  if (!::network::mojom::internal::SiteType_Data
        ::Validate(object->site_type, validation_context))
    return false;

  return true;
}

FirstPartySetEntry_Data::FirstPartySetEntry_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FirstPartySetMetadata_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FirstPartySetMetadata_Data* object =
      static_cast<const FirstPartySetMetadata_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->frame_entry, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->top_frame_entry, validation_context))
    return false;

  return true;
}

FirstPartySetMetadata_Data::FirstPartySetMetadata_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FirstPartySetEntryOverride_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FirstPartySetEntryOverride_Data* object =
      static_cast<const FirstPartySetEntryOverride_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->entry, validation_context))
    return false;

  return true;
}

FirstPartySetEntryOverride_Data::FirstPartySetEntryOverride_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FirstPartySetsContextConfig_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FirstPartySetsContextConfig_Data* object =
      static_cast<const FirstPartySetsContextConfig_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->customizations, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& customizations_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->customizations, validation_context,
                                         &customizations_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->aliases, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& aliases_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->aliases, validation_context,
                                         &aliases_validate_params)) {
    return false;
  }

  return true;
}

FirstPartySetsContextConfig_Data::FirstPartySetsContextConfig_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FirstPartySetsCacheFilter_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FirstPartySetsCacheFilter_Data* object =
      static_cast<const FirstPartySetsCacheFilter_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->filter, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& filter_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->filter, validation_context,
                                         &filter_validate_params)) {
    return false;
  }

  return true;
}

FirstPartySetsCacheFilter_Data::FirstPartySetsCacheFilter_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GlobalFirstPartySets_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GlobalFirstPartySets_Data* object =
      static_cast<const GlobalFirstPartySets_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->public_sets_version, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->public_sets_version, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->sets, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& sets_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->sets, validation_context,
                                         &sets_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->aliases, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& aliases_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->aliases, validation_context,
                                         &aliases_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->manual_config, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->manual_config, validation_context))
    return false;

  return true;
}

GlobalFirstPartySets_Data::GlobalFirstPartySets_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace network

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::SiteType>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::SiteType value) {
  return std::move(context).WriteString(::network::mojom::SiteTypeToString(value));
}

} // namespace perfetto