// services/network/public/mojom/integrity_policy.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_INTEGRITY_POLICY_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_INTEGRITY_POLICY_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/integrity_policy.mojom-shared-internal.h"




#include "services/network/public/mojom/integrity_policy.mojom-data-view.h"




namespace std {

template <>
struct hash<::network::mojom::IntegrityPolicy_Destination>
    : public mojo::internal::EnumHashImpl<::network::mojom::IntegrityPolicy_Destination> {};

template <>
struct hash<::network::mojom::IntegrityPolicy_Source>
    : public mojo::internal::EnumHashImpl<::network::mojom::IntegrityPolicy_Source> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::IntegrityPolicy_Destination, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::IntegrityPolicy_Destination, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::IntegrityPolicy_Destination>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::IntegrityPolicy_Source, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::IntegrityPolicy_Source, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::IntegrityPolicy_Source>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::IntegrityPolicyDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::IntegrityPolicyDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::IntegrityPolicy_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::blocked_destinations(input)) in_blocked_destinations = Traits::blocked_destinations(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->blocked_destinations)::BaseType>
        blocked_destinations_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& blocked_destinations_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::network::mojom::internal::IntegrityPolicy_Destination_Data::Validate>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::IntegrityPolicy_Destination>>(
      in_blocked_destinations,
      blocked_destinations_fragment,
      &blocked_destinations_validate_params);

    fragment->blocked_destinations.Set(
        blocked_destinations_fragment.is_null() ? nullptr : blocked_destinations_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->blocked_destinations.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null blocked_destinations in IntegrityPolicy struct");

    decltype(Traits::sources(input)) in_sources = Traits::sources(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->sources)::BaseType>
        sources_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& sources_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::network::mojom::internal::IntegrityPolicy_Source_Data::Validate>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::IntegrityPolicy_Source>>(
      in_sources,
      sources_fragment,
      &sources_validate_params);

    fragment->sources.Set(
        sources_fragment.is_null() ? nullptr : sources_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->sources.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null sources in IntegrityPolicy struct");

    decltype(Traits::endpoints(input)) in_endpoints = Traits::endpoints(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->endpoints)::BaseType>
        endpoints_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& endpoints_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_endpoints,
      endpoints_fragment,
      &endpoints_validate_params);

    fragment->endpoints.Set(
        endpoints_fragment.is_null() ? nullptr : endpoints_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->endpoints.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null endpoints in IntegrityPolicy struct");

    decltype(Traits::parsing_errors(input)) in_parsing_errors = Traits::parsing_errors(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->parsing_errors)::BaseType>
        parsing_errors_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& parsing_errors_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_parsing_errors,
      parsing_errors_fragment,
      &parsing_errors_validate_params);

    fragment->parsing_errors.Set(
        parsing_errors_fragment.is_null() ? nullptr : parsing_errors_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->parsing_errors.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null parsing_errors in IntegrityPolicy struct");
  }

  static bool Deserialize(::network::mojom::internal::IntegrityPolicy_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::IntegrityPolicyDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network::mojom {

inline void IntegrityPolicyDataView::GetBlockedDestinationsDataView(
    mojo::ArrayDataView<IntegrityPolicy_Destination>* output) {
  auto pointer = data_->blocked_destinations.Get();
  *output = mojo::ArrayDataView<IntegrityPolicy_Destination>(pointer, message_);
}
inline void IntegrityPolicyDataView::GetSourcesDataView(
    mojo::ArrayDataView<IntegrityPolicy_Source>* output) {
  auto pointer = data_->sources.Get();
  *output = mojo::ArrayDataView<IntegrityPolicy_Source>(pointer, message_);
}
inline void IntegrityPolicyDataView::GetEndpointsDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->endpoints.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}
inline void IntegrityPolicyDataView::GetParsingErrorsDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->parsing_errors.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}



}  // network::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::IntegrityPolicy_Destination> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::IntegrityPolicy_Destination value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::IntegrityPolicy_Source> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::IntegrityPolicy_Source value);
};

} // namespace perfetto

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_INTEGRITY_POLICY_MOJOM_SHARED_H_