// services/network/public/mojom/key_pinning.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_KEY_PINNING_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_KEY_PINNING_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/key_pinning.mojom-shared-internal.h"
#include "services/network/public/mojom/hash_value.mojom-shared.h"




#include "services/network/public/mojom/key_pinning.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::PinSetDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::PinSetDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::PinSet_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_name,
      name_fragment);

    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in PinSet struct");

    decltype(Traits::static_spki_hashes(input)) in_static_spki_hashes = Traits::static_spki_hashes(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->static_spki_hashes)::BaseType>
        static_spki_hashes_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& static_spki_hashes_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::SHA256HashValueDataView>>(
      in_static_spki_hashes,
      static_spki_hashes_fragment,
      &static_spki_hashes_validate_params);

    fragment->static_spki_hashes.Set(
        static_spki_hashes_fragment.is_null() ? nullptr : static_spki_hashes_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->static_spki_hashes.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null static_spki_hashes in PinSet struct");

    decltype(Traits::bad_static_spki_hashes(input)) in_bad_static_spki_hashes = Traits::bad_static_spki_hashes(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->bad_static_spki_hashes)::BaseType>
        bad_static_spki_hashes_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& bad_static_spki_hashes_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::SHA256HashValueDataView>>(
      in_bad_static_spki_hashes,
      bad_static_spki_hashes_fragment,
      &bad_static_spki_hashes_validate_params);

    fragment->bad_static_spki_hashes.Set(
        bad_static_spki_hashes_fragment.is_null() ? nullptr : bad_static_spki_hashes_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->bad_static_spki_hashes.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null bad_static_spki_hashes in PinSet struct");
  }

  static bool Deserialize(::network::mojom::internal::PinSet_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::PinSetDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::PinSetInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::PinSetInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::PinSetInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::hostname(input)) in_hostname = Traits::hostname(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->hostname)::BaseType> hostname_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_hostname,
      hostname_fragment);

    fragment->hostname.Set(
        hostname_fragment.is_null() ? nullptr : hostname_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->hostname.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null hostname in PinSetInfo struct");

    decltype(Traits::pinset_name(input)) in_pinset_name = Traits::pinset_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->pinset_name)::BaseType> pinset_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_pinset_name,
      pinset_name_fragment);

    fragment->pinset_name.Set(
        pinset_name_fragment.is_null() ? nullptr : pinset_name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->pinset_name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null pinset_name in PinSetInfo struct");

    fragment->include_subdomains = Traits::include_subdomains(input);
  }

  static bool Deserialize(::network::mojom::internal::PinSetInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::PinSetInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::PinListDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::PinListDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::PinList_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::pinsets(input)) in_pinsets = Traits::pinsets(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->pinsets)::BaseType>
        pinsets_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& pinsets_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::PinSetDataView>>(
      in_pinsets,
      pinsets_fragment,
      &pinsets_validate_params);

    fragment->pinsets.Set(
        pinsets_fragment.is_null() ? nullptr : pinsets_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->pinsets.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null pinsets in PinList struct");

    decltype(Traits::host_pins(input)) in_host_pins = Traits::host_pins(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->host_pins)::BaseType>
        host_pins_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& host_pins_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::PinSetInfoDataView>>(
      in_host_pins,
      host_pins_fragment,
      &host_pins_validate_params);

    fragment->host_pins.Set(
        host_pins_fragment.is_null() ? nullptr : host_pins_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->host_pins.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null host_pins in PinList struct");
  }

  static bool Deserialize(::network::mojom::internal::PinList_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::PinListDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network::mojom {

inline void PinSetDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void PinSetDataView::GetStaticSpkiHashesDataView(
    mojo::ArrayDataView<::network::mojom::SHA256HashValueDataView>* output) {
  auto pointer = data_->static_spki_hashes.Get();
  *output = mojo::ArrayDataView<::network::mojom::SHA256HashValueDataView>(pointer, message_);
}
inline void PinSetDataView::GetBadStaticSpkiHashesDataView(
    mojo::ArrayDataView<::network::mojom::SHA256HashValueDataView>* output) {
  auto pointer = data_->bad_static_spki_hashes.Get();
  *output = mojo::ArrayDataView<::network::mojom::SHA256HashValueDataView>(pointer, message_);
}


inline void PinSetInfoDataView::GetHostnameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->hostname.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void PinSetInfoDataView::GetPinsetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->pinset_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void PinListDataView::GetPinsetsDataView(
    mojo::ArrayDataView<PinSetDataView>* output) {
  auto pointer = data_->pinsets.Get();
  *output = mojo::ArrayDataView<PinSetDataView>(pointer, message_);
}
inline void PinListDataView::GetHostPinsDataView(
    mojo::ArrayDataView<PinSetInfoDataView>* output) {
  auto pointer = data_->host_pins.Get();
  *output = mojo::ArrayDataView<PinSetInfoDataView>(pointer, message_);
}



}  // network::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_KEY_PINNING_MOJOM_SHARED_H_