// services/network/public/mojom/network_context.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/network_context.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/network_context.mojom-params-data.h"
#include "services/network/public/mojom/network_context.mojom-shared-message-ids.h"

#include "services/network/public/mojom/network_context.mojom-import-headers.h"
#include "services/network/public/mojom/network_context.mojom-test-utils.h"
#include "components/content_settings/core/common/content_settings_param_traits.h"
#include "net/cert/cert_verify_result.h"
#include "services/network/public/mojom/cookie_access_observer.mojom.h"
#include "services/network/public/mojom/device_bound_sessions.mojom.h"
#include "services/network/public/mojom/devtools_observer.mojom.h"
#include "services/network/public/mojom/trust_token_access_observer.mojom.h"


namespace network::mojom {
CustomProxyConfig::CustomProxyConfig()
    : rules(),
      should_override_existing_config(false),
      allow_non_idempotent_methods(false),
      connect_tunnel_headers() {}

CustomProxyConfig::CustomProxyConfig(
    const ::net::ProxyConfig::ProxyRules& rules_in,
    bool should_override_existing_config_in,
    bool allow_non_idempotent_methods_in,
    const ::net::HttpRequestHeaders& connect_tunnel_headers_in)
    : rules(std::move(rules_in)),
      should_override_existing_config(std::move(should_override_existing_config_in)),
      allow_non_idempotent_methods(std::move(allow_non_idempotent_methods_in)),
      connect_tunnel_headers(std::move(connect_tunnel_headers_in)) {}

CustomProxyConfig::~CustomProxyConfig() = default;

void CustomProxyConfig::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "rules"), this->rules,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::net::ProxyConfig::ProxyRules&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "should_override_existing_config"), this->should_override_existing_config,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allow_non_idempotent_methods"), this->allow_non_idempotent_methods,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "connect_tunnel_headers"), this->connect_tunnel_headers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::net::HttpRequestHeaders&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CustomProxyConfig::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CertVerifierServiceRemoteParams::CertVerifierServiceRemoteParams()
    : cert_verifier_service(),
      cert_verifier_service_client_receiver() {}

CertVerifierServiceRemoteParams::CertVerifierServiceRemoteParams(
    ::mojo::PendingRemote<::cert_verifier::mojom::CertVerifierService> cert_verifier_service_in,
    ::mojo::PendingReceiver<::cert_verifier::mojom::CertVerifierServiceClient> cert_verifier_service_client_receiver_in)
    : cert_verifier_service(std::move(cert_verifier_service_in)),
      cert_verifier_service_client_receiver(std::move(cert_verifier_service_client_receiver_in)) {}

CertVerifierServiceRemoteParams::~CertVerifierServiceRemoteParams() = default;

void CertVerifierServiceRemoteParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cert_verifier_service"), this->cert_verifier_service,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<::cert_verifier::mojom::CertVerifierService>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cert_verifier_service_client_receiver"), this->cert_verifier_service_client_receiver,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingReceiver<::cert_verifier::mojom::CertVerifierServiceClient>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CertVerifierServiceRemoteParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
HttpAuthStaticNetworkContextParams::HttpAuthStaticNetworkContextParams()
    : allow_default_credentials(mojo::internal::ConvertEnumValue<::network::mojom::DefaultCredentials, ::net::HttpAuthPreferences::DefaultCredentials>(::network::mojom::DefaultCredentials::ALLOW_DEFAULT_CREDENTIALS)) {}

HttpAuthStaticNetworkContextParams::HttpAuthStaticNetworkContextParams(
    ::net::HttpAuthPreferences::DefaultCredentials allow_default_credentials_in)
    : allow_default_credentials(std::move(allow_default_credentials_in)) {}

HttpAuthStaticNetworkContextParams::~HttpAuthStaticNetworkContextParams() = default;

void HttpAuthStaticNetworkContextParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allow_default_credentials"), this->allow_default_credentials,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::net::HttpAuthPreferences::DefaultCredentials>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool HttpAuthStaticNetworkContextParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CTPolicy::CTPolicy()
    : excluded_hosts(),
      excluded_spkis() {}

CTPolicy::CTPolicy(
    std::vector<std::string> excluded_hosts_in,
    std::vector<std::string> excluded_spkis_in)
    : excluded_hosts(std::move(excluded_hosts_in)),
      excluded_spkis(std::move(excluded_spkis_in)) {}

CTPolicy::~CTPolicy() = default;

void CTPolicy::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "excluded_hosts"), this->excluded_hosts,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "excluded_spkis"), this->excluded_spkis,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CTPolicy::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
NetworkContextFilePaths::NetworkContextFilePaths()
    : shared_dictionary_directory(),
      http_cache_directory(),
      no_vary_search_directory(),
      data_directory(),
      unsandboxed_data_path(),
      cookie_database_name(),
      device_bound_sessions_database_name(),
      trust_token_database_name(),
      http_server_properties_file_name(),
      transport_security_persister_file_name(),
      reporting_and_nel_store_database_name(),
      sct_auditing_pending_reports_file_name(),
      trigger_migration(false) {}

NetworkContextFilePaths::NetworkContextFilePaths(
    std::optional<::network::TransferableDirectory> shared_dictionary_directory_in,
    std::optional<::network::TransferableDirectory> http_cache_directory_in,
    std::optional<::network::TransferableDirectory> no_vary_search_directory_in,
    ::network::TransferableDirectory data_directory_in,
    const std::optional<::base::FilePath>& unsandboxed_data_path_in,
    const std::optional<::base::FilePath>& cookie_database_name_in,
    const std::optional<::base::FilePath>& device_bound_sessions_database_name_in,
    const std::optional<::base::FilePath>& trust_token_database_name_in,
    const std::optional<::base::FilePath>& http_server_properties_file_name_in,
    const std::optional<::base::FilePath>& transport_security_persister_file_name_in,
    const std::optional<::base::FilePath>& reporting_and_nel_store_database_name_in,
    const std::optional<::base::FilePath>& sct_auditing_pending_reports_file_name_in,
    bool trigger_migration_in)
    : shared_dictionary_directory(std::move(shared_dictionary_directory_in)),
      http_cache_directory(std::move(http_cache_directory_in)),
      no_vary_search_directory(std::move(no_vary_search_directory_in)),
      data_directory(std::move(data_directory_in)),
      unsandboxed_data_path(std::move(unsandboxed_data_path_in)),
      cookie_database_name(std::move(cookie_database_name_in)),
      device_bound_sessions_database_name(std::move(device_bound_sessions_database_name_in)),
      trust_token_database_name(std::move(trust_token_database_name_in)),
      http_server_properties_file_name(std::move(http_server_properties_file_name_in)),
      transport_security_persister_file_name(std::move(transport_security_persister_file_name_in)),
      reporting_and_nel_store_database_name(std::move(reporting_and_nel_store_database_name_in)),
      sct_auditing_pending_reports_file_name(std::move(sct_auditing_pending_reports_file_name_in)),
      trigger_migration(std::move(trigger_migration_in)) {}

NetworkContextFilePaths::~NetworkContextFilePaths() = default;

void NetworkContextFilePaths::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "shared_dictionary_directory"), this->shared_dictionary_directory,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::network::TransferableDirectory>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "http_cache_directory"), this->http_cache_directory,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::network::TransferableDirectory>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "no_vary_search_directory"), this->no_vary_search_directory,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::network::TransferableDirectory>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data_directory"), this->data_directory,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::TransferableDirectory>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "unsandboxed_data_path"), this->unsandboxed_data_path,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::base::FilePath>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cookie_database_name"), this->cookie_database_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::base::FilePath>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "device_bound_sessions_database_name"), this->device_bound_sessions_database_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::base::FilePath>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "trust_token_database_name"), this->trust_token_database_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::base::FilePath>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "http_server_properties_file_name"), this->http_server_properties_file_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::base::FilePath>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "transport_security_persister_file_name"), this->transport_security_persister_file_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::base::FilePath>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "reporting_and_nel_store_database_name"), this->reporting_and_nel_store_database_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::base::FilePath>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sct_auditing_pending_reports_file_name"), this->sct_auditing_pending_reports_file_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::base::FilePath>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "trigger_migration"), this->trigger_migration,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool NetworkContextFilePaths::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
NetworkContextParams::NetworkContextParams()
    : user_agent(),
      accept_language(),
      enable_brotli(true),
      enable_zstd(false),
      enable_referrers(true),
      validate_referrer_policy_on_initial_request(true),
      proxy_resolver_factory(),
      enable_encrypted_cookies(true),
      restore_old_session_cookies(false),
      persist_session_cookies(false),
      http_cache_enabled(true),
      http_cache_max_size(0),
      http_cache_file_operations_factory(),
      disable_idle_sockets_close_on_memory_pressure(false),
      initial_ssl_config(),
      ssl_config_client_receiver(),
      initial_proxy_config(),
      proxy_config_client_receiver(),
      initial_custom_proxy_config(),
      custom_proxy_config_client_receiver(),
      custom_proxy_connection_observer_remote(),
      proxy_config_poller_client(),
      proxy_error_client(),
      ip_protection_core_host(),
      ip_protection_control(),
      enable_ip_protection(false),
      ip_protection_incognito(false),
      ip_protection_data_directory(),
      pac_quick_check_enabled(true),
      enable_certificate_reporting(false),
      enforce_chrome_ct_policy(false),
      sct_auditing_mode(SCTAuditingMode::kDisabled),
      ct_policy(),
      cert_verifier_params(),
      cookie_manager_params(),
      cookie_manager(),
      enable_domain_reliability(false),
      domain_reliability_upload_reporter(),
      discard_domain_reliablity_uploads(false),
      reporting_delivery_interval(),
      skip_reporting_send_permission_check(false),
      cors_origin_access_list(),
      cors_exempt_header_list(),
      allow_any_cors_exempt_header_for_browser(false),
      hsts_policy_bypass_list(),
      http_auth_static_network_context_params(),
      reset_http_cache_backend(false),
      split_auth_cache_by_network_anonymization_key(false),
      require_network_anonymization_key(false),
      file_paths(),
      block_trust_tokens(),
      shared_dictionary_enabled(false),
      shared_dictionary_cache_max_size(0ULL),
      first_party_sets_access_delegate_params(),
      first_party_sets_access_delegate_receiver(),
      acam_preflight_spec_conformant(true),
      cookie_deprecation_label(),
      cookie_encryption_provider(),
      device_bound_sessions_enabled(false),
      bound_network(-1),
      enterprise_reporting_endpoints(),
      quic_idle_connection_timeout_seconds() {}

NetworkContextParams::NetworkContextParams(
    const std::string& user_agent_in,
    const std::string& accept_language_in,
    bool enable_brotli_in,
    bool enable_zstd_in,
    bool enable_referrers_in,
    bool validate_referrer_policy_on_initial_request_in,
    ::mojo::PendingRemote<::proxy_resolver::mojom::ProxyResolverFactory> proxy_resolver_factory_in,
    bool enable_encrypted_cookies_in,
    bool restore_old_session_cookies_in,
    bool persist_session_cookies_in,
    bool http_cache_enabled_in,
    int32_t http_cache_max_size_in,
    ::mojo::PendingRemote<::network::mojom::HttpCacheBackendFileOperationsFactory> http_cache_file_operations_factory_in,
    bool disable_idle_sockets_close_on_memory_pressure_in,
    ::network::mojom::SSLConfigPtr initial_ssl_config_in,
    ::mojo::PendingReceiver<::network::mojom::SSLConfigClient> ssl_config_client_receiver_in,
    const std::optional<::net::ProxyConfigWithAnnotation>& initial_proxy_config_in,
    ::mojo::PendingReceiver<::network::mojom::ProxyConfigClient> proxy_config_client_receiver_in,
    CustomProxyConfigPtr initial_custom_proxy_config_in,
    ::mojo::PendingReceiver<CustomProxyConfigClient> custom_proxy_config_client_receiver_in,
    ::mojo::PendingRemote<CustomProxyConnectionObserver> custom_proxy_connection_observer_remote_in,
    ::mojo::PendingRemote<::network::mojom::ProxyConfigPollerClient> proxy_config_poller_client_in,
    ::mojo::PendingRemote<::network::mojom::ProxyErrorClient> proxy_error_client_in,
    ::mojo::PendingRemote<::ip_protection::mojom::CoreHost> ip_protection_core_host_in,
    ::mojo::PendingReceiver<::ip_protection::mojom::CoreControl> ip_protection_control_in,
    bool enable_ip_protection_in,
    bool ip_protection_incognito_in,
    const std::optional<::base::FilePath>& ip_protection_data_directory_in,
    bool pac_quick_check_enabled_in,
    bool enable_certificate_reporting_in,
    bool enforce_chrome_ct_policy_in,
    SCTAuditingMode sct_auditing_mode_in,
    CTPolicyPtr ct_policy_in,
    CertVerifierServiceRemoteParamsPtr cert_verifier_params_in,
    ::network::mojom::CookieManagerParamsPtr cookie_manager_params_in,
    ::mojo::PendingReceiver<::network::mojom::CookieManager> cookie_manager_in,
    bool enable_domain_reliability_in,
    const std::string& domain_reliability_upload_reporter_in,
    bool discard_domain_reliablity_uploads_in,
    std::optional<::base::TimeDelta> reporting_delivery_interval_in,
    bool skip_reporting_send_permission_check_in,
    std::vector<::network::mojom::CorsOriginAccessPatternsPtr> cors_origin_access_list_in,
    std::vector<std::string> cors_exempt_header_list_in,
    bool allow_any_cors_exempt_header_for_browser_in,
    std::vector<std::string> hsts_policy_bypass_list_in,
    HttpAuthStaticNetworkContextParamsPtr http_auth_static_network_context_params_in,
    bool reset_http_cache_backend_in,
    bool split_auth_cache_by_network_anonymization_key_in,
    bool require_network_anonymization_key_in,
    NetworkContextFilePathsPtr file_paths_in,
    bool block_trust_tokens_in,
    bool shared_dictionary_enabled_in,
    uint64_t shared_dictionary_cache_max_size_in,
    ::network::mojom::FirstPartySetsAccessDelegateParamsPtr first_party_sets_access_delegate_params_in,
    ::mojo::PendingReceiver<::network::mojom::FirstPartySetsAccessDelegate> first_party_sets_access_delegate_receiver_in,
    bool acam_preflight_spec_conformant_in,
    const std::optional<std::string>& cookie_deprecation_label_in,
    ::mojo::PendingRemote<::network::mojom::CookieEncryptionProvider> cookie_encryption_provider_in,
    bool device_bound_sessions_enabled_in,
    int64_t bound_network_in,
    const std::optional<base::flat_map<std::string, ::GURL>>& enterprise_reporting_endpoints_in,
    std::optional<int64_t> quic_idle_connection_timeout_seconds_in)
    : user_agent(std::move(user_agent_in)),
      accept_language(std::move(accept_language_in)),
      enable_brotli(std::move(enable_brotli_in)),
      enable_zstd(std::move(enable_zstd_in)),
      enable_referrers(std::move(enable_referrers_in)),
      validate_referrer_policy_on_initial_request(std::move(validate_referrer_policy_on_initial_request_in)),
      proxy_resolver_factory(std::move(proxy_resolver_factory_in)),
      enable_encrypted_cookies(std::move(enable_encrypted_cookies_in)),
      restore_old_session_cookies(std::move(restore_old_session_cookies_in)),
      persist_session_cookies(std::move(persist_session_cookies_in)),
      http_cache_enabled(std::move(http_cache_enabled_in)),
      http_cache_max_size(std::move(http_cache_max_size_in)),
      http_cache_file_operations_factory(std::move(http_cache_file_operations_factory_in)),
      disable_idle_sockets_close_on_memory_pressure(std::move(disable_idle_sockets_close_on_memory_pressure_in)),
      initial_ssl_config(std::move(initial_ssl_config_in)),
      ssl_config_client_receiver(std::move(ssl_config_client_receiver_in)),
      initial_proxy_config(std::move(initial_proxy_config_in)),
      proxy_config_client_receiver(std::move(proxy_config_client_receiver_in)),
      initial_custom_proxy_config(std::move(initial_custom_proxy_config_in)),
      custom_proxy_config_client_receiver(std::move(custom_proxy_config_client_receiver_in)),
      custom_proxy_connection_observer_remote(std::move(custom_proxy_connection_observer_remote_in)),
      proxy_config_poller_client(std::move(proxy_config_poller_client_in)),
      proxy_error_client(std::move(proxy_error_client_in)),
      ip_protection_core_host(std::move(ip_protection_core_host_in)),
      ip_protection_control(std::move(ip_protection_control_in)),
      enable_ip_protection(std::move(enable_ip_protection_in)),
      ip_protection_incognito(std::move(ip_protection_incognito_in)),
      ip_protection_data_directory(std::move(ip_protection_data_directory_in)),
      pac_quick_check_enabled(std::move(pac_quick_check_enabled_in)),
      enable_certificate_reporting(std::move(enable_certificate_reporting_in)),
      enforce_chrome_ct_policy(std::move(enforce_chrome_ct_policy_in)),
      sct_auditing_mode(std::move(sct_auditing_mode_in)),
      ct_policy(std::move(ct_policy_in)),
      cert_verifier_params(std::move(cert_verifier_params_in)),
      cookie_manager_params(std::move(cookie_manager_params_in)),
      cookie_manager(std::move(cookie_manager_in)),
      enable_domain_reliability(std::move(enable_domain_reliability_in)),
      domain_reliability_upload_reporter(std::move(domain_reliability_upload_reporter_in)),
      discard_domain_reliablity_uploads(std::move(discard_domain_reliablity_uploads_in)),
      reporting_delivery_interval(std::move(reporting_delivery_interval_in)),
      skip_reporting_send_permission_check(std::move(skip_reporting_send_permission_check_in)),
      cors_origin_access_list(std::move(cors_origin_access_list_in)),
      cors_exempt_header_list(std::move(cors_exempt_header_list_in)),
      allow_any_cors_exempt_header_for_browser(std::move(allow_any_cors_exempt_header_for_browser_in)),
      hsts_policy_bypass_list(std::move(hsts_policy_bypass_list_in)),
      http_auth_static_network_context_params(std::move(http_auth_static_network_context_params_in)),
      reset_http_cache_backend(std::move(reset_http_cache_backend_in)),
      split_auth_cache_by_network_anonymization_key(std::move(split_auth_cache_by_network_anonymization_key_in)),
      require_network_anonymization_key(std::move(require_network_anonymization_key_in)),
      file_paths(std::move(file_paths_in)),
      block_trust_tokens(std::move(block_trust_tokens_in)),
      shared_dictionary_enabled(std::move(shared_dictionary_enabled_in)),
      shared_dictionary_cache_max_size(std::move(shared_dictionary_cache_max_size_in)),
      first_party_sets_access_delegate_params(std::move(first_party_sets_access_delegate_params_in)),
      first_party_sets_access_delegate_receiver(std::move(first_party_sets_access_delegate_receiver_in)),
      acam_preflight_spec_conformant(std::move(acam_preflight_spec_conformant_in)),
      cookie_deprecation_label(std::move(cookie_deprecation_label_in)),
      cookie_encryption_provider(std::move(cookie_encryption_provider_in)),
      device_bound_sessions_enabled(std::move(device_bound_sessions_enabled_in)),
      bound_network(std::move(bound_network_in)),
      enterprise_reporting_endpoints(std::move(enterprise_reporting_endpoints_in)),
      quic_idle_connection_timeout_seconds(std::move(quic_idle_connection_timeout_seconds_in)) {}

NetworkContextParams::~NetworkContextParams() = default;

void NetworkContextParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "user_agent"), this->user_agent,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "accept_language"), this->accept_language,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_brotli"), this->enable_brotli,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_zstd"), this->enable_zstd,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_referrers"), this->enable_referrers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "validate_referrer_policy_on_initial_request"), this->validate_referrer_policy_on_initial_request,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "proxy_resolver_factory"), this->proxy_resolver_factory,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<::proxy_resolver::mojom::ProxyResolverFactory>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_encrypted_cookies"), this->enable_encrypted_cookies,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "restore_old_session_cookies"), this->restore_old_session_cookies,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "persist_session_cookies"), this->persist_session_cookies,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "http_cache_enabled"), this->http_cache_enabled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "http_cache_max_size"), this->http_cache_max_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "http_cache_file_operations_factory"), this->http_cache_file_operations_factory,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<::network::mojom::HttpCacheBackendFileOperationsFactory>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "disable_idle_sockets_close_on_memory_pressure"), this->disable_idle_sockets_close_on_memory_pressure,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "initial_ssl_config"), this->initial_ssl_config,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::SSLConfigPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ssl_config_client_receiver"), this->ssl_config_client_receiver,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingReceiver<::network::mojom::SSLConfigClient>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "initial_proxy_config"), this->initial_proxy_config,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::net::ProxyConfigWithAnnotation>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "proxy_config_client_receiver"), this->proxy_config_client_receiver,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingReceiver<::network::mojom::ProxyConfigClient>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "initial_custom_proxy_config"), this->initial_custom_proxy_config,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type CustomProxyConfigPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "custom_proxy_config_client_receiver"), this->custom_proxy_config_client_receiver,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingReceiver<CustomProxyConfigClient>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "custom_proxy_connection_observer_remote"), this->custom_proxy_connection_observer_remote,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<CustomProxyConnectionObserver>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "proxy_config_poller_client"), this->proxy_config_poller_client,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<::network::mojom::ProxyConfigPollerClient>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "proxy_error_client"), this->proxy_error_client,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<::network::mojom::ProxyErrorClient>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ip_protection_core_host"), this->ip_protection_core_host,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<::ip_protection::mojom::CoreHost>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ip_protection_control"), this->ip_protection_control,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingReceiver<::ip_protection::mojom::CoreControl>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_ip_protection"), this->enable_ip_protection,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ip_protection_incognito"), this->ip_protection_incognito,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ip_protection_data_directory"), this->ip_protection_data_directory,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::base::FilePath>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pac_quick_check_enabled"), this->pac_quick_check_enabled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_certificate_reporting"), this->enable_certificate_reporting,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enforce_chrome_ct_policy"), this->enforce_chrome_ct_policy,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sct_auditing_mode"), this->sct_auditing_mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type SCTAuditingMode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ct_policy"), this->ct_policy,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type CTPolicyPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cert_verifier_params"), this->cert_verifier_params,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type CertVerifierServiceRemoteParamsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cookie_manager_params"), this->cookie_manager_params,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::CookieManagerParamsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cookie_manager"), this->cookie_manager,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingReceiver<::network::mojom::CookieManager>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_domain_reliability"), this->enable_domain_reliability,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "domain_reliability_upload_reporter"), this->domain_reliability_upload_reporter,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "discard_domain_reliablity_uploads"), this->discard_domain_reliablity_uploads,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "reporting_delivery_interval"), this->reporting_delivery_interval,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::TimeDelta>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "skip_reporting_send_permission_check"), this->skip_reporting_send_permission_check,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cors_origin_access_list"), this->cors_origin_access_list,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<::network::mojom::CorsOriginAccessPatternsPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cors_exempt_header_list"), this->cors_exempt_header_list,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allow_any_cors_exempt_header_for_browser"), this->allow_any_cors_exempt_header_for_browser,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hsts_policy_bypass_list"), this->hsts_policy_bypass_list,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "http_auth_static_network_context_params"), this->http_auth_static_network_context_params,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type HttpAuthStaticNetworkContextParamsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "reset_http_cache_backend"), this->reset_http_cache_backend,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "split_auth_cache_by_network_anonymization_key"), this->split_auth_cache_by_network_anonymization_key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "require_network_anonymization_key"), this->require_network_anonymization_key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "file_paths"), this->file_paths,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type NetworkContextFilePathsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "block_trust_tokens"), this->block_trust_tokens,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "shared_dictionary_enabled"), this->shared_dictionary_enabled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "shared_dictionary_cache_max_size"), this->shared_dictionary_cache_max_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "first_party_sets_access_delegate_params"), this->first_party_sets_access_delegate_params,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::FirstPartySetsAccessDelegateParamsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "first_party_sets_access_delegate_receiver"), this->first_party_sets_access_delegate_receiver,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingReceiver<::network::mojom::FirstPartySetsAccessDelegate>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "acam_preflight_spec_conformant"), this->acam_preflight_spec_conformant,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cookie_deprecation_label"), this->cookie_deprecation_label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cookie_encryption_provider"), this->cookie_encryption_provider,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<::network::mojom::CookieEncryptionProvider>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "device_bound_sessions_enabled"), this->device_bound_sessions_enabled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bound_network"), this->bound_network,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enterprise_reporting_endpoints"), this->enterprise_reporting_endpoints,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<base::flat_map<std::string, ::GURL>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "quic_idle_connection_timeout_seconds"), this->quic_idle_connection_timeout_seconds,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<int64_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool NetworkContextParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
NetworkConditions::NetworkConditions()
    : offline(),
      latency(),
      download_throughput(),
      upload_throughput(),
      packet_loss(),
      packet_queue_length(),
      packet_reordering() {}

NetworkConditions::NetworkConditions(
    bool offline_in,
    ::base::TimeDelta latency_in,
    double download_throughput_in,
    double upload_throughput_in,
    double packet_loss_in,
    int32_t packet_queue_length_in,
    bool packet_reordering_in)
    : offline(std::move(offline_in)),
      latency(std::move(latency_in)),
      download_throughput(std::move(download_throughput_in)),
      upload_throughput(std::move(upload_throughput_in)),
      packet_loss(std::move(packet_loss_in)),
      packet_queue_length(std::move(packet_queue_length_in)),
      packet_reordering(std::move(packet_reordering_in)) {}

NetworkConditions::~NetworkConditions() = default;

void NetworkConditions::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "offline"), this->offline,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "latency"), this->latency,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "download_throughput"), this->download_throughput,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "upload_throughput"), this->upload_throughput,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "packet_loss"), this->packet_loss,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "packet_queue_length"), this->packet_queue_length,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "packet_reordering"), this->packet_reordering,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool NetworkConditions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SharedDictionaryInfo::SharedDictionaryInfo()
    : match(),
      match_dest(),
      id(),
      dictionary_url(),
      last_fetch_time(),
      response_time(),
      expiration(),
      last_used_time(),
      size(),
      hash() {}

SharedDictionaryInfo::SharedDictionaryInfo(
    const std::string& match_in,
    std::vector<::network::mojom::RequestDestination> match_dest_in,
    const std::string& id_in,
    const ::GURL& dictionary_url_in,
    ::base::Time last_fetch_time_in,
    ::base::Time response_time_in,
    ::base::TimeDelta expiration_in,
    ::base::Time last_used_time_in,
    uint64_t size_in,
    const ::net::SHA256HashValue& hash_in)
    : match(std::move(match_in)),
      match_dest(std::move(match_dest_in)),
      id(std::move(id_in)),
      dictionary_url(std::move(dictionary_url_in)),
      last_fetch_time(std::move(last_fetch_time_in)),
      response_time(std::move(response_time_in)),
      expiration(std::move(expiration_in)),
      last_used_time(std::move(last_used_time_in)),
      size(std::move(size_in)),
      hash(std::move(hash_in)) {}

SharedDictionaryInfo::~SharedDictionaryInfo() = default;

void SharedDictionaryInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "match"), this->match,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "match_dest"), this->match_dest,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::network::mojom::RequestDestination>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "dictionary_url"), this->dictionary_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "last_fetch_time"), this->last_fetch_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::Time>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "response_time"), this->response_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::Time>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "expiration"), this->expiration,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "last_used_time"), this->last_used_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::Time>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "size"), this->size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hash"), this->hash,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::net::SHA256HashValue&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SharedDictionaryInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SignedExchangeReport::SignedExchangeReport()
    : success(),
      type(),
      outer_url(),
      inner_url(),
      cert_url(),
      referrer(),
      server_ip_address(),
      protocol(),
      method(),
      status_code(),
      elapsed_time() {}

SignedExchangeReport::SignedExchangeReport(
    bool success_in,
    const std::string& type_in,
    const ::GURL& outer_url_in,
    const ::GURL& inner_url_in,
    const ::GURL& cert_url_in,
    const std::string& referrer_in,
    const ::net::IPAddress& server_ip_address_in,
    const std::string& protocol_in,
    const std::string& method_in,
    int32_t status_code_in,
    ::base::TimeDelta elapsed_time_in)
    : success(std::move(success_in)),
      type(std::move(type_in)),
      outer_url(std::move(outer_url_in)),
      inner_url(std::move(inner_url_in)),
      cert_url(std::move(cert_url_in)),
      referrer(std::move(referrer_in)),
      server_ip_address(std::move(server_ip_address_in)),
      protocol(std::move(protocol_in)),
      method(std::move(method_in)),
      status_code(std::move(status_code_in)),
      elapsed_time(std::move(elapsed_time_in)) {}

SignedExchangeReport::~SignedExchangeReport() = default;

void SignedExchangeReport::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "success"), this->success,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "outer_url"), this->outer_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "inner_url"), this->inner_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cert_url"), this->cert_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "referrer"), this->referrer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "server_ip_address"), this->server_ip_address,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::net::IPAddress&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "protocol"), this->protocol,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "method"), this->method,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "status_code"), this->status_code,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "elapsed_time"), this->elapsed_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SignedExchangeReport::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
URLLoaderFactoryOverride::URLLoaderFactoryOverride()
    : overriding_factory(),
      overridden_factory_receiver(),
      skip_cors_enabled_scheme_check(false) {}

URLLoaderFactoryOverride::URLLoaderFactoryOverride(
    ::mojo::PendingRemote<::network::mojom::URLLoaderFactory> overriding_factory_in,
    ::mojo::PendingReceiver<::network::mojom::URLLoaderFactory> overridden_factory_receiver_in,
    bool skip_cors_enabled_scheme_check_in)
    : overriding_factory(std::move(overriding_factory_in)),
      overridden_factory_receiver(std::move(overridden_factory_receiver_in)),
      skip_cors_enabled_scheme_check(std::move(skip_cors_enabled_scheme_check_in)) {}

URLLoaderFactoryOverride::~URLLoaderFactoryOverride() = default;

void URLLoaderFactoryOverride::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "overriding_factory"), this->overriding_factory,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<::network::mojom::URLLoaderFactory>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "overridden_factory_receiver"), this->overridden_factory_receiver,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingReceiver<::network::mojom::URLLoaderFactory>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "skip_cors_enabled_scheme_check"), this->skip_cors_enabled_scheme_check,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool URLLoaderFactoryOverride::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
URLLoaderFactoryParams::URLLoaderFactoryParams()
    : process_id(kInvalidProcessId),
      request_initiator_origin_lock(),
      is_orb_enabled(true),
      ignore_isolated_world_origin(true),
      unsafe_non_webby_initiator(false),
      disable_web_security(false),
      header_client(),
      isolation_info(),
      disable_secure_dns(false),
      is_trusted(false),
      automatically_assign_isolation_info(false),
      top_frame_id(),
      factory_override(),
      client_security_state(),
      coep_reporter(),
      dip_reporter(),
      cookie_observer(),
      trust_token_observer(),
      shared_dictionary_observer(),
      url_loader_network_observer(),
      devtools_observer(),
      device_bound_session_observer(),
      trust_token_issuance_policy(TrustTokenOperationPolicyVerdict::kPotentiallyPermit),
      trust_token_redemption_policy(TrustTokenOperationPolicyVerdict::kPotentiallyPermit),
      debug_tag(""),
      cookie_setting_overrides(),
      devtools_cookie_setting_overrides(),
      require_cross_site_request_for_cookies(false),
      ignore_factory_reset(false) {}

URLLoaderFactoryParams::URLLoaderFactoryParams(
    int32_t process_id_in,
    const std::optional<::url::Origin>& request_initiator_origin_lock_in,
    bool is_orb_enabled_in,
    bool ignore_isolated_world_origin_in,
    bool unsafe_non_webby_initiator_in,
    bool disable_web_security_in,
    ::mojo::PendingRemote<TrustedURLLoaderHeaderClient> header_client_in,
    const ::net::IsolationInfo& isolation_info_in,
    bool disable_secure_dns_in,
    bool is_trusted_in,
    bool automatically_assign_isolation_info_in,
    const std::optional<::base::UnguessableToken>& top_frame_id_in,
    URLLoaderFactoryOverridePtr factory_override_in,
    ::network::mojom::ClientSecurityStatePtr client_security_state_in,
    ::mojo::PendingRemote<::network::mojom::CrossOriginEmbedderPolicyReporter> coep_reporter_in,
    ::mojo::PendingRemote<::network::mojom::DocumentIsolationPolicyReporter> dip_reporter_in,
    ::mojo::PendingRemote<::network::mojom::CookieAccessObserver> cookie_observer_in,
    ::mojo::PendingRemote<::network::mojom::TrustTokenAccessObserver> trust_token_observer_in,
    ::mojo::PendingRemote<::network::mojom::SharedDictionaryAccessObserver> shared_dictionary_observer_in,
    ::mojo::PendingRemote<::network::mojom::URLLoaderNetworkServiceObserver> url_loader_network_observer_in,
    ::mojo::PendingRemote<::network::mojom::DevToolsObserver> devtools_observer_in,
    ::mojo::PendingRemote<::network::mojom::DeviceBoundSessionAccessObserver> device_bound_session_observer_in,
    TrustTokenOperationPolicyVerdict trust_token_issuance_policy_in,
    TrustTokenOperationPolicyVerdict trust_token_redemption_policy_in,
    const std::string& debug_tag_in,
    const ::net::CookieSettingOverrides& cookie_setting_overrides_in,
    const ::net::CookieSettingOverrides& devtools_cookie_setting_overrides_in,
    bool require_cross_site_request_for_cookies_in,
    bool ignore_factory_reset_in)
    : process_id(std::move(process_id_in)),
      request_initiator_origin_lock(std::move(request_initiator_origin_lock_in)),
      is_orb_enabled(std::move(is_orb_enabled_in)),
      ignore_isolated_world_origin(std::move(ignore_isolated_world_origin_in)),
      unsafe_non_webby_initiator(std::move(unsafe_non_webby_initiator_in)),
      disable_web_security(std::move(disable_web_security_in)),
      header_client(std::move(header_client_in)),
      isolation_info(std::move(isolation_info_in)),
      disable_secure_dns(std::move(disable_secure_dns_in)),
      is_trusted(std::move(is_trusted_in)),
      automatically_assign_isolation_info(std::move(automatically_assign_isolation_info_in)),
      top_frame_id(std::move(top_frame_id_in)),
      factory_override(std::move(factory_override_in)),
      client_security_state(std::move(client_security_state_in)),
      coep_reporter(std::move(coep_reporter_in)),
      dip_reporter(std::move(dip_reporter_in)),
      cookie_observer(std::move(cookie_observer_in)),
      trust_token_observer(std::move(trust_token_observer_in)),
      shared_dictionary_observer(std::move(shared_dictionary_observer_in)),
      url_loader_network_observer(std::move(url_loader_network_observer_in)),
      devtools_observer(std::move(devtools_observer_in)),
      device_bound_session_observer(std::move(device_bound_session_observer_in)),
      trust_token_issuance_policy(std::move(trust_token_issuance_policy_in)),
      trust_token_redemption_policy(std::move(trust_token_redemption_policy_in)),
      debug_tag(std::move(debug_tag_in)),
      cookie_setting_overrides(std::move(cookie_setting_overrides_in)),
      devtools_cookie_setting_overrides(std::move(devtools_cookie_setting_overrides_in)),
      require_cross_site_request_for_cookies(std::move(require_cross_site_request_for_cookies_in)),
      ignore_factory_reset(std::move(ignore_factory_reset_in)) {}

URLLoaderFactoryParams::~URLLoaderFactoryParams() = default;

void URLLoaderFactoryParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "process_id"), this->process_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "request_initiator_origin_lock"), this->request_initiator_origin_lock,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::url::Origin>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_orb_enabled"), this->is_orb_enabled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ignore_isolated_world_origin"), this->ignore_isolated_world_origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "unsafe_non_webby_initiator"), this->unsafe_non_webby_initiator,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "disable_web_security"), this->disable_web_security,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "header_client"), this->header_client,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<TrustedURLLoaderHeaderClient>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "isolation_info"), this->isolation_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::net::IsolationInfo&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "disable_secure_dns"), this->disable_secure_dns,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_trusted"), this->is_trusted,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "automatically_assign_isolation_info"), this->automatically_assign_isolation_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "top_frame_id"), this->top_frame_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::base::UnguessableToken>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "factory_override"), this->factory_override,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type URLLoaderFactoryOverridePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "client_security_state"), this->client_security_state,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::ClientSecurityStatePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "coep_reporter"), this->coep_reporter,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<::network::mojom::CrossOriginEmbedderPolicyReporter>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "dip_reporter"), this->dip_reporter,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<::network::mojom::DocumentIsolationPolicyReporter>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cookie_observer"), this->cookie_observer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<::network::mojom::CookieAccessObserver>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "trust_token_observer"), this->trust_token_observer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<::network::mojom::TrustTokenAccessObserver>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "shared_dictionary_observer"), this->shared_dictionary_observer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<::network::mojom::SharedDictionaryAccessObserver>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url_loader_network_observer"), this->url_loader_network_observer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<::network::mojom::URLLoaderNetworkServiceObserver>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "devtools_observer"), this->devtools_observer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<::network::mojom::DevToolsObserver>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "device_bound_session_observer"), this->device_bound_session_observer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<::network::mojom::DeviceBoundSessionAccessObserver>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "trust_token_issuance_policy"), this->trust_token_issuance_policy,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type TrustTokenOperationPolicyVerdict>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "trust_token_redemption_policy"), this->trust_token_redemption_policy,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type TrustTokenOperationPolicyVerdict>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "debug_tag"), this->debug_tag,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cookie_setting_overrides"), this->cookie_setting_overrides,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::net::CookieSettingOverrides&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "devtools_cookie_setting_overrides"), this->devtools_cookie_setting_overrides,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::net::CookieSettingOverrides&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "require_cross_site_request_for_cookies"), this->require_cross_site_request_for_cookies,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ignore_factory_reset"), this->ignore_factory_reset,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool URLLoaderFactoryParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

CustomProxyConnectionObserver::IPCStableHashFunction CustomProxyConnectionObserver::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::CustomProxyConnectionObserver>(message.name())) {
    case messages::CustomProxyConnectionObserver::kOnFallback: {
      return &CustomProxyConnectionObserver::OnFallback_Sym::IPCStableHash;
    }
    case messages::CustomProxyConnectionObserver::kOnTunnelHeadersReceived: {
      return &CustomProxyConnectionObserver::OnTunnelHeadersReceived_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* CustomProxyConnectionObserver::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::CustomProxyConnectionObserver>(message.name())) {
      case messages::CustomProxyConnectionObserver::kOnFallback:
            return "Receive network::mojom::CustomProxyConnectionObserver::OnFallback";
      case messages::CustomProxyConnectionObserver::kOnTunnelHeadersReceived:
            return "Receive network::mojom::CustomProxyConnectionObserver::OnTunnelHeadersReceived";
    }
  } else {
    switch (static_cast<messages::CustomProxyConnectionObserver>(message.name())) {
      case messages::CustomProxyConnectionObserver::kOnFallback:
            return "Receive reply network::mojom::CustomProxyConnectionObserver::OnFallback";
      case messages::CustomProxyConnectionObserver::kOnTunnelHeadersReceived:
            return "Receive reply network::mojom::CustomProxyConnectionObserver::OnTunnelHeadersReceived";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t CustomProxyConnectionObserver::OnFallback_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbba48f77;  // IPCStableHash for network::mojom::CustomProxyConnectionObserver::OnFallback
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CustomProxyConnectionObserver::OnTunnelHeadersReceived_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2b6b8096;  // IPCStableHash for network::mojom::CustomProxyConnectionObserver::OnTunnelHeadersReceived
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

CustomProxyConnectionObserverProxy::CustomProxyConnectionObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CustomProxyConnectionObserverProxy::OnFallback(
    const ::net::ProxyChain& in_bad_chain, int32_t in_net_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::CustomProxyConnectionObserver::OnFallback", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bad_chain"), in_bad_chain,
                        "<value of type const ::net::ProxyChain&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("net_error"), in_net_error,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CustomProxyConnectionObserver::kOnFallback), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::CustomProxyConnectionObserver_OnFallback_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->bad_chain)::BaseType> bad_chain_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::ProxyChainDataView>(
    in_bad_chain,
    bad_chain_fragment);

  params->bad_chain.Set(
      bad_chain_fragment.is_null() ? nullptr : bad_chain_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->bad_chain.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null bad_chain in CustomProxyConnectionObserver.OnFallback request");

  params->net_error = in_net_error;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CustomProxyConnectionObserver::Name_);
  message.set_method_name("OnFallback");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CustomProxyConnectionObserverProxy::OnTunnelHeadersReceived(
    const ::net::ProxyChain& in_proxy_chain, uint64_t in_chain_index, const ::scoped_refptr<::net::HttpResponseHeaders>& in_response_headers) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::CustomProxyConnectionObserver::OnTunnelHeadersReceived", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("proxy_chain"), in_proxy_chain,
                        "<value of type const ::net::ProxyChain&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("chain_index"), in_chain_index,
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("response_headers"), in_response_headers,
                        "<value of type const ::scoped_refptr<::net::HttpResponseHeaders>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CustomProxyConnectionObserver::kOnTunnelHeadersReceived), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::CustomProxyConnectionObserver_OnTunnelHeadersReceived_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->proxy_chain)::BaseType> proxy_chain_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::ProxyChainDataView>(
    in_proxy_chain,
    proxy_chain_fragment);

  params->proxy_chain.Set(
      proxy_chain_fragment.is_null() ? nullptr : proxy_chain_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->proxy_chain.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null proxy_chain in CustomProxyConnectionObserver.OnTunnelHeadersReceived request");

  params->chain_index = in_chain_index;
  mojo::internal::MessageFragment<
      typename decltype(params->response_headers)::BaseType> response_headers_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::HttpResponseHeadersDataView>(
    in_response_headers,
    response_headers_fragment);

  params->response_headers.Set(
      response_headers_fragment.is_null() ? nullptr : response_headers_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->response_headers.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null response_headers in CustomProxyConnectionObserver.OnTunnelHeadersReceived request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CustomProxyConnectionObserver::Name_);
  message.set_method_name("OnTunnelHeadersReceived");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool CustomProxyConnectionObserverStubDispatch::Accept(
    CustomProxyConnectionObserver* impl,
    mojo::Message* message) {
  switch (static_cast<messages::CustomProxyConnectionObserver>(message->header()->name)) {
    case messages::CustomProxyConnectionObserver::kOnFallback: {
      DCHECK(message->is_serialized());
      internal::CustomProxyConnectionObserver_OnFallback_Params_Data* params =
          reinterpret_cast<internal::CustomProxyConnectionObserver_OnFallback_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CustomProxyConnectionObserver.0
      bool success = true;
      ::net::ProxyChain p_bad_chain{};
      int32_t p_net_error{};
      CustomProxyConnectionObserver_OnFallback_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBadChain(&p_bad_chain))
        success = false;
      if (success)
        p_net_error = input_data_view.net_error();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CustomProxyConnectionObserver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnFallback(        
        std::move(p_bad_chain), 
        std::move(p_net_error));
      return true;
    }
    case messages::CustomProxyConnectionObserver::kOnTunnelHeadersReceived: {
      DCHECK(message->is_serialized());
      internal::CustomProxyConnectionObserver_OnTunnelHeadersReceived_Params_Data* params =
          reinterpret_cast<internal::CustomProxyConnectionObserver_OnTunnelHeadersReceived_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CustomProxyConnectionObserver.1
      bool success = true;
      ::net::ProxyChain p_proxy_chain{};
      uint64_t p_chain_index{};
      ::scoped_refptr<::net::HttpResponseHeaders> p_response_headers{};
      CustomProxyConnectionObserver_OnTunnelHeadersReceived_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadProxyChain(&p_proxy_chain))
        success = false;
      if (success)
        p_chain_index = input_data_view.chain_index();
      if (success && !input_data_view.ReadResponseHeaders(&p_response_headers))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CustomProxyConnectionObserver::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnTunnelHeadersReceived(        
        std::move(p_proxy_chain), 
        std::move(p_chain_index), 
        std::move(p_response_headers));
      return true;
    }
  }
  return false;
}

// static
bool CustomProxyConnectionObserverStubDispatch::AcceptWithResponder(
    CustomProxyConnectionObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::CustomProxyConnectionObserver>(message->header()->name)) {
    case messages::CustomProxyConnectionObserver::kOnFallback: {
      break;
    }
    case messages::CustomProxyConnectionObserver::kOnTunnelHeadersReceived: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kCustomProxyConnectionObserverValidationInfo[] = {
    {base::to_underlying(messages::CustomProxyConnectionObserver::kOnFallback),
     { &internal::CustomProxyConnectionObserver_OnFallback_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::CustomProxyConnectionObserver::kOnTunnelHeadersReceived),
     { &internal::CustomProxyConnectionObserver_OnTunnelHeadersReceived_Params_Data::Validate,
      nullptr /* no response */}},
};

bool CustomProxyConnectionObserverRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::network::mojom::CustomProxyConnectionObserver::Name_,
    kCustomProxyConnectionObserverValidationInfo);
}

// The declaration includes the definition on other builds.

CustomProxyConfigClient::IPCStableHashFunction CustomProxyConfigClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::CustomProxyConfigClient>(message.name())) {
    case messages::CustomProxyConfigClient::kOnCustomProxyConfigUpdated: {
      return &CustomProxyConfigClient::OnCustomProxyConfigUpdated_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* CustomProxyConfigClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::CustomProxyConfigClient>(message.name())) {
      case messages::CustomProxyConfigClient::kOnCustomProxyConfigUpdated:
            return "Receive network::mojom::CustomProxyConfigClient::OnCustomProxyConfigUpdated";
    }
  } else {
    switch (static_cast<messages::CustomProxyConfigClient>(message.name())) {
      case messages::CustomProxyConfigClient::kOnCustomProxyConfigUpdated:
            return "Receive reply network::mojom::CustomProxyConfigClient::OnCustomProxyConfigUpdated";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t CustomProxyConfigClient::OnCustomProxyConfigUpdated_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8ef6e9b6;  // IPCStableHash for network::mojom::CustomProxyConfigClient::OnCustomProxyConfigUpdated
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class CustomProxyConfigClient_OnCustomProxyConfigUpdated_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CustomProxyConfigClient_OnCustomProxyConfigUpdated_ForwardToCallback(
      CustomProxyConfigClient::OnCustomProxyConfigUpdatedCallback callback
      ) : callback_(std::move(callback)) {
  }

  CustomProxyConfigClient_OnCustomProxyConfigUpdated_ForwardToCallback(const CustomProxyConfigClient_OnCustomProxyConfigUpdated_ForwardToCallback&) = delete;
  CustomProxyConfigClient_OnCustomProxyConfigUpdated_ForwardToCallback& operator=(const CustomProxyConfigClient_OnCustomProxyConfigUpdated_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  CustomProxyConfigClient::OnCustomProxyConfigUpdatedCallback callback_;
};

CustomProxyConfigClientProxy::CustomProxyConfigClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CustomProxyConfigClientProxy::OnCustomProxyConfigUpdated(
    CustomProxyConfigPtr in_proxy_config, OnCustomProxyConfigUpdatedCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::CustomProxyConfigClient::OnCustomProxyConfigUpdated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("proxy_config"), in_proxy_config,
                        "<value of type CustomProxyConfigPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CustomProxyConfigClient::kOnCustomProxyConfigUpdated), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::CustomProxyConfigClient_OnCustomProxyConfigUpdated_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->proxy_config)::BaseType> proxy_config_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::CustomProxyConfigDataView>(
    in_proxy_config,
    proxy_config_fragment);

  params->proxy_config.Set(
      proxy_config_fragment.is_null() ? nullptr : proxy_config_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->proxy_config.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null proxy_config in CustomProxyConfigClient.OnCustomProxyConfigUpdated request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CustomProxyConfigClient::Name_);
  message.set_method_name("OnCustomProxyConfigUpdated");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CustomProxyConfigClient_OnCustomProxyConfigUpdated_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class CustomProxyConfigClient_OnCustomProxyConfigUpdated_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static CustomProxyConfigClient::OnCustomProxyConfigUpdatedCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<CustomProxyConfigClient_OnCustomProxyConfigUpdated_ProxyToResponder> proxy(
        new CustomProxyConfigClient_OnCustomProxyConfigUpdated_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&CustomProxyConfigClient_OnCustomProxyConfigUpdated_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CustomProxyConfigClient_OnCustomProxyConfigUpdated_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  CustomProxyConfigClient_OnCustomProxyConfigUpdated_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "CustomProxyConfigClient::OnCustomProxyConfigUpdatedCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool CustomProxyConfigClient_OnCustomProxyConfigUpdated_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::CustomProxyConfigClient_OnCustomProxyConfigUpdated_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CustomProxyConfigClient_OnCustomProxyConfigUpdated_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for CustomProxyConfigClient.0
  bool success = true;
  CustomProxyConfigClient_OnCustomProxyConfigUpdated_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CustomProxyConfigClient::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void CustomProxyConfigClient_OnCustomProxyConfigUpdated_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply network::mojom::CustomProxyConfigClient::OnCustomProxyConfigUpdated");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CustomProxyConfigClient::kOnCustomProxyConfigUpdated), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::CustomProxyConfigClient_OnCustomProxyConfigUpdated_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CustomProxyConfigClient::Name_);
  message.set_method_name("OnCustomProxyConfigUpdated");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool CustomProxyConfigClientStubDispatch::Accept(
    CustomProxyConfigClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::CustomProxyConfigClient>(message->header()->name)) {
    case messages::CustomProxyConfigClient::kOnCustomProxyConfigUpdated: {
      break;
    }
  }
  return false;
}

// static
bool CustomProxyConfigClientStubDispatch::AcceptWithResponder(
    CustomProxyConfigClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::CustomProxyConfigClient>(message->header()->name)) {
    case messages::CustomProxyConfigClient::kOnCustomProxyConfigUpdated: {
      internal::CustomProxyConfigClient_OnCustomProxyConfigUpdated_Params_Data* params =
          reinterpret_cast<
              internal::CustomProxyConfigClient_OnCustomProxyConfigUpdated_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for CustomProxyConfigClient.0
      bool success = true;
      CustomProxyConfigPtr p_proxy_config{};
      CustomProxyConfigClient_OnCustomProxyConfigUpdated_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadProxyConfig(&p_proxy_config))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CustomProxyConfigClient::Name_, 0, false);
        return false;
      }
      auto callback =
          CustomProxyConfigClient_OnCustomProxyConfigUpdated_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnCustomProxyConfigUpdated(        
        std::move(p_proxy_config), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kCustomProxyConfigClientValidationInfo[] = {
    {base::to_underlying(messages::CustomProxyConfigClient::kOnCustomProxyConfigUpdated),
     { &internal::CustomProxyConfigClient_OnCustomProxyConfigUpdated_Params_Data::Validate,
      &internal::CustomProxyConfigClient_OnCustomProxyConfigUpdated_ResponseParams_Data::Validate}},
};

bool CustomProxyConfigClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::network::mojom::CustomProxyConfigClient::Name_,
    kCustomProxyConfigClientValidationInfo);
}

bool CustomProxyConfigClientResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGeneric(
    message,
    ::network::mojom::CustomProxyConfigClient::Name_,
    kCustomProxyConfigClientValidationInfo);

}
// The declaration includes the definition on other builds.

TrustedHeaderClient::IPCStableHashFunction TrustedHeaderClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::TrustedHeaderClient>(message.name())) {
    case messages::TrustedHeaderClient::kOnBeforeSendHeaders: {
      return &TrustedHeaderClient::OnBeforeSendHeaders_Sym::IPCStableHash;
    }
    case messages::TrustedHeaderClient::kOnHeadersReceived: {
      return &TrustedHeaderClient::OnHeadersReceived_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* TrustedHeaderClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::TrustedHeaderClient>(message.name())) {
      case messages::TrustedHeaderClient::kOnBeforeSendHeaders:
            return "Receive network::mojom::TrustedHeaderClient::OnBeforeSendHeaders";
      case messages::TrustedHeaderClient::kOnHeadersReceived:
            return "Receive network::mojom::TrustedHeaderClient::OnHeadersReceived";
    }
  } else {
    switch (static_cast<messages::TrustedHeaderClient>(message.name())) {
      case messages::TrustedHeaderClient::kOnBeforeSendHeaders:
            return "Receive reply network::mojom::TrustedHeaderClient::OnBeforeSendHeaders";
      case messages::TrustedHeaderClient::kOnHeadersReceived:
            return "Receive reply network::mojom::TrustedHeaderClient::OnHeadersReceived";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t TrustedHeaderClient::OnBeforeSendHeaders_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x450b2176;  // IPCStableHash for network::mojom::TrustedHeaderClient::OnBeforeSendHeaders
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t TrustedHeaderClient::OnHeadersReceived_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x558f6e34;  // IPCStableHash for network::mojom::TrustedHeaderClient::OnHeadersReceived
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class TrustedHeaderClient_OnBeforeSendHeaders_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  TrustedHeaderClient_OnBeforeSendHeaders_ForwardToCallback(
      TrustedHeaderClient::OnBeforeSendHeadersCallback callback
      ) : callback_(std::move(callback)) {
  }

  TrustedHeaderClient_OnBeforeSendHeaders_ForwardToCallback(const TrustedHeaderClient_OnBeforeSendHeaders_ForwardToCallback&) = delete;
  TrustedHeaderClient_OnBeforeSendHeaders_ForwardToCallback& operator=(const TrustedHeaderClient_OnBeforeSendHeaders_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  TrustedHeaderClient::OnBeforeSendHeadersCallback callback_;
};

class TrustedHeaderClient_OnHeadersReceived_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  TrustedHeaderClient_OnHeadersReceived_ForwardToCallback(
      TrustedHeaderClient::OnHeadersReceivedCallback callback
      ) : callback_(std::move(callback)) {
  }

  TrustedHeaderClient_OnHeadersReceived_ForwardToCallback(const TrustedHeaderClient_OnHeadersReceived_ForwardToCallback&) = delete;
  TrustedHeaderClient_OnHeadersReceived_ForwardToCallback& operator=(const TrustedHeaderClient_OnHeadersReceived_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  TrustedHeaderClient::OnHeadersReceivedCallback callback_;
};

TrustedHeaderClientProxy::TrustedHeaderClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void TrustedHeaderClientProxy::OnBeforeSendHeaders(
    const ::net::HttpRequestHeaders& in_headers, OnBeforeSendHeadersCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::TrustedHeaderClient::OnBeforeSendHeaders", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("headers"), in_headers,
                        "<value of type const ::net::HttpRequestHeaders&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TrustedHeaderClient::kOnBeforeSendHeaders), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::TrustedHeaderClient_OnBeforeSendHeaders_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->headers)::BaseType> headers_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::HttpRequestHeadersDataView>(
    in_headers,
    headers_fragment);

  params->headers.Set(
      headers_fragment.is_null() ? nullptr : headers_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->headers.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null headers in TrustedHeaderClient.OnBeforeSendHeaders request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TrustedHeaderClient::Name_);
  message.set_method_name("OnBeforeSendHeaders");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new TrustedHeaderClient_OnBeforeSendHeaders_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void TrustedHeaderClientProxy::OnHeadersReceived(
    const std::string& in_headers, const ::net::IPEndPoint& in_remote_endpoint, OnHeadersReceivedCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::TrustedHeaderClient::OnHeadersReceived", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("headers"), in_headers,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("remote_endpoint"), in_remote_endpoint,
                        "<value of type const ::net::IPEndPoint&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TrustedHeaderClient::kOnHeadersReceived), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::TrustedHeaderClient_OnHeadersReceived_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->headers)::BaseType> headers_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_headers,
    headers_fragment);

  params->headers.Set(
      headers_fragment.is_null() ? nullptr : headers_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->headers.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null headers in TrustedHeaderClient.OnHeadersReceived request");
  mojo::internal::MessageFragment<
      typename decltype(params->remote_endpoint)::BaseType> remote_endpoint_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::IPEndPointDataView>(
    in_remote_endpoint,
    remote_endpoint_fragment);

  params->remote_endpoint.Set(
      remote_endpoint_fragment.is_null() ? nullptr : remote_endpoint_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->remote_endpoint.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null remote_endpoint in TrustedHeaderClient.OnHeadersReceived request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TrustedHeaderClient::Name_);
  message.set_method_name("OnHeadersReceived");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new TrustedHeaderClient_OnHeadersReceived_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class TrustedHeaderClient_OnBeforeSendHeaders_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static TrustedHeaderClient::OnBeforeSendHeadersCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<TrustedHeaderClient_OnBeforeSendHeaders_ProxyToResponder> proxy(
        new TrustedHeaderClient_OnBeforeSendHeaders_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&TrustedHeaderClient_OnBeforeSendHeaders_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~TrustedHeaderClient_OnBeforeSendHeaders_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  TrustedHeaderClient_OnBeforeSendHeaders_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "TrustedHeaderClient::OnBeforeSendHeadersCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_result, const std::optional<::net::HttpRequestHeaders>& in_headers);
};

bool TrustedHeaderClient_OnBeforeSendHeaders_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::TrustedHeaderClient_OnBeforeSendHeaders_ResponseParams_Data* params =
      reinterpret_cast<
          internal::TrustedHeaderClient_OnBeforeSendHeaders_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for TrustedHeaderClient.0
  bool success = true;
  int32_t p_result{};
  std::optional<::net::HttpRequestHeaders> p_headers{};
  TrustedHeaderClient_OnBeforeSendHeaders_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_result = input_data_view.result();
  if (success && !input_data_view.ReadHeaders(&p_headers))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        TrustedHeaderClient::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_headers));
  }
  return true;
}

void TrustedHeaderClient_OnBeforeSendHeaders_ProxyToResponder::Run(
    int32_t in_result, const std::optional<::net::HttpRequestHeaders>& in_headers) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::TrustedHeaderClient::OnBeforeSendHeaders", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("headers"), in_headers,
                        "<value of type const std::optional<::net::HttpRequestHeaders>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TrustedHeaderClient::kOnBeforeSendHeaders), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::TrustedHeaderClient_OnBeforeSendHeaders_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->result = in_result;
  mojo::internal::MessageFragment<
      typename decltype(params->headers)::BaseType> headers_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::HttpRequestHeadersDataView>(
    in_headers,
    headers_fragment);

  params->headers.Set(
      headers_fragment.is_null() ? nullptr : headers_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TrustedHeaderClient::Name_);
  message.set_method_name("OnBeforeSendHeaders");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class TrustedHeaderClient_OnHeadersReceived_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static TrustedHeaderClient::OnHeadersReceivedCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<TrustedHeaderClient_OnHeadersReceived_ProxyToResponder> proxy(
        new TrustedHeaderClient_OnHeadersReceived_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&TrustedHeaderClient_OnHeadersReceived_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~TrustedHeaderClient_OnHeadersReceived_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  TrustedHeaderClient_OnHeadersReceived_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "TrustedHeaderClient::OnHeadersReceivedCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_result, const std::optional<std::string>& in_headers, const std::optional<::GURL>& in_preserve_fragment_on_redirect_url);
};

bool TrustedHeaderClient_OnHeadersReceived_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::TrustedHeaderClient_OnHeadersReceived_ResponseParams_Data* params =
      reinterpret_cast<
          internal::TrustedHeaderClient_OnHeadersReceived_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for TrustedHeaderClient.1
  bool success = true;
  int32_t p_result{};
  std::optional<std::string> p_headers{};
  std::optional<::GURL> p_preserve_fragment_on_redirect_url{};
  TrustedHeaderClient_OnHeadersReceived_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_result = input_data_view.result();
  if (success && !input_data_view.ReadHeaders(&p_headers))
    success = false;
  if (success && !input_data_view.ReadPreserveFragmentOnRedirectUrl(&p_preserve_fragment_on_redirect_url))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        TrustedHeaderClient::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_headers), 
std::move(p_preserve_fragment_on_redirect_url));
  }
  return true;
}

void TrustedHeaderClient_OnHeadersReceived_ProxyToResponder::Run(
    int32_t in_result, const std::optional<std::string>& in_headers, const std::optional<::GURL>& in_preserve_fragment_on_redirect_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::TrustedHeaderClient::OnHeadersReceived", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("headers"), in_headers,
                        "<value of type const std::optional<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("preserve_fragment_on_redirect_url"), in_preserve_fragment_on_redirect_url,
                        "<value of type const std::optional<::GURL>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TrustedHeaderClient::kOnHeadersReceived), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::TrustedHeaderClient_OnHeadersReceived_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->result = in_result;
  mojo::internal::MessageFragment<
      typename decltype(params->headers)::BaseType> headers_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_headers,
    headers_fragment);

  params->headers.Set(
      headers_fragment.is_null() ? nullptr : headers_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->preserve_fragment_on_redirect_url)::BaseType> preserve_fragment_on_redirect_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_preserve_fragment_on_redirect_url,
    preserve_fragment_on_redirect_url_fragment);

  params->preserve_fragment_on_redirect_url.Set(
      preserve_fragment_on_redirect_url_fragment.is_null() ? nullptr : preserve_fragment_on_redirect_url_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TrustedHeaderClient::Name_);
  message.set_method_name("OnHeadersReceived");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool TrustedHeaderClientStubDispatch::Accept(
    TrustedHeaderClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::TrustedHeaderClient>(message->header()->name)) {
    case messages::TrustedHeaderClient::kOnBeforeSendHeaders: {
      break;
    }
    case messages::TrustedHeaderClient::kOnHeadersReceived: {
      break;
    }
  }
  return false;
}

// static
bool TrustedHeaderClientStubDispatch::AcceptWithResponder(
    TrustedHeaderClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::TrustedHeaderClient>(message->header()->name)) {
    case messages::TrustedHeaderClient::kOnBeforeSendHeaders: {
      internal::TrustedHeaderClient_OnBeforeSendHeaders_Params_Data* params =
          reinterpret_cast<
              internal::TrustedHeaderClient_OnBeforeSendHeaders_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for TrustedHeaderClient.0
      bool success = true;
      ::net::HttpRequestHeaders p_headers{};
      TrustedHeaderClient_OnBeforeSendHeaders_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadHeaders(&p_headers))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TrustedHeaderClient::Name_, 0, false);
        return false;
      }
      auto callback =
          TrustedHeaderClient_OnBeforeSendHeaders_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnBeforeSendHeaders(        
        std::move(p_headers), std::move(callback));
      return true;
    }
    case messages::TrustedHeaderClient::kOnHeadersReceived: {
      internal::TrustedHeaderClient_OnHeadersReceived_Params_Data* params =
          reinterpret_cast<
              internal::TrustedHeaderClient_OnHeadersReceived_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for TrustedHeaderClient.1
      bool success = true;
      std::string p_headers{};
      ::net::IPEndPoint p_remote_endpoint{};
      TrustedHeaderClient_OnHeadersReceived_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadHeaders(&p_headers))
        success = false;
      if (success && !input_data_view.ReadRemoteEndpoint(&p_remote_endpoint))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TrustedHeaderClient::Name_, 1, false);
        return false;
      }
      auto callback =
          TrustedHeaderClient_OnHeadersReceived_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnHeadersReceived(        
        std::move(p_headers), 
        std::move(p_remote_endpoint), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kTrustedHeaderClientValidationInfo[] = {
    {base::to_underlying(messages::TrustedHeaderClient::kOnBeforeSendHeaders),
     { &internal::TrustedHeaderClient_OnBeforeSendHeaders_Params_Data::Validate,
      &internal::TrustedHeaderClient_OnBeforeSendHeaders_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::TrustedHeaderClient::kOnHeadersReceived),
     { &internal::TrustedHeaderClient_OnHeadersReceived_Params_Data::Validate,
      &internal::TrustedHeaderClient_OnHeadersReceived_ResponseParams_Data::Validate}},
};

bool TrustedHeaderClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::network::mojom::TrustedHeaderClient::Name_,
    kTrustedHeaderClientValidationInfo);
}

bool TrustedHeaderClientResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGeneric(
    message,
    ::network::mojom::TrustedHeaderClient::Name_,
    kTrustedHeaderClientValidationInfo);

}
// The declaration includes the definition on other builds.

TrustedURLLoaderHeaderClient::IPCStableHashFunction TrustedURLLoaderHeaderClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::TrustedURLLoaderHeaderClient>(message.name())) {
    case messages::TrustedURLLoaderHeaderClient::kOnLoaderCreated: {
      return &TrustedURLLoaderHeaderClient::OnLoaderCreated_Sym::IPCStableHash;
    }
    case messages::TrustedURLLoaderHeaderClient::kOnLoaderForCorsPreflightCreated: {
      return &TrustedURLLoaderHeaderClient::OnLoaderForCorsPreflightCreated_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* TrustedURLLoaderHeaderClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::TrustedURLLoaderHeaderClient>(message.name())) {
      case messages::TrustedURLLoaderHeaderClient::kOnLoaderCreated:
            return "Receive network::mojom::TrustedURLLoaderHeaderClient::OnLoaderCreated";
      case messages::TrustedURLLoaderHeaderClient::kOnLoaderForCorsPreflightCreated:
            return "Receive network::mojom::TrustedURLLoaderHeaderClient::OnLoaderForCorsPreflightCreated";
    }
  } else {
    switch (static_cast<messages::TrustedURLLoaderHeaderClient>(message.name())) {
      case messages::TrustedURLLoaderHeaderClient::kOnLoaderCreated:
            return "Receive reply network::mojom::TrustedURLLoaderHeaderClient::OnLoaderCreated";
      case messages::TrustedURLLoaderHeaderClient::kOnLoaderForCorsPreflightCreated:
            return "Receive reply network::mojom::TrustedURLLoaderHeaderClient::OnLoaderForCorsPreflightCreated";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t TrustedURLLoaderHeaderClient::OnLoaderCreated_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x22d23ceb;  // IPCStableHash for network::mojom::TrustedURLLoaderHeaderClient::OnLoaderCreated
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t TrustedURLLoaderHeaderClient::OnLoaderForCorsPreflightCreated_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4d3c9a60;  // IPCStableHash for network::mojom::TrustedURLLoaderHeaderClient::OnLoaderForCorsPreflightCreated
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

TrustedURLLoaderHeaderClientProxy::TrustedURLLoaderHeaderClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void TrustedURLLoaderHeaderClientProxy::OnLoaderCreated(
    int32_t in_request_id, ::mojo::PendingReceiver<TrustedHeaderClient> in_header_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::TrustedURLLoaderHeaderClient::OnLoaderCreated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_id"), in_request_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("header_client"), in_header_client,
                        "<value of type ::mojo::PendingReceiver<TrustedHeaderClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TrustedURLLoaderHeaderClient::kOnLoaderCreated), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::TrustedURLLoaderHeaderClient_OnLoaderCreated_Params_Data> params(
          message);
  params.Allocate();

  params->request_id = in_request_id;

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::TrustedHeaderClientInterfaceBase>>(
    in_header_client,
    &params->header_client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->header_client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid header_client in TrustedURLLoaderHeaderClient.OnLoaderCreated request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TrustedURLLoaderHeaderClient::Name_);
  message.set_method_name("OnLoaderCreated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void TrustedURLLoaderHeaderClientProxy::OnLoaderForCorsPreflightCreated(
    const ::network::ResourceRequest& in_request, ::mojo::PendingReceiver<TrustedHeaderClient> in_header_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::TrustedURLLoaderHeaderClient::OnLoaderForCorsPreflightCreated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request"), in_request,
                        "<value of type const ::network::ResourceRequest&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("header_client"), in_header_client,
                        "<value of type ::mojo::PendingReceiver<TrustedHeaderClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TrustedURLLoaderHeaderClient::kOnLoaderForCorsPreflightCreated), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::TrustedURLLoaderHeaderClient_OnLoaderForCorsPreflightCreated_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->request)::BaseType> request_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::URLRequestDataView>(
    in_request,
    request_fragment);

  params->request.Set(
      request_fragment.is_null() ? nullptr : request_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->request.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null request in TrustedURLLoaderHeaderClient.OnLoaderForCorsPreflightCreated request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::TrustedHeaderClientInterfaceBase>>(
    in_header_client,
    &params->header_client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->header_client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid header_client in TrustedURLLoaderHeaderClient.OnLoaderForCorsPreflightCreated request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TrustedURLLoaderHeaderClient::Name_);
  message.set_method_name("OnLoaderForCorsPreflightCreated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool TrustedURLLoaderHeaderClientStubDispatch::Accept(
    TrustedURLLoaderHeaderClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::TrustedURLLoaderHeaderClient>(message->header()->name)) {
    case messages::TrustedURLLoaderHeaderClient::kOnLoaderCreated: {
      DCHECK(message->is_serialized());
      internal::TrustedURLLoaderHeaderClient_OnLoaderCreated_Params_Data* params =
          reinterpret_cast<internal::TrustedURLLoaderHeaderClient_OnLoaderCreated_Params_Data*>(
              message->mutable_payload());
      

      // Validation for TrustedURLLoaderHeaderClient.0
      bool success = true;
      int32_t p_request_id{};
      ::mojo::PendingReceiver<TrustedHeaderClient> p_header_client{};
      TrustedURLLoaderHeaderClient_OnLoaderCreated_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_request_id = input_data_view.request_id();
      if (success) {
        p_header_client =
            input_data_view.TakeHeaderClient<decltype(p_header_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TrustedURLLoaderHeaderClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnLoaderCreated(        
        std::move(p_request_id), 
        std::move(p_header_client));
      return true;
    }
    case messages::TrustedURLLoaderHeaderClient::kOnLoaderForCorsPreflightCreated: {
      DCHECK(message->is_serialized());
      internal::TrustedURLLoaderHeaderClient_OnLoaderForCorsPreflightCreated_Params_Data* params =
          reinterpret_cast<internal::TrustedURLLoaderHeaderClient_OnLoaderForCorsPreflightCreated_Params_Data*>(
              message->mutable_payload());
      

      // Validation for TrustedURLLoaderHeaderClient.1
      bool success = true;
      ::network::ResourceRequest p_request{};
      ::mojo::PendingReceiver<TrustedHeaderClient> p_header_client{};
      TrustedURLLoaderHeaderClient_OnLoaderForCorsPreflightCreated_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRequest(&p_request))
        success = false;
      if (success) {
        p_header_client =
            input_data_view.TakeHeaderClient<decltype(p_header_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TrustedURLLoaderHeaderClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnLoaderForCorsPreflightCreated(        
        p_request, 
        std::move(p_header_client));
      return true;
    }
  }
  return false;
}

// static
bool TrustedURLLoaderHeaderClientStubDispatch::AcceptWithResponder(
    TrustedURLLoaderHeaderClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::TrustedURLLoaderHeaderClient>(message->header()->name)) {
    case messages::TrustedURLLoaderHeaderClient::kOnLoaderCreated: {
      break;
    }
    case messages::TrustedURLLoaderHeaderClient::kOnLoaderForCorsPreflightCreated: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kTrustedURLLoaderHeaderClientValidationInfo[] = {
    {base::to_underlying(messages::TrustedURLLoaderHeaderClient::kOnLoaderCreated),
     { &internal::TrustedURLLoaderHeaderClient_OnLoaderCreated_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::TrustedURLLoaderHeaderClient::kOnLoaderForCorsPreflightCreated),
     { &internal::TrustedURLLoaderHeaderClient_OnLoaderForCorsPreflightCreated_Params_Data::Validate,
      nullptr /* no response */}},
};

bool TrustedURLLoaderHeaderClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::network::mojom::TrustedURLLoaderHeaderClient::Name_,
    kTrustedURLLoaderHeaderClientValidationInfo);
}

// The declaration includes the definition on other builds.

PreloadedSharedDictionaryInfoHandle::IPCStableHashFunction PreloadedSharedDictionaryInfoHandle::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PreloadedSharedDictionaryInfoHandle::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
# endif // !BUILDFLAG(IS_FUCHSIA)

PreloadedSharedDictionaryInfoHandleProxy::PreloadedSharedDictionaryInfoHandleProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

// static
bool PreloadedSharedDictionaryInfoHandleStubDispatch::Accept(
    PreloadedSharedDictionaryInfoHandle* impl,
    mojo::Message* message) {
  return false;
}

// static
bool PreloadedSharedDictionaryInfoHandleStubDispatch::AcceptWithResponder(
    PreloadedSharedDictionaryInfoHandle* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  return false;
}
namespace {
}  // namespace

bool PreloadedSharedDictionaryInfoHandleRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::network::mojom::PreloadedSharedDictionaryInfoHandle::Name_,
    {});
}

// The declaration includes the definition on other builds.

NetworkContext::IPCStableHashFunction NetworkContext::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::NetworkContext>(message.name())) {
    case messages::NetworkContext::kSetClient: {
      return &NetworkContext::SetClient_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kCreateURLLoaderFactory: {
      return &NetworkContext::CreateURLLoaderFactory_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kResetURLLoaderFactories: {
      return &NetworkContext::ResetURLLoaderFactories_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kGetViaObliviousHttp: {
      return &NetworkContext::GetViaObliviousHttp_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kGetCookieManager: {
      return &NetworkContext::GetCookieManager_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kGetRestrictedCookieManager: {
      return &NetworkContext::GetRestrictedCookieManager_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kGetTrustTokenQueryAnswerer: {
      return &NetworkContext::GetTrustTokenQueryAnswerer_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kClearTrustTokenData: {
      return &NetworkContext::ClearTrustTokenData_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kClearTrustTokenSessionOnlyData: {
      return &NetworkContext::ClearTrustTokenSessionOnlyData_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kGetStoredTrustTokenCounts: {
      return &NetworkContext::GetStoredTrustTokenCounts_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kGetPrivateStateTokenRedemptionRecords: {
      return &NetworkContext::GetPrivateStateTokenRedemptionRecords_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kDeleteStoredTrustTokens: {
      return &NetworkContext::DeleteStoredTrustTokens_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kSetBlockTrustTokens: {
      return &NetworkContext::SetBlockTrustTokens_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kSetTrackingProtectionContentSetting: {
      return &NetworkContext::SetTrackingProtectionContentSetting_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kClearNetworkingHistoryBetween: {
      return &NetworkContext::ClearNetworkingHistoryBetween_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kClearHttpCache: {
      return &NetworkContext::ClearHttpCache_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kComputeHttpCacheSize: {
      return &NetworkContext::ComputeHttpCacheSize_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kNotifyExternalCacheHit: {
      return &NetworkContext::NotifyExternalCacheHit_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kClearHostCache: {
      return &NetworkContext::ClearHostCache_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kClearHttpAuthCache: {
      return &NetworkContext::ClearHttpAuthCache_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kClearCorsPreflightCache: {
      return &NetworkContext::ClearCorsPreflightCache_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kClearReportingCacheReports: {
      return &NetworkContext::ClearReportingCacheReports_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kClearReportingCacheClients: {
      return &NetworkContext::ClearReportingCacheClients_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kClearNetworkErrorLogging: {
      return &NetworkContext::ClearNetworkErrorLogging_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kClearDomainReliability: {
      return &NetworkContext::ClearDomainReliability_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kClearSharedDictionaryCache: {
      return &NetworkContext::ClearSharedDictionaryCache_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kClearSharedDictionaryCacheForIsolationKey: {
      return &NetworkContext::ClearSharedDictionaryCacheForIsolationKey_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kSetDocumentReportingEndpoints: {
      return &NetworkContext::SetDocumentReportingEndpoints_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kSetEnterpriseReportingEndpoints: {
      return &NetworkContext::SetEnterpriseReportingEndpoints_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kSendReportsAndRemoveSource: {
      return &NetworkContext::SendReportsAndRemoveSource_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kQueueReport: {
      return &NetworkContext::QueueReport_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kQueueEnterpriseReport: {
      return &NetworkContext::QueueEnterpriseReport_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kQueueSignedExchangeReport: {
      return &NetworkContext::QueueSignedExchangeReport_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kCloseAllConnections: {
      return &NetworkContext::CloseAllConnections_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kCloseIdleConnections: {
      return &NetworkContext::CloseIdleConnections_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kSetNetworkConditions: {
      return &NetworkContext::SetNetworkConditions_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kSetAcceptLanguage: {
      return &NetworkContext::SetAcceptLanguage_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kSetUserAgent: {
      return &NetworkContext::SetUserAgent_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kSetEnableReferrers: {
      return &NetworkContext::SetEnableReferrers_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kSetCTPolicy: {
      return &NetworkContext::SetCTPolicy_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kCreateUDPSocket: {
      return &NetworkContext::CreateUDPSocket_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kCreateRestrictedUDPSocket: {
      return &NetworkContext::CreateRestrictedUDPSocket_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kCreateTCPServerSocket: {
      return &NetworkContext::CreateTCPServerSocket_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kCreateTCPConnectedSocket: {
      return &NetworkContext::CreateTCPConnectedSocket_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kCreateTCPBoundSocket: {
      return &NetworkContext::CreateTCPBoundSocket_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kCreateProxyResolvingSocketFactory: {
      return &NetworkContext::CreateProxyResolvingSocketFactory_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kLookUpProxyForURL: {
      return &NetworkContext::LookUpProxyForURL_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kForceReloadProxyConfig: {
      return &NetworkContext::ForceReloadProxyConfig_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kClearBadProxiesCache: {
      return &NetworkContext::ClearBadProxiesCache_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kCreateWebSocket: {
      return &NetworkContext::CreateWebSocket_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kCreateWebTransport: {
      return &NetworkContext::CreateWebTransport_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kCreateNetLogExporter: {
      return &NetworkContext::CreateNetLogExporter_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kPreconnectSockets: {
      return &NetworkContext::PreconnectSockets_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kCreateP2PSocketManager: {
      return &NetworkContext::CreateP2PSocketManager_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kCreateMdnsResponder: {
      return &NetworkContext::CreateMdnsResponder_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kResolveHost: {
      return &NetworkContext::ResolveHost_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kCreateHostResolver: {
      return &NetworkContext::CreateHostResolver_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kVerifyCert: {
      return &NetworkContext::VerifyCert_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kVerifyCertForSignedExchange: {
      return &NetworkContext::VerifyCertForSignedExchange_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kVerify2QwacCertBinding: {
      return &NetworkContext::Verify2QwacCertBinding_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kAddHSTS: {
      return &NetworkContext::AddHSTS_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kIsHSTSActiveForHost: {
      return &NetworkContext::IsHSTSActiveForHost_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kGetHSTSState: {
      return &NetworkContext::GetHSTSState_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kSetCorsOriginAccessListsForOrigin: {
      return &NetworkContext::SetCorsOriginAccessListsForOrigin_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kDeleteDynamicDataForHost: {
      return &NetworkContext::DeleteDynamicDataForHost_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kSetSplitAuthCacheByNetworkAnonymizationKey: {
      return &NetworkContext::SetSplitAuthCacheByNetworkAnonymizationKey_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kSaveHttpAuthCacheProxyEntries: {
      return &NetworkContext::SaveHttpAuthCacheProxyEntries_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kLoadHttpAuthCacheProxyEntries: {
      return &NetworkContext::LoadHttpAuthCacheProxyEntries_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kAddAuthCacheEntry: {
      return &NetworkContext::AddAuthCacheEntry_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kSetCorsNonWildcardRequestHeadersSupport: {
      return &NetworkContext::SetCorsNonWildcardRequestHeadersSupport_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kLookupServerBasicAuthCredentials: {
      return &NetworkContext::LookupServerBasicAuthCredentials_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kEnableStaticKeyPinningForTesting: {
      return &NetworkContext::EnableStaticKeyPinningForTesting_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kVerifyCertificateForTesting: {
      return &NetworkContext::VerifyCertificateForTesting_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kGetTrustAnchorIDsForTesting: {
      return &NetworkContext::GetTrustAnchorIDsForTesting_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kAddDomainReliabilityContextForTesting: {
      return &NetworkContext::AddDomainReliabilityContextForTesting_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kForceDomainReliabilityUploadsForTesting: {
      return &NetworkContext::ForceDomainReliabilityUploadsForTesting_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kSetSCTAuditingMode: {
      return &NetworkContext::SetSCTAuditingMode_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kGetSharedDictionaryUsageInfo: {
      return &NetworkContext::GetSharedDictionaryUsageInfo_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kGetSharedDictionaryInfo: {
      return &NetworkContext::GetSharedDictionaryInfo_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kGetSharedDictionaryOriginsBetween: {
      return &NetworkContext::GetSharedDictionaryOriginsBetween_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kSetSharedDictionaryCacheMaxSize: {
      return &NetworkContext::SetSharedDictionaryCacheMaxSize_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kPreloadSharedDictionaryInfoForDocument: {
      return &NetworkContext::PreloadSharedDictionaryInfoForDocument_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kHasPreloadedSharedDictionaryInfoForTesting: {
      return &NetworkContext::HasPreloadedSharedDictionaryInfoForTesting_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kResourceSchedulerClientVisibilityChanged: {
      return &NetworkContext::ResourceSchedulerClientVisibilityChanged_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kFlushCachedClientCertIfNeeded: {
      return &NetworkContext::FlushCachedClientCertIfNeeded_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kFlushMatchingCachedClientCert: {
      return &NetworkContext::FlushMatchingCachedClientCert_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kSetCookieDeprecationLabel: {
      return &NetworkContext::SetCookieDeprecationLabel_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kRevokeNetworkForNonces: {
      return &NetworkContext::RevokeNetworkForNonces_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kClearNonces: {
      return &NetworkContext::ClearNonces_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kExemptUrlFromNetworkRevocationForNonce: {
      return &NetworkContext::ExemptUrlFromNetworkRevocationForNonce_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kPrefetch: {
      return &NetworkContext::Prefetch_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kGetBoundNetworkForTesting: {
      return &NetworkContext::GetBoundNetworkForTesting_Sym::IPCStableHash;
    }
    case messages::NetworkContext::kGetDeviceBoundSessionManager: {
      return &NetworkContext::GetDeviceBoundSessionManager_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* NetworkContext::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::NetworkContext>(message.name())) {
      case messages::NetworkContext::kSetClient:
            return "Receive network::mojom::NetworkContext::SetClient";
      case messages::NetworkContext::kCreateURLLoaderFactory:
            return "Receive network::mojom::NetworkContext::CreateURLLoaderFactory";
      case messages::NetworkContext::kResetURLLoaderFactories:
            return "Receive network::mojom::NetworkContext::ResetURLLoaderFactories";
      case messages::NetworkContext::kGetViaObliviousHttp:
            return "Receive network::mojom::NetworkContext::GetViaObliviousHttp";
      case messages::NetworkContext::kGetCookieManager:
            return "Receive network::mojom::NetworkContext::GetCookieManager";
      case messages::NetworkContext::kGetRestrictedCookieManager:
            return "Receive network::mojom::NetworkContext::GetRestrictedCookieManager";
      case messages::NetworkContext::kGetTrustTokenQueryAnswerer:
            return "Receive network::mojom::NetworkContext::GetTrustTokenQueryAnswerer";
      case messages::NetworkContext::kClearTrustTokenData:
            return "Receive network::mojom::NetworkContext::ClearTrustTokenData";
      case messages::NetworkContext::kClearTrustTokenSessionOnlyData:
            return "Receive network::mojom::NetworkContext::ClearTrustTokenSessionOnlyData";
      case messages::NetworkContext::kGetStoredTrustTokenCounts:
            return "Receive network::mojom::NetworkContext::GetStoredTrustTokenCounts";
      case messages::NetworkContext::kGetPrivateStateTokenRedemptionRecords:
            return "Receive network::mojom::NetworkContext::GetPrivateStateTokenRedemptionRecords";
      case messages::NetworkContext::kDeleteStoredTrustTokens:
            return "Receive network::mojom::NetworkContext::DeleteStoredTrustTokens";
      case messages::NetworkContext::kSetBlockTrustTokens:
            return "Receive network::mojom::NetworkContext::SetBlockTrustTokens";
      case messages::NetworkContext::kSetTrackingProtectionContentSetting:
            return "Receive network::mojom::NetworkContext::SetTrackingProtectionContentSetting";
      case messages::NetworkContext::kClearNetworkingHistoryBetween:
            return "Receive network::mojom::NetworkContext::ClearNetworkingHistoryBetween";
      case messages::NetworkContext::kClearHttpCache:
            return "Receive network::mojom::NetworkContext::ClearHttpCache";
      case messages::NetworkContext::kComputeHttpCacheSize:
            return "Receive network::mojom::NetworkContext::ComputeHttpCacheSize";
      case messages::NetworkContext::kNotifyExternalCacheHit:
            return "Receive network::mojom::NetworkContext::NotifyExternalCacheHit";
      case messages::NetworkContext::kClearHostCache:
            return "Receive network::mojom::NetworkContext::ClearHostCache";
      case messages::NetworkContext::kClearHttpAuthCache:
            return "Receive network::mojom::NetworkContext::ClearHttpAuthCache";
      case messages::NetworkContext::kClearCorsPreflightCache:
            return "Receive network::mojom::NetworkContext::ClearCorsPreflightCache";
      case messages::NetworkContext::kClearReportingCacheReports:
            return "Receive network::mojom::NetworkContext::ClearReportingCacheReports";
      case messages::NetworkContext::kClearReportingCacheClients:
            return "Receive network::mojom::NetworkContext::ClearReportingCacheClients";
      case messages::NetworkContext::kClearNetworkErrorLogging:
            return "Receive network::mojom::NetworkContext::ClearNetworkErrorLogging";
      case messages::NetworkContext::kClearDomainReliability:
            return "Receive network::mojom::NetworkContext::ClearDomainReliability";
      case messages::NetworkContext::kClearSharedDictionaryCache:
            return "Receive network::mojom::NetworkContext::ClearSharedDictionaryCache";
      case messages::NetworkContext::kClearSharedDictionaryCacheForIsolationKey:
            return "Receive network::mojom::NetworkContext::ClearSharedDictionaryCacheForIsolationKey";
      case messages::NetworkContext::kSetDocumentReportingEndpoints:
            return "Receive network::mojom::NetworkContext::SetDocumentReportingEndpoints";
      case messages::NetworkContext::kSetEnterpriseReportingEndpoints:
            return "Receive network::mojom::NetworkContext::SetEnterpriseReportingEndpoints";
      case messages::NetworkContext::kSendReportsAndRemoveSource:
            return "Receive network::mojom::NetworkContext::SendReportsAndRemoveSource";
      case messages::NetworkContext::kQueueReport:
            return "Receive network::mojom::NetworkContext::QueueReport";
      case messages::NetworkContext::kQueueEnterpriseReport:
            return "Receive network::mojom::NetworkContext::QueueEnterpriseReport";
      case messages::NetworkContext::kQueueSignedExchangeReport:
            return "Receive network::mojom::NetworkContext::QueueSignedExchangeReport";
      case messages::NetworkContext::kCloseAllConnections:
            return "Receive network::mojom::NetworkContext::CloseAllConnections";
      case messages::NetworkContext::kCloseIdleConnections:
            return "Receive network::mojom::NetworkContext::CloseIdleConnections";
      case messages::NetworkContext::kSetNetworkConditions:
            return "Receive network::mojom::NetworkContext::SetNetworkConditions";
      case messages::NetworkContext::kSetAcceptLanguage:
            return "Receive network::mojom::NetworkContext::SetAcceptLanguage";
      case messages::NetworkContext::kSetUserAgent:
            return "Receive network::mojom::NetworkContext::SetUserAgent";
      case messages::NetworkContext::kSetEnableReferrers:
            return "Receive network::mojom::NetworkContext::SetEnableReferrers";
      case messages::NetworkContext::kSetCTPolicy:
            return "Receive network::mojom::NetworkContext::SetCTPolicy";
      case messages::NetworkContext::kCreateUDPSocket:
            return "Receive network::mojom::NetworkContext::CreateUDPSocket";
      case messages::NetworkContext::kCreateRestrictedUDPSocket:
            return "Receive network::mojom::NetworkContext::CreateRestrictedUDPSocket";
      case messages::NetworkContext::kCreateTCPServerSocket:
            return "Receive network::mojom::NetworkContext::CreateTCPServerSocket";
      case messages::NetworkContext::kCreateTCPConnectedSocket:
            return "Receive network::mojom::NetworkContext::CreateTCPConnectedSocket";
      case messages::NetworkContext::kCreateTCPBoundSocket:
            return "Receive network::mojom::NetworkContext::CreateTCPBoundSocket";
      case messages::NetworkContext::kCreateProxyResolvingSocketFactory:
            return "Receive network::mojom::NetworkContext::CreateProxyResolvingSocketFactory";
      case messages::NetworkContext::kLookUpProxyForURL:
            return "Receive network::mojom::NetworkContext::LookUpProxyForURL";
      case messages::NetworkContext::kForceReloadProxyConfig:
            return "Receive network::mojom::NetworkContext::ForceReloadProxyConfig";
      case messages::NetworkContext::kClearBadProxiesCache:
            return "Receive network::mojom::NetworkContext::ClearBadProxiesCache";
      case messages::NetworkContext::kCreateWebSocket:
            return "Receive network::mojom::NetworkContext::CreateWebSocket";
      case messages::NetworkContext::kCreateWebTransport:
            return "Receive network::mojom::NetworkContext::CreateWebTransport";
      case messages::NetworkContext::kCreateNetLogExporter:
            return "Receive network::mojom::NetworkContext::CreateNetLogExporter";
      case messages::NetworkContext::kPreconnectSockets:
            return "Receive network::mojom::NetworkContext::PreconnectSockets";
      case messages::NetworkContext::kCreateP2PSocketManager:
            return "Receive network::mojom::NetworkContext::CreateP2PSocketManager";
      case messages::NetworkContext::kCreateMdnsResponder:
            return "Receive network::mojom::NetworkContext::CreateMdnsResponder";
      case messages::NetworkContext::kResolveHost:
            return "Receive network::mojom::NetworkContext::ResolveHost";
      case messages::NetworkContext::kCreateHostResolver:
            return "Receive network::mojom::NetworkContext::CreateHostResolver";
      case messages::NetworkContext::kVerifyCert:
            return "Receive network::mojom::NetworkContext::VerifyCert";
      case messages::NetworkContext::kVerifyCertForSignedExchange:
            return "Receive network::mojom::NetworkContext::VerifyCertForSignedExchange";
      case messages::NetworkContext::kVerify2QwacCertBinding:
            return "Receive network::mojom::NetworkContext::Verify2QwacCertBinding";
      case messages::NetworkContext::kAddHSTS:
            return "Receive network::mojom::NetworkContext::AddHSTS";
      case messages::NetworkContext::kIsHSTSActiveForHost:
            return "Receive network::mojom::NetworkContext::IsHSTSActiveForHost";
      case messages::NetworkContext::kGetHSTSState:
            return "Receive network::mojom::NetworkContext::GetHSTSState";
      case messages::NetworkContext::kSetCorsOriginAccessListsForOrigin:
            return "Receive network::mojom::NetworkContext::SetCorsOriginAccessListsForOrigin";
      case messages::NetworkContext::kDeleteDynamicDataForHost:
            return "Receive network::mojom::NetworkContext::DeleteDynamicDataForHost";
      case messages::NetworkContext::kSetSplitAuthCacheByNetworkAnonymizationKey:
            return "Receive network::mojom::NetworkContext::SetSplitAuthCacheByNetworkAnonymizationKey";
      case messages::NetworkContext::kSaveHttpAuthCacheProxyEntries:
            return "Receive network::mojom::NetworkContext::SaveHttpAuthCacheProxyEntries";
      case messages::NetworkContext::kLoadHttpAuthCacheProxyEntries:
            return "Receive network::mojom::NetworkContext::LoadHttpAuthCacheProxyEntries";
      case messages::NetworkContext::kAddAuthCacheEntry:
            return "Receive network::mojom::NetworkContext::AddAuthCacheEntry";
      case messages::NetworkContext::kSetCorsNonWildcardRequestHeadersSupport:
            return "Receive network::mojom::NetworkContext::SetCorsNonWildcardRequestHeadersSupport";
      case messages::NetworkContext::kLookupServerBasicAuthCredentials:
            return "Receive network::mojom::NetworkContext::LookupServerBasicAuthCredentials";
      case messages::NetworkContext::kEnableStaticKeyPinningForTesting:
            return "Receive network::mojom::NetworkContext::EnableStaticKeyPinningForTesting";
      case messages::NetworkContext::kVerifyCertificateForTesting:
            return "Receive network::mojom::NetworkContext::VerifyCertificateForTesting";
      case messages::NetworkContext::kGetTrustAnchorIDsForTesting:
            return "Receive network::mojom::NetworkContext::GetTrustAnchorIDsForTesting";
      case messages::NetworkContext::kAddDomainReliabilityContextForTesting:
            return "Receive network::mojom::NetworkContext::AddDomainReliabilityContextForTesting";
      case messages::NetworkContext::kForceDomainReliabilityUploadsForTesting:
            return "Receive network::mojom::NetworkContext::ForceDomainReliabilityUploadsForTesting";
      case messages::NetworkContext::kSetSCTAuditingMode:
            return "Receive network::mojom::NetworkContext::SetSCTAuditingMode";
      case messages::NetworkContext::kGetSharedDictionaryUsageInfo:
            return "Receive network::mojom::NetworkContext::GetSharedDictionaryUsageInfo";
      case messages::NetworkContext::kGetSharedDictionaryInfo:
            return "Receive network::mojom::NetworkContext::GetSharedDictionaryInfo";
      case messages::NetworkContext::kGetSharedDictionaryOriginsBetween:
            return "Receive network::mojom::NetworkContext::GetSharedDictionaryOriginsBetween";
      case messages::NetworkContext::kSetSharedDictionaryCacheMaxSize:
            return "Receive network::mojom::NetworkContext::SetSharedDictionaryCacheMaxSize";
      case messages::NetworkContext::kPreloadSharedDictionaryInfoForDocument:
            return "Receive network::mojom::NetworkContext::PreloadSharedDictionaryInfoForDocument";
      case messages::NetworkContext::kHasPreloadedSharedDictionaryInfoForTesting:
            return "Receive network::mojom::NetworkContext::HasPreloadedSharedDictionaryInfoForTesting";
      case messages::NetworkContext::kResourceSchedulerClientVisibilityChanged:
            return "Receive network::mojom::NetworkContext::ResourceSchedulerClientVisibilityChanged";
      case messages::NetworkContext::kFlushCachedClientCertIfNeeded:
            return "Receive network::mojom::NetworkContext::FlushCachedClientCertIfNeeded";
      case messages::NetworkContext::kFlushMatchingCachedClientCert:
            return "Receive network::mojom::NetworkContext::FlushMatchingCachedClientCert";
      case messages::NetworkContext::kSetCookieDeprecationLabel:
            return "Receive network::mojom::NetworkContext::SetCookieDeprecationLabel";
      case messages::NetworkContext::kRevokeNetworkForNonces:
            return "Receive network::mojom::NetworkContext::RevokeNetworkForNonces";
      case messages::NetworkContext::kClearNonces:
            return "Receive network::mojom::NetworkContext::ClearNonces";
      case messages::NetworkContext::kExemptUrlFromNetworkRevocationForNonce:
            return "Receive network::mojom::NetworkContext::ExemptUrlFromNetworkRevocationForNonce";
      case messages::NetworkContext::kPrefetch:
            return "Receive network::mojom::NetworkContext::Prefetch";
      case messages::NetworkContext::kGetBoundNetworkForTesting:
            return "Receive network::mojom::NetworkContext::GetBoundNetworkForTesting";
      case messages::NetworkContext::kGetDeviceBoundSessionManager:
            return "Receive network::mojom::NetworkContext::GetDeviceBoundSessionManager";
    }
  } else {
    switch (static_cast<messages::NetworkContext>(message.name())) {
      case messages::NetworkContext::kSetClient:
            return "Receive reply network::mojom::NetworkContext::SetClient";
      case messages::NetworkContext::kCreateURLLoaderFactory:
            return "Receive reply network::mojom::NetworkContext::CreateURLLoaderFactory";
      case messages::NetworkContext::kResetURLLoaderFactories:
            return "Receive reply network::mojom::NetworkContext::ResetURLLoaderFactories";
      case messages::NetworkContext::kGetViaObliviousHttp:
            return "Receive reply network::mojom::NetworkContext::GetViaObliviousHttp";
      case messages::NetworkContext::kGetCookieManager:
            return "Receive reply network::mojom::NetworkContext::GetCookieManager";
      case messages::NetworkContext::kGetRestrictedCookieManager:
            return "Receive reply network::mojom::NetworkContext::GetRestrictedCookieManager";
      case messages::NetworkContext::kGetTrustTokenQueryAnswerer:
            return "Receive reply network::mojom::NetworkContext::GetTrustTokenQueryAnswerer";
      case messages::NetworkContext::kClearTrustTokenData:
            return "Receive reply network::mojom::NetworkContext::ClearTrustTokenData";
      case messages::NetworkContext::kClearTrustTokenSessionOnlyData:
            return "Receive reply network::mojom::NetworkContext::ClearTrustTokenSessionOnlyData";
      case messages::NetworkContext::kGetStoredTrustTokenCounts:
            return "Receive reply network::mojom::NetworkContext::GetStoredTrustTokenCounts";
      case messages::NetworkContext::kGetPrivateStateTokenRedemptionRecords:
            return "Receive reply network::mojom::NetworkContext::GetPrivateStateTokenRedemptionRecords";
      case messages::NetworkContext::kDeleteStoredTrustTokens:
            return "Receive reply network::mojom::NetworkContext::DeleteStoredTrustTokens";
      case messages::NetworkContext::kSetBlockTrustTokens:
            return "Receive reply network::mojom::NetworkContext::SetBlockTrustTokens";
      case messages::NetworkContext::kSetTrackingProtectionContentSetting:
            return "Receive reply network::mojom::NetworkContext::SetTrackingProtectionContentSetting";
      case messages::NetworkContext::kClearNetworkingHistoryBetween:
            return "Receive reply network::mojom::NetworkContext::ClearNetworkingHistoryBetween";
      case messages::NetworkContext::kClearHttpCache:
            return "Receive reply network::mojom::NetworkContext::ClearHttpCache";
      case messages::NetworkContext::kComputeHttpCacheSize:
            return "Receive reply network::mojom::NetworkContext::ComputeHttpCacheSize";
      case messages::NetworkContext::kNotifyExternalCacheHit:
            return "Receive reply network::mojom::NetworkContext::NotifyExternalCacheHit";
      case messages::NetworkContext::kClearHostCache:
            return "Receive reply network::mojom::NetworkContext::ClearHostCache";
      case messages::NetworkContext::kClearHttpAuthCache:
            return "Receive reply network::mojom::NetworkContext::ClearHttpAuthCache";
      case messages::NetworkContext::kClearCorsPreflightCache:
            return "Receive reply network::mojom::NetworkContext::ClearCorsPreflightCache";
      case messages::NetworkContext::kClearReportingCacheReports:
            return "Receive reply network::mojom::NetworkContext::ClearReportingCacheReports";
      case messages::NetworkContext::kClearReportingCacheClients:
            return "Receive reply network::mojom::NetworkContext::ClearReportingCacheClients";
      case messages::NetworkContext::kClearNetworkErrorLogging:
            return "Receive reply network::mojom::NetworkContext::ClearNetworkErrorLogging";
      case messages::NetworkContext::kClearDomainReliability:
            return "Receive reply network::mojom::NetworkContext::ClearDomainReliability";
      case messages::NetworkContext::kClearSharedDictionaryCache:
            return "Receive reply network::mojom::NetworkContext::ClearSharedDictionaryCache";
      case messages::NetworkContext::kClearSharedDictionaryCacheForIsolationKey:
            return "Receive reply network::mojom::NetworkContext::ClearSharedDictionaryCacheForIsolationKey";
      case messages::NetworkContext::kSetDocumentReportingEndpoints:
            return "Receive reply network::mojom::NetworkContext::SetDocumentReportingEndpoints";
      case messages::NetworkContext::kSetEnterpriseReportingEndpoints:
            return "Receive reply network::mojom::NetworkContext::SetEnterpriseReportingEndpoints";
      case messages::NetworkContext::kSendReportsAndRemoveSource:
            return "Receive reply network::mojom::NetworkContext::SendReportsAndRemoveSource";
      case messages::NetworkContext::kQueueReport:
            return "Receive reply network::mojom::NetworkContext::QueueReport";
      case messages::NetworkContext::kQueueEnterpriseReport:
            return "Receive reply network::mojom::NetworkContext::QueueEnterpriseReport";
      case messages::NetworkContext::kQueueSignedExchangeReport:
            return "Receive reply network::mojom::NetworkContext::QueueSignedExchangeReport";
      case messages::NetworkContext::kCloseAllConnections:
            return "Receive reply network::mojom::NetworkContext::CloseAllConnections";
      case messages::NetworkContext::kCloseIdleConnections:
            return "Receive reply network::mojom::NetworkContext::CloseIdleConnections";
      case messages::NetworkContext::kSetNetworkConditions:
            return "Receive reply network::mojom::NetworkContext::SetNetworkConditions";
      case messages::NetworkContext::kSetAcceptLanguage:
            return "Receive reply network::mojom::NetworkContext::SetAcceptLanguage";
      case messages::NetworkContext::kSetUserAgent:
            return "Receive reply network::mojom::NetworkContext::SetUserAgent";
      case messages::NetworkContext::kSetEnableReferrers:
            return "Receive reply network::mojom::NetworkContext::SetEnableReferrers";
      case messages::NetworkContext::kSetCTPolicy:
            return "Receive reply network::mojom::NetworkContext::SetCTPolicy";
      case messages::NetworkContext::kCreateUDPSocket:
            return "Receive reply network::mojom::NetworkContext::CreateUDPSocket";
      case messages::NetworkContext::kCreateRestrictedUDPSocket:
            return "Receive reply network::mojom::NetworkContext::CreateRestrictedUDPSocket";
      case messages::NetworkContext::kCreateTCPServerSocket:
            return "Receive reply network::mojom::NetworkContext::CreateTCPServerSocket";
      case messages::NetworkContext::kCreateTCPConnectedSocket:
            return "Receive reply network::mojom::NetworkContext::CreateTCPConnectedSocket";
      case messages::NetworkContext::kCreateTCPBoundSocket:
            return "Receive reply network::mojom::NetworkContext::CreateTCPBoundSocket";
      case messages::NetworkContext::kCreateProxyResolvingSocketFactory:
            return "Receive reply network::mojom::NetworkContext::CreateProxyResolvingSocketFactory";
      case messages::NetworkContext::kLookUpProxyForURL:
            return "Receive reply network::mojom::NetworkContext::LookUpProxyForURL";
      case messages::NetworkContext::kForceReloadProxyConfig:
            return "Receive reply network::mojom::NetworkContext::ForceReloadProxyConfig";
      case messages::NetworkContext::kClearBadProxiesCache:
            return "Receive reply network::mojom::NetworkContext::ClearBadProxiesCache";
      case messages::NetworkContext::kCreateWebSocket:
            return "Receive reply network::mojom::NetworkContext::CreateWebSocket";
      case messages::NetworkContext::kCreateWebTransport:
            return "Receive reply network::mojom::NetworkContext::CreateWebTransport";
      case messages::NetworkContext::kCreateNetLogExporter:
            return "Receive reply network::mojom::NetworkContext::CreateNetLogExporter";
      case messages::NetworkContext::kPreconnectSockets:
            return "Receive reply network::mojom::NetworkContext::PreconnectSockets";
      case messages::NetworkContext::kCreateP2PSocketManager:
            return "Receive reply network::mojom::NetworkContext::CreateP2PSocketManager";
      case messages::NetworkContext::kCreateMdnsResponder:
            return "Receive reply network::mojom::NetworkContext::CreateMdnsResponder";
      case messages::NetworkContext::kResolveHost:
            return "Receive reply network::mojom::NetworkContext::ResolveHost";
      case messages::NetworkContext::kCreateHostResolver:
            return "Receive reply network::mojom::NetworkContext::CreateHostResolver";
      case messages::NetworkContext::kVerifyCert:
            return "Receive reply network::mojom::NetworkContext::VerifyCert";
      case messages::NetworkContext::kVerifyCertForSignedExchange:
            return "Receive reply network::mojom::NetworkContext::VerifyCertForSignedExchange";
      case messages::NetworkContext::kVerify2QwacCertBinding:
            return "Receive reply network::mojom::NetworkContext::Verify2QwacCertBinding";
      case messages::NetworkContext::kAddHSTS:
            return "Receive reply network::mojom::NetworkContext::AddHSTS";
      case messages::NetworkContext::kIsHSTSActiveForHost:
            return "Receive reply network::mojom::NetworkContext::IsHSTSActiveForHost";
      case messages::NetworkContext::kGetHSTSState:
            return "Receive reply network::mojom::NetworkContext::GetHSTSState";
      case messages::NetworkContext::kSetCorsOriginAccessListsForOrigin:
            return "Receive reply network::mojom::NetworkContext::SetCorsOriginAccessListsForOrigin";
      case messages::NetworkContext::kDeleteDynamicDataForHost:
            return "Receive reply network::mojom::NetworkContext::DeleteDynamicDataForHost";
      case messages::NetworkContext::kSetSplitAuthCacheByNetworkAnonymizationKey:
            return "Receive reply network::mojom::NetworkContext::SetSplitAuthCacheByNetworkAnonymizationKey";
      case messages::NetworkContext::kSaveHttpAuthCacheProxyEntries:
            return "Receive reply network::mojom::NetworkContext::SaveHttpAuthCacheProxyEntries";
      case messages::NetworkContext::kLoadHttpAuthCacheProxyEntries:
            return "Receive reply network::mojom::NetworkContext::LoadHttpAuthCacheProxyEntries";
      case messages::NetworkContext::kAddAuthCacheEntry:
            return "Receive reply network::mojom::NetworkContext::AddAuthCacheEntry";
      case messages::NetworkContext::kSetCorsNonWildcardRequestHeadersSupport:
            return "Receive reply network::mojom::NetworkContext::SetCorsNonWildcardRequestHeadersSupport";
      case messages::NetworkContext::kLookupServerBasicAuthCredentials:
            return "Receive reply network::mojom::NetworkContext::LookupServerBasicAuthCredentials";
      case messages::NetworkContext::kEnableStaticKeyPinningForTesting:
            return "Receive reply network::mojom::NetworkContext::EnableStaticKeyPinningForTesting";
      case messages::NetworkContext::kVerifyCertificateForTesting:
            return "Receive reply network::mojom::NetworkContext::VerifyCertificateForTesting";
      case messages::NetworkContext::kGetTrustAnchorIDsForTesting:
            return "Receive reply network::mojom::NetworkContext::GetTrustAnchorIDsForTesting";
      case messages::NetworkContext::kAddDomainReliabilityContextForTesting:
            return "Receive reply network::mojom::NetworkContext::AddDomainReliabilityContextForTesting";
      case messages::NetworkContext::kForceDomainReliabilityUploadsForTesting:
            return "Receive reply network::mojom::NetworkContext::ForceDomainReliabilityUploadsForTesting";
      case messages::NetworkContext::kSetSCTAuditingMode:
            return "Receive reply network::mojom::NetworkContext::SetSCTAuditingMode";
      case messages::NetworkContext::kGetSharedDictionaryUsageInfo:
            return "Receive reply network::mojom::NetworkContext::GetSharedDictionaryUsageInfo";
      case messages::NetworkContext::kGetSharedDictionaryInfo:
            return "Receive reply network::mojom::NetworkContext::GetSharedDictionaryInfo";
      case messages::NetworkContext::kGetSharedDictionaryOriginsBetween:
            return "Receive reply network::mojom::NetworkContext::GetSharedDictionaryOriginsBetween";
      case messages::NetworkContext::kSetSharedDictionaryCacheMaxSize:
            return "Receive reply network::mojom::NetworkContext::SetSharedDictionaryCacheMaxSize";
      case messages::NetworkContext::kPreloadSharedDictionaryInfoForDocument:
            return "Receive reply network::mojom::NetworkContext::PreloadSharedDictionaryInfoForDocument";
      case messages::NetworkContext::kHasPreloadedSharedDictionaryInfoForTesting:
            return "Receive reply network::mojom::NetworkContext::HasPreloadedSharedDictionaryInfoForTesting";
      case messages::NetworkContext::kResourceSchedulerClientVisibilityChanged:
            return "Receive reply network::mojom::NetworkContext::ResourceSchedulerClientVisibilityChanged";
      case messages::NetworkContext::kFlushCachedClientCertIfNeeded:
            return "Receive reply network::mojom::NetworkContext::FlushCachedClientCertIfNeeded";
      case messages::NetworkContext::kFlushMatchingCachedClientCert:
            return "Receive reply network::mojom::NetworkContext::FlushMatchingCachedClientCert";
      case messages::NetworkContext::kSetCookieDeprecationLabel:
            return "Receive reply network::mojom::NetworkContext::SetCookieDeprecationLabel";
      case messages::NetworkContext::kRevokeNetworkForNonces:
            return "Receive reply network::mojom::NetworkContext::RevokeNetworkForNonces";
      case messages::NetworkContext::kClearNonces:
            return "Receive reply network::mojom::NetworkContext::ClearNonces";
      case messages::NetworkContext::kExemptUrlFromNetworkRevocationForNonce:
            return "Receive reply network::mojom::NetworkContext::ExemptUrlFromNetworkRevocationForNonce";
      case messages::NetworkContext::kPrefetch:
            return "Receive reply network::mojom::NetworkContext::Prefetch";
      case messages::NetworkContext::kGetBoundNetworkForTesting:
            return "Receive reply network::mojom::NetworkContext::GetBoundNetworkForTesting";
      case messages::NetworkContext::kGetDeviceBoundSessionManager:
            return "Receive reply network::mojom::NetworkContext::GetDeviceBoundSessionManager";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t NetworkContext::SetClient_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf8659408;  // IPCStableHash for network::mojom::NetworkContext::SetClient
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::CreateURLLoaderFactory_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1cabc51e;  // IPCStableHash for network::mojom::NetworkContext::CreateURLLoaderFactory
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::ResetURLLoaderFactories_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf11eab93;  // IPCStableHash for network::mojom::NetworkContext::ResetURLLoaderFactories
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::GetViaObliviousHttp_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc3bafbf3;  // IPCStableHash for network::mojom::NetworkContext::GetViaObliviousHttp
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::GetCookieManager_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa1749c7d;  // IPCStableHash for network::mojom::NetworkContext::GetCookieManager
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::GetRestrictedCookieManager_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb824e146;  // IPCStableHash for network::mojom::NetworkContext::GetRestrictedCookieManager
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::GetTrustTokenQueryAnswerer_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa3febf0e;  // IPCStableHash for network::mojom::NetworkContext::GetTrustTokenQueryAnswerer
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::ClearTrustTokenData_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xaa8a7b71;  // IPCStableHash for network::mojom::NetworkContext::ClearTrustTokenData
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::ClearTrustTokenSessionOnlyData_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x83900601;  // IPCStableHash for network::mojom::NetworkContext::ClearTrustTokenSessionOnlyData
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::GetStoredTrustTokenCounts_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x728de229;  // IPCStableHash for network::mojom::NetworkContext::GetStoredTrustTokenCounts
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::GetPrivateStateTokenRedemptionRecords_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0bea0545;  // IPCStableHash for network::mojom::NetworkContext::GetPrivateStateTokenRedemptionRecords
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::DeleteStoredTrustTokens_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3d5042df;  // IPCStableHash for network::mojom::NetworkContext::DeleteStoredTrustTokens
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::SetBlockTrustTokens_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x203f2bfb;  // IPCStableHash for network::mojom::NetworkContext::SetBlockTrustTokens
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::SetTrackingProtectionContentSetting_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x353898a4;  // IPCStableHash for network::mojom::NetworkContext::SetTrackingProtectionContentSetting
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::ClearNetworkingHistoryBetween_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0ff85293;  // IPCStableHash for network::mojom::NetworkContext::ClearNetworkingHistoryBetween
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::ClearHttpCache_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc537fa0b;  // IPCStableHash for network::mojom::NetworkContext::ClearHttpCache
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::ComputeHttpCacheSize_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x91c36b2c;  // IPCStableHash for network::mojom::NetworkContext::ComputeHttpCacheSize
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::NotifyExternalCacheHit_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x59d8f0f7;  // IPCStableHash for network::mojom::NetworkContext::NotifyExternalCacheHit
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::ClearHostCache_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcd021e7c;  // IPCStableHash for network::mojom::NetworkContext::ClearHostCache
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::ClearHttpAuthCache_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1ff54c74;  // IPCStableHash for network::mojom::NetworkContext::ClearHttpAuthCache
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::ClearCorsPreflightCache_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x413c1879;  // IPCStableHash for network::mojom::NetworkContext::ClearCorsPreflightCache
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::ClearReportingCacheReports_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x949fc90e;  // IPCStableHash for network::mojom::NetworkContext::ClearReportingCacheReports
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::ClearReportingCacheClients_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5274a97c;  // IPCStableHash for network::mojom::NetworkContext::ClearReportingCacheClients
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::ClearNetworkErrorLogging_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbfb88d3c;  // IPCStableHash for network::mojom::NetworkContext::ClearNetworkErrorLogging
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::ClearDomainReliability_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x42c213dc;  // IPCStableHash for network::mojom::NetworkContext::ClearDomainReliability
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::ClearSharedDictionaryCache_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5da16cf4;  // IPCStableHash for network::mojom::NetworkContext::ClearSharedDictionaryCache
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::ClearSharedDictionaryCacheForIsolationKey_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9c2783ed;  // IPCStableHash for network::mojom::NetworkContext::ClearSharedDictionaryCacheForIsolationKey
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::SetDocumentReportingEndpoints_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe9717bc1;  // IPCStableHash for network::mojom::NetworkContext::SetDocumentReportingEndpoints
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::SetEnterpriseReportingEndpoints_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6e2a092d;  // IPCStableHash for network::mojom::NetworkContext::SetEnterpriseReportingEndpoints
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::SendReportsAndRemoveSource_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb99f5906;  // IPCStableHash for network::mojom::NetworkContext::SendReportsAndRemoveSource
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::QueueReport_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2940f3c6;  // IPCStableHash for network::mojom::NetworkContext::QueueReport
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::QueueEnterpriseReport_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x33271711;  // IPCStableHash for network::mojom::NetworkContext::QueueEnterpriseReport
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::QueueSignedExchangeReport_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa2484c05;  // IPCStableHash for network::mojom::NetworkContext::QueueSignedExchangeReport
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::CloseAllConnections_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xebac2473;  // IPCStableHash for network::mojom::NetworkContext::CloseAllConnections
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::CloseIdleConnections_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xae01cb55;  // IPCStableHash for network::mojom::NetworkContext::CloseIdleConnections
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::SetNetworkConditions_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcf2e658a;  // IPCStableHash for network::mojom::NetworkContext::SetNetworkConditions
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::SetAcceptLanguage_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xdef85972;  // IPCStableHash for network::mojom::NetworkContext::SetAcceptLanguage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::SetUserAgent_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8204d216;  // IPCStableHash for network::mojom::NetworkContext::SetUserAgent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::SetEnableReferrers_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4e4fddac;  // IPCStableHash for network::mojom::NetworkContext::SetEnableReferrers
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::SetCTPolicy_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc0d98433;  // IPCStableHash for network::mojom::NetworkContext::SetCTPolicy
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::CreateUDPSocket_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa48524be;  // IPCStableHash for network::mojom::NetworkContext::CreateUDPSocket
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::CreateRestrictedUDPSocket_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9cc0c92f;  // IPCStableHash for network::mojom::NetworkContext::CreateRestrictedUDPSocket
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::CreateTCPServerSocket_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2ff3433a;  // IPCStableHash for network::mojom::NetworkContext::CreateTCPServerSocket
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::CreateTCPConnectedSocket_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3f44bbf9;  // IPCStableHash for network::mojom::NetworkContext::CreateTCPConnectedSocket
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::CreateTCPBoundSocket_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7f473e1e;  // IPCStableHash for network::mojom::NetworkContext::CreateTCPBoundSocket
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::CreateProxyResolvingSocketFactory_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x582f70b6;  // IPCStableHash for network::mojom::NetworkContext::CreateProxyResolvingSocketFactory
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::LookUpProxyForURL_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x20ea0ca0;  // IPCStableHash for network::mojom::NetworkContext::LookUpProxyForURL
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::ForceReloadProxyConfig_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6228067b;  // IPCStableHash for network::mojom::NetworkContext::ForceReloadProxyConfig
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::ClearBadProxiesCache_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x86658769;  // IPCStableHash for network::mojom::NetworkContext::ClearBadProxiesCache
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::CreateWebSocket_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1bc862d3;  // IPCStableHash for network::mojom::NetworkContext::CreateWebSocket
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::CreateWebTransport_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2e6a98fd;  // IPCStableHash for network::mojom::NetworkContext::CreateWebTransport
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::CreateNetLogExporter_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x61bd8389;  // IPCStableHash for network::mojom::NetworkContext::CreateNetLogExporter
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::PreconnectSockets_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfe8445d3;  // IPCStableHash for network::mojom::NetworkContext::PreconnectSockets
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::CreateP2PSocketManager_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x20550535;  // IPCStableHash for network::mojom::NetworkContext::CreateP2PSocketManager
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::CreateMdnsResponder_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x640bff7a;  // IPCStableHash for network::mojom::NetworkContext::CreateMdnsResponder
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::ResolveHost_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0385dc82;  // IPCStableHash for network::mojom::NetworkContext::ResolveHost
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::CreateHostResolver_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcee96d16;  // IPCStableHash for network::mojom::NetworkContext::CreateHostResolver
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::VerifyCert_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2e05e9f9;  // IPCStableHash for network::mojom::NetworkContext::VerifyCert
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::VerifyCertForSignedExchange_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x66421cb0;  // IPCStableHash for network::mojom::NetworkContext::VerifyCertForSignedExchange
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::Verify2QwacCertBinding_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x349114ac;  // IPCStableHash for network::mojom::NetworkContext::Verify2QwacCertBinding
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::AddHSTS_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x02bf6314;  // IPCStableHash for network::mojom::NetworkContext::AddHSTS
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::IsHSTSActiveForHost_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4caafac4;  // IPCStableHash for network::mojom::NetworkContext::IsHSTSActiveForHost
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::GetHSTSState_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x403cca70;  // IPCStableHash for network::mojom::NetworkContext::GetHSTSState
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::SetCorsOriginAccessListsForOrigin_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd73abbce;  // IPCStableHash for network::mojom::NetworkContext::SetCorsOriginAccessListsForOrigin
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::DeleteDynamicDataForHost_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6cbcfe3a;  // IPCStableHash for network::mojom::NetworkContext::DeleteDynamicDataForHost
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::SetSplitAuthCacheByNetworkAnonymizationKey_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1274a2f8;  // IPCStableHash for network::mojom::NetworkContext::SetSplitAuthCacheByNetworkAnonymizationKey
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::SaveHttpAuthCacheProxyEntries_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x712ba160;  // IPCStableHash for network::mojom::NetworkContext::SaveHttpAuthCacheProxyEntries
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::LoadHttpAuthCacheProxyEntries_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0dbb3138;  // IPCStableHash for network::mojom::NetworkContext::LoadHttpAuthCacheProxyEntries
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::AddAuthCacheEntry_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x44054c16;  // IPCStableHash for network::mojom::NetworkContext::AddAuthCacheEntry
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::SetCorsNonWildcardRequestHeadersSupport_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3f512f15;  // IPCStableHash for network::mojom::NetworkContext::SetCorsNonWildcardRequestHeadersSupport
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::LookupServerBasicAuthCredentials_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x412dbeb4;  // IPCStableHash for network::mojom::NetworkContext::LookupServerBasicAuthCredentials
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::EnableStaticKeyPinningForTesting_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5323aab8;  // IPCStableHash for network::mojom::NetworkContext::EnableStaticKeyPinningForTesting
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::VerifyCertificateForTesting_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x43a30112;  // IPCStableHash for network::mojom::NetworkContext::VerifyCertificateForTesting
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::GetTrustAnchorIDsForTesting_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf3ca4bbf;  // IPCStableHash for network::mojom::NetworkContext::GetTrustAnchorIDsForTesting
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::AddDomainReliabilityContextForTesting_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xee375a2d;  // IPCStableHash for network::mojom::NetworkContext::AddDomainReliabilityContextForTesting
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::ForceDomainReliabilityUploadsForTesting_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x03d00ac9;  // IPCStableHash for network::mojom::NetworkContext::ForceDomainReliabilityUploadsForTesting
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::SetSCTAuditingMode_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x659bcdfd;  // IPCStableHash for network::mojom::NetworkContext::SetSCTAuditingMode
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::GetSharedDictionaryUsageInfo_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3862f7e2;  // IPCStableHash for network::mojom::NetworkContext::GetSharedDictionaryUsageInfo
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::GetSharedDictionaryInfo_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x028e10c3;  // IPCStableHash for network::mojom::NetworkContext::GetSharedDictionaryInfo
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::GetSharedDictionaryOriginsBetween_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5599d58d;  // IPCStableHash for network::mojom::NetworkContext::GetSharedDictionaryOriginsBetween
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::SetSharedDictionaryCacheMaxSize_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb8b6bb9b;  // IPCStableHash for network::mojom::NetworkContext::SetSharedDictionaryCacheMaxSize
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::PreloadSharedDictionaryInfoForDocument_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc5ea95a7;  // IPCStableHash for network::mojom::NetworkContext::PreloadSharedDictionaryInfoForDocument
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::HasPreloadedSharedDictionaryInfoForTesting_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x311e0c08;  // IPCStableHash for network::mojom::NetworkContext::HasPreloadedSharedDictionaryInfoForTesting
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::ResourceSchedulerClientVisibilityChanged_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9eb11403;  // IPCStableHash for network::mojom::NetworkContext::ResourceSchedulerClientVisibilityChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::FlushCachedClientCertIfNeeded_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3e1c671e;  // IPCStableHash for network::mojom::NetworkContext::FlushCachedClientCertIfNeeded
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::FlushMatchingCachedClientCert_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4e2f5d9c;  // IPCStableHash for network::mojom::NetworkContext::FlushMatchingCachedClientCert
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::SetCookieDeprecationLabel_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x56335aca;  // IPCStableHash for network::mojom::NetworkContext::SetCookieDeprecationLabel
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::RevokeNetworkForNonces_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x470a7b75;  // IPCStableHash for network::mojom::NetworkContext::RevokeNetworkForNonces
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::ClearNonces_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbfdd2976;  // IPCStableHash for network::mojom::NetworkContext::ClearNonces
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::ExemptUrlFromNetworkRevocationForNonce_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x29cd4841;  // IPCStableHash for network::mojom::NetworkContext::ExemptUrlFromNetworkRevocationForNonce
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::Prefetch_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc94c2331;  // IPCStableHash for network::mojom::NetworkContext::Prefetch
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::GetBoundNetworkForTesting_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xaf7f4cc8;  // IPCStableHash for network::mojom::NetworkContext::GetBoundNetworkForTesting
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkContext::GetDeviceBoundSessionManager_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3e55a1f3;  // IPCStableHash for network::mojom::NetworkContext::GetDeviceBoundSessionManager
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)
bool NetworkContext::EnableStaticKeyPinningForTesting() {
  NOTREACHED();
}
bool NetworkContext::GetTrustAnchorIDsForTesting(std::vector<std::vector<uint8_t>>* out_trust_anchor_ids) {
  NOTREACHED();
}
bool NetworkContext::AddDomainReliabilityContextForTesting(const ::url::Origin& origin, const ::GURL& upload_url) {
  NOTREACHED();
}
bool NetworkContext::ForceDomainReliabilityUploadsForTesting() {
  NOTREACHED();
}

class NetworkContext_ClearTrustTokenData_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_ClearTrustTokenData_ForwardToCallback(
      NetworkContext::ClearTrustTokenDataCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkContext_ClearTrustTokenData_ForwardToCallback(const NetworkContext_ClearTrustTokenData_ForwardToCallback&) = delete;
  NetworkContext_ClearTrustTokenData_ForwardToCallback& operator=(const NetworkContext_ClearTrustTokenData_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::ClearTrustTokenDataCallback callback_;
};

class NetworkContext_ClearTrustTokenSessionOnlyData_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_ClearTrustTokenSessionOnlyData_ForwardToCallback(
      NetworkContext::ClearTrustTokenSessionOnlyDataCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkContext_ClearTrustTokenSessionOnlyData_ForwardToCallback(const NetworkContext_ClearTrustTokenSessionOnlyData_ForwardToCallback&) = delete;
  NetworkContext_ClearTrustTokenSessionOnlyData_ForwardToCallback& operator=(const NetworkContext_ClearTrustTokenSessionOnlyData_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::ClearTrustTokenSessionOnlyDataCallback callback_;
};

class NetworkContext_GetStoredTrustTokenCounts_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_GetStoredTrustTokenCounts_ForwardToCallback(
      NetworkContext::GetStoredTrustTokenCountsCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkContext_GetStoredTrustTokenCounts_ForwardToCallback(const NetworkContext_GetStoredTrustTokenCounts_ForwardToCallback&) = delete;
  NetworkContext_GetStoredTrustTokenCounts_ForwardToCallback& operator=(const NetworkContext_GetStoredTrustTokenCounts_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::GetStoredTrustTokenCountsCallback callback_;
};

class NetworkContext_GetPrivateStateTokenRedemptionRecords_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_GetPrivateStateTokenRedemptionRecords_ForwardToCallback(
      NetworkContext::GetPrivateStateTokenRedemptionRecordsCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkContext_GetPrivateStateTokenRedemptionRecords_ForwardToCallback(const NetworkContext_GetPrivateStateTokenRedemptionRecords_ForwardToCallback&) = delete;
  NetworkContext_GetPrivateStateTokenRedemptionRecords_ForwardToCallback& operator=(const NetworkContext_GetPrivateStateTokenRedemptionRecords_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::GetPrivateStateTokenRedemptionRecordsCallback callback_;
};

class NetworkContext_DeleteStoredTrustTokens_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_DeleteStoredTrustTokens_ForwardToCallback(
      NetworkContext::DeleteStoredTrustTokensCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkContext_DeleteStoredTrustTokens_ForwardToCallback(const NetworkContext_DeleteStoredTrustTokens_ForwardToCallback&) = delete;
  NetworkContext_DeleteStoredTrustTokens_ForwardToCallback& operator=(const NetworkContext_DeleteStoredTrustTokens_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::DeleteStoredTrustTokensCallback callback_;
};

class NetworkContext_ClearNetworkingHistoryBetween_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_ClearNetworkingHistoryBetween_ForwardToCallback(
      NetworkContext::ClearNetworkingHistoryBetweenCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkContext_ClearNetworkingHistoryBetween_ForwardToCallback(const NetworkContext_ClearNetworkingHistoryBetween_ForwardToCallback&) = delete;
  NetworkContext_ClearNetworkingHistoryBetween_ForwardToCallback& operator=(const NetworkContext_ClearNetworkingHistoryBetween_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::ClearNetworkingHistoryBetweenCallback callback_;
};

class NetworkContext_ClearHttpCache_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_ClearHttpCache_ForwardToCallback(
      NetworkContext::ClearHttpCacheCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkContext_ClearHttpCache_ForwardToCallback(const NetworkContext_ClearHttpCache_ForwardToCallback&) = delete;
  NetworkContext_ClearHttpCache_ForwardToCallback& operator=(const NetworkContext_ClearHttpCache_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::ClearHttpCacheCallback callback_;
};

class NetworkContext_ComputeHttpCacheSize_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_ComputeHttpCacheSize_ForwardToCallback(
      NetworkContext::ComputeHttpCacheSizeCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkContext_ComputeHttpCacheSize_ForwardToCallback(const NetworkContext_ComputeHttpCacheSize_ForwardToCallback&) = delete;
  NetworkContext_ComputeHttpCacheSize_ForwardToCallback& operator=(const NetworkContext_ComputeHttpCacheSize_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::ComputeHttpCacheSizeCallback callback_;
};

class NetworkContext_ClearHostCache_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_ClearHostCache_ForwardToCallback(
      NetworkContext::ClearHostCacheCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkContext_ClearHostCache_ForwardToCallback(const NetworkContext_ClearHostCache_ForwardToCallback&) = delete;
  NetworkContext_ClearHostCache_ForwardToCallback& operator=(const NetworkContext_ClearHostCache_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::ClearHostCacheCallback callback_;
};

class NetworkContext_ClearHttpAuthCache_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_ClearHttpAuthCache_ForwardToCallback(
      NetworkContext::ClearHttpAuthCacheCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkContext_ClearHttpAuthCache_ForwardToCallback(const NetworkContext_ClearHttpAuthCache_ForwardToCallback&) = delete;
  NetworkContext_ClearHttpAuthCache_ForwardToCallback& operator=(const NetworkContext_ClearHttpAuthCache_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::ClearHttpAuthCacheCallback callback_;
};

class NetworkContext_ClearCorsPreflightCache_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_ClearCorsPreflightCache_ForwardToCallback(
      NetworkContext::ClearCorsPreflightCacheCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkContext_ClearCorsPreflightCache_ForwardToCallback(const NetworkContext_ClearCorsPreflightCache_ForwardToCallback&) = delete;
  NetworkContext_ClearCorsPreflightCache_ForwardToCallback& operator=(const NetworkContext_ClearCorsPreflightCache_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::ClearCorsPreflightCacheCallback callback_;
};

class NetworkContext_ClearReportingCacheReports_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_ClearReportingCacheReports_ForwardToCallback(
      NetworkContext::ClearReportingCacheReportsCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkContext_ClearReportingCacheReports_ForwardToCallback(const NetworkContext_ClearReportingCacheReports_ForwardToCallback&) = delete;
  NetworkContext_ClearReportingCacheReports_ForwardToCallback& operator=(const NetworkContext_ClearReportingCacheReports_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::ClearReportingCacheReportsCallback callback_;
};

class NetworkContext_ClearReportingCacheClients_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_ClearReportingCacheClients_ForwardToCallback(
      NetworkContext::ClearReportingCacheClientsCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkContext_ClearReportingCacheClients_ForwardToCallback(const NetworkContext_ClearReportingCacheClients_ForwardToCallback&) = delete;
  NetworkContext_ClearReportingCacheClients_ForwardToCallback& operator=(const NetworkContext_ClearReportingCacheClients_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::ClearReportingCacheClientsCallback callback_;
};

class NetworkContext_ClearNetworkErrorLogging_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_ClearNetworkErrorLogging_ForwardToCallback(
      NetworkContext::ClearNetworkErrorLoggingCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkContext_ClearNetworkErrorLogging_ForwardToCallback(const NetworkContext_ClearNetworkErrorLogging_ForwardToCallback&) = delete;
  NetworkContext_ClearNetworkErrorLogging_ForwardToCallback& operator=(const NetworkContext_ClearNetworkErrorLogging_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::ClearNetworkErrorLoggingCallback callback_;
};

class NetworkContext_ClearDomainReliability_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_ClearDomainReliability_ForwardToCallback(
      NetworkContext::ClearDomainReliabilityCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkContext_ClearDomainReliability_ForwardToCallback(const NetworkContext_ClearDomainReliability_ForwardToCallback&) = delete;
  NetworkContext_ClearDomainReliability_ForwardToCallback& operator=(const NetworkContext_ClearDomainReliability_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::ClearDomainReliabilityCallback callback_;
};

class NetworkContext_ClearSharedDictionaryCache_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_ClearSharedDictionaryCache_ForwardToCallback(
      NetworkContext::ClearSharedDictionaryCacheCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkContext_ClearSharedDictionaryCache_ForwardToCallback(const NetworkContext_ClearSharedDictionaryCache_ForwardToCallback&) = delete;
  NetworkContext_ClearSharedDictionaryCache_ForwardToCallback& operator=(const NetworkContext_ClearSharedDictionaryCache_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::ClearSharedDictionaryCacheCallback callback_;
};

class NetworkContext_ClearSharedDictionaryCacheForIsolationKey_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_ClearSharedDictionaryCacheForIsolationKey_ForwardToCallback(
      NetworkContext::ClearSharedDictionaryCacheForIsolationKeyCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkContext_ClearSharedDictionaryCacheForIsolationKey_ForwardToCallback(const NetworkContext_ClearSharedDictionaryCacheForIsolationKey_ForwardToCallback&) = delete;
  NetworkContext_ClearSharedDictionaryCacheForIsolationKey_ForwardToCallback& operator=(const NetworkContext_ClearSharedDictionaryCacheForIsolationKey_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::ClearSharedDictionaryCacheForIsolationKeyCallback callback_;
};

class NetworkContext_CloseAllConnections_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_CloseAllConnections_ForwardToCallback(
      NetworkContext::CloseAllConnectionsCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkContext_CloseAllConnections_ForwardToCallback(const NetworkContext_CloseAllConnections_ForwardToCallback&) = delete;
  NetworkContext_CloseAllConnections_ForwardToCallback& operator=(const NetworkContext_CloseAllConnections_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::CloseAllConnectionsCallback callback_;
};

class NetworkContext_CloseIdleConnections_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_CloseIdleConnections_ForwardToCallback(
      NetworkContext::CloseIdleConnectionsCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkContext_CloseIdleConnections_ForwardToCallback(const NetworkContext_CloseIdleConnections_ForwardToCallback&) = delete;
  NetworkContext_CloseIdleConnections_ForwardToCallback& operator=(const NetworkContext_CloseIdleConnections_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::CloseIdleConnectionsCallback callback_;
};

class NetworkContext_CreateRestrictedUDPSocket_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_CreateRestrictedUDPSocket_ForwardToCallback(
      NetworkContext::CreateRestrictedUDPSocketCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkContext_CreateRestrictedUDPSocket_ForwardToCallback(const NetworkContext_CreateRestrictedUDPSocket_ForwardToCallback&) = delete;
  NetworkContext_CreateRestrictedUDPSocket_ForwardToCallback& operator=(const NetworkContext_CreateRestrictedUDPSocket_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::CreateRestrictedUDPSocketCallback callback_;
};

class NetworkContext_CreateTCPServerSocket_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_CreateTCPServerSocket_ForwardToCallback(
      NetworkContext::CreateTCPServerSocketCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkContext_CreateTCPServerSocket_ForwardToCallback(const NetworkContext_CreateTCPServerSocket_ForwardToCallback&) = delete;
  NetworkContext_CreateTCPServerSocket_ForwardToCallback& operator=(const NetworkContext_CreateTCPServerSocket_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::CreateTCPServerSocketCallback callback_;
};

class NetworkContext_CreateTCPConnectedSocket_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_CreateTCPConnectedSocket_ForwardToCallback(
      NetworkContext::CreateTCPConnectedSocketCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkContext_CreateTCPConnectedSocket_ForwardToCallback(const NetworkContext_CreateTCPConnectedSocket_ForwardToCallback&) = delete;
  NetworkContext_CreateTCPConnectedSocket_ForwardToCallback& operator=(const NetworkContext_CreateTCPConnectedSocket_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::CreateTCPConnectedSocketCallback callback_;
};

class NetworkContext_CreateTCPBoundSocket_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_CreateTCPBoundSocket_ForwardToCallback(
      NetworkContext::CreateTCPBoundSocketCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkContext_CreateTCPBoundSocket_ForwardToCallback(const NetworkContext_CreateTCPBoundSocket_ForwardToCallback&) = delete;
  NetworkContext_CreateTCPBoundSocket_ForwardToCallback& operator=(const NetworkContext_CreateTCPBoundSocket_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::CreateTCPBoundSocketCallback callback_;
};

class NetworkContext_ForceReloadProxyConfig_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_ForceReloadProxyConfig_ForwardToCallback(
      NetworkContext::ForceReloadProxyConfigCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkContext_ForceReloadProxyConfig_ForwardToCallback(const NetworkContext_ForceReloadProxyConfig_ForwardToCallback&) = delete;
  NetworkContext_ForceReloadProxyConfig_ForwardToCallback& operator=(const NetworkContext_ForceReloadProxyConfig_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::ForceReloadProxyConfigCallback callback_;
};

class NetworkContext_ClearBadProxiesCache_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_ClearBadProxiesCache_ForwardToCallback(
      NetworkContext::ClearBadProxiesCacheCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkContext_ClearBadProxiesCache_ForwardToCallback(const NetworkContext_ClearBadProxiesCache_ForwardToCallback&) = delete;
  NetworkContext_ClearBadProxiesCache_ForwardToCallback& operator=(const NetworkContext_ClearBadProxiesCache_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::ClearBadProxiesCacheCallback callback_;
};

class NetworkContext_VerifyCert_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_VerifyCert_ForwardToCallback(
      NetworkContext::VerifyCertCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkContext_VerifyCert_ForwardToCallback(const NetworkContext_VerifyCert_ForwardToCallback&) = delete;
  NetworkContext_VerifyCert_ForwardToCallback& operator=(const NetworkContext_VerifyCert_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::VerifyCertCallback callback_;
};

class NetworkContext_VerifyCertForSignedExchange_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_VerifyCertForSignedExchange_ForwardToCallback(
      NetworkContext::VerifyCertForSignedExchangeCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkContext_VerifyCertForSignedExchange_ForwardToCallback(const NetworkContext_VerifyCertForSignedExchange_ForwardToCallback&) = delete;
  NetworkContext_VerifyCertForSignedExchange_ForwardToCallback& operator=(const NetworkContext_VerifyCertForSignedExchange_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::VerifyCertForSignedExchangeCallback callback_;
};

class NetworkContext_Verify2QwacCertBinding_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_Verify2QwacCertBinding_ForwardToCallback(
      NetworkContext::Verify2QwacCertBindingCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkContext_Verify2QwacCertBinding_ForwardToCallback(const NetworkContext_Verify2QwacCertBinding_ForwardToCallback&) = delete;
  NetworkContext_Verify2QwacCertBinding_ForwardToCallback& operator=(const NetworkContext_Verify2QwacCertBinding_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::Verify2QwacCertBindingCallback callback_;
};

class NetworkContext_AddHSTS_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_AddHSTS_ForwardToCallback(
      NetworkContext::AddHSTSCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkContext_AddHSTS_ForwardToCallback(const NetworkContext_AddHSTS_ForwardToCallback&) = delete;
  NetworkContext_AddHSTS_ForwardToCallback& operator=(const NetworkContext_AddHSTS_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::AddHSTSCallback callback_;
};

class NetworkContext_IsHSTSActiveForHost_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_IsHSTSActiveForHost_ForwardToCallback(
      NetworkContext::IsHSTSActiveForHostCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkContext_IsHSTSActiveForHost_ForwardToCallback(const NetworkContext_IsHSTSActiveForHost_ForwardToCallback&) = delete;
  NetworkContext_IsHSTSActiveForHost_ForwardToCallback& operator=(const NetworkContext_IsHSTSActiveForHost_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::IsHSTSActiveForHostCallback callback_;
};

class NetworkContext_GetHSTSState_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_GetHSTSState_ForwardToCallback(
      NetworkContext::GetHSTSStateCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkContext_GetHSTSState_ForwardToCallback(const NetworkContext_GetHSTSState_ForwardToCallback&) = delete;
  NetworkContext_GetHSTSState_ForwardToCallback& operator=(const NetworkContext_GetHSTSState_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::GetHSTSStateCallback callback_;
};

class NetworkContext_SetCorsOriginAccessListsForOrigin_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_SetCorsOriginAccessListsForOrigin_ForwardToCallback(
      NetworkContext::SetCorsOriginAccessListsForOriginCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkContext_SetCorsOriginAccessListsForOrigin_ForwardToCallback(const NetworkContext_SetCorsOriginAccessListsForOrigin_ForwardToCallback&) = delete;
  NetworkContext_SetCorsOriginAccessListsForOrigin_ForwardToCallback& operator=(const NetworkContext_SetCorsOriginAccessListsForOrigin_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::SetCorsOriginAccessListsForOriginCallback callback_;
};

class NetworkContext_DeleteDynamicDataForHost_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_DeleteDynamicDataForHost_ForwardToCallback(
      NetworkContext::DeleteDynamicDataForHostCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkContext_DeleteDynamicDataForHost_ForwardToCallback(const NetworkContext_DeleteDynamicDataForHost_ForwardToCallback&) = delete;
  NetworkContext_DeleteDynamicDataForHost_ForwardToCallback& operator=(const NetworkContext_DeleteDynamicDataForHost_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::DeleteDynamicDataForHostCallback callback_;
};

class NetworkContext_SaveHttpAuthCacheProxyEntries_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_SaveHttpAuthCacheProxyEntries_ForwardToCallback(
      NetworkContext::SaveHttpAuthCacheProxyEntriesCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkContext_SaveHttpAuthCacheProxyEntries_ForwardToCallback(const NetworkContext_SaveHttpAuthCacheProxyEntries_ForwardToCallback&) = delete;
  NetworkContext_SaveHttpAuthCacheProxyEntries_ForwardToCallback& operator=(const NetworkContext_SaveHttpAuthCacheProxyEntries_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::SaveHttpAuthCacheProxyEntriesCallback callback_;
};

class NetworkContext_LoadHttpAuthCacheProxyEntries_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_LoadHttpAuthCacheProxyEntries_ForwardToCallback(
      NetworkContext::LoadHttpAuthCacheProxyEntriesCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkContext_LoadHttpAuthCacheProxyEntries_ForwardToCallback(const NetworkContext_LoadHttpAuthCacheProxyEntries_ForwardToCallback&) = delete;
  NetworkContext_LoadHttpAuthCacheProxyEntries_ForwardToCallback& operator=(const NetworkContext_LoadHttpAuthCacheProxyEntries_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::LoadHttpAuthCacheProxyEntriesCallback callback_;
};

class NetworkContext_AddAuthCacheEntry_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_AddAuthCacheEntry_ForwardToCallback(
      NetworkContext::AddAuthCacheEntryCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkContext_AddAuthCacheEntry_ForwardToCallback(const NetworkContext_AddAuthCacheEntry_ForwardToCallback&) = delete;
  NetworkContext_AddAuthCacheEntry_ForwardToCallback& operator=(const NetworkContext_AddAuthCacheEntry_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::AddAuthCacheEntryCallback callback_;
};

class NetworkContext_LookupServerBasicAuthCredentials_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_LookupServerBasicAuthCredentials_ForwardToCallback(
      NetworkContext::LookupServerBasicAuthCredentialsCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkContext_LookupServerBasicAuthCredentials_ForwardToCallback(const NetworkContext_LookupServerBasicAuthCredentials_ForwardToCallback&) = delete;
  NetworkContext_LookupServerBasicAuthCredentials_ForwardToCallback& operator=(const NetworkContext_LookupServerBasicAuthCredentials_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::LookupServerBasicAuthCredentialsCallback callback_;
};
class NetworkContext_EnableStaticKeyPinningForTesting_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  NetworkContext_EnableStaticKeyPinningForTesting_HandleSyncResponse(
      bool* result)
      : result_(result) {
    DCHECK(!*result_);
  }

  NetworkContext_EnableStaticKeyPinningForTesting_HandleSyncResponse(const NetworkContext_EnableStaticKeyPinningForTesting_HandleSyncResponse&) = delete;
  NetworkContext_EnableStaticKeyPinningForTesting_HandleSyncResponse& operator=(const NetworkContext_EnableStaticKeyPinningForTesting_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;};

class NetworkContext_EnableStaticKeyPinningForTesting_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_EnableStaticKeyPinningForTesting_ForwardToCallback(
      NetworkContext::EnableStaticKeyPinningForTestingCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkContext_EnableStaticKeyPinningForTesting_ForwardToCallback(const NetworkContext_EnableStaticKeyPinningForTesting_ForwardToCallback&) = delete;
  NetworkContext_EnableStaticKeyPinningForTesting_ForwardToCallback& operator=(const NetworkContext_EnableStaticKeyPinningForTesting_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::EnableStaticKeyPinningForTestingCallback callback_;
};

class NetworkContext_VerifyCertificateForTesting_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_VerifyCertificateForTesting_ForwardToCallback(
      NetworkContext::VerifyCertificateForTestingCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkContext_VerifyCertificateForTesting_ForwardToCallback(const NetworkContext_VerifyCertificateForTesting_ForwardToCallback&) = delete;
  NetworkContext_VerifyCertificateForTesting_ForwardToCallback& operator=(const NetworkContext_VerifyCertificateForTesting_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::VerifyCertificateForTestingCallback callback_;
};
class NetworkContext_GetTrustAnchorIDsForTesting_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  NetworkContext_GetTrustAnchorIDsForTesting_HandleSyncResponse(
      bool* result, std::vector<std::vector<uint8_t>>* out_trust_anchor_ids)
      : result_(result), out_trust_anchor_ids_(out_trust_anchor_ids) {
    DCHECK(!*result_);
  }

  NetworkContext_GetTrustAnchorIDsForTesting_HandleSyncResponse(const NetworkContext_GetTrustAnchorIDsForTesting_HandleSyncResponse&) = delete;
  NetworkContext_GetTrustAnchorIDsForTesting_HandleSyncResponse& operator=(const NetworkContext_GetTrustAnchorIDsForTesting_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  std::vector<std::vector<uint8_t>>* out_trust_anchor_ids_;};

class NetworkContext_GetTrustAnchorIDsForTesting_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_GetTrustAnchorIDsForTesting_ForwardToCallback(
      NetworkContext::GetTrustAnchorIDsForTestingCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkContext_GetTrustAnchorIDsForTesting_ForwardToCallback(const NetworkContext_GetTrustAnchorIDsForTesting_ForwardToCallback&) = delete;
  NetworkContext_GetTrustAnchorIDsForTesting_ForwardToCallback& operator=(const NetworkContext_GetTrustAnchorIDsForTesting_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::GetTrustAnchorIDsForTestingCallback callback_;
};
class NetworkContext_AddDomainReliabilityContextForTesting_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  NetworkContext_AddDomainReliabilityContextForTesting_HandleSyncResponse(
      bool* result)
      : result_(result) {
    DCHECK(!*result_);
  }

  NetworkContext_AddDomainReliabilityContextForTesting_HandleSyncResponse(const NetworkContext_AddDomainReliabilityContextForTesting_HandleSyncResponse&) = delete;
  NetworkContext_AddDomainReliabilityContextForTesting_HandleSyncResponse& operator=(const NetworkContext_AddDomainReliabilityContextForTesting_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;};

class NetworkContext_AddDomainReliabilityContextForTesting_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_AddDomainReliabilityContextForTesting_ForwardToCallback(
      NetworkContext::AddDomainReliabilityContextForTestingCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkContext_AddDomainReliabilityContextForTesting_ForwardToCallback(const NetworkContext_AddDomainReliabilityContextForTesting_ForwardToCallback&) = delete;
  NetworkContext_AddDomainReliabilityContextForTesting_ForwardToCallback& operator=(const NetworkContext_AddDomainReliabilityContextForTesting_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::AddDomainReliabilityContextForTestingCallback callback_;
};
class NetworkContext_ForceDomainReliabilityUploadsForTesting_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  NetworkContext_ForceDomainReliabilityUploadsForTesting_HandleSyncResponse(
      bool* result)
      : result_(result) {
    DCHECK(!*result_);
  }

  NetworkContext_ForceDomainReliabilityUploadsForTesting_HandleSyncResponse(const NetworkContext_ForceDomainReliabilityUploadsForTesting_HandleSyncResponse&) = delete;
  NetworkContext_ForceDomainReliabilityUploadsForTesting_HandleSyncResponse& operator=(const NetworkContext_ForceDomainReliabilityUploadsForTesting_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;};

class NetworkContext_ForceDomainReliabilityUploadsForTesting_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_ForceDomainReliabilityUploadsForTesting_ForwardToCallback(
      NetworkContext::ForceDomainReliabilityUploadsForTestingCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkContext_ForceDomainReliabilityUploadsForTesting_ForwardToCallback(const NetworkContext_ForceDomainReliabilityUploadsForTesting_ForwardToCallback&) = delete;
  NetworkContext_ForceDomainReliabilityUploadsForTesting_ForwardToCallback& operator=(const NetworkContext_ForceDomainReliabilityUploadsForTesting_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::ForceDomainReliabilityUploadsForTestingCallback callback_;
};

class NetworkContext_GetSharedDictionaryUsageInfo_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_GetSharedDictionaryUsageInfo_ForwardToCallback(
      NetworkContext::GetSharedDictionaryUsageInfoCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkContext_GetSharedDictionaryUsageInfo_ForwardToCallback(const NetworkContext_GetSharedDictionaryUsageInfo_ForwardToCallback&) = delete;
  NetworkContext_GetSharedDictionaryUsageInfo_ForwardToCallback& operator=(const NetworkContext_GetSharedDictionaryUsageInfo_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::GetSharedDictionaryUsageInfoCallback callback_;
};

class NetworkContext_GetSharedDictionaryInfo_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_GetSharedDictionaryInfo_ForwardToCallback(
      NetworkContext::GetSharedDictionaryInfoCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkContext_GetSharedDictionaryInfo_ForwardToCallback(const NetworkContext_GetSharedDictionaryInfo_ForwardToCallback&) = delete;
  NetworkContext_GetSharedDictionaryInfo_ForwardToCallback& operator=(const NetworkContext_GetSharedDictionaryInfo_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::GetSharedDictionaryInfoCallback callback_;
};

class NetworkContext_GetSharedDictionaryOriginsBetween_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_GetSharedDictionaryOriginsBetween_ForwardToCallback(
      NetworkContext::GetSharedDictionaryOriginsBetweenCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkContext_GetSharedDictionaryOriginsBetween_ForwardToCallback(const NetworkContext_GetSharedDictionaryOriginsBetween_ForwardToCallback&) = delete;
  NetworkContext_GetSharedDictionaryOriginsBetween_ForwardToCallback& operator=(const NetworkContext_GetSharedDictionaryOriginsBetween_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::GetSharedDictionaryOriginsBetweenCallback callback_;
};

class NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_ForwardToCallback(
      NetworkContext::HasPreloadedSharedDictionaryInfoForTestingCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_ForwardToCallback(const NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_ForwardToCallback&) = delete;
  NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_ForwardToCallback& operator=(const NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::HasPreloadedSharedDictionaryInfoForTestingCallback callback_;
};

class NetworkContext_RevokeNetworkForNonces_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_RevokeNetworkForNonces_ForwardToCallback(
      NetworkContext::RevokeNetworkForNoncesCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkContext_RevokeNetworkForNonces_ForwardToCallback(const NetworkContext_RevokeNetworkForNonces_ForwardToCallback&) = delete;
  NetworkContext_RevokeNetworkForNonces_ForwardToCallback& operator=(const NetworkContext_RevokeNetworkForNonces_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::RevokeNetworkForNoncesCallback callback_;
};

class NetworkContext_ExemptUrlFromNetworkRevocationForNonce_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_ExemptUrlFromNetworkRevocationForNonce_ForwardToCallback(
      NetworkContext::ExemptUrlFromNetworkRevocationForNonceCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkContext_ExemptUrlFromNetworkRevocationForNonce_ForwardToCallback(const NetworkContext_ExemptUrlFromNetworkRevocationForNonce_ForwardToCallback&) = delete;
  NetworkContext_ExemptUrlFromNetworkRevocationForNonce_ForwardToCallback& operator=(const NetworkContext_ExemptUrlFromNetworkRevocationForNonce_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::ExemptUrlFromNetworkRevocationForNonceCallback callback_;
};

class NetworkContext_GetBoundNetworkForTesting_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_GetBoundNetworkForTesting_ForwardToCallback(
      NetworkContext::GetBoundNetworkForTestingCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkContext_GetBoundNetworkForTesting_ForwardToCallback(const NetworkContext_GetBoundNetworkForTesting_ForwardToCallback&) = delete;
  NetworkContext_GetBoundNetworkForTesting_ForwardToCallback& operator=(const NetworkContext_GetBoundNetworkForTesting_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::GetBoundNetworkForTestingCallback callback_;
};

NetworkContextProxy::NetworkContextProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void NetworkContextProxy::SetClient(
    ::mojo::PendingRemote<::network::mojom::NetworkContextClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkContext::SetClient", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<::network::mojom::NetworkContextClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kSetClient), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_SetClient_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::NetworkContextClientInterfaceBase>>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid client in NetworkContext.SetClient request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("SetClient");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NetworkContextProxy::CreateURLLoaderFactory(
    ::mojo::PendingReceiver<::network::mojom::URLLoaderFactory> in_url_loader_factory, URLLoaderFactoryParamsPtr in_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkContext::CreateURLLoaderFactory", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url_loader_factory"), in_url_loader_factory,
                        "<value of type ::mojo::PendingReceiver<::network::mojom::URLLoaderFactory>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type URLLoaderFactoryParamsPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kCreateURLLoaderFactory), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_CreateURLLoaderFactory_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::URLLoaderFactoryInterfaceBase>>(
    in_url_loader_factory,
    &params->url_loader_factory,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->url_loader_factory)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid url_loader_factory in NetworkContext.CreateURLLoaderFactory request");
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::URLLoaderFactoryParamsDataView>(
    in_params,
    params_fragment);

  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null params in NetworkContext.CreateURLLoaderFactory request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("CreateURLLoaderFactory");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NetworkContextProxy::ResetURLLoaderFactories(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send network::mojom::NetworkContext::ResetURLLoaderFactories");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kResetURLLoaderFactories), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_ResetURLLoaderFactories_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("ResetURLLoaderFactories");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NetworkContextProxy::GetViaObliviousHttp(
    ::network::mojom::ObliviousHttpRequestPtr in_request, ::mojo::PendingRemote<::network::mojom::ObliviousHttpClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkContext::GetViaObliviousHttp", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request"), in_request,
                        "<value of type ::network::mojom::ObliviousHttpRequestPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<::network::mojom::ObliviousHttpClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kGetViaObliviousHttp), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_GetViaObliviousHttp_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->request)::BaseType> request_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::ObliviousHttpRequestDataView>(
    in_request,
    request_fragment);

  params->request.Set(
      request_fragment.is_null() ? nullptr : request_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->request.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null request in NetworkContext.GetViaObliviousHttp request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::ObliviousHttpClientInterfaceBase>>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid client in NetworkContext.GetViaObliviousHttp request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("GetViaObliviousHttp");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NetworkContextProxy::GetCookieManager(
    ::mojo::PendingReceiver<::network::mojom::CookieManager> in_cookie_manager) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkContext::GetCookieManager", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cookie_manager"), in_cookie_manager,
                        "<value of type ::mojo::PendingReceiver<::network::mojom::CookieManager>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kGetCookieManager), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_GetCookieManager_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::CookieManagerInterfaceBase>>(
    in_cookie_manager,
    &params->cookie_manager,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->cookie_manager)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid cookie_manager in NetworkContext.GetCookieManager request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("GetCookieManager");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NetworkContextProxy::GetRestrictedCookieManager(
    ::mojo::PendingReceiver<::network::mojom::RestrictedCookieManager> in_restricted_cookie_manager, ::network::mojom::RestrictedCookieManagerRole in_role, const ::url::Origin& in_origin, const ::net::IsolationInfo& in_isolation_info, const ::net::CookieSettingOverrides& in_cookie_setting_overrides, const ::net::CookieSettingOverrides& in_devtools_cookie_setting_overrides, ::mojo::PendingRemote<::network::mojom::CookieAccessObserver> in_cookie_observer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkContext::GetRestrictedCookieManager", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("restricted_cookie_manager"), in_restricted_cookie_manager,
                        "<value of type ::mojo::PendingReceiver<::network::mojom::RestrictedCookieManager>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("role"), in_role,
                        "<value of type ::network::mojom::RestrictedCookieManagerRole>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("origin"), in_origin,
                        "<value of type const ::url::Origin&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("isolation_info"), in_isolation_info,
                        "<value of type const ::net::IsolationInfo&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cookie_setting_overrides"), in_cookie_setting_overrides,
                        "<value of type const ::net::CookieSettingOverrides&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("devtools_cookie_setting_overrides"), in_devtools_cookie_setting_overrides,
                        "<value of type const ::net::CookieSettingOverrides&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cookie_observer"), in_cookie_observer,
                        "<value of type ::mojo::PendingRemote<::network::mojom::CookieAccessObserver>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kGetRestrictedCookieManager), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_GetRestrictedCookieManager_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::RestrictedCookieManagerInterfaceBase>>(
    in_restricted_cookie_manager,
    &params->restricted_cookie_manager,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->restricted_cookie_manager)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid restricted_cookie_manager in NetworkContext.GetRestrictedCookieManager request");

  
  mojo::internal::Serialize<::network::mojom::RestrictedCookieManagerRole>(
    in_role,
    &params->role);
  mojo::internal::MessageFragment<
      typename decltype(params->origin)::BaseType> origin_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
    in_origin,
    origin_fragment);

  params->origin.Set(
      origin_fragment.is_null() ? nullptr : origin_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->origin.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null origin in NetworkContext.GetRestrictedCookieManager request");
  mojo::internal::MessageFragment<
      typename decltype(params->isolation_info)::BaseType> isolation_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::IsolationInfoDataView>(
    in_isolation_info,
    isolation_info_fragment);

  params->isolation_info.Set(
      isolation_info_fragment.is_null() ? nullptr : isolation_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->isolation_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null isolation_info in NetworkContext.GetRestrictedCookieManager request");
  mojo::internal::MessageFragment<
      typename decltype(params->cookie_setting_overrides)::BaseType> cookie_setting_overrides_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::CookieSettingOverridesDataView>(
    in_cookie_setting_overrides,
    cookie_setting_overrides_fragment);

  params->cookie_setting_overrides.Set(
      cookie_setting_overrides_fragment.is_null() ? nullptr : cookie_setting_overrides_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->cookie_setting_overrides.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null cookie_setting_overrides in NetworkContext.GetRestrictedCookieManager request");
  mojo::internal::MessageFragment<
      typename decltype(params->devtools_cookie_setting_overrides)::BaseType> devtools_cookie_setting_overrides_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::CookieSettingOverridesDataView>(
    in_devtools_cookie_setting_overrides,
    devtools_cookie_setting_overrides_fragment);

  params->devtools_cookie_setting_overrides.Set(
      devtools_cookie_setting_overrides_fragment.is_null() ? nullptr : devtools_cookie_setting_overrides_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->devtools_cookie_setting_overrides.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null devtools_cookie_setting_overrides in NetworkContext.GetRestrictedCookieManager request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::CookieAccessObserverInterfaceBase>>(
    in_cookie_observer,
    &params->cookie_observer,
    &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("GetRestrictedCookieManager");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NetworkContextProxy::GetTrustTokenQueryAnswerer(
    ::mojo::PendingReceiver<::network::mojom::TrustTokenQueryAnswerer> in_trust_token_query_answerer, const ::url::Origin& in_top_frame_origin) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkContext::GetTrustTokenQueryAnswerer", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("trust_token_query_answerer"), in_trust_token_query_answerer,
                        "<value of type ::mojo::PendingReceiver<::network::mojom::TrustTokenQueryAnswerer>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("top_frame_origin"), in_top_frame_origin,
                        "<value of type const ::url::Origin&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kGetTrustTokenQueryAnswerer), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_GetTrustTokenQueryAnswerer_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::TrustTokenQueryAnswererInterfaceBase>>(
    in_trust_token_query_answerer,
    &params->trust_token_query_answerer,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->trust_token_query_answerer)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid trust_token_query_answerer in NetworkContext.GetTrustTokenQueryAnswerer request");
  mojo::internal::MessageFragment<
      typename decltype(params->top_frame_origin)::BaseType> top_frame_origin_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
    in_top_frame_origin,
    top_frame_origin_fragment);

  params->top_frame_origin.Set(
      top_frame_origin_fragment.is_null() ? nullptr : top_frame_origin_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->top_frame_origin.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null top_frame_origin in NetworkContext.GetTrustTokenQueryAnswerer request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("GetTrustTokenQueryAnswerer");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NetworkContextProxy::ClearTrustTokenData(
    ::network::mojom::ClearDataFilterPtr in_filter, ClearTrustTokenDataCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkContext::ClearTrustTokenData", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("filter"), in_filter,
                        "<value of type ::network::mojom::ClearDataFilterPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kClearTrustTokenData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_ClearTrustTokenData_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->filter)::BaseType> filter_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::ClearDataFilterDataView>(
    in_filter,
    filter_fragment);

  params->filter.Set(
      filter_fragment.is_null() ? nullptr : filter_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("ClearTrustTokenData");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_ClearTrustTokenData_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void NetworkContextProxy::ClearTrustTokenSessionOnlyData(
    ClearTrustTokenSessionOnlyDataCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send network::mojom::NetworkContext::ClearTrustTokenSessionOnlyData");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kClearTrustTokenSessionOnlyData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_ClearTrustTokenSessionOnlyData_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("ClearTrustTokenSessionOnlyData");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_ClearTrustTokenSessionOnlyData_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void NetworkContextProxy::GetStoredTrustTokenCounts(
    GetStoredTrustTokenCountsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send network::mojom::NetworkContext::GetStoredTrustTokenCounts");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kGetStoredTrustTokenCounts), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_GetStoredTrustTokenCounts_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("GetStoredTrustTokenCounts");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_GetStoredTrustTokenCounts_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void NetworkContextProxy::GetPrivateStateTokenRedemptionRecords(
    GetPrivateStateTokenRedemptionRecordsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send network::mojom::NetworkContext::GetPrivateStateTokenRedemptionRecords");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kGetPrivateStateTokenRedemptionRecords), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_GetPrivateStateTokenRedemptionRecords_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("GetPrivateStateTokenRedemptionRecords");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_GetPrivateStateTokenRedemptionRecords_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void NetworkContextProxy::DeleteStoredTrustTokens(
    const ::url::Origin& in_issuer, DeleteStoredTrustTokensCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkContext::DeleteStoredTrustTokens", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("issuer"), in_issuer,
                        "<value of type const ::url::Origin&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kDeleteStoredTrustTokens), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_DeleteStoredTrustTokens_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->issuer)::BaseType> issuer_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
    in_issuer,
    issuer_fragment);

  params->issuer.Set(
      issuer_fragment.is_null() ? nullptr : issuer_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->issuer.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null issuer in NetworkContext.DeleteStoredTrustTokens request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("DeleteStoredTrustTokens");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_DeleteStoredTrustTokens_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void NetworkContextProxy::SetBlockTrustTokens(
    bool in_block) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkContext::SetBlockTrustTokens", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("block"), in_block,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kSetBlockTrustTokens), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_SetBlockTrustTokens_Params_Data> params(
          message);
  params.Allocate();

  params->block = in_block;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("SetBlockTrustTokens");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NetworkContextProxy::SetTrackingProtectionContentSetting(
    const std::vector<::ContentSettingPatternSource>& in_settings) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkContext::SetTrackingProtectionContentSetting", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("settings"), in_settings,
                        "<value of type const std::vector<::ContentSettingPatternSource>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kSetTrackingProtectionContentSetting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_SetTrackingProtectionContentSetting_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->settings)::BaseType>
      settings_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& settings_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::content_settings::mojom::ContentSettingPatternSourceDataView>>(
    in_settings,
    settings_fragment,
    &settings_validate_params);

  params->settings.Set(
      settings_fragment.is_null() ? nullptr : settings_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->settings.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null settings in NetworkContext.SetTrackingProtectionContentSetting request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("SetTrackingProtectionContentSetting");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NetworkContextProxy::ClearNetworkingHistoryBetween(
    ::base::Time in_start_time, ::base::Time in_end_time, ClearNetworkingHistoryBetweenCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkContext::ClearNetworkingHistoryBetween", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("start_time"), in_start_time,
                        "<value of type ::base::Time>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("end_time"), in_end_time,
                        "<value of type ::base::Time>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kClearNetworkingHistoryBetween), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_ClearNetworkingHistoryBetween_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->start_time)::BaseType> start_time_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
    in_start_time,
    start_time_fragment);

  params->start_time.Set(
      start_time_fragment.is_null() ? nullptr : start_time_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->start_time.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null start_time in NetworkContext.ClearNetworkingHistoryBetween request");
  mojo::internal::MessageFragment<
      typename decltype(params->end_time)::BaseType> end_time_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
    in_end_time,
    end_time_fragment);

  params->end_time.Set(
      end_time_fragment.is_null() ? nullptr : end_time_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->end_time.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null end_time in NetworkContext.ClearNetworkingHistoryBetween request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("ClearNetworkingHistoryBetween");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_ClearNetworkingHistoryBetween_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void NetworkContextProxy::ClearHttpCache(
    ::base::Time in_start_time, ::base::Time in_end_time, ::network::mojom::ClearDataFilterPtr in_filter, ClearHttpCacheCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkContext::ClearHttpCache", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("start_time"), in_start_time,
                        "<value of type ::base::Time>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("end_time"), in_end_time,
                        "<value of type ::base::Time>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("filter"), in_filter,
                        "<value of type ::network::mojom::ClearDataFilterPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kClearHttpCache), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_ClearHttpCache_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->start_time)::BaseType> start_time_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
    in_start_time,
    start_time_fragment);

  params->start_time.Set(
      start_time_fragment.is_null() ? nullptr : start_time_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->start_time.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null start_time in NetworkContext.ClearHttpCache request");
  mojo::internal::MessageFragment<
      typename decltype(params->end_time)::BaseType> end_time_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
    in_end_time,
    end_time_fragment);

  params->end_time.Set(
      end_time_fragment.is_null() ? nullptr : end_time_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->end_time.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null end_time in NetworkContext.ClearHttpCache request");
  mojo::internal::MessageFragment<
      typename decltype(params->filter)::BaseType> filter_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::ClearDataFilterDataView>(
    in_filter,
    filter_fragment);

  params->filter.Set(
      filter_fragment.is_null() ? nullptr : filter_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("ClearHttpCache");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_ClearHttpCache_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void NetworkContextProxy::ComputeHttpCacheSize(
    ::base::Time in_start_time, ::base::Time in_end_time, ComputeHttpCacheSizeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkContext::ComputeHttpCacheSize", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("start_time"), in_start_time,
                        "<value of type ::base::Time>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("end_time"), in_end_time,
                        "<value of type ::base::Time>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kComputeHttpCacheSize), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_ComputeHttpCacheSize_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->start_time)::BaseType> start_time_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
    in_start_time,
    start_time_fragment);

  params->start_time.Set(
      start_time_fragment.is_null() ? nullptr : start_time_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->start_time.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null start_time in NetworkContext.ComputeHttpCacheSize request");
  mojo::internal::MessageFragment<
      typename decltype(params->end_time)::BaseType> end_time_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
    in_end_time,
    end_time_fragment);

  params->end_time.Set(
      end_time_fragment.is_null() ? nullptr : end_time_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->end_time.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null end_time in NetworkContext.ComputeHttpCacheSize request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("ComputeHttpCacheSize");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_ComputeHttpCacheSize_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void NetworkContextProxy::NotifyExternalCacheHit(
    const ::GURL& in_url, const std::string& in_http_method, const ::net::NetworkIsolationKey& in_key, bool in_include_credentials) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkContext::NotifyExternalCacheHit", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("http_method"), in_http_method,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key"), in_key,
                        "<value of type const ::net::NetworkIsolationKey&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("include_credentials"), in_include_credentials,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kNotifyExternalCacheHit), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_NotifyExternalCacheHit_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in NetworkContext.NotifyExternalCacheHit request");
  mojo::internal::MessageFragment<
      typename decltype(params->http_method)::BaseType> http_method_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_http_method,
    http_method_fragment);

  params->http_method.Set(
      http_method_fragment.is_null() ? nullptr : http_method_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->http_method.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null http_method in NetworkContext.NotifyExternalCacheHit request");
  mojo::internal::MessageFragment<decltype(params->key)>
      key_fragment(params.message());
  key_fragment.Claim(&params->key);
  
  mojo::internal::Serialize<::network::mojom::NetworkIsolationKeyDataView>(
    in_key,
    key_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->key.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null key in NetworkContext.NotifyExternalCacheHit request");

  params->include_credentials = in_include_credentials;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("NotifyExternalCacheHit");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NetworkContextProxy::ClearHostCache(
    ::network::mojom::ClearDataFilterPtr in_filter, ClearHostCacheCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkContext::ClearHostCache", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("filter"), in_filter,
                        "<value of type ::network::mojom::ClearDataFilterPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kClearHostCache), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_ClearHostCache_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->filter)::BaseType> filter_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::ClearDataFilterDataView>(
    in_filter,
    filter_fragment);

  params->filter.Set(
      filter_fragment.is_null() ? nullptr : filter_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("ClearHostCache");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_ClearHostCache_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void NetworkContextProxy::ClearHttpAuthCache(
    ::base::Time in_start_time, ::base::Time in_end_time, ::network::mojom::ClearDataFilterPtr in_filter, ClearHttpAuthCacheCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkContext::ClearHttpAuthCache", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("start_time"), in_start_time,
                        "<value of type ::base::Time>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("end_time"), in_end_time,
                        "<value of type ::base::Time>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("filter"), in_filter,
                        "<value of type ::network::mojom::ClearDataFilterPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kClearHttpAuthCache), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_ClearHttpAuthCache_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->start_time)::BaseType> start_time_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
    in_start_time,
    start_time_fragment);

  params->start_time.Set(
      start_time_fragment.is_null() ? nullptr : start_time_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->start_time.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null start_time in NetworkContext.ClearHttpAuthCache request");
  mojo::internal::MessageFragment<
      typename decltype(params->end_time)::BaseType> end_time_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
    in_end_time,
    end_time_fragment);

  params->end_time.Set(
      end_time_fragment.is_null() ? nullptr : end_time_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->end_time.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null end_time in NetworkContext.ClearHttpAuthCache request");
  mojo::internal::MessageFragment<
      typename decltype(params->filter)::BaseType> filter_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::ClearDataFilterDataView>(
    in_filter,
    filter_fragment);

  params->filter.Set(
      filter_fragment.is_null() ? nullptr : filter_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("ClearHttpAuthCache");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_ClearHttpAuthCache_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void NetworkContextProxy::ClearCorsPreflightCache(
    ::network::mojom::ClearDataFilterPtr in_filter, ClearCorsPreflightCacheCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkContext::ClearCorsPreflightCache", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("filter"), in_filter,
                        "<value of type ::network::mojom::ClearDataFilterPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kClearCorsPreflightCache), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_ClearCorsPreflightCache_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->filter)::BaseType> filter_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::ClearDataFilterDataView>(
    in_filter,
    filter_fragment);

  params->filter.Set(
      filter_fragment.is_null() ? nullptr : filter_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("ClearCorsPreflightCache");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_ClearCorsPreflightCache_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void NetworkContextProxy::ClearReportingCacheReports(
    ::network::mojom::ClearDataFilterPtr in_filter, ClearReportingCacheReportsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkContext::ClearReportingCacheReports", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("filter"), in_filter,
                        "<value of type ::network::mojom::ClearDataFilterPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kClearReportingCacheReports), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_ClearReportingCacheReports_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->filter)::BaseType> filter_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::ClearDataFilterDataView>(
    in_filter,
    filter_fragment);

  params->filter.Set(
      filter_fragment.is_null() ? nullptr : filter_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("ClearReportingCacheReports");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_ClearReportingCacheReports_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void NetworkContextProxy::ClearReportingCacheClients(
    ::network::mojom::ClearDataFilterPtr in_filter, ClearReportingCacheClientsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkContext::ClearReportingCacheClients", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("filter"), in_filter,
                        "<value of type ::network::mojom::ClearDataFilterPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kClearReportingCacheClients), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_ClearReportingCacheClients_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->filter)::BaseType> filter_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::ClearDataFilterDataView>(
    in_filter,
    filter_fragment);

  params->filter.Set(
      filter_fragment.is_null() ? nullptr : filter_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("ClearReportingCacheClients");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_ClearReportingCacheClients_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void NetworkContextProxy::ClearNetworkErrorLogging(
    ::network::mojom::ClearDataFilterPtr in_filter, ClearNetworkErrorLoggingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkContext::ClearNetworkErrorLogging", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("filter"), in_filter,
                        "<value of type ::network::mojom::ClearDataFilterPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kClearNetworkErrorLogging), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_ClearNetworkErrorLogging_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->filter)::BaseType> filter_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::ClearDataFilterDataView>(
    in_filter,
    filter_fragment);

  params->filter.Set(
      filter_fragment.is_null() ? nullptr : filter_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("ClearNetworkErrorLogging");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_ClearNetworkErrorLogging_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void NetworkContextProxy::ClearDomainReliability(
    ::network::mojom::ClearDataFilterPtr in_filter, NetworkContext::DomainReliabilityClearMode in_mode, ClearDomainReliabilityCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkContext::ClearDomainReliability", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("filter"), in_filter,
                        "<value of type ::network::mojom::ClearDataFilterPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("mode"), in_mode,
                        "<value of type NetworkContext::DomainReliabilityClearMode>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kClearDomainReliability), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_ClearDomainReliability_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->filter)::BaseType> filter_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::ClearDataFilterDataView>(
    in_filter,
    filter_fragment);

  params->filter.Set(
      filter_fragment.is_null() ? nullptr : filter_fragment.data());

  
  mojo::internal::Serialize<::network::mojom::NetworkContext_DomainReliabilityClearMode>(
    in_mode,
    &params->mode);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("ClearDomainReliability");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_ClearDomainReliability_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void NetworkContextProxy::ClearSharedDictionaryCache(
    ::base::Time in_start_time, ::base::Time in_end_time, ::network::mojom::ClearDataFilterPtr in_filter, ClearSharedDictionaryCacheCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkContext::ClearSharedDictionaryCache", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("start_time"), in_start_time,
                        "<value of type ::base::Time>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("end_time"), in_end_time,
                        "<value of type ::base::Time>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("filter"), in_filter,
                        "<value of type ::network::mojom::ClearDataFilterPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kClearSharedDictionaryCache), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_ClearSharedDictionaryCache_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->start_time)::BaseType> start_time_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
    in_start_time,
    start_time_fragment);

  params->start_time.Set(
      start_time_fragment.is_null() ? nullptr : start_time_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->start_time.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null start_time in NetworkContext.ClearSharedDictionaryCache request");
  mojo::internal::MessageFragment<
      typename decltype(params->end_time)::BaseType> end_time_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
    in_end_time,
    end_time_fragment);

  params->end_time.Set(
      end_time_fragment.is_null() ? nullptr : end_time_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->end_time.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null end_time in NetworkContext.ClearSharedDictionaryCache request");
  mojo::internal::MessageFragment<
      typename decltype(params->filter)::BaseType> filter_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::ClearDataFilterDataView>(
    in_filter,
    filter_fragment);

  params->filter.Set(
      filter_fragment.is_null() ? nullptr : filter_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("ClearSharedDictionaryCache");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_ClearSharedDictionaryCache_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void NetworkContextProxy::ClearSharedDictionaryCacheForIsolationKey(
    const ::net::SharedDictionaryIsolationKey& in_isolation_key, ClearSharedDictionaryCacheForIsolationKeyCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkContext::ClearSharedDictionaryCacheForIsolationKey", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("isolation_key"), in_isolation_key,
                        "<value of type const ::net::SharedDictionaryIsolationKey&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kClearSharedDictionaryCacheForIsolationKey), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_ClearSharedDictionaryCacheForIsolationKey_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->isolation_key)::BaseType> isolation_key_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::SharedDictionaryIsolationKeyDataView>(
    in_isolation_key,
    isolation_key_fragment);

  params->isolation_key.Set(
      isolation_key_fragment.is_null() ? nullptr : isolation_key_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->isolation_key.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null isolation_key in NetworkContext.ClearSharedDictionaryCacheForIsolationKey request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("ClearSharedDictionaryCacheForIsolationKey");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_ClearSharedDictionaryCacheForIsolationKey_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void NetworkContextProxy::SetDocumentReportingEndpoints(
    const ::base::UnguessableToken& in_reporting_source, const ::url::Origin& in_origin, const ::net::IsolationInfo& in_isolation_info, const base::flat_map<std::string, std::string>& in_endpoints) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkContext::SetDocumentReportingEndpoints", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reporting_source"), in_reporting_source,
                        "<value of type const ::base::UnguessableToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("origin"), in_origin,
                        "<value of type const ::url::Origin&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("isolation_info"), in_isolation_info,
                        "<value of type const ::net::IsolationInfo&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("endpoints"), in_endpoints,
                        "<value of type const base::flat_map<std::string, std::string>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kSetDocumentReportingEndpoints), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_SetDocumentReportingEndpoints_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->reporting_source)::BaseType> reporting_source_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_reporting_source,
    reporting_source_fragment);

  params->reporting_source.Set(
      reporting_source_fragment.is_null() ? nullptr : reporting_source_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->reporting_source.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null reporting_source in NetworkContext.SetDocumentReportingEndpoints request");
  mojo::internal::MessageFragment<
      typename decltype(params->origin)::BaseType> origin_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
    in_origin,
    origin_fragment);

  params->origin.Set(
      origin_fragment.is_null() ? nullptr : origin_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->origin.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null origin in NetworkContext.SetDocumentReportingEndpoints request");
  mojo::internal::MessageFragment<
      typename decltype(params->isolation_info)::BaseType> isolation_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::IsolationInfoDataView>(
    in_isolation_info,
    isolation_info_fragment);

  params->isolation_info.Set(
      isolation_info_fragment.is_null() ? nullptr : isolation_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->isolation_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null isolation_info in NetworkContext.SetDocumentReportingEndpoints request");
  mojo::internal::MessageFragment<
      typename decltype(params->endpoints)::BaseType>
      endpoints_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& endpoints_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
  
  mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>>(
    in_endpoints,
    endpoints_fragment,
    &endpoints_validate_params);

  params->endpoints.Set(
      endpoints_fragment.is_null() ? nullptr : endpoints_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->endpoints.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null endpoints in NetworkContext.SetDocumentReportingEndpoints request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("SetDocumentReportingEndpoints");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NetworkContextProxy::SetEnterpriseReportingEndpoints(
    const base::flat_map<std::string, ::GURL>& in_endpoints) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkContext::SetEnterpriseReportingEndpoints", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("endpoints"), in_endpoints,
                        "<value of type const base::flat_map<std::string, ::GURL>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kSetEnterpriseReportingEndpoints), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_SetEnterpriseReportingEndpoints_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->endpoints)::BaseType>
      endpoints_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& endpoints_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, ::url::mojom::UrlDataView>>(
    in_endpoints,
    endpoints_fragment,
    &endpoints_validate_params);

  params->endpoints.Set(
      endpoints_fragment.is_null() ? nullptr : endpoints_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->endpoints.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null endpoints in NetworkContext.SetEnterpriseReportingEndpoints request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("SetEnterpriseReportingEndpoints");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NetworkContextProxy::SendReportsAndRemoveSource(
    const ::base::UnguessableToken& in_reporting_source) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkContext::SendReportsAndRemoveSource", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reporting_source"), in_reporting_source,
                        "<value of type const ::base::UnguessableToken&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kSendReportsAndRemoveSource), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_SendReportsAndRemoveSource_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->reporting_source)::BaseType> reporting_source_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_reporting_source,
    reporting_source_fragment);

  params->reporting_source.Set(
      reporting_source_fragment.is_null() ? nullptr : reporting_source_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->reporting_source.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null reporting_source in NetworkContext.SendReportsAndRemoveSource request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("SendReportsAndRemoveSource");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NetworkContextProxy::QueueReport(
    const std::string& in_type, const std::string& in_group, const ::GURL& in_url, const std::optional<::base::UnguessableToken>& in_reporting_source, const ::net::NetworkAnonymizationKey& in_network_anonymization_key, ::base::Value::Dict in_body) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkContext::QueueReport", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("group"), in_group,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reporting_source"), in_reporting_source,
                        "<value of type const std::optional<::base::UnguessableToken>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("network_anonymization_key"), in_network_anonymization_key,
                        "<value of type const ::net::NetworkAnonymizationKey&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("body"), in_body,
                        "<value of type ::base::Value::Dict>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kQueueReport), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_QueueReport_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->type)::BaseType> type_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_type,
    type_fragment);

  params->type.Set(
      type_fragment.is_null() ? nullptr : type_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->type.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null type in NetworkContext.QueueReport request");
  mojo::internal::MessageFragment<
      typename decltype(params->group)::BaseType> group_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_group,
    group_fragment);

  params->group.Set(
      group_fragment.is_null() ? nullptr : group_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->group.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null group in NetworkContext.QueueReport request");
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in NetworkContext.QueueReport request");
  mojo::internal::MessageFragment<
      typename decltype(params->reporting_source)::BaseType> reporting_source_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_reporting_source,
    reporting_source_fragment);

  params->reporting_source.Set(
      reporting_source_fragment.is_null() ? nullptr : reporting_source_fragment.data());
  mojo::internal::MessageFragment<decltype(params->network_anonymization_key)>
      network_anonymization_key_fragment(params.message());
  network_anonymization_key_fragment.Claim(&params->network_anonymization_key);
  
  mojo::internal::Serialize<::network::mojom::NetworkAnonymizationKeyDataView>(
    in_network_anonymization_key,
    network_anonymization_key_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->network_anonymization_key.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null network_anonymization_key in NetworkContext.QueueReport request");
  mojo::internal::MessageFragment<
      typename decltype(params->body)::BaseType> body_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::DictionaryValueDataView>(
    in_body,
    body_fragment);

  params->body.Set(
      body_fragment.is_null() ? nullptr : body_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->body.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null body in NetworkContext.QueueReport request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("QueueReport");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NetworkContextProxy::QueueEnterpriseReport(
    const std::string& in_type, const std::string& in_group, const ::GURL& in_url, ::base::Value::Dict in_body) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkContext::QueueEnterpriseReport", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("group"), in_group,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("body"), in_body,
                        "<value of type ::base::Value::Dict>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kQueueEnterpriseReport), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_QueueEnterpriseReport_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->type)::BaseType> type_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_type,
    type_fragment);

  params->type.Set(
      type_fragment.is_null() ? nullptr : type_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->type.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null type in NetworkContext.QueueEnterpriseReport request");
  mojo::internal::MessageFragment<
      typename decltype(params->group)::BaseType> group_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_group,
    group_fragment);

  params->group.Set(
      group_fragment.is_null() ? nullptr : group_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->group.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null group in NetworkContext.QueueEnterpriseReport request");
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in NetworkContext.QueueEnterpriseReport request");
  mojo::internal::MessageFragment<
      typename decltype(params->body)::BaseType> body_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::DictionaryValueDataView>(
    in_body,
    body_fragment);

  params->body.Set(
      body_fragment.is_null() ? nullptr : body_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->body.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null body in NetworkContext.QueueEnterpriseReport request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("QueueEnterpriseReport");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NetworkContextProxy::QueueSignedExchangeReport(
    SignedExchangeReportPtr in_report, const ::net::NetworkAnonymizationKey& in_network_anonymization_key) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkContext::QueueSignedExchangeReport", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("report"), in_report,
                        "<value of type SignedExchangeReportPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("network_anonymization_key"), in_network_anonymization_key,
                        "<value of type const ::net::NetworkAnonymizationKey&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kQueueSignedExchangeReport), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_QueueSignedExchangeReport_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->report)::BaseType> report_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::SignedExchangeReportDataView>(
    in_report,
    report_fragment);

  params->report.Set(
      report_fragment.is_null() ? nullptr : report_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->report.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null report in NetworkContext.QueueSignedExchangeReport request");
  mojo::internal::MessageFragment<decltype(params->network_anonymization_key)>
      network_anonymization_key_fragment(params.message());
  network_anonymization_key_fragment.Claim(&params->network_anonymization_key);
  
  mojo::internal::Serialize<::network::mojom::NetworkAnonymizationKeyDataView>(
    in_network_anonymization_key,
    network_anonymization_key_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->network_anonymization_key.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null network_anonymization_key in NetworkContext.QueueSignedExchangeReport request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("QueueSignedExchangeReport");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NetworkContextProxy::CloseAllConnections(
    CloseAllConnectionsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send network::mojom::NetworkContext::CloseAllConnections");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kCloseAllConnections), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_CloseAllConnections_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("CloseAllConnections");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_CloseAllConnections_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void NetworkContextProxy::CloseIdleConnections(
    CloseIdleConnectionsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send network::mojom::NetworkContext::CloseIdleConnections");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kCloseIdleConnections), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_CloseIdleConnections_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("CloseIdleConnections");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_CloseIdleConnections_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void NetworkContextProxy::SetNetworkConditions(
    const ::base::UnguessableToken& in_throttling_profile_id, NetworkConditionsPtr in_conditions) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkContext::SetNetworkConditions", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("throttling_profile_id"), in_throttling_profile_id,
                        "<value of type const ::base::UnguessableToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("conditions"), in_conditions,
                        "<value of type NetworkConditionsPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kSetNetworkConditions), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_SetNetworkConditions_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->throttling_profile_id)::BaseType> throttling_profile_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_throttling_profile_id,
    throttling_profile_id_fragment);

  params->throttling_profile_id.Set(
      throttling_profile_id_fragment.is_null() ? nullptr : throttling_profile_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->throttling_profile_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null throttling_profile_id in NetworkContext.SetNetworkConditions request");
  mojo::internal::MessageFragment<
      typename decltype(params->conditions)::BaseType> conditions_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::NetworkConditionsDataView>(
    in_conditions,
    conditions_fragment);

  params->conditions.Set(
      conditions_fragment.is_null() ? nullptr : conditions_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("SetNetworkConditions");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NetworkContextProxy::SetAcceptLanguage(
    const std::string& in_new_accept_language) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkContext::SetAcceptLanguage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_accept_language"), in_new_accept_language,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kSetAcceptLanguage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_SetAcceptLanguage_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->new_accept_language)::BaseType> new_accept_language_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_new_accept_language,
    new_accept_language_fragment);

  params->new_accept_language.Set(
      new_accept_language_fragment.is_null() ? nullptr : new_accept_language_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->new_accept_language.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null new_accept_language in NetworkContext.SetAcceptLanguage request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("SetAcceptLanguage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NetworkContextProxy::SetUserAgent(
    const std::string& in_new_user_agent) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkContext::SetUserAgent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_user_agent"), in_new_user_agent,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kSetUserAgent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_SetUserAgent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->new_user_agent)::BaseType> new_user_agent_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_new_user_agent,
    new_user_agent_fragment);

  params->new_user_agent.Set(
      new_user_agent_fragment.is_null() ? nullptr : new_user_agent_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->new_user_agent.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null new_user_agent in NetworkContext.SetUserAgent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("SetUserAgent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NetworkContextProxy::SetEnableReferrers(
    bool in_enable_referrers) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkContext::SetEnableReferrers", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enable_referrers"), in_enable_referrers,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kSetEnableReferrers), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_SetEnableReferrers_Params_Data> params(
          message);
  params.Allocate();

  params->enable_referrers = in_enable_referrers;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("SetEnableReferrers");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NetworkContextProxy::SetCTPolicy(
    CTPolicyPtr in_ct_policy) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkContext::SetCTPolicy", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ct_policy"), in_ct_policy,
                        "<value of type CTPolicyPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kSetCTPolicy), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_SetCTPolicy_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->ct_policy)::BaseType> ct_policy_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::CTPolicyDataView>(
    in_ct_policy,
    ct_policy_fragment);

  params->ct_policy.Set(
      ct_policy_fragment.is_null() ? nullptr : ct_policy_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->ct_policy.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null ct_policy in NetworkContext.SetCTPolicy request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("SetCTPolicy");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NetworkContextProxy::CreateUDPSocket(
    ::mojo::PendingReceiver<::network::mojom::UDPSocket> in_receiver, ::mojo::PendingRemote<::network::mojom::UDPSocketListener> in_listener) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkContext::CreateUDPSocket", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::network::mojom::UDPSocket>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("listener"), in_listener,
                        "<value of type ::mojo::PendingRemote<::network::mojom::UDPSocketListener>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kCreateUDPSocket), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_CreateUDPSocket_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::UDPSocketInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in NetworkContext.CreateUDPSocket request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::UDPSocketListenerInterfaceBase>>(
    in_listener,
    &params->listener,
    &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("CreateUDPSocket");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NetworkContextProxy::CreateRestrictedUDPSocket(
    const ::net::IPEndPoint& in_addr, ::network::mojom::RestrictedUDPSocketMode in_mode, const ::net::MutableNetworkTrafficAnnotationTag& in_traffic_annotation, ::network::mojom::RestrictedUDPSocketParamsPtr in_params, ::mojo::PendingReceiver<::network::mojom::RestrictedUDPSocket> in_receiver, ::mojo::PendingRemote<::network::mojom::UDPSocketListener> in_listener, CreateRestrictedUDPSocketCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkContext::CreateRestrictedUDPSocket", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("addr"), in_addr,
                        "<value of type const ::net::IPEndPoint&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("mode"), in_mode,
                        "<value of type ::network::mojom::RestrictedUDPSocketMode>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("traffic_annotation"), in_traffic_annotation,
                        "<value of type const ::net::MutableNetworkTrafficAnnotationTag&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type ::network::mojom::RestrictedUDPSocketParamsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::network::mojom::RestrictedUDPSocket>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("listener"), in_listener,
                        "<value of type ::mojo::PendingRemote<::network::mojom::UDPSocketListener>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kCreateRestrictedUDPSocket), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_CreateRestrictedUDPSocket_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->addr)::BaseType> addr_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::IPEndPointDataView>(
    in_addr,
    addr_fragment);

  params->addr.Set(
      addr_fragment.is_null() ? nullptr : addr_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->addr.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null addr in NetworkContext.CreateRestrictedUDPSocket request");

  
  mojo::internal::Serialize<::network::mojom::RestrictedUDPSocketMode>(
    in_mode,
    &params->mode);
  mojo::internal::MessageFragment<
      typename decltype(params->traffic_annotation)::BaseType> traffic_annotation_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::MutableNetworkTrafficAnnotationTagDataView>(
    in_traffic_annotation,
    traffic_annotation_fragment);

  params->traffic_annotation.Set(
      traffic_annotation_fragment.is_null() ? nullptr : traffic_annotation_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->traffic_annotation.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null traffic_annotation in NetworkContext.CreateRestrictedUDPSocket request");
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::RestrictedUDPSocketParamsDataView>(
    in_params,
    params_fragment);

  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::RestrictedUDPSocketInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in NetworkContext.CreateRestrictedUDPSocket request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::UDPSocketListenerInterfaceBase>>(
    in_listener,
    &params->listener,
    &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("CreateRestrictedUDPSocket");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_CreateRestrictedUDPSocket_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void NetworkContextProxy::CreateTCPServerSocket(
    const ::net::IPEndPoint& in_local_addr, ::network::mojom::TCPServerSocketOptionsPtr in_options, const ::net::MutableNetworkTrafficAnnotationTag& in_traffic_annotation, ::mojo::PendingReceiver<::network::mojom::TCPServerSocket> in_socket, CreateTCPServerSocketCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkContext::CreateTCPServerSocket", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("local_addr"), in_local_addr,
                        "<value of type const ::net::IPEndPoint&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type ::network::mojom::TCPServerSocketOptionsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("traffic_annotation"), in_traffic_annotation,
                        "<value of type const ::net::MutableNetworkTrafficAnnotationTag&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("socket"), in_socket,
                        "<value of type ::mojo::PendingReceiver<::network::mojom::TCPServerSocket>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kCreateTCPServerSocket), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_CreateTCPServerSocket_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->local_addr)::BaseType> local_addr_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::IPEndPointDataView>(
    in_local_addr,
    local_addr_fragment);

  params->local_addr.Set(
      local_addr_fragment.is_null() ? nullptr : local_addr_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->local_addr.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null local_addr in NetworkContext.CreateTCPServerSocket request");
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::TCPServerSocketOptionsDataView>(
    in_options,
    options_fragment);

  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->options.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null options in NetworkContext.CreateTCPServerSocket request");
  mojo::internal::MessageFragment<
      typename decltype(params->traffic_annotation)::BaseType> traffic_annotation_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::MutableNetworkTrafficAnnotationTagDataView>(
    in_traffic_annotation,
    traffic_annotation_fragment);

  params->traffic_annotation.Set(
      traffic_annotation_fragment.is_null() ? nullptr : traffic_annotation_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->traffic_annotation.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null traffic_annotation in NetworkContext.CreateTCPServerSocket request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::TCPServerSocketInterfaceBase>>(
    in_socket,
    &params->socket,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->socket)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid socket in NetworkContext.CreateTCPServerSocket request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("CreateTCPServerSocket");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_CreateTCPServerSocket_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void NetworkContextProxy::CreateTCPConnectedSocket(
    const std::optional<::net::IPEndPoint>& in_local_addr, const ::net::AddressList& in_remote_addr_list, ::network::mojom::TCPConnectedSocketOptionsPtr in_tcp_connected_socket_options, const ::net::MutableNetworkTrafficAnnotationTag& in_traffic_annotation, ::mojo::PendingReceiver<::network::mojom::TCPConnectedSocket> in_socket, ::mojo::PendingRemote<::network::mojom::SocketObserver> in_observer, CreateTCPConnectedSocketCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkContext::CreateTCPConnectedSocket", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("local_addr"), in_local_addr,
                        "<value of type const std::optional<::net::IPEndPoint>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("remote_addr_list"), in_remote_addr_list,
                        "<value of type const ::net::AddressList&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tcp_connected_socket_options"), in_tcp_connected_socket_options,
                        "<value of type ::network::mojom::TCPConnectedSocketOptionsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("traffic_annotation"), in_traffic_annotation,
                        "<value of type const ::net::MutableNetworkTrafficAnnotationTag&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("socket"), in_socket,
                        "<value of type ::mojo::PendingReceiver<::network::mojom::TCPConnectedSocket>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer,
                        "<value of type ::mojo::PendingRemote<::network::mojom::SocketObserver>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kCreateTCPConnectedSocket), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_CreateTCPConnectedSocket_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->local_addr)::BaseType> local_addr_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::IPEndPointDataView>(
    in_local_addr,
    local_addr_fragment);

  params->local_addr.Set(
      local_addr_fragment.is_null() ? nullptr : local_addr_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->remote_addr_list)::BaseType> remote_addr_list_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::AddressListDataView>(
    in_remote_addr_list,
    remote_addr_list_fragment);

  params->remote_addr_list.Set(
      remote_addr_list_fragment.is_null() ? nullptr : remote_addr_list_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->remote_addr_list.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null remote_addr_list in NetworkContext.CreateTCPConnectedSocket request");
  mojo::internal::MessageFragment<
      typename decltype(params->tcp_connected_socket_options)::BaseType> tcp_connected_socket_options_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::TCPConnectedSocketOptionsDataView>(
    in_tcp_connected_socket_options,
    tcp_connected_socket_options_fragment);

  params->tcp_connected_socket_options.Set(
      tcp_connected_socket_options_fragment.is_null() ? nullptr : tcp_connected_socket_options_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->traffic_annotation)::BaseType> traffic_annotation_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::MutableNetworkTrafficAnnotationTagDataView>(
    in_traffic_annotation,
    traffic_annotation_fragment);

  params->traffic_annotation.Set(
      traffic_annotation_fragment.is_null() ? nullptr : traffic_annotation_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->traffic_annotation.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null traffic_annotation in NetworkContext.CreateTCPConnectedSocket request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::TCPConnectedSocketInterfaceBase>>(
    in_socket,
    &params->socket,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->socket)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid socket in NetworkContext.CreateTCPConnectedSocket request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::SocketObserverInterfaceBase>>(
    in_observer,
    &params->observer,
    &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("CreateTCPConnectedSocket");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_CreateTCPConnectedSocket_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void NetworkContextProxy::CreateTCPBoundSocket(
    const ::net::IPEndPoint& in_local_addr, const ::net::MutableNetworkTrafficAnnotationTag& in_traffic_annotation, ::mojo::PendingReceiver<::network::mojom::TCPBoundSocket> in_socket, CreateTCPBoundSocketCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkContext::CreateTCPBoundSocket", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("local_addr"), in_local_addr,
                        "<value of type const ::net::IPEndPoint&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("traffic_annotation"), in_traffic_annotation,
                        "<value of type const ::net::MutableNetworkTrafficAnnotationTag&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("socket"), in_socket,
                        "<value of type ::mojo::PendingReceiver<::network::mojom::TCPBoundSocket>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kCreateTCPBoundSocket), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_CreateTCPBoundSocket_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->local_addr)::BaseType> local_addr_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::IPEndPointDataView>(
    in_local_addr,
    local_addr_fragment);

  params->local_addr.Set(
      local_addr_fragment.is_null() ? nullptr : local_addr_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->local_addr.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null local_addr in NetworkContext.CreateTCPBoundSocket request");
  mojo::internal::MessageFragment<
      typename decltype(params->traffic_annotation)::BaseType> traffic_annotation_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::MutableNetworkTrafficAnnotationTagDataView>(
    in_traffic_annotation,
    traffic_annotation_fragment);

  params->traffic_annotation.Set(
      traffic_annotation_fragment.is_null() ? nullptr : traffic_annotation_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->traffic_annotation.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null traffic_annotation in NetworkContext.CreateTCPBoundSocket request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::TCPBoundSocketInterfaceBase>>(
    in_socket,
    &params->socket,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->socket)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid socket in NetworkContext.CreateTCPBoundSocket request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("CreateTCPBoundSocket");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_CreateTCPBoundSocket_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void NetworkContextProxy::CreateProxyResolvingSocketFactory(
    ::mojo::PendingReceiver<::network::mojom::ProxyResolvingSocketFactory> in_factory) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkContext::CreateProxyResolvingSocketFactory", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("factory"), in_factory,
                        "<value of type ::mojo::PendingReceiver<::network::mojom::ProxyResolvingSocketFactory>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kCreateProxyResolvingSocketFactory), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_CreateProxyResolvingSocketFactory_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::ProxyResolvingSocketFactoryInterfaceBase>>(
    in_factory,
    &params->factory,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->factory)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid factory in NetworkContext.CreateProxyResolvingSocketFactory request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("CreateProxyResolvingSocketFactory");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NetworkContextProxy::LookUpProxyForURL(
    const ::GURL& in_url, const ::net::NetworkAnonymizationKey& in_network_anonymization_key, ::mojo::PendingRemote<::network::mojom::ProxyLookupClient> in_proxy_lookup_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkContext::LookUpProxyForURL", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("network_anonymization_key"), in_network_anonymization_key,
                        "<value of type const ::net::NetworkAnonymizationKey&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("proxy_lookup_client"), in_proxy_lookup_client,
                        "<value of type ::mojo::PendingRemote<::network::mojom::ProxyLookupClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kLookUpProxyForURL), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_LookUpProxyForURL_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in NetworkContext.LookUpProxyForURL request");
  mojo::internal::MessageFragment<decltype(params->network_anonymization_key)>
      network_anonymization_key_fragment(params.message());
  network_anonymization_key_fragment.Claim(&params->network_anonymization_key);
  
  mojo::internal::Serialize<::network::mojom::NetworkAnonymizationKeyDataView>(
    in_network_anonymization_key,
    network_anonymization_key_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->network_anonymization_key.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null network_anonymization_key in NetworkContext.LookUpProxyForURL request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::ProxyLookupClientInterfaceBase>>(
    in_proxy_lookup_client,
    &params->proxy_lookup_client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->proxy_lookup_client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid proxy_lookup_client in NetworkContext.LookUpProxyForURL request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("LookUpProxyForURL");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NetworkContextProxy::ForceReloadProxyConfig(
    ForceReloadProxyConfigCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send network::mojom::NetworkContext::ForceReloadProxyConfig");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kForceReloadProxyConfig), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_ForceReloadProxyConfig_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("ForceReloadProxyConfig");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_ForceReloadProxyConfig_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void NetworkContextProxy::ClearBadProxiesCache(
    ClearBadProxiesCacheCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send network::mojom::NetworkContext::ClearBadProxiesCache");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kClearBadProxiesCache), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_ClearBadProxiesCache_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("ClearBadProxiesCache");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_ClearBadProxiesCache_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void NetworkContextProxy::CreateWebSocket(
    const ::GURL& in_url, const std::vector<std::string>& in_requested_protocols, const ::net::SiteForCookies& in_site_for_cookies, ::net::StorageAccessApiStatus in_storage_access_api_status, const ::net::IsolationInfo& in_isolation_info, std::vector<::network::mojom::HttpHeaderPtr> in_additional_headers, int32_t in_process_id, const ::url::Origin& in_origin, uint32_t in_options, const ::net::MutableNetworkTrafficAnnotationTag& in_traffic_annotation, ::mojo::PendingRemote<::network::mojom::WebSocketHandshakeClient> in_handshake_client, ::mojo::PendingRemote<::network::mojom::URLLoaderNetworkServiceObserver> in_url_loader_network_observer, ::mojo::PendingRemote<::network::mojom::WebSocketAuthenticationHandler> in_auth_handler, ::mojo::PendingRemote<TrustedHeaderClient> in_header_client, const std::optional<::base::UnguessableToken>& in_throttling_profile_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkContext::CreateWebSocket", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("requested_protocols"), in_requested_protocols,
                        "<value of type const std::vector<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("site_for_cookies"), in_site_for_cookies,
                        "<value of type const ::net::SiteForCookies&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("storage_access_api_status"), in_storage_access_api_status,
                        "<value of type ::net::StorageAccessApiStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("isolation_info"), in_isolation_info,
                        "<value of type const ::net::IsolationInfo&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("additional_headers"), in_additional_headers,
                        "<value of type std::vector<::network::mojom::HttpHeaderPtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("process_id"), in_process_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("origin"), in_origin,
                        "<value of type const ::url::Origin&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("traffic_annotation"), in_traffic_annotation,
                        "<value of type const ::net::MutableNetworkTrafficAnnotationTag&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("handshake_client"), in_handshake_client,
                        "<value of type ::mojo::PendingRemote<::network::mojom::WebSocketHandshakeClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url_loader_network_observer"), in_url_loader_network_observer,
                        "<value of type ::mojo::PendingRemote<::network::mojom::URLLoaderNetworkServiceObserver>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("auth_handler"), in_auth_handler,
                        "<value of type ::mojo::PendingRemote<::network::mojom::WebSocketAuthenticationHandler>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("header_client"), in_header_client,
                        "<value of type ::mojo::PendingRemote<TrustedHeaderClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("throttling_profile_id"), in_throttling_profile_id,
                        "<value of type const std::optional<::base::UnguessableToken>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kCreateWebSocket), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_CreateWebSocket_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in NetworkContext.CreateWebSocket request");
  mojo::internal::MessageFragment<
      typename decltype(params->requested_protocols)::BaseType>
      requested_protocols_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& requested_protocols_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
    in_requested_protocols,
    requested_protocols_fragment,
    &requested_protocols_validate_params);

  params->requested_protocols.Set(
      requested_protocols_fragment.is_null() ? nullptr : requested_protocols_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->requested_protocols.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null requested_protocols in NetworkContext.CreateWebSocket request");
  mojo::internal::MessageFragment<
      typename decltype(params->site_for_cookies)::BaseType> site_for_cookies_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::SiteForCookiesDataView>(
    in_site_for_cookies,
    site_for_cookies_fragment);

  params->site_for_cookies.Set(
      site_for_cookies_fragment.is_null() ? nullptr : site_for_cookies_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->site_for_cookies.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null site_for_cookies in NetworkContext.CreateWebSocket request");

  
  mojo::internal::Serialize<::network::mojom::StorageAccessApiStatus>(
    in_storage_access_api_status,
    &params->storage_access_api_status);
  mojo::internal::MessageFragment<
      typename decltype(params->isolation_info)::BaseType> isolation_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::IsolationInfoDataView>(
    in_isolation_info,
    isolation_info_fragment);

  params->isolation_info.Set(
      isolation_info_fragment.is_null() ? nullptr : isolation_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->isolation_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null isolation_info in NetworkContext.CreateWebSocket request");
  mojo::internal::MessageFragment<
      typename decltype(params->additional_headers)::BaseType>
      additional_headers_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& additional_headers_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::HttpHeaderDataView>>(
    in_additional_headers,
    additional_headers_fragment,
    &additional_headers_validate_params);

  params->additional_headers.Set(
      additional_headers_fragment.is_null() ? nullptr : additional_headers_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->additional_headers.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null additional_headers in NetworkContext.CreateWebSocket request");

  params->process_id = in_process_id;
  mojo::internal::MessageFragment<
      typename decltype(params->origin)::BaseType> origin_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
    in_origin,
    origin_fragment);

  params->origin.Set(
      origin_fragment.is_null() ? nullptr : origin_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->origin.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null origin in NetworkContext.CreateWebSocket request");

  params->options = in_options;
  mojo::internal::MessageFragment<
      typename decltype(params->traffic_annotation)::BaseType> traffic_annotation_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::MutableNetworkTrafficAnnotationTagDataView>(
    in_traffic_annotation,
    traffic_annotation_fragment);

  params->traffic_annotation.Set(
      traffic_annotation_fragment.is_null() ? nullptr : traffic_annotation_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->traffic_annotation.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null traffic_annotation in NetworkContext.CreateWebSocket request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::WebSocketHandshakeClientInterfaceBase>>(
    in_handshake_client,
    &params->handshake_client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->handshake_client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid handshake_client in NetworkContext.CreateWebSocket request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::URLLoaderNetworkServiceObserverInterfaceBase>>(
    in_url_loader_network_observer,
    &params->url_loader_network_observer,
    &params.message());

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::WebSocketAuthenticationHandlerInterfaceBase>>(
    in_auth_handler,
    &params->auth_handler,
    &params.message());

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::TrustedHeaderClientInterfaceBase>>(
    in_header_client,
    &params->header_client,
    &params.message());
  mojo::internal::MessageFragment<
      typename decltype(params->throttling_profile_id)::BaseType> throttling_profile_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_throttling_profile_id,
    throttling_profile_id_fragment);

  params->throttling_profile_id.Set(
      throttling_profile_id_fragment.is_null() ? nullptr : throttling_profile_id_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("CreateWebSocket");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NetworkContextProxy::CreateWebTransport(
    const ::GURL& in_url, const ::url::Origin& in_origin, const ::net::NetworkAnonymizationKey& in_network_anonymization_key, std::vector<::network::mojom::WebTransportCertificateFingerprintPtr> in_fingerprints, const std::vector<std::string>& in_application_protocols, ::mojo::PendingRemote<::network::mojom::WebTransportHandshakeClient> in_handshake_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkContext::CreateWebTransport", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("origin"), in_origin,
                        "<value of type const ::url::Origin&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("network_anonymization_key"), in_network_anonymization_key,
                        "<value of type const ::net::NetworkAnonymizationKey&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("fingerprints"), in_fingerprints,
                        "<value of type std::vector<::network::mojom::WebTransportCertificateFingerprintPtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("application_protocols"), in_application_protocols,
                        "<value of type const std::vector<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("handshake_client"), in_handshake_client,
                        "<value of type ::mojo::PendingRemote<::network::mojom::WebTransportHandshakeClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kCreateWebTransport), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_CreateWebTransport_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in NetworkContext.CreateWebTransport request");
  mojo::internal::MessageFragment<
      typename decltype(params->origin)::BaseType> origin_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
    in_origin,
    origin_fragment);

  params->origin.Set(
      origin_fragment.is_null() ? nullptr : origin_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->origin.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null origin in NetworkContext.CreateWebTransport request");
  mojo::internal::MessageFragment<decltype(params->network_anonymization_key)>
      network_anonymization_key_fragment(params.message());
  network_anonymization_key_fragment.Claim(&params->network_anonymization_key);
  
  mojo::internal::Serialize<::network::mojom::NetworkAnonymizationKeyDataView>(
    in_network_anonymization_key,
    network_anonymization_key_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->network_anonymization_key.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null network_anonymization_key in NetworkContext.CreateWebTransport request");
  mojo::internal::MessageFragment<
      typename decltype(params->fingerprints)::BaseType>
      fingerprints_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& fingerprints_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::WebTransportCertificateFingerprintDataView>>(
    in_fingerprints,
    fingerprints_fragment,
    &fingerprints_validate_params);

  params->fingerprints.Set(
      fingerprints_fragment.is_null() ? nullptr : fingerprints_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->fingerprints.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null fingerprints in NetworkContext.CreateWebTransport request");
  mojo::internal::MessageFragment<
      typename decltype(params->application_protocols)::BaseType>
      application_protocols_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& application_protocols_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
    in_application_protocols,
    application_protocols_fragment,
    &application_protocols_validate_params);

  params->application_protocols.Set(
      application_protocols_fragment.is_null() ? nullptr : application_protocols_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->application_protocols.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null application_protocols in NetworkContext.CreateWebTransport request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::WebTransportHandshakeClientInterfaceBase>>(
    in_handshake_client,
    &params->handshake_client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->handshake_client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid handshake_client in NetworkContext.CreateWebTransport request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("CreateWebTransport");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NetworkContextProxy::CreateNetLogExporter(
    ::mojo::PendingReceiver<::network::mojom::NetLogExporter> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkContext::CreateNetLogExporter", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::network::mojom::NetLogExporter>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kCreateNetLogExporter), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_CreateNetLogExporter_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::NetLogExporterInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in NetworkContext.CreateNetLogExporter request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("CreateNetLogExporter");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NetworkContextProxy::PreconnectSockets(
    uint32_t in_num_streams, const ::GURL& in_url, ::network::mojom::CredentialsMode in_credentials_mode, const ::net::NetworkAnonymizationKey& in_network_anonymization_key, const ::net::MutableNetworkTrafficAnnotationTag& in_traffic_annotation, const std::optional<::net::ConnectionKeepAliveConfig>& in_keepalive_config, ::mojo::PendingRemote<::network::mojom::ConnectionChangeObserverClient> in_observer_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkContext::PreconnectSockets", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("num_streams"), in_num_streams,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("credentials_mode"), in_credentials_mode,
                        "<value of type ::network::mojom::CredentialsMode>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("network_anonymization_key"), in_network_anonymization_key,
                        "<value of type const ::net::NetworkAnonymizationKey&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("traffic_annotation"), in_traffic_annotation,
                        "<value of type const ::net::MutableNetworkTrafficAnnotationTag&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("keepalive_config"), in_keepalive_config,
                        "<value of type const std::optional<::net::ConnectionKeepAliveConfig>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer_client"), in_observer_client,
                        "<value of type ::mojo::PendingRemote<::network::mojom::ConnectionChangeObserverClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kPreconnectSockets), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_PreconnectSockets_Params_Data> params(
          message);
  params.Allocate();

  params->num_streams = in_num_streams;
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in NetworkContext.PreconnectSockets request");

  
  mojo::internal::Serialize<::network::mojom::CredentialsMode>(
    in_credentials_mode,
    &params->credentials_mode);
  mojo::internal::MessageFragment<decltype(params->network_anonymization_key)>
      network_anonymization_key_fragment(params.message());
  network_anonymization_key_fragment.Claim(&params->network_anonymization_key);
  
  mojo::internal::Serialize<::network::mojom::NetworkAnonymizationKeyDataView>(
    in_network_anonymization_key,
    network_anonymization_key_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->network_anonymization_key.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null network_anonymization_key in NetworkContext.PreconnectSockets request");
  mojo::internal::MessageFragment<
      typename decltype(params->traffic_annotation)::BaseType> traffic_annotation_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::MutableNetworkTrafficAnnotationTagDataView>(
    in_traffic_annotation,
    traffic_annotation_fragment);

  params->traffic_annotation.Set(
      traffic_annotation_fragment.is_null() ? nullptr : traffic_annotation_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->traffic_annotation.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null traffic_annotation in NetworkContext.PreconnectSockets request");
  mojo::internal::MessageFragment<
      typename decltype(params->keepalive_config)::BaseType> keepalive_config_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::ConnectionKeepAliveConfigDataView>(
    in_keepalive_config,
    keepalive_config_fragment);

  params->keepalive_config.Set(
      keepalive_config_fragment.is_null() ? nullptr : keepalive_config_fragment.data());

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::ConnectionChangeObserverClientInterfaceBase>>(
    in_observer_client,
    &params->observer_client,
    &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("PreconnectSockets");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NetworkContextProxy::CreateP2PSocketManager(
    const ::net::NetworkAnonymizationKey& in_network_anonymization_key, ::mojo::PendingRemote<::network::mojom::P2PTrustedSocketManagerClient> in_client, ::mojo::PendingReceiver<::network::mojom::P2PTrustedSocketManager> in_trusted_socket_manager, ::mojo::PendingReceiver<::network::mojom::P2PSocketManager> in_socket_manager) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkContext::CreateP2PSocketManager", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("network_anonymization_key"), in_network_anonymization_key,
                        "<value of type const ::net::NetworkAnonymizationKey&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<::network::mojom::P2PTrustedSocketManagerClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("trusted_socket_manager"), in_trusted_socket_manager,
                        "<value of type ::mojo::PendingReceiver<::network::mojom::P2PTrustedSocketManager>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("socket_manager"), in_socket_manager,
                        "<value of type ::mojo::PendingReceiver<::network::mojom::P2PSocketManager>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kCreateP2PSocketManager), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_CreateP2PSocketManager_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->network_anonymization_key)>
      network_anonymization_key_fragment(params.message());
  network_anonymization_key_fragment.Claim(&params->network_anonymization_key);
  
  mojo::internal::Serialize<::network::mojom::NetworkAnonymizationKeyDataView>(
    in_network_anonymization_key,
    network_anonymization_key_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->network_anonymization_key.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null network_anonymization_key in NetworkContext.CreateP2PSocketManager request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::P2PTrustedSocketManagerClientInterfaceBase>>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid client in NetworkContext.CreateP2PSocketManager request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::P2PTrustedSocketManagerInterfaceBase>>(
    in_trusted_socket_manager,
    &params->trusted_socket_manager,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->trusted_socket_manager)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid trusted_socket_manager in NetworkContext.CreateP2PSocketManager request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::P2PSocketManagerInterfaceBase>>(
    in_socket_manager,
    &params->socket_manager,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->socket_manager)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid socket_manager in NetworkContext.CreateP2PSocketManager request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("CreateP2PSocketManager");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NetworkContextProxy::CreateMdnsResponder(
    ::mojo::PendingReceiver<::network::mojom::MdnsResponder> in_responder_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkContext::CreateMdnsResponder", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("responder_receiver"), in_responder_receiver,
                        "<value of type ::mojo::PendingReceiver<::network::mojom::MdnsResponder>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kCreateMdnsResponder), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_CreateMdnsResponder_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::MdnsResponderInterfaceBase>>(
    in_responder_receiver,
    &params->responder_receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->responder_receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid responder_receiver in NetworkContext.CreateMdnsResponder request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("CreateMdnsResponder");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NetworkContextProxy::ResolveHost(
    ::network::mojom::HostResolverHostPtr in_host, const ::net::NetworkAnonymizationKey& in_network_anonymization_key, ::network::mojom::ResolveHostParametersPtr in_optional_parameters, ::mojo::PendingRemote<::network::mojom::ResolveHostClient> in_response_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkContext::ResolveHost", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("host"), in_host,
                        "<value of type ::network::mojom::HostResolverHostPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("network_anonymization_key"), in_network_anonymization_key,
                        "<value of type const ::net::NetworkAnonymizationKey&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("optional_parameters"), in_optional_parameters,
                        "<value of type ::network::mojom::ResolveHostParametersPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("response_client"), in_response_client,
                        "<value of type ::mojo::PendingRemote<::network::mojom::ResolveHostClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kResolveHost), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_ResolveHost_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->host)>
      host_fragment(params.message());
  host_fragment.Claim(&params->host);
  
  mojo::internal::Serialize<::network::mojom::HostResolverHostDataView>(
    in_host,
    host_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->host.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null host in NetworkContext.ResolveHost request");
  mojo::internal::MessageFragment<decltype(params->network_anonymization_key)>
      network_anonymization_key_fragment(params.message());
  network_anonymization_key_fragment.Claim(&params->network_anonymization_key);
  
  mojo::internal::Serialize<::network::mojom::NetworkAnonymizationKeyDataView>(
    in_network_anonymization_key,
    network_anonymization_key_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->network_anonymization_key.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null network_anonymization_key in NetworkContext.ResolveHost request");
  mojo::internal::MessageFragment<
      typename decltype(params->optional_parameters)::BaseType> optional_parameters_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::ResolveHostParametersDataView>(
    in_optional_parameters,
    optional_parameters_fragment);

  params->optional_parameters.Set(
      optional_parameters_fragment.is_null() ? nullptr : optional_parameters_fragment.data());

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::ResolveHostClientInterfaceBase>>(
    in_response_client,
    &params->response_client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->response_client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid response_client in NetworkContext.ResolveHost request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("ResolveHost");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NetworkContextProxy::CreateHostResolver(
    const std::optional<::net::DnsConfigOverrides>& in_config_overrides, ::mojo::PendingReceiver<::network::mojom::HostResolver> in_host_resolver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkContext::CreateHostResolver", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("config_overrides"), in_config_overrides,
                        "<value of type const std::optional<::net::DnsConfigOverrides>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("host_resolver"), in_host_resolver,
                        "<value of type ::mojo::PendingReceiver<::network::mojom::HostResolver>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kCreateHostResolver), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_CreateHostResolver_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->config_overrides)::BaseType> config_overrides_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::DnsConfigOverridesDataView>(
    in_config_overrides,
    config_overrides_fragment);

  params->config_overrides.Set(
      config_overrides_fragment.is_null() ? nullptr : config_overrides_fragment.data());

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::HostResolverInterfaceBase>>(
    in_host_resolver,
    &params->host_resolver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->host_resolver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid host_resolver in NetworkContext.CreateHostResolver request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("CreateHostResolver");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NetworkContextProxy::VerifyCert(
    const ::scoped_refptr<::net::X509Certificate>& in_certificate, const ::net::HostPortPair& in_host_port, const std::string& in_ocsp_response, const std::string& in_sct_list, VerifyCertCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkContext::VerifyCert", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("certificate"), in_certificate,
                        "<value of type const ::scoped_refptr<::net::X509Certificate>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("host_port"), in_host_port,
                        "<value of type const ::net::HostPortPair&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ocsp_response"), in_ocsp_response,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sct_list"), in_sct_list,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kVerifyCert), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_VerifyCert_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->certificate)::BaseType> certificate_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::X509CertificateDataView>(
    in_certificate,
    certificate_fragment);

  params->certificate.Set(
      certificate_fragment.is_null() ? nullptr : certificate_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->certificate.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null certificate in NetworkContext.VerifyCert request");
  mojo::internal::MessageFragment<
      typename decltype(params->host_port)::BaseType> host_port_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::HostPortPairDataView>(
    in_host_port,
    host_port_fragment);

  params->host_port.Set(
      host_port_fragment.is_null() ? nullptr : host_port_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->host_port.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null host_port in NetworkContext.VerifyCert request");
  mojo::internal::MessageFragment<
      typename decltype(params->ocsp_response)::BaseType> ocsp_response_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_ocsp_response,
    ocsp_response_fragment);

  params->ocsp_response.Set(
      ocsp_response_fragment.is_null() ? nullptr : ocsp_response_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->ocsp_response.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null ocsp_response in NetworkContext.VerifyCert request");
  mojo::internal::MessageFragment<
      typename decltype(params->sct_list)::BaseType> sct_list_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_sct_list,
    sct_list_fragment);

  params->sct_list.Set(
      sct_list_fragment.is_null() ? nullptr : sct_list_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->sct_list.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null sct_list in NetworkContext.VerifyCert request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("VerifyCert");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_VerifyCert_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void NetworkContextProxy::VerifyCertForSignedExchange(
    const ::scoped_refptr<::net::X509Certificate>& in_certificate, const ::net::HostPortPair& in_host_port, const std::string& in_ocsp_response, const std::string& in_sct_list, VerifyCertForSignedExchangeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkContext::VerifyCertForSignedExchange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("certificate"), in_certificate,
                        "<value of type const ::scoped_refptr<::net::X509Certificate>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("host_port"), in_host_port,
                        "<value of type const ::net::HostPortPair&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ocsp_response"), in_ocsp_response,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sct_list"), in_sct_list,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kVerifyCertForSignedExchange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_VerifyCertForSignedExchange_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->certificate)::BaseType> certificate_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::X509CertificateDataView>(
    in_certificate,
    certificate_fragment);

  params->certificate.Set(
      certificate_fragment.is_null() ? nullptr : certificate_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->certificate.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null certificate in NetworkContext.VerifyCertForSignedExchange request");
  mojo::internal::MessageFragment<
      typename decltype(params->host_port)::BaseType> host_port_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::HostPortPairDataView>(
    in_host_port,
    host_port_fragment);

  params->host_port.Set(
      host_port_fragment.is_null() ? nullptr : host_port_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->host_port.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null host_port in NetworkContext.VerifyCertForSignedExchange request");
  mojo::internal::MessageFragment<
      typename decltype(params->ocsp_response)::BaseType> ocsp_response_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_ocsp_response,
    ocsp_response_fragment);

  params->ocsp_response.Set(
      ocsp_response_fragment.is_null() ? nullptr : ocsp_response_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->ocsp_response.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null ocsp_response in NetworkContext.VerifyCertForSignedExchange request");
  mojo::internal::MessageFragment<
      typename decltype(params->sct_list)::BaseType> sct_list_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_sct_list,
    sct_list_fragment);

  params->sct_list.Set(
      sct_list_fragment.is_null() ? nullptr : sct_list_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->sct_list.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null sct_list in NetworkContext.VerifyCertForSignedExchange request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("VerifyCertForSignedExchange");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_VerifyCertForSignedExchange_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void NetworkContextProxy::Verify2QwacCertBinding(
    const std::string& in_binding, const std::string& in_hostname, const ::scoped_refptr<::net::X509Certificate>& in_tls_certificate, Verify2QwacCertBindingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkContext::Verify2QwacCertBinding", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("binding"), in_binding,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("hostname"), in_hostname,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tls_certificate"), in_tls_certificate,
                        "<value of type const ::scoped_refptr<::net::X509Certificate>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kVerify2QwacCertBinding), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_Verify2QwacCertBinding_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->binding)::BaseType> binding_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_binding,
    binding_fragment);

  params->binding.Set(
      binding_fragment.is_null() ? nullptr : binding_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->binding.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null binding in NetworkContext.Verify2QwacCertBinding request");
  mojo::internal::MessageFragment<
      typename decltype(params->hostname)::BaseType> hostname_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_hostname,
    hostname_fragment);

  params->hostname.Set(
      hostname_fragment.is_null() ? nullptr : hostname_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->hostname.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null hostname in NetworkContext.Verify2QwacCertBinding request");
  mojo::internal::MessageFragment<
      typename decltype(params->tls_certificate)::BaseType> tls_certificate_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::X509CertificateDataView>(
    in_tls_certificate,
    tls_certificate_fragment);

  params->tls_certificate.Set(
      tls_certificate_fragment.is_null() ? nullptr : tls_certificate_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->tls_certificate.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null tls_certificate in NetworkContext.Verify2QwacCertBinding request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("Verify2QwacCertBinding");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_Verify2QwacCertBinding_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void NetworkContextProxy::AddHSTS(
    const std::string& in_host, ::base::Time in_expiry, bool in_include_subdomains, AddHSTSCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkContext::AddHSTS", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("host"), in_host,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("expiry"), in_expiry,
                        "<value of type ::base::Time>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("include_subdomains"), in_include_subdomains,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kAddHSTS), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_AddHSTS_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->host)::BaseType> host_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_host,
    host_fragment);

  params->host.Set(
      host_fragment.is_null() ? nullptr : host_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->host.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null host in NetworkContext.AddHSTS request");
  mojo::internal::MessageFragment<
      typename decltype(params->expiry)::BaseType> expiry_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
    in_expiry,
    expiry_fragment);

  params->expiry.Set(
      expiry_fragment.is_null() ? nullptr : expiry_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->expiry.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null expiry in NetworkContext.AddHSTS request");

  params->include_subdomains = in_include_subdomains;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("AddHSTS");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_AddHSTS_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void NetworkContextProxy::IsHSTSActiveForHost(
    const std::string& in_host, bool in_is_top_level_nav, IsHSTSActiveForHostCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkContext::IsHSTSActiveForHost", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("host"), in_host,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_top_level_nav"), in_is_top_level_nav,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kIsHSTSActiveForHost), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_IsHSTSActiveForHost_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->host)::BaseType> host_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_host,
    host_fragment);

  params->host.Set(
      host_fragment.is_null() ? nullptr : host_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->host.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null host in NetworkContext.IsHSTSActiveForHost request");

  params->is_top_level_nav = in_is_top_level_nav;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("IsHSTSActiveForHost");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_IsHSTSActiveForHost_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void NetworkContextProxy::GetHSTSState(
    const std::string& in_domain, GetHSTSStateCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkContext::GetHSTSState", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("domain"), in_domain,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kGetHSTSState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_GetHSTSState_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->domain)::BaseType> domain_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_domain,
    domain_fragment);

  params->domain.Set(
      domain_fragment.is_null() ? nullptr : domain_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->domain.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null domain in NetworkContext.GetHSTSState request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("GetHSTSState");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_GetHSTSState_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void NetworkContextProxy::SetCorsOriginAccessListsForOrigin(
    const ::url::Origin& in_source_origin, std::vector<::network::mojom::CorsOriginPatternPtr> in_allow_patterns, std::vector<::network::mojom::CorsOriginPatternPtr> in_block_patterns, SetCorsOriginAccessListsForOriginCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkContext::SetCorsOriginAccessListsForOrigin", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_origin"), in_source_origin,
                        "<value of type const ::url::Origin&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("allow_patterns"), in_allow_patterns,
                        "<value of type std::vector<::network::mojom::CorsOriginPatternPtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("block_patterns"), in_block_patterns,
                        "<value of type std::vector<::network::mojom::CorsOriginPatternPtr>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kSetCorsOriginAccessListsForOrigin), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_SetCorsOriginAccessListsForOrigin_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->source_origin)::BaseType> source_origin_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
    in_source_origin,
    source_origin_fragment);

  params->source_origin.Set(
      source_origin_fragment.is_null() ? nullptr : source_origin_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->source_origin.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null source_origin in NetworkContext.SetCorsOriginAccessListsForOrigin request");
  mojo::internal::MessageFragment<
      typename decltype(params->allow_patterns)::BaseType>
      allow_patterns_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& allow_patterns_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::CorsOriginPatternDataView>>(
    in_allow_patterns,
    allow_patterns_fragment,
    &allow_patterns_validate_params);

  params->allow_patterns.Set(
      allow_patterns_fragment.is_null() ? nullptr : allow_patterns_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->allow_patterns.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null allow_patterns in NetworkContext.SetCorsOriginAccessListsForOrigin request");
  mojo::internal::MessageFragment<
      typename decltype(params->block_patterns)::BaseType>
      block_patterns_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& block_patterns_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::CorsOriginPatternDataView>>(
    in_block_patterns,
    block_patterns_fragment,
    &block_patterns_validate_params);

  params->block_patterns.Set(
      block_patterns_fragment.is_null() ? nullptr : block_patterns_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->block_patterns.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null block_patterns in NetworkContext.SetCorsOriginAccessListsForOrigin request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("SetCorsOriginAccessListsForOrigin");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_SetCorsOriginAccessListsForOrigin_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void NetworkContextProxy::DeleteDynamicDataForHost(
    const std::string& in_host, DeleteDynamicDataForHostCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkContext::DeleteDynamicDataForHost", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("host"), in_host,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kDeleteDynamicDataForHost), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_DeleteDynamicDataForHost_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->host)::BaseType> host_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_host,
    host_fragment);

  params->host.Set(
      host_fragment.is_null() ? nullptr : host_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->host.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null host in NetworkContext.DeleteDynamicDataForHost request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("DeleteDynamicDataForHost");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_DeleteDynamicDataForHost_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void NetworkContextProxy::SetSplitAuthCacheByNetworkAnonymizationKey(
    bool in_split_auth_cache_by_network_anonymization_key) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkContext::SetSplitAuthCacheByNetworkAnonymizationKey", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("split_auth_cache_by_network_anonymization_key"), in_split_auth_cache_by_network_anonymization_key,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kSetSplitAuthCacheByNetworkAnonymizationKey), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_SetSplitAuthCacheByNetworkAnonymizationKey_Params_Data> params(
          message);
  params.Allocate();

  params->split_auth_cache_by_network_anonymization_key = in_split_auth_cache_by_network_anonymization_key;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("SetSplitAuthCacheByNetworkAnonymizationKey");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NetworkContextProxy::SaveHttpAuthCacheProxyEntries(
    SaveHttpAuthCacheProxyEntriesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send network::mojom::NetworkContext::SaveHttpAuthCacheProxyEntries");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kSaveHttpAuthCacheProxyEntries), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_SaveHttpAuthCacheProxyEntries_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("SaveHttpAuthCacheProxyEntries");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_SaveHttpAuthCacheProxyEntries_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void NetworkContextProxy::LoadHttpAuthCacheProxyEntries(
    const ::base::UnguessableToken& in_cache_key, LoadHttpAuthCacheProxyEntriesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkContext::LoadHttpAuthCacheProxyEntries", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cache_key"), in_cache_key,
                        "<value of type const ::base::UnguessableToken&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kLoadHttpAuthCacheProxyEntries), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_LoadHttpAuthCacheProxyEntries_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->cache_key)::BaseType> cache_key_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_cache_key,
    cache_key_fragment);

  params->cache_key.Set(
      cache_key_fragment.is_null() ? nullptr : cache_key_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->cache_key.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null cache_key in NetworkContext.LoadHttpAuthCacheProxyEntries request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("LoadHttpAuthCacheProxyEntries");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_LoadHttpAuthCacheProxyEntries_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void NetworkContextProxy::AddAuthCacheEntry(
    const ::net::AuthChallengeInfo& in_challenge, const ::net::NetworkAnonymizationKey& in_network_anonymization_key, const ::net::AuthCredentials& in_credentials, AddAuthCacheEntryCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkContext::AddAuthCacheEntry", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("challenge"), in_challenge,
                        "<value of type const ::net::AuthChallengeInfo&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("network_anonymization_key"), in_network_anonymization_key,
                        "<value of type const ::net::NetworkAnonymizationKey&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("credentials"), in_credentials,
                        "<value of type const ::net::AuthCredentials&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kAddAuthCacheEntry), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_AddAuthCacheEntry_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->challenge)::BaseType> challenge_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::AuthChallengeInfoDataView>(
    in_challenge,
    challenge_fragment);

  params->challenge.Set(
      challenge_fragment.is_null() ? nullptr : challenge_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->challenge.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null challenge in NetworkContext.AddAuthCacheEntry request");
  mojo::internal::MessageFragment<decltype(params->network_anonymization_key)>
      network_anonymization_key_fragment(params.message());
  network_anonymization_key_fragment.Claim(&params->network_anonymization_key);
  
  mojo::internal::Serialize<::network::mojom::NetworkAnonymizationKeyDataView>(
    in_network_anonymization_key,
    network_anonymization_key_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->network_anonymization_key.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null network_anonymization_key in NetworkContext.AddAuthCacheEntry request");
  mojo::internal::MessageFragment<
      typename decltype(params->credentials)::BaseType> credentials_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::AuthCredentialsDataView>(
    in_credentials,
    credentials_fragment);

  params->credentials.Set(
      credentials_fragment.is_null() ? nullptr : credentials_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->credentials.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null credentials in NetworkContext.AddAuthCacheEntry request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("AddAuthCacheEntry");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_AddAuthCacheEntry_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void NetworkContextProxy::SetCorsNonWildcardRequestHeadersSupport(
    bool in_value) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkContext::SetCorsNonWildcardRequestHeadersSupport", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("value"), in_value,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kSetCorsNonWildcardRequestHeadersSupport), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_SetCorsNonWildcardRequestHeadersSupport_Params_Data> params(
          message);
  params.Allocate();

  params->value = in_value;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("SetCorsNonWildcardRequestHeadersSupport");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NetworkContextProxy::LookupServerBasicAuthCredentials(
    const ::GURL& in_url, const ::net::NetworkAnonymizationKey& in_network_anonymization_key, LookupServerBasicAuthCredentialsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkContext::LookupServerBasicAuthCredentials", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("network_anonymization_key"), in_network_anonymization_key,
                        "<value of type const ::net::NetworkAnonymizationKey&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kLookupServerBasicAuthCredentials), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_LookupServerBasicAuthCredentials_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in NetworkContext.LookupServerBasicAuthCredentials request");
  mojo::internal::MessageFragment<decltype(params->network_anonymization_key)>
      network_anonymization_key_fragment(params.message());
  network_anonymization_key_fragment.Claim(&params->network_anonymization_key);
  
  mojo::internal::Serialize<::network::mojom::NetworkAnonymizationKeyDataView>(
    in_network_anonymization_key,
    network_anonymization_key_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->network_anonymization_key.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null network_anonymization_key in NetworkContext.LookupServerBasicAuthCredentials request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("LookupServerBasicAuthCredentials");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_LookupServerBasicAuthCredentials_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool NetworkContextProxy::EnableStaticKeyPinningForTesting(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "Call network::mojom::NetworkContext::EnableStaticKeyPinningForTesting (sync)");
#else
  TRACE_EVENT0("mojom", "NetworkContext::EnableStaticKeyPinningForTesting");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kEnableStaticKeyPinningForTesting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_EnableStaticKeyPinningForTesting_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("EnableStaticKeyPinningForTesting");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_EnableStaticKeyPinningForTesting_HandleSyncResponse(
          &result));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END0("mojom", "NetworkContext::EnableStaticKeyPinningForTesting");
#endif
  return result;
}

void NetworkContextProxy::EnableStaticKeyPinningForTesting(
    EnableStaticKeyPinningForTestingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send network::mojom::NetworkContext::EnableStaticKeyPinningForTesting");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kEnableStaticKeyPinningForTesting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_EnableStaticKeyPinningForTesting_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("EnableStaticKeyPinningForTesting");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_EnableStaticKeyPinningForTesting_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void NetworkContextProxy::VerifyCertificateForTesting(
    const ::scoped_refptr<::net::X509Certificate>& in_certificate, const std::string& in_hostname, const std::string& in_ocsp_response, const std::string& in_sct_list, VerifyCertificateForTestingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkContext::VerifyCertificateForTesting", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("certificate"), in_certificate,
                        "<value of type const ::scoped_refptr<::net::X509Certificate>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("hostname"), in_hostname,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ocsp_response"), in_ocsp_response,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sct_list"), in_sct_list,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kVerifyCertificateForTesting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_VerifyCertificateForTesting_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->certificate)::BaseType> certificate_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::X509CertificateDataView>(
    in_certificate,
    certificate_fragment);

  params->certificate.Set(
      certificate_fragment.is_null() ? nullptr : certificate_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->certificate.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null certificate in NetworkContext.VerifyCertificateForTesting request");
  mojo::internal::MessageFragment<
      typename decltype(params->hostname)::BaseType> hostname_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_hostname,
    hostname_fragment);

  params->hostname.Set(
      hostname_fragment.is_null() ? nullptr : hostname_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->hostname.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null hostname in NetworkContext.VerifyCertificateForTesting request");
  mojo::internal::MessageFragment<
      typename decltype(params->ocsp_response)::BaseType> ocsp_response_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_ocsp_response,
    ocsp_response_fragment);

  params->ocsp_response.Set(
      ocsp_response_fragment.is_null() ? nullptr : ocsp_response_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->ocsp_response.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null ocsp_response in NetworkContext.VerifyCertificateForTesting request");
  mojo::internal::MessageFragment<
      typename decltype(params->sct_list)::BaseType> sct_list_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_sct_list,
    sct_list_fragment);

  params->sct_list.Set(
      sct_list_fragment.is_null() ? nullptr : sct_list_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->sct_list.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null sct_list in NetworkContext.VerifyCertificateForTesting request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("VerifyCertificateForTesting");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_VerifyCertificateForTesting_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool NetworkContextProxy::GetTrustAnchorIDsForTesting(
    std::vector<std::vector<uint8_t>>* out_param_trust_anchor_ids) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "Call network::mojom::NetworkContext::GetTrustAnchorIDsForTesting (sync)");
#else
  TRACE_EVENT0("mojom", "NetworkContext::GetTrustAnchorIDsForTesting");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kGetTrustAnchorIDsForTesting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_GetTrustAnchorIDsForTesting_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("GetTrustAnchorIDsForTesting");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_GetTrustAnchorIDsForTesting_HandleSyncResponse(
          &result, out_param_trust_anchor_ids));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "NetworkContext::GetTrustAnchorIDsForTesting", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("trust_anchor_ids"), out_param_trust_anchor_ids,
                        "<value of type const std::vector<std::vector<uint8_t>>&>");
   });
#endif
  return result;
}

void NetworkContextProxy::GetTrustAnchorIDsForTesting(
    GetTrustAnchorIDsForTestingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send network::mojom::NetworkContext::GetTrustAnchorIDsForTesting");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kGetTrustAnchorIDsForTesting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_GetTrustAnchorIDsForTesting_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("GetTrustAnchorIDsForTesting");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_GetTrustAnchorIDsForTesting_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool NetworkContextProxy::AddDomainReliabilityContextForTesting(
    const ::url::Origin& param_origin, const ::GURL& param_upload_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call network::mojom::NetworkContext::AddDomainReliabilityContextForTesting (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("origin"), param_origin,
                        "<value of type const ::url::Origin&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("upload_url"), param_upload_url,
                        "<value of type const ::GURL&>");
   });
#else
  TRACE_EVENT0("mojom", "NetworkContext::AddDomainReliabilityContextForTesting");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kAddDomainReliabilityContextForTesting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_AddDomainReliabilityContextForTesting_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->origin)::BaseType> origin_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
    param_origin,
    origin_fragment);

  params->origin.Set(
      origin_fragment.is_null() ? nullptr : origin_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->origin.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null origin in NetworkContext.AddDomainReliabilityContextForTesting request");
  mojo::internal::MessageFragment<
      typename decltype(params->upload_url)::BaseType> upload_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    param_upload_url,
    upload_url_fragment);

  params->upload_url.Set(
      upload_url_fragment.is_null() ? nullptr : upload_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->upload_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null upload_url in NetworkContext.AddDomainReliabilityContextForTesting request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("AddDomainReliabilityContextForTesting");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_AddDomainReliabilityContextForTesting_HandleSyncResponse(
          &result));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END0("mojom", "NetworkContext::AddDomainReliabilityContextForTesting");
#endif
  return result;
}

void NetworkContextProxy::AddDomainReliabilityContextForTesting(
    const ::url::Origin& in_origin, const ::GURL& in_upload_url, AddDomainReliabilityContextForTestingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkContext::AddDomainReliabilityContextForTesting", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("origin"), in_origin,
                        "<value of type const ::url::Origin&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("upload_url"), in_upload_url,
                        "<value of type const ::GURL&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kAddDomainReliabilityContextForTesting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_AddDomainReliabilityContextForTesting_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->origin)::BaseType> origin_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
    in_origin,
    origin_fragment);

  params->origin.Set(
      origin_fragment.is_null() ? nullptr : origin_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->origin.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null origin in NetworkContext.AddDomainReliabilityContextForTesting request");
  mojo::internal::MessageFragment<
      typename decltype(params->upload_url)::BaseType> upload_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_upload_url,
    upload_url_fragment);

  params->upload_url.Set(
      upload_url_fragment.is_null() ? nullptr : upload_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->upload_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null upload_url in NetworkContext.AddDomainReliabilityContextForTesting request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("AddDomainReliabilityContextForTesting");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_AddDomainReliabilityContextForTesting_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool NetworkContextProxy::ForceDomainReliabilityUploadsForTesting(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "Call network::mojom::NetworkContext::ForceDomainReliabilityUploadsForTesting (sync)");
#else
  TRACE_EVENT0("mojom", "NetworkContext::ForceDomainReliabilityUploadsForTesting");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kForceDomainReliabilityUploadsForTesting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_ForceDomainReliabilityUploadsForTesting_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("ForceDomainReliabilityUploadsForTesting");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_ForceDomainReliabilityUploadsForTesting_HandleSyncResponse(
          &result));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END0("mojom", "NetworkContext::ForceDomainReliabilityUploadsForTesting");
#endif
  return result;
}

void NetworkContextProxy::ForceDomainReliabilityUploadsForTesting(
    ForceDomainReliabilityUploadsForTestingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send network::mojom::NetworkContext::ForceDomainReliabilityUploadsForTesting");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kForceDomainReliabilityUploadsForTesting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_ForceDomainReliabilityUploadsForTesting_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("ForceDomainReliabilityUploadsForTesting");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_ForceDomainReliabilityUploadsForTesting_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void NetworkContextProxy::SetSCTAuditingMode(
    SCTAuditingMode in_mode) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkContext::SetSCTAuditingMode", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("mode"), in_mode,
                        "<value of type SCTAuditingMode>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kSetSCTAuditingMode), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_SetSCTAuditingMode_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::network::mojom::SCTAuditingMode>(
    in_mode,
    &params->mode);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("SetSCTAuditingMode");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NetworkContextProxy::GetSharedDictionaryUsageInfo(
    GetSharedDictionaryUsageInfoCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send network::mojom::NetworkContext::GetSharedDictionaryUsageInfo");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kGetSharedDictionaryUsageInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_GetSharedDictionaryUsageInfo_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("GetSharedDictionaryUsageInfo");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_GetSharedDictionaryUsageInfo_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void NetworkContextProxy::GetSharedDictionaryInfo(
    const ::net::SharedDictionaryIsolationKey& in_isolation_key, GetSharedDictionaryInfoCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkContext::GetSharedDictionaryInfo", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("isolation_key"), in_isolation_key,
                        "<value of type const ::net::SharedDictionaryIsolationKey&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kGetSharedDictionaryInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_GetSharedDictionaryInfo_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->isolation_key)::BaseType> isolation_key_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::SharedDictionaryIsolationKeyDataView>(
    in_isolation_key,
    isolation_key_fragment);

  params->isolation_key.Set(
      isolation_key_fragment.is_null() ? nullptr : isolation_key_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->isolation_key.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null isolation_key in NetworkContext.GetSharedDictionaryInfo request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("GetSharedDictionaryInfo");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_GetSharedDictionaryInfo_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void NetworkContextProxy::GetSharedDictionaryOriginsBetween(
    ::base::Time in_start_time, ::base::Time in_end_time, GetSharedDictionaryOriginsBetweenCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkContext::GetSharedDictionaryOriginsBetween", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("start_time"), in_start_time,
                        "<value of type ::base::Time>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("end_time"), in_end_time,
                        "<value of type ::base::Time>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kGetSharedDictionaryOriginsBetween), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_GetSharedDictionaryOriginsBetween_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->start_time)::BaseType> start_time_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
    in_start_time,
    start_time_fragment);

  params->start_time.Set(
      start_time_fragment.is_null() ? nullptr : start_time_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->start_time.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null start_time in NetworkContext.GetSharedDictionaryOriginsBetween request");
  mojo::internal::MessageFragment<
      typename decltype(params->end_time)::BaseType> end_time_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
    in_end_time,
    end_time_fragment);

  params->end_time.Set(
      end_time_fragment.is_null() ? nullptr : end_time_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->end_time.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null end_time in NetworkContext.GetSharedDictionaryOriginsBetween request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("GetSharedDictionaryOriginsBetween");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_GetSharedDictionaryOriginsBetween_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void NetworkContextProxy::SetSharedDictionaryCacheMaxSize(
    uint64_t in_cache_max_size) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkContext::SetSharedDictionaryCacheMaxSize", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cache_max_size"), in_cache_max_size,
                        "<value of type uint64_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kSetSharedDictionaryCacheMaxSize), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_SetSharedDictionaryCacheMaxSize_Params_Data> params(
          message);
  params.Allocate();

  params->cache_max_size = in_cache_max_size;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("SetSharedDictionaryCacheMaxSize");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NetworkContextProxy::PreloadSharedDictionaryInfoForDocument(
    const std::vector<::GURL>& in_urls, ::mojo::PendingReceiver<PreloadedSharedDictionaryInfoHandle> in_preload_handle) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkContext::PreloadSharedDictionaryInfoForDocument", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("urls"), in_urls,
                        "<value of type const std::vector<::GURL>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("preload_handle"), in_preload_handle,
                        "<value of type ::mojo::PendingReceiver<PreloadedSharedDictionaryInfoHandle>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kPreloadSharedDictionaryInfoForDocument), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_PreloadSharedDictionaryInfoForDocument_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->urls)::BaseType>
      urls_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& urls_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::url::mojom::UrlDataView>>(
    in_urls,
    urls_fragment,
    &urls_validate_params);

  params->urls.Set(
      urls_fragment.is_null() ? nullptr : urls_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->urls.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null urls in NetworkContext.PreloadSharedDictionaryInfoForDocument request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::PreloadedSharedDictionaryInfoHandleInterfaceBase>>(
    in_preload_handle,
    &params->preload_handle,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->preload_handle)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid preload_handle in NetworkContext.PreloadSharedDictionaryInfoForDocument request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("PreloadSharedDictionaryInfoForDocument");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NetworkContextProxy::HasPreloadedSharedDictionaryInfoForTesting(
    HasPreloadedSharedDictionaryInfoForTestingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send network::mojom::NetworkContext::HasPreloadedSharedDictionaryInfoForTesting");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kHasPreloadedSharedDictionaryInfoForTesting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("HasPreloadedSharedDictionaryInfoForTesting");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void NetworkContextProxy::ResourceSchedulerClientVisibilityChanged(
    const ::base::UnguessableToken& in_client_token, bool in_visible) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkContext::ResourceSchedulerClientVisibilityChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client_token"), in_client_token,
                        "<value of type const ::base::UnguessableToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("visible"), in_visible,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kResourceSchedulerClientVisibilityChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_ResourceSchedulerClientVisibilityChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->client_token)::BaseType> client_token_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_client_token,
    client_token_fragment);

  params->client_token.Set(
      client_token_fragment.is_null() ? nullptr : client_token_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->client_token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null client_token in NetworkContext.ResourceSchedulerClientVisibilityChanged request");

  params->visible = in_visible;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("ResourceSchedulerClientVisibilityChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NetworkContextProxy::FlushCachedClientCertIfNeeded(
    const ::net::HostPortPair& in_host, const ::scoped_refptr<::net::X509Certificate>& in_certificate) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkContext::FlushCachedClientCertIfNeeded", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("host"), in_host,
                        "<value of type const ::net::HostPortPair&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("certificate"), in_certificate,
                        "<value of type const ::scoped_refptr<::net::X509Certificate>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kFlushCachedClientCertIfNeeded), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_FlushCachedClientCertIfNeeded_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->host)::BaseType> host_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::HostPortPairDataView>(
    in_host,
    host_fragment);

  params->host.Set(
      host_fragment.is_null() ? nullptr : host_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->host.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null host in NetworkContext.FlushCachedClientCertIfNeeded request");
  mojo::internal::MessageFragment<
      typename decltype(params->certificate)::BaseType> certificate_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::X509CertificateDataView>(
    in_certificate,
    certificate_fragment);

  params->certificate.Set(
      certificate_fragment.is_null() ? nullptr : certificate_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->certificate.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null certificate in NetworkContext.FlushCachedClientCertIfNeeded request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("FlushCachedClientCertIfNeeded");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NetworkContextProxy::FlushMatchingCachedClientCert(
    const ::scoped_refptr<::net::X509Certificate>& in_certificate) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkContext::FlushMatchingCachedClientCert", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("certificate"), in_certificate,
                        "<value of type const ::scoped_refptr<::net::X509Certificate>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kFlushMatchingCachedClientCert), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_FlushMatchingCachedClientCert_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->certificate)::BaseType> certificate_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::X509CertificateDataView>(
    in_certificate,
    certificate_fragment);

  params->certificate.Set(
      certificate_fragment.is_null() ? nullptr : certificate_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->certificate.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null certificate in NetworkContext.FlushMatchingCachedClientCert request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("FlushMatchingCachedClientCert");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NetworkContextProxy::SetCookieDeprecationLabel(
    const std::optional<std::string>& in_label) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkContext::SetCookieDeprecationLabel", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("label"), in_label,
                        "<value of type const std::optional<std::string>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kSetCookieDeprecationLabel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_SetCookieDeprecationLabel_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->label)::BaseType> label_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_label,
    label_fragment);

  params->label.Set(
      label_fragment.is_null() ? nullptr : label_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("SetCookieDeprecationLabel");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NetworkContextProxy::RevokeNetworkForNonces(
    const std::vector<::base::UnguessableToken>& in_nonces, RevokeNetworkForNoncesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkContext::RevokeNetworkForNonces", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("nonces"), in_nonces,
                        "<value of type const std::vector<::base::UnguessableToken>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kRevokeNetworkForNonces), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_RevokeNetworkForNonces_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->nonces)::BaseType>
      nonces_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& nonces_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::mojo_base::mojom::UnguessableTokenDataView>>(
    in_nonces,
    nonces_fragment,
    &nonces_validate_params);

  params->nonces.Set(
      nonces_fragment.is_null() ? nullptr : nonces_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->nonces.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null nonces in NetworkContext.RevokeNetworkForNonces request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("RevokeNetworkForNonces");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_RevokeNetworkForNonces_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void NetworkContextProxy::ClearNonces(
    const std::vector<::base::UnguessableToken>& in_nonces) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkContext::ClearNonces", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("nonces"), in_nonces,
                        "<value of type const std::vector<::base::UnguessableToken>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kClearNonces), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_ClearNonces_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->nonces)::BaseType>
      nonces_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& nonces_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::mojo_base::mojom::UnguessableTokenDataView>>(
    in_nonces,
    nonces_fragment,
    &nonces_validate_params);

  params->nonces.Set(
      nonces_fragment.is_null() ? nullptr : nonces_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->nonces.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null nonces in NetworkContext.ClearNonces request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("ClearNonces");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NetworkContextProxy::ExemptUrlFromNetworkRevocationForNonce(
    const ::GURL& in_exempted_url, const ::base::UnguessableToken& in_nonce, ExemptUrlFromNetworkRevocationForNonceCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkContext::ExemptUrlFromNetworkRevocationForNonce", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("exempted_url"), in_exempted_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("nonce"), in_nonce,
                        "<value of type const ::base::UnguessableToken&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kExemptUrlFromNetworkRevocationForNonce), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_ExemptUrlFromNetworkRevocationForNonce_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->exempted_url)::BaseType> exempted_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_exempted_url,
    exempted_url_fragment);

  params->exempted_url.Set(
      exempted_url_fragment.is_null() ? nullptr : exempted_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->exempted_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null exempted_url in NetworkContext.ExemptUrlFromNetworkRevocationForNonce request");
  mojo::internal::MessageFragment<
      typename decltype(params->nonce)::BaseType> nonce_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_nonce,
    nonce_fragment);

  params->nonce.Set(
      nonce_fragment.is_null() ? nullptr : nonce_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->nonce.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null nonce in NetworkContext.ExemptUrlFromNetworkRevocationForNonce request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("ExemptUrlFromNetworkRevocationForNonce");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_ExemptUrlFromNetworkRevocationForNonce_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void NetworkContextProxy::Prefetch(
    int32_t in_request_id, uint32_t in_options, const ::network::ResourceRequest& in_request, const ::net::MutableNetworkTrafficAnnotationTag& in_traffic_annotation) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkContext::Prefetch", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_id"), in_request_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request"), in_request,
                        "<value of type const ::network::ResourceRequest&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("traffic_annotation"), in_traffic_annotation,
                        "<value of type const ::net::MutableNetworkTrafficAnnotationTag&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kPrefetch), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_Prefetch_Params_Data> params(
          message);
  params.Allocate();

  params->request_id = in_request_id;

  params->options = in_options;
  mojo::internal::MessageFragment<
      typename decltype(params->request)::BaseType> request_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::URLRequestDataView>(
    in_request,
    request_fragment);

  params->request.Set(
      request_fragment.is_null() ? nullptr : request_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->request.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null request in NetworkContext.Prefetch request");
  mojo::internal::MessageFragment<
      typename decltype(params->traffic_annotation)::BaseType> traffic_annotation_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::MutableNetworkTrafficAnnotationTagDataView>(
    in_traffic_annotation,
    traffic_annotation_fragment);

  params->traffic_annotation.Set(
      traffic_annotation_fragment.is_null() ? nullptr : traffic_annotation_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->traffic_annotation.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null traffic_annotation in NetworkContext.Prefetch request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("Prefetch");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NetworkContextProxy::GetBoundNetworkForTesting(
    GetBoundNetworkForTestingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send network::mojom::NetworkContext::GetBoundNetworkForTesting");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kGetBoundNetworkForTesting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_GetBoundNetworkForTesting_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("GetBoundNetworkForTesting");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_GetBoundNetworkForTesting_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void NetworkContextProxy::GetDeviceBoundSessionManager(
    ::mojo::PendingReceiver<::network::mojom::DeviceBoundSessionManager> in_device_bound_session_manager) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkContext::GetDeviceBoundSessionManager", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_bound_session_manager"), in_device_bound_session_manager,
                        "<value of type ::mojo::PendingReceiver<::network::mojom::DeviceBoundSessionManager>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kGetDeviceBoundSessionManager), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_GetDeviceBoundSessionManager_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::DeviceBoundSessionManagerInterfaceBase>>(
    in_device_bound_session_manager,
    &params->device_bound_session_manager,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->device_bound_session_manager)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid device_bound_session_manager in NetworkContext.GetDeviceBoundSessionManager request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("GetDeviceBoundSessionManager");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class NetworkContext_ClearTrustTokenData_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkContext::ClearTrustTokenDataCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkContext_ClearTrustTokenData_ProxyToResponder> proxy(
        new NetworkContext_ClearTrustTokenData_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkContext_ClearTrustTokenData_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_ClearTrustTokenData_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkContext_ClearTrustTokenData_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::ClearTrustTokenDataCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool NetworkContext_ClearTrustTokenData_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkContext_ClearTrustTokenData_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_ClearTrustTokenData_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetworkContext.7
  bool success = true;
  NetworkContext_ClearTrustTokenData_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 7, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void NetworkContext_ClearTrustTokenData_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply network::mojom::NetworkContext::ClearTrustTokenData");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kClearTrustTokenData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_ClearTrustTokenData_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("ClearTrustTokenData");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContext_ClearTrustTokenSessionOnlyData_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkContext::ClearTrustTokenSessionOnlyDataCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkContext_ClearTrustTokenSessionOnlyData_ProxyToResponder> proxy(
        new NetworkContext_ClearTrustTokenSessionOnlyData_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkContext_ClearTrustTokenSessionOnlyData_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_ClearTrustTokenSessionOnlyData_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkContext_ClearTrustTokenSessionOnlyData_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::ClearTrustTokenSessionOnlyDataCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_any_data_deleted);
};

bool NetworkContext_ClearTrustTokenSessionOnlyData_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkContext_ClearTrustTokenSessionOnlyData_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_ClearTrustTokenSessionOnlyData_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetworkContext.8
  bool success = true;
  bool p_any_data_deleted{};
  NetworkContext_ClearTrustTokenSessionOnlyData_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_any_data_deleted = input_data_view.any_data_deleted();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 8, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_any_data_deleted));
  }
  return true;
}

void NetworkContext_ClearTrustTokenSessionOnlyData_ProxyToResponder::Run(
    bool in_any_data_deleted) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::NetworkContext::ClearTrustTokenSessionOnlyData", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("any_data_deleted"), in_any_data_deleted,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kClearTrustTokenSessionOnlyData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_ClearTrustTokenSessionOnlyData_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->any_data_deleted = in_any_data_deleted;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("ClearTrustTokenSessionOnlyData");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContext_GetStoredTrustTokenCounts_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkContext::GetStoredTrustTokenCountsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkContext_GetStoredTrustTokenCounts_ProxyToResponder> proxy(
        new NetworkContext_GetStoredTrustTokenCounts_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkContext_GetStoredTrustTokenCounts_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_GetStoredTrustTokenCounts_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkContext_GetStoredTrustTokenCounts_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::GetStoredTrustTokenCountsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<::network::mojom::StoredTrustTokensForIssuerPtr> in_tokens);
};

bool NetworkContext_GetStoredTrustTokenCounts_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkContext_GetStoredTrustTokenCounts_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_GetStoredTrustTokenCounts_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetworkContext.9
  bool success = true;
  std::vector<::network::mojom::StoredTrustTokensForIssuerPtr> p_tokens{};
  NetworkContext_GetStoredTrustTokenCounts_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadTokens(&p_tokens))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 9, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_tokens));
  }
  return true;
}

void NetworkContext_GetStoredTrustTokenCounts_ProxyToResponder::Run(
    std::vector<::network::mojom::StoredTrustTokensForIssuerPtr> in_tokens) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::NetworkContext::GetStoredTrustTokenCounts", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tokens"), in_tokens,
                        "<value of type std::vector<::network::mojom::StoredTrustTokensForIssuerPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kGetStoredTrustTokenCounts), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_GetStoredTrustTokenCounts_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->tokens)::BaseType>
      tokens_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& tokens_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::StoredTrustTokensForIssuerDataView>>(
    in_tokens,
    tokens_fragment,
    &tokens_validate_params);

  params->tokens.Set(
      tokens_fragment.is_null() ? nullptr : tokens_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->tokens.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null tokens in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("GetStoredTrustTokenCounts");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContext_GetPrivateStateTokenRedemptionRecords_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkContext::GetPrivateStateTokenRedemptionRecordsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkContext_GetPrivateStateTokenRedemptionRecords_ProxyToResponder> proxy(
        new NetworkContext_GetPrivateStateTokenRedemptionRecords_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkContext_GetPrivateStateTokenRedemptionRecords_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_GetPrivateStateTokenRedemptionRecords_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkContext_GetPrivateStateTokenRedemptionRecords_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::GetPrivateStateTokenRedemptionRecordsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      base::flat_map<::url::Origin, std::vector<::network::mojom::ToplevelRedemptionRecordPtr>> in_issuer_redemption_record_map);
};

bool NetworkContext_GetPrivateStateTokenRedemptionRecords_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkContext_GetPrivateStateTokenRedemptionRecords_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_GetPrivateStateTokenRedemptionRecords_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetworkContext.10
  bool success = true;
  base::flat_map<::url::Origin, std::vector<::network::mojom::ToplevelRedemptionRecordPtr>> p_issuer_redemption_record_map{};
  NetworkContext_GetPrivateStateTokenRedemptionRecords_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadIssuerRedemptionRecordMap(&p_issuer_redemption_record_map))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 10, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_issuer_redemption_record_map));
  }
  return true;
}

void NetworkContext_GetPrivateStateTokenRedemptionRecords_ProxyToResponder::Run(
    base::flat_map<::url::Origin, std::vector<::network::mojom::ToplevelRedemptionRecordPtr>> in_issuer_redemption_record_map) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::NetworkContext::GetPrivateStateTokenRedemptionRecords", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("issuer_redemption_record_map"), in_issuer_redemption_record_map,
                        "<value of type base::flat_map<::url::Origin, std::vector<::network::mojom::ToplevelRedemptionRecordPtr>>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kGetPrivateStateTokenRedemptionRecords), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_GetPrivateStateTokenRedemptionRecords_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->issuer_redemption_record_map)::BaseType>
      issuer_redemption_record_map_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& issuer_redemption_record_map_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
  
  mojo::internal::Serialize<mojo::MapDataView<::url::mojom::OriginDataView, mojo::ArrayDataView<::network::mojom::ToplevelRedemptionRecordDataView>>>(
    in_issuer_redemption_record_map,
    issuer_redemption_record_map_fragment,
    &issuer_redemption_record_map_validate_params);

  params->issuer_redemption_record_map.Set(
      issuer_redemption_record_map_fragment.is_null() ? nullptr : issuer_redemption_record_map_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->issuer_redemption_record_map.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null issuer_redemption_record_map in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("GetPrivateStateTokenRedemptionRecords");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContext_DeleteStoredTrustTokens_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkContext::DeleteStoredTrustTokensCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkContext_DeleteStoredTrustTokens_ProxyToResponder> proxy(
        new NetworkContext_DeleteStoredTrustTokens_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkContext_DeleteStoredTrustTokens_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_DeleteStoredTrustTokens_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkContext_DeleteStoredTrustTokens_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::DeleteStoredTrustTokensCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::network::mojom::DeleteStoredTrustTokensStatus in_status);
};

bool NetworkContext_DeleteStoredTrustTokens_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkContext_DeleteStoredTrustTokens_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_DeleteStoredTrustTokens_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetworkContext.11
  bool success = true;
  ::network::mojom::DeleteStoredTrustTokensStatus p_status{};
  NetworkContext_DeleteStoredTrustTokens_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 11, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status));
  }
  return true;
}

void NetworkContext_DeleteStoredTrustTokens_ProxyToResponder::Run(
    ::network::mojom::DeleteStoredTrustTokensStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::NetworkContext::DeleteStoredTrustTokens", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::network::mojom::DeleteStoredTrustTokensStatus>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kDeleteStoredTrustTokens), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_DeleteStoredTrustTokens_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::network::mojom::DeleteStoredTrustTokensStatus>(
    in_status,
    &params->status);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("DeleteStoredTrustTokens");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContext_ClearNetworkingHistoryBetween_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkContext::ClearNetworkingHistoryBetweenCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkContext_ClearNetworkingHistoryBetween_ProxyToResponder> proxy(
        new NetworkContext_ClearNetworkingHistoryBetween_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkContext_ClearNetworkingHistoryBetween_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_ClearNetworkingHistoryBetween_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkContext_ClearNetworkingHistoryBetween_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::ClearNetworkingHistoryBetweenCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool NetworkContext_ClearNetworkingHistoryBetween_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkContext_ClearNetworkingHistoryBetween_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_ClearNetworkingHistoryBetween_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetworkContext.14
  bool success = true;
  NetworkContext_ClearNetworkingHistoryBetween_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 14, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void NetworkContext_ClearNetworkingHistoryBetween_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply network::mojom::NetworkContext::ClearNetworkingHistoryBetween");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kClearNetworkingHistoryBetween), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_ClearNetworkingHistoryBetween_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("ClearNetworkingHistoryBetween");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContext_ClearHttpCache_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkContext::ClearHttpCacheCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkContext_ClearHttpCache_ProxyToResponder> proxy(
        new NetworkContext_ClearHttpCache_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkContext_ClearHttpCache_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_ClearHttpCache_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkContext_ClearHttpCache_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::ClearHttpCacheCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool NetworkContext_ClearHttpCache_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkContext_ClearHttpCache_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_ClearHttpCache_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetworkContext.15
  bool success = true;
  NetworkContext_ClearHttpCache_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 15, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void NetworkContext_ClearHttpCache_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply network::mojom::NetworkContext::ClearHttpCache");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kClearHttpCache), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_ClearHttpCache_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("ClearHttpCache");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContext_ComputeHttpCacheSize_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkContext::ComputeHttpCacheSizeCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkContext_ComputeHttpCacheSize_ProxyToResponder> proxy(
        new NetworkContext_ComputeHttpCacheSize_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkContext_ComputeHttpCacheSize_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_ComputeHttpCacheSize_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkContext_ComputeHttpCacheSize_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::ComputeHttpCacheSizeCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_is_upper_bound, int64_t in_size_or_error);
};

bool NetworkContext_ComputeHttpCacheSize_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkContext_ComputeHttpCacheSize_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_ComputeHttpCacheSize_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetworkContext.16
  bool success = true;
  bool p_is_upper_bound{};
  int64_t p_size_or_error{};
  NetworkContext_ComputeHttpCacheSize_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_is_upper_bound = input_data_view.is_upper_bound();
  if (success)
    p_size_or_error = input_data_view.size_or_error();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 16, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_is_upper_bound), 
std::move(p_size_or_error));
  }
  return true;
}

void NetworkContext_ComputeHttpCacheSize_ProxyToResponder::Run(
    bool in_is_upper_bound, int64_t in_size_or_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::NetworkContext::ComputeHttpCacheSize", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_upper_bound"), in_is_upper_bound,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("size_or_error"), in_size_or_error,
                        "<value of type int64_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kComputeHttpCacheSize), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_ComputeHttpCacheSize_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->is_upper_bound = in_is_upper_bound;

  params->size_or_error = in_size_or_error;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("ComputeHttpCacheSize");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContext_ClearHostCache_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkContext::ClearHostCacheCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkContext_ClearHostCache_ProxyToResponder> proxy(
        new NetworkContext_ClearHostCache_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkContext_ClearHostCache_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_ClearHostCache_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkContext_ClearHostCache_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::ClearHostCacheCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool NetworkContext_ClearHostCache_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkContext_ClearHostCache_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_ClearHostCache_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetworkContext.18
  bool success = true;
  NetworkContext_ClearHostCache_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 18, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void NetworkContext_ClearHostCache_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply network::mojom::NetworkContext::ClearHostCache");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kClearHostCache), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_ClearHostCache_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("ClearHostCache");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContext_ClearHttpAuthCache_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkContext::ClearHttpAuthCacheCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkContext_ClearHttpAuthCache_ProxyToResponder> proxy(
        new NetworkContext_ClearHttpAuthCache_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkContext_ClearHttpAuthCache_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_ClearHttpAuthCache_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkContext_ClearHttpAuthCache_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::ClearHttpAuthCacheCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool NetworkContext_ClearHttpAuthCache_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkContext_ClearHttpAuthCache_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_ClearHttpAuthCache_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetworkContext.19
  bool success = true;
  NetworkContext_ClearHttpAuthCache_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 19, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void NetworkContext_ClearHttpAuthCache_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply network::mojom::NetworkContext::ClearHttpAuthCache");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kClearHttpAuthCache), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_ClearHttpAuthCache_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("ClearHttpAuthCache");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContext_ClearCorsPreflightCache_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkContext::ClearCorsPreflightCacheCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkContext_ClearCorsPreflightCache_ProxyToResponder> proxy(
        new NetworkContext_ClearCorsPreflightCache_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkContext_ClearCorsPreflightCache_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_ClearCorsPreflightCache_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkContext_ClearCorsPreflightCache_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::ClearCorsPreflightCacheCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool NetworkContext_ClearCorsPreflightCache_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkContext_ClearCorsPreflightCache_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_ClearCorsPreflightCache_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetworkContext.20
  bool success = true;
  NetworkContext_ClearCorsPreflightCache_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 20, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void NetworkContext_ClearCorsPreflightCache_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply network::mojom::NetworkContext::ClearCorsPreflightCache");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kClearCorsPreflightCache), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_ClearCorsPreflightCache_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("ClearCorsPreflightCache");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContext_ClearReportingCacheReports_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkContext::ClearReportingCacheReportsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkContext_ClearReportingCacheReports_ProxyToResponder> proxy(
        new NetworkContext_ClearReportingCacheReports_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkContext_ClearReportingCacheReports_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_ClearReportingCacheReports_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkContext_ClearReportingCacheReports_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::ClearReportingCacheReportsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool NetworkContext_ClearReportingCacheReports_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkContext_ClearReportingCacheReports_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_ClearReportingCacheReports_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetworkContext.21
  bool success = true;
  NetworkContext_ClearReportingCacheReports_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 21, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void NetworkContext_ClearReportingCacheReports_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply network::mojom::NetworkContext::ClearReportingCacheReports");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kClearReportingCacheReports), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_ClearReportingCacheReports_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("ClearReportingCacheReports");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContext_ClearReportingCacheClients_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkContext::ClearReportingCacheClientsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkContext_ClearReportingCacheClients_ProxyToResponder> proxy(
        new NetworkContext_ClearReportingCacheClients_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkContext_ClearReportingCacheClients_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_ClearReportingCacheClients_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkContext_ClearReportingCacheClients_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::ClearReportingCacheClientsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool NetworkContext_ClearReportingCacheClients_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkContext_ClearReportingCacheClients_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_ClearReportingCacheClients_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetworkContext.22
  bool success = true;
  NetworkContext_ClearReportingCacheClients_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 22, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void NetworkContext_ClearReportingCacheClients_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply network::mojom::NetworkContext::ClearReportingCacheClients");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kClearReportingCacheClients), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_ClearReportingCacheClients_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("ClearReportingCacheClients");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContext_ClearNetworkErrorLogging_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkContext::ClearNetworkErrorLoggingCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkContext_ClearNetworkErrorLogging_ProxyToResponder> proxy(
        new NetworkContext_ClearNetworkErrorLogging_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkContext_ClearNetworkErrorLogging_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_ClearNetworkErrorLogging_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkContext_ClearNetworkErrorLogging_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::ClearNetworkErrorLoggingCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool NetworkContext_ClearNetworkErrorLogging_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkContext_ClearNetworkErrorLogging_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_ClearNetworkErrorLogging_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetworkContext.23
  bool success = true;
  NetworkContext_ClearNetworkErrorLogging_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 23, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void NetworkContext_ClearNetworkErrorLogging_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply network::mojom::NetworkContext::ClearNetworkErrorLogging");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kClearNetworkErrorLogging), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_ClearNetworkErrorLogging_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("ClearNetworkErrorLogging");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContext_ClearDomainReliability_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkContext::ClearDomainReliabilityCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkContext_ClearDomainReliability_ProxyToResponder> proxy(
        new NetworkContext_ClearDomainReliability_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkContext_ClearDomainReliability_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_ClearDomainReliability_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkContext_ClearDomainReliability_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::ClearDomainReliabilityCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool NetworkContext_ClearDomainReliability_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkContext_ClearDomainReliability_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_ClearDomainReliability_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetworkContext.24
  bool success = true;
  NetworkContext_ClearDomainReliability_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 24, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void NetworkContext_ClearDomainReliability_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply network::mojom::NetworkContext::ClearDomainReliability");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kClearDomainReliability), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_ClearDomainReliability_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("ClearDomainReliability");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContext_ClearSharedDictionaryCache_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkContext::ClearSharedDictionaryCacheCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkContext_ClearSharedDictionaryCache_ProxyToResponder> proxy(
        new NetworkContext_ClearSharedDictionaryCache_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkContext_ClearSharedDictionaryCache_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_ClearSharedDictionaryCache_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkContext_ClearSharedDictionaryCache_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::ClearSharedDictionaryCacheCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool NetworkContext_ClearSharedDictionaryCache_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkContext_ClearSharedDictionaryCache_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_ClearSharedDictionaryCache_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetworkContext.25
  bool success = true;
  NetworkContext_ClearSharedDictionaryCache_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 25, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void NetworkContext_ClearSharedDictionaryCache_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply network::mojom::NetworkContext::ClearSharedDictionaryCache");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kClearSharedDictionaryCache), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_ClearSharedDictionaryCache_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("ClearSharedDictionaryCache");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContext_ClearSharedDictionaryCacheForIsolationKey_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkContext::ClearSharedDictionaryCacheForIsolationKeyCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkContext_ClearSharedDictionaryCacheForIsolationKey_ProxyToResponder> proxy(
        new NetworkContext_ClearSharedDictionaryCacheForIsolationKey_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkContext_ClearSharedDictionaryCacheForIsolationKey_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_ClearSharedDictionaryCacheForIsolationKey_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkContext_ClearSharedDictionaryCacheForIsolationKey_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::ClearSharedDictionaryCacheForIsolationKeyCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool NetworkContext_ClearSharedDictionaryCacheForIsolationKey_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkContext_ClearSharedDictionaryCacheForIsolationKey_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_ClearSharedDictionaryCacheForIsolationKey_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetworkContext.26
  bool success = true;
  NetworkContext_ClearSharedDictionaryCacheForIsolationKey_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 26, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void NetworkContext_ClearSharedDictionaryCacheForIsolationKey_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply network::mojom::NetworkContext::ClearSharedDictionaryCacheForIsolationKey");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kClearSharedDictionaryCacheForIsolationKey), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_ClearSharedDictionaryCacheForIsolationKey_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("ClearSharedDictionaryCacheForIsolationKey");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContext_CloseAllConnections_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkContext::CloseAllConnectionsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkContext_CloseAllConnections_ProxyToResponder> proxy(
        new NetworkContext_CloseAllConnections_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkContext_CloseAllConnections_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_CloseAllConnections_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkContext_CloseAllConnections_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::CloseAllConnectionsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool NetworkContext_CloseAllConnections_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkContext_CloseAllConnections_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_CloseAllConnections_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetworkContext.33
  bool success = true;
  NetworkContext_CloseAllConnections_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 33, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void NetworkContext_CloseAllConnections_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply network::mojom::NetworkContext::CloseAllConnections");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kCloseAllConnections), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_CloseAllConnections_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("CloseAllConnections");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContext_CloseIdleConnections_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkContext::CloseIdleConnectionsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkContext_CloseIdleConnections_ProxyToResponder> proxy(
        new NetworkContext_CloseIdleConnections_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkContext_CloseIdleConnections_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_CloseIdleConnections_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkContext_CloseIdleConnections_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::CloseIdleConnectionsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool NetworkContext_CloseIdleConnections_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkContext_CloseIdleConnections_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_CloseIdleConnections_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetworkContext.34
  bool success = true;
  NetworkContext_CloseIdleConnections_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 34, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void NetworkContext_CloseIdleConnections_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply network::mojom::NetworkContext::CloseIdleConnections");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kCloseIdleConnections), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_CloseIdleConnections_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("CloseIdleConnections");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContext_CreateRestrictedUDPSocket_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkContext::CreateRestrictedUDPSocketCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkContext_CreateRestrictedUDPSocket_ProxyToResponder> proxy(
        new NetworkContext_CreateRestrictedUDPSocket_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkContext_CreateRestrictedUDPSocket_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_CreateRestrictedUDPSocket_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkContext_CreateRestrictedUDPSocket_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::CreateRestrictedUDPSocketCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_result, const std::optional<::net::IPEndPoint>& in_local_addr_out);
};

bool NetworkContext_CreateRestrictedUDPSocket_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkContext_CreateRestrictedUDPSocket_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_CreateRestrictedUDPSocket_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetworkContext.41
  bool success = true;
  int32_t p_result{};
  std::optional<::net::IPEndPoint> p_local_addr_out{};
  NetworkContext_CreateRestrictedUDPSocket_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_result = input_data_view.result();
  if (success && !input_data_view.ReadLocalAddrOut(&p_local_addr_out))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 41, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_local_addr_out));
  }
  return true;
}

void NetworkContext_CreateRestrictedUDPSocket_ProxyToResponder::Run(
    int32_t in_result, const std::optional<::net::IPEndPoint>& in_local_addr_out) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::NetworkContext::CreateRestrictedUDPSocket", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("local_addr_out"), in_local_addr_out,
                        "<value of type const std::optional<::net::IPEndPoint>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kCreateRestrictedUDPSocket), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_CreateRestrictedUDPSocket_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->result = in_result;
  mojo::internal::MessageFragment<
      typename decltype(params->local_addr_out)::BaseType> local_addr_out_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::IPEndPointDataView>(
    in_local_addr_out,
    local_addr_out_fragment);

  params->local_addr_out.Set(
      local_addr_out_fragment.is_null() ? nullptr : local_addr_out_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("CreateRestrictedUDPSocket");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContext_CreateTCPServerSocket_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkContext::CreateTCPServerSocketCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkContext_CreateTCPServerSocket_ProxyToResponder> proxy(
        new NetworkContext_CreateTCPServerSocket_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkContext_CreateTCPServerSocket_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_CreateTCPServerSocket_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkContext_CreateTCPServerSocket_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::CreateTCPServerSocketCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_result, const std::optional<::net::IPEndPoint>& in_local_addr_out);
};

bool NetworkContext_CreateTCPServerSocket_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkContext_CreateTCPServerSocket_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_CreateTCPServerSocket_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetworkContext.42
  bool success = true;
  int32_t p_result{};
  std::optional<::net::IPEndPoint> p_local_addr_out{};
  NetworkContext_CreateTCPServerSocket_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_result = input_data_view.result();
  if (success && !input_data_view.ReadLocalAddrOut(&p_local_addr_out))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 42, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_local_addr_out));
  }
  return true;
}

void NetworkContext_CreateTCPServerSocket_ProxyToResponder::Run(
    int32_t in_result, const std::optional<::net::IPEndPoint>& in_local_addr_out) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::NetworkContext::CreateTCPServerSocket", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("local_addr_out"), in_local_addr_out,
                        "<value of type const std::optional<::net::IPEndPoint>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kCreateTCPServerSocket), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_CreateTCPServerSocket_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->result = in_result;
  mojo::internal::MessageFragment<
      typename decltype(params->local_addr_out)::BaseType> local_addr_out_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::IPEndPointDataView>(
    in_local_addr_out,
    local_addr_out_fragment);

  params->local_addr_out.Set(
      local_addr_out_fragment.is_null() ? nullptr : local_addr_out_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("CreateTCPServerSocket");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContext_CreateTCPConnectedSocket_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkContext::CreateTCPConnectedSocketCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkContext_CreateTCPConnectedSocket_ProxyToResponder> proxy(
        new NetworkContext_CreateTCPConnectedSocket_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkContext_CreateTCPConnectedSocket_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_CreateTCPConnectedSocket_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkContext_CreateTCPConnectedSocket_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::CreateTCPConnectedSocketCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_result, const std::optional<::net::IPEndPoint>& in_local_addr, const std::optional<::net::IPEndPoint>& in_peer_addr, ::mojo::ScopedDataPipeConsumerHandle in_receive_stream, ::mojo::ScopedDataPipeProducerHandle in_send_stream);
};

bool NetworkContext_CreateTCPConnectedSocket_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkContext_CreateTCPConnectedSocket_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_CreateTCPConnectedSocket_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetworkContext.43
  bool success = true;
  int32_t p_result{};
  std::optional<::net::IPEndPoint> p_local_addr{};
  std::optional<::net::IPEndPoint> p_peer_addr{};
  ::mojo::ScopedDataPipeConsumerHandle p_receive_stream{};
  ::mojo::ScopedDataPipeProducerHandle p_send_stream{};
  NetworkContext_CreateTCPConnectedSocket_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_result = input_data_view.result();
  if (success && !input_data_view.ReadLocalAddr(&p_local_addr))
    success = false;
  if (success && !input_data_view.ReadPeerAddr(&p_peer_addr))
    success = false;
  if (success)
    p_receive_stream = input_data_view.TakeReceiveStream();
  if (success)
    p_send_stream = input_data_view.TakeSendStream();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 43, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_local_addr), 
std::move(p_peer_addr), 
std::move(p_receive_stream), 
std::move(p_send_stream));
  }
  return true;
}

void NetworkContext_CreateTCPConnectedSocket_ProxyToResponder::Run(
    int32_t in_result, const std::optional<::net::IPEndPoint>& in_local_addr, const std::optional<::net::IPEndPoint>& in_peer_addr, ::mojo::ScopedDataPipeConsumerHandle in_receive_stream, ::mojo::ScopedDataPipeProducerHandle in_send_stream) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::NetworkContext::CreateTCPConnectedSocket", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("local_addr"), in_local_addr,
                        "<value of type const std::optional<::net::IPEndPoint>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("peer_addr"), in_peer_addr,
                        "<value of type const std::optional<::net::IPEndPoint>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receive_stream"), in_receive_stream,
                        "<value of type ::mojo::ScopedDataPipeConsumerHandle>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("send_stream"), in_send_stream,
                        "<value of type ::mojo::ScopedDataPipeProducerHandle>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kCreateTCPConnectedSocket), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_CreateTCPConnectedSocket_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->result = in_result;
  mojo::internal::MessageFragment<
      typename decltype(params->local_addr)::BaseType> local_addr_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::IPEndPointDataView>(
    in_local_addr,
    local_addr_fragment);

  params->local_addr.Set(
      local_addr_fragment.is_null() ? nullptr : local_addr_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->peer_addr)::BaseType> peer_addr_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::IPEndPointDataView>(
    in_peer_addr,
    peer_addr_fragment);

  params->peer_addr.Set(
      peer_addr_fragment.is_null() ? nullptr : peer_addr_fragment.data());

  
  mojo::internal::Serialize<mojo::ScopedDataPipeConsumerHandle>(
    in_receive_stream,
    &params->receive_stream,
    &params.message());

  
  mojo::internal::Serialize<mojo::ScopedDataPipeProducerHandle>(
    in_send_stream,
    &params->send_stream,
    &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("CreateTCPConnectedSocket");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContext_CreateTCPBoundSocket_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkContext::CreateTCPBoundSocketCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkContext_CreateTCPBoundSocket_ProxyToResponder> proxy(
        new NetworkContext_CreateTCPBoundSocket_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkContext_CreateTCPBoundSocket_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_CreateTCPBoundSocket_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkContext_CreateTCPBoundSocket_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::CreateTCPBoundSocketCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_result, const std::optional<::net::IPEndPoint>& in_local_addr);
};

bool NetworkContext_CreateTCPBoundSocket_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkContext_CreateTCPBoundSocket_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_CreateTCPBoundSocket_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetworkContext.44
  bool success = true;
  int32_t p_result{};
  std::optional<::net::IPEndPoint> p_local_addr{};
  NetworkContext_CreateTCPBoundSocket_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_result = input_data_view.result();
  if (success && !input_data_view.ReadLocalAddr(&p_local_addr))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 44, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_local_addr));
  }
  return true;
}

void NetworkContext_CreateTCPBoundSocket_ProxyToResponder::Run(
    int32_t in_result, const std::optional<::net::IPEndPoint>& in_local_addr) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::NetworkContext::CreateTCPBoundSocket", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("local_addr"), in_local_addr,
                        "<value of type const std::optional<::net::IPEndPoint>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kCreateTCPBoundSocket), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_CreateTCPBoundSocket_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->result = in_result;
  mojo::internal::MessageFragment<
      typename decltype(params->local_addr)::BaseType> local_addr_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::IPEndPointDataView>(
    in_local_addr,
    local_addr_fragment);

  params->local_addr.Set(
      local_addr_fragment.is_null() ? nullptr : local_addr_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("CreateTCPBoundSocket");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContext_ForceReloadProxyConfig_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkContext::ForceReloadProxyConfigCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkContext_ForceReloadProxyConfig_ProxyToResponder> proxy(
        new NetworkContext_ForceReloadProxyConfig_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkContext_ForceReloadProxyConfig_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_ForceReloadProxyConfig_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkContext_ForceReloadProxyConfig_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::ForceReloadProxyConfigCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool NetworkContext_ForceReloadProxyConfig_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkContext_ForceReloadProxyConfig_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_ForceReloadProxyConfig_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetworkContext.47
  bool success = true;
  NetworkContext_ForceReloadProxyConfig_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 47, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void NetworkContext_ForceReloadProxyConfig_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply network::mojom::NetworkContext::ForceReloadProxyConfig");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kForceReloadProxyConfig), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_ForceReloadProxyConfig_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("ForceReloadProxyConfig");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContext_ClearBadProxiesCache_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkContext::ClearBadProxiesCacheCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkContext_ClearBadProxiesCache_ProxyToResponder> proxy(
        new NetworkContext_ClearBadProxiesCache_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkContext_ClearBadProxiesCache_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_ClearBadProxiesCache_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkContext_ClearBadProxiesCache_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::ClearBadProxiesCacheCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool NetworkContext_ClearBadProxiesCache_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkContext_ClearBadProxiesCache_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_ClearBadProxiesCache_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetworkContext.48
  bool success = true;
  NetworkContext_ClearBadProxiesCache_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 48, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void NetworkContext_ClearBadProxiesCache_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply network::mojom::NetworkContext::ClearBadProxiesCache");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kClearBadProxiesCache), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_ClearBadProxiesCache_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("ClearBadProxiesCache");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContext_VerifyCert_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkContext::VerifyCertCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkContext_VerifyCert_ProxyToResponder> proxy(
        new NetworkContext_VerifyCert_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkContext_VerifyCert_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_VerifyCert_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkContext_VerifyCert_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::VerifyCertCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_error_code, const ::net::CertVerifyResult& in_cv_result, bool in_pkp_bypassed);
};

bool NetworkContext_VerifyCert_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkContext_VerifyCert_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_VerifyCert_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetworkContext.57
  bool success = true;
  int32_t p_error_code{};
  ::net::CertVerifyResult p_cv_result{};
  bool p_pkp_bypassed{};
  NetworkContext_VerifyCert_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_error_code = input_data_view.error_code();
  if (success && !input_data_view.ReadCvResult(&p_cv_result))
    success = false;
  if (success)
    p_pkp_bypassed = input_data_view.pkp_bypassed();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 57, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_error_code), 
std::move(p_cv_result), 
std::move(p_pkp_bypassed));
  }
  return true;
}

void NetworkContext_VerifyCert_ProxyToResponder::Run(
    int32_t in_error_code, const ::net::CertVerifyResult& in_cv_result, bool in_pkp_bypassed) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::NetworkContext::VerifyCert", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_code"), in_error_code,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cv_result"), in_cv_result,
                        "<value of type const ::net::CertVerifyResult&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pkp_bypassed"), in_pkp_bypassed,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kVerifyCert), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_VerifyCert_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->error_code = in_error_code;
  mojo::internal::MessageFragment<
      typename decltype(params->cv_result)::BaseType> cv_result_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::CertVerifyResultDataView>(
    in_cv_result,
    cv_result_fragment);

  params->cv_result.Set(
      cv_result_fragment.is_null() ? nullptr : cv_result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->cv_result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null cv_result in ");

  params->pkp_bypassed = in_pkp_bypassed;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("VerifyCert");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContext_VerifyCertForSignedExchange_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkContext::VerifyCertForSignedExchangeCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkContext_VerifyCertForSignedExchange_ProxyToResponder> proxy(
        new NetworkContext_VerifyCertForSignedExchange_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkContext_VerifyCertForSignedExchange_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_VerifyCertForSignedExchange_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkContext_VerifyCertForSignedExchange_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::VerifyCertForSignedExchangeCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_error_code, const ::net::CertVerifyResult& in_cv_result, bool in_pkp_bypassed);
};

bool NetworkContext_VerifyCertForSignedExchange_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkContext_VerifyCertForSignedExchange_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_VerifyCertForSignedExchange_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetworkContext.58
  bool success = true;
  int32_t p_error_code{};
  ::net::CertVerifyResult p_cv_result{};
  bool p_pkp_bypassed{};
  NetworkContext_VerifyCertForSignedExchange_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_error_code = input_data_view.error_code();
  if (success && !input_data_view.ReadCvResult(&p_cv_result))
    success = false;
  if (success)
    p_pkp_bypassed = input_data_view.pkp_bypassed();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 58, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_error_code), 
std::move(p_cv_result), 
std::move(p_pkp_bypassed));
  }
  return true;
}

void NetworkContext_VerifyCertForSignedExchange_ProxyToResponder::Run(
    int32_t in_error_code, const ::net::CertVerifyResult& in_cv_result, bool in_pkp_bypassed) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::NetworkContext::VerifyCertForSignedExchange", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_code"), in_error_code,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cv_result"), in_cv_result,
                        "<value of type const ::net::CertVerifyResult&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pkp_bypassed"), in_pkp_bypassed,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kVerifyCertForSignedExchange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_VerifyCertForSignedExchange_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->error_code = in_error_code;
  mojo::internal::MessageFragment<
      typename decltype(params->cv_result)::BaseType> cv_result_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::CertVerifyResultDataView>(
    in_cv_result,
    cv_result_fragment);

  params->cv_result.Set(
      cv_result_fragment.is_null() ? nullptr : cv_result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->cv_result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null cv_result in ");

  params->pkp_bypassed = in_pkp_bypassed;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("VerifyCertForSignedExchange");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContext_Verify2QwacCertBinding_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkContext::Verify2QwacCertBindingCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkContext_Verify2QwacCertBinding_ProxyToResponder> proxy(
        new NetworkContext_Verify2QwacCertBinding_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkContext_Verify2QwacCertBinding_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_Verify2QwacCertBinding_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkContext_Verify2QwacCertBinding_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::Verify2QwacCertBindingCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::scoped_refptr<::net::X509Certificate>& in_verified_cert);
};

bool NetworkContext_Verify2QwacCertBinding_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkContext_Verify2QwacCertBinding_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_Verify2QwacCertBinding_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetworkContext.59
  bool success = true;
  ::scoped_refptr<::net::X509Certificate> p_verified_cert{};
  NetworkContext_Verify2QwacCertBinding_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadVerifiedCert(&p_verified_cert))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 59, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_verified_cert));
  }
  return true;
}

void NetworkContext_Verify2QwacCertBinding_ProxyToResponder::Run(
    const ::scoped_refptr<::net::X509Certificate>& in_verified_cert) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::NetworkContext::Verify2QwacCertBinding", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("verified_cert"), in_verified_cert,
                        "<value of type const ::scoped_refptr<::net::X509Certificate>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kVerify2QwacCertBinding), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_Verify2QwacCertBinding_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->verified_cert)::BaseType> verified_cert_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::X509CertificateDataView>(
    in_verified_cert,
    verified_cert_fragment);

  params->verified_cert.Set(
      verified_cert_fragment.is_null() ? nullptr : verified_cert_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->verified_cert.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null verified_cert in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("Verify2QwacCertBinding");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContext_AddHSTS_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkContext::AddHSTSCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkContext_AddHSTS_ProxyToResponder> proxy(
        new NetworkContext_AddHSTS_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkContext_AddHSTS_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_AddHSTS_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkContext_AddHSTS_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::AddHSTSCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool NetworkContext_AddHSTS_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkContext_AddHSTS_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_AddHSTS_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetworkContext.60
  bool success = true;
  NetworkContext_AddHSTS_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 60, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void NetworkContext_AddHSTS_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply network::mojom::NetworkContext::AddHSTS");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kAddHSTS), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_AddHSTS_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("AddHSTS");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContext_IsHSTSActiveForHost_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkContext::IsHSTSActiveForHostCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkContext_IsHSTSActiveForHost_ProxyToResponder> proxy(
        new NetworkContext_IsHSTSActiveForHost_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkContext_IsHSTSActiveForHost_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_IsHSTSActiveForHost_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkContext_IsHSTSActiveForHost_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::IsHSTSActiveForHostCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_result);
};

bool NetworkContext_IsHSTSActiveForHost_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkContext_IsHSTSActiveForHost_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_IsHSTSActiveForHost_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetworkContext.61
  bool success = true;
  bool p_result{};
  NetworkContext_IsHSTSActiveForHost_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_result = input_data_view.result();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 61, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void NetworkContext_IsHSTSActiveForHost_ProxyToResponder::Run(
    bool in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::NetworkContext::IsHSTSActiveForHost", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kIsHSTSActiveForHost), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_IsHSTSActiveForHost_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->result = in_result;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("IsHSTSActiveForHost");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContext_GetHSTSState_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkContext::GetHSTSStateCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkContext_GetHSTSState_ProxyToResponder> proxy(
        new NetworkContext_GetHSTSState_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkContext_GetHSTSState_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_GetHSTSState_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkContext_GetHSTSState_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::GetHSTSStateCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::Value::Dict in_state);
};

bool NetworkContext_GetHSTSState_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkContext_GetHSTSState_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_GetHSTSState_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetworkContext.62
  bool success = true;
  ::base::Value::Dict p_state{};
  NetworkContext_GetHSTSState_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadState(&p_state))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 62, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_state));
  }
  return true;
}

void NetworkContext_GetHSTSState_ProxyToResponder::Run(
    ::base::Value::Dict in_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::NetworkContext::GetHSTSState", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("state"), in_state,
                        "<value of type ::base::Value::Dict>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kGetHSTSState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_GetHSTSState_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->state)::BaseType> state_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::DictionaryValueDataView>(
    in_state,
    state_fragment);

  params->state.Set(
      state_fragment.is_null() ? nullptr : state_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->state.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null state in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("GetHSTSState");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContext_SetCorsOriginAccessListsForOrigin_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkContext::SetCorsOriginAccessListsForOriginCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkContext_SetCorsOriginAccessListsForOrigin_ProxyToResponder> proxy(
        new NetworkContext_SetCorsOriginAccessListsForOrigin_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkContext_SetCorsOriginAccessListsForOrigin_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_SetCorsOriginAccessListsForOrigin_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkContext_SetCorsOriginAccessListsForOrigin_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::SetCorsOriginAccessListsForOriginCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool NetworkContext_SetCorsOriginAccessListsForOrigin_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkContext_SetCorsOriginAccessListsForOrigin_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_SetCorsOriginAccessListsForOrigin_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetworkContext.63
  bool success = true;
  NetworkContext_SetCorsOriginAccessListsForOrigin_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 63, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void NetworkContext_SetCorsOriginAccessListsForOrigin_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply network::mojom::NetworkContext::SetCorsOriginAccessListsForOrigin");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kSetCorsOriginAccessListsForOrigin), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_SetCorsOriginAccessListsForOrigin_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("SetCorsOriginAccessListsForOrigin");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContext_DeleteDynamicDataForHost_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkContext::DeleteDynamicDataForHostCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkContext_DeleteDynamicDataForHost_ProxyToResponder> proxy(
        new NetworkContext_DeleteDynamicDataForHost_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkContext_DeleteDynamicDataForHost_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_DeleteDynamicDataForHost_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkContext_DeleteDynamicDataForHost_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::DeleteDynamicDataForHostCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_result);
};

bool NetworkContext_DeleteDynamicDataForHost_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkContext_DeleteDynamicDataForHost_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_DeleteDynamicDataForHost_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetworkContext.64
  bool success = true;
  bool p_result{};
  NetworkContext_DeleteDynamicDataForHost_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_result = input_data_view.result();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 64, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void NetworkContext_DeleteDynamicDataForHost_ProxyToResponder::Run(
    bool in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::NetworkContext::DeleteDynamicDataForHost", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kDeleteDynamicDataForHost), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_DeleteDynamicDataForHost_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->result = in_result;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("DeleteDynamicDataForHost");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContext_SaveHttpAuthCacheProxyEntries_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkContext::SaveHttpAuthCacheProxyEntriesCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkContext_SaveHttpAuthCacheProxyEntries_ProxyToResponder> proxy(
        new NetworkContext_SaveHttpAuthCacheProxyEntries_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkContext_SaveHttpAuthCacheProxyEntries_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_SaveHttpAuthCacheProxyEntries_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkContext_SaveHttpAuthCacheProxyEntries_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::SaveHttpAuthCacheProxyEntriesCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::base::UnguessableToken& in_cache_key);
};

bool NetworkContext_SaveHttpAuthCacheProxyEntries_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkContext_SaveHttpAuthCacheProxyEntries_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_SaveHttpAuthCacheProxyEntries_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetworkContext.66
  bool success = true;
  ::base::UnguessableToken p_cache_key{};
  NetworkContext_SaveHttpAuthCacheProxyEntries_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadCacheKey(&p_cache_key))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 66, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_cache_key));
  }
  return true;
}

void NetworkContext_SaveHttpAuthCacheProxyEntries_ProxyToResponder::Run(
    const ::base::UnguessableToken& in_cache_key) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::NetworkContext::SaveHttpAuthCacheProxyEntries", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cache_key"), in_cache_key,
                        "<value of type const ::base::UnguessableToken&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kSaveHttpAuthCacheProxyEntries), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_SaveHttpAuthCacheProxyEntries_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->cache_key)::BaseType> cache_key_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_cache_key,
    cache_key_fragment);

  params->cache_key.Set(
      cache_key_fragment.is_null() ? nullptr : cache_key_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->cache_key.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null cache_key in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("SaveHttpAuthCacheProxyEntries");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContext_LoadHttpAuthCacheProxyEntries_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkContext::LoadHttpAuthCacheProxyEntriesCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkContext_LoadHttpAuthCacheProxyEntries_ProxyToResponder> proxy(
        new NetworkContext_LoadHttpAuthCacheProxyEntries_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkContext_LoadHttpAuthCacheProxyEntries_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_LoadHttpAuthCacheProxyEntries_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkContext_LoadHttpAuthCacheProxyEntries_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::LoadHttpAuthCacheProxyEntriesCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool NetworkContext_LoadHttpAuthCacheProxyEntries_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkContext_LoadHttpAuthCacheProxyEntries_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_LoadHttpAuthCacheProxyEntries_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetworkContext.67
  bool success = true;
  NetworkContext_LoadHttpAuthCacheProxyEntries_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 67, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void NetworkContext_LoadHttpAuthCacheProxyEntries_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply network::mojom::NetworkContext::LoadHttpAuthCacheProxyEntries");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kLoadHttpAuthCacheProxyEntries), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_LoadHttpAuthCacheProxyEntries_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("LoadHttpAuthCacheProxyEntries");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContext_AddAuthCacheEntry_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkContext::AddAuthCacheEntryCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkContext_AddAuthCacheEntry_ProxyToResponder> proxy(
        new NetworkContext_AddAuthCacheEntry_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkContext_AddAuthCacheEntry_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_AddAuthCacheEntry_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkContext_AddAuthCacheEntry_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::AddAuthCacheEntryCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool NetworkContext_AddAuthCacheEntry_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkContext_AddAuthCacheEntry_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_AddAuthCacheEntry_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetworkContext.68
  bool success = true;
  NetworkContext_AddAuthCacheEntry_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 68, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void NetworkContext_AddAuthCacheEntry_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply network::mojom::NetworkContext::AddAuthCacheEntry");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kAddAuthCacheEntry), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_AddAuthCacheEntry_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("AddAuthCacheEntry");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContext_LookupServerBasicAuthCredentials_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkContext::LookupServerBasicAuthCredentialsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkContext_LookupServerBasicAuthCredentials_ProxyToResponder> proxy(
        new NetworkContext_LookupServerBasicAuthCredentials_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkContext_LookupServerBasicAuthCredentials_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_LookupServerBasicAuthCredentials_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkContext_LookupServerBasicAuthCredentials_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::LookupServerBasicAuthCredentialsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::optional<::net::AuthCredentials>& in_credentials);
};

bool NetworkContext_LookupServerBasicAuthCredentials_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkContext_LookupServerBasicAuthCredentials_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_LookupServerBasicAuthCredentials_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetworkContext.70
  bool success = true;
  std::optional<::net::AuthCredentials> p_credentials{};
  NetworkContext_LookupServerBasicAuthCredentials_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadCredentials(&p_credentials))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 70, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_credentials));
  }
  return true;
}

void NetworkContext_LookupServerBasicAuthCredentials_ProxyToResponder::Run(
    const std::optional<::net::AuthCredentials>& in_credentials) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::NetworkContext::LookupServerBasicAuthCredentials", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("credentials"), in_credentials,
                        "<value of type const std::optional<::net::AuthCredentials>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kLookupServerBasicAuthCredentials), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_LookupServerBasicAuthCredentials_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->credentials)::BaseType> credentials_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::AuthCredentialsDataView>(
    in_credentials,
    credentials_fragment);

  params->credentials.Set(
      credentials_fragment.is_null() ? nullptr : credentials_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("LookupServerBasicAuthCredentials");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContext_EnableStaticKeyPinningForTesting_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkContext::EnableStaticKeyPinningForTestingCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkContext_EnableStaticKeyPinningForTesting_ProxyToResponder> proxy(
        new NetworkContext_EnableStaticKeyPinningForTesting_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkContext_EnableStaticKeyPinningForTesting_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_EnableStaticKeyPinningForTesting_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkContext_EnableStaticKeyPinningForTesting_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::EnableStaticKeyPinningForTestingCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool NetworkContext_EnableStaticKeyPinningForTesting_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkContext_EnableStaticKeyPinningForTesting_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_EnableStaticKeyPinningForTesting_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetworkContext.71
  bool success = true;
  NetworkContext_EnableStaticKeyPinningForTesting_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 71, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void NetworkContext_EnableStaticKeyPinningForTesting_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply network::mojom::NetworkContext::EnableStaticKeyPinningForTesting");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kEnableStaticKeyPinningForTesting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_EnableStaticKeyPinningForTesting_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("EnableStaticKeyPinningForTesting");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool NetworkContext_EnableStaticKeyPinningForTesting_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkContext_EnableStaticKeyPinningForTesting_ResponseParams_Data* params =
      reinterpret_cast<internal::NetworkContext_EnableStaticKeyPinningForTesting_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for NetworkContext.71
  bool success = true;
  NetworkContext_EnableStaticKeyPinningForTesting_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 71, true);
    return false;
  }
  *result_ = true;
  return true;
}
class NetworkContext_VerifyCertificateForTesting_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkContext::VerifyCertificateForTestingCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkContext_VerifyCertificateForTesting_ProxyToResponder> proxy(
        new NetworkContext_VerifyCertificateForTesting_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkContext_VerifyCertificateForTesting_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_VerifyCertificateForTesting_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkContext_VerifyCertificateForTesting_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::VerifyCertificateForTestingCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_error_code);
};

bool NetworkContext_VerifyCertificateForTesting_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkContext_VerifyCertificateForTesting_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_VerifyCertificateForTesting_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetworkContext.72
  bool success = true;
  int32_t p_error_code{};
  NetworkContext_VerifyCertificateForTesting_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_error_code = input_data_view.error_code();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 72, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_error_code));
  }
  return true;
}

void NetworkContext_VerifyCertificateForTesting_ProxyToResponder::Run(
    int32_t in_error_code) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::NetworkContext::VerifyCertificateForTesting", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_code"), in_error_code,
                        "<value of type int32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kVerifyCertificateForTesting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_VerifyCertificateForTesting_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->error_code = in_error_code;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("VerifyCertificateForTesting");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContext_GetTrustAnchorIDsForTesting_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkContext::GetTrustAnchorIDsForTestingCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkContext_GetTrustAnchorIDsForTesting_ProxyToResponder> proxy(
        new NetworkContext_GetTrustAnchorIDsForTesting_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkContext_GetTrustAnchorIDsForTesting_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_GetTrustAnchorIDsForTesting_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkContext_GetTrustAnchorIDsForTesting_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::GetTrustAnchorIDsForTestingCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::vector<std::vector<uint8_t>>& in_trust_anchor_ids);
};

bool NetworkContext_GetTrustAnchorIDsForTesting_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkContext_GetTrustAnchorIDsForTesting_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_GetTrustAnchorIDsForTesting_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetworkContext.73
  bool success = true;
  std::vector<std::vector<uint8_t>> p_trust_anchor_ids{};
  NetworkContext_GetTrustAnchorIDsForTesting_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadTrustAnchorIds(&p_trust_anchor_ids))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 73, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_trust_anchor_ids));
  }
  return true;
}

void NetworkContext_GetTrustAnchorIDsForTesting_ProxyToResponder::Run(
    const std::vector<std::vector<uint8_t>>& in_trust_anchor_ids) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::NetworkContext::GetTrustAnchorIDsForTesting", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("trust_anchor_ids"), in_trust_anchor_ids,
                        "<value of type const std::vector<std::vector<uint8_t>>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kGetTrustAnchorIDsForTesting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_GetTrustAnchorIDsForTesting_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->trust_anchor_ids)::BaseType>
      trust_anchor_ids_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& trust_anchor_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>>(
    in_trust_anchor_ids,
    trust_anchor_ids_fragment,
    &trust_anchor_ids_validate_params);

  params->trust_anchor_ids.Set(
      trust_anchor_ids_fragment.is_null() ? nullptr : trust_anchor_ids_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->trust_anchor_ids.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null trust_anchor_ids in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("GetTrustAnchorIDsForTesting");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool NetworkContext_GetTrustAnchorIDsForTesting_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkContext_GetTrustAnchorIDsForTesting_ResponseParams_Data* params =
      reinterpret_cast<internal::NetworkContext_GetTrustAnchorIDsForTesting_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for NetworkContext.73
  bool success = true;
  std::vector<std::vector<uint8_t>> p_trust_anchor_ids{};
  NetworkContext_GetTrustAnchorIDsForTesting_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadTrustAnchorIds(&p_trust_anchor_ids))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 73, true);
    return false;
  }
  *out_trust_anchor_ids_ = std::move(p_trust_anchor_ids);
  *result_ = true;
  return true;
}
class NetworkContext_AddDomainReliabilityContextForTesting_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkContext::AddDomainReliabilityContextForTestingCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkContext_AddDomainReliabilityContextForTesting_ProxyToResponder> proxy(
        new NetworkContext_AddDomainReliabilityContextForTesting_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkContext_AddDomainReliabilityContextForTesting_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_AddDomainReliabilityContextForTesting_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkContext_AddDomainReliabilityContextForTesting_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::AddDomainReliabilityContextForTestingCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool NetworkContext_AddDomainReliabilityContextForTesting_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkContext_AddDomainReliabilityContextForTesting_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_AddDomainReliabilityContextForTesting_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetworkContext.74
  bool success = true;
  NetworkContext_AddDomainReliabilityContextForTesting_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 74, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void NetworkContext_AddDomainReliabilityContextForTesting_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply network::mojom::NetworkContext::AddDomainReliabilityContextForTesting");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kAddDomainReliabilityContextForTesting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_AddDomainReliabilityContextForTesting_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("AddDomainReliabilityContextForTesting");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool NetworkContext_AddDomainReliabilityContextForTesting_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkContext_AddDomainReliabilityContextForTesting_ResponseParams_Data* params =
      reinterpret_cast<internal::NetworkContext_AddDomainReliabilityContextForTesting_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for NetworkContext.74
  bool success = true;
  NetworkContext_AddDomainReliabilityContextForTesting_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 74, true);
    return false;
  }
  *result_ = true;
  return true;
}
class NetworkContext_ForceDomainReliabilityUploadsForTesting_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkContext::ForceDomainReliabilityUploadsForTestingCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkContext_ForceDomainReliabilityUploadsForTesting_ProxyToResponder> proxy(
        new NetworkContext_ForceDomainReliabilityUploadsForTesting_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkContext_ForceDomainReliabilityUploadsForTesting_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_ForceDomainReliabilityUploadsForTesting_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkContext_ForceDomainReliabilityUploadsForTesting_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::ForceDomainReliabilityUploadsForTestingCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool NetworkContext_ForceDomainReliabilityUploadsForTesting_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkContext_ForceDomainReliabilityUploadsForTesting_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_ForceDomainReliabilityUploadsForTesting_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetworkContext.75
  bool success = true;
  NetworkContext_ForceDomainReliabilityUploadsForTesting_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 75, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void NetworkContext_ForceDomainReliabilityUploadsForTesting_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply network::mojom::NetworkContext::ForceDomainReliabilityUploadsForTesting");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kForceDomainReliabilityUploadsForTesting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_ForceDomainReliabilityUploadsForTesting_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("ForceDomainReliabilityUploadsForTesting");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool NetworkContext_ForceDomainReliabilityUploadsForTesting_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkContext_ForceDomainReliabilityUploadsForTesting_ResponseParams_Data* params =
      reinterpret_cast<internal::NetworkContext_ForceDomainReliabilityUploadsForTesting_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for NetworkContext.75
  bool success = true;
  NetworkContext_ForceDomainReliabilityUploadsForTesting_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 75, true);
    return false;
  }
  *result_ = true;
  return true;
}
class NetworkContext_GetSharedDictionaryUsageInfo_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkContext::GetSharedDictionaryUsageInfoCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkContext_GetSharedDictionaryUsageInfo_ProxyToResponder> proxy(
        new NetworkContext_GetSharedDictionaryUsageInfo_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkContext_GetSharedDictionaryUsageInfo_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_GetSharedDictionaryUsageInfo_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkContext_GetSharedDictionaryUsageInfo_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::GetSharedDictionaryUsageInfoCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::vector<::net::SharedDictionaryUsageInfo>& in_usage_info);
};

bool NetworkContext_GetSharedDictionaryUsageInfo_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkContext_GetSharedDictionaryUsageInfo_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_GetSharedDictionaryUsageInfo_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetworkContext.77
  bool success = true;
  std::vector<::net::SharedDictionaryUsageInfo> p_usage_info{};
  NetworkContext_GetSharedDictionaryUsageInfo_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadUsageInfo(&p_usage_info))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 77, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_usage_info));
  }
  return true;
}

void NetworkContext_GetSharedDictionaryUsageInfo_ProxyToResponder::Run(
    const std::vector<::net::SharedDictionaryUsageInfo>& in_usage_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::NetworkContext::GetSharedDictionaryUsageInfo", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("usage_info"), in_usage_info,
                        "<value of type const std::vector<::net::SharedDictionaryUsageInfo>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kGetSharedDictionaryUsageInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_GetSharedDictionaryUsageInfo_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->usage_info)::BaseType>
      usage_info_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& usage_info_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::SharedDictionaryUsageInfoDataView>>(
    in_usage_info,
    usage_info_fragment,
    &usage_info_validate_params);

  params->usage_info.Set(
      usage_info_fragment.is_null() ? nullptr : usage_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->usage_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null usage_info in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("GetSharedDictionaryUsageInfo");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContext_GetSharedDictionaryInfo_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkContext::GetSharedDictionaryInfoCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkContext_GetSharedDictionaryInfo_ProxyToResponder> proxy(
        new NetworkContext_GetSharedDictionaryInfo_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkContext_GetSharedDictionaryInfo_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_GetSharedDictionaryInfo_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkContext_GetSharedDictionaryInfo_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::GetSharedDictionaryInfoCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<SharedDictionaryInfoPtr> in_dictionaries);
};

bool NetworkContext_GetSharedDictionaryInfo_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkContext_GetSharedDictionaryInfo_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_GetSharedDictionaryInfo_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetworkContext.78
  bool success = true;
  std::vector<SharedDictionaryInfoPtr> p_dictionaries{};
  NetworkContext_GetSharedDictionaryInfo_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadDictionaries(&p_dictionaries))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 78, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_dictionaries));
  }
  return true;
}

void NetworkContext_GetSharedDictionaryInfo_ProxyToResponder::Run(
    std::vector<SharedDictionaryInfoPtr> in_dictionaries) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::NetworkContext::GetSharedDictionaryInfo", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("dictionaries"), in_dictionaries,
                        "<value of type std::vector<SharedDictionaryInfoPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kGetSharedDictionaryInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_GetSharedDictionaryInfo_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->dictionaries)::BaseType>
      dictionaries_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& dictionaries_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::SharedDictionaryInfoDataView>>(
    in_dictionaries,
    dictionaries_fragment,
    &dictionaries_validate_params);

  params->dictionaries.Set(
      dictionaries_fragment.is_null() ? nullptr : dictionaries_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->dictionaries.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null dictionaries in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("GetSharedDictionaryInfo");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContext_GetSharedDictionaryOriginsBetween_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkContext::GetSharedDictionaryOriginsBetweenCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkContext_GetSharedDictionaryOriginsBetween_ProxyToResponder> proxy(
        new NetworkContext_GetSharedDictionaryOriginsBetween_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkContext_GetSharedDictionaryOriginsBetween_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_GetSharedDictionaryOriginsBetween_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkContext_GetSharedDictionaryOriginsBetween_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::GetSharedDictionaryOriginsBetweenCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::vector<::url::Origin>& in_origins);
};

bool NetworkContext_GetSharedDictionaryOriginsBetween_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkContext_GetSharedDictionaryOriginsBetween_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_GetSharedDictionaryOriginsBetween_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetworkContext.79
  bool success = true;
  std::vector<::url::Origin> p_origins{};
  NetworkContext_GetSharedDictionaryOriginsBetween_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadOrigins(&p_origins))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 79, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_origins));
  }
  return true;
}

void NetworkContext_GetSharedDictionaryOriginsBetween_ProxyToResponder::Run(
    const std::vector<::url::Origin>& in_origins) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::NetworkContext::GetSharedDictionaryOriginsBetween", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("origins"), in_origins,
                        "<value of type const std::vector<::url::Origin>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kGetSharedDictionaryOriginsBetween), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_GetSharedDictionaryOriginsBetween_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->origins)::BaseType>
      origins_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& origins_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::url::mojom::OriginDataView>>(
    in_origins,
    origins_fragment,
    &origins_validate_params);

  params->origins.Set(
      origins_fragment.is_null() ? nullptr : origins_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->origins.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null origins in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("GetSharedDictionaryOriginsBetween");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkContext::HasPreloadedSharedDictionaryInfoForTestingCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_ProxyToResponder> proxy(
        new NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::HasPreloadedSharedDictionaryInfoForTestingCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_value);
};

bool NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetworkContext.82
  bool success = true;
  bool p_value{};
  NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_value = input_data_view.value();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 82, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_value));
  }
  return true;
}

void NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_ProxyToResponder::Run(
    bool in_value) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::NetworkContext::HasPreloadedSharedDictionaryInfoForTesting", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("value"), in_value,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kHasPreloadedSharedDictionaryInfoForTesting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->value = in_value;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("HasPreloadedSharedDictionaryInfoForTesting");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContext_RevokeNetworkForNonces_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkContext::RevokeNetworkForNoncesCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkContext_RevokeNetworkForNonces_ProxyToResponder> proxy(
        new NetworkContext_RevokeNetworkForNonces_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkContext_RevokeNetworkForNonces_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_RevokeNetworkForNonces_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkContext_RevokeNetworkForNonces_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::RevokeNetworkForNoncesCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool NetworkContext_RevokeNetworkForNonces_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkContext_RevokeNetworkForNonces_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_RevokeNetworkForNonces_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetworkContext.87
  bool success = true;
  NetworkContext_RevokeNetworkForNonces_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 87, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void NetworkContext_RevokeNetworkForNonces_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply network::mojom::NetworkContext::RevokeNetworkForNonces");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kRevokeNetworkForNonces), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_RevokeNetworkForNonces_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("RevokeNetworkForNonces");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContext_ExemptUrlFromNetworkRevocationForNonce_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkContext::ExemptUrlFromNetworkRevocationForNonceCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkContext_ExemptUrlFromNetworkRevocationForNonce_ProxyToResponder> proxy(
        new NetworkContext_ExemptUrlFromNetworkRevocationForNonce_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkContext_ExemptUrlFromNetworkRevocationForNonce_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_ExemptUrlFromNetworkRevocationForNonce_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkContext_ExemptUrlFromNetworkRevocationForNonce_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::ExemptUrlFromNetworkRevocationForNonceCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool NetworkContext_ExemptUrlFromNetworkRevocationForNonce_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkContext_ExemptUrlFromNetworkRevocationForNonce_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_ExemptUrlFromNetworkRevocationForNonce_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetworkContext.89
  bool success = true;
  NetworkContext_ExemptUrlFromNetworkRevocationForNonce_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 89, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void NetworkContext_ExemptUrlFromNetworkRevocationForNonce_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply network::mojom::NetworkContext::ExemptUrlFromNetworkRevocationForNonce");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kExemptUrlFromNetworkRevocationForNonce), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_ExemptUrlFromNetworkRevocationForNonce_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("ExemptUrlFromNetworkRevocationForNonce");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContext_GetBoundNetworkForTesting_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkContext::GetBoundNetworkForTestingCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkContext_GetBoundNetworkForTesting_ProxyToResponder> proxy(
        new NetworkContext_GetBoundNetworkForTesting_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkContext_GetBoundNetworkForTesting_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_GetBoundNetworkForTesting_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkContext_GetBoundNetworkForTesting_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::GetBoundNetworkForTestingCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int64_t in_bound_network);
};

bool NetworkContext_GetBoundNetworkForTesting_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkContext_GetBoundNetworkForTesting_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_GetBoundNetworkForTesting_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetworkContext.91
  bool success = true;
  int64_t p_bound_network{};
  NetworkContext_GetBoundNetworkForTesting_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_bound_network = input_data_view.bound_network();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 91, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_bound_network));
  }
  return true;
}

void NetworkContext_GetBoundNetworkForTesting_ProxyToResponder::Run(
    int64_t in_bound_network) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::NetworkContext::GetBoundNetworkForTesting", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bound_network"), in_bound_network,
                        "<value of type int64_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkContext::kGetBoundNetworkForTesting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkContext_GetBoundNetworkForTesting_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->bound_network = in_bound_network;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("GetBoundNetworkForTesting");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool NetworkContextStubDispatch::Accept(
    NetworkContext* impl,
    mojo::Message* message) {
  switch (static_cast<messages::NetworkContext>(message->header()->name)) {
    case messages::NetworkContext::kSetClient: {
      DCHECK(message->is_serialized());
      internal::NetworkContext_SetClient_Params_Data* params =
          reinterpret_cast<internal::NetworkContext_SetClient_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NetworkContext.0
      bool success = true;
      ::mojo::PendingRemote<::network::mojom::NetworkContextClient> p_client{};
      NetworkContext_SetClient_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetClient(        
        std::move(p_client));
      return true;
    }
    case messages::NetworkContext::kCreateURLLoaderFactory: {
      DCHECK(message->is_serialized());
      internal::NetworkContext_CreateURLLoaderFactory_Params_Data* params =
          reinterpret_cast<internal::NetworkContext_CreateURLLoaderFactory_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NetworkContext.1
      bool success = true;
      ::mojo::PendingReceiver<::network::mojom::URLLoaderFactory> p_url_loader_factory{};
      URLLoaderFactoryParamsPtr p_params{};
      NetworkContext_CreateURLLoaderFactory_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_url_loader_factory =
            input_data_view.TakeUrlLoaderFactory<decltype(p_url_loader_factory)>();
      }
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateURLLoaderFactory(        
        std::move(p_url_loader_factory), 
        std::move(p_params));
      return true;
    }
    case messages::NetworkContext::kResetURLLoaderFactories: {
      DCHECK(message->is_serialized());
      internal::NetworkContext_ResetURLLoaderFactories_Params_Data* params =
          reinterpret_cast<internal::NetworkContext_ResetURLLoaderFactories_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NetworkContext.2
      bool success = true;
      NetworkContext_ResetURLLoaderFactories_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ResetURLLoaderFactories(        );
      return true;
    }
    case messages::NetworkContext::kGetViaObliviousHttp: {
      DCHECK(message->is_serialized());
      internal::NetworkContext_GetViaObliviousHttp_Params_Data* params =
          reinterpret_cast<internal::NetworkContext_GetViaObliviousHttp_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NetworkContext.3
      bool success = true;
      ::network::mojom::ObliviousHttpRequestPtr p_request{};
      ::mojo::PendingRemote<::network::mojom::ObliviousHttpClient> p_client{};
      NetworkContext_GetViaObliviousHttp_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRequest(&p_request))
        success = false;
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetViaObliviousHttp(        
        std::move(p_request), 
        std::move(p_client));
      return true;
    }
    case messages::NetworkContext::kGetCookieManager: {
      DCHECK(message->is_serialized());
      internal::NetworkContext_GetCookieManager_Params_Data* params =
          reinterpret_cast<internal::NetworkContext_GetCookieManager_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NetworkContext.4
      bool success = true;
      ::mojo::PendingReceiver<::network::mojom::CookieManager> p_cookie_manager{};
      NetworkContext_GetCookieManager_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_cookie_manager =
            input_data_view.TakeCookieManager<decltype(p_cookie_manager)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetCookieManager(        
        std::move(p_cookie_manager));
      return true;
    }
    case messages::NetworkContext::kGetRestrictedCookieManager: {
      DCHECK(message->is_serialized());
      internal::NetworkContext_GetRestrictedCookieManager_Params_Data* params =
          reinterpret_cast<internal::NetworkContext_GetRestrictedCookieManager_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NetworkContext.5
      bool success = true;
      ::mojo::PendingReceiver<::network::mojom::RestrictedCookieManager> p_restricted_cookie_manager{};
      ::network::mojom::RestrictedCookieManagerRole p_role{};
      ::url::Origin p_origin{};
      ::net::IsolationInfo p_isolation_info{};
      ::net::CookieSettingOverrides p_cookie_setting_overrides{};
      ::net::CookieSettingOverrides p_devtools_cookie_setting_overrides{};
      ::mojo::PendingRemote<::network::mojom::CookieAccessObserver> p_cookie_observer{};
      NetworkContext_GetRestrictedCookieManager_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_restricted_cookie_manager =
            input_data_view.TakeRestrictedCookieManager<decltype(p_restricted_cookie_manager)>();
      }
      if (success && !input_data_view.ReadRole(&p_role))
        success = false;
      if (success && !input_data_view.ReadOrigin(&p_origin))
        success = false;
      if (success && !input_data_view.ReadIsolationInfo(&p_isolation_info))
        success = false;
      if (success && !input_data_view.ReadCookieSettingOverrides(&p_cookie_setting_overrides))
        success = false;
      if (success && !input_data_view.ReadDevtoolsCookieSettingOverrides(&p_devtools_cookie_setting_overrides))
        success = false;
      if (success) {
        p_cookie_observer =
            input_data_view.TakeCookieObserver<decltype(p_cookie_observer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetRestrictedCookieManager(        
        std::move(p_restricted_cookie_manager), 
        std::move(p_role), 
        std::move(p_origin), 
        std::move(p_isolation_info), 
        std::move(p_cookie_setting_overrides), 
        std::move(p_devtools_cookie_setting_overrides), 
        std::move(p_cookie_observer));
      return true;
    }
    case messages::NetworkContext::kGetTrustTokenQueryAnswerer: {
      DCHECK(message->is_serialized());
      internal::NetworkContext_GetTrustTokenQueryAnswerer_Params_Data* params =
          reinterpret_cast<internal::NetworkContext_GetTrustTokenQueryAnswerer_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NetworkContext.6
      bool success = true;
      ::mojo::PendingReceiver<::network::mojom::TrustTokenQueryAnswerer> p_trust_token_query_answerer{};
      ::url::Origin p_top_frame_origin{};
      NetworkContext_GetTrustTokenQueryAnswerer_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_trust_token_query_answerer =
            input_data_view.TakeTrustTokenQueryAnswerer<decltype(p_trust_token_query_answerer)>();
      }
      if (success && !input_data_view.ReadTopFrameOrigin(&p_top_frame_origin))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetTrustTokenQueryAnswerer(        
        std::move(p_trust_token_query_answerer), 
        std::move(p_top_frame_origin));
      return true;
    }
    case messages::NetworkContext::kClearTrustTokenData: {
      break;
    }
    case messages::NetworkContext::kClearTrustTokenSessionOnlyData: {
      break;
    }
    case messages::NetworkContext::kGetStoredTrustTokenCounts: {
      break;
    }
    case messages::NetworkContext::kGetPrivateStateTokenRedemptionRecords: {
      break;
    }
    case messages::NetworkContext::kDeleteStoredTrustTokens: {
      break;
    }
    case messages::NetworkContext::kSetBlockTrustTokens: {
      DCHECK(message->is_serialized());
      internal::NetworkContext_SetBlockTrustTokens_Params_Data* params =
          reinterpret_cast<internal::NetworkContext_SetBlockTrustTokens_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NetworkContext.12
      bool success = true;
      bool p_block{};
      NetworkContext_SetBlockTrustTokens_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_block = input_data_view.block();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetBlockTrustTokens(        
        std::move(p_block));
      return true;
    }
    case messages::NetworkContext::kSetTrackingProtectionContentSetting: {
      DCHECK(message->is_serialized());
      internal::NetworkContext_SetTrackingProtectionContentSetting_Params_Data* params =
          reinterpret_cast<internal::NetworkContext_SetTrackingProtectionContentSetting_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NetworkContext.13
      bool success = true;
      std::vector<::ContentSettingPatternSource> p_settings{};
      NetworkContext_SetTrackingProtectionContentSetting_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSettings(&p_settings))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 13, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetTrackingProtectionContentSetting(        
        std::move(p_settings));
      return true;
    }
    case messages::NetworkContext::kClearNetworkingHistoryBetween: {
      break;
    }
    case messages::NetworkContext::kClearHttpCache: {
      break;
    }
    case messages::NetworkContext::kComputeHttpCacheSize: {
      break;
    }
    case messages::NetworkContext::kNotifyExternalCacheHit: {
      DCHECK(message->is_serialized());
      internal::NetworkContext_NotifyExternalCacheHit_Params_Data* params =
          reinterpret_cast<internal::NetworkContext_NotifyExternalCacheHit_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NetworkContext.17
      bool success = true;
      ::GURL p_url{};
      std::string p_http_method{};
      ::net::NetworkIsolationKey p_key{};
      bool p_include_credentials{};
      NetworkContext_NotifyExternalCacheHit_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadHttpMethod(&p_http_method))
        success = false;
      if (success && !input_data_view.ReadKey(&p_key))
        success = false;
      if (success)
        p_include_credentials = input_data_view.include_credentials();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 17, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyExternalCacheHit(        
        std::move(p_url), 
        std::move(p_http_method), 
        std::move(p_key), 
        std::move(p_include_credentials));
      return true;
    }
    case messages::NetworkContext::kClearHostCache: {
      break;
    }
    case messages::NetworkContext::kClearHttpAuthCache: {
      break;
    }
    case messages::NetworkContext::kClearCorsPreflightCache: {
      break;
    }
    case messages::NetworkContext::kClearReportingCacheReports: {
      break;
    }
    case messages::NetworkContext::kClearReportingCacheClients: {
      break;
    }
    case messages::NetworkContext::kClearNetworkErrorLogging: {
      break;
    }
    case messages::NetworkContext::kClearDomainReliability: {
      break;
    }
    case messages::NetworkContext::kClearSharedDictionaryCache: {
      break;
    }
    case messages::NetworkContext::kClearSharedDictionaryCacheForIsolationKey: {
      break;
    }
    case messages::NetworkContext::kSetDocumentReportingEndpoints: {
      DCHECK(message->is_serialized());
      internal::NetworkContext_SetDocumentReportingEndpoints_Params_Data* params =
          reinterpret_cast<internal::NetworkContext_SetDocumentReportingEndpoints_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NetworkContext.27
      bool success = true;
      ::base::UnguessableToken p_reporting_source{};
      ::url::Origin p_origin{};
      ::net::IsolationInfo p_isolation_info{};
      base::flat_map<std::string, std::string> p_endpoints{};
      NetworkContext_SetDocumentReportingEndpoints_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadReportingSource(&p_reporting_source))
        success = false;
      if (success && !input_data_view.ReadOrigin(&p_origin))
        success = false;
      if (success && !input_data_view.ReadIsolationInfo(&p_isolation_info))
        success = false;
      if (success && !input_data_view.ReadEndpoints(&p_endpoints))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 27, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetDocumentReportingEndpoints(        
        std::move(p_reporting_source), 
        std::move(p_origin), 
        std::move(p_isolation_info), 
        std::move(p_endpoints));
      return true;
    }
    case messages::NetworkContext::kSetEnterpriseReportingEndpoints: {
      DCHECK(message->is_serialized());
      internal::NetworkContext_SetEnterpriseReportingEndpoints_Params_Data* params =
          reinterpret_cast<internal::NetworkContext_SetEnterpriseReportingEndpoints_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NetworkContext.28
      bool success = true;
      base::flat_map<std::string, ::GURL> p_endpoints{};
      NetworkContext_SetEnterpriseReportingEndpoints_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEndpoints(&p_endpoints))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 28, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetEnterpriseReportingEndpoints(        
        std::move(p_endpoints));
      return true;
    }
    case messages::NetworkContext::kSendReportsAndRemoveSource: {
      DCHECK(message->is_serialized());
      internal::NetworkContext_SendReportsAndRemoveSource_Params_Data* params =
          reinterpret_cast<internal::NetworkContext_SendReportsAndRemoveSource_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NetworkContext.29
      bool success = true;
      ::base::UnguessableToken p_reporting_source{};
      NetworkContext_SendReportsAndRemoveSource_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadReportingSource(&p_reporting_source))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 29, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SendReportsAndRemoveSource(        
        std::move(p_reporting_source));
      return true;
    }
    case messages::NetworkContext::kQueueReport: {
      DCHECK(message->is_serialized());
      internal::NetworkContext_QueueReport_Params_Data* params =
          reinterpret_cast<internal::NetworkContext_QueueReport_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NetworkContext.30
      bool success = true;
      std::string p_type{};
      std::string p_group{};
      ::GURL p_url{};
      std::optional<::base::UnguessableToken> p_reporting_source{};
      ::net::NetworkAnonymizationKey p_network_anonymization_key{};
      ::base::Value::Dict p_body{};
      NetworkContext_QueueReport_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (success && !input_data_view.ReadGroup(&p_group))
        success = false;
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadReportingSource(&p_reporting_source))
        success = false;
      if (success && !input_data_view.ReadNetworkAnonymizationKey(&p_network_anonymization_key))
        success = false;
      if (success && !input_data_view.ReadBody(&p_body))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 30, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->QueueReport(        
        std::move(p_type), 
        std::move(p_group), 
        std::move(p_url), 
        std::move(p_reporting_source), 
        std::move(p_network_anonymization_key), 
        std::move(p_body));
      return true;
    }
    case messages::NetworkContext::kQueueEnterpriseReport: {
      DCHECK(message->is_serialized());
      internal::NetworkContext_QueueEnterpriseReport_Params_Data* params =
          reinterpret_cast<internal::NetworkContext_QueueEnterpriseReport_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NetworkContext.31
      bool success = true;
      std::string p_type{};
      std::string p_group{};
      ::GURL p_url{};
      ::base::Value::Dict p_body{};
      NetworkContext_QueueEnterpriseReport_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (success && !input_data_view.ReadGroup(&p_group))
        success = false;
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadBody(&p_body))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 31, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->QueueEnterpriseReport(        
        std::move(p_type), 
        std::move(p_group), 
        std::move(p_url), 
        std::move(p_body));
      return true;
    }
    case messages::NetworkContext::kQueueSignedExchangeReport: {
      DCHECK(message->is_serialized());
      internal::NetworkContext_QueueSignedExchangeReport_Params_Data* params =
          reinterpret_cast<internal::NetworkContext_QueueSignedExchangeReport_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NetworkContext.32
      bool success = true;
      SignedExchangeReportPtr p_report{};
      ::net::NetworkAnonymizationKey p_network_anonymization_key{};
      NetworkContext_QueueSignedExchangeReport_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadReport(&p_report))
        success = false;
      if (success && !input_data_view.ReadNetworkAnonymizationKey(&p_network_anonymization_key))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 32, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->QueueSignedExchangeReport(        
        std::move(p_report), 
        std::move(p_network_anonymization_key));
      return true;
    }
    case messages::NetworkContext::kCloseAllConnections: {
      break;
    }
    case messages::NetworkContext::kCloseIdleConnections: {
      break;
    }
    case messages::NetworkContext::kSetNetworkConditions: {
      DCHECK(message->is_serialized());
      internal::NetworkContext_SetNetworkConditions_Params_Data* params =
          reinterpret_cast<internal::NetworkContext_SetNetworkConditions_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NetworkContext.35
      bool success = true;
      ::base::UnguessableToken p_throttling_profile_id{};
      NetworkConditionsPtr p_conditions{};
      NetworkContext_SetNetworkConditions_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadThrottlingProfileId(&p_throttling_profile_id))
        success = false;
      if (success && !input_data_view.ReadConditions(&p_conditions))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 35, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetNetworkConditions(        
        std::move(p_throttling_profile_id), 
        std::move(p_conditions));
      return true;
    }
    case messages::NetworkContext::kSetAcceptLanguage: {
      DCHECK(message->is_serialized());
      internal::NetworkContext_SetAcceptLanguage_Params_Data* params =
          reinterpret_cast<internal::NetworkContext_SetAcceptLanguage_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NetworkContext.36
      bool success = true;
      std::string p_new_accept_language{};
      NetworkContext_SetAcceptLanguage_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNewAcceptLanguage(&p_new_accept_language))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 36, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetAcceptLanguage(        
        std::move(p_new_accept_language));
      return true;
    }
    case messages::NetworkContext::kSetUserAgent: {
      DCHECK(message->is_serialized());
      internal::NetworkContext_SetUserAgent_Params_Data* params =
          reinterpret_cast<internal::NetworkContext_SetUserAgent_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NetworkContext.37
      bool success = true;
      std::string p_new_user_agent{};
      NetworkContext_SetUserAgent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNewUserAgent(&p_new_user_agent))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 37, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetUserAgent(        
        std::move(p_new_user_agent));
      return true;
    }
    case messages::NetworkContext::kSetEnableReferrers: {
      DCHECK(message->is_serialized());
      internal::NetworkContext_SetEnableReferrers_Params_Data* params =
          reinterpret_cast<internal::NetworkContext_SetEnableReferrers_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NetworkContext.38
      bool success = true;
      bool p_enable_referrers{};
      NetworkContext_SetEnableReferrers_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_enable_referrers = input_data_view.enable_referrers();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 38, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetEnableReferrers(        
        std::move(p_enable_referrers));
      return true;
    }
    case messages::NetworkContext::kSetCTPolicy: {
      DCHECK(message->is_serialized());
      internal::NetworkContext_SetCTPolicy_Params_Data* params =
          reinterpret_cast<internal::NetworkContext_SetCTPolicy_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NetworkContext.39
      bool success = true;
      CTPolicyPtr p_ct_policy{};
      NetworkContext_SetCTPolicy_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCtPolicy(&p_ct_policy))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 39, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetCTPolicy(        
        std::move(p_ct_policy));
      return true;
    }
    case messages::NetworkContext::kCreateUDPSocket: {
      DCHECK(message->is_serialized());
      internal::NetworkContext_CreateUDPSocket_Params_Data* params =
          reinterpret_cast<internal::NetworkContext_CreateUDPSocket_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NetworkContext.40
      bool success = true;
      ::mojo::PendingReceiver<::network::mojom::UDPSocket> p_receiver{};
      ::mojo::PendingRemote<::network::mojom::UDPSocketListener> p_listener{};
      NetworkContext_CreateUDPSocket_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (success) {
        p_listener =
            input_data_view.TakeListener<decltype(p_listener)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 40, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateUDPSocket(        
        std::move(p_receiver), 
        std::move(p_listener));
      return true;
    }
    case messages::NetworkContext::kCreateRestrictedUDPSocket: {
      break;
    }
    case messages::NetworkContext::kCreateTCPServerSocket: {
      break;
    }
    case messages::NetworkContext::kCreateTCPConnectedSocket: {
      break;
    }
    case messages::NetworkContext::kCreateTCPBoundSocket: {
      break;
    }
    case messages::NetworkContext::kCreateProxyResolvingSocketFactory: {
      DCHECK(message->is_serialized());
      internal::NetworkContext_CreateProxyResolvingSocketFactory_Params_Data* params =
          reinterpret_cast<internal::NetworkContext_CreateProxyResolvingSocketFactory_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NetworkContext.45
      bool success = true;
      ::mojo::PendingReceiver<::network::mojom::ProxyResolvingSocketFactory> p_factory{};
      NetworkContext_CreateProxyResolvingSocketFactory_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_factory =
            input_data_view.TakeFactory<decltype(p_factory)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 45, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateProxyResolvingSocketFactory(        
        std::move(p_factory));
      return true;
    }
    case messages::NetworkContext::kLookUpProxyForURL: {
      DCHECK(message->is_serialized());
      internal::NetworkContext_LookUpProxyForURL_Params_Data* params =
          reinterpret_cast<internal::NetworkContext_LookUpProxyForURL_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NetworkContext.46
      bool success = true;
      ::GURL p_url{};
      ::net::NetworkAnonymizationKey p_network_anonymization_key{};
      ::mojo::PendingRemote<::network::mojom::ProxyLookupClient> p_proxy_lookup_client{};
      NetworkContext_LookUpProxyForURL_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadNetworkAnonymizationKey(&p_network_anonymization_key))
        success = false;
      if (success) {
        p_proxy_lookup_client =
            input_data_view.TakeProxyLookupClient<decltype(p_proxy_lookup_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 46, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->LookUpProxyForURL(        
        std::move(p_url), 
        std::move(p_network_anonymization_key), 
        std::move(p_proxy_lookup_client));
      return true;
    }
    case messages::NetworkContext::kForceReloadProxyConfig: {
      break;
    }
    case messages::NetworkContext::kClearBadProxiesCache: {
      break;
    }
    case messages::NetworkContext::kCreateWebSocket: {
      DCHECK(message->is_serialized());
      internal::NetworkContext_CreateWebSocket_Params_Data* params =
          reinterpret_cast<internal::NetworkContext_CreateWebSocket_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NetworkContext.49
      bool success = true;
      ::GURL p_url{};
      std::vector<std::string> p_requested_protocols{};
      ::net::SiteForCookies p_site_for_cookies{};
      ::net::StorageAccessApiStatus p_storage_access_api_status{};
      ::net::IsolationInfo p_isolation_info{};
      std::vector<::network::mojom::HttpHeaderPtr> p_additional_headers{};
      int32_t p_process_id{};
      ::url::Origin p_origin{};
      uint32_t p_options{};
      ::net::MutableNetworkTrafficAnnotationTag p_traffic_annotation{};
      ::mojo::PendingRemote<::network::mojom::WebSocketHandshakeClient> p_handshake_client{};
      ::mojo::PendingRemote<::network::mojom::URLLoaderNetworkServiceObserver> p_url_loader_network_observer{};
      ::mojo::PendingRemote<::network::mojom::WebSocketAuthenticationHandler> p_auth_handler{};
      ::mojo::PendingRemote<TrustedHeaderClient> p_header_client{};
      std::optional<::base::UnguessableToken> p_throttling_profile_id{};
      NetworkContext_CreateWebSocket_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadRequestedProtocols(&p_requested_protocols))
        success = false;
      if (success && !input_data_view.ReadSiteForCookies(&p_site_for_cookies))
        success = false;
      if (success && !input_data_view.ReadStorageAccessApiStatus(&p_storage_access_api_status))
        success = false;
      if (success && !input_data_view.ReadIsolationInfo(&p_isolation_info))
        success = false;
      if (success && !input_data_view.ReadAdditionalHeaders(&p_additional_headers))
        success = false;
      if (success)
        p_process_id = input_data_view.process_id();
      if (success && !input_data_view.ReadOrigin(&p_origin))
        success = false;
      if (success)
        p_options = input_data_view.options();
      if (success && !input_data_view.ReadTrafficAnnotation(&p_traffic_annotation))
        success = false;
      if (success) {
        p_handshake_client =
            input_data_view.TakeHandshakeClient<decltype(p_handshake_client)>();
      }
      if (success) {
        p_url_loader_network_observer =
            input_data_view.TakeUrlLoaderNetworkObserver<decltype(p_url_loader_network_observer)>();
      }
      if (success) {
        p_auth_handler =
            input_data_view.TakeAuthHandler<decltype(p_auth_handler)>();
      }
      if (success) {
        p_header_client =
            input_data_view.TakeHeaderClient<decltype(p_header_client)>();
      }
      if (success && !input_data_view.ReadThrottlingProfileId(&p_throttling_profile_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 49, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateWebSocket(        
        std::move(p_url), 
        std::move(p_requested_protocols), 
        std::move(p_site_for_cookies), 
        std::move(p_storage_access_api_status), 
        std::move(p_isolation_info), 
        std::move(p_additional_headers), 
        std::move(p_process_id), 
        std::move(p_origin), 
        std::move(p_options), 
        std::move(p_traffic_annotation), 
        std::move(p_handshake_client), 
        std::move(p_url_loader_network_observer), 
        std::move(p_auth_handler), 
        std::move(p_header_client), 
        std::move(p_throttling_profile_id));
      return true;
    }
    case messages::NetworkContext::kCreateWebTransport: {
      DCHECK(message->is_serialized());
      internal::NetworkContext_CreateWebTransport_Params_Data* params =
          reinterpret_cast<internal::NetworkContext_CreateWebTransport_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NetworkContext.50
      bool success = true;
      ::GURL p_url{};
      ::url::Origin p_origin{};
      ::net::NetworkAnonymizationKey p_network_anonymization_key{};
      std::vector<::network::mojom::WebTransportCertificateFingerprintPtr> p_fingerprints{};
      std::vector<std::string> p_application_protocols{};
      ::mojo::PendingRemote<::network::mojom::WebTransportHandshakeClient> p_handshake_client{};
      NetworkContext_CreateWebTransport_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadOrigin(&p_origin))
        success = false;
      if (success && !input_data_view.ReadNetworkAnonymizationKey(&p_network_anonymization_key))
        success = false;
      if (success && !input_data_view.ReadFingerprints(&p_fingerprints))
        success = false;
      if (success && !input_data_view.ReadApplicationProtocols(&p_application_protocols))
        success = false;
      if (success) {
        p_handshake_client =
            input_data_view.TakeHandshakeClient<decltype(p_handshake_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 50, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateWebTransport(        
        std::move(p_url), 
        std::move(p_origin), 
        std::move(p_network_anonymization_key), 
        std::move(p_fingerprints), 
        std::move(p_application_protocols), 
        std::move(p_handshake_client));
      return true;
    }
    case messages::NetworkContext::kCreateNetLogExporter: {
      DCHECK(message->is_serialized());
      internal::NetworkContext_CreateNetLogExporter_Params_Data* params =
          reinterpret_cast<internal::NetworkContext_CreateNetLogExporter_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NetworkContext.51
      bool success = true;
      ::mojo::PendingReceiver<::network::mojom::NetLogExporter> p_receiver{};
      NetworkContext_CreateNetLogExporter_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 51, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateNetLogExporter(        
        std::move(p_receiver));
      return true;
    }
    case messages::NetworkContext::kPreconnectSockets: {
      DCHECK(message->is_serialized());
      internal::NetworkContext_PreconnectSockets_Params_Data* params =
          reinterpret_cast<internal::NetworkContext_PreconnectSockets_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NetworkContext.52
      bool success = true;
      uint32_t p_num_streams{};
      ::GURL p_url{};
      ::network::mojom::CredentialsMode p_credentials_mode{};
      ::net::NetworkAnonymizationKey p_network_anonymization_key{};
      ::net::MutableNetworkTrafficAnnotationTag p_traffic_annotation{};
      std::optional<::net::ConnectionKeepAliveConfig> p_keepalive_config{};
      ::mojo::PendingRemote<::network::mojom::ConnectionChangeObserverClient> p_observer_client{};
      NetworkContext_PreconnectSockets_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_num_streams = input_data_view.num_streams();
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadCredentialsMode(&p_credentials_mode))
        success = false;
      if (success && !input_data_view.ReadNetworkAnonymizationKey(&p_network_anonymization_key))
        success = false;
      if (success && !input_data_view.ReadTrafficAnnotation(&p_traffic_annotation))
        success = false;
      if (success && !input_data_view.ReadKeepaliveConfig(&p_keepalive_config))
        success = false;
      if (success) {
        p_observer_client =
            input_data_view.TakeObserverClient<decltype(p_observer_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 52, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PreconnectSockets(        
        std::move(p_num_streams), 
        std::move(p_url), 
        std::move(p_credentials_mode), 
        std::move(p_network_anonymization_key), 
        std::move(p_traffic_annotation), 
        std::move(p_keepalive_config), 
        std::move(p_observer_client));
      return true;
    }
    case messages::NetworkContext::kCreateP2PSocketManager: {
      DCHECK(message->is_serialized());
      internal::NetworkContext_CreateP2PSocketManager_Params_Data* params =
          reinterpret_cast<internal::NetworkContext_CreateP2PSocketManager_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NetworkContext.53
      bool success = true;
      ::net::NetworkAnonymizationKey p_network_anonymization_key{};
      ::mojo::PendingRemote<::network::mojom::P2PTrustedSocketManagerClient> p_client{};
      ::mojo::PendingReceiver<::network::mojom::P2PTrustedSocketManager> p_trusted_socket_manager{};
      ::mojo::PendingReceiver<::network::mojom::P2PSocketManager> p_socket_manager{};
      NetworkContext_CreateP2PSocketManager_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNetworkAnonymizationKey(&p_network_anonymization_key))
        success = false;
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (success) {
        p_trusted_socket_manager =
            input_data_view.TakeTrustedSocketManager<decltype(p_trusted_socket_manager)>();
      }
      if (success) {
        p_socket_manager =
            input_data_view.TakeSocketManager<decltype(p_socket_manager)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 53, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateP2PSocketManager(        
        std::move(p_network_anonymization_key), 
        std::move(p_client), 
        std::move(p_trusted_socket_manager), 
        std::move(p_socket_manager));
      return true;
    }
    case messages::NetworkContext::kCreateMdnsResponder: {
      DCHECK(message->is_serialized());
      internal::NetworkContext_CreateMdnsResponder_Params_Data* params =
          reinterpret_cast<internal::NetworkContext_CreateMdnsResponder_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NetworkContext.54
      bool success = true;
      ::mojo::PendingReceiver<::network::mojom::MdnsResponder> p_responder_receiver{};
      NetworkContext_CreateMdnsResponder_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_responder_receiver =
            input_data_view.TakeResponderReceiver<decltype(p_responder_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 54, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateMdnsResponder(        
        std::move(p_responder_receiver));
      return true;
    }
    case messages::NetworkContext::kResolveHost: {
      DCHECK(message->is_serialized());
      internal::NetworkContext_ResolveHost_Params_Data* params =
          reinterpret_cast<internal::NetworkContext_ResolveHost_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NetworkContext.55
      bool success = true;
      ::network::mojom::HostResolverHostPtr p_host{};
      ::net::NetworkAnonymizationKey p_network_anonymization_key{};
      ::network::mojom::ResolveHostParametersPtr p_optional_parameters{};
      ::mojo::PendingRemote<::network::mojom::ResolveHostClient> p_response_client{};
      NetworkContext_ResolveHost_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadHost(&p_host))
        success = false;
      if (success && !input_data_view.ReadNetworkAnonymizationKey(&p_network_anonymization_key))
        success = false;
      if (success && !input_data_view.ReadOptionalParameters(&p_optional_parameters))
        success = false;
      if (success) {
        p_response_client =
            input_data_view.TakeResponseClient<decltype(p_response_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 55, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ResolveHost(        
        std::move(p_host), 
        std::move(p_network_anonymization_key), 
        std::move(p_optional_parameters), 
        std::move(p_response_client));
      return true;
    }
    case messages::NetworkContext::kCreateHostResolver: {
      DCHECK(message->is_serialized());
      internal::NetworkContext_CreateHostResolver_Params_Data* params =
          reinterpret_cast<internal::NetworkContext_CreateHostResolver_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NetworkContext.56
      bool success = true;
      std::optional<::net::DnsConfigOverrides> p_config_overrides{};
      ::mojo::PendingReceiver<::network::mojom::HostResolver> p_host_resolver{};
      NetworkContext_CreateHostResolver_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadConfigOverrides(&p_config_overrides))
        success = false;
      if (success) {
        p_host_resolver =
            input_data_view.TakeHostResolver<decltype(p_host_resolver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 56, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateHostResolver(        
        std::move(p_config_overrides), 
        std::move(p_host_resolver));
      return true;
    }
    case messages::NetworkContext::kVerifyCert: {
      break;
    }
    case messages::NetworkContext::kVerifyCertForSignedExchange: {
      break;
    }
    case messages::NetworkContext::kVerify2QwacCertBinding: {
      break;
    }
    case messages::NetworkContext::kAddHSTS: {
      break;
    }
    case messages::NetworkContext::kIsHSTSActiveForHost: {
      break;
    }
    case messages::NetworkContext::kGetHSTSState: {
      break;
    }
    case messages::NetworkContext::kSetCorsOriginAccessListsForOrigin: {
      break;
    }
    case messages::NetworkContext::kDeleteDynamicDataForHost: {
      break;
    }
    case messages::NetworkContext::kSetSplitAuthCacheByNetworkAnonymizationKey: {
      DCHECK(message->is_serialized());
      internal::NetworkContext_SetSplitAuthCacheByNetworkAnonymizationKey_Params_Data* params =
          reinterpret_cast<internal::NetworkContext_SetSplitAuthCacheByNetworkAnonymizationKey_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NetworkContext.65
      bool success = true;
      bool p_split_auth_cache_by_network_anonymization_key{};
      NetworkContext_SetSplitAuthCacheByNetworkAnonymizationKey_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_split_auth_cache_by_network_anonymization_key = input_data_view.split_auth_cache_by_network_anonymization_key();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 65, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetSplitAuthCacheByNetworkAnonymizationKey(        
        std::move(p_split_auth_cache_by_network_anonymization_key));
      return true;
    }
    case messages::NetworkContext::kSaveHttpAuthCacheProxyEntries: {
      break;
    }
    case messages::NetworkContext::kLoadHttpAuthCacheProxyEntries: {
      break;
    }
    case messages::NetworkContext::kAddAuthCacheEntry: {
      break;
    }
    case messages::NetworkContext::kSetCorsNonWildcardRequestHeadersSupport: {
      DCHECK(message->is_serialized());
      internal::NetworkContext_SetCorsNonWildcardRequestHeadersSupport_Params_Data* params =
          reinterpret_cast<internal::NetworkContext_SetCorsNonWildcardRequestHeadersSupport_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NetworkContext.69
      bool success = true;
      bool p_value{};
      NetworkContext_SetCorsNonWildcardRequestHeadersSupport_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_value = input_data_view.value();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 69, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetCorsNonWildcardRequestHeadersSupport(        
        std::move(p_value));
      return true;
    }
    case messages::NetworkContext::kLookupServerBasicAuthCredentials: {
      break;
    }
    case messages::NetworkContext::kEnableStaticKeyPinningForTesting: {
      break;
    }
    case messages::NetworkContext::kVerifyCertificateForTesting: {
      break;
    }
    case messages::NetworkContext::kGetTrustAnchorIDsForTesting: {
      break;
    }
    case messages::NetworkContext::kAddDomainReliabilityContextForTesting: {
      break;
    }
    case messages::NetworkContext::kForceDomainReliabilityUploadsForTesting: {
      break;
    }
    case messages::NetworkContext::kSetSCTAuditingMode: {
      DCHECK(message->is_serialized());
      internal::NetworkContext_SetSCTAuditingMode_Params_Data* params =
          reinterpret_cast<internal::NetworkContext_SetSCTAuditingMode_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NetworkContext.76
      bool success = true;
      SCTAuditingMode p_mode{};
      NetworkContext_SetSCTAuditingMode_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMode(&p_mode))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 76, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetSCTAuditingMode(        
        std::move(p_mode));
      return true;
    }
    case messages::NetworkContext::kGetSharedDictionaryUsageInfo: {
      break;
    }
    case messages::NetworkContext::kGetSharedDictionaryInfo: {
      break;
    }
    case messages::NetworkContext::kGetSharedDictionaryOriginsBetween: {
      break;
    }
    case messages::NetworkContext::kSetSharedDictionaryCacheMaxSize: {
      DCHECK(message->is_serialized());
      internal::NetworkContext_SetSharedDictionaryCacheMaxSize_Params_Data* params =
          reinterpret_cast<internal::NetworkContext_SetSharedDictionaryCacheMaxSize_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NetworkContext.80
      bool success = true;
      uint64_t p_cache_max_size{};
      NetworkContext_SetSharedDictionaryCacheMaxSize_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_cache_max_size = input_data_view.cache_max_size();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 80, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetSharedDictionaryCacheMaxSize(        
        std::move(p_cache_max_size));
      return true;
    }
    case messages::NetworkContext::kPreloadSharedDictionaryInfoForDocument: {
      DCHECK(message->is_serialized());
      internal::NetworkContext_PreloadSharedDictionaryInfoForDocument_Params_Data* params =
          reinterpret_cast<internal::NetworkContext_PreloadSharedDictionaryInfoForDocument_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NetworkContext.81
      bool success = true;
      std::vector<::GURL> p_urls{};
      ::mojo::PendingReceiver<PreloadedSharedDictionaryInfoHandle> p_preload_handle{};
      NetworkContext_PreloadSharedDictionaryInfoForDocument_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrls(&p_urls))
        success = false;
      if (success) {
        p_preload_handle =
            input_data_view.TakePreloadHandle<decltype(p_preload_handle)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 81, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PreloadSharedDictionaryInfoForDocument(        
        std::move(p_urls), 
        std::move(p_preload_handle));
      return true;
    }
    case messages::NetworkContext::kHasPreloadedSharedDictionaryInfoForTesting: {
      break;
    }
    case messages::NetworkContext::kResourceSchedulerClientVisibilityChanged: {
      DCHECK(message->is_serialized());
      internal::NetworkContext_ResourceSchedulerClientVisibilityChanged_Params_Data* params =
          reinterpret_cast<internal::NetworkContext_ResourceSchedulerClientVisibilityChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NetworkContext.83
      bool success = true;
      ::base::UnguessableToken p_client_token{};
      bool p_visible{};
      NetworkContext_ResourceSchedulerClientVisibilityChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadClientToken(&p_client_token))
        success = false;
      if (success)
        p_visible = input_data_view.visible();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 83, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ResourceSchedulerClientVisibilityChanged(        
        std::move(p_client_token), 
        std::move(p_visible));
      return true;
    }
    case messages::NetworkContext::kFlushCachedClientCertIfNeeded: {
      DCHECK(message->is_serialized());
      internal::NetworkContext_FlushCachedClientCertIfNeeded_Params_Data* params =
          reinterpret_cast<internal::NetworkContext_FlushCachedClientCertIfNeeded_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NetworkContext.84
      bool success = true;
      ::net::HostPortPair p_host{};
      ::scoped_refptr<::net::X509Certificate> p_certificate{};
      NetworkContext_FlushCachedClientCertIfNeeded_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadHost(&p_host))
        success = false;
      if (success && !input_data_view.ReadCertificate(&p_certificate))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 84, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FlushCachedClientCertIfNeeded(        
        std::move(p_host), 
        std::move(p_certificate));
      return true;
    }
    case messages::NetworkContext::kFlushMatchingCachedClientCert: {
      DCHECK(message->is_serialized());
      internal::NetworkContext_FlushMatchingCachedClientCert_Params_Data* params =
          reinterpret_cast<internal::NetworkContext_FlushMatchingCachedClientCert_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NetworkContext.85
      bool success = true;
      ::scoped_refptr<::net::X509Certificate> p_certificate{};
      NetworkContext_FlushMatchingCachedClientCert_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCertificate(&p_certificate))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 85, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FlushMatchingCachedClientCert(        
        std::move(p_certificate));
      return true;
    }
    case messages::NetworkContext::kSetCookieDeprecationLabel: {
      DCHECK(message->is_serialized());
      internal::NetworkContext_SetCookieDeprecationLabel_Params_Data* params =
          reinterpret_cast<internal::NetworkContext_SetCookieDeprecationLabel_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NetworkContext.86
      bool success = true;
      std::optional<std::string> p_label{};
      NetworkContext_SetCookieDeprecationLabel_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLabel(&p_label))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 86, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetCookieDeprecationLabel(        
        std::move(p_label));
      return true;
    }
    case messages::NetworkContext::kRevokeNetworkForNonces: {
      break;
    }
    case messages::NetworkContext::kClearNonces: {
      DCHECK(message->is_serialized());
      internal::NetworkContext_ClearNonces_Params_Data* params =
          reinterpret_cast<internal::NetworkContext_ClearNonces_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NetworkContext.88
      bool success = true;
      std::vector<::base::UnguessableToken> p_nonces{};
      NetworkContext_ClearNonces_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNonces(&p_nonces))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 88, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearNonces(        
        std::move(p_nonces));
      return true;
    }
    case messages::NetworkContext::kExemptUrlFromNetworkRevocationForNonce: {
      break;
    }
    case messages::NetworkContext::kPrefetch: {
      DCHECK(message->is_serialized());
      internal::NetworkContext_Prefetch_Params_Data* params =
          reinterpret_cast<internal::NetworkContext_Prefetch_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NetworkContext.90
      bool success = true;
      int32_t p_request_id{};
      uint32_t p_options{};
      ::network::ResourceRequest p_request{};
      ::net::MutableNetworkTrafficAnnotationTag p_traffic_annotation{};
      NetworkContext_Prefetch_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_request_id = input_data_view.request_id();
      if (success)
        p_options = input_data_view.options();
      if (success && !input_data_view.ReadRequest(&p_request))
        success = false;
      if (success && !input_data_view.ReadTrafficAnnotation(&p_traffic_annotation))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 90, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Prefetch(        
        std::move(p_request_id), 
        std::move(p_options), 
        p_request, 
        std::move(p_traffic_annotation));
      return true;
    }
    case messages::NetworkContext::kGetBoundNetworkForTesting: {
      break;
    }
    case messages::NetworkContext::kGetDeviceBoundSessionManager: {
      DCHECK(message->is_serialized());
      internal::NetworkContext_GetDeviceBoundSessionManager_Params_Data* params =
          reinterpret_cast<internal::NetworkContext_GetDeviceBoundSessionManager_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NetworkContext.92
      bool success = true;
      ::mojo::PendingReceiver<::network::mojom::DeviceBoundSessionManager> p_device_bound_session_manager{};
      NetworkContext_GetDeviceBoundSessionManager_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_device_bound_session_manager =
            input_data_view.TakeDeviceBoundSessionManager<decltype(p_device_bound_session_manager)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 92, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetDeviceBoundSessionManager(        
        std::move(p_device_bound_session_manager));
      return true;
    }
  }
  return false;
}

// static
bool NetworkContextStubDispatch::AcceptWithResponder(
    NetworkContext* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::NetworkContext>(message->header()->name)) {
    case messages::NetworkContext::kSetClient: {
      break;
    }
    case messages::NetworkContext::kCreateURLLoaderFactory: {
      break;
    }
    case messages::NetworkContext::kResetURLLoaderFactories: {
      break;
    }
    case messages::NetworkContext::kGetViaObliviousHttp: {
      break;
    }
    case messages::NetworkContext::kGetCookieManager: {
      break;
    }
    case messages::NetworkContext::kGetRestrictedCookieManager: {
      break;
    }
    case messages::NetworkContext::kGetTrustTokenQueryAnswerer: {
      break;
    }
    case messages::NetworkContext::kClearTrustTokenData: {
      internal::NetworkContext_ClearTrustTokenData_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_ClearTrustTokenData_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetworkContext.7
      bool success = true;
      ::network::mojom::ClearDataFilterPtr p_filter{};
      NetworkContext_ClearTrustTokenData_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFilter(&p_filter))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 7, false);
        return false;
      }
      auto callback =
          NetworkContext_ClearTrustTokenData_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearTrustTokenData(        
        std::move(p_filter), std::move(callback));
      return true;
    }
    case messages::NetworkContext::kClearTrustTokenSessionOnlyData: {
      internal::NetworkContext_ClearTrustTokenSessionOnlyData_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_ClearTrustTokenSessionOnlyData_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetworkContext.8
      bool success = true;
      NetworkContext_ClearTrustTokenSessionOnlyData_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 8, false);
        return false;
      }
      auto callback =
          NetworkContext_ClearTrustTokenSessionOnlyData_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearTrustTokenSessionOnlyData(std::move(callback));
      return true;
    }
    case messages::NetworkContext::kGetStoredTrustTokenCounts: {
      internal::NetworkContext_GetStoredTrustTokenCounts_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_GetStoredTrustTokenCounts_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetworkContext.9
      bool success = true;
      NetworkContext_GetStoredTrustTokenCounts_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 9, false);
        return false;
      }
      auto callback =
          NetworkContext_GetStoredTrustTokenCounts_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetStoredTrustTokenCounts(std::move(callback));
      return true;
    }
    case messages::NetworkContext::kGetPrivateStateTokenRedemptionRecords: {
      internal::NetworkContext_GetPrivateStateTokenRedemptionRecords_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_GetPrivateStateTokenRedemptionRecords_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetworkContext.10
      bool success = true;
      NetworkContext_GetPrivateStateTokenRedemptionRecords_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 10, false);
        return false;
      }
      auto callback =
          NetworkContext_GetPrivateStateTokenRedemptionRecords_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetPrivateStateTokenRedemptionRecords(std::move(callback));
      return true;
    }
    case messages::NetworkContext::kDeleteStoredTrustTokens: {
      internal::NetworkContext_DeleteStoredTrustTokens_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_DeleteStoredTrustTokens_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetworkContext.11
      bool success = true;
      ::url::Origin p_issuer{};
      NetworkContext_DeleteStoredTrustTokens_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadIssuer(&p_issuer))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 11, false);
        return false;
      }
      auto callback =
          NetworkContext_DeleteStoredTrustTokens_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeleteStoredTrustTokens(        
        std::move(p_issuer), std::move(callback));
      return true;
    }
    case messages::NetworkContext::kSetBlockTrustTokens: {
      break;
    }
    case messages::NetworkContext::kSetTrackingProtectionContentSetting: {
      break;
    }
    case messages::NetworkContext::kClearNetworkingHistoryBetween: {
      internal::NetworkContext_ClearNetworkingHistoryBetween_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_ClearNetworkingHistoryBetween_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetworkContext.14
      bool success = true;
      ::base::Time p_start_time{};
      ::base::Time p_end_time{};
      NetworkContext_ClearNetworkingHistoryBetween_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStartTime(&p_start_time))
        success = false;
      if (success && !input_data_view.ReadEndTime(&p_end_time))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 14, false);
        return false;
      }
      auto callback =
          NetworkContext_ClearNetworkingHistoryBetween_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearNetworkingHistoryBetween(        
        std::move(p_start_time), 
        std::move(p_end_time), std::move(callback));
      return true;
    }
    case messages::NetworkContext::kClearHttpCache: {
      internal::NetworkContext_ClearHttpCache_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_ClearHttpCache_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetworkContext.15
      bool success = true;
      ::base::Time p_start_time{};
      ::base::Time p_end_time{};
      ::network::mojom::ClearDataFilterPtr p_filter{};
      NetworkContext_ClearHttpCache_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStartTime(&p_start_time))
        success = false;
      if (success && !input_data_view.ReadEndTime(&p_end_time))
        success = false;
      if (success && !input_data_view.ReadFilter(&p_filter))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 15, false);
        return false;
      }
      auto callback =
          NetworkContext_ClearHttpCache_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearHttpCache(        
        std::move(p_start_time), 
        std::move(p_end_time), 
        std::move(p_filter), std::move(callback));
      return true;
    }
    case messages::NetworkContext::kComputeHttpCacheSize: {
      internal::NetworkContext_ComputeHttpCacheSize_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_ComputeHttpCacheSize_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetworkContext.16
      bool success = true;
      ::base::Time p_start_time{};
      ::base::Time p_end_time{};
      NetworkContext_ComputeHttpCacheSize_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStartTime(&p_start_time))
        success = false;
      if (success && !input_data_view.ReadEndTime(&p_end_time))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 16, false);
        return false;
      }
      auto callback =
          NetworkContext_ComputeHttpCacheSize_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ComputeHttpCacheSize(        
        std::move(p_start_time), 
        std::move(p_end_time), std::move(callback));
      return true;
    }
    case messages::NetworkContext::kNotifyExternalCacheHit: {
      break;
    }
    case messages::NetworkContext::kClearHostCache: {
      internal::NetworkContext_ClearHostCache_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_ClearHostCache_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetworkContext.18
      bool success = true;
      ::network::mojom::ClearDataFilterPtr p_filter{};
      NetworkContext_ClearHostCache_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFilter(&p_filter))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 18, false);
        return false;
      }
      auto callback =
          NetworkContext_ClearHostCache_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearHostCache(        
        std::move(p_filter), std::move(callback));
      return true;
    }
    case messages::NetworkContext::kClearHttpAuthCache: {
      internal::NetworkContext_ClearHttpAuthCache_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_ClearHttpAuthCache_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetworkContext.19
      bool success = true;
      ::base::Time p_start_time{};
      ::base::Time p_end_time{};
      ::network::mojom::ClearDataFilterPtr p_filter{};
      NetworkContext_ClearHttpAuthCache_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStartTime(&p_start_time))
        success = false;
      if (success && !input_data_view.ReadEndTime(&p_end_time))
        success = false;
      if (success && !input_data_view.ReadFilter(&p_filter))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 19, false);
        return false;
      }
      auto callback =
          NetworkContext_ClearHttpAuthCache_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearHttpAuthCache(        
        std::move(p_start_time), 
        std::move(p_end_time), 
        std::move(p_filter), std::move(callback));
      return true;
    }
    case messages::NetworkContext::kClearCorsPreflightCache: {
      internal::NetworkContext_ClearCorsPreflightCache_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_ClearCorsPreflightCache_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetworkContext.20
      bool success = true;
      ::network::mojom::ClearDataFilterPtr p_filter{};
      NetworkContext_ClearCorsPreflightCache_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFilter(&p_filter))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 20, false);
        return false;
      }
      auto callback =
          NetworkContext_ClearCorsPreflightCache_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearCorsPreflightCache(        
        std::move(p_filter), std::move(callback));
      return true;
    }
    case messages::NetworkContext::kClearReportingCacheReports: {
      internal::NetworkContext_ClearReportingCacheReports_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_ClearReportingCacheReports_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetworkContext.21
      bool success = true;
      ::network::mojom::ClearDataFilterPtr p_filter{};
      NetworkContext_ClearReportingCacheReports_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFilter(&p_filter))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 21, false);
        return false;
      }
      auto callback =
          NetworkContext_ClearReportingCacheReports_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearReportingCacheReports(        
        std::move(p_filter), std::move(callback));
      return true;
    }
    case messages::NetworkContext::kClearReportingCacheClients: {
      internal::NetworkContext_ClearReportingCacheClients_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_ClearReportingCacheClients_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetworkContext.22
      bool success = true;
      ::network::mojom::ClearDataFilterPtr p_filter{};
      NetworkContext_ClearReportingCacheClients_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFilter(&p_filter))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 22, false);
        return false;
      }
      auto callback =
          NetworkContext_ClearReportingCacheClients_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearReportingCacheClients(        
        std::move(p_filter), std::move(callback));
      return true;
    }
    case messages::NetworkContext::kClearNetworkErrorLogging: {
      internal::NetworkContext_ClearNetworkErrorLogging_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_ClearNetworkErrorLogging_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetworkContext.23
      bool success = true;
      ::network::mojom::ClearDataFilterPtr p_filter{};
      NetworkContext_ClearNetworkErrorLogging_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFilter(&p_filter))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 23, false);
        return false;
      }
      auto callback =
          NetworkContext_ClearNetworkErrorLogging_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearNetworkErrorLogging(        
        std::move(p_filter), std::move(callback));
      return true;
    }
    case messages::NetworkContext::kClearDomainReliability: {
      internal::NetworkContext_ClearDomainReliability_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_ClearDomainReliability_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetworkContext.24
      bool success = true;
      ::network::mojom::ClearDataFilterPtr p_filter{};
      NetworkContext::DomainReliabilityClearMode p_mode{};
      NetworkContext_ClearDomainReliability_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFilter(&p_filter))
        success = false;
      if (success && !input_data_view.ReadMode(&p_mode))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 24, false);
        return false;
      }
      auto callback =
          NetworkContext_ClearDomainReliability_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearDomainReliability(        
        std::move(p_filter), 
        std::move(p_mode), std::move(callback));
      return true;
    }
    case messages::NetworkContext::kClearSharedDictionaryCache: {
      internal::NetworkContext_ClearSharedDictionaryCache_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_ClearSharedDictionaryCache_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetworkContext.25
      bool success = true;
      ::base::Time p_start_time{};
      ::base::Time p_end_time{};
      ::network::mojom::ClearDataFilterPtr p_filter{};
      NetworkContext_ClearSharedDictionaryCache_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStartTime(&p_start_time))
        success = false;
      if (success && !input_data_view.ReadEndTime(&p_end_time))
        success = false;
      if (success && !input_data_view.ReadFilter(&p_filter))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 25, false);
        return false;
      }
      auto callback =
          NetworkContext_ClearSharedDictionaryCache_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearSharedDictionaryCache(        
        std::move(p_start_time), 
        std::move(p_end_time), 
        std::move(p_filter), std::move(callback));
      return true;
    }
    case messages::NetworkContext::kClearSharedDictionaryCacheForIsolationKey: {
      internal::NetworkContext_ClearSharedDictionaryCacheForIsolationKey_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_ClearSharedDictionaryCacheForIsolationKey_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetworkContext.26
      bool success = true;
      ::net::SharedDictionaryIsolationKey p_isolation_key{};
      NetworkContext_ClearSharedDictionaryCacheForIsolationKey_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadIsolationKey(&p_isolation_key))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 26, false);
        return false;
      }
      auto callback =
          NetworkContext_ClearSharedDictionaryCacheForIsolationKey_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearSharedDictionaryCacheForIsolationKey(        
        std::move(p_isolation_key), std::move(callback));
      return true;
    }
    case messages::NetworkContext::kSetDocumentReportingEndpoints: {
      break;
    }
    case messages::NetworkContext::kSetEnterpriseReportingEndpoints: {
      break;
    }
    case messages::NetworkContext::kSendReportsAndRemoveSource: {
      break;
    }
    case messages::NetworkContext::kQueueReport: {
      break;
    }
    case messages::NetworkContext::kQueueEnterpriseReport: {
      break;
    }
    case messages::NetworkContext::kQueueSignedExchangeReport: {
      break;
    }
    case messages::NetworkContext::kCloseAllConnections: {
      internal::NetworkContext_CloseAllConnections_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_CloseAllConnections_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetworkContext.33
      bool success = true;
      NetworkContext_CloseAllConnections_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 33, false);
        return false;
      }
      auto callback =
          NetworkContext_CloseAllConnections_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CloseAllConnections(std::move(callback));
      return true;
    }
    case messages::NetworkContext::kCloseIdleConnections: {
      internal::NetworkContext_CloseIdleConnections_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_CloseIdleConnections_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetworkContext.34
      bool success = true;
      NetworkContext_CloseIdleConnections_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 34, false);
        return false;
      }
      auto callback =
          NetworkContext_CloseIdleConnections_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CloseIdleConnections(std::move(callback));
      return true;
    }
    case messages::NetworkContext::kSetNetworkConditions: {
      break;
    }
    case messages::NetworkContext::kSetAcceptLanguage: {
      break;
    }
    case messages::NetworkContext::kSetUserAgent: {
      break;
    }
    case messages::NetworkContext::kSetEnableReferrers: {
      break;
    }
    case messages::NetworkContext::kSetCTPolicy: {
      break;
    }
    case messages::NetworkContext::kCreateUDPSocket: {
      break;
    }
    case messages::NetworkContext::kCreateRestrictedUDPSocket: {
      internal::NetworkContext_CreateRestrictedUDPSocket_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_CreateRestrictedUDPSocket_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetworkContext.41
      bool success = true;
      ::net::IPEndPoint p_addr{};
      ::network::mojom::RestrictedUDPSocketMode p_mode{};
      ::net::MutableNetworkTrafficAnnotationTag p_traffic_annotation{};
      ::network::mojom::RestrictedUDPSocketParamsPtr p_params{};
      ::mojo::PendingReceiver<::network::mojom::RestrictedUDPSocket> p_receiver{};
      ::mojo::PendingRemote<::network::mojom::UDPSocketListener> p_listener{};
      NetworkContext_CreateRestrictedUDPSocket_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAddr(&p_addr))
        success = false;
      if (success && !input_data_view.ReadMode(&p_mode))
        success = false;
      if (success && !input_data_view.ReadTrafficAnnotation(&p_traffic_annotation))
        success = false;
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (success) {
        p_listener =
            input_data_view.TakeListener<decltype(p_listener)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 41, false);
        return false;
      }
      auto callback =
          NetworkContext_CreateRestrictedUDPSocket_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateRestrictedUDPSocket(        
        std::move(p_addr), 
        std::move(p_mode), 
        std::move(p_traffic_annotation), 
        std::move(p_params), 
        std::move(p_receiver), 
        std::move(p_listener), std::move(callback));
      return true;
    }
    case messages::NetworkContext::kCreateTCPServerSocket: {
      internal::NetworkContext_CreateTCPServerSocket_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_CreateTCPServerSocket_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetworkContext.42
      bool success = true;
      ::net::IPEndPoint p_local_addr{};
      ::network::mojom::TCPServerSocketOptionsPtr p_options{};
      ::net::MutableNetworkTrafficAnnotationTag p_traffic_annotation{};
      ::mojo::PendingReceiver<::network::mojom::TCPServerSocket> p_socket{};
      NetworkContext_CreateTCPServerSocket_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLocalAddr(&p_local_addr))
        success = false;
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (success && !input_data_view.ReadTrafficAnnotation(&p_traffic_annotation))
        success = false;
      if (success) {
        p_socket =
            input_data_view.TakeSocket<decltype(p_socket)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 42, false);
        return false;
      }
      auto callback =
          NetworkContext_CreateTCPServerSocket_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateTCPServerSocket(        
        std::move(p_local_addr), 
        std::move(p_options), 
        std::move(p_traffic_annotation), 
        std::move(p_socket), std::move(callback));
      return true;
    }
    case messages::NetworkContext::kCreateTCPConnectedSocket: {
      internal::NetworkContext_CreateTCPConnectedSocket_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_CreateTCPConnectedSocket_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetworkContext.43
      bool success = true;
      std::optional<::net::IPEndPoint> p_local_addr{};
      ::net::AddressList p_remote_addr_list{};
      ::network::mojom::TCPConnectedSocketOptionsPtr p_tcp_connected_socket_options{};
      ::net::MutableNetworkTrafficAnnotationTag p_traffic_annotation{};
      ::mojo::PendingReceiver<::network::mojom::TCPConnectedSocket> p_socket{};
      ::mojo::PendingRemote<::network::mojom::SocketObserver> p_observer{};
      NetworkContext_CreateTCPConnectedSocket_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLocalAddr(&p_local_addr))
        success = false;
      if (success && !input_data_view.ReadRemoteAddrList(&p_remote_addr_list))
        success = false;
      if (success && !input_data_view.ReadTcpConnectedSocketOptions(&p_tcp_connected_socket_options))
        success = false;
      if (success && !input_data_view.ReadTrafficAnnotation(&p_traffic_annotation))
        success = false;
      if (success) {
        p_socket =
            input_data_view.TakeSocket<decltype(p_socket)>();
      }
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 43, false);
        return false;
      }
      auto callback =
          NetworkContext_CreateTCPConnectedSocket_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateTCPConnectedSocket(        
        std::move(p_local_addr), 
        std::move(p_remote_addr_list), 
        std::move(p_tcp_connected_socket_options), 
        std::move(p_traffic_annotation), 
        std::move(p_socket), 
        std::move(p_observer), std::move(callback));
      return true;
    }
    case messages::NetworkContext::kCreateTCPBoundSocket: {
      internal::NetworkContext_CreateTCPBoundSocket_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_CreateTCPBoundSocket_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetworkContext.44
      bool success = true;
      ::net::IPEndPoint p_local_addr{};
      ::net::MutableNetworkTrafficAnnotationTag p_traffic_annotation{};
      ::mojo::PendingReceiver<::network::mojom::TCPBoundSocket> p_socket{};
      NetworkContext_CreateTCPBoundSocket_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLocalAddr(&p_local_addr))
        success = false;
      if (success && !input_data_view.ReadTrafficAnnotation(&p_traffic_annotation))
        success = false;
      if (success) {
        p_socket =
            input_data_view.TakeSocket<decltype(p_socket)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 44, false);
        return false;
      }
      auto callback =
          NetworkContext_CreateTCPBoundSocket_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateTCPBoundSocket(        
        std::move(p_local_addr), 
        std::move(p_traffic_annotation), 
        std::move(p_socket), std::move(callback));
      return true;
    }
    case messages::NetworkContext::kCreateProxyResolvingSocketFactory: {
      break;
    }
    case messages::NetworkContext::kLookUpProxyForURL: {
      break;
    }
    case messages::NetworkContext::kForceReloadProxyConfig: {
      internal::NetworkContext_ForceReloadProxyConfig_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_ForceReloadProxyConfig_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetworkContext.47
      bool success = true;
      NetworkContext_ForceReloadProxyConfig_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 47, false);
        return false;
      }
      auto callback =
          NetworkContext_ForceReloadProxyConfig_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ForceReloadProxyConfig(std::move(callback));
      return true;
    }
    case messages::NetworkContext::kClearBadProxiesCache: {
      internal::NetworkContext_ClearBadProxiesCache_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_ClearBadProxiesCache_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetworkContext.48
      bool success = true;
      NetworkContext_ClearBadProxiesCache_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 48, false);
        return false;
      }
      auto callback =
          NetworkContext_ClearBadProxiesCache_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearBadProxiesCache(std::move(callback));
      return true;
    }
    case messages::NetworkContext::kCreateWebSocket: {
      break;
    }
    case messages::NetworkContext::kCreateWebTransport: {
      break;
    }
    case messages::NetworkContext::kCreateNetLogExporter: {
      break;
    }
    case messages::NetworkContext::kPreconnectSockets: {
      break;
    }
    case messages::NetworkContext::kCreateP2PSocketManager: {
      break;
    }
    case messages::NetworkContext::kCreateMdnsResponder: {
      break;
    }
    case messages::NetworkContext::kResolveHost: {
      break;
    }
    case messages::NetworkContext::kCreateHostResolver: {
      break;
    }
    case messages::NetworkContext::kVerifyCert: {
      internal::NetworkContext_VerifyCert_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_VerifyCert_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetworkContext.57
      bool success = true;
      ::scoped_refptr<::net::X509Certificate> p_certificate{};
      ::net::HostPortPair p_host_port{};
      std::string p_ocsp_response{};
      std::string p_sct_list{};
      NetworkContext_VerifyCert_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCertificate(&p_certificate))
        success = false;
      if (success && !input_data_view.ReadHostPort(&p_host_port))
        success = false;
      if (success && !input_data_view.ReadOcspResponse(&p_ocsp_response))
        success = false;
      if (success && !input_data_view.ReadSctList(&p_sct_list))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 57, false);
        return false;
      }
      auto callback =
          NetworkContext_VerifyCert_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->VerifyCert(        
        std::move(p_certificate), 
        std::move(p_host_port), 
        std::move(p_ocsp_response), 
        std::move(p_sct_list), std::move(callback));
      return true;
    }
    case messages::NetworkContext::kVerifyCertForSignedExchange: {
      internal::NetworkContext_VerifyCertForSignedExchange_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_VerifyCertForSignedExchange_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetworkContext.58
      bool success = true;
      ::scoped_refptr<::net::X509Certificate> p_certificate{};
      ::net::HostPortPair p_host_port{};
      std::string p_ocsp_response{};
      std::string p_sct_list{};
      NetworkContext_VerifyCertForSignedExchange_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCertificate(&p_certificate))
        success = false;
      if (success && !input_data_view.ReadHostPort(&p_host_port))
        success = false;
      if (success && !input_data_view.ReadOcspResponse(&p_ocsp_response))
        success = false;
      if (success && !input_data_view.ReadSctList(&p_sct_list))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 58, false);
        return false;
      }
      auto callback =
          NetworkContext_VerifyCertForSignedExchange_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->VerifyCertForSignedExchange(        
        std::move(p_certificate), 
        std::move(p_host_port), 
        std::move(p_ocsp_response), 
        std::move(p_sct_list), std::move(callback));
      return true;
    }
    case messages::NetworkContext::kVerify2QwacCertBinding: {
      internal::NetworkContext_Verify2QwacCertBinding_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_Verify2QwacCertBinding_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetworkContext.59
      bool success = true;
      std::string p_binding{};
      std::string p_hostname{};
      ::scoped_refptr<::net::X509Certificate> p_tls_certificate{};
      NetworkContext_Verify2QwacCertBinding_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBinding(&p_binding))
        success = false;
      if (success && !input_data_view.ReadHostname(&p_hostname))
        success = false;
      if (success && !input_data_view.ReadTlsCertificate(&p_tls_certificate))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 59, false);
        return false;
      }
      auto callback =
          NetworkContext_Verify2QwacCertBinding_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Verify2QwacCertBinding(        
        std::move(p_binding), 
        std::move(p_hostname), 
        std::move(p_tls_certificate), std::move(callback));
      return true;
    }
    case messages::NetworkContext::kAddHSTS: {
      internal::NetworkContext_AddHSTS_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_AddHSTS_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetworkContext.60
      bool success = true;
      std::string p_host{};
      ::base::Time p_expiry{};
      bool p_include_subdomains{};
      NetworkContext_AddHSTS_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadHost(&p_host))
        success = false;
      if (success && !input_data_view.ReadExpiry(&p_expiry))
        success = false;
      if (success)
        p_include_subdomains = input_data_view.include_subdomains();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 60, false);
        return false;
      }
      auto callback =
          NetworkContext_AddHSTS_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddHSTS(        
        std::move(p_host), 
        std::move(p_expiry), 
        std::move(p_include_subdomains), std::move(callback));
      return true;
    }
    case messages::NetworkContext::kIsHSTSActiveForHost: {
      internal::NetworkContext_IsHSTSActiveForHost_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_IsHSTSActiveForHost_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetworkContext.61
      bool success = true;
      std::string p_host{};
      bool p_is_top_level_nav{};
      NetworkContext_IsHSTSActiveForHost_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadHost(&p_host))
        success = false;
      if (success)
        p_is_top_level_nav = input_data_view.is_top_level_nav();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 61, false);
        return false;
      }
      auto callback =
          NetworkContext_IsHSTSActiveForHost_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->IsHSTSActiveForHost(        
        std::move(p_host), 
        std::move(p_is_top_level_nav), std::move(callback));
      return true;
    }
    case messages::NetworkContext::kGetHSTSState: {
      internal::NetworkContext_GetHSTSState_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_GetHSTSState_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetworkContext.62
      bool success = true;
      std::string p_domain{};
      NetworkContext_GetHSTSState_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDomain(&p_domain))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 62, false);
        return false;
      }
      auto callback =
          NetworkContext_GetHSTSState_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetHSTSState(        
        std::move(p_domain), std::move(callback));
      return true;
    }
    case messages::NetworkContext::kSetCorsOriginAccessListsForOrigin: {
      internal::NetworkContext_SetCorsOriginAccessListsForOrigin_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_SetCorsOriginAccessListsForOrigin_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetworkContext.63
      bool success = true;
      ::url::Origin p_source_origin{};
      std::vector<::network::mojom::CorsOriginPatternPtr> p_allow_patterns{};
      std::vector<::network::mojom::CorsOriginPatternPtr> p_block_patterns{};
      NetworkContext_SetCorsOriginAccessListsForOrigin_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSourceOrigin(&p_source_origin))
        success = false;
      if (success && !input_data_view.ReadAllowPatterns(&p_allow_patterns))
        success = false;
      if (success && !input_data_view.ReadBlockPatterns(&p_block_patterns))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 63, false);
        return false;
      }
      auto callback =
          NetworkContext_SetCorsOriginAccessListsForOrigin_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetCorsOriginAccessListsForOrigin(        
        std::move(p_source_origin), 
        std::move(p_allow_patterns), 
        std::move(p_block_patterns), std::move(callback));
      return true;
    }
    case messages::NetworkContext::kDeleteDynamicDataForHost: {
      internal::NetworkContext_DeleteDynamicDataForHost_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_DeleteDynamicDataForHost_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetworkContext.64
      bool success = true;
      std::string p_host{};
      NetworkContext_DeleteDynamicDataForHost_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadHost(&p_host))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 64, false);
        return false;
      }
      auto callback =
          NetworkContext_DeleteDynamicDataForHost_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeleteDynamicDataForHost(        
        std::move(p_host), std::move(callback));
      return true;
    }
    case messages::NetworkContext::kSetSplitAuthCacheByNetworkAnonymizationKey: {
      break;
    }
    case messages::NetworkContext::kSaveHttpAuthCacheProxyEntries: {
      internal::NetworkContext_SaveHttpAuthCacheProxyEntries_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_SaveHttpAuthCacheProxyEntries_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetworkContext.66
      bool success = true;
      NetworkContext_SaveHttpAuthCacheProxyEntries_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 66, false);
        return false;
      }
      auto callback =
          NetworkContext_SaveHttpAuthCacheProxyEntries_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SaveHttpAuthCacheProxyEntries(std::move(callback));
      return true;
    }
    case messages::NetworkContext::kLoadHttpAuthCacheProxyEntries: {
      internal::NetworkContext_LoadHttpAuthCacheProxyEntries_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_LoadHttpAuthCacheProxyEntries_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetworkContext.67
      bool success = true;
      ::base::UnguessableToken p_cache_key{};
      NetworkContext_LoadHttpAuthCacheProxyEntries_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCacheKey(&p_cache_key))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 67, false);
        return false;
      }
      auto callback =
          NetworkContext_LoadHttpAuthCacheProxyEntries_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->LoadHttpAuthCacheProxyEntries(        
        std::move(p_cache_key), std::move(callback));
      return true;
    }
    case messages::NetworkContext::kAddAuthCacheEntry: {
      internal::NetworkContext_AddAuthCacheEntry_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_AddAuthCacheEntry_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetworkContext.68
      bool success = true;
      ::net::AuthChallengeInfo p_challenge{};
      ::net::NetworkAnonymizationKey p_network_anonymization_key{};
      ::net::AuthCredentials p_credentials{};
      NetworkContext_AddAuthCacheEntry_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadChallenge(&p_challenge))
        success = false;
      if (success && !input_data_view.ReadNetworkAnonymizationKey(&p_network_anonymization_key))
        success = false;
      if (success && !input_data_view.ReadCredentials(&p_credentials))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 68, false);
        return false;
      }
      auto callback =
          NetworkContext_AddAuthCacheEntry_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddAuthCacheEntry(        
        std::move(p_challenge), 
        std::move(p_network_anonymization_key), 
        std::move(p_credentials), std::move(callback));
      return true;
    }
    case messages::NetworkContext::kSetCorsNonWildcardRequestHeadersSupport: {
      break;
    }
    case messages::NetworkContext::kLookupServerBasicAuthCredentials: {
      internal::NetworkContext_LookupServerBasicAuthCredentials_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_LookupServerBasicAuthCredentials_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetworkContext.70
      bool success = true;
      ::GURL p_url{};
      ::net::NetworkAnonymizationKey p_network_anonymization_key{};
      NetworkContext_LookupServerBasicAuthCredentials_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadNetworkAnonymizationKey(&p_network_anonymization_key))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 70, false);
        return false;
      }
      auto callback =
          NetworkContext_LookupServerBasicAuthCredentials_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->LookupServerBasicAuthCredentials(        
        std::move(p_url), 
        std::move(p_network_anonymization_key), std::move(callback));
      return true;
    }
    case messages::NetworkContext::kEnableStaticKeyPinningForTesting: {
      internal::NetworkContext_EnableStaticKeyPinningForTesting_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_EnableStaticKeyPinningForTesting_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetworkContext.71
      bool success = true;
      NetworkContext_EnableStaticKeyPinningForTesting_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 71, false);
        return false;
      }
      auto callback =
          NetworkContext_EnableStaticKeyPinningForTesting_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EnableStaticKeyPinningForTesting(std::move(callback));
      return true;
    }
    case messages::NetworkContext::kVerifyCertificateForTesting: {
      internal::NetworkContext_VerifyCertificateForTesting_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_VerifyCertificateForTesting_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetworkContext.72
      bool success = true;
      ::scoped_refptr<::net::X509Certificate> p_certificate{};
      std::string p_hostname{};
      std::string p_ocsp_response{};
      std::string p_sct_list{};
      NetworkContext_VerifyCertificateForTesting_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCertificate(&p_certificate))
        success = false;
      if (success && !input_data_view.ReadHostname(&p_hostname))
        success = false;
      if (success && !input_data_view.ReadOcspResponse(&p_ocsp_response))
        success = false;
      if (success && !input_data_view.ReadSctList(&p_sct_list))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 72, false);
        return false;
      }
      auto callback =
          NetworkContext_VerifyCertificateForTesting_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->VerifyCertificateForTesting(        
        std::move(p_certificate), 
        std::move(p_hostname), 
        std::move(p_ocsp_response), 
        std::move(p_sct_list), std::move(callback));
      return true;
    }
    case messages::NetworkContext::kGetTrustAnchorIDsForTesting: {
      internal::NetworkContext_GetTrustAnchorIDsForTesting_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_GetTrustAnchorIDsForTesting_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetworkContext.73
      bool success = true;
      NetworkContext_GetTrustAnchorIDsForTesting_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 73, false);
        return false;
      }
      auto callback =
          NetworkContext_GetTrustAnchorIDsForTesting_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetTrustAnchorIDsForTesting(std::move(callback));
      return true;
    }
    case messages::NetworkContext::kAddDomainReliabilityContextForTesting: {
      internal::NetworkContext_AddDomainReliabilityContextForTesting_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_AddDomainReliabilityContextForTesting_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetworkContext.74
      bool success = true;
      ::url::Origin p_origin{};
      ::GURL p_upload_url{};
      NetworkContext_AddDomainReliabilityContextForTesting_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOrigin(&p_origin))
        success = false;
      if (success && !input_data_view.ReadUploadUrl(&p_upload_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 74, false);
        return false;
      }
      auto callback =
          NetworkContext_AddDomainReliabilityContextForTesting_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddDomainReliabilityContextForTesting(        
        std::move(p_origin), 
        std::move(p_upload_url), std::move(callback));
      return true;
    }
    case messages::NetworkContext::kForceDomainReliabilityUploadsForTesting: {
      internal::NetworkContext_ForceDomainReliabilityUploadsForTesting_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_ForceDomainReliabilityUploadsForTesting_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetworkContext.75
      bool success = true;
      NetworkContext_ForceDomainReliabilityUploadsForTesting_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 75, false);
        return false;
      }
      auto callback =
          NetworkContext_ForceDomainReliabilityUploadsForTesting_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ForceDomainReliabilityUploadsForTesting(std::move(callback));
      return true;
    }
    case messages::NetworkContext::kSetSCTAuditingMode: {
      break;
    }
    case messages::NetworkContext::kGetSharedDictionaryUsageInfo: {
      internal::NetworkContext_GetSharedDictionaryUsageInfo_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_GetSharedDictionaryUsageInfo_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetworkContext.77
      bool success = true;
      NetworkContext_GetSharedDictionaryUsageInfo_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 77, false);
        return false;
      }
      auto callback =
          NetworkContext_GetSharedDictionaryUsageInfo_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetSharedDictionaryUsageInfo(std::move(callback));
      return true;
    }
    case messages::NetworkContext::kGetSharedDictionaryInfo: {
      internal::NetworkContext_GetSharedDictionaryInfo_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_GetSharedDictionaryInfo_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetworkContext.78
      bool success = true;
      ::net::SharedDictionaryIsolationKey p_isolation_key{};
      NetworkContext_GetSharedDictionaryInfo_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadIsolationKey(&p_isolation_key))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 78, false);
        return false;
      }
      auto callback =
          NetworkContext_GetSharedDictionaryInfo_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetSharedDictionaryInfo(        
        std::move(p_isolation_key), std::move(callback));
      return true;
    }
    case messages::NetworkContext::kGetSharedDictionaryOriginsBetween: {
      internal::NetworkContext_GetSharedDictionaryOriginsBetween_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_GetSharedDictionaryOriginsBetween_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetworkContext.79
      bool success = true;
      ::base::Time p_start_time{};
      ::base::Time p_end_time{};
      NetworkContext_GetSharedDictionaryOriginsBetween_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStartTime(&p_start_time))
        success = false;
      if (success && !input_data_view.ReadEndTime(&p_end_time))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 79, false);
        return false;
      }
      auto callback =
          NetworkContext_GetSharedDictionaryOriginsBetween_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetSharedDictionaryOriginsBetween(        
        std::move(p_start_time), 
        std::move(p_end_time), std::move(callback));
      return true;
    }
    case messages::NetworkContext::kSetSharedDictionaryCacheMaxSize: {
      break;
    }
    case messages::NetworkContext::kPreloadSharedDictionaryInfoForDocument: {
      break;
    }
    case messages::NetworkContext::kHasPreloadedSharedDictionaryInfoForTesting: {
      internal::NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetworkContext.82
      bool success = true;
      NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 82, false);
        return false;
      }
      auto callback =
          NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->HasPreloadedSharedDictionaryInfoForTesting(std::move(callback));
      return true;
    }
    case messages::NetworkContext::kResourceSchedulerClientVisibilityChanged: {
      break;
    }
    case messages::NetworkContext::kFlushCachedClientCertIfNeeded: {
      break;
    }
    case messages::NetworkContext::kFlushMatchingCachedClientCert: {
      break;
    }
    case messages::NetworkContext::kSetCookieDeprecationLabel: {
      break;
    }
    case messages::NetworkContext::kRevokeNetworkForNonces: {
      internal::NetworkContext_RevokeNetworkForNonces_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_RevokeNetworkForNonces_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetworkContext.87
      bool success = true;
      std::vector<::base::UnguessableToken> p_nonces{};
      NetworkContext_RevokeNetworkForNonces_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNonces(&p_nonces))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 87, false);
        return false;
      }
      auto callback =
          NetworkContext_RevokeNetworkForNonces_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RevokeNetworkForNonces(        
        std::move(p_nonces), std::move(callback));
      return true;
    }
    case messages::NetworkContext::kClearNonces: {
      break;
    }
    case messages::NetworkContext::kExemptUrlFromNetworkRevocationForNonce: {
      internal::NetworkContext_ExemptUrlFromNetworkRevocationForNonce_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_ExemptUrlFromNetworkRevocationForNonce_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetworkContext.89
      bool success = true;
      ::GURL p_exempted_url{};
      ::base::UnguessableToken p_nonce{};
      NetworkContext_ExemptUrlFromNetworkRevocationForNonce_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadExemptedUrl(&p_exempted_url))
        success = false;
      if (success && !input_data_view.ReadNonce(&p_nonce))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 89, false);
        return false;
      }
      auto callback =
          NetworkContext_ExemptUrlFromNetworkRevocationForNonce_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ExemptUrlFromNetworkRevocationForNonce(        
        std::move(p_exempted_url), 
        std::move(p_nonce), std::move(callback));
      return true;
    }
    case messages::NetworkContext::kPrefetch: {
      break;
    }
    case messages::NetworkContext::kGetBoundNetworkForTesting: {
      internal::NetworkContext_GetBoundNetworkForTesting_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_GetBoundNetworkForTesting_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetworkContext.91
      bool success = true;
      NetworkContext_GetBoundNetworkForTesting_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 91, false);
        return false;
      }
      auto callback =
          NetworkContext_GetBoundNetworkForTesting_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetBoundNetworkForTesting(std::move(callback));
      return true;
    }
    case messages::NetworkContext::kGetDeviceBoundSessionManager: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kNetworkContextValidationInfo[] = {
    {base::to_underlying(messages::NetworkContext::kSetClient),
     { &internal::NetworkContext_SetClient_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::NetworkContext::kCreateURLLoaderFactory),
     { &internal::NetworkContext_CreateURLLoaderFactory_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::NetworkContext::kResetURLLoaderFactories),
     { &internal::NetworkContext_ResetURLLoaderFactories_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::NetworkContext::kGetViaObliviousHttp),
     { &internal::NetworkContext_GetViaObliviousHttp_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::NetworkContext::kGetCookieManager),
     { &internal::NetworkContext_GetCookieManager_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::NetworkContext::kGetRestrictedCookieManager),
     { &internal::NetworkContext_GetRestrictedCookieManager_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::NetworkContext::kGetTrustTokenQueryAnswerer),
     { &internal::NetworkContext_GetTrustTokenQueryAnswerer_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::NetworkContext::kClearTrustTokenData),
     { &internal::NetworkContext_ClearTrustTokenData_Params_Data::Validate,
      &internal::NetworkContext_ClearTrustTokenData_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::NetworkContext::kClearTrustTokenSessionOnlyData),
     { &internal::NetworkContext_ClearTrustTokenSessionOnlyData_Params_Data::Validate,
      &internal::NetworkContext_ClearTrustTokenSessionOnlyData_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::NetworkContext::kGetStoredTrustTokenCounts),
     { &internal::NetworkContext_GetStoredTrustTokenCounts_Params_Data::Validate,
      &internal::NetworkContext_GetStoredTrustTokenCounts_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::NetworkContext::kGetPrivateStateTokenRedemptionRecords),
     { &internal::NetworkContext_GetPrivateStateTokenRedemptionRecords_Params_Data::Validate,
      &internal::NetworkContext_GetPrivateStateTokenRedemptionRecords_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::NetworkContext::kDeleteStoredTrustTokens),
     { &internal::NetworkContext_DeleteStoredTrustTokens_Params_Data::Validate,
      &internal::NetworkContext_DeleteStoredTrustTokens_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::NetworkContext::kSetBlockTrustTokens),
     { &internal::NetworkContext_SetBlockTrustTokens_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::NetworkContext::kSetTrackingProtectionContentSetting),
     { &internal::NetworkContext_SetTrackingProtectionContentSetting_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::NetworkContext::kClearNetworkingHistoryBetween),
     { &internal::NetworkContext_ClearNetworkingHistoryBetween_Params_Data::Validate,
      &internal::NetworkContext_ClearNetworkingHistoryBetween_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::NetworkContext::kClearHttpCache),
     { &internal::NetworkContext_ClearHttpCache_Params_Data::Validate,
      &internal::NetworkContext_ClearHttpCache_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::NetworkContext::kComputeHttpCacheSize),
     { &internal::NetworkContext_ComputeHttpCacheSize_Params_Data::Validate,
      &internal::NetworkContext_ComputeHttpCacheSize_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::NetworkContext::kNotifyExternalCacheHit),
     { &internal::NetworkContext_NotifyExternalCacheHit_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::NetworkContext::kClearHostCache),
     { &internal::NetworkContext_ClearHostCache_Params_Data::Validate,
      &internal::NetworkContext_ClearHostCache_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::NetworkContext::kClearHttpAuthCache),
     { &internal::NetworkContext_ClearHttpAuthCache_Params_Data::Validate,
      &internal::NetworkContext_ClearHttpAuthCache_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::NetworkContext::kClearCorsPreflightCache),
     { &internal::NetworkContext_ClearCorsPreflightCache_Params_Data::Validate,
      &internal::NetworkContext_ClearCorsPreflightCache_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::NetworkContext::kClearReportingCacheReports),
     { &internal::NetworkContext_ClearReportingCacheReports_Params_Data::Validate,
      &internal::NetworkContext_ClearReportingCacheReports_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::NetworkContext::kClearReportingCacheClients),
     { &internal::NetworkContext_ClearReportingCacheClients_Params_Data::Validate,
      &internal::NetworkContext_ClearReportingCacheClients_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::NetworkContext::kClearNetworkErrorLogging),
     { &internal::NetworkContext_ClearNetworkErrorLogging_Params_Data::Validate,
      &internal::NetworkContext_ClearNetworkErrorLogging_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::NetworkContext::kClearDomainReliability),
     { &internal::NetworkContext_ClearDomainReliability_Params_Data::Validate,
      &internal::NetworkContext_ClearDomainReliability_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::NetworkContext::kClearSharedDictionaryCache),
     { &internal::NetworkContext_ClearSharedDictionaryCache_Params_Data::Validate,
      &internal::NetworkContext_ClearSharedDictionaryCache_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::NetworkContext::kClearSharedDictionaryCacheForIsolationKey),
     { &internal::NetworkContext_ClearSharedDictionaryCacheForIsolationKey_Params_Data::Validate,
      &internal::NetworkContext_ClearSharedDictionaryCacheForIsolationKey_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::NetworkContext::kSetDocumentReportingEndpoints),
     { &internal::NetworkContext_SetDocumentReportingEndpoints_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::NetworkContext::kSetEnterpriseReportingEndpoints),
     { &internal::NetworkContext_SetEnterpriseReportingEndpoints_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::NetworkContext::kSendReportsAndRemoveSource),
     { &internal::NetworkContext_SendReportsAndRemoveSource_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::NetworkContext::kQueueReport),
     { &internal::NetworkContext_QueueReport_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::NetworkContext::kQueueEnterpriseReport),
     { &internal::NetworkContext_QueueEnterpriseReport_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::NetworkContext::kQueueSignedExchangeReport),
     { &internal::NetworkContext_QueueSignedExchangeReport_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::NetworkContext::kCloseAllConnections),
     { &internal::NetworkContext_CloseAllConnections_Params_Data::Validate,
      &internal::NetworkContext_CloseAllConnections_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::NetworkContext::kCloseIdleConnections),
     { &internal::NetworkContext_CloseIdleConnections_Params_Data::Validate,
      &internal::NetworkContext_CloseIdleConnections_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::NetworkContext::kSetNetworkConditions),
     { &internal::NetworkContext_SetNetworkConditions_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::NetworkContext::kSetAcceptLanguage),
     { &internal::NetworkContext_SetAcceptLanguage_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::NetworkContext::kSetUserAgent),
     { &internal::NetworkContext_SetUserAgent_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::NetworkContext::kSetEnableReferrers),
     { &internal::NetworkContext_SetEnableReferrers_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::NetworkContext::kSetCTPolicy),
     { &internal::NetworkContext_SetCTPolicy_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::NetworkContext::kCreateUDPSocket),
     { &internal::NetworkContext_CreateUDPSocket_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::NetworkContext::kCreateRestrictedUDPSocket),
     { &internal::NetworkContext_CreateRestrictedUDPSocket_Params_Data::Validate,
      &internal::NetworkContext_CreateRestrictedUDPSocket_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::NetworkContext::kCreateTCPServerSocket),
     { &internal::NetworkContext_CreateTCPServerSocket_Params_Data::Validate,
      &internal::NetworkContext_CreateTCPServerSocket_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::NetworkContext::kCreateTCPConnectedSocket),
     { &internal::NetworkContext_CreateTCPConnectedSocket_Params_Data::Validate,
      &internal::NetworkContext_CreateTCPConnectedSocket_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::NetworkContext::kCreateTCPBoundSocket),
     { &internal::NetworkContext_CreateTCPBoundSocket_Params_Data::Validate,
      &internal::NetworkContext_CreateTCPBoundSocket_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::NetworkContext::kCreateProxyResolvingSocketFactory),
     { &internal::NetworkContext_CreateProxyResolvingSocketFactory_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::NetworkContext::kLookUpProxyForURL),
     { &internal::NetworkContext_LookUpProxyForURL_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::NetworkContext::kForceReloadProxyConfig),
     { &internal::NetworkContext_ForceReloadProxyConfig_Params_Data::Validate,
      &internal::NetworkContext_ForceReloadProxyConfig_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::NetworkContext::kClearBadProxiesCache),
     { &internal::NetworkContext_ClearBadProxiesCache_Params_Data::Validate,
      &internal::NetworkContext_ClearBadProxiesCache_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::NetworkContext::kCreateWebSocket),
     { &internal::NetworkContext_CreateWebSocket_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::NetworkContext::kCreateWebTransport),
     { &internal::NetworkContext_CreateWebTransport_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::NetworkContext::kCreateNetLogExporter),
     { &internal::NetworkContext_CreateNetLogExporter_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::NetworkContext::kPreconnectSockets),
     { &internal::NetworkContext_PreconnectSockets_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::NetworkContext::kCreateP2PSocketManager),
     { &internal::NetworkContext_CreateP2PSocketManager_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::NetworkContext::kCreateMdnsResponder),
     { &internal::NetworkContext_CreateMdnsResponder_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::NetworkContext::kResolveHost),
     { &internal::NetworkContext_ResolveHost_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::NetworkContext::kCreateHostResolver),
     { &internal::NetworkContext_CreateHostResolver_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::NetworkContext::kVerifyCert),
     { &internal::NetworkContext_VerifyCert_Params_Data::Validate,
      &internal::NetworkContext_VerifyCert_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::NetworkContext::kVerifyCertForSignedExchange),
     { &internal::NetworkContext_VerifyCertForSignedExchange_Params_Data::Validate,
      &internal::NetworkContext_VerifyCertForSignedExchange_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::NetworkContext::kVerify2QwacCertBinding),
     { &internal::NetworkContext_Verify2QwacCertBinding_Params_Data::Validate,
      &internal::NetworkContext_Verify2QwacCertBinding_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::NetworkContext::kAddHSTS),
     { &internal::NetworkContext_AddHSTS_Params_Data::Validate,
      &internal::NetworkContext_AddHSTS_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::NetworkContext::kIsHSTSActiveForHost),
     { &internal::NetworkContext_IsHSTSActiveForHost_Params_Data::Validate,
      &internal::NetworkContext_IsHSTSActiveForHost_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::NetworkContext::kGetHSTSState),
     { &internal::NetworkContext_GetHSTSState_Params_Data::Validate,
      &internal::NetworkContext_GetHSTSState_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::NetworkContext::kSetCorsOriginAccessListsForOrigin),
     { &internal::NetworkContext_SetCorsOriginAccessListsForOrigin_Params_Data::Validate,
      &internal::NetworkContext_SetCorsOriginAccessListsForOrigin_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::NetworkContext::kDeleteDynamicDataForHost),
     { &internal::NetworkContext_DeleteDynamicDataForHost_Params_Data::Validate,
      &internal::NetworkContext_DeleteDynamicDataForHost_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::NetworkContext::kSetSplitAuthCacheByNetworkAnonymizationKey),
     { &internal::NetworkContext_SetSplitAuthCacheByNetworkAnonymizationKey_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::NetworkContext::kSaveHttpAuthCacheProxyEntries),
     { &internal::NetworkContext_SaveHttpAuthCacheProxyEntries_Params_Data::Validate,
      &internal::NetworkContext_SaveHttpAuthCacheProxyEntries_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::NetworkContext::kLoadHttpAuthCacheProxyEntries),
     { &internal::NetworkContext_LoadHttpAuthCacheProxyEntries_Params_Data::Validate,
      &internal::NetworkContext_LoadHttpAuthCacheProxyEntries_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::NetworkContext::kAddAuthCacheEntry),
     { &internal::NetworkContext_AddAuthCacheEntry_Params_Data::Validate,
      &internal::NetworkContext_AddAuthCacheEntry_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::NetworkContext::kSetCorsNonWildcardRequestHeadersSupport),
     { &internal::NetworkContext_SetCorsNonWildcardRequestHeadersSupport_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::NetworkContext::kLookupServerBasicAuthCredentials),
     { &internal::NetworkContext_LookupServerBasicAuthCredentials_Params_Data::Validate,
      &internal::NetworkContext_LookupServerBasicAuthCredentials_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::NetworkContext::kEnableStaticKeyPinningForTesting),
     { &internal::NetworkContext_EnableStaticKeyPinningForTesting_Params_Data::Validate,
      &internal::NetworkContext_EnableStaticKeyPinningForTesting_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::NetworkContext::kVerifyCertificateForTesting),
     { &internal::NetworkContext_VerifyCertificateForTesting_Params_Data::Validate,
      &internal::NetworkContext_VerifyCertificateForTesting_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::NetworkContext::kGetTrustAnchorIDsForTesting),
     { &internal::NetworkContext_GetTrustAnchorIDsForTesting_Params_Data::Validate,
      &internal::NetworkContext_GetTrustAnchorIDsForTesting_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::NetworkContext::kAddDomainReliabilityContextForTesting),
     { &internal::NetworkContext_AddDomainReliabilityContextForTesting_Params_Data::Validate,
      &internal::NetworkContext_AddDomainReliabilityContextForTesting_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::NetworkContext::kForceDomainReliabilityUploadsForTesting),
     { &internal::NetworkContext_ForceDomainReliabilityUploadsForTesting_Params_Data::Validate,
      &internal::NetworkContext_ForceDomainReliabilityUploadsForTesting_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::NetworkContext::kSetSCTAuditingMode),
     { &internal::NetworkContext_SetSCTAuditingMode_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::NetworkContext::kGetSharedDictionaryUsageInfo),
     { &internal::NetworkContext_GetSharedDictionaryUsageInfo_Params_Data::Validate,
      &internal::NetworkContext_GetSharedDictionaryUsageInfo_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::NetworkContext::kGetSharedDictionaryInfo),
     { &internal::NetworkContext_GetSharedDictionaryInfo_Params_Data::Validate,
      &internal::NetworkContext_GetSharedDictionaryInfo_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::NetworkContext::kGetSharedDictionaryOriginsBetween),
     { &internal::NetworkContext_GetSharedDictionaryOriginsBetween_Params_Data::Validate,
      &internal::NetworkContext_GetSharedDictionaryOriginsBetween_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::NetworkContext::kSetSharedDictionaryCacheMaxSize),
     { &internal::NetworkContext_SetSharedDictionaryCacheMaxSize_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::NetworkContext::kPreloadSharedDictionaryInfoForDocument),
     { &internal::NetworkContext_PreloadSharedDictionaryInfoForDocument_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::NetworkContext::kHasPreloadedSharedDictionaryInfoForTesting),
     { &internal::NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_Params_Data::Validate,
      &internal::NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::NetworkContext::kResourceSchedulerClientVisibilityChanged),
     { &internal::NetworkContext_ResourceSchedulerClientVisibilityChanged_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::NetworkContext::kFlushCachedClientCertIfNeeded),
     { &internal::NetworkContext_FlushCachedClientCertIfNeeded_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::NetworkContext::kFlushMatchingCachedClientCert),
     { &internal::NetworkContext_FlushMatchingCachedClientCert_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::NetworkContext::kSetCookieDeprecationLabel),
     { &internal::NetworkContext_SetCookieDeprecationLabel_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::NetworkContext::kRevokeNetworkForNonces),
     { &internal::NetworkContext_RevokeNetworkForNonces_Params_Data::Validate,
      &internal::NetworkContext_RevokeNetworkForNonces_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::NetworkContext::kClearNonces),
     { &internal::NetworkContext_ClearNonces_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::NetworkContext::kExemptUrlFromNetworkRevocationForNonce),
     { &internal::NetworkContext_ExemptUrlFromNetworkRevocationForNonce_Params_Data::Validate,
      &internal::NetworkContext_ExemptUrlFromNetworkRevocationForNonce_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::NetworkContext::kPrefetch),
     { &internal::NetworkContext_Prefetch_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::NetworkContext::kGetBoundNetworkForTesting),
     { &internal::NetworkContext_GetBoundNetworkForTesting_Params_Data::Validate,
      &internal::NetworkContext_GetBoundNetworkForTesting_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::NetworkContext::kGetDeviceBoundSessionManager),
     { &internal::NetworkContext_GetDeviceBoundSessionManager_Params_Data::Validate,
      nullptr /* no response */}},
};

bool NetworkContextRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::network::mojom::NetworkContext::Name_,
    kNetworkContextValidationInfo);
}

bool NetworkContextResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGeneric(
    message,
    ::network::mojom::NetworkContext::Name_,
    kNetworkContextValidationInfo);

}


}  // network::mojom


namespace mojo {


// static
bool StructTraits<::network::mojom::CustomProxyConfig::DataView, ::network::mojom::CustomProxyConfigPtr>::Read(
    ::network::mojom::CustomProxyConfig::DataView input,
    ::network::mojom::CustomProxyConfigPtr* output) {
  bool success = true;
  ::network::mojom::CustomProxyConfigPtr result(::network::mojom::CustomProxyConfig::New());
  
      if (success && !input.ReadRules(&result->rules))
        success = false;
      if (success)
        result->should_override_existing_config = input.should_override_existing_config();
      if (success)
        result->allow_non_idempotent_methods = input.allow_non_idempotent_methods();
      if (success && !input.ReadConnectTunnelHeaders(&result->connect_tunnel_headers))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::CertVerifierServiceRemoteParams::DataView, ::network::mojom::CertVerifierServiceRemoteParamsPtr>::Read(
    ::network::mojom::CertVerifierServiceRemoteParams::DataView input,
    ::network::mojom::CertVerifierServiceRemoteParamsPtr* output) {
  bool success = true;
  ::network::mojom::CertVerifierServiceRemoteParamsPtr result(::network::mojom::CertVerifierServiceRemoteParams::New());
  
      if (success) {
        result->cert_verifier_service =
            input.TakeCertVerifierService<decltype(result->cert_verifier_service)>();
      }
      if (success) {
        result->cert_verifier_service_client_receiver =
            input.TakeCertVerifierServiceClientReceiver<decltype(result->cert_verifier_service_client_receiver)>();
      }
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::HttpAuthStaticNetworkContextParams::DataView, ::network::mojom::HttpAuthStaticNetworkContextParamsPtr>::Read(
    ::network::mojom::HttpAuthStaticNetworkContextParams::DataView input,
    ::network::mojom::HttpAuthStaticNetworkContextParamsPtr* output) {
  bool success = true;
  ::network::mojom::HttpAuthStaticNetworkContextParamsPtr result(::network::mojom::HttpAuthStaticNetworkContextParams::New());
  
      if (success && !input.ReadAllowDefaultCredentials(&result->allow_default_credentials))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::CTPolicy::DataView, ::network::mojom::CTPolicyPtr>::Read(
    ::network::mojom::CTPolicy::DataView input,
    ::network::mojom::CTPolicyPtr* output) {
  bool success = true;
  ::network::mojom::CTPolicyPtr result(::network::mojom::CTPolicy::New());
  
      if (success && !input.ReadExcludedHosts(&result->excluded_hosts))
        success = false;
      if (success && !input.ReadExcludedSpkis(&result->excluded_spkis))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::NetworkContextFilePaths::DataView, ::network::mojom::NetworkContextFilePathsPtr>::Read(
    ::network::mojom::NetworkContextFilePaths::DataView input,
    ::network::mojom::NetworkContextFilePathsPtr* output) {
  bool success = true;
  ::network::mojom::NetworkContextFilePathsPtr result(::network::mojom::NetworkContextFilePaths::New());
  
      if (success && !input.ReadSharedDictionaryDirectory(&result->shared_dictionary_directory))
        success = false;
      if (success && !input.ReadHttpCacheDirectory(&result->http_cache_directory))
        success = false;
      if (success && !input.ReadNoVarySearchDirectory(&result->no_vary_search_directory))
        success = false;
      if (success && !input.ReadDataDirectory(&result->data_directory))
        success = false;
      if (success && !input.ReadUnsandboxedDataPath(&result->unsandboxed_data_path))
        success = false;
      if (success && !input.ReadCookieDatabaseName(&result->cookie_database_name))
        success = false;
      if (success && !input.ReadDeviceBoundSessionsDatabaseName(&result->device_bound_sessions_database_name))
        success = false;
      if (success && !input.ReadTrustTokenDatabaseName(&result->trust_token_database_name))
        success = false;
      if (success && !input.ReadHttpServerPropertiesFileName(&result->http_server_properties_file_name))
        success = false;
      if (success && !input.ReadTransportSecurityPersisterFileName(&result->transport_security_persister_file_name))
        success = false;
      if (success && !input.ReadReportingAndNelStoreDatabaseName(&result->reporting_and_nel_store_database_name))
        success = false;
      if (success && !input.ReadSctAuditingPendingReportsFileName(&result->sct_auditing_pending_reports_file_name))
        success = false;
      if (success)
        result->trigger_migration = input.trigger_migration();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::NetworkContextParams::DataView, ::network::mojom::NetworkContextParamsPtr>::Read(
    ::network::mojom::NetworkContextParams::DataView input,
    ::network::mojom::NetworkContextParamsPtr* output) {
  bool success = true;
  ::network::mojom::NetworkContextParamsPtr result(::network::mojom::NetworkContextParams::New());
  
      if (success && !input.ReadUserAgent(&result->user_agent))
        success = false;
      if (success && !input.ReadAcceptLanguage(&result->accept_language))
        success = false;
      if (success)
        result->enable_brotli = input.enable_brotli();
      if (success)
        result->enable_zstd = input.enable_zstd();
      if (success)
        result->enable_referrers = input.enable_referrers();
      if (success)
        result->validate_referrer_policy_on_initial_request = input.validate_referrer_policy_on_initial_request();
      if (success) {
        result->proxy_resolver_factory =
            input.TakeProxyResolverFactory<decltype(result->proxy_resolver_factory)>();
      }
      if (success)
        result->enable_encrypted_cookies = input.enable_encrypted_cookies();
      if (success)
        result->restore_old_session_cookies = input.restore_old_session_cookies();
      if (success)
        result->persist_session_cookies = input.persist_session_cookies();
      if (success)
        result->http_cache_enabled = input.http_cache_enabled();
      if (success)
        result->http_cache_max_size = input.http_cache_max_size();
      if (success) {
        result->http_cache_file_operations_factory =
            input.TakeHttpCacheFileOperationsFactory<decltype(result->http_cache_file_operations_factory)>();
      }
      if (success)
        result->disable_idle_sockets_close_on_memory_pressure = input.disable_idle_sockets_close_on_memory_pressure();
      if (success && !input.ReadInitialSslConfig(&result->initial_ssl_config))
        success = false;
      if (success) {
        result->ssl_config_client_receiver =
            input.TakeSslConfigClientReceiver<decltype(result->ssl_config_client_receiver)>();
      }
      if (success && !input.ReadInitialProxyConfig(&result->initial_proxy_config))
        success = false;
      if (success) {
        result->proxy_config_client_receiver =
            input.TakeProxyConfigClientReceiver<decltype(result->proxy_config_client_receiver)>();
      }
      if (success && !input.ReadInitialCustomProxyConfig(&result->initial_custom_proxy_config))
        success = false;
      if (success) {
        result->custom_proxy_config_client_receiver =
            input.TakeCustomProxyConfigClientReceiver<decltype(result->custom_proxy_config_client_receiver)>();
      }
      if (success) {
        result->custom_proxy_connection_observer_remote =
            input.TakeCustomProxyConnectionObserverRemote<decltype(result->custom_proxy_connection_observer_remote)>();
      }
      if (success) {
        result->proxy_config_poller_client =
            input.TakeProxyConfigPollerClient<decltype(result->proxy_config_poller_client)>();
      }
      if (success) {
        result->proxy_error_client =
            input.TakeProxyErrorClient<decltype(result->proxy_error_client)>();
      }
      if (success) {
        result->ip_protection_core_host =
            input.TakeIpProtectionCoreHost<decltype(result->ip_protection_core_host)>();
      }
      if (success) {
        result->ip_protection_control =
            input.TakeIpProtectionControl<decltype(result->ip_protection_control)>();
      }
      if (success)
        result->enable_ip_protection = input.enable_ip_protection();
      if (success)
        result->ip_protection_incognito = input.ip_protection_incognito();
      if (success && !input.ReadIpProtectionDataDirectory(&result->ip_protection_data_directory))
        success = false;
      if (success)
        result->pac_quick_check_enabled = input.pac_quick_check_enabled();
      if (success)
        result->enable_certificate_reporting = input.enable_certificate_reporting();
      if (success)
        result->enforce_chrome_ct_policy = input.enforce_chrome_ct_policy();
      if (success && !input.ReadSctAuditingMode(&result->sct_auditing_mode))
        success = false;
      if (success && !input.ReadCtPolicy(&result->ct_policy))
        success = false;
      if (success && !input.ReadCertVerifierParams(&result->cert_verifier_params))
        success = false;
      if (success && !input.ReadCookieManagerParams(&result->cookie_manager_params))
        success = false;
      if (success) {
        result->cookie_manager =
            input.TakeCookieManager<decltype(result->cookie_manager)>();
      }
      if (success)
        result->enable_domain_reliability = input.enable_domain_reliability();
      if (success && !input.ReadDomainReliabilityUploadReporter(&result->domain_reliability_upload_reporter))
        success = false;
      if (success)
        result->discard_domain_reliablity_uploads = input.discard_domain_reliablity_uploads();
      if (success && !input.ReadReportingDeliveryInterval(&result->reporting_delivery_interval))
        success = false;
      if (success)
        result->skip_reporting_send_permission_check = input.skip_reporting_send_permission_check();
      if (success && !input.ReadCorsOriginAccessList(&result->cors_origin_access_list))
        success = false;
      if (success && !input.ReadCorsExemptHeaderList(&result->cors_exempt_header_list))
        success = false;
      if (success)
        result->allow_any_cors_exempt_header_for_browser = input.allow_any_cors_exempt_header_for_browser();
      if (success && !input.ReadHstsPolicyBypassList(&result->hsts_policy_bypass_list))
        success = false;
      if (success && !input.ReadHttpAuthStaticNetworkContextParams(&result->http_auth_static_network_context_params))
        success = false;
      if (success)
        result->reset_http_cache_backend = input.reset_http_cache_backend();
      if (success)
        result->split_auth_cache_by_network_anonymization_key = input.split_auth_cache_by_network_anonymization_key();
      if (success)
        result->require_network_anonymization_key = input.require_network_anonymization_key();
      if (success && !input.ReadFilePaths(&result->file_paths))
        success = false;
      if (success)
        result->block_trust_tokens = input.block_trust_tokens();
      if (success)
        result->shared_dictionary_enabled = input.shared_dictionary_enabled();
      if (success)
        result->shared_dictionary_cache_max_size = input.shared_dictionary_cache_max_size();
      if (success && !input.ReadFirstPartySetsAccessDelegateParams(&result->first_party_sets_access_delegate_params))
        success = false;
      if (success) {
        result->first_party_sets_access_delegate_receiver =
            input.TakeFirstPartySetsAccessDelegateReceiver<decltype(result->first_party_sets_access_delegate_receiver)>();
      }
      if (success)
        result->acam_preflight_spec_conformant = input.acam_preflight_spec_conformant();
      if (success && !input.ReadCookieDeprecationLabel(&result->cookie_deprecation_label))
        success = false;
      if (success) {
        result->cookie_encryption_provider =
            input.TakeCookieEncryptionProvider<decltype(result->cookie_encryption_provider)>();
      }
      if (success)
        result->device_bound_sessions_enabled = input.device_bound_sessions_enabled();
      if (success)
        result->bound_network = input.bound_network();
      if (success && !input.ReadEnterpriseReportingEndpoints(&result->enterprise_reporting_endpoints))
        success = false;
      if (success) {
        result->quic_idle_connection_timeout_seconds = input.quic_idle_connection_timeout_seconds();
      }
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::NetworkConditions::DataView, ::network::mojom::NetworkConditionsPtr>::Read(
    ::network::mojom::NetworkConditions::DataView input,
    ::network::mojom::NetworkConditionsPtr* output) {
  bool success = true;
  ::network::mojom::NetworkConditionsPtr result(::network::mojom::NetworkConditions::New());
  
      if (success)
        result->offline = input.offline();
      if (success && !input.ReadLatency(&result->latency))
        success = false;
      if (success)
        result->download_throughput = input.download_throughput();
      if (success)
        result->upload_throughput = input.upload_throughput();
      if (success)
        result->packet_loss = input.packet_loss();
      if (success)
        result->packet_queue_length = input.packet_queue_length();
      if (success)
        result->packet_reordering = input.packet_reordering();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::SharedDictionaryInfo::DataView, ::network::mojom::SharedDictionaryInfoPtr>::Read(
    ::network::mojom::SharedDictionaryInfo::DataView input,
    ::network::mojom::SharedDictionaryInfoPtr* output) {
  bool success = true;
  ::network::mojom::SharedDictionaryInfoPtr result(::network::mojom::SharedDictionaryInfo::New());
  
      if (success && !input.ReadMatch(&result->match))
        success = false;
      if (success && !input.ReadMatchDest(&result->match_dest))
        success = false;
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadDictionaryUrl(&result->dictionary_url))
        success = false;
      if (success && !input.ReadLastFetchTime(&result->last_fetch_time))
        success = false;
      if (success && !input.ReadResponseTime(&result->response_time))
        success = false;
      if (success && !input.ReadExpiration(&result->expiration))
        success = false;
      if (success && !input.ReadLastUsedTime(&result->last_used_time))
        success = false;
      if (success)
        result->size = input.size();
      if (success && !input.ReadHash(&result->hash))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::SignedExchangeReport::DataView, ::network::mojom::SignedExchangeReportPtr>::Read(
    ::network::mojom::SignedExchangeReport::DataView input,
    ::network::mojom::SignedExchangeReportPtr* output) {
  bool success = true;
  ::network::mojom::SignedExchangeReportPtr result(::network::mojom::SignedExchangeReport::New());
  
      if (success)
        result->success = input.success();
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success && !input.ReadOuterUrl(&result->outer_url))
        success = false;
      if (success && !input.ReadInnerUrl(&result->inner_url))
        success = false;
      if (success && !input.ReadCertUrl(&result->cert_url))
        success = false;
      if (success && !input.ReadReferrer(&result->referrer))
        success = false;
      if (success && !input.ReadServerIpAddress(&result->server_ip_address))
        success = false;
      if (success && !input.ReadProtocol(&result->protocol))
        success = false;
      if (success && !input.ReadMethod(&result->method))
        success = false;
      if (success)
        result->status_code = input.status_code();
      if (success && !input.ReadElapsedTime(&result->elapsed_time))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::URLLoaderFactoryOverride::DataView, ::network::mojom::URLLoaderFactoryOverridePtr>::Read(
    ::network::mojom::URLLoaderFactoryOverride::DataView input,
    ::network::mojom::URLLoaderFactoryOverridePtr* output) {
  bool success = true;
  ::network::mojom::URLLoaderFactoryOverridePtr result(::network::mojom::URLLoaderFactoryOverride::New());
  
      if (success) {
        result->overriding_factory =
            input.TakeOverridingFactory<decltype(result->overriding_factory)>();
      }
      if (success) {
        result->overridden_factory_receiver =
            input.TakeOverriddenFactoryReceiver<decltype(result->overridden_factory_receiver)>();
      }
      if (success)
        result->skip_cors_enabled_scheme_check = input.skip_cors_enabled_scheme_check();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::URLLoaderFactoryParams::DataView, ::network::mojom::URLLoaderFactoryParamsPtr>::Read(
    ::network::mojom::URLLoaderFactoryParams::DataView input,
    ::network::mojom::URLLoaderFactoryParamsPtr* output) {
  bool success = true;
  ::network::mojom::URLLoaderFactoryParamsPtr result(::network::mojom::URLLoaderFactoryParams::New());
  
      if (success)
        result->process_id = input.process_id();
      if (success && !input.ReadRequestInitiatorOriginLock(&result->request_initiator_origin_lock))
        success = false;
      if (success)
        result->is_orb_enabled = input.is_orb_enabled();
      if (success)
        result->ignore_isolated_world_origin = input.ignore_isolated_world_origin();
      if (success)
        result->unsafe_non_webby_initiator = input.unsafe_non_webby_initiator();
      if (success)
        result->disable_web_security = input.disable_web_security();
      if (success) {
        result->header_client =
            input.TakeHeaderClient<decltype(result->header_client)>();
      }
      if (success && !input.ReadIsolationInfo(&result->isolation_info))
        success = false;
      if (success)
        result->disable_secure_dns = input.disable_secure_dns();
      if (success)
        result->is_trusted = input.is_trusted();
      if (success)
        result->automatically_assign_isolation_info = input.automatically_assign_isolation_info();
      if (success && !input.ReadTopFrameId(&result->top_frame_id))
        success = false;
      if (success && !input.ReadFactoryOverride(&result->factory_override))
        success = false;
      if (success && !input.ReadClientSecurityState(&result->client_security_state))
        success = false;
      if (success) {
        result->coep_reporter =
            input.TakeCoepReporter<decltype(result->coep_reporter)>();
      }
      if (success) {
        result->dip_reporter =
            input.TakeDipReporter<decltype(result->dip_reporter)>();
      }
      if (success) {
        result->cookie_observer =
            input.TakeCookieObserver<decltype(result->cookie_observer)>();
      }
      if (success) {
        result->trust_token_observer =
            input.TakeTrustTokenObserver<decltype(result->trust_token_observer)>();
      }
      if (success) {
        result->shared_dictionary_observer =
            input.TakeSharedDictionaryObserver<decltype(result->shared_dictionary_observer)>();
      }
      if (success) {
        result->url_loader_network_observer =
            input.TakeUrlLoaderNetworkObserver<decltype(result->url_loader_network_observer)>();
      }
      if (success) {
        result->devtools_observer =
            input.TakeDevtoolsObserver<decltype(result->devtools_observer)>();
      }
      if (success) {
        result->device_bound_session_observer =
            input.TakeDeviceBoundSessionObserver<decltype(result->device_bound_session_observer)>();
      }
      if (success && !input.ReadTrustTokenIssuancePolicy(&result->trust_token_issuance_policy))
        success = false;
      if (success && !input.ReadTrustTokenRedemptionPolicy(&result->trust_token_redemption_policy))
        success = false;
      if (success && !input.ReadDebugTag(&result->debug_tag))
        success = false;
      if (success && !input.ReadCookieSettingOverrides(&result->cookie_setting_overrides))
        success = false;
      if (success && !input.ReadDevtoolsCookieSettingOverrides(&result->devtools_cookie_setting_overrides))
        success = false;
      if (success)
        result->require_cross_site_request_for_cookies = input.require_cross_site_request_for_cookies();
      if (success)
        result->ignore_factory_reset = input.ignore_factory_reset();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace network::mojom {


void CustomProxyConnectionObserverInterceptorForTesting::OnFallback(const ::net::ProxyChain& bad_chain, int32_t net_error) {
  GetForwardingInterface()->OnFallback(
    std::move(bad_chain)
    , 
    std::move(net_error)
    );
}
void CustomProxyConnectionObserverInterceptorForTesting::OnTunnelHeadersReceived(const ::net::ProxyChain& proxy_chain, uint64_t chain_index, const ::scoped_refptr<::net::HttpResponseHeaders>& response_headers) {
  GetForwardingInterface()->OnTunnelHeadersReceived(
    std::move(proxy_chain)
    , 
    std::move(chain_index)
    , 
    std::move(response_headers)
    );
}
CustomProxyConnectionObserverAsyncWaiter::CustomProxyConnectionObserverAsyncWaiter(
    CustomProxyConnectionObserver* proxy) : proxy_(proxy) {}

CustomProxyConnectionObserverAsyncWaiter::~CustomProxyConnectionObserverAsyncWaiter() = default;





void CustomProxyConfigClientInterceptorForTesting::OnCustomProxyConfigUpdated(CustomProxyConfigPtr proxy_config, OnCustomProxyConfigUpdatedCallback callback) {
  GetForwardingInterface()->OnCustomProxyConfigUpdated(
    std::move(proxy_config)
    , std::move(callback));
}
CustomProxyConfigClientAsyncWaiter::CustomProxyConfigClientAsyncWaiter(
    CustomProxyConfigClient* proxy) : proxy_(proxy) {}

CustomProxyConfigClientAsyncWaiter::~CustomProxyConfigClientAsyncWaiter() = default;


void CustomProxyConfigClientAsyncWaiter::OnCustomProxyConfigUpdated(
    CustomProxyConfigPtr proxy_config) {
  base::RunLoop loop;
  proxy_->OnCustomProxyConfigUpdated(
      std::move(proxy_config),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}






void TrustedHeaderClientInterceptorForTesting::OnBeforeSendHeaders(const ::net::HttpRequestHeaders& headers, OnBeforeSendHeadersCallback callback) {
  GetForwardingInterface()->OnBeforeSendHeaders(
    std::move(headers)
    , std::move(callback));
}
void TrustedHeaderClientInterceptorForTesting::OnHeadersReceived(const std::string& headers, const ::net::IPEndPoint& remote_endpoint, OnHeadersReceivedCallback callback) {
  GetForwardingInterface()->OnHeadersReceived(
    std::move(headers)
    , 
    std::move(remote_endpoint)
    , std::move(callback));
}
TrustedHeaderClientAsyncWaiter::TrustedHeaderClientAsyncWaiter(
    TrustedHeaderClient* proxy) : proxy_(proxy) {}

TrustedHeaderClientAsyncWaiter::~TrustedHeaderClientAsyncWaiter() = default;


void TrustedHeaderClientAsyncWaiter::OnBeforeSendHeaders(
    const ::net::HttpRequestHeaders& headers, int32_t* out_result, std::optional<::net::HttpRequestHeaders>* out_headers) {
  base::RunLoop loop;
  proxy_->OnBeforeSendHeaders(
      std::move(headers),
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_result
,
             std::optional<::net::HttpRequestHeaders>* out_headers
,
             int32_t result,
             const std::optional<::net::HttpRequestHeaders>& headers) {*out_result = std::move(result);*out_headers = std::move(headers);
            loop->Quit();
          },
          &loop,
          out_result,
          out_headers));
  loop.Run();
}



void TrustedHeaderClientAsyncWaiter::OnHeadersReceived(
    const std::string& headers, const ::net::IPEndPoint& remote_endpoint, int32_t* out_result, std::optional<std::string>* out_headers, std::optional<::GURL>* out_preserve_fragment_on_redirect_url) {
  base::RunLoop loop;
  proxy_->OnHeadersReceived(
      std::move(headers),
      std::move(remote_endpoint),
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_result
,
             std::optional<std::string>* out_headers
,
             std::optional<::GURL>* out_preserve_fragment_on_redirect_url
,
             int32_t result,
             const std::optional<std::string>& headers,
             const std::optional<::GURL>& preserve_fragment_on_redirect_url) {*out_result = std::move(result);*out_headers = std::move(headers);*out_preserve_fragment_on_redirect_url = std::move(preserve_fragment_on_redirect_url);
            loop->Quit();
          },
          &loop,
          out_result,
          out_headers,
          out_preserve_fragment_on_redirect_url));
  loop.Run();
}






void TrustedURLLoaderHeaderClientInterceptorForTesting::OnLoaderCreated(int32_t request_id, ::mojo::PendingReceiver<TrustedHeaderClient> header_client) {
  GetForwardingInterface()->OnLoaderCreated(
    std::move(request_id)
    , 
    std::move(header_client)
    );
}
void TrustedURLLoaderHeaderClientInterceptorForTesting::OnLoaderForCorsPreflightCreated(const ::network::ResourceRequest& request, ::mojo::PendingReceiver<TrustedHeaderClient> header_client) {
  GetForwardingInterface()->OnLoaderForCorsPreflightCreated(
    request, 
    std::move(header_client)
    );
}
TrustedURLLoaderHeaderClientAsyncWaiter::TrustedURLLoaderHeaderClientAsyncWaiter(
    TrustedURLLoaderHeaderClient* proxy) : proxy_(proxy) {}

TrustedURLLoaderHeaderClientAsyncWaiter::~TrustedURLLoaderHeaderClientAsyncWaiter() = default;





PreloadedSharedDictionaryInfoHandleAsyncWaiter::PreloadedSharedDictionaryInfoHandleAsyncWaiter(
    PreloadedSharedDictionaryInfoHandle* proxy) : proxy_(proxy) {}

PreloadedSharedDictionaryInfoHandleAsyncWaiter::~PreloadedSharedDictionaryInfoHandleAsyncWaiter() = default;





void NetworkContextInterceptorForTesting::SetClient(::mojo::PendingRemote<::network::mojom::NetworkContextClient> client) {
  GetForwardingInterface()->SetClient(
    std::move(client)
    );
}
void NetworkContextInterceptorForTesting::CreateURLLoaderFactory(::mojo::PendingReceiver<::network::mojom::URLLoaderFactory> url_loader_factory, URLLoaderFactoryParamsPtr params) {
  GetForwardingInterface()->CreateURLLoaderFactory(
    std::move(url_loader_factory)
    , 
    std::move(params)
    );
}
void NetworkContextInterceptorForTesting::ResetURLLoaderFactories() {
  GetForwardingInterface()->ResetURLLoaderFactories();
}
void NetworkContextInterceptorForTesting::GetViaObliviousHttp(::network::mojom::ObliviousHttpRequestPtr request, ::mojo::PendingRemote<::network::mojom::ObliviousHttpClient> client) {
  GetForwardingInterface()->GetViaObliviousHttp(
    std::move(request)
    , 
    std::move(client)
    );
}
void Net