// services/network/public/mojom/network_param.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_PARAM_MOJOM_BLINK_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_PARAM_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/network_param.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/network_param.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/network_param.mojom-blink-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/time.mojom-blink.h"
#include "url/mojom/scheme_host_port.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "mojo/public/cpp/bindings/lib/native_enum_serialization.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"
#include "services/network/public/cpp/network_param_mojom_traits.h"
#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace network::mojom::blink {









class BLINK_PLATFORM_EXPORT HttpVersion {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<HttpVersion, T>::value>;
  using DataView = HttpVersionDataView;
  using Data_ = internal::HttpVersion_Data;

  template <typename... Args>
  static HttpVersionPtr New(Args&&... args) {
    return HttpVersionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static HttpVersionPtr From(const U& u) {
    return mojo::TypeConverter<HttpVersionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, HttpVersion>::Convert(*this);
  }


  HttpVersion();

  HttpVersion(
      uint16_t major_value,
      uint16_t minor_value);


  ~HttpVersion();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = HttpVersionPtr>
  HttpVersionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, HttpVersion::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, HttpVersion::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, HttpVersion::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HttpVersion::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HttpVersion::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        HttpVersion::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::HttpVersion_UnserializedMessageContext<
            UserType, HttpVersion::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<HttpVersion::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return HttpVersion::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::HttpVersion_UnserializedMessageContext<
            UserType, HttpVersion::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<HttpVersion::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint16_t major_value;
  
  uint16_t minor_value;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, HttpVersion::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, HttpVersion::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, HttpVersion::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, HttpVersion::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT HostPortPair {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<HostPortPair, T>::value>;
  using DataView = HostPortPairDataView;
  using Data_ = internal::HostPortPair_Data;

  template <typename... Args>
  static HostPortPairPtr New(Args&&... args) {
    return HostPortPairPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static HostPortPairPtr From(const U& u) {
    return mojo::TypeConverter<HostPortPairPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, HostPortPair>::Convert(*this);
  }


  HostPortPair();

  HostPortPair(
      const ::blink::String& host,
      uint16_t port);


  ~HostPortPair();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = HostPortPairPtr>
  HostPortPairPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, HostPortPair::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, HostPortPair::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, HostPortPair::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HostPortPair::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HostPortPair::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        HostPortPair::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::HostPortPair_UnserializedMessageContext<
            UserType, HostPortPair::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<HostPortPair::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return HostPortPair::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::HostPortPair_UnserializedMessageContext<
            UserType, HostPortPair::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<HostPortPair::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::String host;
  
  uint16_t port;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, HostPortPair::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, HostPortPair::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, HostPortPair::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, HostPortPair::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class BLINK_PLATFORM_EXPORT ResolveErrorInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ResolveErrorInfo, T>::value>;
  using DataView = ResolveErrorInfoDataView;
  using Data_ = internal::ResolveErrorInfo_Data;

  template <typename... Args>
  static ResolveErrorInfoPtr New(Args&&... args) {
    return ResolveErrorInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ResolveErrorInfoPtr From(const U& u) {
    return mojo::TypeConverter<ResolveErrorInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ResolveErrorInfo>::Convert(*this);
  }


  ResolveErrorInfo();

  ResolveErrorInfo(
      int32_t error,
      bool is_secure_network_error);


  ~ResolveErrorInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ResolveErrorInfoPtr>
  ResolveErrorInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ResolveErrorInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ResolveErrorInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ResolveErrorInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ResolveErrorInfo::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ResolveErrorInfo::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ResolveErrorInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ResolveErrorInfo_UnserializedMessageContext<
            UserType, ResolveErrorInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ResolveErrorInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ResolveErrorInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ResolveErrorInfo_UnserializedMessageContext<
            UserType, ResolveErrorInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ResolveErrorInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t error;
  
  bool is_secure_network_error;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ResolveErrorInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ResolveErrorInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ResolveErrorInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ResolveErrorInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}











class BLINK_PLATFORM_EXPORT AuthChallengeInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AuthChallengeInfo, T>::value>;
  using DataView = AuthChallengeInfoDataView;
  using Data_ = internal::AuthChallengeInfo_Data;

  template <typename... Args>
  static AuthChallengeInfoPtr New(Args&&... args) {
    return AuthChallengeInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AuthChallengeInfoPtr From(const U& u) {
    return mojo::TypeConverter<AuthChallengeInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AuthChallengeInfo>::Convert(*this);
  }


  AuthChallengeInfo();

  AuthChallengeInfo(
      bool is_proxy,
      const ::url::SchemeHostPort& challenger,
      const ::blink::String& scheme,
      const ::blink::String& realm,
      const ::blink::String& challenge,
      const ::blink::String& path);


  ~AuthChallengeInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AuthChallengeInfoPtr>
  AuthChallengeInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AuthChallengeInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AuthChallengeInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AuthChallengeInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AuthChallengeInfo::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AuthChallengeInfo::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AuthChallengeInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AuthChallengeInfo_UnserializedMessageContext<
            UserType, AuthChallengeInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AuthChallengeInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AuthChallengeInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AuthChallengeInfo_UnserializedMessageContext<
            UserType, AuthChallengeInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AuthChallengeInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool is_proxy;
  
  ::url::SchemeHostPort challenger;
  
  ::blink::String scheme;
  
  ::blink::String realm;
  
  ::blink::String challenge;
  
  ::blink::String path;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AuthChallengeInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AuthChallengeInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AuthChallengeInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AuthChallengeInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}










class BLINK_PLATFORM_EXPORT ProxyServer {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ProxyServer, T>::value>;
  using DataView = ProxyServerDataView;
  using Data_ = internal::ProxyServer_Data;

  template <typename... Args>
  static ProxyServerPtr New(Args&&... args) {
    return ProxyServerPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ProxyServerPtr From(const U& u) {
    return mojo::TypeConverter<ProxyServerPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ProxyServer>::Convert(*this);
  }


  ProxyServer();

  ProxyServer(
      ProxyScheme scheme,
      const std::optional<::net::HostPortPair>& host_and_port);


  ~ProxyServer();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ProxyServerPtr>
  ProxyServerPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ProxyServer::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ProxyServer::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ProxyServer::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ProxyServer::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ProxyServer::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ProxyServer::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ProxyServer_UnserializedMessageContext<
            UserType, ProxyServer::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ProxyServer::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ProxyServer::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ProxyServer_UnserializedMessageContext<
            UserType, ProxyServer::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ProxyServer::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ProxyScheme scheme;
  
  std::optional<::net::HostPortPair> host_and_port;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ProxyServer::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ProxyServer::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ProxyServer::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ProxyServer::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT ProxyChain {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ProxyChain, T>::value>;
  using DataView = ProxyChainDataView;
  using Data_ = internal::ProxyChain_Data;

  template <typename... Args>
  static ProxyChainPtr New(Args&&... args) {
    return ProxyChainPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ProxyChainPtr From(const U& u) {
    return mojo::TypeConverter<ProxyChainPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ProxyChain>::Convert(*this);
  }


  ProxyChain();

  ProxyChain(
      std::optional<::blink::Vector<ProxyServerPtr>> proxy_servers,
      int32_t ip_protection_chain_id);

ProxyChain(const ProxyChain&) = delete;
ProxyChain& operator=(const ProxyChain&) = delete;

  ~ProxyChain();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ProxyChainPtr>
  ProxyChainPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ProxyChain::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ProxyChain::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ProxyChain::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ProxyChain::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ProxyChain::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ProxyChain::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ProxyChain_UnserializedMessageContext<
            UserType, ProxyChain::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ProxyChain::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ProxyChain::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ProxyChain_UnserializedMessageContext<
            UserType, ProxyChain::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ProxyChain::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<::blink::Vector<ProxyServerPtr>> proxy_servers;
  
  int32_t ip_protection_chain_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ProxyChain::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ProxyChain::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ProxyChain::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ProxyChain::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class BLINK_PLATFORM_EXPORT SSLCertRequestInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SSLCertRequestInfo, T>::value>;
  using DataView = SSLCertRequestInfoDataView;
  using Data_ = internal::SSLCertRequestInfo_Data;

  template <typename... Args>
  static SSLCertRequestInfoPtr New(Args&&... args) {
    return SSLCertRequestInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SSLCertRequestInfoPtr From(const U& u) {
    return mojo::TypeConverter<SSLCertRequestInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SSLCertRequestInfo>::Convert(*this);
  }


  SSLCertRequestInfo();

  SSLCertRequestInfo(
      const ::net::HostPortPair& host_and_port,
      bool is_proxy,
      ::blink::Vector<::blink::String> cert_authorities,
      ::blink::Vector<uint16_t> signature_algorithms);


  ~SSLCertRequestInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SSLCertRequestInfoPtr>
  SSLCertRequestInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SSLCertRequestInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SSLCertRequestInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SSLCertRequestInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SSLCertRequestInfo::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SSLCertRequestInfo::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SSLCertRequestInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SSLCertRequestInfo_UnserializedMessageContext<
            UserType, SSLCertRequestInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SSLCertRequestInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SSLCertRequestInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SSLCertRequestInfo_UnserializedMessageContext<
            UserType, SSLCertRequestInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SSLCertRequestInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::net::HostPortPair host_and_port;
  
  bool is_proxy;
  
  ::blink::Vector<::blink::String> cert_authorities;
  
  ::blink::Vector<uint16_t> signature_algorithms;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SSLCertRequestInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SSLCertRequestInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SSLCertRequestInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SSLCertRequestInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class BLINK_PLATFORM_EXPORT NetLogSource {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<NetLogSource, T>::value>;
  using DataView = NetLogSourceDataView;
  using Data_ = internal::NetLogSource_Data;

  template <typename... Args>
  static NetLogSourcePtr New(Args&&... args) {
    return NetLogSourcePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static NetLogSourcePtr From(const U& u) {
    return mojo::TypeConverter<NetLogSourcePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, NetLogSource>::Convert(*this);
  }


  NetLogSource();

  NetLogSource(
      uint32_t source_type,
      uint32_t source_id,
      ::base::TimeTicks start_time);


  ~NetLogSource();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = NetLogSourcePtr>
  NetLogSourcePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, NetLogSource::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, NetLogSource::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, NetLogSource::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NetLogSource::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NetLogSource::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        NetLogSource::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::NetLogSource_UnserializedMessageContext<
            UserType, NetLogSource::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<NetLogSource::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return NetLogSource::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::NetLogSource_UnserializedMessageContext<
            UserType, NetLogSource::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<NetLogSource::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t source_type;
  
  uint32_t source_id;
  
  ::base::TimeTicks start_time;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, NetLogSource::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, NetLogSource::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, NetLogSource::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, NetLogSource::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
AuthChallengeInfoPtr AuthChallengeInfo::Clone() const {
  return New(
      mojo::Clone(is_proxy),
      mojo::Clone(challenger),
      mojo::Clone(scheme),
      mojo::Clone(realm),
      mojo::Clone(challenge),
      mojo::Clone(path)
  );
}

template <typename T, AuthChallengeInfo::EnableIfSame<T>*>
bool AuthChallengeInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->is_proxy, other_struct.is_proxy))
    return false;
  if (!mojo::Equals(this->challenger, other_struct.challenger))
    return false;
  if (!mojo::Equals(this->scheme, other_struct.scheme))
    return false;
  if (!mojo::Equals(this->realm, other_struct.realm))
    return false;
  if (!mojo::Equals(this->challenge, other_struct.challenge))
    return false;
  if (!mojo::Equals(this->path, other_struct.path))
    return false;
  return true;
}

template <typename T, AuthChallengeInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.is_proxy < rhs.is_proxy)
    return true;
  if (rhs.is_proxy < lhs.is_proxy)
    return false;
  if (lhs.challenger < rhs.challenger)
    return true;
  if (rhs.challenger < lhs.challenger)
    return false;
  if (lhs.scheme < rhs.scheme)
    return true;
  if (rhs.scheme < lhs.scheme)
    return false;
  if (lhs.realm < rhs.realm)
    return true;
  if (rhs.realm < lhs.realm)
    return false;
  if (lhs.challenge < rhs.challenge)
    return true;
  if (rhs.challenge < lhs.challenge)
    return false;
  if (lhs.path < rhs.path)
    return true;
  if (rhs.path < lhs.path)
    return false;
  return false;
}
template <typename StructPtrType>
HttpVersionPtr HttpVersion::Clone() const {
  return New(
      mojo::Clone(major_value),
      mojo::Clone(minor_value)
  );
}

template <typename T, HttpVersion::EnableIfSame<T>*>
bool HttpVersion::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->major_value, other_struct.major_value))
    return false;
  if (!mojo::Equals(this->minor_value, other_struct.minor_value))
    return false;
  return true;
}

template <typename T, HttpVersion::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.major_value < rhs.major_value)
    return true;
  if (rhs.major_value < lhs.major_value)
    return false;
  if (lhs.minor_value < rhs.minor_value)
    return true;
  if (rhs.minor_value < lhs.minor_value)
    return false;
  return false;
}
template <typename StructPtrType>
HostPortPairPtr HostPortPair::Clone() const {
  return New(
      mojo::Clone(host),
      mojo::Clone(port)
  );
}

template <typename T, HostPortPair::EnableIfSame<T>*>
bool HostPortPair::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->host, other_struct.host))
    return false;
  if (!mojo::Equals(this->port, other_struct.port))
    return false;
  return true;
}

template <typename T, HostPortPair::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.host < rhs.host)
    return true;
  if (rhs.host < lhs.host)
    return false;
  if (lhs.port < rhs.port)
    return true;
  if (rhs.port < lhs.port)
    return false;
  return false;
}
template <typename StructPtrType>
ProxyServerPtr ProxyServer::Clone() const {
  return New(
      mojo::Clone(scheme),
      mojo::Clone(host_and_port)
  );
}

template <typename T, ProxyServer::EnableIfSame<T>*>
bool ProxyServer::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->scheme, other_struct.scheme))
    return false;
  if (!mojo::Equals(this->host_and_port, other_struct.host_and_port))
    return false;
  return true;
}

template <typename T, ProxyServer::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.scheme < rhs.scheme)
    return true;
  if (rhs.scheme < lhs.scheme)
    return false;
  if (lhs.host_and_port < rhs.host_and_port)
    return true;
  if (rhs.host_and_port < lhs.host_and_port)
    return false;
  return false;
}
template <typename StructPtrType>
ProxyChainPtr ProxyChain::Clone() const {
  return New(
      mojo::Clone(proxy_servers),
      mojo::Clone(ip_protection_chain_id)
  );
}

template <typename T, ProxyChain::EnableIfSame<T>*>
bool ProxyChain::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->proxy_servers, other_struct.proxy_servers))
    return false;
  if (!mojo::Equals(this->ip_protection_chain_id, other_struct.ip_protection_chain_id))
    return false;
  return true;
}

template <typename T, ProxyChain::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.proxy_servers < rhs.proxy_servers)
    return true;
  if (rhs.proxy_servers < lhs.proxy_servers)
    return false;
  if (lhs.ip_protection_chain_id < rhs.ip_protection_chain_id)
    return true;
  if (rhs.ip_protection_chain_id < lhs.ip_protection_chain_id)
    return false;
  return false;
}
template <typename StructPtrType>
ResolveErrorInfoPtr ResolveErrorInfo::Clone() const {
  return New(
      mojo::Clone(error),
      mojo::Clone(is_secure_network_error)
  );
}

template <typename T, ResolveErrorInfo::EnableIfSame<T>*>
bool ResolveErrorInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->error, other_struct.error))
    return false;
  if (!mojo::Equals(this->is_secure_network_error, other_struct.is_secure_network_error))
    return false;
  return true;
}

template <typename T, ResolveErrorInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.error < rhs.error)
    return true;
  if (rhs.error < lhs.error)
    return false;
  if (lhs.is_secure_network_error < rhs.is_secure_network_error)
    return true;
  if (rhs.is_secure_network_error < lhs.is_secure_network_error)
    return false;
  return false;
}
template <typename StructPtrType>
SSLCertRequestInfoPtr SSLCertRequestInfo::Clone() const {
  return New(
      mojo::Clone(host_and_port),
      mojo::Clone(is_proxy),
      mojo::Clone(cert_authorities),
      mojo::Clone(signature_algorithms)
  );
}

template <typename T, SSLCertRequestInfo::EnableIfSame<T>*>
bool SSLCertRequestInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->host_and_port, other_struct.host_and_port))
    return false;
  if (!mojo::Equals(this->is_proxy, other_struct.is_proxy))
    return false;
  if (!mojo::Equals(this->cert_authorities, other_struct.cert_authorities))
    return false;
  if (!mojo::Equals(this->signature_algorithms, other_struct.signature_algorithms))
    return false;
  return true;
}

template <typename T, SSLCertRequestInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.host_and_port < rhs.host_and_port)
    return true;
  if (rhs.host_and_port < lhs.host_and_port)
    return false;
  if (lhs.is_proxy < rhs.is_proxy)
    return true;
  if (rhs.is_proxy < lhs.is_proxy)
    return false;
  if (lhs.cert_authorities < rhs.cert_authorities)
    return true;
  if (rhs.cert_authorities < lhs.cert_authorities)
    return false;
  if (lhs.signature_algorithms < rhs.signature_algorithms)
    return true;
  if (rhs.signature_algorithms < lhs.signature_algorithms)
    return false;
  return false;
}
template <typename StructPtrType>
NetLogSourcePtr NetLogSource::Clone() const {
  return New(
      mojo::Clone(source_type),
      mojo::Clone(source_id),
      mojo::Clone(start_time)
  );
}

template <typename T, NetLogSource::EnableIfSame<T>*>
bool NetLogSource::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->source_type, other_struct.source_type))
    return false;
  if (!mojo::Equals(this->source_id, other_struct.source_id))
    return false;
  if (!mojo::Equals(this->start_time, other_struct.start_time))
    return false;
  return true;
}

template <typename T, NetLogSource::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.source_type < rhs.source_type)
    return true;
  if (rhs.source_type < lhs.source_type)
    return false;
  if (lhs.source_id < rhs.source_id)
    return true;
  if (rhs.source_id < lhs.source_id)
    return false;
  if (lhs.start_time < rhs.start_time)
    return true;
  if (rhs.start_time < lhs.start_time)
    return false;
  return false;
}


}  // network::mojom::blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::AuthChallengeInfo::DataView,
                                         ::network::mojom::blink::AuthChallengeInfoPtr> {
  static bool IsNull(const ::network::mojom::blink::AuthChallengeInfoPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::AuthChallengeInfoPtr* output) { output->reset(); }

  static decltype(::network::mojom::blink::AuthChallengeInfo::is_proxy) is_proxy(
      const ::network::mojom::blink::AuthChallengeInfoPtr& input) {
    return input->is_proxy;
  }

  static const decltype(::network::mojom::blink::AuthChallengeInfo::challenger)& challenger(
      const ::network::mojom::blink::AuthChallengeInfoPtr& input) {
    return input->challenger;
  }

  static const decltype(::network::mojom::blink::AuthChallengeInfo::scheme)& scheme(
      const ::network::mojom::blink::AuthChallengeInfoPtr& input) {
    return input->scheme;
  }

  static const decltype(::network::mojom::blink::AuthChallengeInfo::realm)& realm(
      const ::network::mojom::blink::AuthChallengeInfoPtr& input) {
    return input->realm;
  }

  static const decltype(::network::mojom::blink::AuthChallengeInfo::challenge)& challenge(
      const ::network::mojom::blink::AuthChallengeInfoPtr& input) {
    return input->challenge;
  }

  static const decltype(::network::mojom::blink::AuthChallengeInfo::path)& path(
      const ::network::mojom::blink::AuthChallengeInfoPtr& input) {
    return input->path;
  }

  static bool Read(::network::mojom::blink::AuthChallengeInfo::DataView input, ::network::mojom::blink::AuthChallengeInfoPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::HttpVersion::DataView,
                                         ::network::mojom::blink::HttpVersionPtr> {
  static bool IsNull(const ::network::mojom::blink::HttpVersionPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::HttpVersionPtr* output) { output->reset(); }

  static decltype(::network::mojom::blink::HttpVersion::major_value) major_value(
      const ::network::mojom::blink::HttpVersionPtr& input) {
    return input->major_value;
  }

  static decltype(::network::mojom::blink::HttpVersion::minor_value) minor_value(
      const ::network::mojom::blink::HttpVersionPtr& input) {
    return input->minor_value;
  }

  static bool Read(::network::mojom::blink::HttpVersion::DataView input, ::network::mojom::blink::HttpVersionPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::HostPortPair::DataView,
                                         ::network::mojom::blink::HostPortPairPtr> {
  static bool IsNull(const ::network::mojom::blink::HostPortPairPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::HostPortPairPtr* output) { output->reset(); }

  static const decltype(::network::mojom::blink::HostPortPair::host)& host(
      const ::network::mojom::blink::HostPortPairPtr& input) {
    return input->host;
  }

  static decltype(::network::mojom::blink::HostPortPair::port) port(
      const ::network::mojom::blink::HostPortPairPtr& input) {
    return input->port;
  }

  static bool Read(::network::mojom::blink::HostPortPair::DataView input, ::network::mojom::blink::HostPortPairPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::ProxyServer::DataView,
                                         ::network::mojom::blink::ProxyServerPtr> {
  static bool IsNull(const ::network::mojom::blink::ProxyServerPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::ProxyServerPtr* output) { output->reset(); }

  static decltype(::network::mojom::blink::ProxyServer::scheme) scheme(
      const ::network::mojom::blink::ProxyServerPtr& input) {
    return input->scheme;
  }

  static const decltype(::network::mojom::blink::ProxyServer::host_and_port)& host_and_port(
      const ::network::mojom::blink::ProxyServerPtr& input) {
    return input->host_and_port;
  }

  static bool Read(::network::mojom::blink::ProxyServer::DataView input, ::network::mojom::blink::ProxyServerPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::ProxyChain::DataView,
                                         ::network::mojom::blink::ProxyChainPtr> {
  static bool IsNull(const ::network::mojom::blink::ProxyChainPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::ProxyChainPtr* output) { output->reset(); }

  static const decltype(::network::mojom::blink::ProxyChain::proxy_servers)& proxy_servers(
      const ::network::mojom::blink::ProxyChainPtr& input) {
    return input->proxy_servers;
  }

  static decltype(::network::mojom::blink::ProxyChain::ip_protection_chain_id) ip_protection_chain_id(
      const ::network::mojom::blink::ProxyChainPtr& input) {
    return input->ip_protection_chain_id;
  }

  static bool Read(::network::mojom::blink::ProxyChain::DataView input, ::network::mojom::blink::ProxyChainPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::ResolveErrorInfo::DataView,
                                         ::network::mojom::blink::ResolveErrorInfoPtr> {
  static bool IsNull(const ::network::mojom::blink::ResolveErrorInfoPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::ResolveErrorInfoPtr* output) { output->reset(); }

  static decltype(::network::mojom::blink::ResolveErrorInfo::error) error(
      const ::network::mojom::blink::ResolveErrorInfoPtr& input) {
    return input->error;
  }

  static decltype(::network::mojom::blink::ResolveErrorInfo::is_secure_network_error) is_secure_network_error(
      const ::network::mojom::blink::ResolveErrorInfoPtr& input) {
    return input->is_secure_network_error;
  }

  static bool Read(::network::mojom::blink::ResolveErrorInfo::DataView input, ::network::mojom::blink::ResolveErrorInfoPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::SSLCertRequestInfo::DataView,
                                         ::network::mojom::blink::SSLCertRequestInfoPtr> {
  static bool IsNull(const ::network::mojom::blink::SSLCertRequestInfoPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::SSLCertRequestInfoPtr* output) { output->reset(); }

  static const decltype(::network::mojom::blink::SSLCertRequestInfo::host_and_port)& host_and_port(
      const ::network::mojom::blink::SSLCertRequestInfoPtr& input) {
    return input->host_and_port;
  }

  static decltype(::network::mojom::blink::SSLCertRequestInfo::is_proxy) is_proxy(
      const ::network::mojom::blink::SSLCertRequestInfoPtr& input) {
    return input->is_proxy;
  }

  static const decltype(::network::mojom::blink::SSLCertRequestInfo::cert_authorities)& cert_authorities(
      const ::network::mojom::blink::SSLCertRequestInfoPtr& input) {
    return input->cert_authorities;
  }

  static const decltype(::network::mojom::blink::SSLCertRequestInfo::signature_algorithms)& signature_algorithms(
      const ::network::mojom::blink::SSLCertRequestInfoPtr& input) {
    return input->signature_algorithms;
  }

  static bool Read(::network::mojom::blink::SSLCertRequestInfo::DataView input, ::network::mojom::blink::SSLCertRequestInfoPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::NetLogSource::DataView,
                                         ::network::mojom::blink::NetLogSourcePtr> {
  static bool IsNull(const ::network::mojom::blink::NetLogSourcePtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::NetLogSourcePtr* output) { output->reset(); }

  static decltype(::network::mojom::blink::NetLogSource::source_type) source_type(
      const ::network::mojom::blink::NetLogSourcePtr& input) {
    return input->source_type;
  }

  static decltype(::network::mojom::blink::NetLogSource::source_id) source_id(
      const ::network::mojom::blink::NetLogSourcePtr& input) {
    return input->source_id;
  }

  static const decltype(::network::mojom::blink::NetLogSource::start_time)& start_time(
      const ::network::mojom::blink::NetLogSourcePtr& input) {
    return input->start_time;
  }

  static bool Read(::network::mojom::blink::NetLogSource::DataView input, ::network::mojom::blink::NetLogSourcePtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_PARAM_MOJOM_BLINK_H_