// services/network/public/mojom/network_service_test.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_SERVICE_TEST_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_SERVICE_TEST_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/network_service_test.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file.mojom-shared.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "mojo/public/mojom/base/memory_pressure_level.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "services/network/public/mojom/address_list.mojom-shared.h"
#include "services/network/public/mojom/host_resolver.mojom-shared.h"
#include "services/network/public/mojom/network_change_manager.mojom-shared.h"
#include "services/network/public/mojom/network_interface_change_listener.mojom-shared.h"
#include "services/network/public/mojom/network_param.mojom-shared.h"
#include "services/network/public/mojom/network_types.mojom-shared.h"
#include "services/network/public/mojom/http_cache_backend_file_operations.mojom-shared.h"
#include "services/network/public/mojom/ip_endpoint.mojom-shared.h"
#include "services/network/public/mojom/transferable_socket.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "services/network/public/mojom/network_service_test.mojom-data-view.h"




namespace std {

template <>
struct hash<::network::mojom::ResolverType>
    : public mojo::internal::EnumHashImpl<::network::mojom::ResolverType> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::ResolverType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::ResolverType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::ResolverType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::RuleDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::RuleDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::Rule_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::network::mojom::ResolverType>(
      Traits::resolver_type(input),
      &fragment->resolver_type);

    decltype(Traits::host_pattern(input)) in_host_pattern = Traits::host_pattern(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->host_pattern)::BaseType> host_pattern_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_host_pattern,
      host_pattern_fragment);

    fragment->host_pattern.Set(
        host_pattern_fragment.is_null() ? nullptr : host_pattern_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->host_pattern.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null host_pattern in Rule struct");

    decltype(Traits::replacement(input)) in_replacement = Traits::replacement(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->replacement)::BaseType> replacement_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_replacement,
      replacement_fragment);

    fragment->replacement.Set(
        replacement_fragment.is_null() ? nullptr : replacement_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->replacement.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null replacement in Rule struct");

    fragment->host_resolver_flags = Traits::host_resolver_flags(input);

    decltype(Traits::dns_aliases(input)) in_dns_aliases = Traits::dns_aliases(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->dns_aliases)::BaseType>
        dns_aliases_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& dns_aliases_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_dns_aliases,
      dns_aliases_fragment,
      &dns_aliases_validate_params);

    fragment->dns_aliases.Set(
        dns_aliases_fragment.is_null() ? nullptr : dns_aliases_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->dns_aliases.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null dns_aliases in Rule struct");
  }

  static bool Deserialize(::network::mojom::internal::Rule_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::RuleDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::SimpleCacheOpenEntryResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::SimpleCacheOpenEntryResultDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::SimpleCacheOpenEntryResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->error = Traits::error(input);

    decltype(Traits::key(input)) in_key = Traits::key(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->key)::BaseType> key_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_key,
      key_fragment);

    fragment->key.Set(
        key_fragment.is_null() ? nullptr : key_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->key.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null key in SimpleCacheOpenEntryResult struct");

    decltype(Traits::entry(input)) in_entry = Traits::entry(input);

    
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::SimpleCacheEntryInterfaceBase>>(
      in_entry,
      &fragment->entry,
      &fragment.message());
  }

  static bool Deserialize(::network::mojom::internal::SimpleCacheOpenEntryResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::SimpleCacheOpenEntryResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network::mojom {

inline void RuleDataView::GetHostPatternDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->host_pattern.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void RuleDataView::GetReplacementDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->replacement.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void RuleDataView::GetDnsAliasesDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->dns_aliases.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}


inline void SimpleCacheOpenEntryResultDataView::GetKeyDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->key.Get();
  *output = mojo::StringDataView(pointer, message_);
}



}  // network::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::ResolverType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::ResolverType value);
};

} // namespace perfetto

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_SERVICE_TEST_MOJOM_SHARED_H_