// services/network/public/mojom/oblivious_http_request.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_OBLIVIOUS_HTTP_REQUEST_MOJOM_BLINK_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_OBLIVIOUS_HTTP_REQUEST_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/oblivious_http_request.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/oblivious_http_request.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/oblivious_http_request.mojom-blink-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/byte_string.mojom-blink.h"
#include "mojo/public/mojom/base/time.mojom-blink.h"
#include "services/network/public/mojom/isolation_info.mojom-blink-forward.h"
#include "services/network/public/mojom/mutable_network_traffic_annotation_tag.mojom-blink.h"
#include "services/network/public/mojom/network_param.mojom-blink.h"
#include "services/network/public/mojom/trust_tokens.mojom-blink.h"
#include "url/mojom/url.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "mojo/public/cpp/bindings/lib/native_enum_serialization.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"
#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace network::mojom::blink {

class ObliviousHttpClientProxy;

template <typename ImplRefTraits>
class ObliviousHttpClientStub;

class ObliviousHttpClientRequestValidator;


class BLINK_PLATFORM_EXPORT ObliviousHttpClient
    : public ObliviousHttpClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "network.mojom.ObliviousHttpClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ObliviousHttpClientInterfaceBase;
  using Proxy_ = ObliviousHttpClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = ObliviousHttpClientStub<ImplRefTraits>;

  using RequestValidator_ = ObliviousHttpClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnCompletedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnCompleted_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ObliviousHttpClient() = default;

  virtual void OnCompleted(ObliviousHttpCompletionResultPtr response) = 0;
};



class BLINK_PLATFORM_EXPORT ObliviousHttpClientProxy
    : public ObliviousHttpClient {
 public:
  using InterfaceType = ObliviousHttpClient;

  explicit ObliviousHttpClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnCompleted(ObliviousHttpCompletionResultPtr response) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_PLATFORM_EXPORT ObliviousHttpClientStubDispatch {
 public:
  static bool Accept(ObliviousHttpClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ObliviousHttpClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ObliviousHttpClient>>
class ObliviousHttpClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ObliviousHttpClientStub() = default;
  ~ObliviousHttpClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ObliviousHttpClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ObliviousHttpClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT ObliviousHttpClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};







class BLINK_PLATFORM_EXPORT ObliviousHttpPaddingParameters {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ObliviousHttpPaddingParameters, T>::value>;
  using DataView = ObliviousHttpPaddingParametersDataView;
  using Data_ = internal::ObliviousHttpPaddingParameters_Data;

  template <typename... Args>
  static ObliviousHttpPaddingParametersPtr New(Args&&... args) {
    return ObliviousHttpPaddingParametersPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ObliviousHttpPaddingParametersPtr From(const U& u) {
    return mojo::TypeConverter<ObliviousHttpPaddingParametersPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ObliviousHttpPaddingParameters>::Convert(*this);
  }


  ObliviousHttpPaddingParameters();

  ObliviousHttpPaddingParameters(
      bool add_exponential_pad,
      uint16_t exponential_mean,
      bool pad_to_next_power_of_two);


  ~ObliviousHttpPaddingParameters();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ObliviousHttpPaddingParametersPtr>
  ObliviousHttpPaddingParametersPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ObliviousHttpPaddingParameters::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ObliviousHttpPaddingParameters::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ObliviousHttpPaddingParameters::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ObliviousHttpPaddingParameters::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ObliviousHttpPaddingParameters::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ObliviousHttpPaddingParameters::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ObliviousHttpPaddingParameters_UnserializedMessageContext<
            UserType, ObliviousHttpPaddingParameters::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ObliviousHttpPaddingParameters::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ObliviousHttpPaddingParameters::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ObliviousHttpPaddingParameters_UnserializedMessageContext<
            UserType, ObliviousHttpPaddingParameters::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ObliviousHttpPaddingParameters::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool add_exponential_pad;
  
  uint16_t exponential_mean;
  
  bool pad_to_next_power_of_two;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ObliviousHttpPaddingParameters::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ObliviousHttpPaddingParameters::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ObliviousHttpPaddingParameters::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ObliviousHttpPaddingParameters::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class BLINK_PLATFORM_EXPORT ObliviousHttpCompletionResult {
 public:
  using DataView = ObliviousHttpCompletionResultDataView;
  using Data_ = internal::ObliviousHttpCompletionResult_Data;
  using Tag = Data_::ObliviousHttpCompletionResult_Tag;

  template <typename... Args>
  static ObliviousHttpCompletionResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |net_error|.
  static ObliviousHttpCompletionResultPtr NewNetError(
      int32_t value);
  // Construct an instance holding |outer_response_error_code|.
  static ObliviousHttpCompletionResultPtr NewOuterResponseErrorCode(
      int32_t value);
  // Construct an instance holding |inner_response|.
  static ObliviousHttpCompletionResultPtr NewInnerResponse(
      ObliviousHttpResponsePtr value);

  template <typename U>
  static ObliviousHttpCompletionResultPtr From(const U& u) {
    return mojo::TypeConverter<ObliviousHttpCompletionResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ObliviousHttpCompletionResult>::Convert(*this);
  }
  ~ObliviousHttpCompletionResult();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  ObliviousHttpCompletionResult(const ObliviousHttpCompletionResult& other) = delete;
  ObliviousHttpCompletionResult& operator=(const ObliviousHttpCompletionResult& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = ObliviousHttpCompletionResultPtr>
  ObliviousHttpCompletionResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, ObliviousHttpCompletionResult>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, ObliviousHttpCompletionResult>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_net_error() const { return tag_ == Tag::kNetError; }
  int32_t get_net_error() const {
    CHECK(tag_ == Tag::kNetError);
    return data_.net_error;
  }
  void set_net_error(int32_t net_error);

  bool is_outer_response_error_code() const { return tag_ == Tag::kOuterResponseErrorCode; }
  int32_t get_outer_response_error_code() const {
    CHECK(tag_ == Tag::kOuterResponseErrorCode);
    return data_.outer_response_error_code;
  }
  void set_outer_response_error_code(int32_t outer_response_error_code);

  bool is_inner_response() const { return tag_ == Tag::kInnerResponse; }
  const ObliviousHttpResponsePtr& get_inner_response() const {
    CHECK(tag_ == Tag::kInnerResponse);
    return data_.inner_response;
  }
  ObliviousHttpResponsePtr& get_inner_response() {
    CHECK(tag_ == Tag::kInnerResponse);
    return data_.inner_response;
  }
  void set_inner_response(ObliviousHttpResponsePtr inner_response);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ObliviousHttpCompletionResult::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<ObliviousHttpCompletionResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kNetError)>,
        int32_t value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kOuterResponseErrorCode)>,
        int32_t value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kInnerResponse)>,
        ObliviousHttpResponsePtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    int32_t net_error;
    int32_t outer_response_error_code;
    ObliviousHttpResponsePtr inner_response;
  };

  ObliviousHttpCompletionResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kNetError)>,
      int32_t value);
  ObliviousHttpCompletionResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kOuterResponseErrorCode)>,
      int32_t value);
  ObliviousHttpCompletionResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kInnerResponse)>,
      ObliviousHttpResponsePtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class BLINK_PLATFORM_EXPORT ObliviousHttpRequestBody {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ObliviousHttpRequestBody, T>::value>;
  using DataView = ObliviousHttpRequestBodyDataView;
  using Data_ = internal::ObliviousHttpRequestBody_Data;

  template <typename... Args>
  static ObliviousHttpRequestBodyPtr New(Args&&... args) {
    return ObliviousHttpRequestBodyPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ObliviousHttpRequestBodyPtr From(const U& u) {
    return mojo::TypeConverter<ObliviousHttpRequestBodyPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ObliviousHttpRequestBody>::Convert(*this);
  }


  ObliviousHttpRequestBody();

  ObliviousHttpRequestBody(
      const std::string& content,
      const ::blink::String& content_type);


  ~ObliviousHttpRequestBody();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ObliviousHttpRequestBodyPtr>
  ObliviousHttpRequestBodyPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ObliviousHttpRequestBody::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ObliviousHttpRequestBody::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ObliviousHttpRequestBody::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ObliviousHttpRequestBody::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ObliviousHttpRequestBody::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ObliviousHttpRequestBody::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ObliviousHttpRequestBody_UnserializedMessageContext<
            UserType, ObliviousHttpRequestBody::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ObliviousHttpRequestBody::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ObliviousHttpRequestBody::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ObliviousHttpRequestBody_UnserializedMessageContext<
            UserType, ObliviousHttpRequestBody::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ObliviousHttpRequestBody::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string content;
  
  ::blink::String content_type;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ObliviousHttpRequestBody::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ObliviousHttpRequestBody::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ObliviousHttpRequestBody::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ObliviousHttpRequestBody::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT ObliviousHttpResponse {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ObliviousHttpResponse, T>::value>;
  using DataView = ObliviousHttpResponseDataView;
  using Data_ = internal::ObliviousHttpResponse_Data;

  template <typename... Args>
  static ObliviousHttpResponsePtr New(Args&&... args) {
    return ObliviousHttpResponsePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ObliviousHttpResponsePtr From(const U& u) {
    return mojo::TypeConverter<ObliviousHttpResponsePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ObliviousHttpResponse>::Convert(*this);
  }


  ObliviousHttpResponse();

  ObliviousHttpResponse(
      int32_t response_code,
      ::network::mojom::blink::HttpResponseHeadersPtr headers,
      const std::string& response_body);

ObliviousHttpResponse(const ObliviousHttpResponse&) = delete;
ObliviousHttpResponse& operator=(const ObliviousHttpResponse&) = delete;

  ~ObliviousHttpResponse();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ObliviousHttpResponsePtr>
  ObliviousHttpResponsePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ObliviousHttpResponse::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ObliviousHttpResponse::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ObliviousHttpResponse::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ObliviousHttpResponse::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ObliviousHttpResponse::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ObliviousHttpResponse::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ObliviousHttpResponse_UnserializedMessageContext<
            UserType, ObliviousHttpResponse::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ObliviousHttpResponse::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ObliviousHttpResponse::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ObliviousHttpResponse_UnserializedMessageContext<
            UserType, ObliviousHttpResponse::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ObliviousHttpResponse::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t response_code;
  
  ::network::mojom::blink::HttpResponseHeadersPtr headers;
  
  std::string response_body;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ObliviousHttpResponse::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ObliviousHttpResponse::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ObliviousHttpResponse::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ObliviousHttpResponse::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class BLINK_PLATFORM_EXPORT ObliviousHttpRequest {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ObliviousHttpRequest, T>::value>;
  using DataView = ObliviousHttpRequestDataView;
  using Data_ = internal::ObliviousHttpRequest_Data;

  template <typename... Args>
  static ObliviousHttpRequestPtr New(Args&&... args) {
    return ObliviousHttpRequestPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ObliviousHttpRequestPtr From(const U& u) {
    return mojo::TypeConverter<ObliviousHttpRequestPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ObliviousHttpRequest>::Convert(*this);
  }


  ObliviousHttpRequest();

  ObliviousHttpRequest(
      const ::blink::KURL& relay_url,
      const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation,
      std::optional<::base::TimeDelta> timeout_duration,
      const ::blink::String& key_config,
      const ::blink::KURL& resource_url,
      const ::blink::String& method,
      ObliviousHttpRequestBodyPtr request_body,
      ::network::mojom::blink::TrustTokenParamsPtr trust_token_params,
      ObliviousHttpPaddingParametersPtr padding_params);

ObliviousHttpRequest(const ObliviousHttpRequest&) = delete;
ObliviousHttpRequest& operator=(const ObliviousHttpRequest&) = delete;

  ~ObliviousHttpRequest();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ObliviousHttpRequestPtr>
  ObliviousHttpRequestPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ObliviousHttpRequest::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ObliviousHttpRequest::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ObliviousHttpRequest::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ObliviousHttpRequest::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ObliviousHttpRequest::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ObliviousHttpRequest::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ObliviousHttpRequest_UnserializedMessageContext<
            UserType, ObliviousHttpRequest::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ObliviousHttpRequest::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ObliviousHttpRequest::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ObliviousHttpRequest_UnserializedMessageContext<
            UserType, ObliviousHttpRequest::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ObliviousHttpRequest::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::KURL relay_url;
  
  ::net::MutableNetworkTrafficAnnotationTag traffic_annotation;
  
  std::optional<::base::TimeDelta> timeout_duration;
  
  ::blink::String key_config;
  
  ::blink::KURL resource_url;
  
  ::blink::String method;
  
  ObliviousHttpRequestBodyPtr request_body;
  
  ::network::mojom::blink::TrustTokenParamsPtr trust_token_params;
  
  ObliviousHttpPaddingParametersPtr padding_params;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ObliviousHttpRequest::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ObliviousHttpRequest::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ObliviousHttpRequest::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ObliviousHttpRequest::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
ObliviousHttpCompletionResultPtr ObliviousHttpCompletionResult::Clone() const {
  switch (tag_) {
    case Tag::kNetError:
      return NewNetError(
          mojo::Clone(data_.net_error));
    case Tag::kOuterResponseErrorCode:
      return NewOuterResponseErrorCode(
          mojo::Clone(data_.outer_response_error_code));
    case Tag::kInnerResponse:
      return NewInnerResponse(
          mojo::Clone(data_.inner_response));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, ObliviousHttpCompletionResult>::value>::type*>
bool ObliviousHttpCompletionResult::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kNetError:
      return mojo::Equals(data_.net_error, other.data_.net_error);
    case Tag::kOuterResponseErrorCode:
      return mojo::Equals(data_.outer_response_error_code, other.data_.outer_response_error_code);
    case Tag::kInnerResponse:
      return mojo::Equals(data_.inner_response, other.data_.inner_response);
  }

  return false;
}
template <typename StructPtrType>
ObliviousHttpRequestBodyPtr ObliviousHttpRequestBody::Clone() const {
  return New(
      mojo::Clone(content),
      mojo::Clone(content_type)
  );
}

template <typename T, ObliviousHttpRequestBody::EnableIfSame<T>*>
bool ObliviousHttpRequestBody::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->content, other_struct.content))
    return false;
  if (!mojo::Equals(this->content_type, other_struct.content_type))
    return false;
  return true;
}

template <typename T, ObliviousHttpRequestBody::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.content < rhs.content)
    return true;
  if (rhs.content < lhs.content)
    return false;
  if (lhs.content_type < rhs.content_type)
    return true;
  if (rhs.content_type < lhs.content_type)
    return false;
  return false;
}
template <typename StructPtrType>
ObliviousHttpResponsePtr ObliviousHttpResponse::Clone() const {
  return New(
      mojo::Clone(response_code),
      mojo::Clone(headers),
      mojo::Clone(response_body)
  );
}

template <typename T, ObliviousHttpResponse::EnableIfSame<T>*>
bool ObliviousHttpResponse::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->response_code, other_struct.response_code))
    return false;
  if (!mojo::Equals(this->headers, other_struct.headers))
    return false;
  if (!mojo::Equals(this->response_body, other_struct.response_body))
    return false;
  return true;
}

template <typename T, ObliviousHttpResponse::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.response_code < rhs.response_code)
    return true;
  if (rhs.response_code < lhs.response_code)
    return false;
  if (lhs.headers < rhs.headers)
    return true;
  if (rhs.headers < lhs.headers)
    return false;
  if (lhs.response_body < rhs.response_body)
    return true;
  if (rhs.response_body < lhs.response_body)
    return false;
  return false;
}
template <typename StructPtrType>
ObliviousHttpPaddingParametersPtr ObliviousHttpPaddingParameters::Clone() const {
  return New(
      mojo::Clone(add_exponential_pad),
      mojo::Clone(exponential_mean),
      mojo::Clone(pad_to_next_power_of_two)
  );
}

template <typename T, ObliviousHttpPaddingParameters::EnableIfSame<T>*>
bool ObliviousHttpPaddingParameters::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->add_exponential_pad, other_struct.add_exponential_pad))
    return false;
  if (!mojo::Equals(this->exponential_mean, other_struct.exponential_mean))
    return false;
  if (!mojo::Equals(this->pad_to_next_power_of_two, other_struct.pad_to_next_power_of_two))
    return false;
  return true;
}

template <typename T, ObliviousHttpPaddingParameters::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.add_exponential_pad < rhs.add_exponential_pad)
    return true;
  if (rhs.add_exponential_pad < lhs.add_exponential_pad)
    return false;
  if (lhs.exponential_mean < rhs.exponential_mean)
    return true;
  if (rhs.exponential_mean < lhs.exponential_mean)
    return false;
  if (lhs.pad_to_next_power_of_two < rhs.pad_to_next_power_of_two)
    return true;
  if (rhs.pad_to_next_power_of_two < lhs.pad_to_next_power_of_two)
    return false;
  return false;
}
template <typename StructPtrType>
ObliviousHttpRequestPtr ObliviousHttpRequest::Clone() const {
  return New(
      mojo::Clone(relay_url),
      mojo::Clone(traffic_annotation),
      mojo::Clone(timeout_duration),
      mojo::Clone(key_config),
      mojo::Clone(resource_url),
      mojo::Clone(method),
      mojo::Clone(request_body),
      mojo::Clone(trust_token_params),
      mojo::Clone(padding_params)
  );
}

template <typename T, ObliviousHttpRequest::EnableIfSame<T>*>
bool ObliviousHttpRequest::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->relay_url, other_struct.relay_url))
    return false;
  if (!mojo::Equals(this->traffic_annotation, other_struct.traffic_annotation))
    return false;
  if (!mojo::Equals(this->timeout_duration, other_struct.timeout_duration))
    return false;
  if (!mojo::Equals(this->key_config, other_struct.key_config))
    return false;
  if (!mojo::Equals(this->resource_url, other_struct.resource_url))
    return false;
  if (!mojo::Equals(this->method, other_struct.method))
    return false;
  if (!mojo::Equals(this->request_body, other_struct.request_body))
    return false;
  if (!mojo::Equals(this->trust_token_params, other_struct.trust_token_params))
    return false;
  if (!mojo::Equals(this->padding_params, other_struct.padding_params))
    return false;
  return true;
}

template <typename T, ObliviousHttpRequest::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.relay_url < rhs.relay_url)
    return true;
  if (rhs.relay_url < lhs.relay_url)
    return false;
  if (lhs.traffic_annotation < rhs.traffic_annotation)
    return true;
  if (rhs.traffic_annotation < lhs.traffic_annotation)
    return false;
  if (lhs.timeout_duration < rhs.timeout_duration)
    return true;
  if (rhs.timeout_duration < lhs.timeout_duration)
    return false;
  if (lhs.key_config < rhs.key_config)
    return true;
  if (rhs.key_config < lhs.key_config)
    return false;
  if (lhs.resource_url < rhs.resource_url)
    return true;
  if (rhs.resource_url < lhs.resource_url)
    return false;
  if (lhs.method < rhs.method)
    return true;
  if (rhs.method < lhs.method)
    return false;
  if (lhs.request_body < rhs.request_body)
    return true;
  if (rhs.request_body < lhs.request_body)
    return false;
  if (lhs.trust_token_params < rhs.trust_token_params)
    return true;
  if (rhs.trust_token_params < lhs.trust_token_params)
    return false;
  if (lhs.padding_params < rhs.padding_params)
    return true;
  if (rhs.padding_params < lhs.padding_params)
    return false;
  return false;
}


}  // network::mojom::blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::ObliviousHttpRequestBody::DataView,
                                         ::network::mojom::blink::ObliviousHttpRequestBodyPtr> {
  static bool IsNull(const ::network::mojom::blink::ObliviousHttpRequestBodyPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::ObliviousHttpRequestBodyPtr* output) { output->reset(); }

  static const decltype(::network::mojom::blink::ObliviousHttpRequestBody::content)& content(
      const ::network::mojom::blink::ObliviousHttpRequestBodyPtr& input) {
    return input->content;
  }

  static const decltype(::network::mojom::blink::ObliviousHttpRequestBody::content_type)& content_type(
      const ::network::mojom::blink::ObliviousHttpRequestBodyPtr& input) {
    return input->content_type;
  }

  static bool Read(::network::mojom::blink::ObliviousHttpRequestBody::DataView input, ::network::mojom::blink::ObliviousHttpRequestBodyPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::ObliviousHttpResponse::DataView,
                                         ::network::mojom::blink::ObliviousHttpResponsePtr> {
  static bool IsNull(const ::network::mojom::blink::ObliviousHttpResponsePtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::ObliviousHttpResponsePtr* output) { output->reset(); }

  static decltype(::network::mojom::blink::ObliviousHttpResponse::response_code) response_code(
      const ::network::mojom::blink::ObliviousHttpResponsePtr& input) {
    return input->response_code;
  }

  static const decltype(::network::mojom::blink::ObliviousHttpResponse::headers)& headers(
      const ::network::mojom::blink::ObliviousHttpResponsePtr& input) {
    return input->headers;
  }

  static const decltype(::network::mojom::blink::ObliviousHttpResponse::response_body)& response_body(
      const ::network::mojom::blink::ObliviousHttpResponsePtr& input) {
    return input->response_body;
  }

  static bool Read(::network::mojom::blink::ObliviousHttpResponse::DataView input, ::network::mojom::blink::ObliviousHttpResponsePtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::ObliviousHttpPaddingParameters::DataView,
                                         ::network::mojom::blink::ObliviousHttpPaddingParametersPtr> {
  static bool IsNull(const ::network::mojom::blink::ObliviousHttpPaddingParametersPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::ObliviousHttpPaddingParametersPtr* output) { output->reset(); }

  static decltype(::network::mojom::blink::ObliviousHttpPaddingParameters::add_exponential_pad) add_exponential_pad(
      const ::network::mojom::blink::ObliviousHttpPaddingParametersPtr& input) {
    return input->add_exponential_pad;
  }

  static decltype(::network::mojom::blink::ObliviousHttpPaddingParameters::exponential_mean) exponential_mean(
      const ::network::mojom::blink::ObliviousHttpPaddingParametersPtr& input) {
    return input->exponential_mean;
  }

  static decltype(::network::mojom::blink::ObliviousHttpPaddingParameters::pad_to_next_power_of_two) pad_to_next_power_of_two(
      const ::network::mojom::blink::ObliviousHttpPaddingParametersPtr& input) {
    return input->pad_to_next_power_of_two;
  }

  static bool Read(::network::mojom::blink::ObliviousHttpPaddingParameters::DataView input, ::network::mojom::blink::ObliviousHttpPaddingParametersPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::ObliviousHttpRequest::DataView,
                                         ::network::mojom::blink::ObliviousHttpRequestPtr> {
  static bool IsNull(const ::network::mojom::blink::ObliviousHttpRequestPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::ObliviousHttpRequestPtr* output) { output->reset(); }

  static const decltype(::network::mojom::blink::ObliviousHttpRequest::relay_url)& relay_url(
      const ::network::mojom::blink::ObliviousHttpRequestPtr& input) {
    return input->relay_url;
  }

  static const decltype(::network::mojom::blink::ObliviousHttpRequest::traffic_annotation)& traffic_annotation(
      const ::network::mojom::blink::ObliviousHttpRequestPtr& input) {
    return input->traffic_annotation;
  }

  static const decltype(::network::mojom::blink::ObliviousHttpRequest::timeout_duration)& timeout_duration(
      const ::network::mojom::blink::ObliviousHttpRequestPtr& input) {
    return input->timeout_duration;
  }

  static const decltype(::network::mojom::blink::ObliviousHttpRequest::key_config)& key_config(
      const ::network::mojom::blink::ObliviousHttpRequestPtr& input) {
    return input->key_config;
  }

  static const decltype(::network::mojom::blink::ObliviousHttpRequest::resource_url)& resource_url(
      const ::network::mojom::blink::ObliviousHttpRequestPtr& input) {
    return input->resource_url;
  }

  static const decltype(::network::mojom::blink::ObliviousHttpRequest::method)& method(
      const ::network::mojom::blink::ObliviousHttpRequestPtr& input) {
    return input->method;
  }

  static const decltype(::network::mojom::blink::ObliviousHttpRequest::request_body)& request_body(
      const ::network::mojom::blink::ObliviousHttpRequestPtr& input) {
    return input->request_body;
  }

  static const decltype(::network::mojom::blink::ObliviousHttpRequest::trust_token_params)& trust_token_params(
      const ::network::mojom::blink::ObliviousHttpRequestPtr& input) {
    return input->trust_token_params;
  }

  static const decltype(::network::mojom::blink::ObliviousHttpRequest::padding_params)& padding_params(
      const ::network::mojom::blink::ObliviousHttpRequestPtr& input) {
    return input->padding_params;
  }

  static bool Read(::network::mojom::blink::ObliviousHttpRequest::DataView input, ::network::mojom::blink::ObliviousHttpRequestPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT UnionTraits<::network::mojom::blink::ObliviousHttpCompletionResult::DataView,
                                        ::network::mojom::blink::ObliviousHttpCompletionResultPtr> {
  static bool IsNull(const ::network::mojom::blink::ObliviousHttpCompletionResultPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::ObliviousHttpCompletionResultPtr* output) { output->reset(); }

  static ::network::mojom::blink::ObliviousHttpCompletionResult::Tag GetTag(const ::network::mojom::blink::ObliviousHttpCompletionResultPtr& input) {
    return input->which();
  }

  static  int32_t net_error(const ::network::mojom::blink::ObliviousHttpCompletionResultPtr& input) {
    return input->get_net_error();
  }

  static  int32_t outer_response_error_code(const ::network::mojom::blink::ObliviousHttpCompletionResultPtr& input) {
    return input->get_outer_response_error_code();
  }

  static const ::network::mojom::blink::ObliviousHttpResponsePtr& inner_response(const ::network::mojom::blink::ObliviousHttpCompletionResultPtr& input) {
    return input->get_inner_response();
  }

  static bool Read(::network::mojom::blink::ObliviousHttpCompletionResult::DataView input, ::network::mojom::blink::ObliviousHttpCompletionResultPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_OBLIVIOUS_HTTP_REQUEST_MOJOM_BLINK_H_