// services/network/public/mojom/proxy_config.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_PROXY_CONFIG_MOJOM_DATA_VIEW_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_PROXY_CONFIG_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "services/network/public/mojom/proxy_config.mojom-shared-internal.h"
#include "mojo/public/mojom/base/big_string.mojom-shared.h"
#include "services/network/public/mojom/network_param.mojom-shared.h"


namespace network::mojom {
class ProxyBypassRulesDataView;

class ProxyListDataView;

class ProxyRulesDataView;

class ProxyConfigDataView;



}  // network::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::ProxyBypassRulesDataView> {
  using Data = ::network::mojom::internal::ProxyBypassRules_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::ProxyListDataView> {
  using Data = ::network::mojom::internal::ProxyList_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::ProxyRulesDataView> {
  using Data = ::network::mojom::internal::ProxyRules_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::ProxyConfigDataView> {
  using Data = ::network::mojom::internal::ProxyConfig_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {


enum class ProxyRulesType : int32_t {
  
  EMPTY = 0,
  
  PROXY_LIST = 1,
  
  PROXY_LIST_PER_SCHEME = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, ProxyRulesType value);
inline bool IsKnownEnumValue(ProxyRulesType value) {
  return internal::ProxyRulesType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class IpProtectionProxyBypassPolicy : int32_t {
  
  kNone = 0,
  
  kFirstPartyToTopLevelFrame = 1,
  
  kExclusionList = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, IpProtectionProxyBypassPolicy value);
inline bool IsKnownEnumValue(IpProtectionProxyBypassPolicy value) {
  return internal::IpProtectionProxyBypassPolicy_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class ProxyBypassRulesDataView {
 public:
  ProxyBypassRulesDataView() = default;

  ProxyBypassRulesDataView(
      internal::ProxyBypassRules_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRulesDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRules(UserType* output) {
    
    auto* pointer = data_->rules.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
 private:
  internal::ProxyBypassRules_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ProxyListDataView {
 public:
  ProxyListDataView() = default;

  ProxyListDataView(
      internal::ProxyList_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetProxiesDataView(
      mojo::ArrayDataView<::network::mojom::ProxyChainDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadProxies(UserType* output) {
    
    auto* pointer = data_->proxies.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::ProxyChainDataView>>(
        pointer, output, message_);
  }
 private:
  internal::ProxyList_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ProxyRulesDataView {
 public:
  ProxyRulesDataView() = default;

  ProxyRulesDataView(
      internal::ProxyRules_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetBypassRulesDataView(
      ProxyBypassRulesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBypassRules(UserType* output) {
    
    auto* pointer = data_->bypass_rules.Get();
    return mojo::internal::Deserialize<::network::mojom::ProxyBypassRulesDataView>(
        pointer, output, message_);
  }
  bool reverse_bypass() const {
    return data_->reverse_bypass;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::network::mojom::ProxyRulesType>(
        data_value, output);
  }
  ProxyRulesType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::ProxyRulesType>(data_->type));
  }
  inline void GetSingleProxiesDataView(
      ProxyListDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSingleProxies(UserType* output) {
    
    auto* pointer = data_->single_proxies.Get();
    return mojo::internal::Deserialize<::network::mojom::ProxyListDataView>(
        pointer, output, message_);
  }
  inline void GetProxiesForHttpDataView(
      ProxyListDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadProxiesForHttp(UserType* output) {
    
    auto* pointer = data_->proxies_for_http.Get();
    return mojo::internal::Deserialize<::network::mojom::ProxyListDataView>(
        pointer, output, message_);
  }
  inline void GetProxiesForHttpsDataView(
      ProxyListDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadProxiesForHttps(UserType* output) {
    
    auto* pointer = data_->proxies_for_https.Get();
    return mojo::internal::Deserialize<::network::mojom::ProxyListDataView>(
        pointer, output, message_);
  }
  inline void GetProxiesForFtpDataView(
      ProxyListDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadProxiesForFtp(UserType* output) {
    
    auto* pointer = data_->proxies_for_ftp.Get();
    return mojo::internal::Deserialize<::network::mojom::ProxyListDataView>(
        pointer, output, message_);
  }
  inline void GetFallbackProxiesDataView(
      ProxyListDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFallbackProxies(UserType* output) {
    
    auto* pointer = data_->fallback_proxies.Get();
    return mojo::internal::Deserialize<::network::mojom::ProxyListDataView>(
        pointer, output, message_);
  }
 private:
  internal::ProxyRules_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ProxyConfigDataView {
 public:
  ProxyConfigDataView() = default;

  ProxyConfigDataView(
      internal::ProxyConfig_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool auto_detect() const {
    return data_->auto_detect;
  }
  bool from_system() const {
    return data_->from_system;
  }
  inline void GetPacUrlDataView(
      ::mojo_base::mojom::BigStringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPacUrl(UserType* output) {
    
    auto* pointer = data_->pac_url.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::BigStringDataView>(
        pointer, output, message_);
  }
  bool pac_mandatory() const {
    return data_->pac_mandatory;
  }
  inline void GetProxyRulesDataView(
      ProxyRulesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadProxyRules(UserType* output) {
    
    auto* pointer = data_->proxy_rules.Get();
    return mojo::internal::Deserialize<::network::mojom::ProxyRulesDataView>(
        pointer, output, message_);
  }
 private:
  internal::ProxyConfig_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // network::mojom

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_PROXY_CONFIG_MOJOM_DATA_VIEW_H_