// services/network/public/mojom/timing_allow_origin.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_TIMING_ALLOW_ORIGIN_MOJOM_DATA_VIEW_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_TIMING_ALLOW_ORIGIN_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "services/network/public/mojom/timing_allow_origin.mojom-shared-internal.h"


namespace network::mojom {
class TimingAllowOriginDataView;


}  // network::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::TimingAllowOriginDataView> {
  using Data = ::network::mojom::internal::TimingAllowOrigin_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {


class TimingAllowOriginDataView {
 public:
  using Tag = internal::TimingAllowOrigin_Data::TimingAllowOrigin_Tag;

  TimingAllowOriginDataView() = default;

  TimingAllowOriginDataView(
      internal::TimingAllowOrigin_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_serialized_origins() const { return data_->tag == Tag::kSerializedOrigins; }
  inline void GetSerializedOriginsDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSerializedOrigins(UserType* output) const {
    
    CHECK(is_serialized_origins());
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        data_->data.f_serialized_origins.Get(), output, message_);
  }
  bool is_all() const { return data_->tag == Tag::kAll; }
  uint8_t all() const {
    CHECK(is_all());
    return data_->data.f_all;
  }

 private:
  internal::TimingAllowOrigin_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // network::mojom

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_TIMING_ALLOW_ORIGIN_MOJOM_DATA_VIEW_H_