// services/network/public/mojom/transferable_directory.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/transferable_directory.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/transferable_directory.mojom-params-data.h"
#include "services/network/public/mojom/transferable_directory.mojom-shared-message-ids.h"

#include "services/network/public/mojom/transferable_directory.mojom-import-headers.h"
#include "services/network/public/mojom/transferable_directory.mojom-test-utils.h"


namespace network::mojom {
TransferableDirectoryPtr
TransferableDirectory::NewHandleForIpc(
    ::mojo::PlatformHandle value) {
  return TransferableDirectoryPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kHandleForIpc)>,
      std::move(value));
}

TransferableDirectoryPtr
TransferableDirectory::NewPath(
    const ::base::FilePath& value) {
  return TransferableDirectoryPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kPath)>,
      std::move(value));
}

TransferableDirectory::TransferableDirectory(
    std::in_place_index_t<static_cast<size_t>(Tag::kHandleForIpc)>,
    ::mojo::PlatformHandle value)
    : tag_(Tag::kHandleForIpc),
      data_(std::in_place_index<static_cast<size_t>(Tag::kHandleForIpc)>,
            std::move(value)) {}

TransferableDirectory::TransferableDirectory(
    std::in_place_index_t<static_cast<size_t>(Tag::kPath)>,
    const ::base::FilePath& value)
    : tag_(Tag::kPath),
      data_(std::in_place_index<static_cast<size_t>(Tag::kPath)>,
            std::move(value)) {}
TransferableDirectory::~TransferableDirectory() {
  DestroyActive();
}

void TransferableDirectory::set_handle_for_ipc(::mojo::PlatformHandle handle_for_ipc) {
  if (tag_ == Tag::kHandleForIpc) {
    data_.handle_for_ipc = std::move(handle_for_ipc);
  } else {
    DestroyActive();
    tag_ = Tag::kHandleForIpc;
    new (&data_.handle_for_ipc) ::mojo::PlatformHandle(
        std::move(handle_for_ipc));
  }
}

void TransferableDirectory::set_path(const ::base::FilePath& path) {
  if (tag_ == Tag::kPath) {
    data_.path = std::move(path);
  } else {
    DestroyActive();
    tag_ = Tag::kPath;
    new (&data_.path) ::base::FilePath(
        std::move(path));
  }
}


TransferableDirectory::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kHandleForIpc)>,
    ::mojo::PlatformHandle value)
    : handle_for_ipc(std::move(value)) {}

TransferableDirectory::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kPath)>,
    const ::base::FilePath& value)
    : path(std::move(value)) {}

void TransferableDirectory::DestroyActive() {
  switch (tag_) {

    case Tag::kHandleForIpc:
      std::destroy_at(&data_.handle_for_ipc);
      break;
    case Tag::kPath:
      std::destroy_at(&data_.path);
      break;
  }
}

bool TransferableDirectory::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}


}  // network::mojom


namespace mojo {

// static
bool UnionTraits<::network::mojom::TransferableDirectory::DataView, ::network::mojom::TransferableDirectoryPtr>::Read(
    ::network::mojom::TransferableDirectory::DataView input,
    ::network::mojom::TransferableDirectoryPtr* output) {
  using UnionType = ::network::mojom::TransferableDirectory;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kHandleForIpc: {
      *output = UnionType::NewHandleForIpc(
          input.TakeHandleForIpc());
      break;
    }
    case Tag::kPath: {
      ::base::FilePath result_path{};
      if (!input.ReadPath(&result_path))
        return false;

      *output = UnionType::NewPath(
          std::move(result_path));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace network::mojom {




}  // network::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif