// services/network/public/mojom/websocket.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_WEBSOCKET_MOJOM_BLINK_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_WEBSOCKET_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/websocket.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/websocket.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/websocket.mojom-blink-forward.h"  // IWYU pragma: export
#include "url/mojom/url.mojom-blink.h"
#include "services/network/public/mojom/network_param.mojom-blink.h"
#include "services/network/public/mojom/ip_endpoint.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace network::mojom::blink {

class WebSocketAuthenticationHandlerProxy;

template <typename ImplRefTraits>
class WebSocketAuthenticationHandlerStub;

class WebSocketAuthenticationHandlerRequestValidator;
class WebSocketAuthenticationHandlerResponseValidator;


class BLINK_PLATFORM_EXPORT WebSocketAuthenticationHandler
    : public WebSocketAuthenticationHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "network.mojom.WebSocketAuthenticationHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = WebSocketAuthenticationHandlerInterfaceBase;
  using Proxy_ = WebSocketAuthenticationHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = WebSocketAuthenticationHandlerStub<ImplRefTraits>;

  using RequestValidator_ = WebSocketAuthenticationHandlerRequestValidator;
  using ResponseValidator_ = WebSocketAuthenticationHandlerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kOnAuthRequiredMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnAuthRequired_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~WebSocketAuthenticationHandler() = default;

  using OnAuthRequiredCallback = base::OnceCallback<void(::network::mojom::blink::AuthCredentialsPtr)>;
  using OnAuthRequiredMojoCallback = base::OnceCallback<void(::network::mojom::blink::AuthCredentialsPtr)>;

  virtual void OnAuthRequired(const ::net::AuthChallengeInfo& info, ::network::mojom::blink::HttpResponseHeadersPtr headers, const ::net::IPEndPoint& remote_endpoint, OnAuthRequiredCallback callback) = 0;
};

class WebSocketHandshakeClientProxy;

template <typename ImplRefTraits>
class WebSocketHandshakeClientStub;

class WebSocketHandshakeClientRequestValidator;


class BLINK_PLATFORM_EXPORT WebSocketHandshakeClient
    : public WebSocketHandshakeClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "network.mojom.WebSocketHandshakeClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = WebSocketHandshakeClientInterfaceBase;
  using Proxy_ = WebSocketHandshakeClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = WebSocketHandshakeClientStub<ImplRefTraits>;

  using RequestValidator_ = WebSocketHandshakeClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnOpeningHandshakeStartedMinVersion = 0,
    kOnFailureMinVersion = 0,
    kOnConnectionEstablishedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnOpeningHandshakeStarted_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnFailure_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnConnectionEstablished_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~WebSocketHandshakeClient() = default;

  virtual void OnOpeningHandshakeStarted(WebSocketHandshakeRequestPtr request) = 0;

  virtual void OnFailure(const ::blink::String& message, int32_t net_error, int32_t response_code) = 0;

  virtual void OnConnectionEstablished(::mojo::PendingRemote<WebSocket> socket, ::mojo::PendingReceiver<WebSocketClient> client_receiver, WebSocketHandshakeResponsePtr response, ::mojo::ScopedDataPipeConsumerHandle readable, ::mojo::ScopedDataPipeProducerHandle writable) = 0;
};

class WebSocketClientProxy;

template <typename ImplRefTraits>
class WebSocketClientStub;

class WebSocketClientRequestValidator;


class BLINK_PLATFORM_EXPORT WebSocketClient
    : public WebSocketClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "network.mojom.WebSocketClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = WebSocketClientInterfaceBase;
  using Proxy_ = WebSocketClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = WebSocketClientStub<ImplRefTraits>;

  using RequestValidator_ = WebSocketClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnDataFrameMinVersion = 0,
    kOnDropChannelMinVersion = 0,
    kOnClosingHandshakeMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnDataFrame_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnDropChannel_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnClosingHandshake_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~WebSocketClient() = default;

  virtual void OnDataFrame(bool fin, WebSocketMessageType type, uint64_t data_length) = 0;

  virtual void OnDropChannel(bool was_clean, uint16_t code, const ::blink::String& reason) = 0;

  virtual void OnClosingHandshake() = 0;
};

class WebSocketProxy;

template <typename ImplRefTraits>
class WebSocketStub;

class WebSocketRequestValidator;


class BLINK_PLATFORM_EXPORT WebSocket
    : public WebSocketInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "network.mojom.WebSocket";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = WebSocketInterfaceBase;
  using Proxy_ = WebSocketProxy;

  template <typename ImplRefTraits>
  using Stub_ = WebSocketStub<ImplRefTraits>;

  using RequestValidator_ = WebSocketRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSendMessageMinVersion = 0,
    kStartReceivingMinVersion = 0,
    kStartClosingHandshakeMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SendMessage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct StartReceiving_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct StartClosingHandshake_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~WebSocket() = default;

  virtual void SendMessage(WebSocketMessageType type, uint64_t data_length) = 0;

  virtual void StartReceiving() = 0;

  virtual void StartClosingHandshake(uint16_t code, const ::blink::String& reason) = 0;
};



class BLINK_PLATFORM_EXPORT WebSocketAuthenticationHandlerProxy
    : public WebSocketAuthenticationHandler {
 public:
  using InterfaceType = WebSocketAuthenticationHandler;

  explicit WebSocketAuthenticationHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnAuthRequired(const ::net::AuthChallengeInfo& info, ::network::mojom::blink::HttpResponseHeadersPtr headers, const ::net::IPEndPoint& remote_endpoint, OnAuthRequiredCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_PLATFORM_EXPORT WebSocketHandshakeClientProxy
    : public WebSocketHandshakeClient {
 public:
  using InterfaceType = WebSocketHandshakeClient;

  explicit WebSocketHandshakeClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnOpeningHandshakeStarted(WebSocketHandshakeRequestPtr request) final;
  
  void OnFailure(const ::blink::String& message, int32_t net_error, int32_t response_code) final;
  
  void OnConnectionEstablished(::mojo::PendingRemote<WebSocket> socket, ::mojo::PendingReceiver<WebSocketClient> client_receiver, WebSocketHandshakeResponsePtr response, ::mojo::ScopedDataPipeConsumerHandle readable, ::mojo::ScopedDataPipeProducerHandle writable) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_PLATFORM_EXPORT WebSocketClientProxy
    : public WebSocketClient {
 public:
  using InterfaceType = WebSocketClient;

  explicit WebSocketClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnDataFrame(bool fin, WebSocketMessageType type, uint64_t data_length) final;
  
  void OnDropChannel(bool was_clean, uint16_t code, const ::blink::String& reason) final;
  
  void OnClosingHandshake() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_PLATFORM_EXPORT WebSocketProxy
    : public WebSocket {
 public:
  using InterfaceType = WebSocket;

  explicit WebSocketProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SendMessage(WebSocketMessageType type, uint64_t data_length) final;
  
  void StartReceiving() final;
  
  void StartClosingHandshake(uint16_t code, const ::blink::String& reason) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_PLATFORM_EXPORT WebSocketAuthenticationHandlerStubDispatch {
 public:
  static bool Accept(WebSocketAuthenticationHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      WebSocketAuthenticationHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<WebSocketAuthenticationHandler>>
class WebSocketAuthenticationHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WebSocketAuthenticationHandlerStub() = default;
  ~WebSocketAuthenticationHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebSocketAuthenticationHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebSocketAuthenticationHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT WebSocketHandshakeClientStubDispatch {
 public:
  static bool Accept(WebSocketHandshakeClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      WebSocketHandshakeClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<WebSocketHandshakeClient>>
class WebSocketHandshakeClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WebSocketHandshakeClientStub() = default;
  ~WebSocketHandshakeClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebSocketHandshakeClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebSocketHandshakeClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT WebSocketClientStubDispatch {
 public:
  static bool Accept(WebSocketClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      WebSocketClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<WebSocketClient>>
class WebSocketClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WebSocketClientStub() = default;
  ~WebSocketClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebSocketClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebSocketClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT WebSocketStubDispatch {
 public:
  static bool Accept(WebSocket* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      WebSocket* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<WebSocket>>
class WebSocketStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WebSocketStub() = default;
  ~WebSocketStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebSocketStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebSocketStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT WebSocketAuthenticationHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT WebSocketHandshakeClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT WebSocketClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT WebSocketRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT WebSocketAuthenticationHandlerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class BLINK_PLATFORM_EXPORT HttpHeader {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<HttpHeader, T>::value>;
  using DataView = HttpHeaderDataView;
  using Data_ = internal::HttpHeader_Data;

  template <typename... Args>
  static HttpHeaderPtr New(Args&&... args) {
    return HttpHeaderPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static HttpHeaderPtr From(const U& u) {
    return mojo::TypeConverter<HttpHeaderPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, HttpHeader>::Convert(*this);
  }


  HttpHeader();

  HttpHeader(
      const ::blink::String& name,
      const ::blink::String& value);


  ~HttpHeader();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = HttpHeaderPtr>
  HttpHeaderPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, HttpHeader::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, HttpHeader::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, HttpHeader::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HttpHeader::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HttpHeader::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        HttpHeader::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::HttpHeader_UnserializedMessageContext<
            UserType, HttpHeader::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<HttpHeader::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return HttpHeader::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::HttpHeader_UnserializedMessageContext<
            UserType, HttpHeader::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<HttpHeader::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::String name;
  
  ::blink::String value;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, HttpHeader::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, HttpHeader::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, HttpHeader::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, HttpHeader::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}










class BLINK_PLATFORM_EXPORT WebSocketHandshakeRequest {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebSocketHandshakeRequest, T>::value>;
  using DataView = WebSocketHandshakeRequestDataView;
  using Data_ = internal::WebSocketHandshakeRequest_Data;

  template <typename... Args>
  static WebSocketHandshakeRequestPtr New(Args&&... args) {
    return WebSocketHandshakeRequestPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebSocketHandshakeRequestPtr From(const U& u) {
    return mojo::TypeConverter<WebSocketHandshakeRequestPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebSocketHandshakeRequest>::Convert(*this);
  }


  WebSocketHandshakeRequest();

  WebSocketHandshakeRequest(
      const ::blink::KURL& url,
      ::blink::Vector<HttpHeaderPtr> headers,
      const ::blink::String& headers_text);

WebSocketHandshakeRequest(const WebSocketHandshakeRequest&) = delete;
WebSocketHandshakeRequest& operator=(const WebSocketHandshakeRequest&) = delete;

  ~WebSocketHandshakeRequest();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebSocketHandshakeRequestPtr>
  WebSocketHandshakeRequestPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebSocketHandshakeRequest::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WebSocketHandshakeRequest::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WebSocketHandshakeRequest::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebSocketHandshakeRequest::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebSocketHandshakeRequest::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebSocketHandshakeRequest::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebSocketHandshakeRequest_UnserializedMessageContext<
            UserType, WebSocketHandshakeRequest::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WebSocketHandshakeRequest::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WebSocketHandshakeRequest::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebSocketHandshakeRequest_UnserializedMessageContext<
            UserType, WebSocketHandshakeRequest::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebSocketHandshakeRequest::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::KURL url;
  
  ::blink::Vector<HttpHeaderPtr> headers;
  
  ::blink::String headers_text;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebSocketHandshakeRequest::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebSocketHandshakeRequest::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebSocketHandshakeRequest::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebSocketHandshakeRequest::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT WebSocketHandshakeResponse {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebSocketHandshakeResponse, T>::value>;
  using DataView = WebSocketHandshakeResponseDataView;
  using Data_ = internal::WebSocketHandshakeResponse_Data;

  template <typename... Args>
  static WebSocketHandshakeResponsePtr New(Args&&... args) {
    return WebSocketHandshakeResponsePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebSocketHandshakeResponsePtr From(const U& u) {
    return mojo::TypeConverter<WebSocketHandshakeResponsePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebSocketHandshakeResponse>::Convert(*this);
  }


  WebSocketHandshakeResponse();

  WebSocketHandshakeResponse(
      const ::blink::KURL& url,
      ::network::mojom::blink::HttpVersionPtr http_version,
      int32_t status_code,
      const ::blink::String& status_text,
      const ::net::IPEndPoint& remote_endpoint,
      ::blink::Vector<HttpHeaderPtr> headers,
      const ::blink::String& headers_text,
      const ::blink::String& selected_protocol,
      const ::blink::String& extensions);

WebSocketHandshakeResponse(const WebSocketHandshakeResponse&) = delete;
WebSocketHandshakeResponse& operator=(const WebSocketHandshakeResponse&) = delete;

  ~WebSocketHandshakeResponse();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebSocketHandshakeResponsePtr>
  WebSocketHandshakeResponsePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebSocketHandshakeResponse::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WebSocketHandshakeResponse::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WebSocketHandshakeResponse::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebSocketHandshakeResponse::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebSocketHandshakeResponse::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebSocketHandshakeResponse::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebSocketHandshakeResponse_UnserializedMessageContext<
            UserType, WebSocketHandshakeResponse::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WebSocketHandshakeResponse::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WebSocketHandshakeResponse::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebSocketHandshakeResponse_UnserializedMessageContext<
            UserType, WebSocketHandshakeResponse::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebSocketHandshakeResponse::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::KURL url;
  
  ::network::mojom::blink::HttpVersionPtr http_version;
  
  int32_t status_code;
  
  ::blink::String status_text;
  
  ::net::IPEndPoint remote_endpoint;
  
  ::blink::Vector<HttpHeaderPtr> headers;
  
  ::blink::String headers_text;
  
  ::blink::String selected_protocol;
  
  ::blink::String extensions;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebSocketHandshakeResponse::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebSocketHandshakeResponse::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebSocketHandshakeResponse::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebSocketHandshakeResponse::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
HttpHeaderPtr HttpHeader::Clone() const {
  return New(
      mojo::Clone(name),
      mojo::Clone(value)
  );
}

template <typename T, HttpHeader::EnableIfSame<T>*>
bool HttpHeader::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  return true;
}

template <typename T, HttpHeader::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  return false;
}
template <typename StructPtrType>
WebSocketHandshakeRequestPtr WebSocketHandshakeRequest::Clone() const {
  return New(
      mojo::Clone(url),
      mojo::Clone(headers),
      mojo::Clone(headers_text)
  );
}

template <typename T, WebSocketHandshakeRequest::EnableIfSame<T>*>
bool WebSocketHandshakeRequest::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->headers, other_struct.headers))
    return false;
  if (!mojo::Equals(this->headers_text, other_struct.headers_text))
    return false;
  return true;
}

template <typename T, WebSocketHandshakeRequest::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.headers < rhs.headers)
    return true;
  if (rhs.headers < lhs.headers)
    return false;
  if (lhs.headers_text < rhs.headers_text)
    return true;
  if (rhs.headers_text < lhs.headers_text)
    return false;
  return false;
}
template <typename StructPtrType>
WebSocketHandshakeResponsePtr WebSocketHandshakeResponse::Clone() const {
  return New(
      mojo::Clone(url),
      mojo::Clone(http_version),
      mojo::Clone(status_code),
      mojo::Clone(status_text),
      mojo::Clone(remote_endpoint),
      mojo::Clone(headers),
      mojo::Clone(headers_text),
      mojo::Clone(selected_protocol),
      mojo::Clone(extensions)
  );
}

template <typename T, WebSocketHandshakeResponse::EnableIfSame<T>*>
bool WebSocketHandshakeResponse::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->http_version, other_struct.http_version))
    return false;
  if (!mojo::Equals(this->status_code, other_struct.status_code))
    return false;
  if (!mojo::Equals(this->status_text, other_struct.status_text))
    return false;
  if (!mojo::Equals(this->remote_endpoint, other_struct.remote_endpoint))
    return false;
  if (!mojo::Equals(this->headers, other_struct.headers))
    return false;
  if (!mojo::Equals(this->headers_text, other_struct.headers_text))
    return false;
  if (!mojo::Equals(this->selected_protocol, other_struct.selected_protocol))
    return false;
  if (!mojo::Equals(this->extensions, other_struct.extensions))
    return false;
  return true;
}

template <typename T, WebSocketHandshakeResponse::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.http_version < rhs.http_version)
    return true;
  if (rhs.http_version < lhs.http_version)
    return false;
  if (lhs.status_code < rhs.status_code)
    return true;
  if (rhs.status_code < lhs.status_code)
    return false;
  if (lhs.status_text < rhs.status_text)
    return true;
  if (rhs.status_text < lhs.status_text)
    return false;
  if (lhs.remote_endpoint < rhs.remote_endpoint)
    return true;
  if (rhs.remote_endpoint < lhs.remote_endpoint)
    return false;
  if (lhs.headers < rhs.headers)
    return true;
  if (rhs.headers < lhs.headers)
    return false;
  if (lhs.headers_text < rhs.headers_text)
    return true;
  if (rhs.headers_text < lhs.headers_text)
    return false;
  if (lhs.selected_protocol < rhs.selected_protocol)
    return true;
  if (rhs.selected_protocol < lhs.selected_protocol)
    return false;
  if (lhs.extensions < rhs.extensions)
    return true;
  if (rhs.extensions < lhs.extensions)
    return false;
  return false;
}


}  // network::mojom::blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::HttpHeader::DataView,
                                         ::network::mojom::blink::HttpHeaderPtr> {
  static bool IsNull(const ::network::mojom::blink::HttpHeaderPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::HttpHeaderPtr* output) { output->reset(); }

  static const decltype(::network::mojom::blink::HttpHeader::name)& name(
      const ::network::mojom::blink::HttpHeaderPtr& input) {
    return input->name;
  }

  static const decltype(::network::mojom::blink::HttpHeader::value)& value(
      const ::network::mojom::blink::HttpHeaderPtr& input) {
    return input->value;
  }

  static bool Read(::network::mojom::blink::HttpHeader::DataView input, ::network::mojom::blink::HttpHeaderPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::WebSocketHandshakeRequest::DataView,
                                         ::network::mojom::blink::WebSocketHandshakeRequestPtr> {
  static bool IsNull(const ::network::mojom::blink::WebSocketHandshakeRequestPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::WebSocketHandshakeRequestPtr* output) { output->reset(); }

  static const decltype(::network::mojom::blink::WebSocketHandshakeRequest::url)& url(
      const ::network::mojom::blink::WebSocketHandshakeRequestPtr& input) {
    return input->url;
  }

  static const decltype(::network::mojom::blink::WebSocketHandshakeRequest::headers)& headers(
      const ::network::mojom::blink::WebSocketHandshakeRequestPtr& input) {
    return input->headers;
  }

  static const decltype(::network::mojom::blink::WebSocketHandshakeRequest::headers_text)& headers_text(
      const ::network::mojom::blink::WebSocketHandshakeRequestPtr& input) {
    return input->headers_text;
  }

  static bool Read(::network::mojom::blink::WebSocketHandshakeRequest::DataView input, ::network::mojom::blink::WebSocketHandshakeRequestPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::WebSocketHandshakeResponse::DataView,
                                         ::network::mojom::blink::WebSocketHandshakeResponsePtr> {
  static bool IsNull(const ::network::mojom::blink::WebSocketHandshakeResponsePtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::WebSocketHandshakeResponsePtr* output) { output->reset(); }

  static const decltype(::network::mojom::blink::WebSocketHandshakeResponse::url)& url(
      const ::network::mojom::blink::WebSocketHandshakeResponsePtr& input) {
    return input->url;
  }

  static const decltype(::network::mojom::blink::WebSocketHandshakeResponse::http_version)& http_version(
      const ::network::mojom::blink::WebSocketHandshakeResponsePtr& input) {
    return input->http_version;
  }

  static decltype(::network::mojom::blink::WebSocketHandshakeResponse::status_code) status_code(
      const ::network::mojom::blink::WebSocketHandshakeResponsePtr& input) {
    return input->status_code;
  }

  static const decltype(::network::mojom::blink::WebSocketHandshakeResponse::status_text)& status_text(
      const ::network::mojom::blink::WebSocketHandshakeResponsePtr& input) {
    return input->status_text;
  }

  static const decltype(::network::mojom::blink::WebSocketHandshakeResponse::remote_endpoint)& remote_endpoint(
      const ::network::mojom::blink::WebSocketHandshakeResponsePtr& input) {
    return input->remote_endpoint;
  }

  static const decltype(::network::mojom::blink::WebSocketHandshakeResponse::headers)& headers(
      const ::network::mojom::blink::WebSocketHandshakeResponsePtr& input) {
    return input->headers;
  }

  static const decltype(::network::mojom::blink::WebSocketHandshakeResponse::headers_text)& headers_text(
      const ::network::mojom::blink::WebSocketHandshakeResponsePtr& input) {
    return input->headers_text;
  }

  static const decltype(::network::mojom::blink::WebSocketHandshakeResponse::selected_protocol)& selected_protocol(
      const ::network::mojom::blink::WebSocketHandshakeResponsePtr& input) {
    return input->selected_protocol;
  }

  static const decltype(::network::mojom::blink::WebSocketHandshakeResponse::extensions)& extensions(
      const ::network::mojom::blink::WebSocketHandshakeResponsePtr& input) {
    return input->extensions;
  }

  static bool Read(::network::mojom::blink::WebSocketHandshakeResponse::DataView input, ::network::mojom::blink::WebSocketHandshakeResponsePtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_WEBSOCKET_MOJOM_BLINK_H_