// services/resource_coordinator/public/mojom/memory_instrumentation/memory_instrumentation.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/resource_coordinator/public/mojom/memory_instrumentation/memory_instrumentation.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/resource_coordinator/public/mojom/memory_instrumentation/memory_instrumentation.mojom-params-data.h"
#include "services/resource_coordinator/public/mojom/memory_instrumentation/memory_instrumentation.mojom-shared-message-ids.h"

#include "services/resource_coordinator/public/mojom/memory_instrumentation/memory_instrumentation.mojom-import-headers.h"
#include "services/resource_coordinator/public/mojom/memory_instrumentation/memory_instrumentation.mojom-test-utils.h"


namespace memory_instrumentation::mojom {
constexpr uint32_t VmRegion::kProtectionFlagsRead;
constexpr uint32_t VmRegion::kProtectionFlagsWrite;
constexpr uint32_t VmRegion::kProtectionFlagsExec;
constexpr uint32_t VmRegion::kProtectionFlagsMayshare;
RequestArgs::RequestArgs()
    : dump_guid(),
      dump_type(),
      level_of_detail(),
      determinism() {}

RequestArgs::RequestArgs(
    uint64_t dump_guid_in,
    ::base::trace_event::MemoryDumpType dump_type_in,
    ::base::trace_event::MemoryDumpLevelOfDetail level_of_detail_in,
    ::base::trace_event::MemoryDumpDeterminism determinism_in)
    : dump_guid(std::move(dump_guid_in)),
      dump_type(std::move(dump_type_in)),
      level_of_detail(std::move(level_of_detail_in)),
      determinism(std::move(determinism_in)) {}

RequestArgs::~RequestArgs() = default;

void RequestArgs::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "dump_guid"), this->dump_guid,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "dump_type"), this->dump_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::trace_event::MemoryDumpType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "level_of_detail"), this->level_of_detail,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::trace_event::MemoryDumpLevelOfDetail>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "determinism"), this->determinism,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::trace_event::MemoryDumpDeterminism>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool RequestArgs::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
RawAllocatorDumpEdge::RawAllocatorDumpEdge()
    : source_id(),
      target_id(),
      importance(),
      overridable() {}

RawAllocatorDumpEdge::RawAllocatorDumpEdge(
    uint64_t source_id_in,
    uint64_t target_id_in,
    int32_t importance_in,
    bool overridable_in)
    : source_id(std::move(source_id_in)),
      target_id(std::move(target_id_in)),
      importance(std::move(importance_in)),
      overridable(std::move(overridable_in)) {}

RawAllocatorDumpEdge::~RawAllocatorDumpEdge() = default;

void RawAllocatorDumpEdge::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "source_id"), this->source_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "target_id"), this->target_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "importance"), this->importance,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "overridable"), this->overridable,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool RawAllocatorDumpEdge::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
RawAllocatorDumpEntry::RawAllocatorDumpEntry()
    : name(),
      units(),
      value() {}

RawAllocatorDumpEntry::RawAllocatorDumpEntry(
    const std::string& name_in,
    const std::string& units_in,
    RawAllocatorDumpEntryValuePtr value_in)
    : name(std::move(name_in)),
      units(std::move(units_in)),
      value(std::move(value_in)) {}

RawAllocatorDumpEntry::~RawAllocatorDumpEntry() = default;

void RawAllocatorDumpEntry::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "units"), this->units,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type RawAllocatorDumpEntryValuePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool RawAllocatorDumpEntry::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
RawAllocatorDump::RawAllocatorDump()
    : id(),
      absolute_name(),
      weak(),
      level_of_detail(),
      entries() {}

RawAllocatorDump::RawAllocatorDump(
    uint64_t id_in,
    const std::string& absolute_name_in,
    bool weak_in,
    ::base::trace_event::MemoryDumpLevelOfDetail level_of_detail_in,
    std::vector<::base::trace_event::MemoryAllocatorDump::Entry> entries_in)
    : id(std::move(id_in)),
      absolute_name(std::move(absolute_name_in)),
      weak(std::move(weak_in)),
      level_of_detail(std::move(level_of_detail_in)),
      entries(std::move(entries_in)) {}

RawAllocatorDump::~RawAllocatorDump() = default;

void RawAllocatorDump::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "absolute_name"), this->absolute_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "weak"), this->weak,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "level_of_detail"), this->level_of_detail,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::trace_event::MemoryDumpLevelOfDetail>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "entries"), this->entries,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<::base::trace_event::MemoryAllocatorDump::Entry>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool RawAllocatorDump::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
RawProcessMemoryDump::RawProcessMemoryDump()
    : level_of_detail(),
      allocator_dump_edges(),
      allocator_dumps() {}

RawProcessMemoryDump::RawProcessMemoryDump(
    ::base::trace_event::MemoryDumpLevelOfDetail level_of_detail_in,
    std::vector<::base::trace_event::ProcessMemoryDump::MemoryAllocatorDumpEdge> allocator_dump_edges_in,
    std::vector<::std::unique_ptr<::base::trace_event::MemoryAllocatorDump>> allocator_dumps_in)
    : level_of_detail(std::move(level_of_detail_in)),
      allocator_dump_edges(std::move(allocator_dump_edges_in)),
      allocator_dumps(std::move(allocator_dumps_in)) {}

RawProcessMemoryDump::~RawProcessMemoryDump() = default;

void RawProcessMemoryDump::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "level_of_detail"), this->level_of_detail,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::trace_event::MemoryDumpLevelOfDetail>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allocator_dump_edges"), this->allocator_dump_edges,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::base::trace_event::ProcessMemoryDump::MemoryAllocatorDumpEdge>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allocator_dumps"), this->allocator_dumps,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<::std::unique_ptr<::base::trace_event::MemoryAllocatorDump>>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool RawProcessMemoryDump::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VmRegion::VmRegion()
    : start_address(),
      size_in_bytes(),
      module_timestamp(),
      module_debugid(),
      module_debug_path(),
      protection_flags(),
      mapped_file(),
      byte_stats_private_dirty_resident(),
      byte_stats_private_clean_resident(),
      byte_stats_shared_dirty_resident(),
      byte_stats_shared_clean_resident(),
      byte_stats_swapped(),
      byte_locked(),
      byte_stats_proportional_resident() {}

VmRegion::VmRegion(
    uint64_t start_address_in,
    uint64_t size_in_bytes_in,
    uint64_t module_timestamp_in,
    const std::string& module_debugid_in,
    const std::string& module_debug_path_in,
    uint32_t protection_flags_in,
    const std::string& mapped_file_in,
    uint64_t byte_stats_private_dirty_resident_in,
    uint64_t byte_stats_private_clean_resident_in,
    uint64_t byte_stats_shared_dirty_resident_in,
    uint64_t byte_stats_shared_clean_resident_in,
    uint64_t byte_stats_swapped_in,
    uint64_t byte_locked_in,
    uint64_t byte_stats_proportional_resident_in)
    : start_address(std::move(start_address_in)),
      size_in_bytes(std::move(size_in_bytes_in)),
      module_timestamp(std::move(module_timestamp_in)),
      module_debugid(std::move(module_debugid_in)),
      module_debug_path(std::move(module_debug_path_in)),
      protection_flags(std::move(protection_flags_in)),
      mapped_file(std::move(mapped_file_in)),
      byte_stats_private_dirty_resident(std::move(byte_stats_private_dirty_resident_in)),
      byte_stats_private_clean_resident(std::move(byte_stats_private_clean_resident_in)),
      byte_stats_shared_dirty_resident(std::move(byte_stats_shared_dirty_resident_in)),
      byte_stats_shared_clean_resident(std::move(byte_stats_shared_clean_resident_in)),
      byte_stats_swapped(std::move(byte_stats_swapped_in)),
      byte_locked(std::move(byte_locked_in)),
      byte_stats_proportional_resident(std::move(byte_stats_proportional_resident_in)) {}

VmRegion::~VmRegion() = default;
size_t VmRegion::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->start_address);
  seed = mojo::internal::Hash(seed, this->size_in_bytes);
  seed = mojo::internal::Hash(seed, this->module_timestamp);
  seed = mojo::internal::Hash(seed, this->module_debugid);
  seed = mojo::internal::Hash(seed, this->module_debug_path);
  seed = mojo::internal::Hash(seed, this->protection_flags);
  seed = mojo::internal::Hash(seed, this->mapped_file);
  seed = mojo::internal::Hash(seed, this->byte_stats_private_dirty_resident);
  seed = mojo::internal::Hash(seed, this->byte_stats_private_clean_resident);
  seed = mojo::internal::Hash(seed, this->byte_stats_shared_dirty_resident);
  seed = mojo::internal::Hash(seed, this->byte_stats_shared_clean_resident);
  seed = mojo::internal::Hash(seed, this->byte_stats_swapped);
  seed = mojo::internal::Hash(seed, this->byte_locked);
  seed = mojo::internal::Hash(seed, this->byte_stats_proportional_resident);
  return seed;
}

void VmRegion::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "start_address"), this->start_address,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "size_in_bytes"), this->size_in_bytes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "module_timestamp"), this->module_timestamp,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "module_debugid"), this->module_debugid,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "module_debug_path"), this->module_debug_path,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "protection_flags"), this->protection_flags,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mapped_file"), this->mapped_file,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "byte_stats_private_dirty_resident"), this->byte_stats_private_dirty_resident,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "byte_stats_private_clean_resident"), this->byte_stats_private_clean_resident,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "byte_stats_shared_dirty_resident"), this->byte_stats_shared_dirty_resident,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "byte_stats_shared_clean_resident"), this->byte_stats_shared_clean_resident,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "byte_stats_swapped"), this->byte_stats_swapped,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "byte_locked"), this->byte_locked,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "byte_stats_proportional_resident"), this->byte_stats_proportional_resident,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool VmRegion::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PlatformPrivateFootprint::PlatformPrivateFootprint()
    : phys_footprint_bytes(0ULL),
      internal_bytes(0ULL),
      compressed_bytes(0ULL),
      rss_anon_bytes(0ULL),
      vm_swap_bytes(0ULL),
      private_bytes(0ULL) {}

PlatformPrivateFootprint::PlatformPrivateFootprint(
    uint64_t phys_footprint_bytes_in,
    uint64_t internal_bytes_in,
    uint64_t compressed_bytes_in,
    uint64_t rss_anon_bytes_in,
    uint64_t vm_swap_bytes_in,
    uint64_t private_bytes_in)
    : phys_footprint_bytes(std::move(phys_footprint_bytes_in)),
      internal_bytes(std::move(internal_bytes_in)),
      compressed_bytes(std::move(compressed_bytes_in)),
      rss_anon_bytes(std::move(rss_anon_bytes_in)),
      vm_swap_bytes(std::move(vm_swap_bytes_in)),
      private_bytes(std::move(private_bytes_in)) {}

PlatformPrivateFootprint::~PlatformPrivateFootprint() = default;
size_t PlatformPrivateFootprint::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->phys_footprint_bytes);
  seed = mojo::internal::Hash(seed, this->internal_bytes);
  seed = mojo::internal::Hash(seed, this->compressed_bytes);
  seed = mojo::internal::Hash(seed, this->rss_anon_bytes);
  seed = mojo::internal::Hash(seed, this->vm_swap_bytes);
  seed = mojo::internal::Hash(seed, this->private_bytes);
  return seed;
}

void PlatformPrivateFootprint::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "phys_footprint_bytes"), this->phys_footprint_bytes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "internal_bytes"), this->internal_bytes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "compressed_bytes"), this->compressed_bytes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "rss_anon_bytes"), this->rss_anon_bytes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "vm_swap_bytes"), this->vm_swap_bytes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "private_bytes"), this->private_bytes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PlatformPrivateFootprint::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
RawOSMemDump::RawOSMemDump()
    : resident_set_kb(0U),
      peak_resident_set_kb(0U),
      is_peak_rss_resettable(false),
      platform_private_footprint(),
      memory_maps(),
      native_library_pages_bitmap(),
      mappings_count(0U),
      pss_kb(0U),
      swap_pss_kb(0U) {}

RawOSMemDump::RawOSMemDump(
    uint32_t resident_set_kb_in,
    uint32_t peak_resident_set_kb_in,
    bool is_peak_rss_resettable_in,
    PlatformPrivateFootprintPtr platform_private_footprint_in,
    std::vector<VmRegionPtr> memory_maps_in,
    std::vector<uint8_t> native_library_pages_bitmap_in,
    uint32_t mappings_count_in,
    uint32_t pss_kb_in,
    uint32_t swap_pss_kb_in)
    : resident_set_kb(std::move(resident_set_kb_in)),
      peak_resident_set_kb(std::move(peak_resident_set_kb_in)),
      is_peak_rss_resettable(std::move(is_peak_rss_resettable_in)),
      platform_private_footprint(std::move(platform_private_footprint_in)),
      memory_maps(std::move(memory_maps_in)),
      native_library_pages_bitmap(std::move(native_library_pages_bitmap_in)),
      mappings_count(std::move(mappings_count_in)),
      pss_kb(std::move(pss_kb_in)),
      swap_pss_kb(std::move(swap_pss_kb_in)) {}

RawOSMemDump::~RawOSMemDump() = default;

void RawOSMemDump::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "resident_set_kb"), this->resident_set_kb,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "peak_resident_set_kb"), this->peak_resident_set_kb,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_peak_rss_resettable"), this->is_peak_rss_resettable,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "platform_private_footprint"), this->platform_private_footprint,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type PlatformPrivateFootprintPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "memory_maps"), this->memory_maps,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<VmRegionPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "native_library_pages_bitmap"), this->native_library_pages_bitmap,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mappings_count"), this->mappings_count,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pss_kb"), this->pss_kb,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "swap_pss_kb"), this->swap_pss_kb,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool RawOSMemDump::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
OSMemDump::OSMemDump()
    : resident_set_kb(0U),
      peak_resident_set_kb(0U),
      is_peak_rss_resettable(false),
      private_footprint_kb(0U),
      shared_footprint_kb(0U),
      private_footprint_swap_kb(0U),
      mappings_count(0U),
      pss_kb(0U),
      swap_pss_kb(0U) {}

OSMemDump::OSMemDump(
    uint32_t resident_set_kb_in,
    uint32_t peak_resident_set_kb_in,
    bool is_peak_rss_resettable_in,
    uint32_t private_footprint_kb_in,
    uint32_t shared_footprint_kb_in,
    uint32_t private_footprint_swap_kb_in,
    uint32_t mappings_count_in,
    uint32_t pss_kb_in,
    uint32_t swap_pss_kb_in)
    : resident_set_kb(std::move(resident_set_kb_in)),
      peak_resident_set_kb(std::move(peak_resident_set_kb_in)),
      is_peak_rss_resettable(std::move(is_peak_rss_resettable_in)),
      private_footprint_kb(std::move(private_footprint_kb_in)),
      shared_footprint_kb(std::move(shared_footprint_kb_in)),
      private_footprint_swap_kb(std::move(private_footprint_swap_kb_in)),
      mappings_count(std::move(mappings_count_in)),
      pss_kb(std::move(pss_kb_in)),
      swap_pss_kb(std::move(swap_pss_kb_in)) {}

OSMemDump::~OSMemDump() = default;
size_t OSMemDump::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->resident_set_kb);
  seed = mojo::internal::Hash(seed, this->peak_resident_set_kb);
  seed = mojo::internal::Hash(seed, this->is_peak_rss_resettable);
  seed = mojo::internal::Hash(seed, this->private_footprint_kb);
  seed = mojo::internal::Hash(seed, this->shared_footprint_kb);
  seed = mojo::internal::Hash(seed, this->private_footprint_swap_kb);
  seed = mojo::internal::Hash(seed, this->mappings_count);
  seed = mojo::internal::Hash(seed, this->pss_kb);
  seed = mojo::internal::Hash(seed, this->swap_pss_kb);
  return seed;
}

void OSMemDump::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "resident_set_kb"), this->resident_set_kb,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "peak_resident_set_kb"), this->peak_resident_set_kb,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_peak_rss_resettable"), this->is_peak_rss_resettable,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "private_footprint_kb"), this->private_footprint_kb,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "shared_footprint_kb"), this->shared_footprint_kb,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "private_footprint_swap_kb"), this->private_footprint_swap_kb,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mappings_count"), this->mappings_count,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pss_kb"), this->pss_kb,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "swap_pss_kb"), this->swap_pss_kb,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool OSMemDump::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AllocatorMemDump::AllocatorMemDump()
    : numeric_entries(),
      children() {}

AllocatorMemDump::AllocatorMemDump(
    const base::flat_map<std::string, uint64_t>& numeric_entries_in,
    base::flat_map<std::string, AllocatorMemDumpPtr> children_in)
    : numeric_entries(std::move(numeric_entries_in)),
      children(std::move(children_in)) {}

AllocatorMemDump::~AllocatorMemDump() = default;

void AllocatorMemDump::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "numeric_entries"), this->numeric_entries,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const base::flat_map<std::string, uint64_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "children"), this->children,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type base::flat_map<std::string, AllocatorMemDumpPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AllocatorMemDump::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ProcessMemoryDump::ProcessMemoryDump()
    : process_type(),
      os_dump(),
      chrome_allocator_dumps(),
      pid(),
      service_name() {}

ProcessMemoryDump::ProcessMemoryDump(
    ProcessType process_type_in,
    OSMemDumpPtr os_dump_in,
    base::flat_map<std::string, AllocatorMemDumpPtr> chrome_allocator_dumps_in,
    ::base::ProcessId pid_in,
    const std::optional<std::string>& service_name_in)
    : process_type(std::move(process_type_in)),
      os_dump(std::move(os_dump_in)),
      chrome_allocator_dumps(std::move(chrome_allocator_dumps_in)),
      pid(std::move(pid_in)),
      service_name(std::move(service_name_in)) {}

ProcessMemoryDump::~ProcessMemoryDump() = default;

void ProcessMemoryDump::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "process_type"), this->process_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ProcessType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "os_dump"), this->os_dump,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type OSMemDumpPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "chrome_allocator_dumps"), this->chrome_allocator_dumps,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type base::flat_map<std::string, AllocatorMemDumpPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pid"), this->pid,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::ProcessId>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "service_name"), this->service_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ProcessMemoryDump::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AggregatedMetrics::AggregatedMetrics()
    : native_library_resident_kb(0),
      native_library_resident_not_ordered_kb(0),
      native_library_not_resident_ordered_kb(0) {}

AggregatedMetrics::AggregatedMetrics(
    int32_t native_library_resident_kb_in,
    int32_t native_library_resident_not_ordered_kb_in,
    int32_t native_library_not_resident_ordered_kb_in)
    : native_library_resident_kb(std::move(native_library_resident_kb_in)),
      native_library_resident_not_ordered_kb(std::move(native_library_resident_not_ordered_kb_in)),
      native_library_not_resident_ordered_kb(std::move(native_library_not_resident_ordered_kb_in)) {}

AggregatedMetrics::~AggregatedMetrics() = default;
size_t AggregatedMetrics::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->native_library_resident_kb);
  seed = mojo::internal::Hash(seed, this->native_library_resident_not_ordered_kb);
  seed = mojo::internal::Hash(seed, this->native_library_not_resident_ordered_kb);
  return seed;
}

void AggregatedMetrics::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "native_library_resident_kb"), this->native_library_resident_kb,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "native_library_resident_not_ordered_kb"), this->native_library_resident_not_ordered_kb,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "native_library_not_resident_ordered_kb"), this->native_library_not_resident_ordered_kb,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AggregatedMetrics::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
GlobalMemoryDump::GlobalMemoryDump()
    : start_time(),
      process_dumps(),
      aggregated_metrics() {}

GlobalMemoryDump::GlobalMemoryDump(
    ::base::TimeTicks start_time_in,
    std::vector<ProcessMemoryDumpPtr> process_dumps_in,
    AggregatedMetricsPtr aggregated_metrics_in)
    : start_time(std::move(start_time_in)),
      process_dumps(std::move(process_dumps_in)),
      aggregated_metrics(std::move(aggregated_metrics_in)) {}

GlobalMemoryDump::~GlobalMemoryDump() = default;

void GlobalMemoryDump::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "start_time"), this->start_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeTicks>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "process_dumps"), this->process_dumps,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<ProcessMemoryDumpPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "aggregated_metrics"), this->aggregated_metrics,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AggregatedMetricsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool GlobalMemoryDump::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
HeapProfileResult::HeapProfileResult()
    : pid(),
      json() {}

HeapProfileResult::HeapProfileResult(
    ::base::ProcessId pid_in,
    const ::std::string& json_in)
    : pid(std::move(pid_in)),
      json(std::move(json_in)) {}

HeapProfileResult::~HeapProfileResult() = default;

void HeapProfileResult::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pid"), this->pid,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::ProcessId>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "json"), this->json,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool HeapProfileResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
RawAllocatorDumpEntryValuePtr
RawAllocatorDumpEntryValue::NewValueUint64(
    uint64_t value) {
  return RawAllocatorDumpEntryValuePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kValueUint64)>,
      std::move(value));
}

RawAllocatorDumpEntryValuePtr
RawAllocatorDumpEntryValue::NewValueString(
    const std::string& value) {
  return RawAllocatorDumpEntryValuePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kValueString)>,
      std::move(value));
}

RawAllocatorDumpEntryValue::RawAllocatorDumpEntryValue(
    std::in_place_index_t<static_cast<size_t>(Tag::kValueUint64)>,
    uint64_t value)
    : tag_(Tag::kValueUint64),
      data_(std::in_place_index<static_cast<size_t>(Tag::kValueUint64)>,
            std::move(value)) {}

RawAllocatorDumpEntryValue::RawAllocatorDumpEntryValue(
    std::in_place_index_t<static_cast<size_t>(Tag::kValueString)>,
    const std::string& value)
    : tag_(Tag::kValueString),
      data_(std::in_place_index<static_cast<size_t>(Tag::kValueString)>,
            std::move(value)) {}
RawAllocatorDumpEntryValue::~RawAllocatorDumpEntryValue() {
  DestroyActive();
}

void RawAllocatorDumpEntryValue::set_value_uint64(uint64_t value_uint64) {
  if (tag_ != Tag::kValueUint64) {
    DestroyActive();
    tag_ = Tag::kValueUint64;
  }
  data_.value_uint64 = value_uint64;
}

void RawAllocatorDumpEntryValue::set_value_string(const std::string& value_string) {
  if (tag_ == Tag::kValueString) {
    data_.value_string = std::move(value_string);
  } else {
    DestroyActive();
    tag_ = Tag::kValueString;
    new (&data_.value_string) std::string(
        std::move(value_string));
  }
}


RawAllocatorDumpEntryValue::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kValueUint64)>,
    uint64_t value)
    : value_uint64(std::move(value)) {}

RawAllocatorDumpEntryValue::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kValueString)>,
    const std::string& value)
    : value_string(std::move(value)) {}

void RawAllocatorDumpEntryValue::DestroyActive() {
  switch (tag_) {

    case Tag::kValueUint64:
      std::destroy_at(&data_.value_uint64);
      break;
    case Tag::kValueString:
      std::destroy_at(&data_.value_string);
      break;
  }
}
size_t RawAllocatorDumpEntryValue::Hash(size_t seed) const {
  seed = mojo::internal::HashCombine(seed, static_cast<uint32_t>(tag_));
  switch (tag_) {

    case Tag::kValueUint64:
      return mojo::internal::Hash(seed, data_.value_uint64);
    case Tag::kValueString:
      return mojo::internal::Hash(seed, data_.value_string);
    default:
      NOTREACHED();
  }
}

bool RawAllocatorDumpEntryValue::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
// The declaration includes the definition on other builds.

ClientProcess::IPCStableHashFunction ClientProcess::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ClientProcess>(message.name())) {
    case messages::ClientProcess::kRequestChromeMemoryDump: {
      return &ClientProcess::RequestChromeMemoryDump_Sym::IPCStableHash;
    }
    case messages::ClientProcess::kRequestOSMemoryDump: {
      return &ClientProcess::RequestOSMemoryDump_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ClientProcess::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ClientProcess>(message.name())) {
      case messages::ClientProcess::kRequestChromeMemoryDump:
            return "Receive memory_instrumentation::mojom::ClientProcess::RequestChromeMemoryDump";
      case messages::ClientProcess::kRequestOSMemoryDump:
            return "Receive memory_instrumentation::mojom::ClientProcess::RequestOSMemoryDump";
    }
  } else {
    switch (static_cast<messages::ClientProcess>(message.name())) {
      case messages::ClientProcess::kRequestChromeMemoryDump:
            return "Receive reply memory_instrumentation::mojom::ClientProcess::RequestChromeMemoryDump";
      case messages::ClientProcess::kRequestOSMemoryDump:
            return "Receive reply memory_instrumentation::mojom::ClientProcess::RequestOSMemoryDump";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ClientProcess::RequestChromeMemoryDump_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcbc287be;  // IPCStableHash for memory_instrumentation::mojom::ClientProcess::RequestChromeMemoryDump
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ClientProcess::RequestOSMemoryDump_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x21157c58;  // IPCStableHash for memory_instrumentation::mojom::ClientProcess::RequestOSMemoryDump
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class ClientProcess_RequestChromeMemoryDump_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ClientProcess_RequestChromeMemoryDump_ForwardToCallback(
      ClientProcess::RequestChromeMemoryDumpCallback callback
      ) : callback_(std::move(callback)) {
  }

  ClientProcess_RequestChromeMemoryDump_ForwardToCallback(const ClientProcess_RequestChromeMemoryDump_ForwardToCallback&) = delete;
  ClientProcess_RequestChromeMemoryDump_ForwardToCallback& operator=(const ClientProcess_RequestChromeMemoryDump_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ClientProcess::RequestChromeMemoryDumpCallback callback_;
};

class ClientProcess_RequestOSMemoryDump_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ClientProcess_RequestOSMemoryDump_ForwardToCallback(
      ClientProcess::RequestOSMemoryDumpCallback callback
      ) : callback_(std::move(callback)) {
  }

  ClientProcess_RequestOSMemoryDump_ForwardToCallback(const ClientProcess_RequestOSMemoryDump_ForwardToCallback&) = delete;
  ClientProcess_RequestOSMemoryDump_ForwardToCallback& operator=(const ClientProcess_RequestOSMemoryDump_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ClientProcess::RequestOSMemoryDumpCallback callback_;
};

ClientProcessProxy::ClientProcessProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ClientProcessProxy::RequestChromeMemoryDump(
    const ::base::trace_event::MemoryDumpRequestArgs& in_args, RequestChromeMemoryDumpCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send memory_instrumentation::mojom::ClientProcess::RequestChromeMemoryDump", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("args"), in_args,
                        "<value of type const ::base::trace_event::MemoryDumpRequestArgs&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ClientProcess::kRequestChromeMemoryDump), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::memory_instrumentation::mojom::internal::ClientProcess_RequestChromeMemoryDump_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->args)::BaseType> args_fragment(
          params.message());
  
  mojo::internal::Serialize<::memory_instrumentation::mojom::RequestArgsDataView>(
    in_args,
    args_fragment);

  params->args.Set(
      args_fragment.is_null() ? nullptr : args_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->args.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null args in ClientProcess.RequestChromeMemoryDump request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClientProcess::Name_);
  message.set_method_name("RequestChromeMemoryDump");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ClientProcess_RequestChromeMemoryDump_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ClientProcessProxy::RequestOSMemoryDump(
    MemoryMapOption in_option, const std::vector<MemDumpFlags>& in_flags, const std::vector<::base::ProcessId>& in_pids, RequestOSMemoryDumpCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send memory_instrumentation::mojom::ClientProcess::RequestOSMemoryDump", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("option"), in_option,
                        "<value of type MemoryMapOption>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("flags"), in_flags,
                        "<value of type const std::vector<MemDumpFlags>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pids"), in_pids,
                        "<value of type const std::vector<::base::ProcessId>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ClientProcess::kRequestOSMemoryDump), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::memory_instrumentation::mojom::internal::ClientProcess_RequestOSMemoryDump_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::memory_instrumentation::mojom::MemoryMapOption>(
    in_option,
    &params->option);
  mojo::internal::MessageFragment<
      typename decltype(params->flags)::BaseType>
      flags_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& flags_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::memory_instrumentation::mojom::internal::MemDumpFlags_Data::Validate>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::memory_instrumentation::mojom::MemDumpFlags>>(
    in_flags,
    flags_fragment,
    &flags_validate_params);

  params->flags.Set(
      flags_fragment.is_null() ? nullptr : flags_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->flags.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null flags in ClientProcess.RequestOSMemoryDump request");
  mojo::internal::MessageFragment<
      typename decltype(params->pids)::BaseType>
      pids_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& pids_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::mojo_base::mojom::ProcessIdDataView>>(
    in_pids,
    pids_fragment,
    &pids_validate_params);

  params->pids.Set(
      pids_fragment.is_null() ? nullptr : pids_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->pids.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null pids in ClientProcess.RequestOSMemoryDump request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClientProcess::Name_);
  message.set_method_name("RequestOSMemoryDump");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ClientProcess_RequestOSMemoryDump_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class ClientProcess_RequestChromeMemoryDump_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ClientProcess::RequestChromeMemoryDumpCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ClientProcess_RequestChromeMemoryDump_ProxyToResponder> proxy(
        new ClientProcess_RequestChromeMemoryDump_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ClientProcess_RequestChromeMemoryDump_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ClientProcess_RequestChromeMemoryDump_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ClientProcess_RequestChromeMemoryDump_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ClientProcess::RequestChromeMemoryDumpCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success, uint64_t in_dump_id, ::std::unique_ptr<::base::trace_event::ProcessMemoryDump> in_raw_process_memory_dump);
};

bool ClientProcess_RequestChromeMemoryDump_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ClientProcess_RequestChromeMemoryDump_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ClientProcess_RequestChromeMemoryDump_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ClientProcess.0
  bool success = true;
  bool p_success{};
  uint64_t p_dump_id{};
  ::std::unique_ptr<::base::trace_event::ProcessMemoryDump> p_raw_process_memory_dump{};
  ClientProcess_RequestChromeMemoryDump_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (success)
    p_dump_id = input_data_view.dump_id();
  if (success && !input_data_view.ReadRawProcessMemoryDump(&p_raw_process_memory_dump))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ClientProcess::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success), 
std::move(p_dump_id), 
std::move(p_raw_process_memory_dump));
  }
  return true;
}

void ClientProcess_RequestChromeMemoryDump_ProxyToResponder::Run(
    bool in_success, uint64_t in_dump_id, ::std::unique_ptr<::base::trace_event::ProcessMemoryDump> in_raw_process_memory_dump) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply memory_instrumentation::mojom::ClientProcess::RequestChromeMemoryDump", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("dump_id"), in_dump_id,
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("raw_process_memory_dump"), in_raw_process_memory_dump,
                        "<value of type ::std::unique_ptr<::base::trace_event::ProcessMemoryDump>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ClientProcess::kRequestChromeMemoryDump), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::memory_instrumentation::mojom::internal::ClientProcess_RequestChromeMemoryDump_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

  params->dump_id = in_dump_id;
  mojo::internal::MessageFragment<
      typename decltype(params->raw_process_memory_dump)::BaseType> raw_process_memory_dump_fragment(
          params.message());
  
  mojo::internal::Serialize<::memory_instrumentation::mojom::RawProcessMemoryDumpDataView>(
    in_raw_process_memory_dump,
    raw_process_memory_dump_fragment);

  params->raw_process_memory_dump.Set(
      raw_process_memory_dump_fragment.is_null() ? nullptr : raw_process_memory_dump_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClientProcess::Name_);
  message.set_method_name("RequestChromeMemoryDump");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ClientProcess_RequestOSMemoryDump_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ClientProcess::RequestOSMemoryDumpCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ClientProcess_RequestOSMemoryDump_ProxyToResponder> proxy(
        new ClientProcess_RequestOSMemoryDump_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ClientProcess_RequestOSMemoryDump_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ClientProcess_RequestOSMemoryDump_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ClientProcess_RequestOSMemoryDump_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ClientProcess::RequestOSMemoryDumpCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success, base::flat_map<::base::ProcessId, RawOSMemDumpPtr> in_dumps);
};

bool ClientProcess_RequestOSMemoryDump_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ClientProcess_RequestOSMemoryDump_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ClientProcess_RequestOSMemoryDump_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ClientProcess.1
  bool success = true;
  bool p_success{};
  base::flat_map<::base::ProcessId, RawOSMemDumpPtr> p_dumps{};
  ClientProcess_RequestOSMemoryDump_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (success && !input_data_view.ReadDumps(&p_dumps))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ClientProcess::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success), 
std::move(p_dumps));
  }
  return true;
}

void ClientProcess_RequestOSMemoryDump_ProxyToResponder::Run(
    bool in_success, base::flat_map<::base::ProcessId, RawOSMemDumpPtr> in_dumps) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply memory_instrumentation::mojom::ClientProcess::RequestOSMemoryDump", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("dumps"), in_dumps,
                        "<value of type base::flat_map<::base::ProcessId, RawOSMemDumpPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ClientProcess::kRequestOSMemoryDump), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::memory_instrumentation::mojom::internal::ClientProcess_RequestOSMemoryDump_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;
  mojo::internal::MessageFragment<
      typename decltype(params->dumps)::BaseType>
      dumps_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& dumps_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::MapDataView<::mojo_base::mojom::ProcessIdDataView, ::memory_instrumentation::mojom::RawOSMemDumpDataView>>(
    in_dumps,
    dumps_fragment,
    &dumps_validate_params);

  params->dumps.Set(
      dumps_fragment.is_null() ? nullptr : dumps_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->dumps.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null dumps in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClientProcess::Name_);
  message.set_method_name("RequestOSMemoryDump");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ClientProcessStubDispatch::Accept(
    ClientProcess* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ClientProcess>(message->header()->name)) {
    case messages::ClientProcess::kRequestChromeMemoryDump: {
      break;
    }
    case messages::ClientProcess::kRequestOSMemoryDump: {
      break;
    }
  }
  return false;
}

// static
bool ClientProcessStubDispatch::AcceptWithResponder(
    ClientProcess* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ClientProcess>(message->header()->name)) {
    case messages::ClientProcess::kRequestChromeMemoryDump: {
      internal::ClientProcess_RequestChromeMemoryDump_Params_Data* params =
          reinterpret_cast<
              internal::ClientProcess_RequestChromeMemoryDump_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ClientProcess.0
      bool success = true;
      ::base::trace_event::MemoryDumpRequestArgs p_args{};
      ClientProcess_RequestChromeMemoryDump_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadArgs(&p_args))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ClientProcess::Name_, 0, false);
        return false;
      }
      auto callback =
          ClientProcess_RequestChromeMemoryDump_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestChromeMemoryDump(        
        std::move(p_args), std::move(callback));
      return true;
    }
    case messages::ClientProcess::kRequestOSMemoryDump: {
      internal::ClientProcess_RequestOSMemoryDump_Params_Data* params =
          reinterpret_cast<
              internal::ClientProcess_RequestOSMemoryDump_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ClientProcess.1
      bool success = true;
      MemoryMapOption p_option{};
      std::vector<MemDumpFlags> p_flags{};
      std::vector<::base::ProcessId> p_pids{};
      ClientProcess_RequestOSMemoryDump_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOption(&p_option))
        success = false;
      if (success && !input_data_view.ReadFlags(&p_flags))
        success = false;
      if (success && !input_data_view.ReadPids(&p_pids))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ClientProcess::Name_, 1, false);
        return false;
      }
      auto callback =
          ClientProcess_RequestOSMemoryDump_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestOSMemoryDump(        
        std::move(p_option), 
        std::move(p_flags), 
        std::move(p_pids), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kClientProcessValidationInfo[] = {
    {base::to_underlying(messages::ClientProcess::kRequestChromeMemoryDump),
     { &internal::ClientProcess_RequestChromeMemoryDump_Params_Data::Validate,
      &internal::ClientProcess_RequestChromeMemoryDump_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::ClientProcess::kRequestOSMemoryDump),
     { &internal::ClientProcess_RequestOSMemoryDump_Params_Data::Validate,
      &internal::ClientProcess_RequestOSMemoryDump_ResponseParams_Data::Validate}},
};

bool ClientProcessRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::memory_instrumentation::mojom::ClientProcess::Name_,
    kClientProcessValidationInfo);
}

bool ClientProcessResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGeneric(
    message,
    ::memory_instrumentation::mojom::ClientProcess::Name_,
    kClientProcessValidationInfo);

}
// The declaration includes the definition on other builds.

HeapProfiler::IPCStableHashFunction HeapProfiler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::HeapProfiler>(message.name())) {
    case messages::HeapProfiler::kDumpProcessesForTracing: {
      return &HeapProfiler::DumpProcessesForTracing_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* HeapProfiler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::HeapProfiler>(message.name())) {
      case messages::HeapProfiler::kDumpProcessesForTracing:
            return "Receive memory_instrumentation::mojom::HeapProfiler::DumpProcessesForTracing";
    }
  } else {
    switch (static_cast<messages::HeapProfiler>(message.name())) {
      case messages::HeapProfiler::kDumpProcessesForTracing:
            return "Receive reply memory_instrumentation::mojom::HeapProfiler::DumpProcessesForTracing";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t HeapProfiler::DumpProcessesForTracing_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xeb38dfd6;  // IPCStableHash for memory_instrumentation::mojom::HeapProfiler::DumpProcessesForTracing
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class HeapProfiler_DumpProcessesForTracing_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  HeapProfiler_DumpProcessesForTracing_ForwardToCallback(
      HeapProfiler::DumpProcessesForTracingCallback callback
      ) : callback_(std::move(callback)) {
  }

  HeapProfiler_DumpProcessesForTracing_ForwardToCallback(const HeapProfiler_DumpProcessesForTracing_ForwardToCallback&) = delete;
  HeapProfiler_DumpProcessesForTracing_ForwardToCallback& operator=(const HeapProfiler_DumpProcessesForTracing_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  HeapProfiler::DumpProcessesForTracingCallback callback_;
};

HeapProfilerProxy::HeapProfilerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void HeapProfilerProxy::DumpProcessesForTracing(
    bool in_strip_path_from_mapped_files, bool in_write_proto, DumpProcessesForTracingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send memory_instrumentation::mojom::HeapProfiler::DumpProcessesForTracing", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("strip_path_from_mapped_files"), in_strip_path_from_mapped_files,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("write_proto"), in_write_proto,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::HeapProfiler::kDumpProcessesForTracing), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::memory_instrumentation::mojom::internal::HeapProfiler_DumpProcessesForTracing_Params_Data> params(
          message);
  params.Allocate();

  params->strip_path_from_mapped_files = in_strip_path_from_mapped_files;

  params->write_proto = in_write_proto;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(HeapProfiler::Name_);
  message.set_method_name("DumpProcessesForTracing");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new HeapProfiler_DumpProcessesForTracing_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class HeapProfiler_DumpProcessesForTracing_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static HeapProfiler::DumpProcessesForTracingCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<HeapProfiler_DumpProcessesForTracing_ProxyToResponder> proxy(
        new HeapProfiler_DumpProcessesForTracing_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&HeapProfiler_DumpProcessesForTracing_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~HeapProfiler_DumpProcessesForTracing_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  HeapProfiler_DumpProcessesForTracing_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "HeapProfiler::DumpProcessesForTracingCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<HeapProfileResultPtr> in_results);
};

bool HeapProfiler_DumpProcessesForTracing_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::HeapProfiler_DumpProcessesForTracing_ResponseParams_Data* params =
      reinterpret_cast<
          internal::HeapProfiler_DumpProcessesForTracing_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for HeapProfiler.0
  bool success = true;
  std::vector<HeapProfileResultPtr> p_results{};
  HeapProfiler_DumpProcessesForTracing_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResults(&p_results))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        HeapProfiler::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_results));
  }
  return true;
}

void HeapProfiler_DumpProcessesForTracing_ProxyToResponder::Run(
    std::vector<HeapProfileResultPtr> in_results) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply memory_instrumentation::mojom::HeapProfiler::DumpProcessesForTracing", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("results"), in_results,
                        "<value of type std::vector<HeapProfileResultPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::HeapProfiler::kDumpProcessesForTracing), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::memory_instrumentation::mojom::internal::HeapProfiler_DumpProcessesForTracing_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->results)::BaseType>
      results_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& results_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::memory_instrumentation::mojom::HeapProfileResultDataView>>(
    in_results,
    results_fragment,
    &results_validate_params);

  params->results.Set(
      results_fragment.is_null() ? nullptr : results_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->results.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null results in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(HeapProfiler::Name_);
  message.set_method_name("DumpProcessesForTracing");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool HeapProfilerStubDispatch::Accept(
    HeapProfiler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::HeapProfiler>(message->header()->name)) {
    case messages::HeapProfiler::kDumpProcessesForTracing: {
      break;
    }
  }
  return false;
}

// static
bool HeapProfilerStubDispatch::AcceptWithResponder(
    HeapProfiler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::HeapProfiler>(message->header()->name)) {
    case messages::HeapProfiler::kDumpProcessesForTracing: {
      internal::HeapProfiler_DumpProcessesForTracing_Params_Data* params =
          reinterpret_cast<
              internal::HeapProfiler_DumpProcessesForTracing_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for HeapProfiler.0
      bool success = true;
      bool p_strip_path_from_mapped_files{};
      bool p_write_proto{};
      HeapProfiler_DumpProcessesForTracing_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_strip_path_from_mapped_files = input_data_view.strip_path_from_mapped_files();
      if (success)
        p_write_proto = input_data_view.write_proto();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            HeapProfiler::Name_, 0, false);
        return false;
      }
      auto callback =
          HeapProfiler_DumpProcessesForTracing_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DumpProcessesForTracing(        
        std::move(p_strip_path_from_mapped_files), 
        std::move(p_write_proto), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kHeapProfilerValidationInfo[] = {
    {base::to_underlying(messages::HeapProfiler::kDumpProcessesForTracing),
     { &internal::HeapProfiler_DumpProcessesForTracing_Params_Data::Validate,
      &internal::HeapProfiler_DumpProcessesForTracing_ResponseParams_Data::Validate}},
};

bool HeapProfilerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::memory_instrumentation::mojom::HeapProfiler::Name_,
    kHeapProfilerValidationInfo);
}

bool HeapProfilerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGeneric(
    message,
    ::memory_instrumentation::mojom::HeapProfiler::Name_,
    kHeapProfilerValidationInfo);

}
// The declaration includes the definition on other builds.

HeapProfilerHelper::IPCStableHashFunction HeapProfilerHelper::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::HeapProfilerHelper>(message.name())) {
    case messages::HeapProfilerHelper::kGetVmRegionsForHeapProfiler: {
      return &HeapProfilerHelper::GetVmRegionsForHeapProfiler_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* HeapProfilerHelper::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::HeapProfilerHelper>(message.name())) {
      case messages::HeapProfilerHelper::kGetVmRegionsForHeapProfiler:
            return "Receive memory_instrumentation::mojom::HeapProfilerHelper::GetVmRegionsForHeapProfiler";
    }
  } else {
    switch (static_cast<messages::HeapProfilerHelper>(message.name())) {
      case messages::HeapProfilerHelper::kGetVmRegionsForHeapProfiler:
            return "Receive reply memory_instrumentation::mojom::HeapProfilerHelper::GetVmRegionsForHeapProfiler";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t HeapProfilerHelper::GetVmRegionsForHeapProfiler_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x502c8ab0;  // IPCStableHash for memory_instrumentation::mojom::HeapProfilerHelper::GetVmRegionsForHeapProfiler
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class HeapProfilerHelper_GetVmRegionsForHeapProfiler_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  HeapProfilerHelper_GetVmRegionsForHeapProfiler_ForwardToCallback(
      HeapProfilerHelper::GetVmRegionsForHeapProfilerCallback callback
      ) : callback_(std::move(callback)) {
  }

  HeapProfilerHelper_GetVmRegionsForHeapProfiler_ForwardToCallback(const HeapProfilerHelper_GetVmRegionsForHeapProfiler_ForwardToCallback&) = delete;
  HeapProfilerHelper_GetVmRegionsForHeapProfiler_ForwardToCallback& operator=(const HeapProfilerHelper_GetVmRegionsForHeapProfiler_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  HeapProfilerHelper::GetVmRegionsForHeapProfilerCallback callback_;
};

HeapProfilerHelperProxy::HeapProfilerHelperProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void HeapProfilerHelperProxy::GetVmRegionsForHeapProfiler(
    const std::vector<::base::ProcessId>& in_pids, GetVmRegionsForHeapProfilerCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send memory_instrumentation::mojom::HeapProfilerHelper::GetVmRegionsForHeapProfiler", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pids"), in_pids,
                        "<value of type const std::vector<::base::ProcessId>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::HeapProfilerHelper::kGetVmRegionsForHeapProfiler), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::memory_instrumentation::mojom::internal::HeapProfilerHelper_GetVmRegionsForHeapProfiler_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->pids)::BaseType>
      pids_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& pids_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::mojo_base::mojom::ProcessIdDataView>>(
    in_pids,
    pids_fragment,
    &pids_validate_params);

  params->pids.Set(
      pids_fragment.is_null() ? nullptr : pids_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->pids.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null pids in HeapProfilerHelper.GetVmRegionsForHeapProfiler request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(HeapProfilerHelper::Name_);
  message.set_method_name("GetVmRegionsForHeapProfiler");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new HeapProfilerHelper_GetVmRegionsForHeapProfiler_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class HeapProfilerHelper_GetVmRegionsForHeapProfiler_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static HeapProfilerHelper::GetVmRegionsForHeapProfilerCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<HeapProfilerHelper_GetVmRegionsForHeapProfiler_ProxyToResponder> proxy(
        new HeapProfilerHelper_GetVmRegionsForHeapProfiler_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&HeapProfilerHelper_GetVmRegionsForHeapProfiler_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~HeapProfilerHelper_GetVmRegionsForHeapProfiler_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  HeapProfilerHelper_GetVmRegionsForHeapProfiler_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "HeapProfilerHelper::GetVmRegionsForHeapProfilerCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      base::flat_map<::base::ProcessId, std::vector<VmRegionPtr>> in_vm_regions);
};

bool HeapProfilerHelper_GetVmRegionsForHeapProfiler_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::HeapProfilerHelper_GetVmRegionsForHeapProfiler_ResponseParams_Data* params =
      reinterpret_cast<
          internal::HeapProfilerHelper_GetVmRegionsForHeapProfiler_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for HeapProfilerHelper.0
  bool success = true;
  base::flat_map<::base::ProcessId, std::vector<VmRegionPtr>> p_vm_regions{};
  HeapProfilerHelper_GetVmRegionsForHeapProfiler_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadVmRegions(&p_vm_regions))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        HeapProfilerHelper::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_vm_regions));
  }
  return true;
}

void HeapProfilerHelper_GetVmRegionsForHeapProfiler_ProxyToResponder::Run(
    base::flat_map<::base::ProcessId, std::vector<VmRegionPtr>> in_vm_regions) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply memory_instrumentation::mojom::HeapProfilerHelper::GetVmRegionsForHeapProfiler", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("vm_regions"), in_vm_regions,
                        "<value of type base::flat_map<::base::ProcessId, std::vector<VmRegionPtr>>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::HeapProfilerHelper::kGetVmRegionsForHeapProfiler), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::memory_instrumentation::mojom::internal::HeapProfilerHelper_GetVmRegionsForHeapProfiler_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->vm_regions)::BaseType>
      vm_regions_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& vm_regions_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
  
  mojo::internal::Serialize<mojo::MapDataView<::mojo_base::mojom::ProcessIdDataView, mojo::ArrayDataView<::memory_instrumentation::mojom::VmRegionDataView>>>(
    in_vm_regions,
    vm_regions_fragment,
    &vm_regions_validate_params);

  params->vm_regions.Set(
      vm_regions_fragment.is_null() ? nullptr : vm_regions_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->vm_regions.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null vm_regions in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(HeapProfilerHelper::Name_);
  message.set_method_name("GetVmRegionsForHeapProfiler");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool HeapProfilerHelperStubDispatch::Accept(
    HeapProfilerHelper* impl,
    mojo::Message* message) {
  switch (static_cast<messages::HeapProfilerHelper>(message->header()->name)) {
    case messages::HeapProfilerHelper::kGetVmRegionsForHeapProfiler: {
      break;
    }
  }
  return false;
}

// static
bool HeapProfilerHelperStubDispatch::AcceptWithResponder(
    HeapProfilerHelper* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::HeapProfilerHelper>(message->header()->name)) {
    case messages::HeapProfilerHelper::kGetVmRegionsForHeapProfiler: {
      internal::HeapProfilerHelper_GetVmRegionsForHeapProfiler_Params_Data* params =
          reinterpret_cast<
              internal::HeapProfilerHelper_GetVmRegionsForHeapProfiler_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for HeapProfilerHelper.0
      bool success = true;
      std::vector<::base::ProcessId> p_pids{};
      HeapProfilerHelper_GetVmRegionsForHeapProfiler_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPids(&p_pids))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            HeapProfilerHelper::Name_, 0, false);
        return false;
      }
      auto callback =
          HeapProfilerHelper_GetVmRegionsForHeapProfiler_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetVmRegionsForHeapProfiler(        
        std::move(p_pids), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kHeapProfilerHelperValidationInfo[] = {
    {base::to_underlying(messages::HeapProfilerHelper::kGetVmRegionsForHeapProfiler),
     { &internal::HeapProfilerHelper_GetVmRegionsForHeapProfiler_Params_Data::Validate,
      &internal::HeapProfilerHelper_GetVmRegionsForHeapProfiler_ResponseParams_Data::Validate}},
};

bool HeapProfilerHelperRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::memory_instrumentation::mojom::HeapProfilerHelper::Name_,
    kHeapProfilerHelperValidationInfo);
}

bool HeapProfilerHelperResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGeneric(
    message,
    ::memory_instrumentation::mojom::HeapProfilerHelper::Name_,
    kHeapProfilerHelperValidationInfo);

}
// The declaration includes the definition on other builds.

Coordinator::IPCStableHashFunction Coordinator::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::Coordinator>(message.name())) {
    case messages::Coordinator::kRequestGlobalMemoryDump: {
      return &Coordinator::RequestGlobalMemoryDump_Sym::IPCStableHash;
    }
    case messages::Coordinator::kRequestGlobalMemoryDumpForPid: {
      return &Coordinator::RequestGlobalMemoryDumpForPid_Sym::IPCStableHash;
    }
    case messages::Coordinator::kRequestPrivateMemoryFootprint: {
      return &Coordinator::RequestPrivateMemoryFootprint_Sym::IPCStableHash;
    }
    case messages::Coordinator::kRequestGlobalMemoryDumpAndAppendToTrace: {
      return &Coordinator::RequestGlobalMemoryDumpAndAppendToTrace_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* Coordinator::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::Coordinator>(message.name())) {
      case messages::Coordinator::kRequestGlobalMemoryDump:
            return "Receive memory_instrumentation::mojom::Coordinator::RequestGlobalMemoryDump";
      case messages::Coordinator::kRequestGlobalMemoryDumpForPid:
            return "Receive memory_instrumentation::mojom::Coordinator::RequestGlobalMemoryDumpForPid";
      case messages::Coordinator::kRequestPrivateMemoryFootprint:
            return "Receive memory_instrumentation::mojom::Coordinator::RequestPrivateMemoryFootprint";
      case messages::Coordinator::kRequestGlobalMemoryDumpAndAppendToTrace:
            return "Receive memory_instrumentation::mojom::Coordinator::RequestGlobalMemoryDumpAndAppendToTrace";
    }
  } else {
    switch (static_cast<messages::Coordinator>(message.name())) {
      case messages::Coordinator::kRequestGlobalMemoryDump:
            return "Receive reply memory_instrumentation::mojom::Coordinator::RequestGlobalMemoryDump";
      case messages::Coordinator::kRequestGlobalMemoryDumpForPid:
            return "Receive reply memory_instrumentation::mojom::Coordinator::RequestGlobalMemoryDumpForPid";
      case messages::Coordinator::kRequestPrivateMemoryFootprint:
            return "Receive reply memory_instrumentation::mojom::Coordinator::RequestPrivateMemoryFootprint";
      case messages::Coordinator::kRequestGlobalMemoryDumpAndAppendToTrace:
            return "Receive reply memory_instrumentation::mojom::Coordinator::RequestGlobalMemoryDumpAndAppendToTrace";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t Coordinator::RequestGlobalMemoryDump_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x122d450a;  // IPCStableHash for memory_instrumentation::mojom::Coordinator::RequestGlobalMemoryDump
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Coordinator::RequestGlobalMemoryDumpForPid_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe454543c;  // IPCStableHash for memory_instrumentation::mojom::Coordinator::RequestGlobalMemoryDumpForPid
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Coordinator::RequestPrivateMemoryFootprint_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2771fa20;  // IPCStableHash for memory_instrumentation::mojom::Coordinator::RequestPrivateMemoryFootprint
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Coordinator::RequestGlobalMemoryDumpAndAppendToTrace_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb176aeb2;  // IPCStableHash for memory_instrumentation::mojom::Coordinator::RequestGlobalMemoryDumpAndAppendToTrace
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class Coordinator_RequestGlobalMemoryDump_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Coordinator_RequestGlobalMemoryDump_ForwardToCallback(
      Coordinator::RequestGlobalMemoryDumpCallback callback
      ) : callback_(std::move(callback)) {
  }

  Coordinator_RequestGlobalMemoryDump_ForwardToCallback(const Coordinator_RequestGlobalMemoryDump_ForwardToCallback&) = delete;
  Coordinator_RequestGlobalMemoryDump_ForwardToCallback& operator=(const Coordinator_RequestGlobalMemoryDump_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Coordinator::RequestGlobalMemoryDumpCallback callback_;
};

class Coordinator_RequestGlobalMemoryDumpForPid_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Coordinator_RequestGlobalMemoryDumpForPid_ForwardToCallback(
      Coordinator::RequestGlobalMemoryDumpForPidCallback callback
      ) : callback_(std::move(callback)) {
  }

  Coordinator_RequestGlobalMemoryDumpForPid_ForwardToCallback(const Coordinator_RequestGlobalMemoryDumpForPid_ForwardToCallback&) = delete;
  Coordinator_RequestGlobalMemoryDumpForPid_ForwardToCallback& operator=(const Coordinator_RequestGlobalMemoryDumpForPid_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Coordinator::RequestGlobalMemoryDumpForPidCallback callback_;
};

class Coordinator_RequestPrivateMemoryFootprint_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Coordinator_RequestPrivateMemoryFootprint_ForwardToCallback(
      Coordinator::RequestPrivateMemoryFootprintCallback callback
      ) : callback_(std::move(callback)) {
  }

  Coordinator_RequestPrivateMemoryFootprint_ForwardToCallback(const Coordinator_RequestPrivateMemoryFootprint_ForwardToCallback&) = delete;
  Coordinator_RequestPrivateMemoryFootprint_ForwardToCallback& operator=(const Coordinator_RequestPrivateMemoryFootprint_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Coordinator::RequestPrivateMemoryFootprintCallback callback_;
};

class Coordinator_RequestGlobalMemoryDumpAndAppendToTrace_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Coordinator_RequestGlobalMemoryDumpAndAppendToTrace_ForwardToCallback(
      Coordinator::RequestGlobalMemoryDumpAndAppendToTraceCallback callback
      ) : callback_(std::move(callback)) {
  }

  Coordinator_RequestGlobalMemoryDumpAndAppendToTrace_ForwardToCallback(const Coordinator_RequestGlobalMemoryDumpAndAppendToTrace_ForwardToCallback&) = delete;
  Coordinator_RequestGlobalMemoryDumpAndAppendToTrace_ForwardToCallback& operator=(const Coordinator_RequestGlobalMemoryDumpAndAppendToTrace_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Coordinator::RequestGlobalMemoryDumpAndAppendToTraceCallback callback_;
};

CoordinatorProxy::CoordinatorProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CoordinatorProxy::RequestGlobalMemoryDump(
    ::base::trace_event::MemoryDumpType in_dump_type, ::base::trace_event::MemoryDumpLevelOfDetail in_level_of_detail, ::base::trace_event::MemoryDumpDeterminism in_determinism, const std::vector<std::string>& in_allocator_dump_names, RequestGlobalMemoryDumpCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send memory_instrumentation::mojom::Coordinator::RequestGlobalMemoryDump", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("dump_type"), in_dump_type,
                        "<value of type ::base::trace_event::MemoryDumpType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("level_of_detail"), in_level_of_detail,
                        "<value of type ::base::trace_event::MemoryDumpLevelOfDetail>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("determinism"), in_determinism,
                        "<value of type ::base::trace_event::MemoryDumpDeterminism>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("allocator_dump_names"), in_allocator_dump_names,
                        "<value of type const std::vector<std::string>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Coordinator::kRequestGlobalMemoryDump), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::memory_instrumentation::mojom::internal::Coordinator_RequestGlobalMemoryDump_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::memory_instrumentation::mojom::DumpType>(
    in_dump_type,
    &params->dump_type);

  
  mojo::internal::Serialize<::memory_instrumentation::mojom::LevelOfDetail>(
    in_level_of_detail,
    &params->level_of_detail);

  
  mojo::internal::Serialize<::memory_instrumentation::mojom::Determinism>(
    in_determinism,
    &params->determinism);
  mojo::internal::MessageFragment<
      typename decltype(params->allocator_dump_names)::BaseType>
      allocator_dump_names_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& allocator_dump_names_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
    in_allocator_dump_names,
    allocator_dump_names_fragment,
    &allocator_dump_names_validate_params);

  params->allocator_dump_names.Set(
      allocator_dump_names_fragment.is_null() ? nullptr : allocator_dump_names_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->allocator_dump_names.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null allocator_dump_names in Coordinator.RequestGlobalMemoryDump request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Coordinator::Name_);
  message.set_method_name("RequestGlobalMemoryDump");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Coordinator_RequestGlobalMemoryDump_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void CoordinatorProxy::RequestGlobalMemoryDumpForPid(
    ::base::ProcessId in_pid, const std::vector<std::string>& in_allocator_dump_names, RequestGlobalMemoryDumpForPidCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send memory_instrumentation::mojom::Coordinator::RequestGlobalMemoryDumpForPid", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pid"), in_pid,
                        "<value of type ::base::ProcessId>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("allocator_dump_names"), in_allocator_dump_names,
                        "<value of type const std::vector<std::string>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Coordinator::kRequestGlobalMemoryDumpForPid), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::memory_instrumentation::mojom::internal::Coordinator_RequestGlobalMemoryDumpForPid_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->pid)::BaseType> pid_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::ProcessIdDataView>(
    in_pid,
    pid_fragment);

  params->pid.Set(
      pid_fragment.is_null() ? nullptr : pid_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->pid.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null pid in Coordinator.RequestGlobalMemoryDumpForPid request");
  mojo::internal::MessageFragment<
      typename decltype(params->allocator_dump_names)::BaseType>
      allocator_dump_names_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& allocator_dump_names_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
    in_allocator_dump_names,
    allocator_dump_names_fragment,
    &allocator_dump_names_validate_params);

  params->allocator_dump_names.Set(
      allocator_dump_names_fragment.is_null() ? nullptr : allocator_dump_names_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->allocator_dump_names.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null allocator_dump_names in Coordinator.RequestGlobalMemoryDumpForPid request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Coordinator::Name_);
  message.set_method_name("RequestGlobalMemoryDumpForPid");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Coordinator_RequestGlobalMemoryDumpForPid_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void CoordinatorProxy::RequestPrivateMemoryFootprint(
    ::base::ProcessId in_pid, RequestPrivateMemoryFootprintCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send memory_instrumentation::mojom::Coordinator::RequestPrivateMemoryFootprint", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pid"), in_pid,
                        "<value of type ::base::ProcessId>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Coordinator::kRequestPrivateMemoryFootprint), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::memory_instrumentation::mojom::internal::Coordinator_RequestPrivateMemoryFootprint_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->pid)::BaseType> pid_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::ProcessIdDataView>(
    in_pid,
    pid_fragment);

  params->pid.Set(
      pid_fragment.is_null() ? nullptr : pid_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->pid.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null pid in Coordinator.RequestPrivateMemoryFootprint request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Coordinator::Name_);
  message.set_method_name("RequestPrivateMemoryFootprint");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Coordinator_RequestPrivateMemoryFootprint_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void CoordinatorProxy::RequestGlobalMemoryDumpAndAppendToTrace(
    ::base::trace_event::MemoryDumpType in_dump_type, ::base::trace_event::MemoryDumpLevelOfDetail in_level_of_detail, ::base::trace_event::MemoryDumpDeterminism in_determinism, RequestGlobalMemoryDumpAndAppendToTraceCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send memory_instrumentation::mojom::Coordinator::RequestGlobalMemoryDumpAndAppendToTrace", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("dump_type"), in_dump_type,
                        "<value of type ::base::trace_event::MemoryDumpType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("level_of_detail"), in_level_of_detail,
                        "<value of type ::base::trace_event::MemoryDumpLevelOfDetail>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("determinism"), in_determinism,
                        "<value of type ::base::trace_event::MemoryDumpDeterminism>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Coordinator::kRequestGlobalMemoryDumpAndAppendToTrace), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::memory_instrumentation::mojom::internal::Coordinator_RequestGlobalMemoryDumpAndAppendToTrace_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::memory_instrumentation::mojom::DumpType>(
    in_dump_type,
    &params->dump_type);

  
  mojo::internal::Serialize<::memory_instrumentation::mojom::LevelOfDetail>(
    in_level_of_detail,
    &params->level_of_detail);

  
  mojo::internal::Serialize<::memory_instrumentation::mojom::Determinism>(
    in_determinism,
    &params->determinism);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Coordinator::Name_);
  message.set_method_name("RequestGlobalMemoryDumpAndAppendToTrace");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Coordinator_RequestGlobalMemoryDumpAndAppendToTrace_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class Coordinator_RequestGlobalMemoryDump_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Coordinator::RequestGlobalMemoryDumpCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Coordinator_RequestGlobalMemoryDump_ProxyToResponder> proxy(
        new Coordinator_RequestGlobalMemoryDump_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Coordinator_RequestGlobalMemoryDump_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Coordinator_RequestGlobalMemoryDump_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Coordinator_RequestGlobalMemoryDump_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Coordinator::RequestGlobalMemoryDumpCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success, GlobalMemoryDumpPtr in_global_memory_dump);
};

bool Coordinator_RequestGlobalMemoryDump_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Coordinator_RequestGlobalMemoryDump_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Coordinator_RequestGlobalMemoryDump_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Coordinator.0
  bool success = true;
  bool p_success{};
  GlobalMemoryDumpPtr p_global_memory_dump{};
  Coordinator_RequestGlobalMemoryDump_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (success && !input_data_view.ReadGlobalMemoryDump(&p_global_memory_dump))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Coordinator::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success), 
std::move(p_global_memory_dump));
  }
  return true;
}

void Coordinator_RequestGlobalMemoryDump_ProxyToResponder::Run(
    bool in_success, GlobalMemoryDumpPtr in_global_memory_dump) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply memory_instrumentation::mojom::Coordinator::RequestGlobalMemoryDump", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("global_memory_dump"), in_global_memory_dump,
                        "<value of type GlobalMemoryDumpPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Coordinator::kRequestGlobalMemoryDump), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::memory_instrumentation::mojom::internal::Coordinator_RequestGlobalMemoryDump_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;
  mojo::internal::MessageFragment<
      typename decltype(params->global_memory_dump)::BaseType> global_memory_dump_fragment(
          params.message());
  
  mojo::internal::Serialize<::memory_instrumentation::mojom::GlobalMemoryDumpDataView>(
    in_global_memory_dump,
    global_memory_dump_fragment);

  params->global_memory_dump.Set(
      global_memory_dump_fragment.is_null() ? nullptr : global_memory_dump_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Coordinator::Name_);
  message.set_method_name("RequestGlobalMemoryDump");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Coordinator_RequestGlobalMemoryDumpForPid_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Coordinator::RequestGlobalMemoryDumpForPidCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Coordinator_RequestGlobalMemoryDumpForPid_ProxyToResponder> proxy(
        new Coordinator_RequestGlobalMemoryDumpForPid_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Coordinator_RequestGlobalMemoryDumpForPid_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Coordinator_RequestGlobalMemoryDumpForPid_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Coordinator_RequestGlobalMemoryDumpForPid_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Coordinator::RequestGlobalMemoryDumpForPidCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success, GlobalMemoryDumpPtr in_global_memory_dump);
};

bool Coordinator_RequestGlobalMemoryDumpForPid_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Coordinator_RequestGlobalMemoryDumpForPid_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Coordinator_RequestGlobalMemoryDumpForPid_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Coordinator.1
  bool success = true;
  bool p_success{};
  GlobalMemoryDumpPtr p_global_memory_dump{};
  Coordinator_RequestGlobalMemoryDumpForPid_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (success && !input_data_view.ReadGlobalMemoryDump(&p_global_memory_dump))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Coordinator::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success), 
std::move(p_global_memory_dump));
  }
  return true;
}

void Coordinator_RequestGlobalMemoryDumpForPid_ProxyToResponder::Run(
    bool in_success, GlobalMemoryDumpPtr in_global_memory_dump) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply memory_instrumentation::mojom::Coordinator::RequestGlobalMemoryDumpForPid", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("global_memory_dump"), in_global_memory_dump,
                        "<value of type GlobalMemoryDumpPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Coordinator::kRequestGlobalMemoryDumpForPid), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::memory_instrumentation::mojom::internal::Coordinator_RequestGlobalMemoryDumpForPid_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;
  mojo::internal::MessageFragment<
      typename decltype(params->global_memory_dump)::BaseType> global_memory_dump_fragment(
          params.message());
  
  mojo::internal::Serialize<::memory_instrumentation::mojom::GlobalMemoryDumpDataView>(
    in_global_memory_dump,
    global_memory_dump_fragment);

  params->global_memory_dump.Set(
      global_memory_dump_fragment.is_null() ? nullptr : global_memory_dump_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Coordinator::Name_);
  message.set_method_name("RequestGlobalMemoryDumpForPid");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Coordinator_RequestPrivateMemoryFootprint_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Coordinator::RequestPrivateMemoryFootprintCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Coordinator_RequestPrivateMemoryFootprint_ProxyToResponder> proxy(
        new Coordinator_RequestPrivateMemoryFootprint_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Coordinator_RequestPrivateMemoryFootprint_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Coordinator_RequestPrivateMemoryFootprint_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Coordinator_RequestPrivateMemoryFootprint_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Coordinator::RequestPrivateMemoryFootprintCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success, GlobalMemoryDumpPtr in_global_memory_dump);
};

bool Coordinator_RequestPrivateMemoryFootprint_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Coordinator_RequestPrivateMemoryFootprint_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Coordinator_RequestPrivateMemoryFootprint_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Coordinator.2
  bool success = true;
  bool p_success{};
  GlobalMemoryDumpPtr p_global_memory_dump{};
  Coordinator_RequestPrivateMemoryFootprint_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (success && !input_data_view.ReadGlobalMemoryDump(&p_global_memory_dump))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Coordinator::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success), 
std::move(p_global_memory_dump));
  }
  return true;
}

void Coordinator_RequestPrivateMemoryFootprint_ProxyToResponder::Run(
    bool in_success, GlobalMemoryDumpPtr in_global_memory_dump) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply memory_instrumentation::mojom::Coordinator::RequestPrivateMemoryFootprint", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("global_memory_dump"), in_global_memory_dump,
                        "<value of type GlobalMemoryDumpPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Coordinator::kRequestPrivateMemoryFootprint), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::memory_instrumentation::mojom::internal::Coordinator_RequestPrivateMemoryFootprint_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;
  mojo::internal::MessageFragment<
      typename decltype(params->global_memory_dump)::BaseType> global_memory_dump_fragment(
          params.message());
  
  mojo::internal::Serialize<::memory_instrumentation::mojom::GlobalMemoryDumpDataView>(
    in_global_memory_dump,
    global_memory_dump_fragment);

  params->global_memory_dump.Set(
      global_memory_dump_fragment.is_null() ? nullptr : global_memory_dump_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Coordinator::Name_);
  message.set_method_name("RequestPrivateMemoryFootprint");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Coordinator_RequestGlobalMemoryDumpAndAppendToTrace_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Coordinator::RequestGlobalMemoryDumpAndAppendToTraceCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Coordinator_RequestGlobalMemoryDumpAndAppendToTrace_ProxyToResponder> proxy(
        new Coordinator_RequestGlobalMemoryDumpAndAppendToTrace_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Coordinator_RequestGlobalMemoryDumpAndAppendToTrace_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Coordinator_RequestGlobalMemoryDumpAndAppendToTrace_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Coordinator_RequestGlobalMemoryDumpAndAppendToTrace_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Coordinator::RequestGlobalMemoryDumpAndAppendToTraceCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success, uint64_t in_dump_id);
};

bool Coordinator_RequestGlobalMemoryDumpAndAppendToTrace_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Coordinator_RequestGlobalMemoryDumpAndAppendToTrace_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Coordinator_RequestGlobalMemoryDumpAndAppendToTrace_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Coordinator.3
  bool success = true;
  bool p_success{};
  uint64_t p_dump_id{};
  Coordinator_RequestGlobalMemoryDumpAndAppendToTrace_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (success)
    p_dump_id = input_data_view.dump_id();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Coordinator::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success), 
std::move(p_dump_id));
  }
  return true;
}

void Coordinator_RequestGlobalMemoryDumpAndAppendToTrace_ProxyToResponder::Run(
    bool in_success, uint64_t in_dump_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply memory_instrumentation::mojom::Coordinator::RequestGlobalMemoryDumpAndAppendToTrace", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("dump_id"), in_dump_id,
                        "<value of type uint64_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Coordinator::kRequestGlobalMemoryDumpAndAppendToTrace), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::memory_instrumentation::mojom::internal::Coordinator_RequestGlobalMemoryDumpAndAppendToTrace_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

  params->dump_id = in_dump_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Coordinator::Name_);
  message.set_method_name("RequestGlobalMemoryDumpAndAppendToTrace");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool CoordinatorStubDispatch::Accept(
    Coordinator* impl,
    mojo::Message* message) {
  switch (static_cast<messages::Coordinator>(message->header()->name)) {
    case messages::Coordinator::kRequestGlobalMemoryDump: {
      break;
    }
    case messages::Coordinator::kRequestGlobalMemoryDumpForPid: {
      break;
    }
    case messages::Coordinator::kRequestPrivateMemoryFootprint: {
      break;
    }
    case messages::Coordinator::kRequestGlobalMemoryDumpAndAppendToTrace: {
      break;
    }
  }
  return false;
}

// static
bool CoordinatorStubDispatch::AcceptWithResponder(
    Coordinator* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::Coordinator>(message->header()->name)) {
    case messages::Coordinator::kRequestGlobalMemoryDump: {
      internal::Coordinator_RequestGlobalMemoryDump_Params_Data* params =
          reinterpret_cast<
              internal::Coordinator_RequestGlobalMemoryDump_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Coordinator.0
      bool success = true;
      ::base::trace_event::MemoryDumpType p_dump_type{};
      ::base::trace_event::MemoryDumpLevelOfDetail p_level_of_detail{};
      ::base::trace_event::MemoryDumpDeterminism p_determinism{};
      std::vector<std::string> p_allocator_dump_names{};
      Coordinator_RequestGlobalMemoryDump_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDumpType(&p_dump_type))
        success = false;
      if (success && !input_data_view.ReadLevelOfDetail(&p_level_of_detail))
        success = false;
      if (success && !input_data_view.ReadDeterminism(&p_determinism))
        success = false;
      if (success && !input_data_view.ReadAllocatorDumpNames(&p_allocator_dump_names))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Coordinator::Name_, 0, false);
        return false;
      }
      auto callback =
          Coordinator_RequestGlobalMemoryDump_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestGlobalMemoryDump(        
        std::move(p_dump_type), 
        std::move(p_level_of_detail), 
        std::move(p_determinism), 
        std::move(p_allocator_dump_names), std::move(callback));
      return true;
    }
    case messages::Coordinator::kRequestGlobalMemoryDumpForPid: {
      internal::Coordinator_RequestGlobalMemoryDumpForPid_Params_Data* params =
          reinterpret_cast<
              internal::Coordinator_RequestGlobalMemoryDumpForPid_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Coordinator.1
      bool success = true;
      ::base::ProcessId p_pid{};
      std::vector<std::string> p_allocator_dump_names{};
      Coordinator_RequestGlobalMemoryDumpForPid_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPid(&p_pid))
        success = false;
      if (success && !input_data_view.ReadAllocatorDumpNames(&p_allocator_dump_names))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Coordinator::Name_, 1, false);
        return false;
      }
      auto callback =
          Coordinator_RequestGlobalMemoryDumpForPid_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestGlobalMemoryDumpForPid(        
        std::move(p_pid), 
        std::move(p_allocator_dump_names), std::move(callback));
      return true;
    }
    case messages::Coordinator::kRequestPrivateMemoryFootprint: {
      internal::Coordinator_RequestPrivateMemoryFootprint_Params_Data* params =
          reinterpret_cast<
              internal::Coordinator_RequestPrivateMemoryFootprint_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Coordinator.2
      bool success = true;
      ::base::ProcessId p_pid{};
      Coordinator_RequestPrivateMemoryFootprint_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPid(&p_pid))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Coordinator::Name_, 2, false);
        return false;
      }
      auto callback =
          Coordinator_RequestPrivateMemoryFootprint_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestPrivateMemoryFootprint(        
        std::move(p_pid), std::move(callback));
      return true;
    }
    case messages::Coordinator::kRequestGlobalMemoryDumpAndAppendToTrace: {
      internal::Coordinator_RequestGlobalMemoryDumpAndAppendToTrace_Params_Data* params =
          reinterpret_cast<
              internal::Coordinator_RequestGlobalMemoryDumpAndAppendToTrace_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Coordinator.3
      bool success = true;
      ::base::trace_event::MemoryDumpType p_dump_type{};
      ::base::trace_event::MemoryDumpLevelOfDetail p_level_of_detail{};
      ::base::trace_event::MemoryDumpDeterminism p_determinism{};
      Coordinator_RequestGlobalMemoryDumpAndAppendToTrace_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDumpType(&p_dump_type))
        success = false;
      if (success && !input_data_view.ReadLevelOfDetail(&p_level_of_detail))
        success = false;
      if (success && !input_data_view.ReadDeterminism(&p_determinism))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Coordinator::Name_, 3, false);
        return false;
      }
      auto callback =
          Coordinator_RequestGlobalMemoryDumpAndAppendToTrace_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestGlobalMemoryDumpAndAppendToTrace(        
        std::move(p_dump_type), 
        std::move(p_level_of_detail), 
        std::move(p_determinism), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kCoordinatorValidationInfo[] = {
    {base::to_underlying(messages::Coordinator::kRequestGlobalMemoryDump),
     { &internal::Coordinator_RequestGlobalMemoryDump_Params_Data::Validate,
      &internal::Coordinator_RequestGlobalMemoryDump_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::Coordinator::kRequestGlobalMemoryDumpForPid),
     { &internal::Coordinator_RequestGlobalMemoryDumpForPid_Params_Data::Validate,
      &internal::Coordinator_RequestGlobalMemoryDumpForPid_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::Coordinator::kRequestPrivateMemoryFootprint),
     { &internal::Coordinator_RequestPrivateMemoryFootprint_Params_Data::Validate,
      &internal::Coordinator_RequestPrivateMemoryFootprint_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::Coordinator::kRequestGlobalMemoryDumpAndAppendToTrace),
     { &internal::Coordinator_RequestGlobalMemoryDumpAndAppendToTrace_Params_Data::Validate,
      &internal::Coordinator_RequestGlobalMemoryDumpAndAppendToTrace_ResponseParams_Data::Validate}},
};

bool CoordinatorRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::memory_instrumentation::mojom::Coordinator::Name_,
    kCoordinatorValidationInfo);
}

bool CoordinatorResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGeneric(
    message,
    ::memory_instrumentation::mojom::Coordinator::Name_,
    kCoordinatorValidationInfo);

}
// The declaration includes the definition on other builds.

CoordinatorConnector::IPCStableHashFunction CoordinatorConnector::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::CoordinatorConnector>(message.name())) {
    case messages::CoordinatorConnector::kRegisterCoordinatorClient: {
      return &CoordinatorConnector::RegisterCoordinatorClient_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* CoordinatorConnector::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::CoordinatorConnector>(message.name())) {
      case messages::CoordinatorConnector::kRegisterCoordinatorClient:
            return "Receive memory_instrumentation::mojom::CoordinatorConnector::RegisterCoordinatorClient";
    }
  } else {
    switch (static_cast<messages::CoordinatorConnector>(message.name())) {
      case messages::CoordinatorConnector::kRegisterCoordinatorClient:
            return "Receive reply memory_instrumentation::mojom::CoordinatorConnector::RegisterCoordinatorClient";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t CoordinatorConnector::RegisterCoordinatorClient_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2d4dbcd9;  // IPCStableHash for memory_instrumentation::mojom::CoordinatorConnector::RegisterCoordinatorClient
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

CoordinatorConnectorProxy::CoordinatorConnectorProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CoordinatorConnectorProxy::RegisterCoordinatorClient(
    ::mojo::PendingReceiver<Coordinator> in_receiver, ::mojo::PendingRemote<ClientProcess> in_client_process) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send memory_instrumentation::mojom::CoordinatorConnector::RegisterCoordinatorClient", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<Coordinator>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client_process"), in_client_process,
                        "<value of type ::mojo::PendingRemote<ClientProcess>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CoordinatorConnector::kRegisterCoordinatorClient), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::memory_instrumentation::mojom::internal::CoordinatorConnector_RegisterCoordinatorClient_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::memory_instrumentation::mojom::CoordinatorInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in CoordinatorConnector.RegisterCoordinatorClient request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::memory_instrumentation::mojom::ClientProcessInterfaceBase>>(
    in_client_process,
    &params->client_process,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client_process)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid client_process in CoordinatorConnector.RegisterCoordinatorClient request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CoordinatorConnector::Name_);
  message.set_method_name("RegisterCoordinatorClient");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool CoordinatorConnectorStubDispatch::Accept(
    CoordinatorConnector* impl,
    mojo::Message* message) {
  switch (static_cast<messages::CoordinatorConnector>(message->header()->name)) {
    case messages::CoordinatorConnector::kRegisterCoordinatorClient: {
      DCHECK(message->is_serialized());
      internal::CoordinatorConnector_RegisterCoordinatorClient_Params_Data* params =
          reinterpret_cast<internal::CoordinatorConnector_RegisterCoordinatorClient_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CoordinatorConnector.0
      bool success = true;
      ::mojo::PendingReceiver<Coordinator> p_receiver{};
      ::mojo::PendingRemote<ClientProcess> p_client_process{};
      CoordinatorConnector_RegisterCoordinatorClient_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (success) {
        p_client_process =
            input_data_view.TakeClientProcess<decltype(p_client_process)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CoordinatorConnector::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RegisterCoordinatorClient(        
        std::move(p_receiver), 
        std::move(p_client_process));
      return true;
    }
  }
  return false;
}

// static
bool CoordinatorConnectorStubDispatch::AcceptWithResponder(
    CoordinatorConnector* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::CoordinatorConnector>(message->header()->name)) {
    case messages::CoordinatorConnector::kRegisterCoordinatorClient: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kCoordinatorConnectorValidationInfo[] = {
    {base::to_underlying(messages::CoordinatorConnector::kRegisterCoordinatorClient),
     { &internal::CoordinatorConnector_RegisterCoordinatorClient_Params_Data::Validate,
      nullptr /* no response */}},
};

bool CoordinatorConnectorRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::memory_instrumentation::mojom::CoordinatorConnector::Name_,
    kCoordinatorConnectorValidationInfo);
}



}  // memory_instrumentation::mojom


namespace mojo {


// static
bool StructTraits<::memory_instrumentation::mojom::RequestArgs::DataView, ::memory_instrumentation::mojom::RequestArgsPtr>::Read(
    ::memory_instrumentation::mojom::RequestArgs::DataView input,
    ::memory_instrumentation::mojom::RequestArgsPtr* output) {
  bool success = true;
  ::memory_instrumentation::mojom::RequestArgsPtr result(::memory_instrumentation::mojom::RequestArgs::New());
  
      if (success)
        result->dump_guid = input.dump_guid();
      if (success && !input.ReadDumpType(&result->dump_type))
        success = false;
      if (success && !input.ReadLevelOfDetail(&result->level_of_detail))
        success = false;
      if (success && !input.ReadDeterminism(&result->determinism))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::memory_instrumentation::mojom::RawAllocatorDumpEdge::DataView, ::memory_instrumentation::mojom::RawAllocatorDumpEdgePtr>::Read(
    ::memory_instrumentation::mojom::RawAllocatorDumpEdge::DataView input,
    ::memory_instrumentation::mojom::RawAllocatorDumpEdgePtr* output) {
  bool success = true;
  ::memory_instrumentation::mojom::RawAllocatorDumpEdgePtr result(::memory_instrumentation::mojom::RawAllocatorDumpEdge::New());
  
      if (success)
        result->source_id = input.source_id();
      if (success)
        result->target_id = input.target_id();
      if (success)
        result->importance = input.importance();
      if (success)
        result->overridable = input.overridable();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::memory_instrumentation::mojom::RawAllocatorDumpEntry::DataView, ::memory_instrumentation::mojom::RawAllocatorDumpEntryPtr>::Read(
    ::memory_instrumentation::mojom::RawAllocatorDumpEntry::DataView input,
    ::memory_instrumentation::mojom::RawAllocatorDumpEntryPtr* output) {
  bool success = true;
  ::memory_instrumentation::mojom::RawAllocatorDumpEntryPtr result(::memory_instrumentation::mojom::RawAllocatorDumpEntry::New());
  
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadUnits(&result->units))
        success = false;
      if (success && !input.ReadValue(&result->value))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::memory_instrumentation::mojom::RawAllocatorDump::DataView, ::memory_instrumentation::mojom::RawAllocatorDumpPtr>::Read(
    ::memory_instrumentation::mojom::RawAllocatorDump::DataView input,
    ::memory_instrumentation::mojom::RawAllocatorDumpPtr* output) {
  bool success = true;
  ::memory_instrumentation::mojom::RawAllocatorDumpPtr result(::memory_instrumentation::mojom::RawAllocatorDump::New());
  
      if (success)
        result->id = input.id();
      if (success && !input.ReadAbsoluteName(&result->absolute_name))
        success = false;
      if (success)
        result->weak = input.weak();
      if (success && !input.ReadLevelOfDetail(&result->level_of_detail))
        success = false;
      if (success && !input.ReadEntries(&result->entries))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::memory_instrumentation::mojom::RawProcessMemoryDump::DataView, ::memory_instrumentation::mojom::RawProcessMemoryDumpPtr>::Read(
    ::memory_instrumentation::mojom::RawProcessMemoryDump::DataView input,
    ::memory_instrumentation::mojom::RawProcessMemoryDumpPtr* output) {
  bool success = true;
  ::memory_instrumentation::mojom::RawProcessMemoryDumpPtr result(::memory_instrumentation::mojom::RawProcessMemoryDump::New());
  
      if (success && !input.ReadLevelOfDetail(&result->level_of_detail))
        success = false;
      if (success && !input.ReadAllocatorDumpEdges(&result->allocator_dump_edges))
        success = false;
      if (success && !input.ReadAllocatorDumps(&result->allocator_dumps))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::memory_instrumentation::mojom::VmRegion::DataView, ::memory_instrumentation::mojom::VmRegionPtr>::Read(
    ::memory_instrumentation::mojom::VmRegion::DataView input,
    ::memory_instrumentation::mojom::VmRegionPtr* output) {
  bool success = true;
  ::memory_instrumentation::mojom::VmRegionPtr result(::memory_instrumentation::mojom::VmRegion::New());
  
      if (success)
        result->start_address = input.start_address();
      if (success)
        result->size_in_bytes = input.size_in_bytes();
      if (success)
        result->module_timestamp = input.module_timestamp();
      if (success && !input.ReadModuleDebugid(&result->module_debugid))
        success = false;
      if (success && !input.ReadModuleDebugPath(&result->module_debug_path))
        success = false;
      if (success)
        result->protection_flags = input.protection_flags();
      if (success && !input.ReadMappedFile(&result->mapped_file))
        success = false;
      if (success)
        result->byte_stats_private_dirty_resident = input.byte_stats_private_dirty_resident();
      if (success)
        result->byte_stats_private_clean_resident = input.byte_stats_private_clean_resident();
      if (success)
        result->byte_stats_shared_dirty_resident = input.byte_stats_shared_dirty_resident();
      if (success)
        result->byte_stats_shared_clean_resident = input.byte_stats_shared_clean_resident();
      if (success)
        result->byte_stats_swapped = input.byte_stats_swapped();
      if (success)
        result->byte_locked = input.byte_locked();
      if (success)
        result->byte_stats_proportional_resident = input.byte_stats_proportional_resident();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::memory_instrumentation::mojom::PlatformPrivateFootprint::DataView, ::memory_instrumentation::mojom::PlatformPrivateFootprintPtr>::Read(
    ::memory_instrumentation::mojom::PlatformPrivateFootprint::DataView input,
    ::memory_instrumentation::mojom::PlatformPrivateFootprintPtr* output) {
  bool success = true;
  ::memory_instrumentation::mojom::PlatformPrivateFootprintPtr result(::memory_instrumentation::mojom::PlatformPrivateFootprint::New());
  
      if (success)
        result->phys_footprint_bytes = input.phys_footprint_bytes();
      if (success)
        result->internal_bytes = input.internal_bytes();
      if (success)
        result->compressed_bytes = input.compressed_bytes();
      if (success)
        result->rss_anon_bytes = input.rss_anon_bytes();
      if (success)
        result->vm_swap_bytes = input.vm_swap_bytes();
      if (success)
        result->private_bytes = input.private_bytes();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::memory_instrumentation::mojom::RawOSMemDump::DataView, ::memory_instrumentation::mojom::RawOSMemDumpPtr>::Read(
    ::memory_instrumentation::mojom::RawOSMemDump::DataView input,
    ::memory_instrumentation::mojom::RawOSMemDumpPtr* output) {
  bool success = true;
  ::memory_instrumentation::mojom::RawOSMemDumpPtr result(::memory_instrumentation::mojom::RawOSMemDump::New());
  
      if (success)
        result->resident_set_kb = input.resident_set_kb();
      if (success)
        result->peak_resident_set_kb = input.peak_resident_set_kb();
      if (success)
        result->is_peak_rss_resettable = input.is_peak_rss_resettable();
      if (success && !input.ReadPlatformPrivateFootprint(&result->platform_private_footprint))
        success = false;
      if (success && !input.ReadMemoryMaps(&result->memory_maps))
        success = false;
      if (success && !input.ReadNativeLibraryPagesBitmap(&result->native_library_pages_bitmap))
        success = false;
      if (success)
        result->mappings_count = input.mappings_count();
      if (success)
        result->pss_kb = input.pss_kb();
      if (success)
        result->swap_pss_kb = input.swap_pss_kb();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::memory_instrumentation::mojom::OSMemDump::DataView, ::memory_instrumentation::mojom::OSMemDumpPtr>::Read(
    ::memory_instrumentation::mojom::OSMemDump::DataView input,
    ::memory_instrumentation::mojom::OSMemDumpPtr* output) {
  bool success = true;
  ::memory_instrumentation::mojom::OSMemDumpPtr result(::memory_instrumentation::mojom::OSMemDump::New());
  
      if (success)
        result->resident_set_kb = input.resident_set_kb();
      if (success)
        result->peak_resident_set_kb = input.peak_resident_set_kb();
      if (success)
        result->is_peak_rss_resettable = input.is_peak_rss_resettable();
      if (success)
        result->private_footprint_kb = input.private_footprint_kb();
      if (success)
        result->shared_footprint_kb = input.shared_footprint_kb();
      if (success)
        result->private_footprint_swap_kb = input.private_footprint_swap_kb();
      if (success)
        result->mappings_count = input.mappings_count();
      if (success)
        result->pss_kb = input.pss_kb();
      if (success)
        result->swap_pss_kb = input.swap_pss_kb();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::memory_instrumentation::mojom::AllocatorMemDump::DataView, ::memory_instrumentation::mojom::AllocatorMemDumpPtr>::Read(
    ::memory_instrumentation::mojom::AllocatorMemDump::DataView input,
    ::memory_instrumentation::mojom::AllocatorMemDumpPtr* output) {
  bool success = true;
  ::memory_instrumentation::mojom::AllocatorMemDumpPtr result(::memory_instrumentation::mojom::AllocatorMemDump::New());
  
      if (success && !input.ReadNumericEntries(&result->numeric_entries))
        success = false;
      if (success && !input.ReadChildren(&result->children))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::memory_instrumentation::mojom::ProcessMemoryDump::DataView, ::memory_instrumentation::mojom::ProcessMemoryDumpPtr>::Read(
    ::memory_instrumentation::mojom::ProcessMemoryDump::DataView input,
    ::memory_instrumentation::mojom::ProcessMemoryDumpPtr* output) {
  bool success = true;
  ::memory_instrumentation::mojom::ProcessMemoryDumpPtr result(::memory_instrumentation::mojom::ProcessMemoryDump::New());
  
      if (success && !input.ReadProcessType(&result->process_type))
        success = false;
      if (success && !input.ReadOsDump(&result->os_dump))
        success = false;
      if (success && !input.ReadChromeAllocatorDumps(&result->chrome_allocator_dumps))
        success = false;
      if (success && !input.ReadPid(&result->pid))
        success = false;
      if (success && !input.ReadServiceName(&result->service_name))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::memory_instrumentation::mojom::AggregatedMetrics::DataView, ::memory_instrumentation::mojom::AggregatedMetricsPtr>::Read(
    ::memory_instrumentation::mojom::AggregatedMetrics::DataView input,
    ::memory_instrumentation::mojom::AggregatedMetricsPtr* output) {
  bool success = true;
  ::memory_instrumentation::mojom::AggregatedMetricsPtr result(::memory_instrumentation::mojom::AggregatedMetrics::New());
  
      if (success)
        result->native_library_resident_kb = input.native_library_resident_kb();
      if (success)
        result->native_library_resident_not_ordered_kb = input.native_library_resident_not_ordered_kb();
      if (success)
        result->native_library_not_resident_ordered_kb = input.native_library_not_resident_ordered_kb();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::memory_instrumentation::mojom::GlobalMemoryDump::DataView, ::memory_instrumentation::mojom::GlobalMemoryDumpPtr>::Read(
    ::memory_instrumentation::mojom::GlobalMemoryDump::DataView input,
    ::memory_instrumentation::mojom::GlobalMemoryDumpPtr* output) {
  bool success = true;
  ::memory_instrumentation::mojom::GlobalMemoryDumpPtr result(::memory_instrumentation::mojom::GlobalMemoryDump::New());
  
      if (success && !input.ReadStartTime(&result->start_time))
        success = false;
      if (success && !input.ReadProcessDumps(&result->process_dumps))
        success = false;
      if (success && !input.ReadAggregatedMetrics(&result->aggregated_metrics))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::memory_instrumentation::mojom::HeapProfileResult::DataView, ::memory_instrumentation::mojom::HeapProfileResultPtr>::Read(
    ::memory_instrumentation::mojom::HeapProfileResult::DataView input,
    ::memory_instrumentation::mojom::HeapProfileResultPtr* output) {
  bool success = true;
  ::memory_instrumentation::mojom::HeapProfileResultPtr result(::memory_instrumentation::mojom::HeapProfileResult::New());
  
      if (success && !input.ReadPid(&result->pid))
        success = false;
      if (success && !input.ReadJson(&result->json))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::memory_instrumentation::mojom::RawAllocatorDumpEntryValue::DataView, ::memory_instrumentation::mojom::RawAllocatorDumpEntryValuePtr>::Read(
    ::memory_instrumentation::mojom::RawAllocatorDumpEntryValue::DataView input,
    ::memory_instrumentation::mojom::RawAllocatorDumpEntryValuePtr* output) {
  using UnionType = ::memory_instrumentation::mojom::RawAllocatorDumpEntryValue;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kValueUint64: {
      *output = UnionType::NewValueUint64(input.value_uint64());
      break;
    }
    case Tag::kValueString: {
      std::string result_value_string{};
      if (!input.ReadValueString(&result_value_string))
        return false;

      *output = UnionType::NewValueString(
          std::move(result_value_string));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace memory_instrumentation::mojom {


void ClientProcessInterceptorForTesting::RequestChromeMemoryDump(const ::base::trace_event::MemoryDumpRequestArgs& args, RequestChromeMemoryDumpCallback callback) {
  GetForwardingInterface()->RequestChromeMemoryDump(
    std::move(args)
    , std::move(callback));
}
void ClientProcessInterceptorForTesting::RequestOSMemoryDump(MemoryMapOption option, const std::vector<MemDumpFlags>& flags, const std::vector<::base::ProcessId>& pids, RequestOSMemoryDumpCallback callback) {
  GetForwardingInterface()->RequestOSMemoryDump(
    std::move(option)
    , 
    std::move(flags)
    , 
    std::move(pids)
    , std::move(callback));
}
ClientProcessAsyncWaiter::ClientProcessAsyncWaiter(
    ClientProcess* proxy) : proxy_(proxy) {}

ClientProcessAsyncWaiter::~ClientProcessAsyncWaiter() = default;


void ClientProcessAsyncWaiter::RequestChromeMemoryDump(
    const ::base::trace_event::MemoryDumpRequestArgs& args, bool* out_success, uint64_t* out_dump_id, ::std::unique_ptr<::base::trace_event::ProcessMemoryDump>* out_raw_process_memory_dump) {
  base::RunLoop loop;
  proxy_->RequestChromeMemoryDump(
      std::move(args),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             uint64_t* out_dump_id
,
             ::std::unique_ptr<::base::trace_event::ProcessMemoryDump>* out_raw_process_memory_dump
,
             bool success,
             uint64_t dump_id,
             ::std::unique_ptr<::base::trace_event::ProcessMemoryDump> raw_process_memory_dump) {*out_success = std::move(success);*out_dump_id = std::move(dump_id);*out_raw_process_memory_dump = std::move(raw_process_memory_dump);
            loop->Quit();
          },
          &loop,
          out_success,
          out_dump_id,
          out_raw_process_memory_dump));
  loop.Run();
}



void ClientProcessAsyncWaiter::RequestOSMemoryDump(
    MemoryMapOption option, const std::vector<MemDumpFlags>& flags, const std::vector<::base::ProcessId>& pids, bool* out_success, base::flat_map<::base::ProcessId, RawOSMemDumpPtr>* out_dumps) {
  base::RunLoop loop;
  proxy_->RequestOSMemoryDump(
      std::move(option),
      std::move(flags),
      std::move(pids),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             base::flat_map<::base::ProcessId, RawOSMemDumpPtr>* out_dumps
,
             bool success,
             base::flat_map<::base::ProcessId, RawOSMemDumpPtr> dumps) {*out_success = std::move(success);*out_dumps = std::move(dumps);
            loop->Quit();
          },
          &loop,
          out_success,
          out_dumps));
  loop.Run();
}






void HeapProfilerInterceptorForTesting::DumpProcessesForTracing(bool strip_path_from_mapped_files, bool write_proto, DumpProcessesForTracingCallback callback) {
  GetForwardingInterface()->DumpProcessesForTracing(
    std::move(strip_path_from_mapped_files)
    , 
    std::move(write_proto)
    , std::move(callback));
}
HeapProfilerAsyncWaiter::HeapProfilerAsyncWaiter(
    HeapProfiler* proxy) : proxy_(proxy) {}

HeapProfilerAsyncWaiter::~HeapProfilerAsyncWaiter() = default;


void HeapProfilerAsyncWaiter::DumpProcessesForTracing(
    bool strip_path_from_mapped_files, bool write_proto, std::vector<HeapProfileResultPtr>* out_results) {
  base::RunLoop loop;
  proxy_->DumpProcessesForTracing(
      std::move(strip_path_from_mapped_files),
      std::move(write_proto),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<HeapProfileResultPtr>* out_results
,
             std::vector<HeapProfileResultPtr> results) {*out_results = std::move(results);
            loop->Quit();
          },
          &loop,
          out_results));
  loop.Run();
}

std::vector<HeapProfileResultPtr> HeapProfilerAsyncWaiter::DumpProcessesForTracing(
    bool strip_path_from_mapped_files, bool write_proto) {
  std::vector<HeapProfileResultPtr> async_wait_result;
  DumpProcessesForTracing(std::move(strip_path_from_mapped_files),std::move(write_proto),&async_wait_result);
  return async_wait_result;
}




void HeapProfilerHelperInterceptorForTesting::GetVmRegionsForHeapProfiler(const std::vector<::base::ProcessId>& pids, GetVmRegionsForHeapProfilerCallback callback) {
  GetForwardingInterface()->GetVmRegionsForHeapProfiler(
    std::move(pids)
    , std::move(callback));
}
HeapProfilerHelperAsyncWaiter::HeapProfilerHelperAsyncWaiter(
    HeapProfilerHelper* proxy) : proxy_(proxy) {}

HeapProfilerHelperAsyncWaiter::~HeapProfilerHelperAsyncWaiter() = default;


void HeapProfilerHelperAsyncWaiter::GetVmRegionsForHeapProfiler(
    const std::vector<::base::ProcessId>& pids, base::flat_map<::base::ProcessId, std::vector<VmRegionPtr>>* out_vm_regions) {
  base::RunLoop loop;
  proxy_->GetVmRegionsForHeapProfiler(
      std::move(pids),
      base::BindOnce(
          [](base::RunLoop* loop,
             base::flat_map<::base::ProcessId, std::vector<VmRegionPtr>>* out_vm_regions
,
             base::flat_map<::base::ProcessId, std::vector<VmRegionPtr>> vm_regions) {*out_vm_regions = std::move(vm_regions);
            loop->Quit();
          },
          &loop,
          out_vm_regions));
  loop.Run();
}

base::flat_map<::base::ProcessId, std::vector<VmRegionPtr>> HeapProfilerHelperAsyncWaiter::GetVmRegionsForHeapProfiler(
    const std::vector<::base::ProcessId>& pids) {
  base::flat_map<::base::ProcessId, std::vector<VmRegionPtr>> async_wait_result;
  GetVmRegionsForHeapProfiler(std::move(pids),&async_wait_result);
  return async_wait_result;
}




void CoordinatorInterceptorForTesting::RequestGlobalMemoryDump(::base::trace_event::MemoryDumpType dump_type, ::base::trace_event::MemoryDumpLevelOfDetail level_of_detail, ::base::trace_event::MemoryDumpDeterminism determinism, const std::vector<std::string>& allocator_dump_names, RequestGlobalMemoryDumpCallback callback) {
  GetForwardingInterface()->RequestGlobalMemoryDump(
    std::move(dump_type)
    , 
    std::move(level_of_detail)
    , 
    std::move(determinism)
    , 
    std::move(allocator_dump_names)
    , std::move(callback));
}
void CoordinatorInterceptorForTesting::RequestGlobalMemoryDumpForPid(::base::ProcessId pid, const std::vector<std::string>& allocator_dump_names, RequestGlobalMemoryDumpForPidCallback callback) {
  GetForwardingInterface()->RequestGlobalMemoryDumpForPid(
    std::move(pid)
    , 
    std::move(allocator_dump_names)
    , std::move(callback));
}
void CoordinatorInterceptorForTesting::RequestPrivateMemoryFootprint(::base::ProcessId pid, RequestPrivateMemoryFootprintCallback callback) {
  GetForwardingInterface()->RequestPrivateMemoryFootprint(
    std::move(pid)
    , std::move(callback));
}
void CoordinatorInterceptorForTesting::RequestGlobalMemoryDumpAndAppendToTrace(::base::trace_event::MemoryDumpType dump_type, ::base::trace_event::MemoryDumpLevelOfDetail level_of_detail, ::base::trace_event::MemoryDumpDeterminism determinism, RequestGlobalMemoryDumpAndAppendToTraceCallback callback) {
  GetForwardingInterface()->RequestGlobalMemoryDumpAndAppendToTrace(
    std::move(dump_type)
    , 
    std::move(level_of_detail)
    , 
    std::move(determinism)
    , std::move(callback));
}
CoordinatorAsyncWaiter::CoordinatorAsyncWaiter(
    Coordinator* proxy) : proxy_(proxy) {}

CoordinatorAsyncWaiter::~CoordinatorAsyncWaiter() = default;


void CoordinatorAsyncWaiter::RequestGlobalMemoryDump(
    ::base::trace_event::MemoryDumpType dump_type, ::base::trace_event::MemoryDumpLevelOfDetail level_of_detail, ::base::trace_event::MemoryDumpDeterminism determinism, const std::vector<std::string>& allocator_dump_names, bool* out_success, GlobalMemoryDumpPtr* out_global_memory_dump) {
  base::RunLoop loop;
  proxy_->RequestGlobalMemoryDump(
      std::move(dump_type),
      std::move(level_of_detail),
      std::move(determinism),
      std::move(allocator_dump_names),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             GlobalMemoryDumpPtr* out_global_memory_dump
,
             bool success,
             GlobalMemoryDumpPtr global_memory_dump) {*out_success = std::move(success);*out_global_memory_dump = std::move(global_memory_dump);
            loop->Quit();
          },
          &loop,
          out_success,
          out_global_memory_dump));
  loop.Run();
}



void CoordinatorAsyncWaiter::RequestGlobalMemoryDumpForPid(
    ::base::ProcessId pid, const std::vector<std::string>& allocator_dump_names, bool* out_success, GlobalMemoryDumpPtr* out_global_memory_dump) {
  base::RunLoop loop;
  proxy_->RequestGlobalMemoryDumpForPid(
      std::move(pid),
      std::move(allocator_dump_names),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             GlobalMemoryDumpPtr* out_global_memory_dump
,
             bool success,
             GlobalMemoryDumpPtr global_memory_dump) {*out_success = std::move(success);*out_global_memory_dump = std::move(global_memory_dump);
            loop->Quit();
          },
          &loop,
          out_success,
          out_global_memory_dump));
  loop.Run();
}



void CoordinatorAsyncWaiter::RequestPrivateMemoryFootprint(
    ::base::ProcessId pid, bool* out_success, GlobalMemoryDumpPtr* out_global_memory_dump) {
  base::RunLoop loop;
  proxy_->RequestPrivateMemoryFootprint(
      std::move(pid),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             GlobalMemoryDumpPtr* out_global_memory_dump
,
             bool success,
             GlobalMemoryDumpPtr global_memory_dump) {*out_success = std::move(success);*out_global_memory_dump = std::move(global_memory_dump);
            loop->Quit();
          },
          &loop,
          out_success,
          out_global_memory_dump));
  loop.Run();
}



void CoordinatorAsyncWaiter::RequestGlobalMemoryDumpAndAppendToTrace(
    ::base::trace_event::MemoryDumpType dump_type, ::base::trace_event::MemoryDumpLevelOfDetail level_of_detail, ::base::trace_event::MemoryDumpDeterminism determinism, bool* out_success, uint64_t* out_dump_id) {
  base::RunLoop loop;
  proxy_->RequestGlobalMemoryDumpAndAppendToTrace(
      std::move(dump_type),
      std::move(level_of_detail),
      std::move(determinism),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             uint64_t* out_dump_id
,
             bool success,
             uint64_t dump_id) {*out_success = std::move(success);*out_dump_id = std::move(dump_id);
            loop->Quit();
          },
          &loop,
          out_success,
          out_dump_id));
  loop.Run();
}






void CoordinatorConnectorInterceptorForTesting::RegisterCoordinatorClient(::mojo::PendingReceiver<Coordinator> receiver, ::mojo::PendingRemote<ClientProcess> client_process) {
  GetForwardingInterface()->RegisterCoordinatorClient(
    std::move(receiver)
    , 
    std::move(client_process)
    );
}
CoordinatorConnectorAsyncWaiter::CoordinatorConnectorAsyncWaiter(
    CoordinatorConnector* proxy) : proxy_(proxy) {}

CoordinatorConnectorAsyncWaiter::~CoordinatorConnectorAsyncWaiter() = default;







}  // memory_instrumentation::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif