// services/service_manager/public/mojom/connector.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_SERVICE_MANAGER_PUBLIC_MOJOM_CONNECTOR_MOJOM_SHARED_H_
#define SERVICES_SERVICE_MANAGER_PUBLIC_MOJOM_CONNECTOR_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/service_manager/public/mojom/connector.mojom-shared-internal.h"
#include "mojo/public/mojom/base/process_id.mojom-shared.h"
#include "mojo/public/mojom/base/token.mojom-shared.h"
#include "services/service_manager/public/mojom/constants.mojom-shared.h"
#include "services/service_manager/public/mojom/interface_provider.mojom-shared.h"
#include "services/service_manager/public/mojom/service_filter.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "services/service_manager/public/mojom/connector.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

template <>
struct hash<::service_manager::mojom::ConnectResult>
    : public mojo::internal::EnumHashImpl<::service_manager::mojom::ConnectResult> {};

template <>
struct hash<::service_manager::mojom::BindInterfacePriority>
    : public mojo::internal::EnumHashImpl<::service_manager::mojom::BindInterfacePriority> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::service_manager::mojom::ConnectResult, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::service_manager::mojom::ConnectResult, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::service_manager::mojom::ConnectResult>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::service_manager::mojom::BindInterfacePriority, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::service_manager::mojom::BindInterfacePriority, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::service_manager::mojom::BindInterfacePriority>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::service_manager::mojom::IdentityDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::service_manager::mojom::IdentityDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::service_manager::mojom::internal::Identity_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_name,
      name_fragment);

    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in Identity struct");

    decltype(Traits::instance_group(input)) in_instance_group = Traits::instance_group(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->instance_group)::BaseType> instance_group_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TokenDataView>(
      in_instance_group,
      instance_group_fragment);

    fragment->instance_group.Set(
        instance_group_fragment.is_null() ? nullptr : instance_group_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->instance_group.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null instance_group in Identity struct");

    decltype(Traits::instance_id(input)) in_instance_id = Traits::instance_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->instance_id)::BaseType> instance_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TokenDataView>(
      in_instance_id,
      instance_id_fragment);

    fragment->instance_id.Set(
        instance_id_fragment.is_null() ? nullptr : instance_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->instance_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null instance_id in Identity struct");

    decltype(Traits::globally_unique_id(input)) in_globally_unique_id = Traits::globally_unique_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->globally_unique_id)::BaseType> globally_unique_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TokenDataView>(
      in_globally_unique_id,
      globally_unique_id_fragment);

    fragment->globally_unique_id.Set(
        globally_unique_id_fragment.is_null() ? nullptr : globally_unique_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->globally_unique_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null globally_unique_id in Identity struct");
  }

  static bool Deserialize(::service_manager::mojom::internal::Identity_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::service_manager::mojom::IdentityDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::service_manager::mojom::ServiceInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::service_manager::mojom::ServiceInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::service_manager::mojom::internal::ServiceInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::sandbox_type(input)) in_sandbox_type = Traits::sandbox_type(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->sandbox_type)::BaseType> sandbox_type_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_sandbox_type,
      sandbox_type_fragment);

    fragment->sandbox_type.Set(
        sandbox_type_fragment.is_null() ? nullptr : sandbox_type_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->sandbox_type.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null sandbox_type in ServiceInfo struct");
  }

  static bool Deserialize(::service_manager::mojom::internal::ServiceInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::service_manager::mojom::ServiceInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace service_manager::mojom {

inline void IdentityDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void IdentityDataView::GetInstanceGroupDataView(
    ::mojo_base::mojom::TokenDataView* output) {
  auto pointer = data_->instance_group.Get();
  *output = ::mojo_base::mojom::TokenDataView(pointer, message_);
}
inline void IdentityDataView::GetInstanceIdDataView(
    ::mojo_base::mojom::TokenDataView* output) {
  auto pointer = data_->instance_id.Get();
  *output = ::mojo_base::mojom::TokenDataView(pointer, message_);
}
inline void IdentityDataView::GetGloballyUniqueIdDataView(
    ::mojo_base::mojom::TokenDataView* output) {
  auto pointer = data_->globally_unique_id.Get();
  *output = ::mojo_base::mojom::TokenDataView(pointer, message_);
}


inline void ServiceInfoDataView::GetSandboxTypeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->sandbox_type.Get();
  *output = mojo::StringDataView(pointer, message_);
}



}  // service_manager::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(SERVICE_MANAGER_MOJOM_SHARED) TraceFormatTraits<::service_manager::mojom::ConnectResult> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::service_manager::mojom::ConnectResult value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(SERVICE_MANAGER_MOJOM_SHARED) TraceFormatTraits<::service_manager::mojom::BindInterfacePriority> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::service_manager::mojom::BindInterfacePriority value);
};

} // namespace perfetto

#endif  // SERVICES_SERVICE_MANAGER_PUBLIC_MOJOM_CONNECTOR_MOJOM_SHARED_H_