// services/viz/public/mojom/compositing/frame_interval_inputs.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_FRAME_INTERVAL_INPUTS_MOJOM_DATA_VIEW_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_FRAME_INTERVAL_INPUTS_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "services/viz/public/mojom/compositing/frame_interval_inputs.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"


namespace viz::mojom {
class ContentFrameIntervalInfoDataView;

class FrameIntervalInputsDataView;



}  // viz::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::viz::mojom::ContentFrameIntervalInfoDataView> {
  using Data = ::viz::mojom::internal::ContentFrameIntervalInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::FrameIntervalInputsDataView> {
  using Data = ::viz::mojom::internal::FrameIntervalInputs_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace viz::mojom {


enum class ContentFrameIntervalType : int32_t {
  
  kVideo = 0,
  
  kAnimatingImage = 1,
  
  kScrollBarFadeOutAnimation = 2,
  
  kCompositorScroll = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, ContentFrameIntervalType value);
inline bool IsKnownEnumValue(ContentFrameIntervalType value) {
  return internal::ContentFrameIntervalType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class ContentFrameIntervalInfoDataView {
 public:
  ContentFrameIntervalInfoDataView() = default;

  ContentFrameIntervalInfoDataView(
      internal::ContentFrameIntervalInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::viz::mojom::ContentFrameIntervalType>(
        data_value, output);
  }
  ContentFrameIntervalType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::viz::mojom::ContentFrameIntervalType>(data_->type));
  }
  inline void GetFrameIntervalDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrameInterval(UserType* output) {
    
    auto* pointer = data_->frame_interval.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  uint32_t duplicate_count() const {
    return data_->duplicate_count;
  }
 private:
  internal::ContentFrameIntervalInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FrameIntervalInputsDataView {
 public:
  FrameIntervalInputsDataView() = default;

  FrameIntervalInputsDataView(
      internal::FrameIntervalInputs_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFrameTimeDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrameTime(UserType* output) {
    
    auto* pointer = data_->frame_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  bool has_user_input() const {
    return data_->has_user_input;
  }
  bool has_input() const {
    return data_->has_input;
  }
  float major_scroll_speed_in_pixels_per_second() const {
    return data_->major_scroll_speed_in_pixels_per_second;
  }
  inline void GetContentIntervalInfoDataView(
      mojo::ArrayDataView<ContentFrameIntervalInfoDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContentIntervalInfo(UserType* output) {
    
    auto* pointer = data_->content_interval_info.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::viz::mojom::ContentFrameIntervalInfoDataView>>(
        pointer, output, message_);
  }
  bool has_only_content_frame_interval_updates() const {
    return data_->has_only_content_frame_interval_updates;
  }
 private:
  internal::FrameIntervalInputs_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // viz::mojom

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_FRAME_INTERVAL_INPUTS_MOJOM_DATA_VIEW_H_