// services/viz/public/mojom/gpu.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_GPU_MOJOM_PARAMS_DATA_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_GPU_MOJOM_PARAMS_DATA_H_

#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace viz::mojom {
namespace internal {
class  Gpu_EstablishGpuChannel_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<Gpu_EstablishGpuChannel_Params_Data>;

  Gpu_EstablishGpuChannel_Params_Data();
  ~Gpu_EstablishGpuChannel_Params_Data() = delete;
};
static_assert(sizeof(Gpu_EstablishGpuChannel_Params_Data) == 8,
              "Bad sizeof(Gpu_EstablishGpuChannel_Params_Data)");
class  Gpu_EstablishGpuChannel_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t client_id;
  mojo::internal::Handle_Data channel_handle;
  mojo::internal::Pointer<::gpu::mojom::internal::GpuInfo_Data> gpu_info;
  mojo::internal::Pointer<::gpu::mojom::internal::GpuFeatureInfo_Data> gpu_feature_info;
  mojo::internal::Pointer<::gpu::mojom::internal::SharedImageCapabilities_Data> shared_image_capabilities;

 private:
  friend class mojo::internal::MessageFragment<Gpu_EstablishGpuChannel_ResponseParams_Data>;

  Gpu_EstablishGpuChannel_ResponseParams_Data();
  ~Gpu_EstablishGpuChannel_ResponseParams_Data() = delete;
};
static_assert(sizeof(Gpu_EstablishGpuChannel_ResponseParams_Data) == 40,
              "Bad sizeof(Gpu_EstablishGpuChannel_ResponseParams_Data)");
class  Gpu_CreateVideoEncodeAcceleratorProvider_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Handle_Data vea_provider;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<Gpu_CreateVideoEncodeAcceleratorProvider_Params_Data>;

  Gpu_CreateVideoEncodeAcceleratorProvider_Params_Data();
  ~Gpu_CreateVideoEncodeAcceleratorProvider_Params_Data() = delete;
};
static_assert(sizeof(Gpu_CreateVideoEncodeAcceleratorProvider_Params_Data) == 16,
              "Bad sizeof(Gpu_CreateVideoEncodeAcceleratorProvider_Params_Data)");

}  // namespace internal


class Gpu_EstablishGpuChannel_ParamsDataView {
 public:
  Gpu_EstablishGpuChannel_ParamsDataView() = default;

  Gpu_EstablishGpuChannel_ParamsDataView(
      internal::Gpu_EstablishGpuChannel_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::Gpu_EstablishGpuChannel_Params_Data* data_ = nullptr;
};


class Gpu_EstablishGpuChannel_ResponseParamsDataView {
 public:
  Gpu_EstablishGpuChannel_ResponseParamsDataView() = default;

  Gpu_EstablishGpuChannel_ResponseParamsDataView(
      internal::Gpu_EstablishGpuChannel_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t client_id() const {
    return data_->client_id;
  }
  mojo::ScopedMessagePipeHandle TakeChannelHandle() {
    mojo::ScopedMessagePipeHandle result;
    bool ret =
        mojo::internal::Deserialize<mojo::ScopedMessagePipeHandle>(
            &data_->channel_handle, &result, message_);
    DCHECK(ret);
    return result;
  }
  inline void GetGpuInfoDataView(
      ::gpu::mojom::GpuInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGpuInfo(UserType* output) {
    
    auto* pointer = data_->gpu_info.Get();
    return mojo::internal::Deserialize<::gpu::mojom::GpuInfoDataView>(
        pointer, output, message_);
  }
  inline void GetGpuFeatureInfoDataView(
      ::gpu::mojom::GpuFeatureInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGpuFeatureInfo(UserType* output) {
    
    auto* pointer = data_->gpu_feature_info.Get();
    return mojo::internal::Deserialize<::gpu::mojom::GpuFeatureInfoDataView>(
        pointer, output, message_);
  }
  inline void GetSharedImageCapabilitiesDataView(
      ::gpu::mojom::SharedImageCapabilitiesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSharedImageCapabilities(UserType* output) {
    
    auto* pointer = data_->shared_image_capabilities.Get();
    return mojo::internal::Deserialize<::gpu::mojom::SharedImageCapabilitiesDataView>(
        pointer, output, message_);
  }
 private:
  internal::Gpu_EstablishGpuChannel_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Gpu_CreateVideoEncodeAcceleratorProvider_ParamsDataView {
 public:
  Gpu_CreateVideoEncodeAcceleratorProvider_ParamsDataView() = default;

  Gpu_CreateVideoEncodeAcceleratorProvider_ParamsDataView(
      internal::Gpu_CreateVideoEncodeAcceleratorProvider_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeVeaProvider() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::media::mojom::VideoEncodeAcceleratorProviderInterfaceBase>>(
            &data_->vea_provider, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::Gpu_CreateVideoEncodeAcceleratorProvider_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



inline void Gpu_EstablishGpuChannel_ResponseParamsDataView::GetGpuInfoDataView(
    ::gpu::mojom::GpuInfoDataView* output) {
  auto pointer = data_->gpu_info.Get();
  *output = ::gpu::mojom::GpuInfoDataView(pointer, message_);
}
inline void Gpu_EstablishGpuChannel_ResponseParamsDataView::GetGpuFeatureInfoDataView(
    ::gpu::mojom::GpuFeatureInfoDataView* output) {
  auto pointer = data_->gpu_feature_info.Get();
  *output = ::gpu::mojom::GpuFeatureInfoDataView(pointer, message_);
}
inline void Gpu_EstablishGpuChannel_ResponseParamsDataView::GetSharedImageCapabilitiesDataView(
    ::gpu::mojom::SharedImageCapabilitiesDataView* output) {
  auto pointer = data_->shared_image_capabilities.Get();
  *output = ::gpu::mojom::SharedImageCapabilitiesDataView(pointer, message_);
}





}  // viz::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_GPU_MOJOM_PARAMS_DATA_H_