// third_party/blink/public/mojom/blob/blob.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_BLOB_BLOB_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_BLOB_BLOB_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/blob/blob.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/blob/blob.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/blob/blob.mojom-blink-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/big_buffer.mojom-blink.h"
#include "mojo/public/mojom/base/time.mojom-blink.h"
#include "services/network/public/mojom/data_pipe_getter.mojom-blink-forward.h"
#include "services/network/public/mojom/http_request_headers.mojom-blink.h"
#include "services/network/public/mojom/url_loader.mojom-blink-forward.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/renderer/platform/platform_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {

class BlobReaderClientProxy;

template <typename ImplRefTraits>
class BlobReaderClientStub;

class BlobReaderClientRequestValidator;


class PLATFORM_EXPORT BlobReaderClient
    : public BlobReaderClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.BlobReaderClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = BlobReaderClientInterfaceBase;
  using Proxy_ = BlobReaderClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = BlobReaderClientStub<ImplRefTraits>;

  using RequestValidator_ = BlobReaderClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnCalculatedSizeMinVersion = 0,
    kOnCompleteMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnCalculatedSize_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnComplete_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~BlobReaderClient() = default;

  virtual void OnCalculatedSize(uint64_t total_size, uint64_t expected_content_size) = 0;

  virtual void OnComplete(int32_t status, uint64_t data_length) = 0;
};

class BlobProxy;

template <typename ImplRefTraits>
class BlobStub;

class BlobRequestValidator;
class BlobResponseValidator;


class PLATFORM_EXPORT Blob
    : public BlobInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.Blob";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static inline constexpr uint32_t kSyncMethodOrdinals[] = {
    6
  };
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = BlobInterfaceBase;
  using Proxy_ = BlobProxy;

  template <typename ImplRefTraits>
  using Stub_ = BlobStub<ImplRefTraits>;

  using RequestValidator_ = BlobRequestValidator;
  using ResponseValidator_ = BlobResponseValidator;
  enum MethodMinVersions : uint32_t {
    kCloneMinVersion = 0,
    kAsDataPipeGetterMinVersion = 0,
    kReadAllMinVersion = 0,
    kReadRangeMinVersion = 0,
    kLoadMinVersion = 0,
    kReadSideDataMinVersion = 0,
    kCaptureSnapshotMinVersion = 0,
    kGetInternalUUIDMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Clone_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AsDataPipeGetter_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ReadAll_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ReadRange_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Load_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ReadSideData_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CaptureSnapshot_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetInternalUUID_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~Blob() = default;

  virtual void Clone(::mojo::PendingReceiver<Blob> blob) = 0;

  virtual void AsDataPipeGetter(::mojo::PendingReceiver<::network::mojom::blink::DataPipeGetter> data_pipe_getter) = 0;

  virtual void ReadAll(::mojo::ScopedDataPipeProducerHandle pipe, ::mojo::PendingRemote<BlobReaderClient> client) = 0;

  virtual void ReadRange(uint64_t offset, uint64_t length, ::mojo::ScopedDataPipeProducerHandle pipe, ::mojo::PendingRemote<BlobReaderClient> client) = 0;

  virtual void Load(::mojo::PendingReceiver<::network::mojom::blink::URLLoader> loader, const ::blink::String& request_method, const ::net::HttpRequestHeaders& headers, ::mojo::PendingRemote<::network::mojom::blink::URLLoaderClient> client) = 0;

  using ReadSideDataCallback = base::OnceCallback<void(std::optional<::mojo_base::BigBuffer>)>;
  using ReadSideDataMojoCallback = base::OnceCallback<void(std::optional<::mojo_base::BigBuffer>)>;

  virtual void ReadSideData(ReadSideDataCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool CaptureSnapshot(uint64_t* out_length, std::optional<::base::Time>* out_modification_time);
  using CaptureSnapshotCallback = base::OnceCallback<void(uint64_t, std::optional<::base::Time>)>;
  using CaptureSnapshotMojoCallback = base::OnceCallback<void(uint64_t, std::optional<::base::Time>)>;

  virtual void CaptureSnapshot(CaptureSnapshotCallback callback) = 0;

  using GetInternalUUIDCallback = base::OnceCallback<void(const ::blink::String&)>;
  using GetInternalUUIDMojoCallback = base::OnceCallback<void(const ::blink::String&)>;

  virtual void GetInternalUUID(GetInternalUUIDCallback callback) = 0;
};



class PLATFORM_EXPORT BlobReaderClientProxy
    : public BlobReaderClient {
 public:
  using InterfaceType = BlobReaderClient;

  explicit BlobReaderClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnCalculatedSize(uint64_t total_size, uint64_t expected_content_size) final;
  
  void OnComplete(int32_t status, uint64_t data_length) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class PLATFORM_EXPORT BlobProxy
    : public Blob {
 public:
  using InterfaceType = Blob;

  explicit BlobProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Clone(::mojo::PendingReceiver<Blob> blob) final;
  
  void AsDataPipeGetter(::mojo::PendingReceiver<::network::mojom::blink::DataPipeGetter> data_pipe_getter) final;
  
  void ReadAll(::mojo::ScopedDataPipeProducerHandle pipe, ::mojo::PendingRemote<BlobReaderClient> client) final;
  
  void ReadRange(uint64_t offset, uint64_t length, ::mojo::ScopedDataPipeProducerHandle pipe, ::mojo::PendingRemote<BlobReaderClient> client) final;
  
  void Load(::mojo::PendingReceiver<::network::mojom::blink::URLLoader> loader, const ::blink::String& request_method, const ::net::HttpRequestHeaders& headers, ::mojo::PendingRemote<::network::mojom::blink::URLLoaderClient> client) final;
  
  void ReadSideData(ReadSideDataCallback callback) final;
  
  bool CaptureSnapshot(uint64_t* out_length, std::optional<::base::Time>* out_modification_time) final;
  
  void CaptureSnapshot(CaptureSnapshotCallback callback) final;
  
  void GetInternalUUID(GetInternalUUIDCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class PLATFORM_EXPORT BlobReaderClientStubDispatch {
 public:
  static bool Accept(BlobReaderClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      BlobReaderClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<BlobReaderClient>>
class BlobReaderClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  BlobReaderClientStub() = default;
  ~BlobReaderClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return BlobReaderClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return BlobReaderClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT BlobStubDispatch {
 public:
  static bool Accept(Blob* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Blob* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Blob>>
class BlobStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  BlobStub() = default;
  ~BlobStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return BlobStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return BlobStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT BlobReaderClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT BlobRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT BlobResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // blink::mojom::blink

namespace mojo {

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_BLOB_BLOB_MOJOM_BLINK_H_