// third_party/blink/public/mojom/cache_storage/cache_storage.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_CACHE_STORAGE_CACHE_STORAGE_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_CACHE_STORAGE_CACHE_STORAGE_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/blink/public/mojom/cache_storage/cache_storage.mojom-shared-internal.h"
#include "mojo/public/mojom/base/big_buffer.mojom-shared.h"
#include "mojo/public/mojom/base/read_only_buffer.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "third_party/blink/public/mojom/blob/blob.mojom-shared.h"
#include "third_party/blink/public/mojom/fetch/fetch_api_response.mojom-shared.h"
#include "third_party/blink/public/mojom/fetch/fetch_api_request.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace blink::mojom {
class CacheStorageVerboseErrorDataView;

class CacheQueryOptionsDataView;

class MultiCacheQueryOptionsDataView;

class BatchOperationDataView;

class EagerResponseDataView;

class CacheEntryDataView;

class MatchResponseDataView;
class CacheStorageCache_Match_ResponseParam_ResultDataView;
class CacheStorageCache_MatchAll_ResponseParam_ResultDataView;
class CacheStorageCache_GetAllMatchedEntries_ResponseParam_ResultDataView;
class CacheStorageCache_Keys_ResponseParam_ResultDataView;
class CacheStorage_Match_ResponseParam_ResultDataView;
class CacheStorage_Open_ResponseParam_ResultDataView;


}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::CacheStorageVerboseErrorDataView> {
  using Data = ::blink::mojom::internal::CacheStorageVerboseError_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::CacheQueryOptionsDataView> {
  using Data = ::blink::mojom::internal::CacheQueryOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::MultiCacheQueryOptionsDataView> {
  using Data = ::blink::mojom::internal::MultiCacheQueryOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::BatchOperationDataView> {
  using Data = ::blink::mojom::internal::BatchOperation_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::EagerResponseDataView> {
  using Data = ::blink::mojom::internal::EagerResponse_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::CacheEntryDataView> {
  using Data = ::blink::mojom::internal::CacheEntry_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::MatchResponseDataView> {
  using Data = ::blink::mojom::internal::MatchResponse_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::blink::mojom::CacheStorageCache_Match_ResponseParam_ResultDataView> {
  using Data = ::blink::mojom::internal::CacheStorageCache_Match_ResponseParam_Result_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::blink::mojom::CacheStorageCache_MatchAll_ResponseParam_ResultDataView> {
  using Data = ::blink::mojom::internal::CacheStorageCache_MatchAll_ResponseParam_Result_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::blink::mojom::CacheStorageCache_GetAllMatchedEntries_ResponseParam_ResultDataView> {
  using Data = ::blink::mojom::internal::CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::blink::mojom::CacheStorageCache_Keys_ResponseParam_ResultDataView> {
  using Data = ::blink::mojom::internal::CacheStorageCache_Keys_ResponseParam_Result_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::blink::mojom::CacheStorage_Match_ResponseParam_ResultDataView> {
  using Data = ::blink::mojom::internal::CacheStorage_Match_ResponseParam_Result_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::blink::mojom::CacheStorage_Open_ResponseParam_ResultDataView> {
  using Data = ::blink::mojom::internal::CacheStorage_Open_ResponseParam_Result_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class CacheStorageError : int32_t {
  
  kSuccess = 0,
  
  kErrorExists = 1,
  
  kErrorStorage = 2,
  
  kErrorNotFound = 3,
  
  kErrorQuotaExceeded = 4,
  
  kErrorCacheNameNotFound = 5,
  
  kErrorQueryTooLarge = 6,
  
  kErrorNotImplemented = 7,
  
  kErrorDuplicateOperation = 8,
  
  kErrorCrossOriginResourcePolicy = 9,
  kMinValue = 0,
  kMaxValue = 9,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, CacheStorageError value);
inline bool IsKnownEnumValue(CacheStorageError value) {
  return internal::CacheStorageError_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class OperationType : int32_t {
  
  kUndefined = 0,
  
  kPut = 1,
  
  kDelete = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, OperationType value);
inline bool IsKnownEnumValue(OperationType value) {
  return internal::OperationType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class CacheStorageCacheInterfaceBase {};

using CacheStorageCachePtrDataView =
    mojo::InterfacePtrDataView<CacheStorageCacheInterfaceBase>;
using CacheStorageCacheRequestDataView =
    mojo::InterfaceRequestDataView<CacheStorageCacheInterfaceBase>;
using CacheStorageCacheAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<CacheStorageCacheInterfaceBase>;
using CacheStorageCacheAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<CacheStorageCacheInterfaceBase>;
class CacheStorageInterfaceBase {};

using CacheStoragePtrDataView =
    mojo::InterfacePtrDataView<CacheStorageInterfaceBase>;
using CacheStorageRequestDataView =
    mojo::InterfaceRequestDataView<CacheStorageInterfaceBase>;
using CacheStorageAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<CacheStorageInterfaceBase>;
using CacheStorageAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<CacheStorageInterfaceBase>;


class CacheStorageVerboseErrorDataView {
 public:
  CacheStorageVerboseErrorDataView() = default;

  CacheStorageVerboseErrorDataView(
      internal::CacheStorageVerboseError_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadValue(UserType* output) const {
    auto data_value = data_->value;
    return mojo::internal::Deserialize<::blink::mojom::CacheStorageError>(
        data_value, output);
  }
  CacheStorageError value() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::CacheStorageError>(data_->value));
  }
  inline void GetMessageDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMessage(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `message` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadMessage` instead "
    "of `ReadMessage if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->message.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::CacheStorageVerboseError_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CacheQueryOptionsDataView {
 public:
  CacheQueryOptionsDataView() = default;

  CacheQueryOptionsDataView(
      internal::CacheQueryOptions_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool ignore_search() const {
    return data_->ignore_search;
  }
  bool ignore_method() const {
    return data_->ignore_method;
  }
  bool ignore_vary() const {
    return data_->ignore_vary;
  }
 private:
  internal::CacheQueryOptions_Data* data_ = nullptr;
};


class MultiCacheQueryOptionsDataView {
 public:
  MultiCacheQueryOptionsDataView() = default;

  MultiCacheQueryOptionsDataView(
      internal::MultiCacheQueryOptions_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetQueryOptionsDataView(
      CacheQueryOptionsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadQueryOptions(UserType* output) {
    
    auto* pointer = data_->query_options.Get();
    return mojo::internal::Deserialize<::blink::mojom::CacheQueryOptionsDataView>(
        pointer, output, message_);
  }
  inline void GetCacheNameDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCacheName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `cache_name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCacheName` instead "
    "of `ReadCacheName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->cache_name.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
 private:
  internal::MultiCacheQueryOptions_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class BatchOperationDataView {
 public:
  BatchOperationDataView() = default;

  BatchOperationDataView(
      internal::BatchOperation_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadOperationType(UserType* output) const {
    auto data_value = data_->operation_type;
    return mojo::internal::Deserialize<::blink::mojom::OperationType>(
        data_value, output);
  }
  OperationType operation_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::OperationType>(data_->operation_type));
  }
  inline void GetRequestDataView(
      ::blink::mojom::FetchAPIRequestDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRequest(UserType* output) {
    
    auto* pointer = data_->request.Get();
    return mojo::internal::Deserialize<::blink::mojom::FetchAPIRequestDataView>(
        pointer, output, message_);
  }
  inline void GetResponseDataView(
      ::blink::mojom::FetchAPIResponseDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResponse(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::FetchAPIResponseDataView, UserType>(),
    "Attempting to read the optional `response` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadResponse` instead "
    "of `ReadResponse if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->response.Get();
    return mojo::internal::Deserialize<::blink::mojom::FetchAPIResponseDataView>(
        pointer, output, message_);
  }
  inline void GetMatchOptionsDataView(
      CacheQueryOptionsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMatchOptions(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::CacheQueryOptionsDataView, UserType>(),
    "Attempting to read the optional `match_options` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadMatchOptions` instead "
    "of `ReadMatchOptions if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->match_options.Get();
    return mojo::internal::Deserialize<::blink::mojom::CacheQueryOptionsDataView>(
        pointer, output, message_);
  }
 private:
  internal::BatchOperation_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class EagerResponseDataView {
 public:
  EagerResponseDataView() = default;

  EagerResponseDataView(
      internal::EagerResponse_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetResponseDataView(
      ::blink::mojom::FetchAPIResponseDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResponse(UserType* output) {
    
    auto* pointer = data_->response.Get();
    return mojo::internal::Deserialize<::blink::mojom::FetchAPIResponseDataView>(
        pointer, output, message_);
  }
  mojo::ScopedDataPipeConsumerHandle TakePipe() {
    mojo::ScopedDataPipeConsumerHandle result;
    bool ret =
        mojo::internal::Deserialize<mojo::ScopedDataPipeConsumerHandle>(
            &data_->pipe, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeClientReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::blink::mojom::BlobReaderClientInterfaceBase>>(
            &data_->client_receiver, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::EagerResponse_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CacheEntryDataView {
 public:
  CacheEntryDataView() = default;

  CacheEntryDataView(
      internal::CacheEntry_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRequestDataView(
      ::blink::mojom::FetchAPIRequestDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRequest(UserType* output) {
    
    auto* pointer = data_->request.Get();
    return mojo::internal::Deserialize<::blink::mojom::FetchAPIRequestDataView>(
        pointer, output, message_);
  }
  inline void GetResponseDataView(
      ::blink::mojom::FetchAPIResponseDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResponse(UserType* output) {
    
    auto* pointer = data_->response.Get();
    return mojo::internal::Deserialize<::blink::mojom::FetchAPIResponseDataView>(
        pointer, output, message_);
  }
 private:
  internal::CacheEntry_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MatchResponseDataView {
 public:
  using Tag = internal::MatchResponse_Data::MatchResponse_Tag;

  MatchResponseDataView() = default;

  MatchResponseDataView(
      internal::MatchResponse_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_response() const { return data_->tag == Tag::kResponse; }
  inline void GetResponseDataView(
      ::blink::mojom::FetchAPIResponseDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadResponse(UserType* output) const {
    
    CHECK(is_response());
    return mojo::internal::Deserialize<::blink::mojom::FetchAPIResponseDataView>(
        data_->data.f_response.Get(), output, message_);
  }
  bool is_eager_response() const { return data_->tag == Tag::kEagerResponse; }
  inline void GetEagerResponseDataView(
      EagerResponseDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadEagerResponse(UserType* output) const {
    
    CHECK(is_eager_response());
    return mojo::internal::Deserialize<::blink::mojom::EagerResponseDataView>(
        data_->data.f_eager_response.Get(), output, message_);
  }

 private:
  internal::MatchResponse_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class CacheStorageCache_Match_ResponseParam_ResultDataView {
 public:
  using Tag = internal::CacheStorageCache_Match_ResponseParam_Result_Data::CacheStorageCache_Match_ResponseParam_Result_Tag;

  CacheStorageCache_Match_ResponseParam_ResultDataView() = default;

  CacheStorageCache_Match_ResponseParam_ResultDataView(
      internal::CacheStorageCache_Match_ResponseParam_Result_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_success() const { return data_->tag == Tag::kSuccess; }
  inline void GetSuccessDataView(
      MatchResponseDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSuccess(UserType* output) const {
    
    CHECK(is_success());
    return mojo::internal::Deserialize<::blink::mojom::MatchResponseDataView>(
        data_->data.f_success.Get(), output, message_);
  }
  bool is_failure() const { return data_->tag == Tag::kFailure; }
  template <typename UserType>
  [[nodiscard]] bool ReadFailure(UserType* output) const {
    CHECK(is_failure());
    return mojo::internal::Deserialize<::blink::mojom::CacheStorageError>(
        data_->data.f_failure, output);
  }
  CacheStorageError failure() const {
    CHECK(is_failure());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::CacheStorageError>(data_->data.f_failure));
  }

 private:
  internal::CacheStorageCache_Match_ResponseParam_Result_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class CacheStorageCache_MatchAll_ResponseParam_ResultDataView {
 public:
  using Tag = internal::CacheStorageCache_MatchAll_ResponseParam_Result_Data::CacheStorageCache_MatchAll_ResponseParam_Result_Tag;

  CacheStorageCache_MatchAll_ResponseParam_ResultDataView() = default;

  CacheStorageCache_MatchAll_ResponseParam_ResultDataView(
      internal::CacheStorageCache_MatchAll_ResponseParam_Result_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_success() const { return data_->tag == Tag::kSuccess; }
  inline void GetSuccessDataView(
      mojo::ArrayDataView<::blink::mojom::FetchAPIResponseDataView>* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSuccess(UserType* output) const {
    
    CHECK(is_success());
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::FetchAPIResponseDataView>>(
        data_->data.f_success.Get(), output, message_);
  }
  bool is_failure() const { return data_->tag == Tag::kFailure; }
  template <typename UserType>
  [[nodiscard]] bool ReadFailure(UserType* output) const {
    CHECK(is_failure());
    return mojo::internal::Deserialize<::blink::mojom::CacheStorageError>(
        data_->data.f_failure, output);
  }
  CacheStorageError failure() const {
    CHECK(is_failure());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::CacheStorageError>(data_->data.f_failure));
  }

 private:
  internal::CacheStorageCache_MatchAll_ResponseParam_Result_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class CacheStorageCache_GetAllMatchedEntries_ResponseParam_ResultDataView {
 public:
  using Tag = internal::CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result_Data::CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result_Tag;

  CacheStorageCache_GetAllMatchedEntries_ResponseParam_ResultDataView() = default;

  CacheStorageCache_GetAllMatchedEntries_ResponseParam_ResultDataView(
      internal::CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_success() const { return data_->tag == Tag::kSuccess; }
  inline void GetSuccessDataView(
      mojo::ArrayDataView<CacheEntryDataView>* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSuccess(UserType* output) const {
    
    CHECK(is_success());
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::CacheEntryDataView>>(
        data_->data.f_success.Get(), output, message_);
  }
  bool is_failure() const { return data_->tag == Tag::kFailure; }
  template <typename UserType>
  [[nodiscard]] bool ReadFailure(UserType* output) const {
    CHECK(is_failure());
    return mojo::internal::Deserialize<::blink::mojom::CacheStorageError>(
        data_->data.f_failure, output);
  }
  CacheStorageError failure() const {
    CHECK(is_failure());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::CacheStorageError>(data_->data.f_failure));
  }

 private:
  internal::CacheStorageCache_GetAllMatchedEntries_ResponseParam_Result_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class CacheStorageCache_Keys_ResponseParam_ResultDataView {
 public:
  using Tag = internal::CacheStorageCache_Keys_ResponseParam_Result_Data::CacheStorageCache_Keys_ResponseParam_Result_Tag;

  CacheStorageCache_Keys_ResponseParam_ResultDataView() = default;

  CacheStorageCache_Keys_ResponseParam_ResultDataView(
      internal::CacheStorageCache_Keys_ResponseParam_Result_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_success() const { return data_->tag == Tag::kSuccess; }
  inline void GetSuccessDataView(
      mojo::ArrayDataView<::blink::mojom::FetchAPIRequestDataView>* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSuccess(UserType* output) const {
    
    CHECK(is_success());
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::FetchAPIRequestDataView>>(
        data_->data.f_success.Get(), output, message_);
  }
  bool is_failure() const { return data_->tag == Tag::kFailure; }
  template <typename UserType>
  [[nodiscard]] bool ReadFailure(UserType* output) const {
    CHECK(is_failure());
    return mojo::internal::Deserialize<::blink::mojom::CacheStorageError>(
        data_->data.f_failure, output);
  }
  CacheStorageError failure() const {
    CHECK(is_failure());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::CacheStorageError>(data_->data.f_failure));
  }

 private:
  internal::CacheStorageCache_Keys_ResponseParam_Result_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class CacheStorage_Match_ResponseParam_ResultDataView {
 public:
  using Tag = internal::CacheStorage_Match_ResponseParam_Result_Data::CacheStorage_Match_ResponseParam_Result_Tag;

  CacheStorage_Match_ResponseParam_ResultDataView() = default;

  CacheStorage_Match_ResponseParam_ResultDataView(
      internal::CacheStorage_Match_ResponseParam_Result_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_success() const { return data_->tag == Tag::kSuccess; }
  inline void GetSuccessDataView(
      MatchResponseDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSuccess(UserType* output) const {
    
    CHECK(is_success());
    return mojo::internal::Deserialize<::blink::mojom::MatchResponseDataView>(
        data_->data.f_success.Get(), output, message_);
  }
  bool is_failure() const { return data_->tag == Tag::kFailure; }
  template <typename UserType>
  [[nodiscard]] bool ReadFailure(UserType* output) const {
    CHECK(is_failure());
    return mojo::internal::Deserialize<::blink::mojom::CacheStorageError>(
        data_->data.f_failure, output);
  }
  CacheStorageError failure() const {
    CHECK(is_failure());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::CacheStorageError>(data_->data.f_failure));
  }

 private:
  internal::CacheStorage_Match_ResponseParam_Result_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class CacheStorage_Open_ResponseParam_ResultDataView {
 public:
  using Tag = internal::CacheStorage_Open_ResponseParam_Result_Data::CacheStorage_Open_ResponseParam_Result_Tag;

  CacheStorage_Open_ResponseParam_ResultDataView() = default;

  CacheStorage_Open_ResponseParam_ResultDataView(
      internal::CacheStorage_Open_ResponseParam_Result_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_success() const { return data_->tag == Tag::kSuccess; }
  template <typename UserType>
  UserType TakeSuccess() {
    CHECK(is_success());
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::blink::mojom::CacheStorageCacheAssociatedPtrInfoDataView>(
            &data_->data.f_success, &result, message_);
    CHECK(ret);
    return result;
  }
  bool is_failure() const { return data_->tag == Tag::kFailure; }
  template <typename UserType>
  [[nodiscard]] bool ReadFailure(UserType* output) const {
    CHECK(is_failure());
    return mojo::internal::Deserialize<::blink::mojom::CacheStorageError>(
        data_->data.f_failure, output);
  }
  CacheStorageError failure() const {
    CHECK(is_failure());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::CacheStorageError>(data_->data.f_failure));
  }

 private:
  internal::CacheStorage_Open_ResponseParam_Result_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_CACHE_STORAGE_CACHE_STORAGE_MOJOM_DATA_VIEW_H_