// third_party/blink/public/mojom/frame/policy_container.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_POLICY_CONTAINER_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_POLICY_CONTAINER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/frame/policy_container.mojom-shared-internal.h"
#include "services/network/public/mojom/content_security_policy.mojom-shared.h"
#include "services/network/public/mojom/cross_origin_embedder_policy.mojom-shared.h"
#include "services/network/public/mojom/integrity_policy.mojom-shared.h"
#include "services/network/public/mojom/ip_address_space.mojom-shared.h"
#include "services/network/public/mojom/referrer_policy.mojom-shared.h"
#include "services/network/public/mojom/web_sandbox_flags.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "third_party/blink/public/mojom/frame/policy_container.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PolicyContainerPoliciesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::PolicyContainerPoliciesDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::PolicyContainerPolicies_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::cross_origin_embedder_policy(input)) in_cross_origin_embedder_policy = Traits::cross_origin_embedder_policy(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->cross_origin_embedder_policy)::BaseType> cross_origin_embedder_policy_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::CrossOriginEmbedderPolicyDataView>(
      in_cross_origin_embedder_policy,
      cross_origin_embedder_policy_fragment);

    fragment->cross_origin_embedder_policy.Set(
        cross_origin_embedder_policy_fragment.is_null() ? nullptr : cross_origin_embedder_policy_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->cross_origin_embedder_policy.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null cross_origin_embedder_policy in PolicyContainerPolicies struct");

    decltype(Traits::integrity_policy(input)) in_integrity_policy = Traits::integrity_policy(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->integrity_policy)::BaseType> integrity_policy_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::IntegrityPolicyDataView>(
      in_integrity_policy,
      integrity_policy_fragment);

    fragment->integrity_policy.Set(
        integrity_policy_fragment.is_null() ? nullptr : integrity_policy_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->integrity_policy.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null integrity_policy in PolicyContainerPolicies struct");

    decltype(Traits::integrity_policy_report_only(input)) in_integrity_policy_report_only = Traits::integrity_policy_report_only(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->integrity_policy_report_only)::BaseType> integrity_policy_report_only_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::IntegrityPolicyDataView>(
      in_integrity_policy_report_only,
      integrity_policy_report_only_fragment);

    fragment->integrity_policy_report_only.Set(
        integrity_policy_report_only_fragment.is_null() ? nullptr : integrity_policy_report_only_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->integrity_policy_report_only.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null integrity_policy_report_only in PolicyContainerPolicies struct");

    
    mojo::internal::Serialize<::network::mojom::ReferrerPolicy>(
      Traits::referrer_policy(input),
      &fragment->referrer_policy);

    decltype(Traits::content_security_policies(input)) in_content_security_policies = Traits::content_security_policies(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->content_security_policies)::BaseType>
        content_security_policies_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& content_security_policies_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::ContentSecurityPolicyDataView>>(
      in_content_security_policies,
      content_security_policies_fragment,
      &content_security_policies_validate_params);

    fragment->content_security_policies.Set(
        content_security_policies_fragment.is_null() ? nullptr : content_security_policies_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->content_security_policies.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null content_security_policies in PolicyContainerPolicies struct");

    fragment->is_credentialless = Traits::is_credentialless(input);

    
    mojo::internal::Serialize<::network::mojom::WebSandboxFlags>(
      Traits::sandbox_flags(input),
      &fragment->sandbox_flags);

    
    mojo::internal::Serialize<::network::mojom::IPAddressSpace>(
      Traits::ip_address_space(input),
      &fragment->ip_address_space);

    fragment->can_navigate_top_without_user_gesture = Traits::can_navigate_top_without_user_gesture(input);

    fragment->cross_origin_isolation_enabled_by_dip = Traits::cross_origin_isolation_enabled_by_dip(input);
  }

  static bool Deserialize(::blink::mojom::internal::PolicyContainerPolicies_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::PolicyContainerPoliciesDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PolicyContainerDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::PolicyContainerDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::PolicyContainer_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::policies(input)) in_policies = Traits::policies(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->policies)::BaseType> policies_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::PolicyContainerPoliciesDataView>(
      in_policies,
      policies_fragment);

    fragment->policies.Set(
        policies_fragment.is_null() ? nullptr : policies_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->policies.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null policies in PolicyContainer struct");

    decltype(Traits::remote(input)) in_remote = Traits::remote(input);

    
    mojo::internal::Serialize<::blink::mojom::PolicyContainerHostAssociatedPtrInfoDataView>(
      in_remote,
      &fragment->remote,
      &fragment.message());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(!mojo::internal::IsHandleOrInterfaceValid(fragment->remote)),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid remote in PolicyContainer struct");
  }

  static bool Deserialize(::blink::mojom::internal::PolicyContainer_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::PolicyContainerDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PolicyContainerBindParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::PolicyContainerBindParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::PolicyContainerBindParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::receiver(input)) in_receiver = Traits::receiver(input);

    
    mojo::internal::Serialize<::blink::mojom::PolicyContainerHostAssociatedRequestDataView>(
      in_receiver,
      &fragment->receiver,
      &fragment.message());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(!mojo::internal::IsHandleOrInterfaceValid(fragment->receiver)),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid receiver in PolicyContainerBindParams struct");
  }

  static bool Deserialize(::blink::mojom::internal::PolicyContainerBindParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::PolicyContainerBindParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void PolicyContainerPoliciesDataView::GetCrossOriginEmbedderPolicyDataView(
    ::network::mojom::CrossOriginEmbedderPolicyDataView* output) {
  auto pointer = data_->cross_origin_embedder_policy.Get();
  *output = ::network::mojom::CrossOriginEmbedderPolicyDataView(pointer, message_);
}
inline void PolicyContainerPoliciesDataView::GetIntegrityPolicyDataView(
    ::network::mojom::IntegrityPolicyDataView* output) {
  auto pointer = data_->integrity_policy.Get();
  *output = ::network::mojom::IntegrityPolicyDataView(pointer, message_);
}
inline void PolicyContainerPoliciesDataView::GetIntegrityPolicyReportOnlyDataView(
    ::network::mojom::IntegrityPolicyDataView* output) {
  auto pointer = data_->integrity_policy_report_only.Get();
  *output = ::network::mojom::IntegrityPolicyDataView(pointer, message_);
}
inline void PolicyContainerPoliciesDataView::GetContentSecurityPoliciesDataView(
    mojo::ArrayDataView<::network::mojom::ContentSecurityPolicyDataView>* output) {
  auto pointer = data_->content_security_policies.Get();
  *output = mojo::ArrayDataView<::network::mojom::ContentSecurityPolicyDataView>(pointer, message_);
}


inline void PolicyContainerDataView::GetPoliciesDataView(
    PolicyContainerPoliciesDataView* output) {
  auto pointer = data_->policies.Get();
  *output = PolicyContainerPoliciesDataView(pointer, message_);
}





}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_POLICY_CONTAINER_MOJOM_SHARED_H_