// third_party/blink/public/mojom/gpu/gpu.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/gpu/gpu.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/gpu/gpu.mojom-params-data.h"
#include "third_party/blink/public/mojom/gpu/gpu.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/gpu/gpu.mojom-import-headers.h"
#include "third_party/blink/public/mojom/gpu/gpu.mojom-test-utils.h"


namespace blink::mojom {
// The declaration includes the definition on other builds.

GpuDataManager::IPCStableHashFunction GpuDataManager::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::GpuDataManager>(message.name())) {
    case messages::GpuDataManager::kAre3DAPIsBlockedForUrl: {
      return &GpuDataManager::Are3DAPIsBlockedForUrl_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* GpuDataManager::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::GpuDataManager>(message.name())) {
      case messages::GpuDataManager::kAre3DAPIsBlockedForUrl:
            return "Receive blink::mojom::GpuDataManager::Are3DAPIsBlockedForUrl";
    }
  } else {
    switch (static_cast<messages::GpuDataManager>(message.name())) {
      case messages::GpuDataManager::kAre3DAPIsBlockedForUrl:
            return "Receive reply blink::mojom::GpuDataManager::Are3DAPIsBlockedForUrl";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t GpuDataManager::Are3DAPIsBlockedForUrl_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2f8d1e03;  // IPCStableHash for blink::mojom::GpuDataManager::Are3DAPIsBlockedForUrl
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)
bool GpuDataManager::Are3DAPIsBlockedForUrl(const ::GURL& url, bool* out_blocked) {
  NOTREACHED();
}
class GpuDataManager_Are3DAPIsBlockedForUrl_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  GpuDataManager_Are3DAPIsBlockedForUrl_HandleSyncResponse(
      bool* result, bool* out_blocked)
      : result_(result), out_blocked_(out_blocked) {
    DCHECK(!*result_);
  }

  GpuDataManager_Are3DAPIsBlockedForUrl_HandleSyncResponse(const GpuDataManager_Are3DAPIsBlockedForUrl_HandleSyncResponse&) = delete;
  GpuDataManager_Are3DAPIsBlockedForUrl_HandleSyncResponse& operator=(const GpuDataManager_Are3DAPIsBlockedForUrl_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  bool* out_blocked_;};

class GpuDataManager_Are3DAPIsBlockedForUrl_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  GpuDataManager_Are3DAPIsBlockedForUrl_ForwardToCallback(
      GpuDataManager::Are3DAPIsBlockedForUrlCallback callback
      ) : callback_(std::move(callback)) {
  }

  GpuDataManager_Are3DAPIsBlockedForUrl_ForwardToCallback(const GpuDataManager_Are3DAPIsBlockedForUrl_ForwardToCallback&) = delete;
  GpuDataManager_Are3DAPIsBlockedForUrl_ForwardToCallback& operator=(const GpuDataManager_Are3DAPIsBlockedForUrl_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  GpuDataManager::Are3DAPIsBlockedForUrlCallback callback_;
};

GpuDataManagerProxy::GpuDataManagerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}
bool GpuDataManagerProxy::Are3DAPIsBlockedForUrl(
    const ::GURL& param_url, bool* out_param_blocked) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call blink::mojom::GpuDataManager::Are3DAPIsBlockedForUrl (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), param_url,
                        "<value of type const ::GURL&>");
   });
#else
  TRACE_EVENT0("mojom", "GpuDataManager::Are3DAPIsBlockedForUrl");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuDataManager::kAre3DAPIsBlockedForUrl), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::GpuDataManager_Are3DAPIsBlockedForUrl_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    param_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in GpuDataManager.Are3DAPIsBlockedForUrl request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuDataManager::Name_);
  message.set_method_name("Are3DAPIsBlockedForUrl");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GpuDataManager_Are3DAPIsBlockedForUrl_HandleSyncResponse(
          &result, out_param_blocked));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "GpuDataManager::Are3DAPIsBlockedForUrl", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("blocked"), out_param_blocked,
                        "<value of type bool>");
   });
#endif
  return result;
}

void GpuDataManagerProxy::Are3DAPIsBlockedForUrl(
    const ::GURL& in_url, Are3DAPIsBlockedForUrlCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::GpuDataManager::Are3DAPIsBlockedForUrl", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuDataManager::kAre3DAPIsBlockedForUrl), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::GpuDataManager_Are3DAPIsBlockedForUrl_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in GpuDataManager.Are3DAPIsBlockedForUrl request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuDataManager::Name_);
  message.set_method_name("Are3DAPIsBlockedForUrl");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GpuDataManager_Are3DAPIsBlockedForUrl_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class GpuDataManager_Are3DAPIsBlockedForUrl_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static GpuDataManager::Are3DAPIsBlockedForUrlCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<GpuDataManager_Are3DAPIsBlockedForUrl_ProxyToResponder> proxy(
        new GpuDataManager_Are3DAPIsBlockedForUrl_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&GpuDataManager_Are3DAPIsBlockedForUrl_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~GpuDataManager_Are3DAPIsBlockedForUrl_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  GpuDataManager_Are3DAPIsBlockedForUrl_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "GpuDataManager::Are3DAPIsBlockedForUrlCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_blocked);
};

bool GpuDataManager_Are3DAPIsBlockedForUrl_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::GpuDataManager_Are3DAPIsBlockedForUrl_ResponseParams_Data* params =
      reinterpret_cast<
          internal::GpuDataManager_Are3DAPIsBlockedForUrl_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for GpuDataManager.0
  bool success = true;
  bool p_blocked{};
  GpuDataManager_Are3DAPIsBlockedForUrl_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_blocked = input_data_view.blocked();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GpuDataManager::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_blocked));
  }
  return true;
}

void GpuDataManager_Are3DAPIsBlockedForUrl_ProxyToResponder::Run(
    bool in_blocked) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::GpuDataManager::Are3DAPIsBlockedForUrl", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("blocked"), in_blocked,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuDataManager::kAre3DAPIsBlockedForUrl), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::GpuDataManager_Are3DAPIsBlockedForUrl_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->blocked = in_blocked;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuDataManager::Name_);
  message.set_method_name("Are3DAPIsBlockedForUrl");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool GpuDataManager_Are3DAPIsBlockedForUrl_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::GpuDataManager_Are3DAPIsBlockedForUrl_ResponseParams_Data* params =
      reinterpret_cast<internal::GpuDataManager_Are3DAPIsBlockedForUrl_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for GpuDataManager.0
  bool success = true;
  bool p_blocked{};
  GpuDataManager_Are3DAPIsBlockedForUrl_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_blocked = input_data_view.blocked();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GpuDataManager::Name_, 0, true);
    return false;
  }
  *out_blocked_ = std::move(p_blocked);
  *result_ = true;
  return true;
}

// static
bool GpuDataManagerStubDispatch::Accept(
    GpuDataManager* impl,
    mojo::Message* message) {
  switch (static_cast<messages::GpuDataManager>(message->header()->name)) {
    case messages::GpuDataManager::kAre3DAPIsBlockedForUrl: {
      break;
    }
  }
  return false;
}

// static
bool GpuDataManagerStubDispatch::AcceptWithResponder(
    GpuDataManager* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::GpuDataManager>(message->header()->name)) {
    case messages::GpuDataManager::kAre3DAPIsBlockedForUrl: {
      internal::GpuDataManager_Are3DAPIsBlockedForUrl_Params_Data* params =
          reinterpret_cast<
              internal::GpuDataManager_Are3DAPIsBlockedForUrl_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for GpuDataManager.0
      bool success = true;
      ::GURL p_url{};
      GpuDataManager_Are3DAPIsBlockedForUrl_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuDataManager::Name_, 0, false);
        return false;
      }
      auto callback =
          GpuDataManager_Are3DAPIsBlockedForUrl_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Are3DAPIsBlockedForUrl(        
        std::move(p_url), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kGpuDataManagerValidationInfo[] = {
    {base::to_underlying(messages::GpuDataManager::kAre3DAPIsBlockedForUrl),
     { &internal::GpuDataManager_Are3DAPIsBlockedForUrl_Params_Data::Validate,
      &internal::GpuDataManager_Are3DAPIsBlockedForUrl_ResponseParams_Data::Validate}},
};

bool GpuDataManagerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::blink::mojom::GpuDataManager::Name_,
    kGpuDataManagerValidationInfo);
}

bool GpuDataManagerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGeneric(
    message,
    ::blink::mojom::GpuDataManager::Name_,
    kGpuDataManagerValidationInfo);

}


}  // blink::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom {


void GpuDataManagerInterceptorForTesting::Are3DAPIsBlockedForUrl(const ::GURL& url, Are3DAPIsBlockedForUrlCallback callback) {
  GetForwardingInterface()->Are3DAPIsBlockedForUrl(
    std::move(url)
    , std::move(callback));
}
GpuDataManagerAsyncWaiter::GpuDataManagerAsyncWaiter(
    GpuDataManager* proxy) : proxy_(proxy) {}

GpuDataManagerAsyncWaiter::~GpuDataManagerAsyncWaiter() = default;


void GpuDataManagerAsyncWaiter::Are3DAPIsBlockedForUrl(
    const ::GURL& url, bool* out_blocked) {
  base::RunLoop loop;
  proxy_->Are3DAPIsBlockedForUrl(
      std::move(url),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_blocked
,
             bool blocked) {*out_blocked = std::move(blocked);
            loop->Quit();
          },
          &loop,
          out_blocked));
  loop.Run();
}

bool GpuDataManagerAsyncWaiter::Are3DAPIsBlockedForUrl(
    const ::GURL& url) {
  bool async_wait_result;
  Are3DAPIsBlockedForUrl(std::move(url),&async_wait_result);
  return async_wait_result;
}






}  // blink::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif