// third_party/blink/public/mojom/loader/fetch_client_settings_object.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_FETCH_CLIENT_SETTINGS_OBJECT_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_FETCH_CLIENT_SETTINGS_OBJECT_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/loader/fetch_client_settings_object.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/loader/fetch_client_settings_object.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/loader/fetch_client_settings_object.mojom-forward.h"  // IWYU pragma: export
#include "url/mojom/url.mojom.h"
#include "services/network/public/mojom/referrer_policy.mojom-forward.h"
#include <string>
#include <vector>




#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {








class BLINK_COMMON_EXPORT FetchClientSettingsObject {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FetchClientSettingsObject, T>::value>;
  using DataView = FetchClientSettingsObjectDataView;
  using Data_ = internal::FetchClientSettingsObject_Data;

  template <typename... Args>
  static FetchClientSettingsObjectPtr New(Args&&... args) {
    return FetchClientSettingsObjectPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FetchClientSettingsObjectPtr From(const U& u) {
    return mojo::TypeConverter<FetchClientSettingsObjectPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FetchClientSettingsObject>::Convert(*this);
  }


  FetchClientSettingsObject();

  FetchClientSettingsObject(
      ::network::mojom::ReferrerPolicy referrer_policy,
      const ::GURL& outgoing_referrer,
      InsecureRequestsPolicy insecure_requests_policy);


  ~FetchClientSettingsObject();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FetchClientSettingsObjectPtr>
  FetchClientSettingsObjectPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FetchClientSettingsObject::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FetchClientSettingsObject::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FetchClientSettingsObject::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FetchClientSettingsObject::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FetchClientSettingsObject::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FetchClientSettingsObject::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FetchClientSettingsObject_UnserializedMessageContext<
            UserType, FetchClientSettingsObject::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FetchClientSettingsObject::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FetchClientSettingsObject::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FetchClientSettingsObject_UnserializedMessageContext<
            UserType, FetchClientSettingsObject::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FetchClientSettingsObject::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::network::mojom::ReferrerPolicy referrer_policy;
  
  ::GURL outgoing_referrer;
  
  InsecureRequestsPolicy insecure_requests_policy;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FetchClientSettingsObject::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FetchClientSettingsObject::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FetchClientSettingsObject::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FetchClientSettingsObject::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
FetchClientSettingsObjectPtr FetchClientSettingsObject::Clone() const {
  return New(
      mojo::Clone(referrer_policy),
      mojo::Clone(outgoing_referrer),
      mojo::Clone(insecure_requests_policy)
  );
}

template <typename T, FetchClientSettingsObject::EnableIfSame<T>*>
bool FetchClientSettingsObject::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->referrer_policy, other_struct.referrer_policy))
    return false;
  if (!mojo::Equals(this->outgoing_referrer, other_struct.outgoing_referrer))
    return false;
  if (!mojo::Equals(this->insecure_requests_policy, other_struct.insecure_requests_policy))
    return false;
  return true;
}

template <typename T, FetchClientSettingsObject::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.referrer_policy < rhs.referrer_policy)
    return true;
  if (rhs.referrer_policy < lhs.referrer_policy)
    return false;
  if (lhs.outgoing_referrer < rhs.outgoing_referrer)
    return true;
  if (rhs.outgoing_referrer < lhs.outgoing_referrer)
    return false;
  if (lhs.insecure_requests_policy < rhs.insecure_requests_policy)
    return true;
  if (rhs.insecure_requests_policy < lhs.insecure_requests_policy)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::FetchClientSettingsObject::DataView,
                                         ::blink::mojom::FetchClientSettingsObjectPtr> {
  static bool IsNull(const ::blink::mojom::FetchClientSettingsObjectPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::FetchClientSettingsObjectPtr* output) { output->reset(); }

  static decltype(::blink::mojom::FetchClientSettingsObject::referrer_policy) referrer_policy(
      const ::blink::mojom::FetchClientSettingsObjectPtr& input) {
    return input->referrer_policy;
  }

  static const decltype(::blink::mojom::FetchClientSettingsObject::outgoing_referrer)& outgoing_referrer(
      const ::blink::mojom::FetchClientSettingsObjectPtr& input) {
    return input->outgoing_referrer;
  }

  static decltype(::blink::mojom::FetchClientSettingsObject::insecure_requests_policy) insecure_requests_policy(
      const ::blink::mojom::FetchClientSettingsObjectPtr& input) {
    return input->insecure_requests_policy;
  }

  static bool Read(::blink::mojom::FetchClientSettingsObject::DataView input, ::blink::mojom::FetchClientSettingsObjectPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_FETCH_CLIENT_SETTINGS_OBJECT_MOJOM_H_