// third_party/blink/public/mojom/payments/payment_request.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAYMENTS_PAYMENT_REQUEST_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAYMENTS_PAYMENT_REQUEST_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/payments/payment_request.mojom-shared-internal.h"
#include "components/payments/mojom/payment_request_data.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "third_party/blink/public/mojom/payments/secure_payment_confirmation_service.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "third_party/blink/public/mojom/webauthn/authenticator.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "third_party/blink/public/mojom/payments/payment_request.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

template <>
struct hash<::payments::mojom::PaymentErrorReason>
    : public mojo::internal::EnumHashImpl<::payments::mojom::PaymentErrorReason> {};

template <>
struct hash<::payments::mojom::CanMakePaymentQueryResult>
    : public mojo::internal::EnumHashImpl<::payments::mojom::CanMakePaymentQueryResult> {};

template <>
struct hash<::payments::mojom::HasEnrolledInstrumentQueryResult>
    : public mojo::internal::EnumHashImpl<::payments::mojom::HasEnrolledInstrumentQueryResult> {};

template <>
struct hash<::payments::mojom::AndroidPayEnvironment>
    : public mojo::internal::EnumHashImpl<::payments::mojom::AndroidPayEnvironment> {};

template <>
struct hash<::payments::mojom::BasicCardNetwork>
    : public mojo::internal::EnumHashImpl<::payments::mojom::BasicCardNetwork> {};

template <>
struct hash<::payments::mojom::PaymentShippingType>
    : public mojo::internal::EnumHashImpl<::payments::mojom::PaymentShippingType> {};

template <>
struct hash<::payments::mojom::PaymentComplete>
    : public mojo::internal::EnumHashImpl<::payments::mojom::PaymentComplete> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::payments::mojom::PaymentErrorReason, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::payments::mojom::PaymentErrorReason, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::payments::mojom::PaymentErrorReason>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::payments::mojom::CanMakePaymentQueryResult, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::payments::mojom::CanMakePaymentQueryResult, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::payments::mojom::CanMakePaymentQueryResult>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::payments::mojom::HasEnrolledInstrumentQueryResult, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::payments::mojom::HasEnrolledInstrumentQueryResult, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::payments::mojom::HasEnrolledInstrumentQueryResult>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::payments::mojom::AndroidPayEnvironment, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::payments::mojom::AndroidPayEnvironment, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::payments::mojom::AndroidPayEnvironment>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::payments::mojom::BasicCardNetwork, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::payments::mojom::BasicCardNetwork, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::payments::mojom::BasicCardNetwork>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::payments::mojom::PaymentShippingType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::payments::mojom::PaymentShippingType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::payments::mojom::PaymentShippingType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::payments::mojom::PaymentComplete, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::payments::mojom::PaymentComplete, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::payments::mojom::PaymentComplete>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::payments::mojom::PaymentResponseDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::payments::mojom::PaymentResponseDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::payments::mojom::internal::PaymentResponse_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::method_name(input)) in_method_name = Traits::method_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->method_name)::BaseType> method_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_method_name,
      method_name_fragment);

    fragment->method_name.Set(
        method_name_fragment.is_null() ? nullptr : method_name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->method_name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null method_name in PaymentResponse struct");

    decltype(Traits::stringified_details(input)) in_stringified_details = Traits::stringified_details(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->stringified_details)::BaseType> stringified_details_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_stringified_details,
      stringified_details_fragment);

    fragment->stringified_details.Set(
        stringified_details_fragment.is_null() ? nullptr : stringified_details_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->stringified_details.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null stringified_details in PaymentResponse struct");

    decltype(Traits::shipping_address(input)) in_shipping_address = Traits::shipping_address(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->shipping_address)::BaseType> shipping_address_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::payments::mojom::PaymentAddressDataView>(
      in_shipping_address,
      shipping_address_fragment);

    fragment->shipping_address.Set(
        shipping_address_fragment.is_null() ? nullptr : shipping_address_fragment.data());

    decltype(Traits::shipping_option(input)) in_shipping_option = Traits::shipping_option(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->shipping_option)::BaseType> shipping_option_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_shipping_option,
      shipping_option_fragment);

    fragment->shipping_option.Set(
        shipping_option_fragment.is_null() ? nullptr : shipping_option_fragment.data());

    decltype(Traits::payer(input)) in_payer = Traits::payer(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->payer)::BaseType> payer_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::payments::mojom::PayerDetailDataView>(
      in_payer,
      payer_fragment);

    fragment->payer.Set(
        payer_fragment.is_null() ? nullptr : payer_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->payer.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null payer in PaymentResponse struct");

    decltype(Traits::get_assertion_authenticator_response(input)) in_get_assertion_authenticator_response = Traits::get_assertion_authenticator_response(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->get_assertion_authenticator_response)::BaseType> get_assertion_authenticator_response_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::GetAssertionAuthenticatorResponseDataView>(
      in_get_assertion_authenticator_response,
      get_assertion_authenticator_response_fragment);

    fragment->get_assertion_authenticator_response.Set(
        get_assertion_authenticator_response_fragment.is_null() ? nullptr : get_assertion_authenticator_response_fragment.data());
  }

  static bool Deserialize(::payments::mojom::internal::PaymentResponse_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::payments::mojom::PaymentResponseDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::payments::mojom::PayerDetailDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::payments::mojom::PayerDetailDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::payments::mojom::internal::PayerDetail_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::email(input)) in_email = Traits::email(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->email)::BaseType> email_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_email,
      email_fragment);

    fragment->email.Set(
        email_fragment.is_null() ? nullptr : email_fragment.data());

    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_name,
      name_fragment);

    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());

    decltype(Traits::phone(input)) in_phone = Traits::phone(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->phone)::BaseType> phone_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_phone,
      phone_fragment);

    fragment->phone.Set(
        phone_fragment.is_null() ? nullptr : phone_fragment.data());
  }

  static bool Deserialize(::payments::mojom::internal::PayerDetail_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::payments::mojom::PayerDetailDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::payments::mojom::PaymentItemDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::payments::mojom::PaymentItemDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::payments::mojom::internal::PaymentItem_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::label(input)) in_label = Traits::label(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->label)::BaseType> label_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_label,
      label_fragment);

    fragment->label.Set(
        label_fragment.is_null() ? nullptr : label_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->label.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null label in PaymentItem struct");

    decltype(Traits::amount(input)) in_amount = Traits::amount(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->amount)::BaseType> amount_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::payments::mojom::PaymentCurrencyAmountDataView>(
      in_amount,
      amount_fragment);

    fragment->amount.Set(
        amount_fragment.is_null() ? nullptr : amount_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->amount.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null amount in PaymentItem struct");

    fragment->pending = Traits::pending(input);
  }

  static bool Deserialize(::payments::mojom::internal::PaymentItem_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::payments::mojom::PaymentItemDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::payments::mojom::PaymentShippingOptionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::payments::mojom::PaymentShippingOptionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::payments::mojom::internal::PaymentShippingOption_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType> id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_id,
      id_fragment);

    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in PaymentShippingOption struct");

    decltype(Traits::label(input)) in_label = Traits::label(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->label)::BaseType> label_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_label,
      label_fragment);

    fragment->label.Set(
        label_fragment.is_null() ? nullptr : label_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->label.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null label in PaymentShippingOption struct");

    decltype(Traits::amount(input)) in_amount = Traits::amount(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->amount)::BaseType> amount_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::payments::mojom::PaymentCurrencyAmountDataView>(
      in_amount,
      amount_fragment);

    fragment->amount.Set(
        amount_fragment.is_null() ? nullptr : amount_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->amount.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null amount in PaymentShippingOption struct");

    fragment->selected = Traits::selected(input);
  }

  static bool Deserialize(::payments::mojom::internal::PaymentShippingOption_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::payments::mojom::PaymentShippingOptionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::payments::mojom::SecurePaymentConfirmationRequestDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::payments::mojom::SecurePaymentConfirmationRequestDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::payments::mojom::internal::SecurePaymentConfirmationRequest_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::credential_ids(input)) in_credential_ids = Traits::credential_ids(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->credential_ids)::BaseType>
        credential_ids_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& credential_ids_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>>(
      in_credential_ids,
      credential_ids_fragment,
      &credential_ids_validate_params);

    fragment->credential_ids.Set(
        credential_ids_fragment.is_null() ? nullptr : credential_ids_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->credential_ids.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null credential_ids in SecurePaymentConfirmationRequest struct");

    decltype(Traits::challenge(input)) in_challenge = Traits::challenge(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->challenge)::BaseType>
        challenge_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& challenge_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_challenge,
      challenge_fragment,
      &challenge_validate_params);

    fragment->challenge.Set(
        challenge_fragment.is_null() ? nullptr : challenge_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->challenge.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null challenge in SecurePaymentConfirmationRequest struct");

    decltype(Traits::instrument(input)) in_instrument = Traits::instrument(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->instrument)::BaseType> instrument_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::PaymentCredentialInstrumentDataView>(
      in_instrument,
      instrument_fragment);

    fragment->instrument.Set(
        instrument_fragment.is_null() ? nullptr : instrument_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->instrument.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null instrument in SecurePaymentConfirmationRequest struct");

    decltype(Traits::timeout(input)) in_timeout = Traits::timeout(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->timeout)::BaseType> timeout_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_timeout,
      timeout_fragment);

    fragment->timeout.Set(
        timeout_fragment.is_null() ? nullptr : timeout_fragment.data());

    decltype(Traits::payee_origin(input)) in_payee_origin = Traits::payee_origin(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->payee_origin)::BaseType> payee_origin_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_payee_origin,
      payee_origin_fragment);

    fragment->payee_origin.Set(
        payee_origin_fragment.is_null() ? nullptr : payee_origin_fragment.data());

    decltype(Traits::payee_name(input)) in_payee_name = Traits::payee_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->payee_name)::BaseType> payee_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_payee_name,
      payee_name_fragment);

    fragment->payee_name.Set(
        payee_name_fragment.is_null() ? nullptr : payee_name_fragment.data());

    decltype(Traits::rp_id(input)) in_rp_id = Traits::rp_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->rp_id)::BaseType> rp_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_rp_id,
      rp_id_fragment);

    fragment->rp_id.Set(
        rp_id_fragment.is_null() ? nullptr : rp_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->rp_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null rp_id in SecurePaymentConfirmationRequest struct");

    decltype(Traits::extensions(input)) in_extensions = Traits::extensions(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->extensions)::BaseType> extensions_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::AuthenticationExtensionsClientInputsDataView>(
      in_extensions,
      extensions_fragment);

    fragment->extensions.Set(
        extensions_fragment.is_null() ? nullptr : extensions_fragment.data());

    decltype(Traits::browser_bound_pub_key_cred_params(input)) in_browser_bound_pub_key_cred_params = Traits::browser_bound_pub_key_cred_params(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->browser_bound_pub_key_cred_params)::BaseType>
        browser_bound_pub_key_cred_params_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& browser_bound_pub_key_cred_params_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::PublicKeyCredentialParametersDataView>>(
      in_browser_bound_pub_key_cred_params,
      browser_bound_pub_key_cred_params_fragment,
      &browser_bound_pub_key_cred_params_validate_params);

    fragment->browser_bound_pub_key_cred_params.Set(
        browser_bound_pub_key_cred_params_fragment.is_null() ? nullptr : browser_bound_pub_key_cred_params_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->browser_bound_pub_key_cred_params.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null browser_bound_pub_key_cred_params in SecurePaymentConfirmationRequest struct");

    fragment->show_opt_out = Traits::show_opt_out(input);

    decltype(Traits::payment_entities_logos(input)) in_payment_entities_logos = Traits::payment_entities_logos(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->payment_entities_logos)::BaseType>
        payment_entities_logos_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& payment_entities_logos_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::payments::mojom::PaymentEntityLogoDataView>>(
      in_payment_entities_logos,
      payment_entities_logos_fragment,
      &payment_entities_logos_validate_params);

    fragment->payment_entities_logos.Set(
        payment_entities_logos_fragment.is_null() ? nullptr : payment_entities_logos_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->payment_entities_logos.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null payment_entities_logos in SecurePaymentConfirmationRequest struct");
  }

  static bool Deserialize(::payments::mojom::internal::SecurePaymentConfirmationRequest_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::payments::mojom::SecurePaymentConfirmationRequestDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::payments::mojom::NetworkOrIssuerInformationDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::payments::mojom::NetworkOrIssuerInformationDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::payments::mojom::internal::NetworkOrIssuerInformation_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_name,
      name_fragment);

    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in NetworkOrIssuerInformation struct");

    decltype(Traits::icon(input)) in_icon = Traits::icon(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->icon)::BaseType> icon_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_icon,
      icon_fragment);

    fragment->icon.Set(
        icon_fragment.is_null() ? nullptr : icon_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->icon.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null icon in NetworkOrIssuerInformation struct");
  }

  static bool Deserialize(::payments::mojom::internal::NetworkOrIssuerInformation_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::payments::mojom::NetworkOrIssuerInformationDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::payments::mojom::PaymentEntityLogoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::payments::mojom::PaymentEntityLogoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::payments::mojom::internal::PaymentEntityLogo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in PaymentEntityLogo struct");

    decltype(Traits::label(input)) in_label = Traits::label(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->label)::BaseType> label_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_label,
      label_fragment);

    fragment->label.Set(
        label_fragment.is_null() ? nullptr : label_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->label.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null label in PaymentEntityLogo struct");
  }

  static bool Deserialize(::payments::mojom::internal::PaymentEntityLogo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::payments::mojom::PaymentEntityLogoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::payments::mojom::PaymentMethodDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::payments::mojom::PaymentMethodDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::payments::mojom::internal::PaymentMethodData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::supported_method(input)) in_supported_method = Traits::supported_method(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->supported_method)::BaseType> supported_method_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_supported_method,
      supported_method_fragment);

    fragment->supported_method.Set(
        supported_method_fragment.is_null() ? nullptr : supported_method_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->supported_method.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null supported_method in PaymentMethodData struct");

    decltype(Traits::stringified_data(input)) in_stringified_data = Traits::stringified_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->stringified_data)::BaseType> stringified_data_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_stringified_data,
      stringified_data_fragment);

    fragment->stringified_data.Set(
        stringified_data_fragment.is_null() ? nullptr : stringified_data_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->stringified_data.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null stringified_data in PaymentMethodData struct");

    
    mojo::internal::Serialize<::payments::mojom::AndroidPayEnvironment>(
      Traits::environment(input),
      &fragment->environment);

    fragment->min_google_play_services_version = Traits::min_google_play_services_version(input);

    fragment->api_version = Traits::api_version(input);

    decltype(Traits::supported_networks(input)) in_supported_networks = Traits::supported_networks(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->supported_networks)::BaseType>
        supported_networks_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& supported_networks_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::payments::mojom::internal::BasicCardNetwork_Data::Validate>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::payments::mojom::BasicCardNetwork>>(
      in_supported_networks,
      supported_networks_fragment,
      &supported_networks_validate_params);

    fragment->supported_networks.Set(
        supported_networks_fragment.is_null() ? nullptr : supported_networks_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->supported_networks.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null supported_networks in PaymentMethodData struct");

    decltype(Traits::secure_payment_confirmation(input)) in_secure_payment_confirmation = Traits::secure_payment_confirmation(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->secure_payment_confirmation)::BaseType> secure_payment_confirmation_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::payments::mojom::SecurePaymentConfirmationRequestDataView>(
      in_secure_payment_confirmation,
      secure_payment_confirmation_fragment);

    fragment->secure_payment_confirmation.Set(
        secure_payment_confirmation_fragment.is_null() ? nullptr : secure_payment_confirmation_fragment.data());
  }

  static bool Deserialize(::payments::mojom::internal::PaymentMethodData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::payments::mojom::PaymentMethodDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::payments::mojom::PaymentDetailsModifierDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::payments::mojom::PaymentDetailsModifierDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::payments::mojom::internal::PaymentDetailsModifier_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::total(input)) in_total = Traits::total(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->total)::BaseType> total_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::payments::mojom::PaymentItemDataView>(
      in_total,
      total_fragment);

    fragment->total.Set(
        total_fragment.is_null() ? nullptr : total_fragment.data());

    decltype(Traits::additional_display_items(input)) in_additional_display_items = Traits::additional_display_items(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->additional_display_items)::BaseType>
        additional_display_items_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& additional_display_items_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::payments::mojom::PaymentItemDataView>>(
      in_additional_display_items,
      additional_display_items_fragment,
      &additional_display_items_validate_params);

    fragment->additional_display_items.Set(
        additional_display_items_fragment.is_null() ? nullptr : additional_display_items_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->additional_display_items.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null additional_display_items in PaymentDetailsModifier struct");

    decltype(Traits::method_data(input)) in_method_data = Traits::method_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->method_data)::BaseType> method_data_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::payments::mojom::PaymentMethodDataDataView>(
      in_method_data,
      method_data_fragment);

    fragment->method_data.Set(
        method_data_fragment.is_null() ? nullptr : method_data_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->method_data.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null method_data in PaymentDetailsModifier struct");
  }

  static bool Deserialize(::payments::mojom::internal::PaymentDetailsModifier_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::payments::mojom::PaymentDetailsModifierDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::payments::mojom::PaymentDetailsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::payments::mojom::PaymentDetailsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::payments::mojom::internal::PaymentDetails_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::total(input)) in_total = Traits::total(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->total)::BaseType> total_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::payments::mojom::PaymentItemDataView>(
      in_total,
      total_fragment);

    fragment->total.Set(
        total_fragment.is_null() ? nullptr : total_fragment.data());

    decltype(Traits::display_items(input)) in_display_items = Traits::display_items(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->display_items)::BaseType>
        display_items_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& display_items_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::payments::mojom::PaymentItemDataView>>(
      in_display_items,
      display_items_fragment,
      &display_items_validate_params);

    fragment->display_items.Set(
        display_items_fragment.is_null() ? nullptr : display_items_fragment.data());

    decltype(Traits::shipping_options(input)) in_shipping_options = Traits::shipping_options(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->shipping_options)::BaseType>
        shipping_options_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& shipping_options_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::payments::mojom::PaymentShippingOptionDataView>>(
      in_shipping_options,
      shipping_options_fragment,
      &shipping_options_validate_params);

    fragment->shipping_options.Set(
        shipping_options_fragment.is_null() ? nullptr : shipping_options_fragment.data());

    decltype(Traits::modifiers(input)) in_modifiers = Traits::modifiers(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->modifiers)::BaseType>
        modifiers_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& modifiers_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::payments::mojom::PaymentDetailsModifierDataView>>(
      in_modifiers,
      modifiers_fragment,
      &modifiers_validate_params);

    fragment->modifiers.Set(
        modifiers_fragment.is_null() ? nullptr : modifiers_fragment.data());

    decltype(Traits::error(input)) in_error = Traits::error(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->error)::BaseType> error_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_error,
      error_fragment);

    fragment->error.Set(
        error_fragment.is_null() ? nullptr : error_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->error.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null error in PaymentDetails struct");

    decltype(Traits::shipping_address_errors(input)) in_shipping_address_errors = Traits::shipping_address_errors(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->shipping_address_errors)::BaseType> shipping_address_errors_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::payments::mojom::AddressErrorsDataView>(
      in_shipping_address_errors,
      shipping_address_errors_fragment);

    fragment->shipping_address_errors.Set(
        shipping_address_errors_fragment.is_null() ? nullptr : shipping_address_errors_fragment.data());

    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType> id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_id,
      id_fragment);

    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());

    decltype(Traits::stringified_payment_method_errors(input)) in_stringified_payment_method_errors = Traits::stringified_payment_method_errors(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->stringified_payment_method_errors)::BaseType> stringified_payment_method_errors_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_stringified_payment_method_errors,
      stringified_payment_method_errors_fragment);

    fragment->stringified_payment_method_errors.Set(
        stringified_payment_method_errors_fragment.is_null() ? nullptr : stringified_payment_method_errors_fragment.data());
  }

  static bool Deserialize(::payments::mojom::internal::PaymentDetails_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::payments::mojom::PaymentDetailsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::payments::mojom::PaymentOptionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::payments::mojom::PaymentOptionsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::payments::mojom::internal::PaymentOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->request_payer_name = Traits::request_payer_name(input);

    fragment->request_payer_email = Traits::request_payer_email(input);

    fragment->request_payer_phone = Traits::request_payer_phone(input);

    fragment->request_shipping = Traits::request_shipping(input);

    
    mojo::internal::Serialize<::payments::mojom::PaymentShippingType>(
      Traits::shipping_type(input),
      &fragment->shipping_type);
  }

  static bool Deserialize(::payments::mojom::internal::PaymentOptions_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::payments::mojom::PaymentOptionsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace payments::mojom {

inline void PaymentResponseDataView::GetMethodNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->method_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void PaymentResponseDataView::GetStringifiedDetailsDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->stringified_details.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void PaymentResponseDataView::GetShippingAddressDataView(
    ::payments::mojom::PaymentAddressDataView* output) {
  auto pointer = data_->shipping_address.Get();
  *output = ::payments::mojom::PaymentAddressDataView(pointer, message_);
}
inline void PaymentResponseDataView::GetShippingOptionDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->shipping_option.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void PaymentResponseDataView::GetPayerDataView(
    PayerDetailDataView* output) {
  auto pointer = data_->payer.Get();
  *output = PayerDetailDataView(pointer, message_);
}
inline void PaymentResponseDataView::GetGetAssertionAuthenticatorResponseDataView(
    ::blink::mojom::GetAssertionAuthenticatorResponseDataView* output) {
  auto pointer = data_->get_assertion_authenticator_response.Get();
  *output = ::blink::mojom::GetAssertionAuthenticatorResponseDataView(pointer, message_);
}


inline void PayerDetailDataView::GetEmailDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->email.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void PayerDetailDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void PayerDetailDataView::GetPhoneDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->phone.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void PaymentItemDataView::GetLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->label.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void PaymentItemDataView::GetAmountDataView(
    ::payments::mojom::PaymentCurrencyAmountDataView* output) {
  auto pointer = data_->amount.Get();
  *output = ::payments::mojom::PaymentCurrencyAmountDataView(pointer, message_);
}


inline void PaymentShippingOptionDataView::GetIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void PaymentShippingOptionDataView::GetLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->label.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void PaymentShippingOptionDataView::GetAmountDataView(
    ::payments::mojom::PaymentCurrencyAmountDataView* output) {
  auto pointer = data_->amount.Get();
  *output = ::payments::mojom::PaymentCurrencyAmountDataView(pointer, message_);
}


inline void SecurePaymentConfirmationRequestDataView::GetCredentialIdsDataView(
    mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>* output) {
  auto pointer = data_->credential_ids.Get();
  *output = mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>(pointer, message_);
}
inline void SecurePaymentConfirmationRequestDataView::GetChallengeDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->challenge.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}
inline void SecurePaymentConfirmationRequestDataView::GetInstrumentDataView(
    ::blink::mojom::PaymentCredentialInstrumentDataView* output) {
  auto pointer = data_->instrument.Get();
  *output = ::blink::mojom::PaymentCredentialInstrumentDataView(pointer, message_);
}
inline void SecurePaymentConfirmationRequestDataView::GetTimeoutDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->timeout.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void SecurePaymentConfirmationRequestDataView::GetPayeeOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->payee_origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}
inline void SecurePaymentConfirmationRequestDataView::GetPayeeNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->payee_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void SecurePaymentConfirmationRequestDataView::GetRpIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->rp_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void SecurePaymentConfirmationRequestDataView::GetExtensionsDataView(
    ::blink::mojom::AuthenticationExtensionsClientInputsDataView* output) {
  auto pointer = data_->extensions.Get();
  *output = ::blink::mojom::AuthenticationExtensionsClientInputsDataView(pointer, message_);
}
inline void SecurePaymentConfirmationRequestDataView::GetBrowserBoundPubKeyCredParamsDataView(
    mojo::ArrayDataView<::blink::mojom::PublicKeyCredentialParametersDataView>* output) {
  auto pointer = data_->browser_bound_pub_key_cred_params.Get();
  *output = mojo::ArrayDataView<::blink::mojom::PublicKeyCredentialParametersDataView>(pointer, message_);
}
inline void SecurePaymentConfirmationRequestDataView::GetPaymentEntitiesLogosDataView(
    mojo::ArrayDataView<PaymentEntityLogoDataView>* output) {
  auto pointer = data_->payment_entities_logos.Get();
  *output = mojo::ArrayDataView<PaymentEntityLogoDataView>(pointer, message_);
}


inline void NetworkOrIssuerInformationDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void NetworkOrIssuerInformationDataView::GetIconDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->icon.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}


inline void PaymentEntityLogoDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void PaymentEntityLogoDataView::GetLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->label.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void PaymentMethodDataDataView::GetSupportedMethodDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->supported_method.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void PaymentMethodDataDataView::GetStringifiedDataDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->stringified_data.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void PaymentMethodDataDataView::GetSupportedNetworksDataView(
    mojo::ArrayDataView<BasicCardNetwork>* output) {
  auto pointer = data_->supported_networks.Get();
  *output = mojo::ArrayDataView<BasicCardNetwork>(pointer, message_);
}
inline void PaymentMethodDataDataView::GetSecurePaymentConfirmationDataView(
    SecurePaymentConfirmationRequestDataView* output) {
  auto pointer = data_->secure_payment_confirmation.Get();
  *output = SecurePaymentConfirmationRequestDataView(pointer, message_);
}


inline void PaymentDetailsModifierDataView::GetTotalDataView(
    PaymentItemDataView* output) {
  auto pointer = data_->total.Get();
  *output = PaymentItemDataView(pointer, message_);
}
inline void PaymentDetailsModifierDataView::GetAdditionalDisplayItemsDataView(
    mojo::ArrayDataView<PaymentItemDataView>* output) {
  auto pointer = data_->additional_display_items.Get();
  *output = mojo::ArrayDataView<PaymentItemDataView>(pointer, message_);
}
inline void PaymentDetailsModifierDataView::GetMethodDataDataView(
    PaymentMethodDataDataView* output) {
  auto pointer = data_->method_data.Get();
  *output = PaymentMethodDataDataView(pointer, message_);
}


inline void PaymentDetailsDataView::GetTotalDataView(
    PaymentItemDataView* output) {
  auto pointer = data_->total.Get();
  *output = PaymentItemDataView(pointer, message_);
}
inline void PaymentDetailsDataView::GetDisplayItemsDataView(
    mojo::ArrayDataView<PaymentItemDataView>* output) {
  auto pointer = data_->display_items.Get();
  *output = mojo::ArrayDataView<PaymentItemDataView>(pointer, message_);
}
inline void PaymentDetailsDataView::GetShippingOptionsDataView(
    mojo::ArrayDataView<PaymentShippingOptionDataView>* output) {
  auto pointer = data_->shipping_options.Get();
  *output = mojo::ArrayDataView<PaymentShippingOptionDataView>(pointer, message_);
}
inline void PaymentDetailsDataView::GetModifiersDataView(
    mojo::ArrayDataView<PaymentDetailsModifierDataView>* output) {
  auto pointer = data_->modifiers.Get();
  *output = mojo::ArrayDataView<PaymentDetailsModifierDataView>(pointer, message_);
}
inline void PaymentDetailsDataView::GetErrorDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->error.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void PaymentDetailsDataView::GetShippingAddressErrorsDataView(
    ::payments::mojom::AddressErrorsDataView* output) {
  auto pointer = data_->shipping_address_errors.Get();
  *output = ::payments::mojom::AddressErrorsDataView(pointer, message_);
}
inline void PaymentDetailsDataView::GetIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void PaymentDetailsDataView::GetStringifiedPaymentMethodErrorsDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->stringified_payment_method_errors.Get();
  *output = mojo::StringDataView(pointer, message_);
}





}  // payments::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::payments::mojom::PaymentErrorReason> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::payments::mojom::PaymentErrorReason value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::payments::mojom::CanMakePaymentQueryResult> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::payments::mojom::CanMakePaymentQueryResult value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::payments::mojom::HasEnrolledInstrumentQueryResult> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::payments::mojom::HasEnrolledInstrumentQueryResult value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::payments::mojom::AndroidPayEnvironment> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::payments::mojom::AndroidPayEnvironment value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::payments::mojom::BasicCardNetwork> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::payments::mojom::BasicCardNetwork value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::payments::mojom::PaymentShippingType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::payments::mojom::PaymentShippingType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::payments::mojom::PaymentComplete> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::payments::mojom::PaymentComplete value);
};

} // namespace perfetto

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAYMENTS_PAYMENT_REQUEST_MOJOM_SHARED_H_