// third_party/blink/public/mojom/permissions/permission.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PERMISSIONS_PERMISSION_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PERMISSIONS_PERMISSION_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/permissions/permission.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/permissions/permission.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/permissions/permission.mojom-forward.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/permissions/permission_status.mojom-forward.h"
#include "url/mojom/origin.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {

class PermissionObserverProxy;

template <typename ImplRefTraits>
class PermissionObserverStub;

class PermissionObserverRequestValidator;


class BLINK_COMMON_EXPORT PermissionObserver
    : public PermissionObserverInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.PermissionObserver";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PermissionObserverInterfaceBase;
  using Proxy_ = PermissionObserverProxy;

  template <typename ImplRefTraits>
  using Stub_ = PermissionObserverStub<ImplRefTraits>;

  using RequestValidator_ = PermissionObserverRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnPermissionStatusChangeMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnPermissionStatusChange_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PermissionObserver() = default;

  virtual void OnPermissionStatusChange(::blink::mojom::PermissionStatus status) = 0;
};

class EmbeddedPermissionControlClientProxy;

template <typename ImplRefTraits>
class EmbeddedPermissionControlClientStub;

class EmbeddedPermissionControlClientRequestValidator;


class BLINK_COMMON_EXPORT EmbeddedPermissionControlClient
    : public EmbeddedPermissionControlClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.EmbeddedPermissionControlClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = EmbeddedPermissionControlClientInterfaceBase;
  using Proxy_ = EmbeddedPermissionControlClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = EmbeddedPermissionControlClientStub<ImplRefTraits>;

  using RequestValidator_ = EmbeddedPermissionControlClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnEmbeddedPermissionControlRegisteredMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnEmbeddedPermissionControlRegistered_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~EmbeddedPermissionControlClient() = default;

  virtual void OnEmbeddedPermissionControlRegistered(bool allow, const std::optional<std::vector<::blink::mojom::PermissionStatus>>& statuses) = 0;
};

class PermissionServiceProxy;

template <typename ImplRefTraits>
class PermissionServiceStub;

class PermissionServiceRequestValidator;
class PermissionServiceResponseValidator;


class BLINK_COMMON_EXPORT PermissionService
    : public PermissionServiceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.PermissionService";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PermissionServiceInterfaceBase;
  using Proxy_ = PermissionServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = PermissionServiceStub<ImplRefTraits>;

  using RequestValidator_ = PermissionServiceRequestValidator;
  using ResponseValidator_ = PermissionServiceResponseValidator;
  enum MethodMinVersions : uint32_t {
    kHasPermissionMinVersion = 0,
    kRegisterPageEmbeddedPermissionControlMinVersion = 0,
    kRequestPageEmbeddedPermissionMinVersion = 0,
    kRequestPermissionMinVersion = 0,
    kRequestPermissionsMinVersion = 0,
    kRevokePermissionMinVersion = 0,
    kAddPermissionObserverMinVersion = 0,
    kAddCombinedPermissionObserverMinVersion = 0,
    kNotifyEventListenerMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct HasPermission_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RegisterPageEmbeddedPermissionControl_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RequestPageEmbeddedPermission_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RequestPermission_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RequestPermissions_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RevokePermission_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AddPermissionObserver_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AddCombinedPermissionObserver_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NotifyEventListener_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PermissionService() = default;

  using HasPermissionCallback = base::OnceCallback<void(::blink::mojom::PermissionStatus)>;
  using HasPermissionMojoCallback = base::OnceCallback<void(::blink::mojom::PermissionStatus)>;

  virtual void HasPermission(PermissionDescriptorPtr permission, HasPermissionCallback callback) = 0;

  virtual void RegisterPageEmbeddedPermissionControl(std::vector<PermissionDescriptorPtr> permissions, ::mojo::PendingRemote<EmbeddedPermissionControlClient> client) = 0;

  using RequestPageEmbeddedPermissionCallback = base::OnceCallback<void(EmbeddedPermissionControlResult)>;
  using RequestPageEmbeddedPermissionMojoCallback = base::OnceCallback<void(EmbeddedPermissionControlResult)>;

  virtual void RequestPageEmbeddedPermission(EmbeddedPermissionRequestDescriptorPtr descriptor, RequestPageEmbeddedPermissionCallback callback) = 0;

  using RequestPermissionCallback = base::OnceCallback<void(::blink::mojom::PermissionStatus)>;
  using RequestPermissionMojoCallback = base::OnceCallback<void(::blink::mojom::PermissionStatus)>;

  virtual void RequestPermission(PermissionDescriptorPtr permission, bool user_gesture, RequestPermissionCallback callback) = 0;

  using RequestPermissionsCallback = base::OnceCallback<void(const std::vector<::blink::mojom::PermissionStatus>&)>;
  using RequestPermissionsMojoCallback = base::OnceCallback<void(const std::vector<::blink::mojom::PermissionStatus>&)>;

  virtual void RequestPermissions(std::vector<PermissionDescriptorPtr> permission, bool user_gesture, RequestPermissionsCallback callback) = 0;

  using RevokePermissionCallback = base::OnceCallback<void(::blink::mojom::PermissionStatus)>;
  using RevokePermissionMojoCallback = base::OnceCallback<void(::blink::mojom::PermissionStatus)>;

  virtual void RevokePermission(PermissionDescriptorPtr permission, RevokePermissionCallback callback) = 0;

  virtual void AddPermissionObserver(PermissionDescriptorPtr permission, ::blink::mojom::PermissionStatus last_known_status, ::mojo::PendingRemote<PermissionObserver> observer) = 0;

  virtual void AddCombinedPermissionObserver(PermissionDescriptorPtr permission, ::blink::mojom::PermissionStatus last_known_status, ::mojo::PendingRemote<PermissionObserver> observer) = 0;

  virtual void NotifyEventListener(PermissionDescriptorPtr permission, const std::string& event_type, bool is_added) = 0;
};



class BLINK_COMMON_EXPORT PermissionObserverProxy
    : public PermissionObserver {
 public:
  using InterfaceType = PermissionObserver;

  explicit PermissionObserverProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnPermissionStatusChange(::blink::mojom::PermissionStatus status) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_COMMON_EXPORT EmbeddedPermissionControlClientProxy
    : public EmbeddedPermissionControlClient {
 public:
  using InterfaceType = EmbeddedPermissionControlClient;

  explicit EmbeddedPermissionControlClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnEmbeddedPermissionControlRegistered(bool allow, const std::optional<std::vector<::blink::mojom::PermissionStatus>>& statuses) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_COMMON_EXPORT PermissionServiceProxy
    : public PermissionService {
 public:
  using InterfaceType = PermissionService;

  explicit PermissionServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void HasPermission(PermissionDescriptorPtr permission, HasPermissionCallback callback) final;
  
  void RegisterPageEmbeddedPermissionControl(std::vector<PermissionDescriptorPtr> permissions, ::mojo::PendingRemote<EmbeddedPermissionControlClient> client) final;
  
  void RequestPageEmbeddedPermission(EmbeddedPermissionRequestDescriptorPtr descriptor, RequestPageEmbeddedPermissionCallback callback) final;
  
  void RequestPermission(PermissionDescriptorPtr permission, bool user_gesture, RequestPermissionCallback callback) final;
  
  void RequestPermissions(std::vector<PermissionDescriptorPtr> permission, bool user_gesture, RequestPermissionsCallback callback) final;
  
  void RevokePermission(PermissionDescriptorPtr permission, RevokePermissionCallback callback) final;
  
  void AddPermissionObserver(PermissionDescriptorPtr permission, ::blink::mojom::PermissionStatus last_known_status, ::mojo::PendingRemote<PermissionObserver> observer) final;
  
  void AddCombinedPermissionObserver(PermissionDescriptorPtr permission, ::blink::mojom::PermissionStatus last_known_status, ::mojo::PendingRemote<PermissionObserver> observer) final;
  
  void NotifyEventListener(PermissionDescriptorPtr permission, const std::string& event_type, bool is_added) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT PermissionObserverStubDispatch {
 public:
  static bool Accept(PermissionObserver* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PermissionObserver* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PermissionObserver>>
class PermissionObserverStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PermissionObserverStub() = default;
  ~PermissionObserverStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PermissionObserverStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PermissionObserverStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT EmbeddedPermissionControlClientStubDispatch {
 public:
  static bool Accept(EmbeddedPermissionControlClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      EmbeddedPermissionControlClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<EmbeddedPermissionControlClient>>
class EmbeddedPermissionControlClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  EmbeddedPermissionControlClientStub() = default;
  ~EmbeddedPermissionControlClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return EmbeddedPermissionControlClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return EmbeddedPermissionControlClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT PermissionServiceStubDispatch {
 public:
  static bool Accept(PermissionService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PermissionService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PermissionService>>
class PermissionServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PermissionServiceStub() = default;
  ~PermissionServiceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PermissionServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PermissionServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT PermissionObserverRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT EmbeddedPermissionControlClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT PermissionServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT PermissionServiceResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class BLINK_COMMON_EXPORT MidiPermissionDescriptor {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<MidiPermissionDescriptor, T>::value>;
  using DataView = MidiPermissionDescriptorDataView;
  using Data_ = internal::MidiPermissionDescriptor_Data;

  template <typename... Args>
  static MidiPermissionDescriptorPtr New(Args&&... args) {
    return MidiPermissionDescriptorPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static MidiPermissionDescriptorPtr From(const U& u) {
    return mojo::TypeConverter<MidiPermissionDescriptorPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, MidiPermissionDescriptor>::Convert(*this);
  }


  MidiPermissionDescriptor();

  explicit MidiPermissionDescriptor(
      bool sysex);


  ~MidiPermissionDescriptor();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = MidiPermissionDescriptorPtr>
  MidiPermissionDescriptorPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, MidiPermissionDescriptor::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, MidiPermissionDescriptor::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, MidiPermissionDescriptor::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MidiPermissionDescriptor::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MidiPermissionDescriptor::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        MidiPermissionDescriptor::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::MidiPermissionDescriptor_UnserializedMessageContext<
            UserType, MidiPermissionDescriptor::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<MidiPermissionDescriptor::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return MidiPermissionDescriptor::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::MidiPermissionDescriptor_UnserializedMessageContext<
            UserType, MidiPermissionDescriptor::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<MidiPermissionDescriptor::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool sysex;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, MidiPermissionDescriptor::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, MidiPermissionDescriptor::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, MidiPermissionDescriptor::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, MidiPermissionDescriptor::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT ClipboardPermissionDescriptor {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ClipboardPermissionDescriptor, T>::value>;
  using DataView = ClipboardPermissionDescriptorDataView;
  using Data_ = internal::ClipboardPermissionDescriptor_Data;

  template <typename... Args>
  static ClipboardPermissionDescriptorPtr New(Args&&... args) {
    return ClipboardPermissionDescriptorPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ClipboardPermissionDescriptorPtr From(const U& u) {
    return mojo::TypeConverter<ClipboardPermissionDescriptorPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ClipboardPermissionDescriptor>::Convert(*this);
  }


  ClipboardPermissionDescriptor();

  ClipboardPermissionDescriptor(
      bool has_user_gesture,
      bool will_be_sanitized);


  ~ClipboardPermissionDescriptor();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ClipboardPermissionDescriptorPtr>
  ClipboardPermissionDescriptorPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ClipboardPermissionDescriptor::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ClipboardPermissionDescriptor::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ClipboardPermissionDescriptor::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ClipboardPermissionDescriptor::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ClipboardPermissionDescriptor::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ClipboardPermissionDescriptor::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ClipboardPermissionDescriptor_UnserializedMessageContext<
            UserType, ClipboardPermissionDescriptor::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ClipboardPermissionDescriptor::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ClipboardPermissionDescriptor::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ClipboardPermissionDescriptor_UnserializedMessageContext<
            UserType, ClipboardPermissionDescriptor::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ClipboardPermissionDescriptor::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool has_user_gesture;
  
  bool will_be_sanitized;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ClipboardPermissionDescriptor::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ClipboardPermissionDescriptor::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ClipboardPermissionDescriptor::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ClipboardPermissionDescriptor::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT CameraDevicePermissionDescriptor {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CameraDevicePermissionDescriptor, T>::value>;
  using DataView = CameraDevicePermissionDescriptorDataView;
  using Data_ = internal::CameraDevicePermissionDescriptor_Data;

  template <typename... Args>
  static CameraDevicePermissionDescriptorPtr New(Args&&... args) {
    return CameraDevicePermissionDescriptorPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CameraDevicePermissionDescriptorPtr From(const U& u) {
    return mojo::TypeConverter<CameraDevicePermissionDescriptorPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CameraDevicePermissionDescriptor>::Convert(*this);
  }


  CameraDevicePermissionDescriptor();

  explicit CameraDevicePermissionDescriptor(
      bool panTiltZoom);


  ~CameraDevicePermissionDescriptor();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CameraDevicePermissionDescriptorPtr>
  CameraDevicePermissionDescriptorPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CameraDevicePermissionDescriptor::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CameraDevicePermissionDescriptor::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CameraDevicePermissionDescriptor::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CameraDevicePermissionDescriptor::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CameraDevicePermissionDescriptor::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CameraDevicePermissionDescriptor::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CameraDevicePermissionDescriptor_UnserializedMessageContext<
            UserType, CameraDevicePermissionDescriptor::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CameraDevicePermissionDescriptor::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CameraDevicePermissionDescriptor::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CameraDevicePermissionDescriptor_UnserializedMessageContext<
            UserType, CameraDevicePermissionDescriptor::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CameraDevicePermissionDescriptor::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool panTiltZoom;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CameraDevicePermissionDescriptor::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CameraDevicePermissionDescriptor::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CameraDevicePermissionDescriptor::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CameraDevicePermissionDescriptor::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class BLINK_COMMON_EXPORT FullscreenPermissionDescriptor {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FullscreenPermissionDescriptor, T>::value>;
  using DataView = FullscreenPermissionDescriptorDataView;
  using Data_ = internal::FullscreenPermissionDescriptor_Data;

  template <typename... Args>
  static FullscreenPermissionDescriptorPtr New(Args&&... args) {
    return FullscreenPermissionDescriptorPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FullscreenPermissionDescriptorPtr From(const U& u) {
    return mojo::TypeConverter<FullscreenPermissionDescriptorPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FullscreenPermissionDescriptor>::Convert(*this);
  }


  FullscreenPermissionDescriptor();

  explicit FullscreenPermissionDescriptor(
      bool allow_without_user_gesture);


  ~FullscreenPermissionDescriptor();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FullscreenPermissionDescriptorPtr>
  FullscreenPermissionDescriptorPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FullscreenPermissionDescriptor::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FullscreenPermissionDescriptor::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FullscreenPermissionDescriptor::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FullscreenPermissionDescriptor::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FullscreenPermissionDescriptor::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FullscreenPermissionDescriptor::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FullscreenPermissionDescriptor_UnserializedMessageContext<
            UserType, FullscreenPermissionDescriptor::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FullscreenPermissionDescriptor::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FullscreenPermissionDescriptor::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FullscreenPermissionDescriptor_UnserializedMessageContext<
            UserType, FullscreenPermissionDescriptor::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FullscreenPermissionDescriptor::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool allow_without_user_gesture;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FullscreenPermissionDescriptor::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FullscreenPermissionDescriptor::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FullscreenPermissionDescriptor::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FullscreenPermissionDescriptor::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class BLINK_COMMON_EXPORT PermissionDescriptorExtension {
 public:
  using DataView = PermissionDescriptorExtensionDataView;
  using Data_ = internal::PermissionDescriptorExtension_Data;
  using Tag = Data_::PermissionDescriptorExtension_Tag;

  template <typename... Args>
  static PermissionDescriptorExtensionPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |midi|.
  static PermissionDescriptorExtensionPtr NewMidi(
      MidiPermissionDescriptorPtr value);
  // Construct an instance holding |clipboard|.
  static PermissionDescriptorExtensionPtr NewClipboard(
      ClipboardPermissionDescriptorPtr value);
  // Construct an instance holding |camera_device|.
  static PermissionDescriptorExtensionPtr NewCameraDevice(
      CameraDevicePermissionDescriptorPtr value);
  // Construct an instance holding |top_level_storage_access|.
  static PermissionDescriptorExtensionPtr NewTopLevelStorageAccess(
      TopLevelStorageAccessPermissionDescriptorPtr value);
  // Construct an instance holding |fullscreen|.
  static PermissionDescriptorExtensionPtr NewFullscreen(
      FullscreenPermissionDescriptorPtr value);

  template <typename U>
  static PermissionDescriptorExtensionPtr From(const U& u) {
    return mojo::TypeConverter<PermissionDescriptorExtensionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PermissionDescriptorExtension>::Convert(*this);
  }
  ~PermissionDescriptorExtension();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  PermissionDescriptorExtension(const PermissionDescriptorExtension& other) = delete;
  PermissionDescriptorExtension& operator=(const PermissionDescriptorExtension& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = PermissionDescriptorExtensionPtr>
  PermissionDescriptorExtensionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, PermissionDescriptorExtension>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, PermissionDescriptorExtension>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_midi() const { return tag_ == Tag::kMidi; }
  const MidiPermissionDescriptorPtr& get_midi() const {
    CHECK(tag_ == Tag::kMidi);
    return data_.midi;
  }
  MidiPermissionDescriptorPtr& get_midi() {
    CHECK(tag_ == Tag::kMidi);
    return data_.midi;
  }
  void set_midi(MidiPermissionDescriptorPtr midi);

  bool is_clipboard() const { return tag_ == Tag::kClipboard; }
  const ClipboardPermissionDescriptorPtr& get_clipboard() const {
    CHECK(tag_ == Tag::kClipboard);
    return data_.clipboard;
  }
  ClipboardPermissionDescriptorPtr& get_clipboard() {
    CHECK(tag_ == Tag::kClipboard);
    return data_.clipboard;
  }
  void set_clipboard(ClipboardPermissionDescriptorPtr clipboard);

  bool is_camera_device() const { return tag_ == Tag::kCameraDevice; }
  const CameraDevicePermissionDescriptorPtr& get_camera_device() const {
    CHECK(tag_ == Tag::kCameraDevice);
    return data_.camera_device;
  }
  CameraDevicePermissionDescriptorPtr& get_camera_device() {
    CHECK(tag_ == Tag::kCameraDevice);
    return data_.camera_device;
  }
  void set_camera_device(CameraDevicePermissionDescriptorPtr camera_device);

  bool is_top_level_storage_access() const { return tag_ == Tag::kTopLevelStorageAccess; }
  const TopLevelStorageAccessPermissionDescriptorPtr& get_top_level_storage_access() const {
    CHECK(tag_ == Tag::kTopLevelStorageAccess);
    return data_.top_level_storage_access;
  }
  TopLevelStorageAccessPermissionDescriptorPtr& get_top_level_storage_access() {
    CHECK(tag_ == Tag::kTopLevelStorageAccess);
    return data_.top_level_storage_access;
  }
  void set_top_level_storage_access(TopLevelStorageAccessPermissionDescriptorPtr top_level_storage_access);

  bool is_fullscreen() const { return tag_ == Tag::kFullscreen; }
  const FullscreenPermissionDescriptorPtr& get_fullscreen() const {
    CHECK(tag_ == Tag::kFullscreen);
    return data_.fullscreen;
  }
  FullscreenPermissionDescriptorPtr& get_fullscreen() {
    CHECK(tag_ == Tag::kFullscreen);
    return data_.fullscreen;
  }
  void set_fullscreen(FullscreenPermissionDescriptorPtr fullscreen);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PermissionDescriptorExtension::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<PermissionDescriptorExtension::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kMidi)>,
        MidiPermissionDescriptorPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kClipboard)>,
        ClipboardPermissionDescriptorPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kCameraDevice)>,
        CameraDevicePermissionDescriptorPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kTopLevelStorageAccess)>,
        TopLevelStorageAccessPermissionDescriptorPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kFullscreen)>,
        FullscreenPermissionDescriptorPtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    MidiPermissionDescriptorPtr midi;
    ClipboardPermissionDescriptorPtr clipboard;
    CameraDevicePermissionDescriptorPtr camera_device;
    TopLevelStorageAccessPermissionDescriptorPtr top_level_storage_access;
    FullscreenPermissionDescriptorPtr fullscreen;
  };

  PermissionDescriptorExtension(
      std::in_place_index_t<static_cast<size_t>(Tag::kMidi)>,
      MidiPermissionDescriptorPtr value);
  PermissionDescriptorExtension(
      std::in_place_index_t<static_cast<size_t>(Tag::kClipboard)>,
      ClipboardPermissionDescriptorPtr value);
  PermissionDescriptorExtension(
      std::in_place_index_t<static_cast<size_t>(Tag::kCameraDevice)>,
      CameraDevicePermissionDescriptorPtr value);
  PermissionDescriptorExtension(
      std::in_place_index_t<static_cast<size_t>(Tag::kTopLevelStorageAccess)>,
      TopLevelStorageAccessPermissionDescriptorPtr value);
  PermissionDescriptorExtension(
      std::in_place_index_t<static_cast<size_t>(Tag::kFullscreen)>,
      FullscreenPermissionDescriptorPtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};








class BLINK_COMMON_EXPORT TopLevelStorageAccessPermissionDescriptor {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TopLevelStorageAccessPermissionDescriptor, T>::value>;
  using DataView = TopLevelStorageAccessPermissionDescriptorDataView;
  using Data_ = internal::TopLevelStorageAccessPermissionDescriptor_Data;

  template <typename... Args>
  static TopLevelStorageAccessPermissionDescriptorPtr New(Args&&... args) {
    return TopLevelStorageAccessPermissionDescriptorPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TopLevelStorageAccessPermissionDescriptorPtr From(const U& u) {
    return mojo::TypeConverter<TopLevelStorageAccessPermissionDescriptorPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TopLevelStorageAccessPermissionDescriptor>::Convert(*this);
  }


  TopLevelStorageAccessPermissionDescriptor();

  explicit TopLevelStorageAccessPermissionDescriptor(
      const ::url::Origin& requestedOrigin);


  ~TopLevelStorageAccessPermissionDescriptor();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TopLevelStorageAccessPermissionDescriptorPtr>
  TopLevelStorageAccessPermissionDescriptorPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TopLevelStorageAccessPermissionDescriptor::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TopLevelStorageAccessPermissionDescriptor::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TopLevelStorageAccessPermissionDescriptor::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TopLevelStorageAccessPermissionDescriptor::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TopLevelStorageAccessPermissionDescriptor::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TopLevelStorageAccessPermissionDescriptor::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TopLevelStorageAccessPermissionDescriptor_UnserializedMessageContext<
            UserType, TopLevelStorageAccessPermissionDescriptor::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TopLevelStorageAccessPermissionDescriptor::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TopLevelStorageAccessPermissionDescriptor::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TopLevelStorageAccessPermissionDescriptor_UnserializedMessageContext<
            UserType, TopLevelStorageAccessPermissionDescriptor::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TopLevelStorageAccessPermissionDescriptor::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::url::Origin requestedOrigin;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TopLevelStorageAccessPermissionDescriptor::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TopLevelStorageAccessPermissionDescriptor::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TopLevelStorageAccessPermissionDescriptor::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TopLevelStorageAccessPermissionDescriptor::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class BLINK_COMMON_EXPORT PermissionDescriptor {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PermissionDescriptor, T>::value>;
  using DataView = PermissionDescriptorDataView;
  using Data_ = internal::PermissionDescriptor_Data;

  template <typename... Args>
  static PermissionDescriptorPtr New(Args&&... args) {
    return PermissionDescriptorPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PermissionDescriptorPtr From(const U& u) {
    return mojo::TypeConverter<PermissionDescriptorPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PermissionDescriptor>::Convert(*this);
  }


  PermissionDescriptor();

  PermissionDescriptor(
      PermissionName name,
      PermissionDescriptorExtensionPtr extension);

PermissionDescriptor(const PermissionDescriptor&) = delete;
PermissionDescriptor& operator=(const PermissionDescriptor&) = delete;

  ~PermissionDescriptor();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PermissionDescriptorPtr>
  PermissionDescriptorPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PermissionDescriptor::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PermissionDescriptor::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PermissionDescriptor::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PermissionDescriptor::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PermissionDescriptor::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PermissionDescriptor::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PermissionDescriptor_UnserializedMessageContext<
            UserType, PermissionDescriptor::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PermissionDescriptor::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PermissionDescriptor::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PermissionDescriptor_UnserializedMessageContext<
            UserType, PermissionDescriptor::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PermissionDescriptor::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  PermissionName name;
  
  PermissionDescriptorExtensionPtr extension;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PermissionDescriptor::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PermissionDescriptor::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PermissionDescriptor::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PermissionDescriptor::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT EmbeddedPermissionRequestDescriptor {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<EmbeddedPermissionRequestDescriptor, T>::value>;
  using DataView = EmbeddedPermissionRequestDescriptorDataView;
  using Data_ = internal::EmbeddedPermissionRequestDescriptor_Data;

  template <typename... Args>
  static EmbeddedPermissionRequestDescriptorPtr New(Args&&... args) {
    return EmbeddedPermissionRequestDescriptorPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static EmbeddedPermissionRequestDescriptorPtr From(const U& u) {
    return mojo::TypeConverter<EmbeddedPermissionRequestDescriptorPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, EmbeddedPermissionRequestDescriptor>::Convert(*this);
  }


  EmbeddedPermissionRequestDescriptor();

  EmbeddedPermissionRequestDescriptor(
      std::vector<PermissionDescriptorPtr> permissions,
      const ::gfx::Rect& element_position);

EmbeddedPermissionRequestDescriptor(const EmbeddedPermissionRequestDescriptor&) = delete;
EmbeddedPermissionRequestDescriptor& operator=(const EmbeddedPermissionRequestDescriptor&) = delete;

  ~EmbeddedPermissionRequestDescriptor();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = EmbeddedPermissionRequestDescriptorPtr>
  EmbeddedPermissionRequestDescriptorPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, EmbeddedPermissionRequestDescriptor::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, EmbeddedPermissionRequestDescriptor::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, EmbeddedPermissionRequestDescriptor::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        EmbeddedPermissionRequestDescriptor::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        EmbeddedPermissionRequestDescriptor::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        EmbeddedPermissionRequestDescriptor::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::EmbeddedPermissionRequestDescriptor_UnserializedMessageContext<
            UserType, EmbeddedPermissionRequestDescriptor::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<EmbeddedPermissionRequestDescriptor::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return EmbeddedPermissionRequestDescriptor::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::EmbeddedPermissionRequestDescriptor_UnserializedMessageContext<
            UserType, EmbeddedPermissionRequestDescriptor::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<EmbeddedPermissionRequestDescriptor::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<PermissionDescriptorPtr> permissions;
  
  ::gfx::Rect element_position;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, EmbeddedPermissionRequestDescriptor::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, EmbeddedPermissionRequestDescriptor::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, EmbeddedPermissionRequestDescriptor::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, EmbeddedPermissionRequestDescriptor::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
PermissionDescriptorExtensionPtr PermissionDescriptorExtension::Clone() const {
  switch (tag_) {
    case Tag::kMidi:
      return NewMidi(
          mojo::Clone(data_.midi));
    case Tag::kClipboard:
      return NewClipboard(
          mojo::Clone(data_.clipboard));
    case Tag::kCameraDevice:
      return NewCameraDevice(
          mojo::Clone(data_.camera_device));
    case Tag::kTopLevelStorageAccess:
      return NewTopLevelStorageAccess(
          mojo::Clone(data_.top_level_storage_access));
    case Tag::kFullscreen:
      return NewFullscreen(
          mojo::Clone(data_.fullscreen));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, PermissionDescriptorExtension>::value>::type*>
bool PermissionDescriptorExtension::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kMidi:
      return mojo::Equals(data_.midi, other.data_.midi);
    case Tag::kClipboard:
      return mojo::Equals(data_.clipboard, other.data_.clipboard);
    case Tag::kCameraDevice:
      return mojo::Equals(data_.camera_device, other.data_.camera_device);
    case Tag::kTopLevelStorageAccess:
      return mojo::Equals(data_.top_level_storage_access, other.data_.top_level_storage_access);
    case Tag::kFullscreen:
      return mojo::Equals(data_.fullscreen, other.data_.fullscreen);
  }

  return false;
}
template <typename StructPtrType>
MidiPermissionDescriptorPtr MidiPermissionDescriptor::Clone() const {
  return New(
      mojo::Clone(sysex)
  );
}

template <typename T, MidiPermissionDescriptor::EnableIfSame<T>*>
bool MidiPermissionDescriptor::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->sysex, other_struct.sysex))
    return false;
  return true;
}

template <typename T, MidiPermissionDescriptor::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.sysex < rhs.sysex)
    return true;
  if (rhs.sysex < lhs.sysex)
    return false;
  return false;
}
template <typename StructPtrType>
ClipboardPermissionDescriptorPtr ClipboardPermissionDescriptor::Clone() const {
  return New(
      mojo::Clone(has_user_gesture),
      mojo::Clone(will_be_sanitized)
  );
}

template <typename T, ClipboardPermissionDescriptor::EnableIfSame<T>*>
bool ClipboardPermissionDescriptor::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->has_user_gesture, other_struct.has_user_gesture))
    return false;
  if (!mojo::Equals(this->will_be_sanitized, other_struct.will_be_sanitized))
    return false;
  return true;
}

template <typename T, ClipboardPermissionDescriptor::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.has_user_gesture < rhs.has_user_gesture)
    return true;
  if (rhs.has_user_gesture < lhs.has_user_gesture)
    return false;
  if (lhs.will_be_sanitized < rhs.will_be_sanitized)
    return true;
  if (rhs.will_be_sanitized < lhs.will_be_sanitized)
    return false;
  return false;
}
template <typename StructPtrType>
CameraDevicePermissionDescriptorPtr CameraDevicePermissionDescriptor::Clone() const {
  return New(
      mojo::Clone(panTiltZoom)
  );
}

template <typename T, CameraDevicePermissionDescriptor::EnableIfSame<T>*>
bool CameraDevicePermissionDescriptor::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->panTiltZoom, other_struct.panTiltZoom))
    return false;
  return true;
}

template <typename T, CameraDevicePermissionDescriptor::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.panTiltZoom < rhs.panTiltZoom)
    return true;
  if (rhs.panTiltZoom < lhs.panTiltZoom)
    return false;
  return false;
}
template <typename StructPtrType>
TopLevelStorageAccessPermissionDescriptorPtr TopLevelStorageAccessPermissionDescriptor::Clone() const {
  return New(
      mojo::Clone(requestedOrigin)
  );
}

template <typename T, TopLevelStorageAccessPermissionDescriptor::EnableIfSame<T>*>
bool TopLevelStorageAccessPermissionDescriptor::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->requestedOrigin, other_struct.requestedOrigin))
    return false;
  return true;
}

template <typename T, TopLevelStorageAccessPermissionDescriptor::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.requestedOrigin < rhs.requestedOrigin)
    return true;
  if (rhs.requestedOrigin < lhs.requestedOrigin)
    return false;
  return false;
}
template <typename StructPtrType>
FullscreenPermissionDescriptorPtr FullscreenPermissionDescriptor::Clone() const {
  return New(
      mojo::Clone(allow_without_user_gesture)
  );
}

template <typename T, FullscreenPermissionDescriptor::EnableIfSame<T>*>
bool FullscreenPermissionDescriptor::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->allow_without_user_gesture, other_struct.allow_without_user_gesture))
    return false;
  return true;
}

template <typename T, FullscreenPermissionDescriptor::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.allow_without_user_gesture < rhs.allow_without_user_gesture)
    return true;
  if (rhs.allow_without_user_gesture < lhs.allow_without_user_gesture)
    return false;
  return false;
}
template <typename StructPtrType>
PermissionDescriptorPtr PermissionDescriptor::Clone() const {
  return New(
      mojo::Clone(name),
      mojo::Clone(extension)
  );
}

template <typename T, PermissionDescriptor::EnableIfSame<T>*>
bool PermissionDescriptor::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->extension, other_struct.extension))
    return false;
  return true;
}

template <typename T, PermissionDescriptor::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.extension < rhs.extension)
    return true;
  if (rhs.extension < lhs.extension)
    return false;
  return false;
}
template <typename StructPtrType>
EmbeddedPermissionRequestDescriptorPtr EmbeddedPermissionRequestDescriptor::Clone() const {
  return New(
      mojo::Clone(permissions),
      mojo::Clone(element_position)
  );
}

template <typename T, EmbeddedPermissionRequestDescriptor::EnableIfSame<T>*>
bool EmbeddedPermissionRequestDescriptor::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->permissions, other_struct.permissions))
    return false;
  if (!mojo::Equals(this->element_position, other_struct.element_position))
    return false;
  return true;
}

template <typename T, EmbeddedPermissionRequestDescriptor::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.permissions < rhs.permissions)
    return true;
  if (rhs.permissions < lhs.permissions)
    return false;
  if (lhs.element_position < rhs.element_position)
    return true;
  if (rhs.element_position < lhs.element_position)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::MidiPermissionDescriptor::DataView,
                                         ::blink::mojom::MidiPermissionDescriptorPtr> {
  static bool IsNull(const ::blink::mojom::MidiPermissionDescriptorPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::MidiPermissionDescriptorPtr* output) { output->reset(); }

  static decltype(::blink::mojom::MidiPermissionDescriptor::sysex) sysex(
      const ::blink::mojom::MidiPermissionDescriptorPtr& input) {
    return input->sysex;
  }

  static bool Read(::blink::mojom::MidiPermissionDescriptor::DataView input, ::blink::mojom::MidiPermissionDescriptorPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::ClipboardPermissionDescriptor::DataView,
                                         ::blink::mojom::ClipboardPermissionDescriptorPtr> {
  static bool IsNull(const ::blink::mojom::ClipboardPermissionDescriptorPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::ClipboardPermissionDescriptorPtr* output) { output->reset(); }

  static decltype(::blink::mojom::ClipboardPermissionDescriptor::has_user_gesture) has_user_gesture(
      const ::blink::mojom::ClipboardPermissionDescriptorPtr& input) {
    return input->has_user_gesture;
  }

  static decltype(::blink::mojom::ClipboardPermissionDescriptor::will_be_sanitized) will_be_sanitized(
      const ::blink::mojom::ClipboardPermissionDescriptorPtr& input) {
    return input->will_be_sanitized;
  }

  static bool Read(::blink::mojom::ClipboardPermissionDescriptor::DataView input, ::blink::mojom::ClipboardPermissionDescriptorPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::CameraDevicePermissionDescriptor::DataView,
                                         ::blink::mojom::CameraDevicePermissionDescriptorPtr> {
  static bool IsNull(const ::blink::mojom::CameraDevicePermissionDescriptorPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::CameraDevicePermissionDescriptorPtr* output) { output->reset(); }

  static decltype(::blink::mojom::CameraDevicePermissionDescriptor::panTiltZoom) panTiltZoom(
      const ::blink::mojom::CameraDevicePermissionDescriptorPtr& input) {
    return input->panTiltZoom;
  }

  static bool Read(::blink::mojom::CameraDevicePermissionDescriptor::DataView input, ::blink::mojom::CameraDevicePermissionDescriptorPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::TopLevelStorageAccessPermissionDescriptor::DataView,
                                         ::blink::mojom::TopLevelStorageAccessPermissionDescriptorPtr> {
  static bool IsNull(const ::blink::mojom::TopLevelStorageAccessPermissionDescriptorPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::TopLevelStorageAccessPermissionDescriptorPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::TopLevelStorageAccessPermissionDescriptor::requestedOrigin)& requestedOrigin(
      const ::blink::mojom::TopLevelStorageAccessPermissionDescriptorPtr& input) {
    return input->requestedOrigin;
  }

  static bool Read(::blink::mojom::TopLevelStorageAccessPermissionDescriptor::DataView input, ::blink::mojom::TopLevelStorageAccessPermissionDescriptorPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::FullscreenPermissionDescriptor::DataView,
                                         ::blink::mojom::FullscreenPermissionDescriptorPtr> {
  static bool IsNull(const ::blink::mojom::FullscreenPermissionDescriptorPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::FullscreenPermissionDescriptorPtr* output) { output->reset(); }

  static decltype(::blink::mojom::FullscreenPermissionDescriptor::allow_without_user_gesture) allow_without_user_gesture(
      const ::blink::mojom::FullscreenPermissionDescriptorPtr& input) {
    return input->allow_without_user_gesture;
  }

  static bool Read(::blink::mojom::FullscreenPermissionDescriptor::DataView input, ::blink::mojom::FullscreenPermissionDescriptorPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::PermissionDescriptor::DataView,
                                         ::blink::mojom::PermissionDescriptorPtr> {
  static bool IsNull(const ::blink::mojom::PermissionDescriptorPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::PermissionDescriptorPtr* output) { output->reset(); }

  static decltype(::blink::mojom::PermissionDescriptor::name) name(
      const ::blink::mojom::PermissionDescriptorPtr& input) {
    return input->name;
  }

  static const decltype(::blink::mojom::PermissionDescriptor::extension)& extension(
      const ::blink::mojom::PermissionDescriptorPtr& input) {
    return input->extension;
  }

  static bool Read(::blink::mojom::PermissionDescriptor::DataView input, ::blink::mojom::PermissionDescriptorPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::EmbeddedPermissionRequestDescriptor::DataView,
                                         ::blink::mojom::EmbeddedPermissionRequestDescriptorPtr> {
  static bool IsNull(const ::blink::mojom::EmbeddedPermissionRequestDescriptorPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::EmbeddedPermissionRequestDescriptorPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::EmbeddedPermissionRequestDescriptor::permissions)& permissions(
      const ::blink::mojom::EmbeddedPermissionRequestDescriptorPtr& input) {
    return input->permissions;
  }

  static const decltype(::blink::mojom::EmbeddedPermissionRequestDescriptor::element_position)& element_position(
      const ::blink::mojom::EmbeddedPermissionRequestDescriptorPtr& input) {
    return input->element_position;
  }

  static bool Read(::blink::mojom::EmbeddedPermissionRequestDescriptor::DataView input, ::blink::mojom::EmbeddedPermissionRequestDescriptorPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT UnionTraits<::blink::mojom::PermissionDescriptorExtension::DataView,
                                        ::blink::mojom::PermissionDescriptorExtensionPtr> {
  static bool IsNull(const ::blink::mojom::PermissionDescriptorExtensionPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::PermissionDescriptorExtensionPtr* output) { output->reset(); }

  static ::blink::mojom::PermissionDescriptorExtension::Tag GetTag(const ::blink::mojom::PermissionDescriptorExtensionPtr& input) {
    return input->which();
  }

  static const ::blink::mojom::MidiPermissionDescriptorPtr& midi(const ::blink::mojom::PermissionDescriptorExtensionPtr& input) {
    return input->get_midi();
  }

  static const ::blink::mojom::ClipboardPermissionDescriptorPtr& clipboard(const ::blink::mojom::PermissionDescriptorExtensionPtr& input) {
    return input->get_clipboard();
  }

  static const ::blink::mojom::CameraDevicePermissionDescriptorPtr& camera_device(const ::blink::mojom::PermissionDescriptorExtensionPtr& input) {
    return input->get_camera_device();
  }

  static const ::blink::mojom::TopLevelStorageAccessPermissionDescriptorPtr& top_level_storage_access(const ::blink::mojom::PermissionDescriptorExtensionPtr& input) {
    return input->get_top_level_storage_access();
  }

  static const ::blink::mojom::FullscreenPermissionDescriptorPtr& fullscreen(const ::blink::mojom::PermissionDescriptorExtensionPtr& input) {
    return input->get_fullscreen();
  }

  static bool Read(::blink::mojom::PermissionDescriptorExtension::DataView input, ::blink::mojom::PermissionDescriptorExtensionPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PERMISSIONS_PERMISSION_MOJOM_H_