// third_party/blink/public/mojom/shared_storage/shared_storage.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SHARED_STORAGE_SHARED_STORAGE_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SHARED_STORAGE_SHARED_STORAGE_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/shared_storage/shared_storage.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/shared_storage/shared_storage.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/shared_storage/shared_storage.mojom-blink-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/string16.mojom-blink.h"
#include "mojo/public/mojom/base/time.mojom-blink.h"
#include "services/network/public/mojom/fetch_api.mojom-blink-forward.h"
#include "services/network/public/mojom/shared_storage.mojom-blink.h"
#include "third_party/blink/public/mojom/fenced_frame/fenced_frame_config.mojom-blink.h"
#include "third_party/blink/public/mojom/messaging/cloneable_message.mojom-blink.h"
#include "third_party/blink/public/mojom/origin_trials/origin_trial_feature.mojom-blink-forward.h"
#include "url/mojom/origin.mojom-blink.h"
#include "url/mojom/url.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/renderer/modules/modules_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {

class SharedStorageWorkletHostProxy;

template <typename ImplRefTraits>
class SharedStorageWorkletHostStub;

class SharedStorageWorkletHostRequestValidator;
class SharedStorageWorkletHostResponseValidator;


class MODULES_EXPORT SharedStorageWorkletHost
    : public SharedStorageWorkletHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.SharedStorageWorkletHost";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SharedStorageWorkletHostInterfaceBase;
  using Proxy_ = SharedStorageWorkletHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = SharedStorageWorkletHostStub<ImplRefTraits>;

  using RequestValidator_ = SharedStorageWorkletHostRequestValidator;
  using ResponseValidator_ = SharedStorageWorkletHostResponseValidator;
  enum MethodMinVersions : uint32_t {
    kSelectURLMinVersion = 0,
    kRunMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SelectURL_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Run_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SharedStorageWorkletHost() = default;

  using SelectURLCallback = base::OnceCallback<void(bool, const ::blink::String&, const std::optional<::blink::FencedFrame::RedactedFencedFrameConfig>&)>;
  using SelectURLMojoCallback = base::OnceCallback<void(bool, const ::blink::String&, const std::optional<::blink::FencedFrame::RedactedFencedFrameConfig>&)>;

  virtual void SelectURL(const ::blink::String& name, ::blink::Vector<SharedStorageUrlWithMetadataPtr> urls_with_metadata, ::blink::BlinkCloneableMessage serialized_data, bool keep_alive_after_operation, PrivateAggregationConfigPtr private_aggregation_config, bool resolve_to_config, const ::blink::String& saved_query_name, ::base::TimeTicks start_time, SelectURLCallback callback) = 0;

  using RunCallback = base::OnceCallback<void(bool, const ::blink::String&)>;
  using RunMojoCallback = base::OnceCallback<void(bool, const ::blink::String&)>;

  virtual void Run(const ::blink::String& name, ::blink::BlinkCloneableMessage serialized_data, bool keep_alive_after_operation, PrivateAggregationConfigPtr private_aggregation_config, ::base::TimeTicks start_time, RunCallback callback) = 0;
};

class SharedStorageDocumentServiceProxy;

template <typename ImplRefTraits>
class SharedStorageDocumentServiceStub;

class SharedStorageDocumentServiceRequestValidator;
class SharedStorageDocumentServiceResponseValidator;


class MODULES_EXPORT SharedStorageDocumentService
    : public SharedStorageDocumentServiceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.SharedStorageDocumentService";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SharedStorageDocumentServiceInterfaceBase;
  using Proxy_ = SharedStorageDocumentServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = SharedStorageDocumentServiceStub<ImplRefTraits>;

  using RequestValidator_ = SharedStorageDocumentServiceRequestValidator;
  using ResponseValidator_ = SharedStorageDocumentServiceResponseValidator;
  enum MethodMinVersions : uint32_t {
    kCreateWorkletMinVersion = 0,
    kSharedStorageGetMinVersion = 0,
    kSharedStorageUpdateMinVersion = 0,
    kSharedStorageBatchUpdateMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreateWorklet_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SharedStorageGet_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SharedStorageUpdate_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SharedStorageBatchUpdate_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SharedStorageDocumentService() = default;

  using CreateWorkletCallback = base::OnceCallback<void(bool, const ::blink::String&)>;
  using CreateWorkletMojoCallback = base::OnceCallback<void(bool, const ::blink::String&)>;

  virtual void CreateWorklet(const ::blink::KURL& script_source_url, const ::scoped_refptr<const ::blink::SecurityOrigin>& data_origin, SharedStorageDataOriginType data_origin_type, ::network::mojom::blink::CredentialsMode credentials_mode, SharedStorageWorkletCreationMethod creation_method, const ::blink::Vector<::blink::mojom::blink::OriginTrialFeature>& origin_trial_features, ::mojo::PendingAssociatedReceiver<SharedStorageWorkletHost> worklet_host, CreateWorkletCallback callback) = 0;

  using SharedStorageGetCallback = base::OnceCallback<void(SharedStorageGetStatus, const ::blink::String&, const ::blink::String&)>;
  using SharedStorageGetMojoCallback = base::OnceCallback<void(SharedStorageGetStatus, const ::blink::String&, const ::blink::String&)>;

  virtual void SharedStorageGet(const ::WTF::String& key, SharedStorageGetCallback callback) = 0;

  using SharedStorageUpdateCallback = base::OnceCallback<void(const ::blink::String&)>;
  using SharedStorageUpdateMojoCallback = base::OnceCallback<void(const ::blink::String&)>;

  virtual void SharedStorageUpdate(::network::mojom::blink::SharedStorageModifierMethodWithOptionsPtr method_with_options, SharedStorageUpdateCallback callback) = 0;

  using SharedStorageBatchUpdateCallback = base::OnceCallback<void(const ::blink::String&)>;
  using SharedStorageBatchUpdateMojoCallback = base::OnceCallback<void(const ::blink::String&)>;

  virtual void SharedStorageBatchUpdate(::WTF::Vector<::network::mojom::blink::SharedStorageModifierMethodWithOptionsPtr> methods_with_options, const std::optional<::WTF::String>& with_lock, SharedStorageBatchUpdateCallback callback) = 0;
};



class MODULES_EXPORT SharedStorageWorkletHostProxy
    : public SharedStorageWorkletHost {
 public:
  using InterfaceType = SharedStorageWorkletHost;

  explicit SharedStorageWorkletHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SelectURL(const ::blink::String& name, ::blink::Vector<SharedStorageUrlWithMetadataPtr> urls_with_metadata, ::blink::BlinkCloneableMessage serialized_data, bool keep_alive_after_operation, PrivateAggregationConfigPtr private_aggregation_config, bool resolve_to_config, const ::blink::String& saved_query_name, ::base::TimeTicks start_time, SelectURLCallback callback) final;
  
  void Run(const ::blink::String& name, ::blink::BlinkCloneableMessage serialized_data, bool keep_alive_after_operation, PrivateAggregationConfigPtr private_aggregation_config, ::base::TimeTicks start_time, RunCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class MODULES_EXPORT SharedStorageDocumentServiceProxy
    : public SharedStorageDocumentService {
 public:
  using InterfaceType = SharedStorageDocumentService;

  explicit SharedStorageDocumentServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateWorklet(const ::blink::KURL& script_source_url, const ::scoped_refptr<const ::blink::SecurityOrigin>& data_origin, SharedStorageDataOriginType data_origin_type, ::network::mojom::blink::CredentialsMode credentials_mode, SharedStorageWorkletCreationMethod creation_method, const ::blink::Vector<::blink::mojom::blink::OriginTrialFeature>& origin_trial_features, ::mojo::PendingAssociatedReceiver<SharedStorageWorkletHost> worklet_host, CreateWorkletCallback callback) final;
  
  void SharedStorageGet(const ::WTF::String& key, SharedStorageGetCallback callback) final;
  
  void SharedStorageUpdate(::network::mojom::blink::SharedStorageModifierMethodWithOptionsPtr method_with_options, SharedStorageUpdateCallback callback) final;
  
  void SharedStorageBatchUpdate(::WTF::Vector<::network::mojom::blink::SharedStorageModifierMethodWithOptionsPtr> methods_with_options, const std::optional<::WTF::String>& with_lock, SharedStorageBatchUpdateCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class MODULES_EXPORT SharedStorageWorkletHostStubDispatch {
 public:
  static bool Accept(SharedStorageWorkletHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SharedStorageWorkletHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SharedStorageWorkletHost>>
class SharedStorageWorkletHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SharedStorageWorkletHostStub() = default;
  ~SharedStorageWorkletHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SharedStorageWorkletHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SharedStorageWorkletHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class MODULES_EXPORT SharedStorageDocumentServiceStubDispatch {
 public:
  static bool Accept(SharedStorageDocumentService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SharedStorageDocumentService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SharedStorageDocumentService>>
class SharedStorageDocumentServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SharedStorageDocumentServiceStub() = default;
  ~SharedStorageDocumentServiceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SharedStorageDocumentServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SharedStorageDocumentServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class MODULES_EXPORT SharedStorageWorkletHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class MODULES_EXPORT SharedStorageDocumentServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class MODULES_EXPORT SharedStorageWorkletHostResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class MODULES_EXPORT SharedStorageDocumentServiceResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};









class MODULES_EXPORT SharedStorageUrlWithMetadata {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SharedStorageUrlWithMetadata, T>::value>;
  using DataView = SharedStorageUrlWithMetadataDataView;
  using Data_ = internal::SharedStorageUrlWithMetadata_Data;

  template <typename... Args>
  static SharedStorageUrlWithMetadataPtr New(Args&&... args) {
    return SharedStorageUrlWithMetadataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SharedStorageUrlWithMetadataPtr From(const U& u) {
    return mojo::TypeConverter<SharedStorageUrlWithMetadataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SharedStorageUrlWithMetadata>::Convert(*this);
  }


  SharedStorageUrlWithMetadata();

  SharedStorageUrlWithMetadata(
      const ::blink::KURL& url,
      const ::blink::HashMap<::blink::String, ::blink::KURL>& reporting_metadata);


  ~SharedStorageUrlWithMetadata();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SharedStorageUrlWithMetadataPtr>
  SharedStorageUrlWithMetadataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SharedStorageUrlWithMetadata::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SharedStorageUrlWithMetadata::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SharedStorageUrlWithMetadata::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SharedStorageUrlWithMetadata::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SharedStorageUrlWithMetadata::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SharedStorageUrlWithMetadata::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SharedStorageUrlWithMetadata_UnserializedMessageContext<
            UserType, SharedStorageUrlWithMetadata::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SharedStorageUrlWithMetadata::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SharedStorageUrlWithMetadata::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SharedStorageUrlWithMetadata_UnserializedMessageContext<
            UserType, SharedStorageUrlWithMetadata::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SharedStorageUrlWithMetadata::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::KURL url;
  
  ::blink::HashMap<::blink::String, ::blink::KURL> reporting_metadata;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SharedStorageUrlWithMetadata::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SharedStorageUrlWithMetadata::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SharedStorageUrlWithMetadata::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SharedStorageUrlWithMetadata::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class MODULES_EXPORT PrivateAggregationConfig {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PrivateAggregationConfig, T>::value>;
  using DataView = PrivateAggregationConfigDataView;
  using Data_ = internal::PrivateAggregationConfig_Data;

  template <typename... Args>
  static PrivateAggregationConfigPtr New(Args&&... args) {
    return PrivateAggregationConfigPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PrivateAggregationConfigPtr From(const U& u) {
    return mojo::TypeConverter<PrivateAggregationConfigPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PrivateAggregationConfig>::Convert(*this);
  }


  PrivateAggregationConfig();

  PrivateAggregationConfig(
      const ::scoped_refptr<const ::blink::SecurityOrigin>& aggregation_coordinator_origin,
      const ::blink::String& context_id,
      uint32_t filtering_id_max_bytes,
      std::optional<uint16_t> max_contributions);


  ~PrivateAggregationConfig();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PrivateAggregationConfigPtr>
  PrivateAggregationConfigPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PrivateAggregationConfig::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PrivateAggregationConfig::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PrivateAggregationConfig::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PrivateAggregationConfig::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PrivateAggregationConfig::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PrivateAggregationConfig::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PrivateAggregationConfig_UnserializedMessageContext<
            UserType, PrivateAggregationConfig::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PrivateAggregationConfig::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PrivateAggregationConfig::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PrivateAggregationConfig_UnserializedMessageContext<
            UserType, PrivateAggregationConfig::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PrivateAggregationConfig::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::scoped_refptr<const ::blink::SecurityOrigin> aggregation_coordinator_origin;
  
  ::blink::String context_id;
  
  uint32_t filtering_id_max_bytes;
  
  std::optional<uint16_t> max_contributions;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PrivateAggregationConfig::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PrivateAggregationConfig::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PrivateAggregationConfig::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PrivateAggregationConfig::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
SharedStorageUrlWithMetadataPtr SharedStorageUrlWithMetadata::Clone() const {
  return New(
      mojo::Clone(url),
      mojo::Clone(reporting_metadata)
  );
}

template <typename T, SharedStorageUrlWithMetadata::EnableIfSame<T>*>
bool SharedStorageUrlWithMetadata::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->reporting_metadata, other_struct.reporting_metadata))
    return false;
  return true;
}

template <typename T, SharedStorageUrlWithMetadata::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.reporting_metadata < rhs.reporting_metadata)
    return true;
  if (rhs.reporting_metadata < lhs.reporting_metadata)
    return false;
  return false;
}
template <typename StructPtrType>
PrivateAggregationConfigPtr PrivateAggregationConfig::Clone() const {
  return New(
      mojo::Clone(aggregation_coordinator_origin),
      mojo::Clone(context_id),
      mojo::Clone(filtering_id_max_bytes),
      mojo::Clone(max_contributions)
  );
}

template <typename T, PrivateAggregationConfig::EnableIfSame<T>*>
bool PrivateAggregationConfig::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->aggregation_coordinator_origin, other_struct.aggregation_coordinator_origin))
    return false;
  if (!mojo::Equals(this->context_id, other_struct.context_id))
    return false;
  if (!mojo::Equals(this->filtering_id_max_bytes, other_struct.filtering_id_max_bytes))
    return false;
  if (!mojo::Equals(this->max_contributions, other_struct.max_contributions))
    return false;
  return true;
}

template <typename T, PrivateAggregationConfig::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.aggregation_coordinator_origin < rhs.aggregation_coordinator_origin)
    return true;
  if (rhs.aggregation_coordinator_origin < lhs.aggregation_coordinator_origin)
    return false;
  if (lhs.context_id < rhs.context_id)
    return true;
  if (rhs.context_id < lhs.context_id)
    return false;
  if (lhs.filtering_id_max_bytes < rhs.filtering_id_max_bytes)
    return true;
  if (rhs.filtering_id_max_bytes < lhs.filtering_id_max_bytes)
    return false;
  if (lhs.max_contributions < rhs.max_contributions)
    return true;
  if (rhs.max_contributions < lhs.max_contributions)
    return false;
  return false;
}


}  // blink::mojom::blink

namespace mojo {


template <>
struct MODULES_EXPORT StructTraits<::blink::mojom::blink::SharedStorageUrlWithMetadata::DataView,
                                         ::blink::mojom::blink::SharedStorageUrlWithMetadataPtr> {
  static bool IsNull(const ::blink::mojom::blink::SharedStorageUrlWithMetadataPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::SharedStorageUrlWithMetadataPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::SharedStorageUrlWithMetadata::url)& url(
      const ::blink::mojom::blink::SharedStorageUrlWithMetadataPtr& input) {
    return input->url;
  }

  static const decltype(::blink::mojom::blink::SharedStorageUrlWithMetadata::reporting_metadata)& reporting_metadata(
      const ::blink::mojom::blink::SharedStorageUrlWithMetadataPtr& input) {
    return input->reporting_metadata;
  }

  static bool Read(::blink::mojom::blink::SharedStorageUrlWithMetadata::DataView input, ::blink::mojom::blink::SharedStorageUrlWithMetadataPtr* output);
};


template <>
struct MODULES_EXPORT StructTraits<::blink::mojom::blink::PrivateAggregationConfig::DataView,
                                         ::blink::mojom::blink::PrivateAggregationConfigPtr> {
  static bool IsNull(const ::blink::mojom::blink::PrivateAggregationConfigPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::PrivateAggregationConfigPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::PrivateAggregationConfig::aggregation_coordinator_origin)& aggregation_coordinator_origin(
      const ::blink::mojom::blink::PrivateAggregationConfigPtr& input) {
    return input->aggregation_coordinator_origin;
  }

  static const decltype(::blink::mojom::blink::PrivateAggregationConfig::context_id)& context_id(
      const ::blink::mojom::blink::PrivateAggregationConfigPtr& input) {
    return input->context_id;
  }

  static decltype(::blink::mojom::blink::PrivateAggregationConfig::filtering_id_max_bytes) filtering_id_max_bytes(
      const ::blink::mojom::blink::PrivateAggregationConfigPtr& input) {
    return input->filtering_id_max_bytes;
  }

  static decltype(::blink::mojom::blink::PrivateAggregationConfig::max_contributions) max_contributions(
      const ::blink::mojom::blink::PrivateAggregationConfigPtr& input) {
    return input->max_contributions;
  }

  static bool Read(::blink::mojom::blink::PrivateAggregationConfig::DataView input, ::blink::mojom::blink::PrivateAggregationConfigPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_SHARED_STORAGE_SHARED_STORAGE_MOJOM_BLINK_H_