// ui/gfx/mojom/buffer_types.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_GFX_MOJOM_BUFFER_TYPES_MOJOM_H_
#define UI_GFX_MOJOM_BUFFER_TYPES_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/gfx/mojom/buffer_types.mojom-features.h"  // IWYU pragma: export
#include "ui/gfx/mojom/buffer_types.mojom-shared.h"  // IWYU pragma: export
#include "ui/gfx/mojom/buffer_types.mojom-forward.h"  // IWYU pragma: export
#include "ui/gfx/mojom/native_handle_types.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "ui/gfx/mojom/buffer_types_mojom_traits.h"




namespace gfx::mojom {





class  BufferUsageAndFormat {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BufferUsageAndFormat, T>::value>;
  using DataView = BufferUsageAndFormatDataView;
  using Data_ = internal::BufferUsageAndFormat_Data;

  template <typename... Args>
  static BufferUsageAndFormatPtr New(Args&&... args) {
    return BufferUsageAndFormatPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BufferUsageAndFormatPtr From(const U& u) {
    return mojo::TypeConverter<BufferUsageAndFormatPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BufferUsageAndFormat>::Convert(*this);
  }


  BufferUsageAndFormat();

  BufferUsageAndFormat(
      ::gfx::BufferUsage usage,
      ::gfx::BufferFormat format);


  ~BufferUsageAndFormat();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BufferUsageAndFormatPtr>
  BufferUsageAndFormatPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BufferUsageAndFormat::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, BufferUsageAndFormat::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, BufferUsageAndFormat::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BufferUsageAndFormat::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BufferUsageAndFormat::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BufferUsageAndFormat::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BufferUsageAndFormat_UnserializedMessageContext<
            UserType, BufferUsageAndFormat::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<BufferUsageAndFormat::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return BufferUsageAndFormat::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BufferUsageAndFormat_UnserializedMessageContext<
            UserType, BufferUsageAndFormat::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BufferUsageAndFormat::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::gfx::BufferUsage usage;
  
  ::gfx::BufferFormat format;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BufferUsageAndFormat::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BufferUsageAndFormat::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BufferUsageAndFormat::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BufferUsageAndFormat::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  GpuMemoryBufferId {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<GpuMemoryBufferId, T>::value>;
  using DataView = GpuMemoryBufferIdDataView;
  using Data_ = internal::GpuMemoryBufferId_Data;

  template <typename... Args>
  static GpuMemoryBufferIdPtr New(Args&&... args) {
    return GpuMemoryBufferIdPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static GpuMemoryBufferIdPtr From(const U& u) {
    return mojo::TypeConverter<GpuMemoryBufferIdPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, GpuMemoryBufferId>::Convert(*this);
  }


  GpuMemoryBufferId();

  explicit GpuMemoryBufferId(
      int32_t id);


  ~GpuMemoryBufferId();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = GpuMemoryBufferIdPtr>
  GpuMemoryBufferIdPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, GpuMemoryBufferId::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, GpuMemoryBufferId::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, GpuMemoryBufferId::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GpuMemoryBufferId::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GpuMemoryBufferId::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        GpuMemoryBufferId::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::GpuMemoryBufferId_UnserializedMessageContext<
            UserType, GpuMemoryBufferId::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<GpuMemoryBufferId::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return GpuMemoryBufferId::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::GpuMemoryBufferId_UnserializedMessageContext<
            UserType, GpuMemoryBufferId::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<GpuMemoryBufferId::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, GpuMemoryBufferId::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, GpuMemoryBufferId::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, GpuMemoryBufferId::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, GpuMemoryBufferId::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}










class  GpuMemoryBufferHandle {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<GpuMemoryBufferHandle, T>::value>;
  using DataView = GpuMemoryBufferHandleDataView;
  using Data_ = internal::GpuMemoryBufferHandle_Data;

  template <typename... Args>
  static GpuMemoryBufferHandlePtr New(Args&&... args) {
    return GpuMemoryBufferHandlePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static GpuMemoryBufferHandlePtr From(const U& u) {
    return mojo::TypeConverter<GpuMemoryBufferHandlePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, GpuMemoryBufferHandle>::Convert(*this);
  }


  GpuMemoryBufferHandle();

  GpuMemoryBufferHandle(
      uint32_t offset,
      uint32_t stride,
      ::gfx::GpuMemoryBufferHandle platform_handle);

GpuMemoryBufferHandle(const GpuMemoryBufferHandle&) = delete;
GpuMemoryBufferHandle& operator=(const GpuMemoryBufferHandle&) = delete;

  ~GpuMemoryBufferHandle();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = GpuMemoryBufferHandlePtr>
  GpuMemoryBufferHandlePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, GpuMemoryBufferHandle::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, GpuMemoryBufferHandle::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, GpuMemoryBufferHandle::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        GpuMemoryBufferHandle::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::GpuMemoryBufferHandle_UnserializedMessageContext<
            UserType, GpuMemoryBufferHandle::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<GpuMemoryBufferHandle::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return GpuMemoryBufferHandle::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::GpuMemoryBufferHandle_UnserializedMessageContext<
            UserType, GpuMemoryBufferHandle::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<GpuMemoryBufferHandle::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t offset;
  
  uint32_t stride;
  
  ::gfx::GpuMemoryBufferHandle platform_handle;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, GpuMemoryBufferHandle::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, GpuMemoryBufferHandle::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, GpuMemoryBufferHandle::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, GpuMemoryBufferHandle::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
BufferUsageAndFormatPtr BufferUsageAndFormat::Clone() const {
  return New(
      mojo::Clone(usage),
      mojo::Clone(format)
  );
}

template <typename T, BufferUsageAndFormat::EnableIfSame<T>*>
bool BufferUsageAndFormat::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->usage, other_struct.usage))
    return false;
  if (!mojo::Equals(this->format, other_struct.format))
    return false;
  return true;
}

template <typename T, BufferUsageAndFormat::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.usage < rhs.usage)
    return true;
  if (rhs.usage < lhs.usage)
    return false;
  if (lhs.format < rhs.format)
    return true;
  if (rhs.format < lhs.format)
    return false;
  return false;
}
template <typename StructPtrType>
GpuMemoryBufferIdPtr GpuMemoryBufferId::Clone() const {
  return New(
      mojo::Clone(id)
  );
}

template <typename T, GpuMemoryBufferId::EnableIfSame<T>*>
bool GpuMemoryBufferId::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  return true;
}

template <typename T, GpuMemoryBufferId::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  return false;
}
template <typename StructPtrType>
GpuMemoryBufferHandlePtr GpuMemoryBufferHandle::Clone() const {
  return New(
      mojo::Clone(offset),
      mojo::Clone(stride),
      mojo::Clone(platform_handle)
  );
}

template <typename T, GpuMemoryBufferHandle::EnableIfSame<T>*>
bool GpuMemoryBufferHandle::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->offset, other_struct.offset))
    return false;
  if (!mojo::Equals(this->stride, other_struct.stride))
    return false;
  if (!mojo::Equals(this->platform_handle, other_struct.platform_handle))
    return false;
  return true;
}

template <typename T, GpuMemoryBufferHandle::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.offset < rhs.offset)
    return true;
  if (rhs.offset < lhs.offset)
    return false;
  if (lhs.stride < rhs.stride)
    return true;
  if (rhs.stride < lhs.stride)
    return false;
  if (lhs.platform_handle < rhs.platform_handle)
    return true;
  if (rhs.platform_handle < lhs.platform_handle)
    return false;
  return false;
}


}  // gfx::mojom

namespace mojo {


template <>
struct  StructTraits<::gfx::mojom::BufferUsageAndFormat::DataView,
                                         ::gfx::mojom::BufferUsageAndFormatPtr> {
  static bool IsNull(const ::gfx::mojom::BufferUsageAndFormatPtr& input) { return !input; }
  static void SetToNull(::gfx::mojom::BufferUsageAndFormatPtr* output) { output->reset(); }

  static decltype(::gfx::mojom::BufferUsageAndFormat::usage) usage(
      const ::gfx::mojom::BufferUsageAndFormatPtr& input) {
    return input->usage;
  }

  static decltype(::gfx::mojom::BufferUsageAndFormat::format) format(
      const ::gfx::mojom::BufferUsageAndFormatPtr& input) {
    return input->format;
  }

  static bool Read(::gfx::mojom::BufferUsageAndFormat::DataView input, ::gfx::mojom::BufferUsageAndFormatPtr* output);
};


template <>
struct  StructTraits<::gfx::mojom::GpuMemoryBufferId::DataView,
                                         ::gfx::mojom::GpuMemoryBufferIdPtr> {
  static bool IsNull(const ::gfx::mojom::GpuMemoryBufferIdPtr& input) { return !input; }
  static void SetToNull(::gfx::mojom::GpuMemoryBufferIdPtr* output) { output->reset(); }

  static decltype(::gfx::mojom::GpuMemoryBufferId::id) id(
      const ::gfx::mojom::GpuMemoryBufferIdPtr& input) {
    return input->id;
  }

  static bool Read(::gfx::mojom::GpuMemoryBufferId::DataView input, ::gfx::mojom::GpuMemoryBufferIdPtr* output);
};


template <>
struct  StructTraits<::gfx::mojom::GpuMemoryBufferHandle::DataView,
                                         ::gfx::mojom::GpuMemoryBufferHandlePtr> {
  static bool IsNull(const ::gfx::mojom::GpuMemoryBufferHandlePtr& input) { return !input; }
  static void SetToNull(::gfx::mojom::GpuMemoryBufferHandlePtr* output) { output->reset(); }

  static decltype(::gfx::mojom::GpuMemoryBufferHandle::offset) offset(
      const ::gfx::mojom::GpuMemoryBufferHandlePtr& input) {
    return input->offset;
  }

  static decltype(::gfx::mojom::GpuMemoryBufferHandle::stride) stride(
      const ::gfx::mojom::GpuMemoryBufferHandlePtr& input) {
    return input->stride;
  }

  static  decltype(::gfx::mojom::GpuMemoryBufferHandle::platform_handle)& platform_handle(
       ::gfx::mojom::GpuMemoryBufferHandlePtr& input) {
    return input->platform_handle;
  }

  static bool Read(::gfx::mojom::GpuMemoryBufferHandle::DataView input, ::gfx::mojom::GpuMemoryBufferHandlePtr* output);
};

}  // namespace mojo

#endif  // UI_GFX_MOJOM_BUFFER_TYPES_MOJOM_H_