// ui/gfx/mojom/gpu_extra_info.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_GFX_MOJOM_GPU_EXTRA_INFO_MOJOM_DATA_VIEW_H_
#define UI_GFX_MOJOM_GPU_EXTRA_INFO_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "ui/gfx/mojom/gpu_extra_info.mojom-shared-internal.h"
#include "ui/gfx/mojom/buffer_types.mojom-shared.h"


namespace gfx::mojom {
class ANGLEFeatureDataView;

class GpuExtraInfoDataView;



}  // gfx::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::gfx::mojom::ANGLEFeatureDataView> {
  using Data = ::gfx::mojom::internal::ANGLEFeature_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gfx::mojom::GpuExtraInfoDataView> {
  using Data = ::gfx::mojom::internal::GpuExtraInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace gfx::mojom {


class ANGLEFeatureDataView {
 public:
  ANGLEFeatureDataView() = default;

  ANGLEFeatureDataView(
      internal::ANGLEFeature_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetCategoryDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCategory(UserType* output) {
    
    auto* pointer = data_->category.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetStatusDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStatus(UserType* output) {
    
    auto* pointer = data_->status.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::ANGLEFeature_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class GpuExtraInfoDataView {
 public:
  GpuExtraInfoDataView() = default;

  GpuExtraInfoDataView(
      internal::GpuExtraInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetAngleFeaturesDataView(
      mojo::ArrayDataView<ANGLEFeatureDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAngleFeatures(UserType* output) {
    
    auto* pointer = data_->angle_features.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::gfx::mojom::ANGLEFeatureDataView>>(
        pointer, output, message_);
  }
  inline void GetGpuMemoryBufferSupportX11DataView(
      mojo::ArrayDataView<::gfx::mojom::BufferUsageAndFormatDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGpuMemoryBufferSupportX11(UserType* output) {
    
    auto* pointer = data_->gpu_memory_buffer_support_x11.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::gfx::mojom::BufferUsageAndFormatDataView>>(
        pointer, output, message_);
  }
 private:
  internal::GpuExtraInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // gfx::mojom

#endif  // UI_GFX_MOJOM_GPU_EXTRA_INFO_MOJOM_DATA_VIEW_H_