// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_TEST_CHROMEDRIVER_CHROME_LAUNCHER_H_
#define CHROME_TEST_CHROMEDRIVER_CHROME_LAUNCHER_H_

#include <memory>
#include <string>
#include <vector>

#include "base/files/file_path.h"
#include "base/process/kill.h"
#include "base/values.h"
#include "chrome/test/chromedriver/capabilities.h"
#include "chrome/test/chromedriver/net/sync_websocket_factory.h"

class DevToolsEventListener;

namespace base {
class FilePath;
enum TerminationStatus : int;
}  // namespace base

namespace network::mojom {
class URLLoaderFactory;
}  // namespace network::mojom

class Chrome;
class DeviceManager;
class Status;

Switches GetDesktopSwitches();

Status LaunchChrome(network::mojom::URLLoaderFactory* factory,
                    const SyncWebSocketFactory& socket_factory,
                    DeviceManager& device_manager,
                    const Capabilities& capabilities,
                    std::vector<std::unique_ptr<DevToolsEventListener>>
                        devtools_event_listeners,
                    base::RepeatingClosure on_socket_message,
                    bool w3c_compliant,
                    std::unique_ptr<Chrome>& chrome);

namespace internal {
Status ProcessExtensions(const std::vector<std::string>& extensions,
                         const base::FilePath& temp_dir,
                         Switches& switches,
                         std::vector<std::string>& bg_pages);
Status PrepareUserDataDir(const base::FilePath& user_data_dir,
                          const base::Value::Dict* custom_prefs,
                          const base::Value::Dict* custom_local_state);
Status ParseDevToolsActivePortFile(const base::FilePath& user_data_dir,
                                   int& port);
Status RemoveOldDevToolsActivePortFile(const base::FilePath& user_data_dir);
std::string GetTerminationReason(base::TerminationStatus status);
}  // namespace internal

#endif  // CHROME_TEST_CHROMEDRIVER_CHROME_LAUNCHER_H_
